/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.provider.DIImportDataFactory;
import kd.fi.bcm.business.integration.di.service.DIDataHandleFactory;
import kd.fi.bcm.business.integration.di.service.DIDataQueryFactory;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4SchemeService;
import kd.fi.bcm.business.integration.di.service.DIIntegrateDispatcher2;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.service.IntegrationNewServiceHelper;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.di.DIOlapDescEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.di.utils.DIUserSelectUtil;

public class DIExecuteDetailPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIExecuteDetailPlugin.class);
    private static final String BTN_LOOK = "btn_look";
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_TURN = "btn_turn";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_LINK = "btn_link";
    public static final String CURSTEP = "curStep";
    public static final String STEP1 = "step1";
    public static final String STEP2 = "step2";
    public static final String STEP3 = "step3";
    private static final String DI_CATALOG_TYPE = "2";
    private static final String SCHEME = "scheme";
    public static final String EXECUTEID = "executeId";
    public static final String EXTENDSTABLE = "extendstable";
    public static final String EXTENDSTABLE_CP = "extendstable_cp";
    public static final String COLUMNNAMES = "columnNames";
    public static final String MONEY_ATTR = "money_attr";
    private static final String TEXT_ATTR = "text_attr";
    private static final String FILED_SOURCE = "_s";
    private static final String FILED_TARGET = "_t";
    private static final String FILED_SUM = "_sum";
    public static final String NAMELABLE = "nameLable";
    public static final String ISSRC = "isSrc";
    public static final String OTHERFILTER = "otherFilter";
    public static final String OTHERFILTER_CONDITION = " and fidnew = ftraceid ";
    private static final String IMPORT_TAB = "tabpageap";
    private static final String TURN_TAB = "tabpageap1";
    private static final String EXPORT_TAB = "tabpageap2";
    private static final String REPORTFILTERAP = "reportfilterap";
    private static final String TABAP = "tabap";
    private static final String DEFAULT_PK = "fexecuteid";
    public static final String FROM_LINK = "fromLink";
    private static final String IS_FIRST_SEARCH = "isFirstSearch";
    private static final String EXT_FIELD_TYPE_SET = "extFieldTypeSet";
    private static final String EXT_FIELD_PRE_MARK = "$src$";
    public static final String FIELD_TYPE_MAP = "fieldTypeMap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl(SCHEME);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entity = (BasedataEdit)this.getControl("entity");
        entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scene = (BasedataEdit)this.getControl("scenario");
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit year = (BasedataEdit)this.getControl("year");
        year.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cslScheme = (BasedataEdit)this.getControl("cslscheme");
        cslScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab bizTab = (Tab)this.getControl(TABAP);
        bizTab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{REPORTFILTERAP});
        this.getPageCache().put(CURSTEP, this.getCurStepByShowParam());
        if (!this.fillUserSelect()) {
            this.getPageCache().put(IS_FIRST_SEARCH, "1");
        }
        this.doSearch();
    }

    private String getCurStepByShowParam() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long linkId = (Long)formShowParameter.getCustomParam("linkId");
        String curStep = STEP1;
        if (linkId != null) {
            curStep = STEP2;
            String linkFilter = " and ftraceid = " + linkId;
            this.getPageCache().put(FROM_LINK, "1");
            this.getPageCache().put(OTHERFILTER, linkFilter);
            this.activeTab(TURN_TAB);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_IMPORT, BTN_TURN, BTN_EXPORT});
        }
        return curStep;
    }

    private void doSearch() {
        ReportFilter rf = (ReportFilter)this.getControl(REPORTFILTERAP);
        rf.search();
    }

    public void packageData(PackageDataEvent e) {
        ReportColumn rc = (ReportColumn)e.getSource();
        if ("fdatafrom".equals(rc.getFieldKey())) {
            String data = (String)e.getFormatValue();
            e.setFormatValue((Object)("0".equals(data) ? ResManager.loadKDString((String)"\u5bfc\u5165", (String)"IDIDataQueryService_2", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u89c4\u5219", (String)"IDIDataQueryService_3", (String)"fi-bcm-business", (Object[])new Object[0])));
        } else if ("fmatchingstatus".equals(rc.getFieldKey())) {
            String data = (String)e.getFormatValue();
            e.setFormatValue((Object)("1".equals(data) ? ResManager.loadKDString((String)"\u6210\u529f", (String)"BizRuleConstant_10", (String)"fi-bcm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"BizRuleConstant_11", (String)"fi-bcm-common", (Object[])new Object[0])));
        } else if ("folapstatus".equals(rc.getFieldKey())) {
            String data = (String)e.getFormatValue();
            e.setFormatValue((Object)("1".equals(data) ? ResManager.loadKDString((String)"\u662f", (String)"IDIDataQueryService_4", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"IDIDataQueryService_5", (String)"fi-bcm-business", (Object[])new Object[0])));
        } else if ("fmsg".equals(rc.getFieldKey())) {
            String data = (String)e.getFormatValue();
            e.setFormatValue((Object)(StringUtils.isEmpty((CharSequence)DIOlapDescEnum.getNameByIndex((String)data)) ? data : DIOlapDescEnum.getNameByIndex((String)data)));
        }
    }

    public static Set<String> getMoneyAttrSet(String moneyStr) {
        HashSet<String> moneyAttrSet = new HashSet<String>(3);
        moneyAttrSet.add("f" + moneyStr);
        moneyAttrSet.add("f" + moneyStr + FILED_SOURCE);
        moneyAttrSet.add("f" + moneyStr + FILED_SUM + FILED_SOURCE);
        return moneyAttrSet;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        if (this.getPageCache().get(IS_FIRST_SEARCH) != null) {
            this.getPageCache().put(IS_FIRST_SEARCH, null);
            return;
        }
        String executeId = this.getPageCache().get(EXECUTEID);
        Map customParam = queryParam.getCustomParam();
        customParam.put(EXECUTEID, executeId);
        if (executeId == null) {
            return;
        }
        String extendstable_cp = this.getPageCache().get(EXTENDSTABLE_CP);
        String extendstable = this.getPageCache().get(EXTENDSTABLE);
        if (StringUtils.isEmpty((CharSequence)extendstable)) {
            return;
        }
        DynamicObject scheme = this.getScheme();
        String singlemetric = scheme.getString("singlemetric");
        String textfield = scheme.getString("textfield");
        this.getPageCache().put(MONEY_ATTR, singlemetric);
        this.getPageCache().put(TEXT_ATTR, textfield);
        customParam.put(MONEY_ATTR, singlemetric);
        String isSrc = this.getSchemeSrc(scheme);
        customParam.put(ISSRC, isSrc);
        String curStep = this.getPageCache().get(CURSTEP);
        customParam.put(CURSTEP, curStep);
        customParam.put(EXTENDSTABLE_CP, extendstable_cp);
        customParam.put(EXTENDSTABLE, extendstable);
        String tableName = extendstable_cp;
        if (STEP1.equals(curStep)) {
            tableName = extendstable;
        }
        List columnNames = DIDataQueryFactory.getDataQueryService((String)isSrc).getColumnNames(curStep, Long.valueOf(Long.parseLong(executeId)), tableName);
        customParam.put(COLUMNNAMES, columnNames);
        Map<String, String> fieldTypeMap = this.getFildTypeMap();
        customParam.put(FIELD_TYPE_MAP, fieldTypeMap);
        Set<String> extFieldTypeSet = this.getExtFieldTypeSet(scheme, isSrc);
        customParam.put(EXT_FIELD_TYPE_SET, extFieldTypeSet);
        Map<String, String> nameLable = this.initNameLable(scheme.getLong("id"), isSrc, extFieldTypeSet);
        customParam.put(NAMELABLE, nameLable);
        customParam.put(OTHERFILTER, this.getPageCache().get(OTHERFILTER));
    }

    private Set<String> getExtFieldTypeSet(DynamicObject scheme, String isSrc) {
        String cacheKey = EXT_FIELD_TYPE_SET + scheme.getLong("id");
        String typeSetStr = this.getPageCache().get(cacheKey);
        if (typeSetStr != null) {
            return (Set)JSONObject.parseObject((String)typeSetStr, Set.class);
        }
        HashSet<String> extFieldTypeSet = new HashSet<String>(16);
        if (!DIExecuteDetailPlugin.isExtDi(isSrc)) {
            this.getPageCache().put(cacheKey, JSONObject.toJSONString(extFieldTypeSet));
            return extFieldTypeSet;
        }
        DIExtendDim4SchemeService des = new DIExtendDim4SchemeService(scheme);
        des.getFieldNumber2Name_DT_ID().forEach((key, value) -> {
            if (String.valueOf(DataTypeEnum.DEFAULT.getCode()).equals(value.p2) || String.valueOf(DataTypeEnum.UNCURRENCY.getCode()).equals(value.p2)) {
                extFieldTypeSet.add(key.toLowerCase());
            }
        });
        this.getPageCache().put(cacheKey, JSONObject.toJSONString(extFieldTypeSet));
        return extFieldTypeSet;
    }

    private Map<String, String> initNameLable(Long schemeId, String isSrc, Set<String> extFieldTypeSet) {
        HashMap<String, String> nameLableMap = new HashMap<String, String>(16);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)"number, name", (QFilter[])new QFilter[]{new QFilter(SCHEME, "=", (Object)schemeId)});
        String preStr = "f";
        for (DynamicObject obj : load) {
            nameLableMap.put(preStr + obj.getString("number"), obj.getString("name"));
            nameLableMap.put(preStr + obj.getString("number") + FILED_SOURCE, String.format(ResManager.loadKDString((String)"%s_\u6e90", (String)"DIDataHandleService_2", (String)"fi-bcm-business", (Object[])new Object[0]), obj.getString("name")));
        }
        Map dimMap = MemberReader.getDimNumberMapNameById((long)Long.parseLong(this.getPageCache().get("model")));
        for (Map.Entry map : dimMap.entrySet()) {
            nameLableMap.put(preStr + ((String)map.getKey()).toLowerCase() + FILED_TARGET, String.format(ResManager.loadKDString((String)"%s_\u76ee\u6807", (String)"DIDataHandleService_3", (String)"fi-bcm-business", (Object[])new Object[0]), map.getValue()));
        }
        nameLableMap.put("f" + this.getPageCache().get(MONEY_ATTR) + FILED_SOURCE, ResManager.loadKDString((String)"\u5ea6\u91cf\u6570\u503c", (String)"DIDataHandleService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("f" + this.getPageCache().get(MONEY_ATTR), ResManager.loadKDString((String)"\u5ea6\u91cf\u6570\u503c", (String)"DIDataHandleService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("f" + this.getPageCache().get(TEXT_ATTR) + FILED_SOURCE, ResManager.loadKDString((String)"\u5ea6\u91cf\u6587\u672c", (String)"DIDataHandleService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("f" + this.getPageCache().get(TEXT_ATTR), ResManager.loadKDString((String)"\u5ea6\u91cf\u6587\u672c", (String)"DIDataHandleService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("f" + this.getPageCache().get(MONEY_ATTR) + FILED_SUM + FILED_SOURCE, ResManager.loadKDString((String)"\u6c47\u603b\u5ea6\u91cf\u6570\u503c", (String)"DIDataHandleService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("f" + this.getPageCache().get(TEXT_ATTR) + FILED_SUM + FILED_SOURCE, ResManager.loadKDString((String)"\u6c47\u603b\u5ea6\u91cf\u6587\u672c", (String)"DIDataHandleService_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("fmatchingstatus", ResManager.loadKDString((String)"\u5339\u914d\u72b6\u6001", (String)"DIDataHandleService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("folapstatus", ResManager.loadKDString((String)"\u5165\u5e93\u72b6\u6001", (String)"DIDataHandleService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("fidnew", ResManager.loadKDString((String)"ID_\u8f6c\u6362", (String)"DIDataHandleService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("fmsg", ResManager.loadKDString((String)"\u5907\u6ce8_\u8f6c\u6362", (String)"DIDataHandleService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        nameLableMap.put("fdatafrom", ResManager.loadKDString((String)"\u6765\u6e90", (String)"DIDataHandleService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.setExtLable(nameLableMap, schemeId, isSrc, extFieldTypeSet);
        return this.nameLableMapToLow(nameLableMap);
    }

    private Map<String, String> nameLableMapToLow(Map<String, String> nameLableMap) {
        HashMap<String, String> resMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> map : nameLableMap.entrySet()) {
            resMap.put(map.getKey().toLowerCase(), map.getValue());
        }
        return resMap;
    }

    private void setExtLable(Map<String, String> nameLableMap, Long schemeId, String isSrc, Set<String> extFieldTypeSet) {
        DynamicObject[] dimMapping;
        if (!DIExecuteDetailPlugin.isExtDi(isSrc)) {
            return;
        }
        QFilter schemeQf = new QFilter(SCHEME, "=", (Object)schemeId);
        for (DynamicObject dynamicObject : dimMapping = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, number, tagdimension, srcdimension, mappedtype", (QFilter[])new QFilter[]{schemeQf})) {
            int mappedtype = dynamicObject.getInt("mappedtype");
            if (mappedtype != 5) continue;
            DynamicObject isdimmaptargentry = (DynamicObject)dynamicObject.getDynamicObjectCollection("isdimmaptargentry").get(0);
            DynamicObject isdimmapsrcentry = (DynamicObject)dynamicObject.getDynamicObjectCollection("isdimmapsrcentry").get(0);
            String srcdimensionNumber = isdimmapsrcentry.getDynamicObject("srcdimension").getString("number");
            String srcdimensionName = isdimmapsrcentry.getDynamicObject("srcdimension").getString("name");
            String tagdimensionNumber = isdimmaptargentry.getDynamicObject("tagdimension").getString("number");
            String tagdimensionName = isdimmaptargentry.getDynamicObject("tagdimension").getString("name");
            nameLableMap.put("__" + srcdimensionNumber + "__" + tagdimensionNumber, srcdimensionName + "_" + tagdimensionName);
            nameLableMap.put(srcdimensionNumber + FILED_SUM, String.format(ResManager.loadKDString((String)"%s_\u6c47\u603b", (String)"DIDataHandleService_14", (String)"fi-bcm-business", (Object[])new Object[0]), srcdimensionName));
            if (!extFieldTypeSet.contains(tagdimensionNumber.toLowerCase())) continue;
            nameLableMap.put("$src$f" + srcdimensionNumber, tagdimensionNumber.toLowerCase());
        }
    }

    private static boolean isExtDi(String isSrc) {
        return IntegrateProductEnum.DIMIDEXProduct.getNumber().equals(isSrc) || IntegrateProductEnum.DIISCEXProduct.getNumber().equals(isSrc);
    }

    private String getSchemeSrc(DynamicObject scheme) {
        return scheme.getDynamicObject("issrc").getString("number");
    }

    private DynamicObject getScheme() {
        Long id = Long.valueOf(this.getPageCache().get(SCHEME));
        return BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"number,name,extendstable,singlemetric,textfield,issrc,extendsmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    private void setParentCache(Long modelId, Long sceneId, Long yearId, String yearNumber, Long periodId, String periodNumber, Long currencyId, Long schemeId, Long entityId, String entityNumber) {
        this.getPageCache().put(SCHEME, schemeId.toString());
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.getPageCache().put("model", modelId.toString());
        this.getPageCache().put("scenario", sceneId.toString());
        this.getPageCache().put("year", yearId.toString());
        this.getPageCache().put("yearNumber", yearNumber);
        this.getPageCache().put("period", periodId.toString());
        this.getPageCache().put("periodNumber", periodNumber);
        this.getPageCache().put("currency", currencyId.toString());
        this.getPageCache().put("entity", entityId.toString());
        this.getPageCache().put("entityNumber", entityNumber);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        Map<String, String> fildTypeMap = this.getFildTypeMap();
        for (SortAndFilterEvent event : allColumns) {
            String columnName = this.getRealColumnName(event.getColumnName());
            if ((fildTypeMap.get(columnName) == null || !fildTypeMap.get(columnName).contains("char")) && !"fmatchingstatus".equals(columnName) && !"folapstatus".equals(columnName)) continue;
            event.setFilter(true);
        }
    }

    private String getRealColumnName(String columnName) {
        String[] split;
        if (columnName.startsWith("__") && (split = columnName.split("__")).length > 2) {
            columnName = "f" + split[1];
        }
        return columnName;
    }

    private Map<String, String> getFildTypeMap() {
        String extendstable = this.getPageCache().get(EXTENDSTABLE);
        HashMap<String, String> fildTypeMap = new HashMap<String, String>();
        this.addFildTypeMap(fildTypeMap, extendstable);
        String extendstable_cp = this.getPageCache().get(EXTENDSTABLE_CP);
        this.addFildTypeMap(fildTypeMap, extendstable_cp);
        return fildTypeMap;
    }

    private void addFildTypeMap(Map<String, String> fildTypeMap, String table) {
        if (table != null) {
            List fieldInfo = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)table);
            fildTypeMap.putAll(fieldInfo.stream().collect(Collectors.toMap(fild -> fild.getFieldName().toLowerCase(), fild -> fild.getDataType().toLowerCase())));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_link": {
                this.linkData();
                break;
            }
            case "btn_look": {
                this.lookData();
                break;
            }
            case "btn_import": {
                this.importData("1");
                break;
            }
            case "btn_turn": {
                this.collect(DIOperationEnum.OpConvert);
                break;
            }
            case "btn_export": {
                this.collect(DIOperationEnum.OpExport);
                break;
            }
            case "refresh": {
                this.actionRefresh();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (e.getSource() instanceof BasedataEdit) {
            BasedataEdit baseData = (BasedataEdit)e.getSource();
            if (SCHEME.equals(baseData.getKey())) {
                this.setSchemeFilter(e);
            } else if ("entity".equals(baseData.getKey())) {
                this.setEntityFilter(e);
            } else if ("scenario".equals(baseData.getKey())) {
                this.setSceneFilter(e);
            } else if ("year".equals(baseData.getKey())) {
                this.setSceneFilter(e);
            } else if ("period".equals(baseData.getKey())) {
                this.setPeriodMemberByRange(e);
            } else if ("cslscheme".equals(baseData.getKey())) {
                this.setSceneFilter(e);
            } else if ("currency".equals(baseData.getKey())) {
                this.setSceneFilter(e);
            } else if ("model".equals(baseData.getKey())) {
                this.setModelFilter(e);
            }
        }
    }

    private void setPeriodMemberByRange(BeforeF7SelectEvent e) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BCMBaseFunction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        if (scenario == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"BCMBaseFunction_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod((long)model.getLong("id"), (long)scenario.getLong("id"));
        if (coll != null && coll.size() > 0) {
            ArrayList list = new ArrayList();
            QFilter filter = new QFilter("model", "=", (Object)model.getLong("id"));
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    list.add(period.getLong("id"));
                }
            });
            filter.and("id", "in", (Object)list.toArray());
            e.getCustomQFilters().add(filter);
        }
    }

    private void setModelFilter(BeforeF7SelectEvent e) {
        IReportView view = this.getView();
        Set superid = MemberPermHelper.getLimitedModelListByUser();
        Set haspermid = BcmFunPermissionHelper.getEffectiveByPermModel((String)view.getEntityId(), (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)view));
        Set perRoleids = BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)view), (String)view.getEntityId(), (String)"47150e89000000ac");
        superid.addAll(haspermid);
        superid.addAll(perRoleids);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter qf = new QFilter("id", "in", (Object)superid);
        qfilters.add(qf);
        e.setCustomQFilters(qfilters);
    }

    private void setSchemeFilter(BeforeF7SelectEvent e) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BCMBaseFunction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        e.getCustomQFilters().add(new QFilter("model", "=", (Object)model.getLong("id")));
        e.getCustomQFilters().add(new QFilter("templatecatalog.type", "=", (Object)DI_CATALOG_TYPE));
        e.getCustomQFilters().add(new QFilter("status", "=", (Object)"1"));
    }

    private void setSceneFilter(BeforeF7SelectEvent e) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BCMBaseFunction_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        e.getCustomQFilters().add(new QFilter("model", "=", (Object)model.getLong("id")));
    }

    private void setEntityFilter(BeforeF7SelectEvent e) {
        DynamicObject cslScheme = (DynamicObject)this.getModel().getValue("cslscheme");
        if (cslScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"DimensionDisplayList_78", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter cslQf = new QFilter("cslscheme", "=", (Object)cslScheme.getLong("id"));
        e.getCustomQFilters().add(cslQf);
    }

    private void actionRefresh() {
        String executeIdStr = this.getPageCache().get(EXECUTEID);
        if (executeIdStr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u3002", (String)"GuideMenuInitializePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long executeId = Long.valueOf(executeIdStr);
        String curStep = this.getPageCache().get(CURSTEP);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(DI_CATALOG_TYPE);
        if (STEP3.equals(curStep) && this.checkExecuting(executeId, statusList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (STEP1.equals(curStep) || STEP2.equals(curStep)) {
            this.getPageCache().put(OTHERFILTER, null);
        } else if (STEP3.equals(curStep)) {
            this.getPageCache().put(OTHERFILTER, OTHERFILTER_CONDITION);
        }
        this.doSearch();
    }

    private void collect(DIOperationEnum operation) {
        if (this.getPageCache().get(EXECUTEID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u3002", (String)"GuideMenuInitializePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long executeId = Long.valueOf(this.getPageCache().get(EXECUTEID));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(DI_CATALOG_TYPE);
        statusList.add("8");
        if (this.checkExecuting(executeId, statusList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u6b63\u5728\u6392\u961f\u6216\u6267\u884c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long schemeId = Long.valueOf(this.getPageCache().get(SCHEME));
        if (this.checkExistDisableScheme(schemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = Long.valueOf(this.getPageCache().get("model"));
        Long yearId = Long.valueOf(this.getPageCache().get("year"));
        Long periodId = Long.valueOf(this.getPageCache().get("period"));
        Long scenarioId = Long.valueOf(this.getPageCache().get("scenario"));
        if (!this.checkPeriodStatus(modelId, scenarioId, yearId, periodId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String tip = operation == DIOperationEnum.OpConvert ? ResManager.loadKDString((String)"\u8f6c\u6362\u4e2d......", (String)"ISImpModeSetPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d......", (String)"ISImpModeSetPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        LocaleString str = new LocaleString(tip);
        this.getView().showLoading(str);
        try {
            Long currencyId = Long.valueOf(this.getPageCache().get("currency"));
            Long orgId = Long.valueOf(this.getPageCache().get("entity"));
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode fyMember = MemberReader.findFyMemberById((String)modelNumber, (Long)yearId);
            IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((String)modelNumber, (Long)periodId);
            IDNumberTreeNode currencyMember = MemberReader.findCurrencyMemberById((String)modelNumber, (Long)currencyId);
            IDNumberTreeNode scenMember = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
            IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme", (String)"id,number");
            IntegrateEntity intEntity = new IntegrateEntity();
            intEntity.setModel(modelId, modelNumber);
            intEntity.setScene(scenarioId, scenMember.getNumber());
            intEntity.setYear(yearId, fyMember.getNumber());
            intEntity.setPeriod(periodId, periodMember.getNumber());
            intEntity.setCurrency(currencyId, currencyId == 0L ? "" : currencyMember.getNumber());
            intEntity.putCustomParam("operation", (Object)operation);
            intEntity.putCustomParam(DIContextParam.FIRST_TYPE, (Object)2);
            intEntity.putCustomParam(EXECUTEID, (Object)executeId);
            intEntity.addOrgSchemePair(orgId, entityMember.getNumber(), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
            if (!DIIntegrateDispatcher2.submitTask2((IntegrateEntity)intEntity, (boolean)true)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u5df2\u8fdb\u5165\u540e\u53f0\u6267\u884c\u4e2d\u3002\u8bf7\u67e5\u770b\u5177\u4f53\u65e5\u5fd7\u4ee5\u4e86\u89e3\u6267\u884c\u60c5\u51b5\u3002", (String)"ISSchemeDataCollectPlugin2_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        String s = operation == DIOperationEnum.OpConvert ? ResManager.loadKDString((String)"\u8f6c\u6362\u5b8c\u6210\u3002", (String)"DIExecuteDetailPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u51fa\u5b8c\u6210\u3002", (String)"DIExecuteDetailPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(s);
        if (operation == DIOperationEnum.OpConvert) {
            boolean isCurTab = STEP2.equals(this.getPageCache().get(CURSTEP));
            this.getPageCache().put(CURSTEP, STEP2);
            this.getPageCache().put(OTHERFILTER, null);
            if (isCurTab) {
                this.doSearch();
            }
            this.activeTab(TURN_TAB);
            this.setLookEnable();
        } else {
            boolean isCurTab = STEP3.equals(this.getPageCache().get(CURSTEP));
            this.getPageCache().put(CURSTEP, STEP3);
            this.getPageCache().put(OTHERFILTER, OTHERFILTER_CONDITION);
            if (isCurTab) {
                this.doSearch();
            }
            this.activeTab(EXPORT_TAB);
            this.setLookGrayedOut();
        }
        this.setLinkEnable();
        this.getView().hideLoading();
    }

    protected void importData(String serviceParam) {
        Map result;
        if (this.getPageCache().get(EXECUTEID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\u3002", (String)"GuideMenuInitializePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long executeId = Long.valueOf(this.getPageCache().get(EXECUTEID));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(DI_CATALOG_TYPE);
        statusList.add("8");
        if (this.checkExecuting(executeId, statusList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u6b63\u5728\u6392\u961f\u6216\u6267\u884c\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long schemeId = Long.valueOf(this.getPageCache().get(SCHEME));
        if (this.checkExistDisableScheme(schemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = Long.valueOf(this.getPageCache().get("model"));
        Long yearId = Long.valueOf(this.getPageCache().get("year"));
        Long periodId = Long.valueOf(this.getPageCache().get("period"));
        Long scenarioId = Long.valueOf(this.getPageCache().get("scenario"));
        if (!this.checkPeriodStatus(modelId, scenarioId, yearId, periodId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"DIExecuteDetailPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        long startTime = new Date().getTime();
        LocaleString str = new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d...", (String)"ISImpModeSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showLoading(str);
        Long currencyId = Long.valueOf(this.getPageCache().get("currency"));
        Long orgId = Long.valueOf(this.getPageCache().get("entity"));
        DynamicObject scheme = this.getScheme();
        String issrc = this.getSchemeSrc(scheme);
        try {
            DIDataHandleFactory.getDataHandleService((String)issrc).createPlan(schemeId.longValue(), yearId.longValue(), periodId.longValue());
            result = DIImportDataFactory.getImportDataService((String)issrc).importData(schemeId.longValue(), executeId, modelId, scenarioId.longValue(), yearId, periodId, currencyId, orgId, serviceParam);
        }
        catch (Exception e) {
            String errorMgs = "data import error";
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
                errorMgs = e.getMessage();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DIExecuteDetailPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                errorMgs = ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30);
                log.error("data import error:", (Throwable)e);
            }
            DIExecuteDetailPlugin.writeExecuteLogs(executeId, modelId, yearId, periodId, currencyId, orgId, schemeId, CollectStatusEnum.FAIL.getValue(), errorMgs, startTime, scenarioId);
            this.getView().hideLoading();
            return;
        }
        boolean success = (Boolean)result.get("success");
        if (!success) {
            String errorMgs = "import failed" + result.get("msg");
            DIExecuteDetailPlugin.writeExecuteLogs(executeId, modelId, yearId, periodId, currencyId, orgId, schemeId, CollectStatusEnum.FAIL.getValue(), errorMgs, startTime, scenarioId);
        }
        Integer importCount = (Integer)result.get("import_count");
        Integer deriveCount = (Integer)result.get("derive_count");
        String successLog = ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\u3002", (String)"DIExecuteDetailPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(successLog);
        if (success) {
            DIExecuteDetailPlugin.writeExecuteLogs(executeId, modelId, yearId, periodId, currencyId, orgId, schemeId, CollectStatusEnum.SUCCESS.getValue(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5bfc\u5165\u6570\u636e\uff1a%2$s\uff0c\u89c4\u5219\u6d3e\u751f\u6570\u636e\uff1a%3$s\u3002\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a%4$s", (String)"DIExecuteDetailPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successLog, importCount, deriveCount, result.get("msg")), startTime, scenarioId);
        }
        this.cacheTable(schemeId, this.getPageCache().get("yearNumber"), this.getPageCache().get("periodNumber"));
        boolean isCurTab = STEP1.equals(this.getPageCache().get(CURSTEP));
        this.getPageCache().put(CURSTEP, STEP1);
        this.getPageCache().put(OTHERFILTER, null);
        if (isCurTab) {
            this.doSearch();
        }
        this.activeTab(IMPORT_TAB);
        this.getView().hideLoading();
        this.setLookGrayedOut();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"reportlistap"});
    }

    private boolean checkPeriodStatus(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        HashSet<String> orgnumberset = new HashSet<String>();
        String orgNumber = this.getPageCache().get("entityNumber");
        orgnumberset.add(orgNumber);
        Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)modelId, orgnumberset, (Long)scenarioId, (Long)yearId, (Long)periodId, (String)"datastatus");
        return periodOpenOrgSet.contains(orgNumber);
    }

    private void activeTab(String curTab) {
        Tab bizTab = (Tab)this.getControl(TABAP);
        bizTab.activeTab(curTab);
    }

    private void cacheTable(Long schemeId, String yearNumber, String periodNumber) {
        Pair levelTable = DIIntegrationUtil.getLevelTable((Long)schemeId, (String)yearNumber, (String)periodNumber);
        if (!((Boolean)levelTable.p1).booleanValue()) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u8868\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"DIExecuteDetailPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(EXTENDSTABLE, (String)((Pair)levelTable.p2).p1);
        this.getPageCache().put(EXTENDSTABLE_CP, (String)((Pair)levelTable.p2).p2);
    }

    private boolean checkExistDisableScheme(Long schemeId) {
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId), new QFilter("status", "=", (Object)"0")});
    }

    private static void writeExecuteLogs(long executeId, long modelId, long yearId, long periodId, long currencyId, long orgId, long schemeId, int status, String errorMsg, long startTime, long scenarioId) {
        DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"di_isschemecollectlog");
        dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyObj.set("model", (Object)modelId);
        dyObj.set("fy", (Object)yearId);
        dyObj.set("period", (Object)periodId);
        dyObj.set("scenario", (Object)scenarioId);
        dyObj.set("currency", (Object)currencyId);
        dyObj.set("org", (Object)orgId);
        dyObj.set(SCHEME, (Object)schemeId);
        dyObj.set("importmode", (Object)ISImportModeUtil.getImportModeBySchemeDI((Long)schemeId));
        dyObj.set("error", (Object)errorMsg);
        dyObj.set("result", (Object)" ");
        dyObj.set("collector", (Object)RequestContext.get().getCurrUserId());
        dyObj.set("collectorstate", (Object)status);
        dyObj.set("collecttime", (Object)TimeServiceHelper.now());
        dyObj.set("executerec", (Object)executeId);
        dyObj.set("step", (Object)"C");
        long spend = new Date().getTime() - startTime;
        StringBuilder sb = IntegrationNewServiceHelper.calculate((Long)spend);
        dyObj.set("spend", (Object)sb.toString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
    }

    private boolean checkExecuting(Long executeId, List<String> status) {
        QFBuilder filters = new QFBuilder();
        filters.add("id", "=", (Object)executeId);
        filters.add("collectstatus", "in", status);
        return QueryServiceHelper.exists((String)"bcm_isschemeexecuterec", (QFilter[])filters.toArray());
    }

    private void lookData() {
        String curStep = this.getPageCache().get(CURSTEP);
        if (!STEP2.equals(curStep)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DIExecuteDetailPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        int[] rows = reportList.getEntryState().getSelectedRows();
        if (rows.length == 0 || rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DIExecuteDetailPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
        String idStr = (String)rowData.get("fidnew");
        String executeId = this.getView().getPageCache().get(EXECUTEID);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("di_mappingdetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("exeid", (Object)executeId);
        formShowParameter.setCustomParam("matchdataid", (Object)idStr);
        formShowParameter.setCustomParam("schemeid", this.getView().getFormShowParameter().getCustomParam("schemeId"));
        formShowParameter.setCustomParam("modelid", this.getView().getFormShowParameter().getCustomParam("modelId"));
        this.getView().showForm(formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (this.needSetExeId(name) && this.checkNumberMapping(name)) {
            this.setExeIdFromPropertyChanged();
        }
    }

    private boolean checkNumberMapping(String name) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(name);
        if (obj == null) {
            if (!"currency".equals(name)) {
                this.getView().getPageCache().put(EXECUTEID, null);
                return false;
            }
            return true;
        }
        if (!("scenario".equals(name) || "entity".equals(name) || "year".equals(name) || "period".equals(name) || "currency".equals(name))) {
            return true;
        }
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u3002", (String)"DIExecuteDetailPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(name, null);
            return false;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.add(scheme.getLong("id"));
        long modelId = model.getLong("id");
        if ("entity".equals(name)) {
            obj = (DynamicObject)this.getModel().getValue("entity");
            Set assIds = DIIntegrationUtil.filterSchemeAssignOrg((Long)modelId, ids, (String)obj.getString("number"));
            if (assIds.size() == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u5206\u914d\u7ed9\u5f53\u524d\u65b9\u6848\u3002", (String)"DIExecuteDetailPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name")));
                this.getModel().setValue(name, null);
                return false;
            }
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimEntityNumEnum.ENTITY.getNumber());
            ArrayList<Long> memList = new ArrayList<Long>();
            memList.add(obj.getLong("id"));
            if (!PermissionServiceImpl.getInstance((Long)modelId).isAllWritePerm(dimensionId, "bcm_entitymembertree", memList)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u8bfb\u5199\u6743\u9650\u3002", (String)"DIExecuteDetailPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("name")));
                this.getModel().setValue(name, null);
                return false;
            }
        }
        return this.checkNumberMappingByNumber(name, modelId, obj, ids);
    }

    private Boolean checkNumberMappingByNumber(String entityNumber, long modelId, DynamicObject obj, List<Long> ids) {
        if (obj == null) {
            return false;
        }
        String number = obj.getString("number");
        String name = obj.getString("name");
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)this.getRealDimenNum(entityNumber));
        Set<Long> mapIds = DIIntegrationUtil.filterSchemeByDimNumber((Long)dimensionId, (String)number, ids, null);
        if (mapIds.size() > 0) {
            DIUserSelectUtil.propertyChangedUse((IFormView)this.getView(), entityNumber, (DynamicObject)this.getModel().getValue(entityNumber), true, false);
            return true;
        }
        Set defIds = DIIntegrationUtil.filterSchemeByDimNumberDef((String)number, ids);
        if (defIds.size() > 0) {
            DIUserSelectUtil.propertyChangedUse((IFormView)this.getView(), entityNumber, (DynamicObject)this.getModel().getValue(entityNumber), true, false);
            return true;
        }
        mapIds = this.handleInherit(dimensionId, number, ids);
        if (mapIds.size() > 0) {
            DIUserSelectUtil.propertyChangedUse((IFormView)this.getView(), entityNumber, (DynamicObject)this.getModel().getValue(entityNumber), true, false);
            return true;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u67e5\u8be2\u5230\u6210\u5458\u6620\u5c04\u3002", (String)"DIExecuteDetailPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        this.getModel().setValue(entityNumber, null);
        return false;
    }

    private Set<Long> handleInherit(Long dimensionId, String number, List<Long> schemeIds) {
        Long id = schemeIds.get(0);
        QFilter schemeQf = new QFilter("scheme.id", "=", (Object)id);
        QFilter tagdimensionQf = new QFilter("isdimmaptargentry.tagdimension.id", "=", (Object)dimensionId);
        QFilter mappedType = new QFilter("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        DynamicObjectCollection dimMapping = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, inheritancescheme.id, number,isdimmaptargentry.tagdimension", (QFilter[])new QFilter[]{schemeQf, tagdimensionQf, mappedType});
        for (DynamicObject doj : dimMapping) {
            Long inheritanceschemeId = doj.getLong("inheritancescheme.id");
            if (inheritanceschemeId == null || inheritanceschemeId == 0L) continue;
            ArrayList<Long> ids = new ArrayList<Long>(16);
            ids.add(inheritanceschemeId);
            Set resSetTemp = DIIntegrationUtil.filterSchemeByDimNumber((Long)dimensionId, (String)number, ids, (String)doj.getString("number"));
            if (resSetTemp.size() <= 0) continue;
            return resSetTemp;
        }
        return new HashSet<Long>(16);
    }

    private String getRealDimenNum(String entityNumber) {
        switch (entityNumber) {
            case "scenario": {
                return DimTypesEnum.SCENARIO.getNumber();
            }
            case "year": {
                return DimTypesEnum.YEAR.getNumber();
            }
            case "period": {
                return DimTypesEnum.PERIOD.getNumber();
            }
            case "entity": {
                return DimTypesEnum.ENTITY.getNumber();
            }
            case "currency": {
                return DimTypesEnum.CURRENCY.getNumber();
            }
        }
        return null;
    }

    private boolean needSetExeId(String name) {
        boolean flag;
        if ("model".equals(name)) {
            DIUserSelectUtil.propertyChangedModelUse((IFormView)this.getView(), Arrays.asList("scenario", "year", "period", "currency", "cslscheme", "entity"));
            return true;
        }
        if ("scenario".equals(name)) {
            this.getModel().setValue("year", null);
            this.getModel().setValue("period", null);
            return true;
        }
        if ("cslscheme".equals(name)) {
            this.getModel().setValue("entity", null);
            DIUserSelectUtil.propertyChangedUse((IFormView)this.getView(), name, (DynamicObject)this.getModel().getValue(name), true, false);
            return true;
        }
        if (SCHEME.equals(name)) {
            this.getModel().setValue("cslscheme", null);
            this.getModel().setValue("entity", null);
            this.getModel().setValue("scenario", null);
            this.getModel().setValue("year", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            return true;
        }
        boolean bl = flag = "year".equals(name) || "period".equals(name) || "currency".equals(name) || SCHEME.equals(name) || "entity".equals(name);
        if (flag && this.getModel().getValue(name) != null && SCHEME.equals(name)) {
            DIUserSelectUtil.propertyChangedUse((IFormView)this.getView(), name, (DynamicObject)this.getModel().getValue(name), true, false);
        }
        return flag;
    }

    private void linkData() {
        String curStep = this.getPageCache().get(CURSTEP);
        if (!STEP3.equals(curStep) && !STEP2.equals(curStep)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8f6c\u6362\u6216\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DIExecuteDetailPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        int[] rows = reportList.getEntryState().getSelectedRows();
        if (rows.length == 0 || rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8f6c\u6362\u6216\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DIExecuteDetailPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
        String idStr = (String)rowData.get("fidnew");
        String linkFilter = null;
        String curTab = null;
        if (STEP3.equals(curStep)) {
            this.getPageCache().put(CURSTEP, STEP2);
            linkFilter = " and ftraceid = " + idStr;
            this.getPageCache().put(FROM_LINK, "1");
            curTab = TURN_TAB;
        } else if (STEP2.equals(curStep)) {
            this.getPageCache().put(CURSTEP, STEP1);
            linkFilter = this.getImpLinkFilter(idStr);
            this.getPageCache().put(FROM_LINK, "1");
            curTab = IMPORT_TAB;
        }
        this.getPageCache().put(OTHERFILTER, linkFilter);
        this.activeTab(curTab);
    }

    private String getImpLinkFilter(String idStr) {
        String extendstable = this.getView().getPageCache().get(EXTENDSTABLE);
        List pkFileds = DB.getPrimaryKeys((DBRoute)BCMConstant.DBROUTE, (String)extendstable);
        if ((pkFileds = pkFileds.stream().filter(x -> !DEFAULT_PK.equals(x)).collect(Collectors.toList())).size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u8868\u4e3b\u952e\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"DIExecuteDetailPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (pkFileds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u8868\u4e3b\u952e\u8d85\u8fc7\u4e24\u4e2a\uff0c\u65e0\u6cd5\u8054\u67e5\u5bfc\u5165\u8868\u3002", (String)"DIExecuteDetailPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String primaryFiled = (String)pkFileds.get(0);
        List filedInfos = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)extendstable);
        Optional<FieldInfo> fieldInfoOpt = filedInfos.stream().filter(x -> x.getFieldName().equals(primaryFiled)).findFirst();
        if (!fieldInfoOpt.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u952e\u5b57\u6bb5\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"DIExecuteDetailPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FieldInfo fieldInfo = fieldInfoOpt.get();
        String dataType = fieldInfo.getDataType();
        boolean isLongType = "bigint".equalsIgnoreCase(dataType) || "integer".equalsIgnoreCase(dataType) || dataType.toLowerCase().contains("int");
        boolean isStringType = "character varying".equalsIgnoreCase(dataType) || "varchar".equalsIgnoreCase(dataType) || "character".equalsIgnoreCase(dataType);
        Long idImport = this.getIdImport(idStr);
        if (isLongType) {
            return " and " + primaryFiled + " = " + idImport;
        }
        if (isStringType) {
            return " and " + primaryFiled + " = '" + idImport + "'";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"DIExecuteDetailPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataType));
    }

    private Long getIdImport(String idStr) {
        String extendstable = this.getView().getPageCache().get(EXTENDSTABLE_CP);
        String impId = this.getMatchDataId(extendstable, idStr);
        return LongUtil.toLong((Object)impId);
    }

    private String getMatchDataId(String table, String fidNew) {
        String fimpid = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select fimpid from ");
        sql.append(table);
        sql.append(" where fidnew = ");
        sql.append(fidNew);
        DataSet ds = DB.queryDataSet((String)"getCompositeMapping", (DBRoute)BCMConstant.DBROUTE, (String)sql.toString());
        if (ds != null && ds.hasNext()) {
            Row row = ds.next();
            fimpid = row.getString("fimpid");
        }
        return fimpid;
    }

    private boolean fillUserSelect() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)formShowParameter.getCustomParam("schemeId");
        if (schemeId != null) {
            Long modelId = (Long)formShowParameter.getCustomParam("modelId");
            Long yearId = (Long)formShowParameter.getCustomParam("yearId");
            String yearNumber = (String)formShowParameter.getCustomParam("yearNumber");
            Long periodId = (Long)formShowParameter.getCustomParam("periodId");
            String periodNumber = (String)formShowParameter.getCustomParam("periodNumber");
            Long currencyId = Long.valueOf(formShowParameter.getCustomParam("currencyId") == null ? "0" : formShowParameter.getCustomParam("currencyId") + "");
            Long scenarioId = (Long)formShowParameter.getCustomParam("scenarioId");
            Long executeId = (Long)formShowParameter.getCustomParam(EXECUTEID);
            Long entityId = (Long)formShowParameter.getCustomParam("orgId");
            Long cslschemeId = (Long)formShowParameter.getCustomParam("cslschemeId");
            this.getModel().beginInit();
            this.getModel().setValue("model", (Object)modelId);
            this.getModel().setValue(SCHEME, (Object)schemeId);
            this.getModel().setValue("cslscheme", (Object)cslschemeId);
            this.getModel().setValue("entity", (Object)entityId);
            this.getModel().setValue("scenario", (Object)scenarioId);
            this.getModel().setValue("year", (Object)yearId);
            this.getModel().setValue("period", (Object)periodId);
            this.getModel().setValue("currency", (Object)currencyId);
            this.getView().updateView();
            this.getModel().endInit();
            if (!this.checkNumberMappingFromPage()) {
                return false;
            }
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            this.setParentCache(modelId, scenarioId, yearId, yearNumber, periodId, periodNumber, currencyId, schemeId, entityId, entity.getString("number"));
            this.getView().getPageCache().put(EXECUTEID, "" + executeId);
            return this.getTableAndSendMsg(schemeId, yearNumber, periodNumber);
        }
        DIUserSelectUtil.useSelectAfterCreateNewData((IFormView)this.getView(), Arrays.asList("model", "scenario", "year", "period", "currency", "cslscheme", "entity"));
        this.setExeIdFromPropertyChanged();
        return false;
    }

    private boolean checkNumberMappingFromPage() {
        boolean isEntityRight = this.checkNumberMapping("entity");
        if (!isEntityRight) {
            return false;
        }
        boolean isSceneRight = this.checkNumberMapping("scenario");
        if (!isSceneRight) {
            return false;
        }
        boolean isYearRight = this.checkNumberMapping("year");
        if (!isYearRight) {
            return false;
        }
        return this.checkNumberMapping("period");
    }

    private void setExeIdFromPropertyChanged() {
        Long schemeId;
        DynamicObject period;
        DynamicObject year;
        block11: {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
            year = (DynamicObject)this.getModel().getValue("year");
            period = (DynamicObject)this.getModel().getValue("period");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject cslScheme = (DynamicObject)this.getModel().getValue("cslscheme");
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            if (model == null || scene == null || year == null || period == null || cslScheme == null || entity == null || scheme == null) {
                this.getView().getPageCache().put(EXECUTEID, null);
                return;
            }
            Long modelId = model.getLong("id");
            Long sceneId = scene.getLong("id");
            Long yearId = year.getLong("id");
            Long periodId = period.getLong("id");
            Long currencyId = currency == null ? 0L : currency.getLong("id");
            schemeId = scheme.getLong("id");
            Long entityId = entity.getLong("id");
            IDNumberTreeNode entityMem = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId);
            entityId = entityMem.getBaseTreeNode().getId();
            QFBuilder filters = this.getExeFilter(modelId, sceneId, yearId, periodId, currencyId, schemeId, entityId);
            this.setParentCache(modelId, sceneId, yearId, year.getString("number"), periodId, period.getString("number"), currencyId, schemeId, entityId, entity.getString("number"));
            String currencyNumber = currency == null ? "" : currency.getString("number");
            DLock lock = DLock.create((String)("DIIntegrateDispatcher2." + MemberReader.findModelSNumberById((Object)modelId) + scene.getString("number") + year.getString("number") + period.getString("number") + currencyNumber));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id", (QFilter[])filters.toArray());
                    if (existLogs.length > 0) {
                        this.getView().getPageCache().put(EXECUTEID, existLogs[0].getLong("id") + "");
                    } else {
                        this.getView().getPageCache().put(EXECUTEID, this.insertExeLog(model.getLong("id"), scene.getLong("id"), year.getLong("id"), period.getLong("id"), currencyId, entity.getLong("id"), scheme.getLong("id")) + "");
                    }
                    break block11;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DIIntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DIIntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        if (this.getTableAndSendMsg(schemeId, year.getString("number"), period.getString("number"))) {
            this.doSearch();
        }
    }

    private Long insertExeLog(long model, long scene, long fy, long period, Long currency, long org, long scheme) {
        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
        dynaObj.set("model", (Object)model);
        dynaObj.set(SCHEME, (Object)scheme);
        dynaObj.set("org", (Object)org);
        dynaObj.set("scenario", (Object)scene);
        dynaObj.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
        dynaObj.set("collectstatus", (Object)CollectStatusEnum.READY.getValue());
        dynaObj.set("fy", (Object)fy);
        dynaObj.set("period", (Object)period);
        dynaObj.set("currency", (Object)currency);
        dynaObj.set("paramjson", (Object)" ");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynaObj});
        return dynaObj.getLong("id");
    }

    private QFBuilder getExeFilter(Long modelId, Long sceneId, Long yearId, Long periodId, Long currencyId, Long schemeId, Long entityId) {
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", (Object)modelId);
        filters.add("scenario", "=", (Object)sceneId);
        filters.add("fy", "=", (Object)yearId);
        filters.add("period", "=", (Object)periodId);
        filters.add("currency", "=", (Object)currencyId);
        filters.add(SCHEME, "=", (Object)schemeId);
        filters.add("org", "=", (Object)entityId);
        return filters;
    }

    private boolean getTableAndSendMsg(Long schemeId, String yearNumber, String periodNumber) {
        Pair levelTable = DIIntegrationUtil.getLevelTable((Long)schemeId, (String)yearNumber, (String)periodNumber);
        if (((Boolean)levelTable.p1).booleanValue()) {
            this.getPageCache().put(EXTENDSTABLE, (String)((Pair)levelTable.p2).p1);
            this.getPageCache().put(EXTENDSTABLE_CP, (String)((Pair)levelTable.p2).p2);
        } else {
            this.getPageCache().put(EXTENDSTABLE, null);
            this.getPageCache().put(EXTENDSTABLE_CP, null);
        }
        return (Boolean)levelTable.p1;
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.setDataChanged(false);
        switch (tabKey) {
            case "tabpageap": {
                this.showImportEntryGridData();
                break;
            }
            case "tabpageap1": {
                this.showTurnEntryGridData();
                break;
            }
            case "tabpageap2": {
                this.showExportEntryGridData();
                break;
            }
        }
    }

    private void showImportEntryGridData() {
        if (!this.checkCanChandgeLable()) {
            return;
        }
        this.getPageCache().put(CURSTEP, STEP1);
        if (this.getPageCache().get(FROM_LINK) == null) {
            this.getPageCache().put(OTHERFILTER, null);
        }
        this.getPageCache().put(FROM_LINK, null);
        this.clearTableHeadFilter();
        this.doSearch();
        this.setLinkGrayedOut();
        this.setLookGrayedOut();
    }

    private void showTurnEntryGridData() {
        if (!this.checkCanChandgeLable()) {
            return;
        }
        if (this.getPageCache().get(FROM_LINK) == null) {
            this.getPageCache().put(OTHERFILTER, null);
        }
        this.getPageCache().put(FROM_LINK, null);
        this.getPageCache().put(CURSTEP, STEP2);
        this.handle4Report();
        this.clearTableHeadFilter();
        this.doSearch();
        this.setLookEnable();
        this.setLinkEnable();
    }

    private void clearTableHeadFilter() {
        ReportQueryParam queryParam = this.getQueryParam();
        if (queryParam.getFilter() != null && queryParam.getFilter().getTableHeadFilterItems() != null) {
            queryParam.getFilter().getTableHeadFilterItems().clear();
        }
    }

    private void handle4Report() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long linkId = (Long)formShowParameter.getCustomParam("linkId");
        if (linkId != null) {
            String linkFilter = " and ftraceid = " + linkId;
            this.getPageCache().put(OTHERFILTER, linkFilter);
        }
    }

    private void showExportEntryGridData() {
        if (!this.checkCanChandgeLable()) {
            return;
        }
        this.getPageCache().put(CURSTEP, STEP3);
        this.getPageCache().put(OTHERFILTER, OTHERFILTER_CONDITION);
        this.clearTableHeadFilter();
        this.doSearch();
        this.setLinkEnable();
        this.setLookGrayedOut();
    }

    private boolean checkCanChandgeLable() {
        if (this.getPageCache().get(EXECUTEID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"DIExecuteDetailPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        if (this.getPageCache().get(EXTENDSTABLE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u6570\u636e\u3002", (String)"DIExecuteDetailPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setLinkGrayedOut() {
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_LINK});
    }

    private void setLookGrayedOut() {
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_LOOK});
    }

    private void setLinkEnable() {
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_LINK});
    }

    private void setLookEnable() {
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_LOOK});
    }
}

