/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class DIImportModelPlugin
extends AbstractBaseFormPlugin {
    private static final String OTHERDIM = "otherdim";
    private static final String CLEARDATACONFIG = "clearDataConfig";
    private static final String PREDIMENSIONSCOPE = "preDimensionScope";
    private static final String CACHECLEARCONFIG = "cacheClearConfig";
    private static final String CHANGEDIMENSION = "changeDimension";
    private static final String MODELOLAPFORM = "di_model_olap";
    private static final String BTN_OK = "btn_ok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(OTHERDIM, BTN_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (Objects.isNull(parameter.getPkId())) {
            this.getModel().setValue("model", parameter.getCustomParam("KEY_MODEL_ID"));
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String importmode = (String)this.getModel().getValue("importmode");
        if (ISImpModeEnum.REPLACEIMPORT.getCode().equals(importmode)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{OTHERDIM});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
        }
        this.setClearDataDisAndCache();
        this.setClearDataText();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CHANGEDIMENSION.equals(callBackId) && !"No".equals(messageBoxClosedEvent.getResultValue())) {
            this.getModel().setValue(OTHERDIM, null);
            this.getPageCache().put(PREDIMENSIONSCOPE, null);
            this.getPageCache().put(CACHECLEARCONFIG, null);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("importmode".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (ISImpModeEnum.MERGEIMPORT.getCode().equals(newValue)) {
                ThreadCache.put((Object)"importmode", (Object)true);
                this.setClearNull();
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{OTHERDIM});
            }
        }
    }

    private void setClearNull() {
        this.getModel().setValue(OTHERDIM, null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{OTHERDIM});
        this.getPageCache().put(PREDIMENSIONSCOPE, null);
        this.getPageCache().put(CACHECLEARCONFIG, null);
    }

    @Override
    public void click(EventObject evt) {
        Button button;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit button2 = (TextEdit)source;
            String key = button2.getKey();
            if (OTHERDIM.equals(key)) {
                this.openClearDataPage();
            }
        } else if (source instanceof Button && (button = (Button)source).getKey().equals(BTN_OK) && this.actionSave()) {
            this.getView().close();
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if (BTN_OK.equals(opkey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            opkey = OperationStatus.ADDNEW == status ? "btn_add" : "btn_edit";
        }
        super.checkPerm(opkey);
    }

    @Override
    public String getPermEntityId() {
        return "di_importmodelist";
    }

    private void openClearDataPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        String formid = MODELOLAPFORM;
        formShowParameter.setFormId(formid);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u6e05\u9664", (String)"ISSchemeDataCollectPlugin2_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("operationStatus", (Object)false);
        formShowParameter.setCustomParam("isEdit", (Object)true);
        formShowParameter.setCustomParam("paramData", this.getDimensionScope());
        formShowParameter.setCustomParam(CACHECLEARCONFIG, (Object)this.getPageCache().get(CACHECLEARCONFIG));
        formShowParameter.setCustomParam(PREDIMENSIONSCOPE, (Object)this.getPageCache().get(PREDIMENSIONSCOPE));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLEARDATACONFIG));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && CLEARDATACONFIG.equals(actionId)) {
            this.setClearDataText();
        }
    }

    private void saveClearDataConfig(Long id) {
        String returnDataStr = this.getPageCache().get(CACHECLEARCONFIG);
        QFilter qf = null;
        qf = new QFilter("importmode", "=", (Object)id);
        if (StringUtils.isEmpty((String)returnDataStr)) {
            DeleteServiceHelper.delete((String)"di_cleardataconfig", (QFilter[])new QFilter[]{qf});
            return;
        }
        LinkedHashMap cacheMap = (LinkedHashMap)JSONObject.parseObject((String)returnDataStr, LinkedHashMap.class);
        Map innerMap = null;
        JSONArray ja = null;
        JSONObject jo = null;
        DynamicObject clearConfig = null;
        ArrayList<DynamicObject> clearConfigList = new ArrayList<DynamicObject>();
        for (Map.Entry map : cacheMap.entrySet()) {
            innerMap = (Map)map.getValue();
            ja = (JSONArray)innerMap.get("dimList");
            for (Object object : ja) {
                jo = (JSONObject)object;
                clearConfig = BusinessDataServiceHelper.newDynamicObject((String)"di_cleardataconfig");
                clearConfig.set("dimmemberid", (Object)jo.getLong("id"));
                clearConfig.set("dimtype", map.getKey());
                clearConfig.set("membernumber", (Object)jo.getString("number"));
                clearConfig.set("scope", (Object)jo.getString("scope"));
                clearConfig.set("importmode", (Object)id);
                clearConfigList.add(clearConfig);
            }
        }
        DeleteServiceHelper.delete((String)"di_cleardataconfig", (QFilter[])new QFilter[]{qf});
        SaveServiceHelper.save((DynamicObject[])clearConfigList.toArray(new DynamicObject[0]));
    }

    private boolean actionSave() {
        DynamicObject[] modeList;
        Long pkId = (Long)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        Long modelId = this.getModelId();
        boolean isEditData = null != pkId && pkId != 0L;
        String number = this.getModel().getValue("number").toString();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("number", "=", (Object)number);
        if (isEditData) {
            qf.and("id", "!=", (Object)pkId);
        }
        if ((modeList = BusinessDataServiceHelper.load((String)"di_importmode", (String)"id", (QFilter[])new QFilter[]{qf})) != null && modeList.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"DIImportModelPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject integrateImpMode = null != pkId && pkId != 0L && QueryServiceHelper.exists((String)"di_importmode", (Object)pkId) ? BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"di_importmode") : BusinessDataServiceHelper.newDynamicObject((String)"di_importmode");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date now = TimeServiceHelper.now();
        this.setClearDataText();
        String importmode = null;
        integrateImpMode.set("number", this.getModel().getValue("number"));
        integrateImpMode.set("name", this.getModel().getValue("name"));
        integrateImpMode.set("importmode", this.getModel().getValue("importmode"));
        integrateImpMode.set(OTHERDIM, this.getModel().getValue(OTHERDIM));
        integrateImpMode.set("model", (Object)modelId);
        if (isEditData) {
            integrateImpMode.set("modifier", (Object)userId);
            integrateImpMode.set("modifydate", (Object)now);
        } else {
            integrateImpMode.set("creator", (Object)userId);
            integrateImpMode.set("createdate", (Object)now);
        }
        DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{integrateImpMode});
        if (result.length > 0) {
            Long newId = result[0].getLong("id");
            this.getModel().setValue("id", (Object)newId);
            this.getModel().setDataChanged(false);
            this.saveClearDataConfig(result[0].getLong("id"));
        }
        String opName = "";
        String opDescription = "";
        if (isEditData) {
            opName = ResManager.loadKDString((String)"\u4fee\u6539\u96c6\u6210\u6a21\u5f0f", (String)"DIImportModelPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            opDescription = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u96c6\u6210\u6a21\u5f0f\u4e3a\u201c%1$s\u201d\u3002", (String)"DIImportModelPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ISImpModeEnum.getNameByCode(importmode));
        } else {
            opName = ResManager.loadKDString((String)"\u65b0\u589e\u96c6\u6210\u6a21\u5f0f", (String)"ISImpModeSaveOp_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            opDescription = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u96c6\u6210\u6a21\u5f0f\u4e3a\u201c%1$s\u201d\u3002", (String)"ISImpModeSaveOp_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ISImpModeEnum.getNameByCode(importmode));
        }
        OperationLogUtil.writeOperationLog((String)opName, (String)opDescription, (Long)modelId, (String)"bcm_isscheme");
        return true;
    }

    private Map<String, Map<Long, Integer>> getDimensionScope() {
        Map<String, Map<Long, Integer>> dataMap = new HashMap<String, Map<Long, Integer>>(16);
        String dimensionScopeStr = this.getPageCache().get(PREDIMENSIONSCOPE);
        if (StringUtils.isNotEmpty((String)dimensionScopeStr)) {
            dataMap = (Map)JSONObject.parseObject((String)dimensionScopeStr, Map.class);
        }
        return dataMap;
    }

    private void setClearDataText() {
        String cacheClearConfigStr = this.getPageCache().get(CACHECLEARCONFIG);
        if (StringUtils.isNotEmpty((String)cacheClearConfigStr)) {
            LinkedHashMap cacheMap = (LinkedHashMap)JSONObject.parseObject((String)cacheClearConfigStr, LinkedHashMap.class);
            Map innerMap = null;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry map : cacheMap.entrySet()) {
                innerMap = (Map)map.getValue();
                sb.append((String)innerMap.get("dimDescription"));
                if (sb.length() < 30) continue;
                this.getView().getModel().setValue(OTHERDIM, (Object)(sb.substring(0, 30) + "..."));
                return;
            }
            this.getView().getModel().setValue(OTHERDIM, (Object)sb.toString());
            this.getModel().setDataChanged(false);
        }
    }

    private void setClearDataDisAndCache() {
        QFilter qf = null;
        Long pkId = (Long)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        qf = new QFilter("importmode", "=", (Object)pkId);
        DynamicObject[] configs = new DynamicObject[]{};
        if (pkId != null) {
            configs = BusinessDataServiceHelper.load((String)"di_cleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        }
        HashMap<String, Map> dataMap = new HashMap<String, Map>(16);
        Map dimMembers = null;
        LinkedHashMap<String, Map> cacheMap = new LinkedHashMap<String, Map>();
        Map cacheMapInner = null;
        JSONArray ja = null;
        StringBuilder dimDescription = null;
        String dimtype = null;
        Integer scope = null;
        Long membId = null;
        DynamicObject dimObj = null;
        String dimName = null;
        HashSet<String> dimNameSet = new HashSet<String>(configs.length);
        for (DynamicObject dynamicObject : configs) {
            dimtype = dynamicObject.getString("dimtype");
            dimMembers = dataMap.computeIfAbsent(dimtype, k -> new HashMap());
            membId = dynamicObject.getLong("dimmemberid");
            scope = dynamicObject.getInt("scope");
            dimMembers.put(membId, scope);
            cacheMapInner = cacheMap.computeIfAbsent(dimtype, k -> new HashMap());
            ja = (JSONArray)cacheMapInner.computeIfAbsent("dimList", k -> new JSONArray());
            ja.add((Object)this.getDim(dynamicObject));
            dimDescription = (StringBuilder)cacheMapInner.computeIfAbsent("dimDescription", k -> new StringBuilder());
            dimObj = IntegrationUtil.getDimPair((Long)this.getModelId(), (String)dimtype);
            IDNumberTreeNode member = MemberReader.findMemberById((long)this.getModelId(), (String)dimObj.getString("memberform"), (Long)membId);
            String memberName = "";
            if (member.getId() == null || member.getId() == -1L) {
                ArrayList<Long> membIds = new ArrayList<Long>();
                membIds.add(membId);
                Pair memberMap = IntegrateDispatcher2.getMember((DynamicObject)dimObj, membIds);
                memberName = this.getMemberName((Map)memberMap.p2);
            } else {
                memberName = member.getName();
            }
            dimName = !dimNameSet.add(dimObj.getString("name")) ? "" : dimObj.getString("name") + "|";
            dimDescription.append(dimName).append(memberName).append(this.getScopeDesc(scope));
        }
        this.getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString(cacheMap));
        this.getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    private String getMemberName(Map<Object, DynamicObject> memberMap) {
        Iterator<Map.Entry<Object, DynamicObject>> iterator = memberMap.entrySet().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getValue().getString("name");
        }
        return null;
    }

    private String getScopeDesc(Integer scope) {
        if (scope.intValue() == RangeEnum.VALUE_10.getValue()) {
            return ";";
        }
        RangeEnum range = RangeEnum.getRangeByVal((int)scope);
        return range.getName() + ";";
    }

    private JSONObject getDim(DynamicObject dynamicObject) {
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)dynamicObject.getLong("dimmemberid"));
        jo.put("number", (Object)dynamicObject.getString("membernumber"));
        jo.put("scope", (Object)dynamicObject.getString("scope"));
        return jo;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number"))) || this.getModel().getValue("name") == null || ((OrmLocaleValue)this.getModel().getValue("name")).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ISImpModeSetPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            args.setCancel(true);
            return;
        }
    }
}

