/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class DIImportmodeListPlugin
extends DIAbstractListPlugin
implements HyperLinkClickListener {
    private static final String ctl_billlistap = "billlistap";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_DELETE = "btn_delete";
    private static final String DELETE_CONFIRM = "delete_confirm";
    private static final String LISTGRID = "listgridviewap";

    @Override
    public void afterCreateNewData(EventObject e) {
        String modelIdStr;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        if ((modelId == null || modelId == 0L) && StringUtils.isNotEmpty((CharSequence)(modelIdStr = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model")))) {
            modelId = LongUtil.toLong((Object)modelIdStr);
        }
        if (modelId != null) {
            this.getPageCache().put("modelId", modelId.toString());
        }
        this.getModel().setValue("model", (Object)modelId);
        this.refreshBillList(this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        BillListHyperLinkClickEvent list = (BillListHyperLinkClickEvent)e;
        this.openAddPage((Long)list.getCurrentRow().getPrimaryKeyValue());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.openAddPage(null);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList(this);
                break;
            }
            case "btn_delete": {
                this.deleteBill();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "di_importmode": {
                this.refreshBillList(this);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "delete_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Object[] ids = rows.getPrimaryKeyValues();
                this.checkDeleteStatus(ids);
                this.doDelete(ids);
                this.refreshBillList(this);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void doDelete(Object[] ids) {
        DeleteServiceHelper.delete((String)"di_importmode", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        DeleteServiceHelper.delete((String)"bcm_iscleardataconfig", (QFilter[])new QFilter[]{new QFilter("importmode", "in", (Object)ids)});
    }

    private void checkDeleteStatus(Object[] ids) {
    }

    private void deleteBill() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"VariableListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        if (this.checkReferenceSchemeIds(ids).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u96c6\u6210\u6a21\u5f0f\u5df2\u88ab\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u5982\u9700\u5220\u9664\uff0c\u8bf7\u5148\u4fee\u6539\u5f15\u7528\u6b64\u96c6\u6210\u6a21\u5f0f\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"DIImportmodeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this));
    }

    private Boolean checkReferenceSchemeIds(Object[] ids) {
        QFilter filter = new QFilter("importmodeid", "in", (Object)ids);
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])filter.toArray());
    }

    private void openAddPage(Long id) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId("di_importmode");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("fromType", (Object)"DI");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setPkId((Object)id);
        formShowParameter.setStatus(id == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "di_importmode"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        if ("model".equals(e.getProperty().getName()) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.getPageCache().put("modelId", newValue.getString("id"));
            this.getView().getFormShowParameter().setCustomParam("modelId", (Object)newValue.getLong("id"));
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), newValue.getString("id"));
            this.refreshBillList(this);
        }
    }

    private void refreshBillList(AbstractBaseListPlugin plugin) {
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("scheme", "=", (Object)0L);
        fp.setFilter(filter);
        BillList billList = (BillList)plugin.getControl(ctl_billlistap);
        billList.setFilterParameter(fp);
        billList.refresh();
        billList.clearSelection();
    }
}

