/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.util.DISchemeUtil;

public class DIMappingDetailPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String EXEID = "exeid";
    private static final String MATCHDATAID = "matchdataid";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<Tuple<String, String, String>> mappings = new ArrayList<Tuple<String, String, String>>(8);
        String exeid = (String)this.getView().getFormShowParameter().getCustomParam(EXEID);
        String matchdataid = (String)this.getView().getFormShowParameter().getCustomParam(MATCHDATAID);
        Set<Long> mappingIds = this.getMappingId(LongUtil.toLong((Object)exeid), LongUtil.toLong((Object)matchdataid));
        mappings.addAll(this.setCompositeMappingData(mappingIds));
        this.fillMapping(mappings);
    }

    private void fillMapping(List<Tuple<String, String, String>> mappings) {
        if (mappings.size() > 1) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, mappings.size() - 1);
            for (int i = 0; i < mappings.size(); ++i) {
                this.getModel().setValue("mappingtype", mappings.get((int)i).p1, i);
                this.getModel().setValue("srcnumber", mappings.get((int)i).p2, i);
                this.getModel().setValue("targnumber", mappings.get((int)i).p3, i);
            }
        } else if (mappings.size() == 1) {
            this.getModel().setValue("mappingtype", mappings.get((int)0).p1);
            this.getModel().setValue("srcnumber", mappings.get((int)0).p2);
            this.getModel().setValue("targnumber", mappings.get((int)0).p3);
        } else {
            this.getModel().setValue("mappingtype", (Object)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u6620\u5c04\u6570\u636e\u3002", (String)"DIMappingDetailPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Tuple<String, String, String>> setCompositeMappingData(Set<Long> mappingIds) {
        DynamicObject[] loads;
        ArrayList<Tuple<String, String, String>> mappings = new ArrayList<Tuple<String, String, String>>(8);
        String selectField = "srctype,dseq,computeoprt,templateid,templateid.number,isgrouptargmapentry,isgrouptargmapentry.tardimension,isgrouptargmapentry.tarmember,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.srcdimension,isgroupsrcmapentry.srcmember,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.scope,isgroupsrcexprentry.expressions,dimmapid";
        QFilter qf = new QFilter("id", "in", mappingIds);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)selectField, (QFilter[])qf.toArray())) {
            String srcNumber = this.getSrcCompositeNumber((DynamicObjectCollection)load.get("isgroupsrcmapentry"));
            String targNumber = this.getCompositeNumber((DynamicObjectCollection)load.get("isgrouptargmapentry"), "tarmembnumber");
            String mappingType = this.getCompositeMappingType(load.getLong("dimmapid"));
            mappings.add((Tuple<String, String, String>)new Tuple((Object)mappingType, (Object)srcNumber, (Object)targNumber));
        }
        return mappings;
    }

    private DynamicObject getDimMapDyn(Long id) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        return BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)"id, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname, mappedtype,priority,tagmemb,issys", (QFilter[])filters);
    }

    private String getCompositeMappingType(Long dimMapId) {
        DynamicObject dyn = this.getDimMapDyn(dimMapId);
        DynamicObjectCollection srcDyn = dyn.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDyn = dyn.getDynamicObjectCollection("isdimmaptargentry");
        String src = DISchemeUtil.getDimName(srcDyn, "srcdimension", ",");
        String tag = DISchemeUtil.getDimName(tagDyn, "tagdimension", ",");
        return src + "->" + tag;
    }

    private String getCompositeNumber(DynamicObjectCollection isgroupsrcmapentry, String type) {
        StringBuilder srcNumber = new StringBuilder();
        if (isgroupsrcmapentry != null && isgroupsrcmapentry.size() > 0) {
            for (DynamicObject scr : isgroupsrcmapentry) {
                srcNumber.append(scr.getString(type)).append(",");
            }
            return srcNumber.substring(0, srcNumber.length() - 1);
        }
        return "";
    }

    private String getSrcCompositeNumber(DynamicObjectCollection srcs) {
        LinkedHashMap<Long, List> srcMap = new LinkedHashMap<Long, List>(16);
        for (DynamicObject src : srcs) {
            long dimensionId = src.getLong("srcdimension");
            srcMap.computeIfAbsent(dimensionId, l -> new ArrayList());
            List members = (List)srcMap.get(dimensionId);
            members.add(src);
        }
        StringBuilder srcNumber = new StringBuilder();
        srcMap.forEach((dimId, v) -> {
            if (v.isEmpty()) {
                return;
            }
            srcNumber.append(DISchemeUtil.getSrcNumber(v)).append(",");
        });
        return srcNumber.substring(0, srcNumber.length() - 1);
    }

    private Set<Long> getMappingId(Long exeId, Long matchDataId) {
        HashSet<Long> memberMappingIds = new HashSet<Long>(8);
        String selectFilter = "mappingid";
        QFilter qfExeId = new QFilter(EXEID, "=", (Object)exeId);
        QFilter qfMatchDataId = new QFilter(MATCHDATAID, "=", (Object)matchDataId);
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"di_mappingtrace", (String)selectFilter, (QFilter[])new QFilter[]{qfExeId, qfMatchDataId});
        for (DynamicObject dynamicObject : dyn) {
            String mappingId = dynamicObject.getString("mappingid");
            if (!StringUtils.isNotEmpty((String)mappingId)) continue;
            List<String> strList = Arrays.asList(mappingId.split(";"));
            for (String s : strList) {
                memberMappingIds.add(LongUtil.toLong((Object)s));
            }
        }
        return memberMappingIds;
    }
}

