/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIMemberMapExportImp;
import kd.fi.bcm.business.integration.di.service.DIMemberMapImportImp;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIMemberImportStartPlugin
extends ImportStartPlugin
implements BCMBaseFunction {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DIMemberImportStartPlugin.class);
    private static final String DIMMAPPINGIDS = "dimMappingIds";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile", "btnimgzipdelete", "txttardimmapping"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String titleName = showParam.getCustomParam("title").toString();
        Label title = (Label)this.getControl("title");
        title.setText(titleName);
        this.getModel().setValue("importtype", (Object)ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
            case "btnok": {
                String filePath = (String)this.getModel().getValue("filepath");
                if (StringUtils.isBlank((CharSequence)filePath)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DIMemberImportStartPlugin3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Long schemeId = (Long)parameter.getCustomParam("schemeId");
                String schemeName = (String)parameter.getCustomParam("schemeName");
                DIMemberMapExportImp exportService = new DIMemberMapExportImp();
                XSSFWorkbook workbook = exportService.exportTemplate(schemeId);
                try {
                    String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u6210\u5458\u6620\u5c04\u5bfc\u51fa\u6a21\u677f", (String)"DIMemberImportStartPlugin1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeName));
                    this.downloadFile(url, null, null);
                    break;
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u5931\u8d25", (String)"DIMemberImportStartPlugin2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            case "txttardimmapping": {
                this.showDimMappingF7();
            }
        }
    }

    private void showDimMappingF7() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("di_dimmappingf7");
        showParameter.setMultiSelect(true);
        showParameter.setFormId("bos_listf7");
        showParameter.setLookUp(true);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setShowTitle(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimMapCallBack"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("dimMapCallBack")) {
            ListSelectedRowCollection dimMaps = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == dimMaps) {
                return;
            }
            List dimMapIds = Arrays.stream(dimMaps.getPrimaryKeyValues()).map(x -> LongUtil.toLong((Object)x)).collect(Collectors.toList());
            List names = dimMaps.stream().map(x -> x.getName()).collect(Collectors.toList());
            String dimMappingNames = String.join((CharSequence)";", names);
            this.getModel().setValue("txttardimmapping", (Object)dimMappingNames);
            this.getPageCache().put(DIMMAPPINGIDS, JSONObject.toJSONString(dimMapIds));
        }
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)parameter.getCustomParam("schemeId");
        String modelNumber = (String)parameter.getCustomParam("modelNumber");
        DIMemberMapImportImp importService = new DIMemberMapImportImp();
        String impType = this.getModel().getValue("importtype").toString();
        boolean deleteBeforeSave = !ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType().equals(impType);
        List selectedDimMappingIds = !StringUtils.isEmpty((CharSequence)this.getPageCache().get(DIMMAPPINGIDS)) && !StringUtils.isEmpty((CharSequence)this.getModel().getValue("txttardimmapping").toString()) ? (List)JSONObject.parseObject((String)this.getPageCache().get(DIMMAPPINGIDS), List.class) : this.getDimMapIds(schemeId);
        importService.importData(url, schemeId.longValue(), modelNumber, selectedDimMappingIds, deleteBeforeSave);
        this.openTipsPage(importService.getErrorMsgs(), importService.getSuccessCount());
    }

    protected List<Long> getDimMapIds(Long schemeId) {
        QFilter qFilter = new QFilter("scheme.id", "=", (Object)LongUtil.toLong((Object)schemeId));
        qFilter.and(new QFilter("isdimmapsrcentry.id", "!=", null));
        List<Long> ids = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])qFilter.toArray()).stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        return ids;
    }

    private void openTipsPage(List<Object> errorMsgs, Integer successCount) {
        String titleInfo = errorMsgs.size() > 0 ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5c55\u5f00\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u6570\u636e", (String)"DIDeriveRuleStartPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount) : String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%1$s\u884c\u3002", (String)"DIDeriveRuleStartPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount);
        String detailInfo = "";
        detailInfo = errorMsgs.size() > 2000 ? errorMsgs.subList(0, 1999).stream().map(Object::toString).collect(Collectors.joining("")) : errorMsgs.stream().map(Object::toString).collect(Collectors.joining(""));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_membmapimporttip");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)titleInfo);
        showParameter.setCustomParam("isAllSuccess", (Object)(errorMsgs.size() == 0 ? 1 : 0));
        showParameter.setCustomParam("detail", (Object)detailInfo);
        this.getView().showForm(showParameter);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            IFormView view = this.getView();
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf("/") + 1));
            model.setValue("filepath", (Object)url);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }
}

