/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.service.DIMemberMapExportImp;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.intergration.di.DiAbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.intergration.di.utils.DIUserSelectUtil;
import kd.fi.bcm.formplugin.intergration.membermap.handel.MapViewManager;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.model.StatusBarModel;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIMemberMappingPlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier {
    private static final String TOOLBARAP = "toolbarap";
    private static final String TAB_SIMPLE = "simpletab";
    private static final String TAB_COMBO = "combotab";
    private static final String TAB_SPECIAL = "specialtab";
    private static final String TREE_SIMPLE = "simpletree";
    private static final String TREE_COMBO = "combotree";
    private static final String TREE_SPECIAL = "specialtree";
    private static final String SCHEME = "scheme";
    private static final String MODEL = "model";
    private static final String VERSION = "versionnum";
    private static final String COMMEM_SPREAD = "commemspread";
    private static final String TAIL = "fomula";
    private static final String CACHE_LASTTAB = "CACHE_LASTTAB";
    private static final String CACHE_LASTTREE = "CACHE_LASTTREE";
    private static final String CACHE_SELECTNODE = "CACHE_SELECTNODE";
    private static final String CACHE_LASTNODE = "CACHE_LASTNODE";
    private static final String PAGECACHE_LOCKED = "pageCache_locked";
    private static final String CACHE_MEMANDCOMVO = "cache_memandcomvo";
    private static final String CACHE_MODEL = "cache_model";
    private static final String CACHE_SCHEME = "cache_scheme";
    private SpreadManager spreadManager;
    private MemAndComVO memandcomvo;

    private void mutexControl() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (model != null && scheme != null && this.checkAndSetWritePermission().booleanValue()) {
            boolean success = this.requestMutex();
            this.getView().setEnable(Boolean.valueOf(success), new String[]{"bar_save", "btn_import", "btn_export", "btn_refresh", "btn_resetseq"});
        }
    }

    private boolean requestMutex() {
        String mutexKey = this.getMutexKey();
        boolean mutex = MutexServiceHelper.request((String)mutexKey, (String)"di_membermapping", (String)"edit");
        if (!mutex) {
            Map lockInfo = MutexServiceHelper.getLockInfo((String)mutexKey, (String)"di_membermapping", (String)"edit");
            if (lockInfo != null) {
                String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b", (String)"DIMemberMappingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid")));
                this.getView().showTipNotification(tips, Integer.valueOf(3000));
            }
        } else {
            this.getPageCache().put(PAGECACHE_LOCKED, mutexKey);
        }
        return mutex;
    }

    private String getMutexKey() {
        if (this.getModel().getValue(SCHEME) == null) {
            return null;
        }
        long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        return this.getClass().getSimpleName() + schemeId;
    }

    private void releaseLock() {
        String lockedKey;
        Map lockInfo;
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(PAGECACHE_LOCKED)) && (lockInfo = MutexServiceHelper.getLockInfo((String)(lockedKey = this.getPageCache().get(PAGECACHE_LOCKED)), (String)"di_membermapping", (String)"edit")) != null && ((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) {
            MutexServiceHelper.release((String)lockedKey, (String)"di_membermapping", (String)"edit");
        }
        this.getPageCache().remove(PAGECACHE_LOCKED);
    }

    public void addTableIndex() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("di_tableindex");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void forceReleaseMutex() {
        String mutexKey = this.getMutexKey();
        if (mutexKey == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u3002", (String)"DIMemberMappingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasPerm = this.checkOperationPermission("di_membermapping", "3KB8R4GIHJ6B");
        if (!hasPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u201c\u5f3a\u5236\u89e3\u9501\u201d\u6743\u9650", (String)"DIMemberMappingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map lockInfo = MutexServiceHelper.getLockInfo((String)mutexKey, (String)"di_membermapping", (String)"edit");
        if (lockInfo != null) {
            String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u662f\u5426\u5f3a\u5236\u89e3\u9501", (String)"DIMemberMappingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid")));
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, new ConfirmCallBackListener("forceReleaseMutex", (IFormPlugin)this));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u672a\u88ab\u9501\u5b9a\uff0c\u65e0\u9700\u89e3\u9501", (String)"DIMemberMappingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    @Override
    public String getSpreadKey() {
        return COMMEM_SPREAD;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl(SCHEME);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(TOOLBARAP);
        TreeView tree = (TreeView)this.getControl(TREE_SIMPLE);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DIMemberMappingPlugin.this.treeNodeClickDo(evt);
            }
        });
        TreeView tree1 = (TreeView)this.getControl(TREE_COMBO);
        tree1.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DIMemberMappingPlugin.this.treeNodeClickDo(evt);
            }
        });
        TreeView tree2 = (TreeView)this.getControl(TREE_SPECIAL);
        tree2.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DIMemberMappingPlugin.this.treeNodeClickDo(evt);
            }
        });
        Tab subTab = (Tab)this.getControl("tabap");
        IPageCache pageCache = this.getPageCache();
        subTab.addTabSelectListener(arg0 -> {
            DynamicObject schemeDyn = (DynamicObject)this.getModel().getValue(SCHEME);
            if (schemeDyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"IsRpaSchemePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            pageCache.remove(CACHE_SELECTNODE);
            this.initTree(schemeDyn);
        });
        this.initSpreadListener();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        BasedataEdit bs = (BasedataEdit)event.getSource();
        String key = bs.getKey();
        if (SCHEME.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
            qFilter.and("issrc.number", "like", (Object)"DI%");
            qFilter.and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(qFilter);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        e.getProperty().getName();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            this.getModel().beginInit();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                if (oldValue != null) {
                    this.getPageCache().put(CACHE_MODEL, oldValue.getString("id"));
                } else {
                    this.getPageCache().remove(CACHE_MODEL);
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("modelchange", (IFormPlugin)this));
            } else {
                this.modelChanged();
            }
            this.getModel().endInit();
        } else if (SCHEME.equals(key)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                if (oldValue != null) {
                    this.getPageCache().put(CACHE_SCHEME, oldValue.getString("id"));
                } else {
                    this.getPageCache().remove(CACHE_SCHEME);
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("schemechange", (IFormPlugin)this));
            } else {
                this.schemeChanged(newValue);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DIUserSelectUtil.useSelectAfterCreateNewData(this.getView(), Collections.singletonList(MODEL));
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme != null) {
            this.schemeChanged(scheme);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VERSION});
        this.registSpreadShortcutKey();
    }

    protected void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "forceReleaseMutex", "M", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "addTableIndex", "P", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "checkParamValue", "V", true, true, true);
    }

    public void checkParamValue() {
        int startCol = this.getSpreadSelector().getStartCol();
        int startRow = this.getSpreadSelector().getStartRow();
        Object value = this.getSpreadModel().getBook().getSheet(0).getCell(startRow, startCol).getValue();
        if (value == null) {
            return;
        }
        String[] split = value.toString().split(";");
        if (split.length < 2) {
            return;
        }
        Object res = "";
        if ("1".equals(split[0])) {
            res = ConfigServiceHelper.getStringParamNoModel((String)split[1]);
        } else if ("2".equals(split[0])) {
            res = ConfigServiceHelper.getGlobalBoolParam((String)split[1]);
        } else if ("3".equals(split[0])) {
            res = ConfigServiceHelper.getBoolParam((Long)Long.parseLong(split[2]), (String)split[1]);
        } else if ("4".equals(split[0])) {
            res = ConfigServiceHelper.getStringParam((Long)Long.parseLong(split[2]), (String)split[1]);
        }
        this.getView().showSuccessNotification(value.toString() + ":" + res);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String mutexKey = this.getPageCache().get(PAGECACHE_LOCKED);
        if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null && StringUtils.isNotEmpty((String)mutexKey)) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("close", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "change": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    Tab subTab = (Tab)this.getControl("tabap");
                    subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.changeNode(this.getPageCache().get("nodeId"));
                    break;
                }
                Tab subTab = (Tab)this.getControl("tabap");
                subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                break;
            }
            case "close": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getSpreadManager().getBook().getSheet(0).getUserObject().remove("change");
                this.getView().close();
                break;
            }
            case "refreshSpreadData": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                String nodeid = this.getPageCache().get("nodeid");
                this.changeNode(nodeid);
                break;
            }
            case "save": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                this.doSave();
                break;
            }
            case "resetSeq": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getHandel().resetSeq();
                String nodeid = this.getPageCache().get("nodeid");
                this.changeNode(nodeid);
                break;
            }
            case "modelchange": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    Tab subTab = (Tab)this.getControl("tabap");
                    subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave();
                    this.getModel().beginInit();
                    this.getModel().setValue(MODEL, (Object)this.getPageCache().get(CACHE_MODEL));
                    this.getModel().endInit();
                    this.getView().updateView();
                    break;
                }
                if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getModel().beginInit();
                    this.modelChanged();
                    this.getModel().endInit();
                    break;
                }
                Tab subTab = (Tab)this.getControl("tabap");
                subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                this.getModel().beginInit();
                this.getModel().setValue(MODEL, (Object)this.getPageCache().get(CACHE_MODEL));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "schemechange": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    Tab subTab = (Tab)this.getControl("tabap");
                    subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                    TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                    tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                    this.doSave(this.getPageCache().get(CACHE_SCHEME));
                    this.getModel().beginInit();
                    this.getModel().setValue(SCHEME, (Object)this.getPageCache().get(CACHE_SCHEME));
                    this.getModel().endInit();
                    this.getView().updateView();
                    break;
                }
                if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getModel().beginInit();
                    this.schemeChanged((DynamicObject)this.getModel().getValue(SCHEME));
                    this.getModel().endInit();
                    break;
                }
                Tab subTab = (Tab)this.getControl("tabap");
                subTab.activeTab(this.getPageCache().get(CACHE_LASTTAB));
                TreeView tree = (TreeView)this.getControl(this.getPageCache().get(CACHE_LASTTREE));
                tree.focusNode(new TreeNode("0", this.getPageCache().get(CACHE_LASTNODE), ""));
                this.getModel().beginInit();
                this.getModel().setValue(SCHEME, (Object)this.getPageCache().get(CACHE_SCHEME));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "forceReleaseMutex": {
                String mutexKey = this.getMutexKey();
                MutexServiceHelper.release((String)mutexKey, (String)"di_membermapping", (String)"edit");
                this.mutexControl();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"close".equals(itemKey)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.getModel().getValue(SCHEME) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"IsRpaSchemePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            TreeView tree = this.getCurrentTree();
            String selectedNodeId = tree.getTreeState().getFocusNodeId();
            if (StringUtils.isNotEmpty((String)selectedNodeId)) {
                this.checkDimMapping(Long.parseLong(selectedNodeId));
            }
        }
        switch (itemKey) {
            case "btn_import": {
                DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
                String status = scheme.getString("status");
                if ("0".equals(status)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ISDimMemberAndComSettingPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "btn_refresh": 
            case "btn_resetseq": {
                String ta = this.getCurTree();
                TreeView tree = (TreeView)this.getControl(ta);
                List selectedNodeId = tree.getTreeState().getSelectedNodeId();
                this.getPageCache().put("nodeid", (String)selectedNodeId.get(0));
                break;
            }
        }
    }

    private String getCurTree() {
        String ta = this.getCurrentTab();
        if (TAB_COMBO.equals(ta)) {
            return TREE_COMBO;
        }
        if (TAB_SPECIAL.equals(ta)) {
            return TREE_SPECIAL;
        }
        return TREE_SIMPLE;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.doSave();
                break;
            }
            case "btn_import": {
                if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\u3002", (String)"ISDimMemberAndComSettingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importDimMembers();
                break;
            }
            case "btn_export": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("di_dimmappingf7");
                showParameter.setMultiSelect(true);
                showParameter.setFormId("bos_listf7");
                showParameter.setLookUp(true);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                Long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
                showParameter.setCustomParam("schemeId", (Object)schemeId);
                OpenStyle openStyle = showParameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960");
                css.setHeight("580");
                openStyle.setInlineStyleCss(css);
                showParameter.setShowTitle(false);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimMapCallBack"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btn_refresh": {
                this.checkChange();
                break;
            }
            case "btn_resetseq": {
                this.resetSeq();
            }
        }
    }

    private void checkChange() {
        String mutexKey = this.getPageCache().get(PAGECACHE_LOCKED);
        if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null && StringUtils.isNotEmpty((String)mutexKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4fee\u6539\uff0c\u8981\u653e\u5f03\u4fee\u6539\u7684\u5185\u5bb9\u76f4\u63a5\u5237\u65b0\u5417\uff1f", (String)"RptAdjustOffsetPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refreshSpreadData", (IFormPlugin)this));
        } else {
            String nodeId = this.getPageCache().get("nodeid");
            this.changeNode(nodeId);
        }
    }

    private void resetSeq() {
        String currentTab = this.getCurrentTab();
        if (TAB_SPECIAL.equals(currentTab)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7279\u6b8a\u6620\u5c04\u4e0d\u652f\u6301\u91cd\u7f6e\u6392\u5e8f\u3002", (String)"ISDimMappingPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String mutexKey = this.getPageCache().get(PAGECACHE_LOCKED);
        if (StringUtils.isNotEmpty((String)mutexKey)) {
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("save", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u7f6e\u987a\u5e8f\u4f1a\u6e05\u9664\u81ea\u5b9a\u4e49\u6392\u5e8f\uff0c\u662f\u5426\u6267\u884c\uff1f", (String)"ISDimMappingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("resetSeq", (IFormPlugin)this));
            }
        }
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            Cell cell = this.getSpreadManager().getBook().getSheet(0).getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            StatusBarModel statusBarModel = new StatusBarModel();
            if (cell.getValue() != null) {
                statusBarModel.setCellNameStr(cell.getValue() + "");
            } else {
                statusBarModel.setCellNameStr("");
            }
            SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), this.getSpreadKey(), statusBarModel);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsPreInsert(excuteinfo)) {
                return;
            }
            this.updateRowAndCol(excuteinfo);
            this.getSpreadManager().getBook().getSheet(0).putUserObject("change", (Object)true);
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> this.getHandel().beforeUpdateMulValue(e));
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> this.getHandel().afterUpdataValue((EventObject)e));
    }

    private boolean checkIsPreInsert(AskExcuteInfo excuteinfo) {
        Integer[] preRow = new Integer[]{0, 1};
        if (excuteinfo.getOperationdata().contains(preRow[0]) || excuteinfo.getOperationdata().contains(preRow[1])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u9884\u7f6e\u7684\u884c\u5217\u4e0d\u80fd\u5220\u9664\u3002", (String)"ISDimMemberAndComSettingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public String getModelNumber() {
        return MemberReader.findModelNumberById((Object)this.getModelId());
    }

    private void modelChanged() {
        DIUserSelectUtil.propertyChangedModelUse(this.getView(), Collections.emptyList());
        this.getModel().setValue(SCHEME, null);
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        if (this.getMemAndComVO() != null) {
            this.getHandel().clearSpread();
        }
        SpreadManager sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        this.cacheSpreadModel(sm);
        this.getPageCache().remove(CACHE_SELECTNODE);
        this.getPageCache().remove(CACHE_LASTNODE);
        this.getView().updateView();
        this.releaseLock();
        this.mutexControl();
    }

    private void schemeChanged(DynamicObject scheme) {
        DIUserSelectUtil.propertyChangedUse(this.getView(), SCHEME, scheme, false, false);
        if (this.getMemAndComVO() != null) {
            this.getHandel().clearSpread();
        }
        SpreadManager sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        this.cacheSpreadModel(sm);
        this.getPageCache().remove(CACHE_SELECTNODE);
        this.getPageCache().remove(CACHE_LASTNODE);
        if (scheme == null) {
            TreeView tree = this.getCurrentTree();
            tree.deleteAllNodes();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_COMBO, TAB_SPECIAL});
        } else {
            this.setTabVisible(scheme);
            this.initTree(scheme);
        }
        this.releaseLock();
        this.mutexControl();
    }

    private void setTabVisible(DynamicObject scheme) {
        boolean hasSpecial = DIIntegrationUtil.getSpecialMappingStatus((Long)scheme.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(hasSpecial), new String[]{TAB_SPECIAL});
        QFilter filters = new QFilter(SCHEME, "=", (Object)scheme.getLong("id"));
        filters.and("mappedtype", "=", (Object)DimMappTypeEnum.COMBO.getCode());
        boolean existCombo = QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filters.toArray());
        this.getView().setVisible(Boolean.valueOf(existCombo), new String[]{TAB_COMBO});
    }

    private void initTree(DynamicObject scheme) {
        TreeNode focusNode;
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04", (String)"ISDimMemberAndComSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        ArrayList<TreeNode> children = root.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>(10);
            root.setChildren(children);
        }
        MappingContext context = new MappingContext(scheme);
        MappingService service = new MappingService(context);
        DynamicObject[] dimMappings = service.querySimpleDimmapping();
        List<DynamicObject> mappings = this.getMappings(dimMappings);
        for (DynamicObject mapping : mappings) {
            TreeNode temp = new TreeNode();
            temp.setId(mapping.getString("id"));
            if (StringUtils.isEmpty((String)mapping.getString("name"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DIMemberMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String text = service.getDimMappingName(mapping.getString("number"));
            temp.setText(text);
            temp.setParentid(root.getId());
            children.add(temp);
        }
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.setRootVisible(false);
        TreeNode treeNode = focusNode = children.size() > 0 ? (TreeNode)children.get(0) : root;
        if (this.getPageCache().get(CACHE_SELECTNODE) != null) {
            focusNode = new TreeNode(root.getId(), this.getPageCache().get(CACHE_SELECTNODE), "");
        }
        tree.focusNode(focusNode);
        this.treeNodeClickDo(new TreeNodeEvent((Object)tree, (Object)focusNode.getParentid(), (Object)focusNode.getId()));
    }

    private String getTreeNodeName(String number) {
        return "";
    }

    public void treeNodeClickDo(TreeNodeEvent evt) {
        String lastNode = this.getPageCache().get(CACHE_LASTNODE);
        String nodeId = (String)evt.getNodeId();
        String mutexKey = this.getPageCache().get(PAGECACHE_LOCKED);
        if (!nodeId.equals(lastNode)) {
            if (this.getSpreadManager().getBook().getSheet(0).getUserObject("change") != null && StringUtils.isNotEmpty((String)mutexKey)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"ISDimMemberAndComSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("change", (IFormPlugin)this));
                this.getPageCache().put("nodeId", nodeId);
            } else {
                this.changeNode(nodeId);
            }
        }
    }

    private List<DynamicObject> getMappings(DynamicObject[] dimMappings) {
        String tab = this.getCurrentTab();
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>(16);
        if (TAB_SIMPLE.equals(tab)) {
            for (DynamicObject mapping : dimMappings) {
                String dimType = mapping.getString("mappedtype");
                if (!DimMappTypeEnum.SIMPLE.getCode().equals(dimType)) continue;
                int targetSize = mapping.getDynamicObjectCollection("isdimmaptargentry").size();
                int srcSize = mapping.getDynamicObjectCollection("isdimmapsrcentry").size();
                if (targetSize == 0 || srcSize == 0) continue;
                String targetDim = mapping.getString("number").split("-")[0];
                map.computeIfAbsent(targetDim, l -> new ArrayList());
                List mappings = (List)map.get(targetDim);
                mappings.add(mapping);
            }
        } else if (TAB_COMBO.equals(tab)) {
            for (DynamicObject mapping : dimMappings) {
                String dimType = mapping.getString("mappedtype");
                if (!DimMappTypeEnum.COMBO.getCode().equals(dimType)) continue;
                String targetDim = mapping.getString("number");
                map.computeIfAbsent(targetDim, l -> new ArrayList());
                List mappings = (List)map.get(targetDim);
                mappings.add(mapping);
            }
        } else if (TAB_SPECIAL.equals(tab)) {
            for (DynamicObject mapping : dimMappings) {
                String dimType = mapping.getString("mappedtype");
                if (!DimMappTypeEnum.SPECIAL.getCode().equals(dimType)) continue;
                String targetDim = mapping.getString("number");
                map.computeIfAbsent(targetDim, l -> new ArrayList());
                List mappings = (List)map.get(targetDim);
                mappings.add(mapping);
            }
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        map.forEach((k, v) -> result.addAll((Collection<DynamicObject>)v));
        return result;
    }

    private void exportDimMembers(List<Long> dimMapIds) {
        Long schemeid = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        String schemeName = ((DynamicObject)this.getModel().getValue(SCHEME)).getString("name");
        DIMemberMapExportImp exportService = new DIMemberMapExportImp();
        XSSFWorkbook workbook = exportService.exportData(schemeid, this.getModelNumber(), dimMapIds);
        try {
            String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u6210\u5458\u6620\u5c04\u5bfc\u51fa", (String)"DIMemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeName));
            this.downloadFile(url, "di_membermapping", "1G2FW/G3YIL8");
            if (exportService.getErrors().size() > 0) {
                String errors = String.join((CharSequence)";", exportService.getErrors());
                this.getView().showTipNotification(errors);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"DIMemberMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void importDimMembers() {
        Long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        String schemeName = ((DynamicObject)this.getModel().getValue(SCHEME)).getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_memberimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04", (String)"DIMemberMappingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("schemeName", (Object)schemeName);
        showParameter.setCustomParam("modelNumber", (Object)this.getModelNumber());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importCloseCallBack"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("importCloseCallBack")) {
            this.getHandel().buildSpread();
        } else if (actionId.equals("dimMapCallBack")) {
            ListSelectedRowCollection dimMaps = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == dimMaps) {
                return;
            }
            List<Long> dimMapIds = Arrays.stream(dimMaps.getPrimaryKeyValues()).map(x -> LongUtil.toLong((Object)x)).collect(Collectors.toList());
            if (dimMapIds.size() == 0) {
                return;
            }
            this.exportDimMembers(dimMapIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeNode(String nodeId) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85", (String)"ISDimMemberAndComSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        try {
            boolean isFomula = nodeId.contains(TAIL);
            long selectId = isFomula ? Long.parseLong(nodeId.substring(0, nodeId.length() - TAIL.length())) : Long.parseLong(nodeId);
            if (selectId != 0L) {
                this.checkDimMapping(selectId);
                log.startWatch();
                this.memandcomvo = this.geneMemVO(selectId, isFomula);
                log.warn("dimMemberAndCom: create memandcomvo");
                this.getHandel().buildSpread();
                log.warn("dimMemberAndCom: buildSpread");
            }
            this.getPageCache().put(CACHE_SELECTNODE, nodeId);
            this.getPageCache().put(CACHE_LASTTAB, this.getCurrentTab());
            this.getPageCache().put(CACHE_LASTTREE, this.getCurrentTree().getKey());
            this.getPageCache().put(CACHE_LASTNODE, nodeId);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void checkDimMapping(long selectId) {
        if (this.getModelNumber().contains("930UnitTest12")) {
            return;
        }
        TreeView treeView = this.getCurrentTree();
        Map node = treeView.getTreeState().getFocusNode();
        QFilter filters = new QFilter("id", "=", (Object)selectId);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)"id, name, number", (QFilter[])filters.toArray());
        if (dyn != null) {
            MappingContext context = new MappingContext((DynamicObject)this.getModel().getValue(SCHEME));
            MappingService service = new MappingService(context);
            String name = service.getDimMappingName(dyn.getString("number"));
            if (!name.equals(node.get("text"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6210\u5458\u6620\u5c04\u9875\u9762\u3002", (String)"DIMemberMappingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6210\u5458\u6620\u5c04\u9875\u9762\u3002", (String)"DIMemberMappingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void doSave() {
        boolean enable = ((DynamicObject)this.getModel().getValue(SCHEME)).getBoolean("enable");
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DIMemberMappingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), COMMEM_SPREAD, params);
    }

    private void doSave(String schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(schemeId), (String)"bcm_isscheme");
        boolean enable = scheme.getBoolean("enable");
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DIMemberMappingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), COMMEM_SPREAD, params);
    }

    public void actionSave(String spreadJson) {
        this.getHandel().actionSave();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject(SCHEME);
        scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, modifier, modifytime", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{scheme.getLong("id")}).toArray());
        scheme.set("modifier", (Object)RequestContext.get().getUserId());
        scheme.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
    }

    private MappingContext getMappingContext() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        MappingContext context = null;
        if (scheme != null) {
            context = new MappingContext(scheme);
        }
        return context;
    }

    private MemAndComVO geneMemVO(Long selectId, boolean isFomula) {
        MemAndComVO generateMemAndComVO;
        try {
            generateMemAndComVO = MappingService.generateMemAndComVO((Long)selectId);
        }
        catch (IllegalAccessError e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6210\u5458\u6620\u5c04\u9875\u9762\u3002", (String)"DIMemberMappingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (generateMemAndComVO != null && generateMemAndComVO.getType() != MemAndComVO.VOEnum.M) {
            if (isFomula) {
                generateMemAndComVO.setType(MemAndComVO.VOEnum.C3);
            } else {
                MappingContext context = this.getMappingContext();
                if (context != null && context.isSrcNg()) {
                    generateMemAndComVO.setType(MemAndComVO.VOEnum.C2);
                }
            }
        }
        this.getPageCache().put(CACHE_MEMANDCOMVO, this.toByteSerialized(generateMemAndComVO));
        return generateMemAndComVO;
    }

    public MemAndComVO getMemAndComVO() {
        if (this.memandcomvo != null) {
            return this.memandcomvo;
        }
        String serial = this.getPageCache().get(CACHE_MEMANDCOMVO);
        if (!StringUtils.isNotEmpty((String)serial)) {
            return null;
        }
        this.memandcomvo = (MemAndComVO)this.deSerializedBytes(serial);
        return this.memandcomvo;
    }

    private DiAbstractMemMapSheetHandel getHandel() {
        return MapViewManager.getDiViewHandel(this);
    }

    public SpreadManager getSpreadManager() {
        if (this.spreadManager == null) {
            String serial = this.getPageCache().get("KEY_SPREAD_MODEL");
            if (StringUtils.isNotEmpty((String)serial)) {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)serial);
            } else {
                this.spreadManager = new SpreadManager(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u6210\u5458\u6620\u5c04", (String)"DIMemberMappingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSerial(this.spreadManager));
            }
        }
        return this.spreadManager;
    }

    @Override
    public SpreadManager getSpreadModel() {
        return this.getSpreadManager();
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.spreadManager = spread;
        this.getPageCache().put("KEY_SPREAD_MODEL", this.getSpreadModelSerial(spread));
    }

    public String getSpreadModelSerial(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    private String getCurrentTab() {
        Tab subTab = (Tab)this.getControl("tabap");
        return subTab.getCurrentTab();
    }

    private TreeView getCurrentTree() {
        String treeKey = null;
        switch (this.getCurrentTab()) {
            case "simpletab": {
                treeKey = TREE_SIMPLE;
                break;
            }
            case "combotab": {
                treeKey = TREE_COMBO;
                break;
            }
            case "specialtab": {
                treeKey = TREE_SPECIAL;
            }
        }
        if (treeKey != null) {
            return (TreeView)this.getControl(treeKey);
        }
        throw new KDBizException("not find currentTree: " + this.getCurrentTab());
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        this.getHandel().spreadF7LookUpData(args);
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        this.getHandel().setSpreadF7Item(arg);
    }

    private Boolean checkAndSetWritePermission() {
        Long modelId;
        if (this.getModel().getValue(MODEL) == null || this.getModel().getValue(SCHEME) == null) {
            return false;
        }
        long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        Boolean hasWritePermission = DIIntegrationUtil.isWriteSchemePerm((long)schemeId, (long)(modelId = Long.valueOf(this.getModelId())));
        if (!hasWritePermission.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "btn_import", "btn_resetseq", "tabap"});
        }
        return hasWritePermission;
    }
}

