/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.model.AbstractModelOlapOperation;
import kd.fi.bcm.formplugin.model.ModelOlapOperationPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class DIModelOlapPlugin
extends AbstractModelOlapOperation {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ModelOlapOperationPlugin.class);
    private static final String CACHECLEARCONFIG = "cacheClearConfig";
    private static final String PREDIMENSIONSCOPE = "preDimensionScope";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setParentPageData();
        this.getModelOlapScheme();
        this.initPassValue();
        this.hidePreDimension();
    }

    private void setParentPageData() {
        this.getPageCache().put(CACHECLEARCONFIG, (String)this.getFormCustomParam(CACHECLEARCONFIG));
        this.getPageCache().put(PREDIMENSIONSCOPE, (String)this.getFormCustomParam(PREDIMENSIONSCOPE));
    }

    private void hidePreDimension() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.ENTITY.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.YEAR.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.PERIOD.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.SCENARIO.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.CURRENCY.getNumber().toLowerCase()});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear_" + DimEntityNumEnum.PROCESS.getNumber().toLowerCase()});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)"btn_ok")) {
            this.getModelOlapScheme().setResolveParams(this.getMultiF7Param());
            this.finalSetClearConfig();
            this.getView().close();
        }
    }

    private void finalSetClearConfig() {
        LinkedHashMap cacheMap = new LinkedHashMap();
        String clearConfig = this.getView().getPageCache().get(CACHECLEARCONFIG);
        this.getView().getParentView().getPageCache().get(CACHECLEARCONFIG);
        if (StringUtils.isNotEmpty((String)clearConfig)) {
            cacheMap = (LinkedHashMap)JSONObject.parseObject((String)clearConfig, LinkedHashMap.class);
        }
        Map dataMap = new HashMap(16);
        String preDimensionScopeStr = this.getView().getPageCache().get(PREDIMENSIONSCOPE);
        if (StringUtils.isNotEmpty((String)preDimensionScopeStr)) {
            dataMap = (Map)JSONObject.parseObject((String)preDimensionScopeStr, LinkedHashMap.class);
        }
        for (Dimension dim : this.getSchemeContext().getDimensions()) {
            String value = (String)this.getModel().getValue("clear_" + dim.getNumber().toLowerCase(Locale.ENGLISH));
            if (!StringUtils.isEmpty((String)value)) continue;
            cacheMap.remove(dim.getNumber());
            dataMap.remove(dim.getNumber());
        }
        this.getView().getParentView().getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString((Object)cacheMap));
        this.getView().getParentView().getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        DynamicObjectCollection returnDatas = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        Dimension dim = this.getSchemeContext().getDimensionByNumber(actionId.split("\\_")[1]);
        DimensionScope dimensionScope = new DimensionScope(Long.toString(this.getModelId()), dim, returnDatas);
        this.cacheClearConfig(dim, returnDatas, dimensionScope);
        this.setDimensionRangeContainNumber(actionId, dimensionScope);
        this.cacheModelOlapScheme();
    }

    private void cacheClearConfig(Dimension dim, DynamicObjectCollection returnDatas, DimensionScope dimensionScope) {
        LinkedHashMap cacheMap = new LinkedHashMap();
        String clearConfig = this.getView().getPageCache().get(CACHECLEARCONFIG);
        if (StringUtils.isNotEmpty((String)clearConfig)) {
            cacheMap = (LinkedHashMap)JSONObject.parseObject((String)clearConfig, LinkedHashMap.class);
        }
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("dimList", this.getDimList(returnDatas));
        innerMap.put("dimDescription", dim.getName() + "|" + dimensionScope.toString());
        cacheMap.put(dim.getNumber(), innerMap);
        this.getView().getPageCache().put(CACHECLEARCONFIG, JSONObject.toJSONString((Object)cacheMap));
        Map<String, Map<Long, Integer>> dataMap = this.getDataMap(dim.getNumber(), returnDatas);
        this.getView().getPageCache().put(PREDIMENSIONSCOPE, JSONObject.toJSONString(dataMap));
    }

    private JSONArray getDimList(DynamicObjectCollection returnDatas) {
        JSONArray ja = new JSONArray();
        JSONObject jo = null;
        for (DynamicObject dynamicObject : returnDatas) {
            jo = new JSONObject();
            jo.put("id", (Object)dynamicObject.getLong("mid1"));
            jo.put("number", (Object)dynamicObject.getString("mnum1"));
            jo.put("scope", (Object)dynamicObject.getString("filltypevalue1"));
            ja.add((Object)jo);
        }
        return ja;
    }

    private Map<String, Map<Long, Integer>> getDataMap(String dimtype, DynamicObjectCollection returnDatas) {
        String dimensionScopeStr = this.getView().getPageCache().get(PREDIMENSIONSCOPE);
        Map<Object, Object> dataMap = new HashMap(16);
        if (StringUtils.isNotEmpty((String)dimensionScopeStr)) {
            dataMap = this.turnDataMap(dimensionScopeStr);
        }
        HashMap<Long, Integer> dimMembers = new HashMap<Long, Integer>();
        for (DynamicObject dynamicObject : returnDatas) {
            dimMembers.put(Long.parseLong(String.valueOf(dynamicObject.getLong("mid1"))), dynamicObject.getInt("filltypevalue1"));
        }
        dataMap.put(dimtype, dimMembers);
        return dataMap;
    }

    private Map<String, Map<Long, Integer>> turnDataMap(String dimensionScopeStr) {
        this.getModelOlapScheme().getSchemeDetails();
        Map dataMap = (Map)JSONObject.parseObject((String)dimensionScopeStr, Map.class);
        HashMap<String, Map<Long, Integer>> newDataMap = new HashMap<String, Map<Long, Integer>>();
        Map newMapInner = null;
        for (Map.Entry map : dataMap.entrySet()) {
            for (Map.Entry mapInner : ((Map)map.getValue()).entrySet()) {
                newMapInner = newDataMap.computeIfAbsent((String)map.getKey(), (Function<String, Map<Long, Integer>>)((Function<String, Map>)k -> new HashMap()));
                newMapInner.put(Long.parseLong(String.valueOf(mapInner.getKey())), Integer.parseInt(String.valueOf(mapInner.getValue())));
            }
        }
        return newDataMap;
    }

    private Map<String, Set<String>> getMultiF7Param() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        boolean isAllEqual = true;
        for (Dimension dimension : this.getSchemeContext().getDimensions()) {
            String clearKey = "clear_" + dimension.getNumber().toLowerCase(Locale.ENGLISH);
            DimensionScope clearDS = this.getDimensionRange(clearKey);
            if (clearDS == null) continue;
            Set scopes = clearDS.getResolveScopes();
            if ("Process".equals(dimension.getNumber())) {
                this.replaceProcess(scopes);
            }
            result.put(clearKey, scopes);
        }
        return result;
    }

    private void replaceProcess(Set<String> process) {
        if (CollectionUtils.isNotEmpty(process)) {
            if (process.remove("EIRpt")) {
                process.add("IRpt");
            }
            if (process.remove("ERAdj")) {
                process.add("RAdj");
            }
        }
    }
}

