/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIBaseEntAutoCreateService;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class DISBaseEntQueryListPlugin
extends DIAbstractListPlugin {
    private static final String ctl_model = "model";
    private static final String ctl_discheme = "discheme";
    private static final String CTL_ENTRYENTITY = "entryentity";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BAR_ADD = "add";
    private static final String BAR_DELETE = "delete";
    private static final String IS_CHANGED = "ischanged";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(Collections.emptyList(), false);
        this.autoCreateISBaseEntList();
        this.actionRefresh();
        this.setControlComboxItems();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "model": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (newValue != null && !newValue.getPkValue().equals(oldValue == null ? null : oldValue.getPkValue())) {
                    this.propertyChangedModelUse(Collections.emptyList());
                }
                this.actionRefresh();
                this.setControlComboxItems();
                break;
            }
            case "discheme": {
                if (this.getModelId() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
                DynamicObject newValue2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValue2 = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (newValue2 != null && !newValue2.getPkValue().equals(oldValue2 == null ? null : oldValue2.getPkValue())) {
                    this.propertyChangedUse("scheme", newValue2, false, false);
                }
                this.autoCreateISBaseEntList();
                this.actionRefresh();
                this.setControlComboxItems();
                break;
            }
            case "name": 
            case "number": 
            case "entitynumber": {
                String newVal = (String)e.getChangeSet()[0].getNewValue();
                String oldVal = (String)e.getChangeSet()[0].getOldValue();
                if (StringUtils.equals((CharSequence)newVal, (CharSequence)oldVal)) break;
                this.getModel().setValue(IS_CHANGED, (Object)"1", e.getChangeSet()[0].getRowIndex());
                if (!key.equals("number") || !StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("name", e.getChangeSet()[0].getRowIndex())))) break;
                this.getModel().setValue("name", (Object)this.getSyncBaseInfo().get(newVal), e.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit bdEdit = (BasedataEdit)this.getControl(ctl_discheme);
        if (bdEdit != null) {
            bdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.validate(true)) {
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (ctl_discheme.equals(key)) {
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qf = new QFilter(ctl_model, "=", (Object)this.getModelId()).and("templatecatalog.type", "=", (Object)"2").and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qf));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (!this.validate(true) && !"btn_exit".equals(key)) {
            return;
        }
        switch (key) {
            case "btn_save": {
                this.actionSave();
                this.actionRefresh();
                break;
            }
            case "btn_refresh": {
                if (this.isModifyStatus()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"DISBaseEntQueryListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.actionRefresh();
                break;
            }
            case "add": 
            case "delete": {
                break;
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isModifyStatus()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"DISBaseEntQueryListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    private Boolean isWritePermButtonEnable() {
        if (this.validate(false)) {
            Long modelId = this.getModelId();
            Long schemeId = this.getSchemeId();
            Boolean flag = DIIntegrationUtil.isWriteSchemePerm((long)schemeId, (long)modelId);
            if (!flag.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BAR_ADD, BAR_DELETE, CTL_ENTRYENTITY});
            }
            return flag;
        }
        return false;
    }

    private boolean validate(boolean showMsg) {
        if (!showMsg) {
            return this.getModel().getValue(ctl_model) != null && this.getModel().getValue(ctl_discheme) != null;
        }
        if (this.getModel().getValue(ctl_model) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(ctl_discheme) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"DISBaseEntQueryListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isModifyStatus() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
        return entryEntity.stream().anyMatch(e -> "1".equals(e.getString(IS_CHANGED)));
    }

    private void resetChanged() {
        int size = this.getModel().getEntryEntity(CTL_ENTRYENTITY).size();
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue(IS_CHANGED, (Object)"0", i);
        }
    }

    private void actionRefresh() {
        QFilter qFilter;
        DynamicObjectCollection docs;
        this.getModel().deleteEntryData(CTL_ENTRYENTITY);
        if (this.validate(false) && CollectionUtils.isNotEmpty((Collection)(docs = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,name,number,scheme,entitynumber,issys", (QFilter[])(qFilter = new QFilter("scheme", "=", (Object)this.getSchemeId())).toArray())))) {
            this.getModel().batchCreateNewEntryRow(CTL_ENTRYENTITY, docs.size());
            for (int index = 0; index < docs.size(); ++index) {
                this.getModel().setValue("id", (Object)((DynamicObject)docs.get(index)).getLong("id"), index);
                this.getModel().setValue("name", (Object)((DynamicObject)docs.get(index)).getString("name"), index);
                this.getModel().setValue("number", (Object)((DynamicObject)docs.get(index)).getString("number").toLowerCase(Locale.ENGLISH), index);
                this.getModel().setValue("entitynumber", (Object)((DynamicObject)docs.get(index)).getString("entitynumber"), index);
                this.getModel().setValue("issys", (Object)((DynamicObject)docs.get(index)).getString("issys"), index);
                this.getModel().setValue(IS_CHANGED, (Object)"0", index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"number", "entitynumber"});
            }
        }
        if (this.isWritePermButtonEnable().booleanValue()) {
            this.isSchemeEnable();
        }
    }

    private boolean isSchemeEnable() {
        QFilter qFilter = new QFilter("id", "=", (Object)this.getSchemeId());
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"id,status", (QFilter[])qFilter.toArray());
        boolean flag = scheme == null || "1".equals(scheme.getString("status"));
        this.getView().setEnable(Boolean.valueOf(!flag), new String[]{BTN_SAVE, BAR_ADD, BAR_DELETE, CTL_ENTRYENTITY});
        return flag;
    }

    private void setControlComboxItems() {
        ComboEdit textField = (ComboEdit)this.getControl("number");
        Map<String, String> syncBaseInfo = this.getSyncBaseInfo();
        ArrayList itemList = new ArrayList(syncBaseInfo.size());
        syncBaseInfo.forEach((number, name) -> itemList.add(new ComboItem(new LocaleString(number), number)));
        textField.setComboItems(itemList);
    }

    private boolean validateBaseData() {
        if (this.isSchemeEnable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\u5e76\u4fdd\u5b58\u3002", (String)"DISBaseEntQueryListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
        HashSet numberRepeatCheck = new HashSet(16);
        HashSet nameRepeatCheck = new HashSet(16);
        entryEntity.forEach(e -> {
            if (StringUtils.isEmpty((CharSequence)e.getString("name")) ^ StringUtils.isEmpty((CharSequence)e.getString("number"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DISBaseEntQueryListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getString("seq")));
            }
            if (numberRepeatCheck.contains(e.getString("number"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7f16\u7801\u91cd\u590d\u3002", (String)"DISBaseEntQueryListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getString("seq")));
            }
            if (nameRepeatCheck.contains(e.getString("name"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u540d\u79f0\u91cd\u590d\u3002", (String)"DISBaseEntQueryListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getString("seq")));
            }
            numberRepeatCheck.add(e.getString("number"));
            nameRepeatCheck.add(e.getString("name"));
        });
        return true;
    }

    private boolean validateNonRef(Collection<DynamicObject> delDy) {
        Map<Long, String> maps = delDy.stream().collect(Collectors.toMap(e -> e.getLong("id"), v -> v.getString("number")));
        Map<String, List<Long>> deriverRule = this.queryRef(maps.keySet(), "di_deriverule", "entryentity.basefield");
        StringBuilder sb = new StringBuilder();
        deriverRule.forEach((k, v) -> {
            String msg = String.join((CharSequence)",", v.stream().map(maps::get).collect(Collectors.toList()));
            sb.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5df2\u88ab\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DISBaseEntQueryListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg, k)).append("\n");
        });
        Map<String, List<Long>> srcDims = this.queryRef(maps.keySet(), "bcm_isdimmap", "isdimmapsrcentry.srcdimension");
        srcDims.forEach((k, v) -> {
            String msg = String.join((CharSequence)",", v.stream().map(maps::get).collect(Collectors.toList()));
            sb.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5df2\u88ab\u6e90\u7ef4\u5ea6\u6620\u5c04\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DISBaseEntQueryListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg, k)).append("\n");
        });
        if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
            throw new KDBizException(sb.toString());
        }
        return true;
    }

    private Map<String, List<Long>> queryRef(Collection<Long> delIds, String entityNumber, String filterField) {
        HashMap<String, List<Long>> res = new HashMap<String, List<Long>>();
        QFilter qf = new QFilter("scheme", "=", (Object)this.getSchemeId());
        QFilter qf1 = new QFilter(filterField, "in", delIds);
        DynamicObjectCollection dimMapDys = QueryServiceHelper.query((String)entityNumber, (String)("id,number,name," + filterField), (QFilter[])new QFilter[]{qf, qf1});
        if (!dimMapDys.isEmpty()) {
            for (DynamicObject dimMapDy : dimMapDys) {
                Long id = dimMapDy.getLong(filterField);
                res.computeIfAbsent(dimMapDy.getString("number"), e -> new ArrayList(1)).add(id);
            }
        }
        return res;
    }

    private void actionSave() {
        if (this.validateBaseData()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
            ArrayList updateDys = new ArrayList(10);
            ArrayList insertDys = new ArrayList(10);
            QFilter qf1 = new QFilter("scheme", "=", (Object)((DynamicObject)this.getModel().getValue(ctl_discheme)).getLong("id"));
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_isbaseentlist");
            DynamicObject[] oldDyss = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)String.join((CharSequence)",", dataEntityType.getAllFields().keySet()), (QFilter[])qf1.toArray());
            Map<String, DynamicObject> numberDys = Arrays.stream(oldDyss).collect(Collectors.toMap(k -> k.getString("number").toLowerCase(Locale.ENGLISH), v -> v, (v1, v2) -> v2));
            entryEntity.forEach(e -> {
                DynamicObject oldDy = (DynamicObject)numberDys.remove(e.getString("number"));
                if ("1".equals(e.getString(IS_CHANGED))) {
                    if (oldDy != null) {
                        oldDy.set("number", e.get("number"));
                        oldDy.set("name", e.get("name"));
                        updateDys.add(oldDy);
                    } else {
                        insertDys.add(this.createNewDy((DynamicObject)e));
                    }
                }
            });
            this.validateNonRef(numberDys.values());
            try (TXHandle tx = TX.required();){
                try {
                    List delIds = numberDys.values().stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    if (!delIds.isEmpty()) {
                        QFilter qf = new QFilter("id", "in", delIds).and("scheme", "=", (Object)this.getSchemeId());
                        DeleteServiceHelper.delete((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{qf});
                    }
                    if (!updateDys.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])updateDys.toArray(new DynamicObject[updateDys.size()]));
                    }
                    if (!insertDys.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])insertDys.toArray(new DynamicObject[insertDys.size()]));
                    }
                    this.resetChanged();
                }
                catch (Exception e2) {
                    tx.markRollback();
                    log.error((Throwable)e2);
                    throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"DISBaseEntQueryListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[]{e2.getMessage()}));
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DISBaseEntQueryListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private DynamicObject createNewDy(DynamicObject dy) {
        DynamicObject newDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isbaseentlist"));
        newDy.set("number", dy.get("number"));
        newDy.set("name", dy.get("name"));
        newDy.set("scheme", this.getModel().getValue(ctl_discheme));
        newDy.set("issys", (Object)Boolean.FALSE);
        newDy.set("entitynumber", null);
        newDy.set("creator", (Object)RequestContext.get().getUserId());
        newDy.set("createtime", (Object)TimeServiceHelper.now());
        return newDy;
    }

    private void autoCreateISBaseEntList() {
        if (this.validate(false)) {
            new DIBaseEntAutoCreateService(this.getSchemeId()).excute();
        }
    }

    private Map<String, String> getSyncBaseInfo() {
        long schemeId = this.getSchemeId();
        return (Map)ThreadCache.get((Object)("scheme-" + schemeId), () -> {
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"datasrctype,sourceobj,extendstable,extendsmodel,modelconfig.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            if (query != null) {
                String dataSrcType = query.getString("datasrctype");
                if (query.get("sourceobj") != null && DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
                    long srcObj = query.getLong("sourceobj");
                    DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcObj, (String)"isc_metadata_schema", (String)"group,prop_entryentity.prop_name,prop_entryentity.prop_label");
                    DynamicObjectCollection prop_entryentity = src.getDynamicObjectCollection("prop_entryentity");
                    prop_entryentity.forEach(p -> dataMap.put(p.getString("prop_name").toLowerCase(Locale.ENGLISH), p.getString("prop_label").toLowerCase(Locale.ENGLISH)));
                } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
                    String extendstable = query.getString("extendstable");
                    if (StringUtils.isNotEmpty((CharSequence)extendstable) && DB.getTables((DBRoute)BCMConstant.DBROUTE).stream().anyMatch(e -> e.equalsIgnoreCase(extendstable))) {
                        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)extendstable);
                        columnNames.forEach(e -> dataMap.put(e.toLowerCase(Locale.ENGLISH), e.toLowerCase(Locale.ENGLISH)));
                    }
                } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
                    Long modelconfigId = query.getLong("modelconfig.id");
                    this.getModelAdptorBaseList(dataMap, modelconfigId);
                }
            }
            return dataMap;
        });
    }

    private void getModelAdptorBaseList(Map<String, String> dataMap, Long ngModelId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"di_isngmodel", (String)"modelnum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ngModelId)});
        String number = dynamicObject.getString("modelnum");
        Long modelId = MemberReader.findModelIdByShowNum((String)number);
        Map dimMap = MemberReader.getDimNumberMapNameById((long)modelId);
        for (Map.Entry map : dimMap.entrySet()) {
            dataMap.put(((String)map.getKey()).toLowerCase(), (String)map.getValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("save_comfirm".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.actionSave();
            } else {
                this.resetChanged();
                this.getView().close();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        DynamicObject scheme = (DynamicObject)this.getValue(ctl_discheme);
        long schemeId = scheme == null ? 0L : scheme.getLong("id");
        e.getQFilters().add(new QFilter("scheme", "=", (Object)schemeId));
    }
}

