/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.util.ControlPropValidateUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.IOperationLog;

public class DISchemeCatalogEditPlugin
extends AbstractBaseFormPlugin
implements IOperationLog {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getModel().setValue("model", map.get("model"));
            this.getModel().setValue("parent", map.get("parent"));
            this.getModel().setValue("type", map.get("type"));
        } else if (OperationStatus.EDIT.equals((Object)status)) {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_schemecatalog", (String)"id,name,number,parent,type,model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)map.getOrDefault("id", 0L))});
            this.getModel().setValue("model", dy.get("model"));
            this.getModel().setValue("parent", dy.get("parent"));
            this.getModel().setValue("type", dy.get("type"));
            this.getModel().setValue("name", dy.get("name"));
            this.getModel().setValue("number", dy.get("number"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Long id = this.getFormCustomParam("id", 0L);
        if ("btn_ok".equals(key) && this.validate()) {
            DynamicObject dy = null;
            if (id != null && id != 0L) {
                dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getBizEntityNumber());
                dy.set("name", this.getValue("name"));
            } else {
                dy = BusinessDataServiceHelper.newDynamicObject((String)this.getBizEntityNumber());
                dy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                dy.set("number", this.getValue("number"));
                dy.set("name", this.getValue("name"));
                dy.set("model", this.getValue("model"));
                dy.set("parent", this.getValue("parent"));
                dy.set("type", this.getValue("type"));
                dy.set("creator", (Object)RequestContext.get().getCurrUserId());
                dy.set("createtime", (Object)TimeServiceHelper.now());
                dy.set("enable", (Object)"1");
            }
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            this.getView().returnDataToParent(Collections.singletonList(dy.getLong("id")));
            this.getView().close();
        }
    }

    private boolean validate() {
        Optional showTipMesg = ControlPropValidateUtil.validateData((IDataModel)this.getModel());
        if (showTipMesg.isPresent()) {
            this.getView().showTipNotification((String)showTipMesg.get());
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)(this.getModel().getValue("number") + ""))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long id = this.getFormCustomParam("id", 0L);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        QFilter filter1 = new QFilter("number", "=", this.getValue("number"));
        QFilter filter2 = new QFilter("name", "=", (Object)this.getValue("name").toString());
        QFilter filter3 = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter filter4 = new QFilter("id", "!=", (Object)id);
        QFilter typeQf = new QFilter("type", "=", (Object)"2");
        StringBuilder msg = new StringBuilder();
        boolean isEdit = QueryServiceHelper.exists((String)this.getBizEntityNumber(), (Object)id);
        boolean numberFlag = false;
        if (!isEdit) {
            QFilter[] qFilters1 = new QFilter[]{filter1, filter3, typeQf};
            numberFlag = QueryServiceHelper.exists((String)this.getBizEntityNumber(), (QFilter[])qFilters1);
        }
        QFilter[] qFilters2 = new QFilter[]{filter2, filter3, filter4, typeQf};
        boolean nameFlag = QueryServiceHelper.exists((String)this.getBizEntityNumber(), (QFilter[])qFilters2);
        if (nameFlag && numberFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        } else if (numberFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        } else if (nameFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg.toString());
            return false;
        }
        return true;
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_schemecatalog";
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }
}

