/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ExecuteOperationEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.intergration.scheme.ISSchemeCollectLogPlugin;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DISchemeCollectLogPlugin
extends DIAbstractListPlugin
implements HyperLinkClickListener {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ISSchemeCollectLogPlugin.class);
    private static final String CTL_BILLLISTAP = "billlistap";
    private static int i = 0;
    private static final String BTN_DELETE = "btn_delete";
    private static final String f7CACHEKEY = "f7Cache";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period", "currency"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeF7 = (BasedataEdit)this.getControl("scheme");
        schemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, String> f7KeyMap = new HashMap<String, String>();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            for (String key : dimKeys) {
                String f7id = UserSelectUtil.getF7SelectId(this.getView(), key);
                if (StringUtils.isEmpty((CharSequence)f7id)) continue;
                f7KeyMap.put(key, f7id);
            }
        }
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelid)) {
            this.getPageCache().put("KEY_MODEL_ID", modelid);
        } else {
            this.refreshBillByUserSelect(dimKeys, false);
        }
        if (!this.isExitModel()) {
            return;
        }
        this.initF7FromParent();
        this.setOrgTemFilter();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String key = arg0.getProperty().getName();
        String modelid = UserSelectUtil.getF7SelectId(this.getView(), "model");
        if (key.equals("scheme") && !StringUtils.isEmpty((CharSequence)modelid)) {
            QFilter filter = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong((Object)modelid));
            QFilter filterDi = new QFilter("issrc.number", "like", (Object)"DI%");
            QFilter[] filters = new QFilter[]{filter, filterDi};
            String selectFields = "id, name, number,templatecatalog,versionnumber,issrc.number";
            ArrayList result = new ArrayList(10);
            DynamicObjectCollection schemeEntityNew = QueryServiceHelper.query((String)"bcm_isscheme", (String)selectFields, (QFilter[])filters);
            if (this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
                ArrayList schemeIds = new ArrayList(schemeEntityNew.size());
                schemeEntityNew.forEach(schemeDyn -> schemeIds.add(schemeDyn.getLong("id")));
                String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
                String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                schemeEntityNew.forEach(scheme -> {
                    if (schemeIds.contains(scheme.getLong("id"))) {
                        result.add(scheme.getLong("id"));
                    }
                });
                QFilter f7filter = new QFilter("id", "in", result);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{f7filter}), null));
            }
        }
    }

    public boolean isExitModel() {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        return !StringUtils.isEmpty((CharSequence)modelid);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
    }

    private void initF7FromParent() {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")))) {
            return;
        }
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        Object yearId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.YEAR.getNumber());
        Object periodId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.PERIOD.getNumber());
        Object sceneId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.SCENARIO.getNumber());
        Object currencyId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.CURRENCY.getNumber());
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", sceneId);
        this.getModel().setValue("year", yearId);
        this.getModel().setValue("period", periodId);
        this.getModel().setValue("currency", currencyId);
        Object schemeId = this.getView().getFormShowParameter().getCustomParams().get("scheme");
        if (schemeId != null && schemeId != "") {
            this.getModel().setValue("scheme", schemeId);
        }
    }

    private void setOrgTemFilter() {
        Map tmap = this.getView().getFormShowParameter().getCustomParams();
        QFilter filter = null;
        if (!ObjectUtils.isEmpty(tmap.get("orgNumbers")) && !ObjectUtils.isEmpty(tmap.get("temNumbers"))) {
            JSONArray json = (JSONArray)tmap.get("orgNumbers");
            if (json.size() > 0) {
                filter = new QFilter("org.number", "in", (Object)json.toArray());
            }
            if ((json = (JSONArray)tmap.get("temNumbers")).size() > 0) {
                if (filter != null) {
                    filter.and(new QFilter("scheme.number", "in", (Object)json.toArray()));
                } else {
                    filter = new QFilter("scheme.number", "in", (Object)json.toArray());
                }
            }
        }
        BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
        if (filter != null) {
            billList.setFilter(filter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Map f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7CACHEKEY), Map.class);
        if ("model".equals(key)) {
            DynamicObject newValue2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue2 != null && e.getChangeSet()[0].getOldValue() != null) {
                this.getModel().setValue("scheme", null);
            }
            this.modelChange(f7KeyMap);
        } else if ("scenario".equals(key)) {
            this.getModel().setValue("period", null);
            this.propertyChangedUse(key, (DynamicObject)e.getChangeSet()[0].getNewValue(), false, false);
        } else if (dimKeys.contains(key) && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.propertyChangedUse(key, (DynamicObject)e.getChangeSet()[0].getNewValue(), false, true);
        }
        this.refreshBillList();
    }

    private void modelChange(Map<String, Object> f7KeyMap) {
        this.propertyChangedModelUse(dimKeys);
        f7KeyMap.clear();
        this.refreshCurrency();
    }

    private void refreshCurrency() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter currencyFilter = new QFilter("number", "=", (Object)CurrencyEnum.EC.getNumber());
        DynamicObject currencyDy = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, currencyFilter});
        if (currencyDy != null) {
            this.getModel().setValue("currency", (Object)currencyDy.getLong("id"));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_export": {
                this.actionExport();
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
        }
    }

    private void actionDelete() {
        List<Long> ids = this.getSelectIds();
        if (ids == null || ids.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DISchemeCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getModel().getValue("year") == null || this.getModel().getValue("period") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u671f\u95f4\u3002", (String)"ISSchemeCollectLogPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkDeleteStatus(ids)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u6570\u636e\u5417\uff1f", (String)"DISchemeCollectLogPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            return;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DISchemeCollectLogPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private boolean checkDeleteStatus(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.exists((String)"di_isschemecollectlog", (QFilter[])qFilter.toArray());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && BTN_DELETE.equals(callBackId)) {
            this.deleteRecord();
        }
    }

    private void deleteByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DeleteServiceHelper.delete((String)"di_isschemecollectlog", (QFilter[])new QFilter[]{qFilter});
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DataCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private List<Long> getSelectIds() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if (selectRows == null || selectRows.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ISSchemeCollectLogPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        selectRows.forEach(row -> ids.add((Long)row.getPrimaryKeyValue()));
        return ids;
    }

    private void deleteRecord() {
        try (TXHandle tx = TX.required();){
            try {
                List<Long> ids = this.getSelectIds();
                this.deleteByIds(ids);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private boolean checkParams(boolean showMsg) {
        Object model = this.getModel().getValue("model");
        Object scene = this.getModel().getValue("scenario");
        Object year = this.getModel().getValue("year");
        Object period = this.getModel().getValue("period");
        if (model == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f53\u7cfb", (String)"ISSchemeCollectLogPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (scene == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u60c5\u666f", (String)"ISSchemeCollectLogPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (year == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d22\u5e74", (String)"ISSchemeCollectLogPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (period == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u671f\u95f4", (String)"ISSchemeCollectLogPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
        billList.clearSelection();
        billList.setOrderBy("collecttime desc");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterList = e.getQFilters();
        QFilter dimFilter = this.getDimsQilter();
        filterList.add(dimFilter);
        Long modelId = this.getModelId();
        if (modelId != null && modelId != 0L) {
            filterList.add(new QFilter("model", "=", (Object)modelId));
            QFilter orgMeberFilter = this.getNoPermMemberFilter(modelId);
            if (orgMeberFilter != null) {
                filterList.add(orgMeberFilter);
            }
        }
        if (!this.checkParams(false)) {
            filterList.add(new QFilter("1", "=", (Object)0));
        }
    }

    private QFilter getDimsQilter() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        String currencyId = UserSelectUtil.getF7SelectId(this.getView(), "currency");
        String schemeId = UserSelectUtil.getF7SelectId(this.getView(), "scheme");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            filter.and(new QFilter("1", "=", (Object)0));
            return filter;
        }
        filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
        if (!StringUtils.isEmpty((CharSequence)schemeId)) {
            filter.and(new QFilter("scheme", "=", (Object)LongUtil.toLong((Object)schemeId)));
        }
        if (!StringUtils.isEmpty((CharSequence)scenarioId)) {
            filter.and(new QFilter("scenario", "=", (Object)LongUtil.toLong((Object)scenarioId)));
        }
        if (!StringUtils.isEmpty((CharSequence)yearId)) {
            filter.and(new QFilter("fy", "=", (Object)LongUtil.toLong((Object)yearId)));
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            filter.and(new QFilter("period", "=", (Object)LongUtil.toLong((Object)periodId)));
        }
        if (!StringUtils.isEmpty((CharSequence)currencyId)) {
            filter.and(new QFilter("currency", "=", (Object)LongUtil.toLong((Object)currencyId)));
        }
        return filter;
    }

    private QFilter getNoPermMemberFilter(Long modelId) {
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        QFilter filter = null;
        if (!modelIds.contains(modelId)) {
            Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.ENTITY.getNumber());
            filter = PermissionServiceImpl.getInstance((Long)modelId).getReadOrWritePermFilter(dimId, "bcm_entitymembertree", "org");
        }
        return filter;
    }

    private void actionExport() {
        if (!this.checkParams(true)) {
            return;
        }
        String url = this.handleExportData();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            this.downloadFile(url, "di_isschemeloglist", "1G2FW/G3YIL8");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleExportData() {
        DynamicObjectCollection toExportData;
        String selectFields = "org.number,org.name,step,collectorstate,error,spend,collector.name,collecttime,scheme.name,importmode,currency.name,preschemename,schemeparam";
        QFilter qFilter = this.getDimsQilter();
        ListSelectedRowCollection selectedRows = this.getBillListAp().getSelectedRows();
        if (!selectedRows.isEmpty()) {
            List ids = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            qFilter.and("id", "in", ids);
        }
        if ((toExportData = QueryServiceHelper.query((String)"di_isschemecollectlog", (String)selectFields, (QFilter[])new QFilter[]{qFilter})) == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ISSchemeCollectLogPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (toExportData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ISSchemeCollectLogPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.handToExportData(toExportData);
        try (SXSSFWorkbook workBook = new SXSSFWorkbook(100);){
            CellStyle style = workBook.createCellStyle();
            DataFormat dataFormat = workBook.createDataFormat();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setDataFormat(dataFormat.getFormat("@"));
            CellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            SXSSFSheet sheet = workBook.createSheet();
            List<String> headerList = this.getColNames();
            int rowNum = 0;
            SXSSFRow headerRow1 = sheet.createRow(rowNum);
            for (int i = 0; i < headerList.size(); ++i) {
                SXSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(headerList.get(i));
                cell.setCellStyle(headerStyle);
            }
            ++rowNum;
            String[] split = selectFields.split(",");
            headerList.clear();
            Collections.addAll(headerList, split);
            Collections.sort(toExportData, (p1, p2) -> p2.getDate("collecttime").compareTo(p1.getDate("collecttime")));
            Object string = toExportData.iterator();
            while (true) {
                SXSSFRow xssfRow;
                ArrayList row2;
                if (string.hasNext()) {
                    DynamicObject rowData = (DynamicObject)string.next();
                    row2 = Lists.newArrayListWithExpectedSize((int)headerList.size());
                    for (int i = 0; i < headerList.size(); ++i) {
                        row2.add(rowData.get(headerList.get(i)));
                    }
                    xssfRow = sheet.createRow(rowNum);
                } else {
                    string = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u91c7\u96c6\u65e5\u5fd7", (String)"ISSchemeCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return string;
                }
                for (int j = 0; j < row2.size(); ++j) {
                    SXSSFCell cell = xssfRow.createCell(j);
                    Object obj = row2.get(j);
                    if (obj != null && !StringUtils.isEmpty((CharSequence)obj.toString())) {
                        Object anEnum;
                        if ("checkstate".equals(headerList.get(j))) {
                            anEnum = CheckStatusEnum.getEnum((Integer)Integer.valueOf(obj.toString()));
                            if (anEnum != null) {
                                obj = anEnum.getName();
                            }
                        } else if ("collectorstate".equals(headerList.get(j))) {
                            CollectStatusEnum collectStatusEnum = CollectStatusEnum.getEnum((Integer)Integer.valueOf(obj.toString()));
                            if (collectStatusEnum != null) {
                                obj = collectStatusEnum.getName();
                            }
                        } else if ("step".equals(headerList.get(j))) {
                            anEnum = ExecuteOperationEnum.getEnum((String)obj.toString());
                            if (anEnum != null) {
                                obj = anEnum.getName();
                            }
                        } else if ("scheme.versionnumber".equals(headerList.get(j))) {
                            obj = "V" + obj;
                        } else if ("importmode".equals(headerList.get(j))) {
                            anEnum = ISImpModeEnum.getNameByCode((String)obj.toString());
                            if (anEnum != null) {
                                obj = anEnum;
                            }
                        }
                        cell.setCellValue(obj.toString() != null && obj.toString().length() > 500 ? obj.toString().substring(0, 500) : obj.toString());
                    }
                    cell.setCellStyle(style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private BillList getBillListAp() {
        return (BillList)this.getView().getControl(CTL_BILLLISTAP);
    }

    private void handToExportData(DynamicObjectCollection toExportData) {
        for (DynamicObject dynamicObject : toExportData) {
            Object schemeName = dynamicObject.get("scheme.name");
            if (schemeName != null) continue;
            dynamicObject.set("scheme.name", dynamicObject.get("preschemename"));
            dynamicObject.set("preschemename", null);
        }
    }

    private List<String> getColNames() {
        ArrayList<String> colNames = new ArrayList<String>(10);
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        List listFields = billList.getShowListColumns();
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("checkstate");
        ignoreSet.add("clearconfig");
        ignoreSet.add("impmodedimmem");
        ignoreSet.add("preschemenumber");
        ignoreSet.add("preschemename");
        ignoreSet.add("preschemeversion");
        for (IListColumn listField : listFields) {
            if (listField.getListFieldKey().equals("batch") || ignoreSet.contains(listField.getListFieldKey())) continue;
            colNames.add(listField.getCaption().getLocaleValue());
        }
        return colNames;
    }

    public void packageData(PackageDataEvent e) {
        String key = ((ColumnDesc)e.getSource()).getKey();
        if ("scheme.name".equals(key)) {
            this.setSchemeAttr(e, "preschemename");
        } else if ("scheme.versionnumber".equals(key)) {
            this.setSchemeAttr(e, "preschemeversion");
        }
    }

    private void setSchemeAttr(PackageDataEvent e, String type) {
        if (e.getFormatValue() != null) {
            return;
        }
        e.setFormatValue((Object)e.getRowData().getString(type));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList list = (BillList)this.getControl(CTL_BILLLISTAP);
        Object id = list.getFocusRowPkId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("di_collectlogeerrorinfo");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setCustomParam("id", id);
        this.getView().showForm(parameter);
    }
}

