/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.service.DIIntegrateDispatcher2;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SearchResult;
import kd.fi.bcm.formplugin.eventcenter.BaseDataImportHelper;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class DISchemeDataCollectListPlugin
extends DIAbstractListPlugin
implements CountDownListener,
HyperLinkClickListener {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DISchemeDataCollectListPlugin.class);
    private static final String ctl_entryentity = "entryentity";
    private static final String entry_scheme = "schemename";
    private static final String entry_org = "org";
    private static final String entry_collectstatus = "collectstatus";
    private static final String entry_step = "step";
    private static final String entry_modifier = "modifier";
    private static final String entry_modifydate = "modifydate";
    private static final String entry_optime = "optimestr";
    private static final String entry_enddate = "enddate";
    private static final String entry_exeip = "exeip";
    private static final String entry_exeid = "exeid";
    private static final String IS_SYNBASE = "is_synbase";
    private static final List<String> f7KEYS = Arrays.asList("model", "scenario", "year", "period", "currency");
    private static final List<String> dimKeys = Arrays.asList("scenario", "year", "period", "currency");
    private static final String treeview_scheme = "treeview_scheme";
    private static final String treeview_entity = "treeview_entity";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String CACHE_ORG_ID = "cache_org_id";
    private static final String CACHE_SCHEME_ID = "cache_scheme_id";
    private static final String ROOT_NODE_ID = "rootNodeid";
    private static final String CACHE_SHOW_ORG_TYPE = "showorgtype";
    private static final String CACHE_SHOW_SCHEDULE_TYPE = "showscheduletype";
    private static final String cache_scheme_ids = "cache_scheme_ids";
    private static final String ALL = "*";
    private static final String currency = "currency";
    private static final String f7CACHEKEY = "f7Cache";
    private static final String[] arr = new String[]{"Entity", "Scenario", "Year", "Period", "AuditTrail", "Process"};

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("imageup", "imagedown", "schemeimageup", "schemeimagedown");
        Search schemesearchap = this.getCurrencySearch();
        schemesearchap.addEnterListener(var1 -> {
            String text = var1.getText();
            if (text != null && !"".equals(text)) {
                this.searchTemplate(text.trim());
            } else {
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        TreeView tree = this.getCurrentTree();
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DISchemeDataCollectListPlugin.this.refreshEntryEntity();
                IPageCache pageCache = DISchemeDataCollectListPlugin.this.getPageCache();
                if (DISchemeDataCollectListPlugin.this.isEntityTab()) {
                    pageCache.put(DISchemeDataCollectListPlugin.CACHE_ORG_ID, String.valueOf(evt.getNodeId()));
                    UserSelectServiceHelper.setEntity((Long)DISchemeDataCollectListPlugin.this.getUserId(), (Long)DISchemeDataCollectListPlugin.this.getModelId(), (Object)String.valueOf(evt.getNodeId()));
                    DISchemeDataCollectListPlugin.this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(DISchemeDataCollectListPlugin.CACHE_SCHEME_ID, String.valueOf(evt.getNodeId()));
                }
            }
        });
        Tab subTab = (Tab)this.getControl("tabap");
        subTab.addTabSelectListener(arg0 -> {
            DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
            this.refreshLeftTree(modelDyn.getLong("id"));
            this.refreshEntryEntity();
        });
        EntryGrid billList = (EntryGrid)this.getView().getControl(ctl_entryentity);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.addCountDownListener((CountDownListener)this);
    }

    public void onCountDownEnd(CountDownEvent evt) {
        Long scenceId;
        Long yearId = this.getModel().getValue("year") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("year")).getLong("id"));
        Long periodId = this.getModel().getValue("period") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("period")).getLong("id"));
        Long l2 = scenceId = this.getModel().getValue("scenario") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("scenario")).getLong("id"));
        if (yearId != null && periodId != null && scenceId != null) {
            QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
            QFilter scenceQf = new QFilter("scenario", "=", (Object)scenceId);
            QFilter fyQf = new QFilter("fy", "=", (Object)yearId);
            QFilter periodQf = new QFilter("period", "=", (Object)periodId);
            QFilter statusQf = new QFilter(entry_collectstatus, "in", (Object)new String[]{"2", "8"});
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)entry_collectstatus, (QFilter[])new QFilter[]{modelQf, scenceQf, fyQf, periodQf, statusQf});
            Map<String, List<DynamicObject>> collect = Arrays.asList(load).stream().collect(Collectors.groupingBy(l -> l.getString(entry_collectstatus)));
            Label label1 = (Label)this.getControl("labelap");
            Label label2 = (Label)this.getControl("labelap1");
            label1.setText(String.format(ResManager.loadKDString((String)"\u6392\u961f\u4e2d:%s", (String)"DISchemeDataCollectListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get("8") == null ? 0 : collect.get("8").size()));
            label2.setText(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4e2d:%s", (String)"DISchemeDataCollectListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect.get("2") == null ? 0 : collect.get("2").size()));
        }
        super.onCountDownEnd(evt);
        this.setTimeCount(false);
    }

    private void cacheSchemeIds(IPageCache pageCache) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ctl_entryentity);
        ArrayList ids = new ArrayList();
        entryEntity.forEach(row -> {
            DynamicObject scheme = row.getDynamicObject(entry_scheme);
            if (scheme != null) {
                ids.add(scheme.getLong("id"));
            }
        });
        pageCache.put(cache_scheme_ids, ObjectSerialUtil.toByteSerialized(ids));
    }

    private Search getCurrencySearch() {
        String control = "entitysearchap";
        if (!this.isEntityTab()) {
            control = "schemesearchap";
        }
        return (Search)this.getControl(control);
    }

    private boolean isEntityTab() {
        Tab subTab = (Tab)this.getControl("tabap");
        return "taborg".equals(subTab.getCurrentTab());
    }

    private void searchTemplate(String search) {
        TreeView tree = this.getCurrentTree();
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<String> path = new ArrayList<String>();
            this.getTreeNodeListByText(root, hitNode, search, 999, paths, path);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                result.setPath(paths);
                TreeNode next = result.next(1);
                tree.focusNode(next);
                this.refreshEntryEntity();
                IPageCache pageCache = this.getPageCache();
                if (this.isEntityTab()) {
                    pageCache.put(CACHE_ORG_ID, String.valueOf(next.getId()));
                    this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(CACHE_SCHEME_ID, String.valueOf(next.getId()));
                }
                for (String pathId : result.getPath()) {
                    tree.expand(pathId);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"DISchemeDataCollectListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    private TreeView getCurrentTree() {
        String control = "";
        control = this.isEntityTab() ? treeview_entity : treeview_scheme;
        return (TreeView)this.getControl(control);
    }

    public void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text, int maxLevel, List<String> paths, List<String> path) {
        ArrayList<String> temp = new ArrayList<String>(path);
        temp.add(node.getId());
        if (node.getText().contains(text)) {
            treeNodes.add(node);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(node);
            paths.add(String.join((CharSequence)",", temp));
        }
        if (maxLevel > 0 && node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text, maxLevel - 1, paths, temp);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(dimKeys, false);
        this.initCslschemeValue(String.valueOf(this.getModelId()), false);
        HashMap<String, String> f7KeyMap = new HashMap<String, String>();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            for (String key : f7KEYS) {
                String f7id = UserSelectUtil.getF7SelectId(this.getView(), key);
                if (StringUtils.isEmpty((CharSequence)f7id)) continue;
                f7KeyMap.put(key, f7id);
            }
        }
        String showOrgType = this.getModel().getValue(CACHE_SHOW_ORG_TYPE).toString();
        String showScheduleType = this.getModel().getValue(CACHE_SHOW_SCHEDULE_TYPE).toString();
        this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showOrgType);
        this.getPageCache().put(CACHE_SHOW_SCHEDULE_TYPE, showScheduleType);
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        this.refreshCurrency();
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        if (modelDyn != null) {
            this.refreshLeftTree(modelDyn.getLong("id"));
        }
        this.checkGradeOrgScheme();
        this.refreshEntryEntity();
        if (StringUtils.isEmpty((CharSequence)ConfigServiceHelper.getStringParamNoModel((String)"IntegrationReset"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_exeingreset", "btn_linereset"});
        }
        this.setTimeCount(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"countdownap"});
    }

    private void setTimeCount(boolean start) {
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.setDuration(3);
        if (start) {
            countdown.start();
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "imageup": 
            case "schemeimageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": 
            case "schemeimagedown": {
                this.searchNext(1);
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = this.getCurrentTree();
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DISchemeDataCollectListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DISchemeDataCollectListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                for (String id : result.getPath()) {
                    tree.expand(id);
                }
                tree.focusNode(next);
                this.refreshEntryEntity();
                if (this.isEntityTab()) {
                    pageCache.put(CACHE_ORG_ID, String.valueOf(next.getId()));
                    this.cacheSchemeIds(pageCache);
                } else {
                    pageCache.put(CACHE_SCHEME_ID, String.valueOf(next.getId()));
                }
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DISchemeDataCollectListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private TreeNode setSchemeData2View(Long modelid) {
        DynamicObjectCollection temlist = this.getSchemeColls(modelid);
        String showType = this.getPageCache().get(CACHE_SHOW_SCHEDULE_TYPE);
        if (kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)showType)) {
            showType = "1";
        }
        TreeNode rootview = this.getTemplateTree(this.mergeSchemeCatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode(), showType);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        return rootview;
    }

    public TreeNode getTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObjectCollection templateColls, List<TreeNode> templateNodeList, String rootid, TreeNode root, String showType) {
        if (templateNodeList.size() != 0) {
            root.setChildren(templateNodeList);
        }
        if (templatecatalogList.size() == 0) {
            return new TreeNode();
        }
        Iterator<Map<String, String>> iter = templatecatalogList.iterator();
        String fieldId = "";
        String fieldName = "";
        String parentid = "";
        while (iter.hasNext()) {
            Map<String, String> map = iter.next();
            fieldId = map.get("id");
            fieldName = map.get("name");
            parentid = map.get("parentid");
            if (!parentid.equals(rootid)) continue;
            if (templateColls != null && templateColls.size() > 0) {
                templateNodeList = new ArrayList<TreeNode>();
                for (DynamicObject templateObject : templateColls) {
                    String versionnumber;
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    String string = versionnumber = templateObject.getDynamicObjectType().getProperty("versionnumber") == null ? "" : String.format("V%.1f", Float.valueOf(templateObject.getBigDecimal("versionnumber").floatValue()));
                    if ("1".equals(showType)) {
                        templateNode.setText(templateObject.get("name").toString());
                    } else if ("2".equals(showType)) {
                        templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString());
                    } else {
                        templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString() + "   " + versionnumber);
                    }
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = this.getTemplateTree(templatecatalogList, templateColls, templateNodeList, fieldId, entry, showType);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            children.add(entry);
            entry.setIsOpened(true);
        }
        return root;
    }

    private DynamicObjectCollection getSchemeColls(Long modelid) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        QFilter typeFilter = new QFilter("templatecatalog.type", "=", (Object)"2");
        QFilter easPushFilter = new QFilter("datasrctype", "!=", (Object)DIDataSrcTypeEnum.EASReportPush.getValue());
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter, easPushFilter};
        String selectFields = "id, name, number,templatecatalog,versionnumber";
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectCollection schemeEntityNew = QueryServiceHelper.query((String)"bcm_isscheme", (String)selectFields, (QFilter[])filters);
        if (this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
            ArrayList schemeIds = new ArrayList(schemeEntityNew.size());
            schemeEntityNew.forEach(schemeDyn -> schemeIds.add(schemeDyn.getLong("id")));
            String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
            String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
            DIIntegrationUtil.filterSchemeByScenarioAndDate((long)this.getModelId(), (String)scenarioNum, (String)periodNum, (String)yearNum, schemeIds, (Boolean)Boolean.TRUE);
            schemeEntityNew.forEach(scheme -> {
                if (schemeIds.contains(scheme.getLong("id"))) {
                    result.add(scheme);
                }
            });
        } else {
            result.addAll((Collection)schemeEntityNew);
        }
        return result;
    }

    private List<Map<String, String>> mergeSchemeCatalogList(Long modelid) {
        DynamicObject[] doc = this.getSchemecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(16);
        for (DynamicObject dd : doc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getLocaleString("name").getLocaleValue());
            map.put("parentid", dd.getString("parent_id") == null ? "0" : dd.getString("parent_id"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObject[] getSchemecatalogList() {
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter typeFilter = new QFilter("type", "=", (Object)"2");
        QFilter[] filters = new QFilter[]{modelFilter, typeFilter};
        String selectFields = "id,parent,name";
        String orderBys = "longnumber";
        return BusinessDataServiceHelper.load((String)"bcm_schemecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    private void refreshLeftTree(Long modelId) {
        if (this.isEntityTab()) {
            AbstractTreeNode<Object> root = this.getOrgTree(modelId, this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
            if (root != null) {
                this.initOrgTree(root);
            }
        } else {
            TreeNode root = this.setSchemeData2View(modelId);
            this.initSchemeTree(root);
        }
    }

    @Override
    public CslSchemeServiceHelper.QueryOrgParam buildQueryOrgParam(long modelId, QFBuilder builder) {
        CslSchemeServiceHelper.QueryOrgParam param = super.buildQueryOrgParam(modelId, builder);
        param.setIncludeExchangeRateMembers(true);
        return param;
    }

    private void initSchemeTree(TreeNode root) {
        TreeView tree = this.getCurrentTree();
        tree.deleteAllNodes();
        tree.addNode(root);
        String orgId = this.getPageCache().get(CACHE_SCHEME_ID);
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            TreeNode findCacheNode = this.findCacheNode(root);
            tree.focusNode(findCacheNode);
        }
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)root));
        this.getPageCache().put(ROOT_NODE_ID, root.getId());
    }

    private TreeNode findCacheNode(TreeNode root) {
        String selectnode = null;
        if (this.isEntityTab()) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
            String selectedNodeId = this.getPageCache().get(CACHE_ORG_ID);
            if (!StringUtils.isEmpty((CharSequence)selectedNodeId)) {
                selectnode = selectedNodeId;
            }
        } else {
            selectnode = this.getPageCache().get(CACHE_SCHEME_ID);
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getText());
        }
        List childPathNodes = root.getChildPathNodes(selectnode);
        childPathNodes.forEach(v -> v.setIsOpened(true));
        if (childPathNodes.size() > 0) {
            return (TreeNode)childPathNodes.get(childPathNodes.size() - 1);
        }
        return new TreeNode("0", root.getId(), root.getText());
    }

    private AbstractTreeNode<Object> getOrgTree(Long modelId, String showOrgType) {
        OrgTreeNode root = super.initOrgTree(modelId, showOrgType, false, false);
        if (root != null) {
            this.getPageCache().put("treeCacheMap", ObjectSerialUtil.toByteSerialized((Object)ThreadCache.get((Object)"orgrealnames")));
        } else {
            root = new OrgTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"DISchemeDataCollectListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return root;
    }

    private void initOrgTree(AbstractTreeNode<Object> root) {
        TreeView tree = this.getCurrentTree();
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode troot = treemodel.buildEntryTree(tree);
            if (troot.getChildren() == null) {
                return;
            }
            TreeNode findCacheNode = this.findCacheNode(troot);
            tree.focusNode(findCacheNode);
            this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)troot));
            this.getPageCache().put(ROOT_NODE_ID, troot.getId());
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_collect": {
                this.actionCollect(1);
                break;
            }
            case "btn_executedetail": {
                this.executeDetail();
                break;
            }
            case "btn_collectlog": {
                this.actionCollectLog(null, null);
                break;
            }
            case "btn_refresh": {
                this.actionRefresh();
                break;
            }
            case "btn_exeingreset": {
                this.reset("2");
                break;
            }
            case "btn_linereset": {
                this.reset("8");
                break;
            }
        }
    }

    private void executeDetail() {
        if (!this.validate()) {
            return;
        }
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5f85\u6267\u884c\u8bb0\u5f55\uff0c\u67e5\u770b\u6267\u884c\u8fc7\u7a0b\u8be6\u60c5\u3002", (String)"DISchemeDataCollectListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u6765\u67e5\u770b\u6267\u884c\u8fc7\u7a0b\u8be6\u60c5\u3002", (String)"DISchemeDataCollectListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObjectCollection col = new DynamicObjectCollection();
        for (int row : selectedRows) {
            col.add(dyncol.get(row));
        }
        Long schemeId = (Long)((DynamicObject)col.get(0)).get("schemename.id");
        Long orgId = (Long)((DynamicObject)col.get(0)).get("org.id");
        ReportShowParameter param = new ReportShowParameter();
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u8be6\u60c5", (String)"DISchemeDataCollectListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setFormId("di_executdetailreport");
        param.setCustomParam("modelId", (Object)this.getModelId());
        param.setCustomParam("scenarioId", (Object)this.getMemberId("scenario"));
        param.setCustomParam("yearId", (Object)this.getMemberId("year"));
        param.setCustomParam("yearNumber", (Object)this.getMemberNumber("year"));
        param.setCustomParam("periodId", (Object)this.getMemberId("period"));
        param.setCustomParam("periodNumber", (Object)this.getMemberNumber("period"));
        param.setCustomParam("currencyId", (Object)this.getMemberId(currency));
        param.setCustomParam("cslschemeId", (Object)this.getMemberId("cslscheme"));
        param.setCustomParam("schemeId", (Object)schemeId);
        param.setCustomParam("orgId", (Object)orgId);
        param.setCustomParam("executeId", (Object)this.getExecuteId(schemeId, orgId));
        this.getView().showForm((FormShowParameter)param);
    }

    private String getMemberNumber(String name) {
        return this.getModel().getValue(name) == null ? "" : ((DynamicObject)this.getModel().getValue(name)).getString("number");
    }

    private Long getExecuteId(Long schemeId, Long orgId) {
        if (this.existExecuteLine(schemeId, orgId).booleanValue()) {
            return this.queryExecuteId(schemeId, orgId);
        }
        return this.addExecuteLine(schemeId, orgId);
    }

    private Long addExecuteLine(Long schemeId, Long orgId) {
        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schemeexecuterec");
        Long id = GlobalIdUtil.genGlobalLongId();
        dynaObj.set("id", (Object)id);
        dynaObj.set("model", (Object)this.getMemberId("model"));
        dynaObj.set("scenario", (Object)this.getMemberId("scenario"));
        dynaObj.set("fy", (Object)this.getMemberId("year"));
        dynaObj.set("period", (Object)this.getMemberId("period"));
        dynaObj.set(currency, (Object)this.getMemberId(currency));
        dynaObj.set(entry_org, (Object)orgId);
        dynaObj.set("scheme", (Object)schemeId);
        SaveServiceHelper.save((IDataEntityType)dynaObj.getDynamicObjectType(), (Object[])new Object[]{dynaObj});
        return id;
    }

    private Long queryExecuteId(Long schemeId, Long orgId) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bcm_schemeexecuterec", (String)"id", (QFilter[])this.getFilters(schemeId, orgId));
        return object.getLong("id");
    }

    private Boolean existExecuteLine(Long schemeId, Long orgId) {
        return QueryServiceHelper.exists((String)"bcm_schemeexecuterec", (QFilter[])this.getFilters(schemeId, orgId));
    }

    private QFilter[] getFilters(Long schemeId, Long OrgId) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.getMemberId("model"));
        QFilter scenarioQFilter = new QFilter("scenario", "=", (Object)this.getMemberId("scenario"));
        QFilter yearQFilter = new QFilter("fy", "=", (Object)this.getMemberId("year"));
        QFilter periodQFilter = new QFilter("period", "=", (Object)this.getMemberId("period"));
        QFilter currencyQFilter = new QFilter(currency, "=", (Object)this.getMemberId(currency));
        QFilter orgQFilter = new QFilter(entry_org, "=", (Object)OrgId);
        QFilter schemeQFilter = new QFilter("scheme", "=", (Object)schemeId);
        QFilter[] filters = new QFilter[]{modelQFilter, scenarioQFilter, yearQFilter, periodQFilter, currencyQFilter, orgQFilter, schemeQFilter};
        return filters;
    }

    private Long getMemberId(String name) {
        return this.getModel().getValue(name) == null ? 0L : ((DynamicObject)this.getModel().getValue(name)).getLong("id");
    }

    private void reset(String status) {
        QFilter statusQf;
        QFilter idQf;
        DynamicObject[] load;
        int[] selectedRows = this.getSelectedEntry();
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        Search schemesearchap = this.getCurrencySearch();
        String searchKey = schemesearchap.getSearchKey();
        if (StringUtils.isNotEmpty((CharSequence)searchKey) && searchKey.startsWith("#idreset#")) {
            ids.add(LongUtil.toLong((Object)searchKey.replace("#idreset#", "")));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchKey) && searchKey.startsWith("#iddelete#")) {
            DeleteServiceHelper.delete((String)"bcm_schemeexecuterec", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)searchKey.replace("#iddelete#", "")))});
        }
        for (int row : selectedRows) {
            ids.add(((DynamicObject)dyncol.get(row)).getLong(entry_exeid));
        }
        if (ids.size() > 0 && (load = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)"id, collectstatus", (QFilter[])new QFilter[]{idQf = new QFilter("id", "in", ids), statusQf = new QFilter(entry_collectstatus, "=", (Object)status)})).length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.set(entry_collectstatus, (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
        logger.info("is open isIntegrationResetNum:" + ConfigServiceHelper.getGlobalBoolParam((String)"isIntegrationResetNum"));
        if (ConfigServiceHelper.getGlobalBoolParam((String)"isIntegrationResetNum")) {
            this.resetCount();
        }
        this.refreshEntryEntity();
    }

    private void resetCount() {
        DynamicObjectCollection exes = QueryServiceHelper.query((String)"bcm_schemeexecuterec", (String)"id,scheme,org,scenario,fy,period,currency", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
        logger.info("isIntegrationResetNum size:" + exes.size() + ";modelid\uff1a" + this.getModelId());
        HashSet key = new HashSet();
        HashSet ids = new HashSet();
        exes.forEach(e -> {
            if (!key.add("" + e.getLong("scheme") + e.getLong(entry_org) + e.getLong("scenario") + e.getLong("fy") + e.getLong("period") + e.getLong(currency))) {
                ids.add(e.getLong("id"));
            }
        });
        logger.info("isIntegrationResetNum ids size:" + ids.size());
        if (ids.size() > 0) {
            DeleteServiceHelper.delete((String)"bcm_schemeexecuterec", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Map f7KeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(f7CACHEKEY), Map.class);
        switch (key) {
            case "model": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (newValue != null) {
                    ThreadCache.put((Object)"getModelId", (Object)newValue.getLong("id"));
                }
                this.modelChange(f7KeyMap);
                break;
            }
            case "period": 
            case "year": 
            case "scenario": 
            case "currency": {
                this.commonChange(e, key, f7KeyMap);
                break;
            }
            case "cslscheme": {
                this.saveUserChangedCslscheme((DynamicObject)e.getChangeSet()[0].getNewValue());
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
            case "allsub": {
                this.changeAllSub(e.getChangeSet()[0].getNewValue());
                break;
            }
            case "showorgtype": {
                String showType = (String)this.getModel().getValue(CACHE_SHOW_ORG_TYPE);
                this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showType);
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
            case "showscheduletype": {
                String showScheduleType = (String)this.getModel().getValue(CACHE_SHOW_SCHEDULE_TYPE);
                this.getPageCache().put(CACHE_SHOW_SCHEDULE_TYPE, showScheduleType);
                this.refreshLeftTree(this.getModelId());
                this.refreshEntryEntity();
                break;
            }
        }
    }

    private void changeAllSub(Object newValue) {
        this.refreshEntryEntity();
    }

    private void commonChange(PropertyChangedArgs e, String key, Map<String, Object> f7KeyMap) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
            return;
        }
        Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, true);
        if (!isSureReturn.booleanValue()) {
            return;
        }
        if (newValue != null) {
            f7KeyMap.put(key, newValue.getLong("id"));
        } else {
            f7KeyMap.remove(key);
        }
        this.getPageCache().put(f7CACHEKEY, SerializationUtils.toJsonString(f7KeyMap));
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.refreshLeftTree(modelDyn.getLong("id"));
        this.refreshEntryEntity();
    }

    private void modelChange(Map<String, Object> f7KeyMap) {
        this.propertyChangedModelUse(dimKeys);
        this.initCslschemeValue(String.valueOf(this.getModelId()), false);
        f7KeyMap.clear();
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue("model");
        this.refreshLeftTree(modelDyn.getLong("id"));
        this.refreshCurrency();
    }

    private void refreshCurrency() {
        if (this.getModel().getValue(currency) == null) {
            QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
            QFilter currencyFilter = new QFilter("number", "=", (Object)CurrencyEnum.EC.getNumber());
            DynamicObject currencyDy = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, currencyFilter});
            if (currencyDy != null) {
                this.getModel().setValue(currency, (Object)currencyDy.getLong("id"));
            }
        }
    }

    protected void actionCollect(int type) {
        this.doCollect(false, type);
    }

    private void doCollect(boolean isSync, int type) {
        if (!this.validate()) {
            return;
        }
        int[] selectedRows = this.getSelectedEntry();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5f85\u6267\u884c\u8bb0\u5f55\uff0c\u518d\u8fdb\u884c\u91c7\u96c6\u3002", (String)"DISchemeDataCollectListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
        if (dyncol.size() == 0) {
            return;
        }
        DynamicObjectCollection col = new DynamicObjectCollection();
        for (int row : selectedRows) {
            col.add(dyncol.get(row));
        }
        if (this.checkExistDisableScheme(col)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u88ab\u7981\u7528\u65b9\u6848\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"DISchemeDataCollectListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean synstatus = this.sysnBase(col);
        if (!synstatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5176\u5b83\u91c7\u96c6\u6b63\u5728\u540c\u6b65\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DISchemeDataCollectListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean repeatStatus = this.repeatVerification(col);
        if (repeatStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6267\u884c\u8bb0\u5f55\u6216\u8005\u4e92\u65a5\u5e01\u79cd\u7684\u6267\u884c\u8bb0\u5f55\u5305\u542b\u91c7\u96c6\u72b6\u6001\u2018\u6392\u961f\u4e2d\u2019\u6216\u2018\u6267\u884c\u4e2d\u2019\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DISchemeDataCollectListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String errMsg = this.checkSrcOrgRepeat(col);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            this.getView().showTipNotification(errMsg);
            return;
        }
        Set schemeIds = col.stream().map(d -> d.getLong("schemename.id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", schemeIds);
        Set importmodeids = QueryServiceHelper.query((String)"bcm_isscheme", (String)"importmodeid", (QFilter[])qf.toArray()).stream().map(imp -> imp.getLong("importmodeid")).collect(Collectors.toSet());
        QFilter qFilterId = new QFilter("id", "in", importmodeids);
        DynamicObjectCollection integrateimpmodes = QueryServiceHelper.query((String)"bcm_isimportmode", (String)"importmode", (QFilter[])new QFilter[]{qFilterId});
        boolean isReplaceImport = integrateimpmodes.stream().anyMatch(s -> ISImpModeEnum.REPLACEIMPORT.getCode().equals(s.getString("importmode")));
        this.cacheCollectParam(isSync, isReplaceImport, type);
        this.showAcquisitionModeForm();
    }

    private boolean checkExistDisableScheme(DynamicObjectCollection col) {
        Set schemeIds = col.stream().map(c -> c.getLong("schemename.id")).collect(Collectors.toSet());
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds), new QFilter("status", "=", (Object)"0")});
    }

    private boolean repeatVerification(DynamicObjectCollection col) {
        QFilter collectStatusQFilter;
        QFilter periodQFilter;
        QFilter yearQFilter;
        QFilter scenarioQFilter;
        HashSet<Pair> orgSchemePairs = new HashSet<Pair>();
        for (DynamicObject dynamicObject : col) {
            Pair orgSchemePair = Pair.onePair((Object)dynamicObject.getLong("org.id"), (Object)dynamicObject.getLong("schemename.id"));
            orgSchemePairs.add(orgSchemePair);
        }
        long modelId = (Long)((DynamicObject)this.getModel().getValue("model")).get("id");
        long scenarioId = (Long)((DynamicObject)this.getModel().getValue("scenario")).get("id");
        long yearId = (Long)((DynamicObject)this.getModel().getValue("year")).get("id");
        long periodId = (Long)((DynamicObject)this.getModel().getValue("period")).get("id");
        long selectCurrency = this.getModel().getValue(currency) == null ? 0L : (Long)((DynamicObject)this.getModel().getValue(currency)).get("id");
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{modelQFilter, scenarioQFilter = new QFilter("scenario", "=", (Object)scenarioId), yearQFilter = new QFilter("fy", "=", (Object)yearId), periodQFilter = new QFilter("period", "=", (Object)periodId), collectStatusQFilter = new QFilter(entry_collectstatus, "in", (Object)new String[]{"2", "8"})};
        Object[] executors = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)"id,org,scheme,collectstatus,currency", (QFilter[])filters);
        if (ObjectUtils.isEmpty((Object[])executors)) {
            return Boolean.FALSE;
        }
        Set<Long> orgSet = orgSchemePairs.stream().map(x -> (Long)x.p1).collect(Collectors.toSet());
        Map currencys = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)modelId, (Long[])orgSet.toArray(new Long[0]));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode ec = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)"EC");
        IDNumberTreeNode dc = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)"DC");
        ArrayList<Long> ecdc_id = new ArrayList<Long>(3);
        ecdc_id.add(ec.getId());
        ecdc_id.add(dc.getId());
        for (Object executor : executors) {
            long recCurrency = executor.getLong("currency_id");
            for (Pair orgSchemePair : orgSchemePairs) {
                if (!((Long)orgSchemePair.p1).equals(executor.get("org_id")) || !((Long)orgSchemePair.p2).equals(executor.get("scheme_id"))) continue;
                Long orgCur = (Long)((Pair)currencys.get((Object)orgSchemePair.p1)).p1;
                if (selectCurrency == 0L || recCurrency == 0L || selectCurrency == recCurrency) {
                    return Boolean.TRUE;
                }
                if (ecdc_id.contains(selectCurrency) && (ecdc_id.contains(recCurrency) || orgCur == recCurrency)) {
                    return Boolean.TRUE;
                }
                if (!ecdc_id.contains(recCurrency) || !ecdc_id.contains(selectCurrency) && orgCur != selectCurrency) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    protected String checkSrcOrgRepeat(DynamicObjectCollection col) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sysnBase(DynamicObjectCollection col) {
        block20: {
            boolean needSyn = false;
            for (DynamicObject object : col) {
                if (object.get("schemename.synbase") == null || !object.getBoolean("schemename.synbase")) continue;
                needSyn = true;
                break;
            }
            if (!needSyn) {
                return true;
            }
            try (DLock lock = DLock.create((String)IS_SYNBASE);){
                if (lock.tryLock(3000L)) {
                    try {
                        new BaseDataImportHelper().importBaseData(this.getModelId());
                        break block20;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void showAcquisitionModeForm() {
        boolean isReplaceImport = Boolean.parseBoolean(this.getPageCache().get("isReplaceImport"));
        String caption1 = ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u65b9\u6848\u96c6\u6210\u6a21\u5f0f\u4e3a\u66ff\u6362\u6a21\u5f0f\uff0c\u5c06\u6e05\u9664\u6570\u636e\u540e\u518d\u8fdb\u884c\u96c6\u6210\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DISchemeDataCollectListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String caption2 = ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u65b9\u6848\u96c6\u6210\u6a21\u5f0f\u4e3a\u5408\u5e76\u6a21\u5f0f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DISchemeDataCollectListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (isReplaceImport) {
            caption2 = null;
        } else {
            caption1 = null;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_acquisitionmode");
        formShowParameter.setCustomParam("msg1", (Object)caption1);
        formShowParameter.setCustomParam("msg2", (Object)caption2);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_acquisitionmode"));
        this.getView().showForm(formShowParameter);
    }

    private void cacheCollectParam(boolean isSync, boolean isReplaceImport, int param) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("isSync", String.valueOf(isSync));
        pageCache.put("isReplaceImport", String.valueOf(isReplaceImport));
        pageCache.put(DIContextParam.SERVICE_PARAM, String.valueOf(param));
    }

    private void removeCollectParamCache() {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("isSync");
        pageCache.remove("isReplaceImport");
        pageCache.remove(DIContextParam.SERVICE_PARAM);
    }

    private void collect(boolean isSync, int firstType, String serviceParam, List<Long> selectTemplate, DynamicObjectCollection col) {
        IDataModel dataModel = this.getModel();
        DynamicObject modelObj = (DynamicObject)dataModel.getValue("model");
        boolean hasShowMessage = false;
        try {
            IntegrateEntity intEntity = new IntegrateEntity();
            DynamicObject sceneObj = (DynamicObject)dataModel.getValue("scenario");
            DynamicObject yearObj = (DynamicObject)dataModel.getValue("year");
            DynamicObject periodObj = (DynamicObject)dataModel.getValue("period");
            DynamicObject currencyObj = (DynamicObject)dataModel.getValue(currency);
            intEntity.setModel(Long.valueOf(modelObj.getLong("id")), modelObj.getString("number"));
            intEntity.setScene(Long.valueOf(sceneObj.getLong("id")), sceneObj.getString("number"));
            intEntity.setYear(Long.valueOf(yearObj.getLong("id")), yearObj.getString("number"));
            intEntity.setPeriod(Long.valueOf(periodObj.getLong("id")), periodObj.getString("number"));
            intEntity.setCurrency(Long.valueOf(currencyObj == null ? 0L : currencyObj.getLong("id")), currencyObj == null ? "" : currencyObj.getString("number"));
            intEntity.putCustomParam("operation", (Object)DIOperationEnum.OpExecuteAll);
            intEntity.putCustomParam(DIContextParam.FIRST_TYPE, (Object)firstType);
            intEntity.putCustomParam(DIContextParam.SERVICE_PARAM, (Object)serviceParam);
            if (selectTemplate != null && !selectTemplate.isEmpty()) {
                intEntity.putCustomParam("selecttemplate", selectTemplate);
            }
            for (DynamicObject row : col) {
                DynamicObject orgDyn = row.getDynamicObject(entry_org);
                DynamicObject scheme = row.getDynamicObject(entry_scheme);
                intEntity.addOrgSchemePair(Long.valueOf(orgDyn.getLong("id")), orgDyn.getString("number"), Long.valueOf(scheme.getLong("id")), scheme.getString("number"));
            }
            if (!DIIntegrateDispatcher2.submitTaskDistribute((IntegrateEntity)intEntity, (boolean)isSync)) {
                this.refreshEntryEntity();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u8f83\u957f\uff0c\u5df2\u8fdb\u5165\u540e\u53f0\u6267\u884c\u4e2d\u3002\u8bf7\u67e5\u770b\u5177\u4f53\u65e5\u5fd7\u4ee5\u4e86\u89e3\u6267\u884c\u60c5\u51b5\u3002", (String)"DISchemeDataCollectListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                hasShowMessage = true;
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            } else {
                logger.error("datacollect error", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u5206\u6790\u65e5\u5fd7\u3002", (String)"DISchemeDataCollectListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.refreshEntryEntity();
            return;
        }
        Map<Integer, List<Object>> map = null;
        try {
            map = this.getlogMessageMap();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        this.refreshEntryEntity();
        if (isSync) {
            if (!hasShowMessage) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91c7\u96c6\u5b8c\u6210\u3002", (String)"DISchemeDataCollectListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String doName = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6", (String)"DISchemeDataCollectListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String doSuccesss = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u5b8c\u6210", (String)"DISchemeDataCollectListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (map != null) {
                this.printLogMessage(doName, map, doSuccesss);
            }
        } else {
            QFilter collectStatusQFilter = new QFilter(entry_collectstatus, "in", (Object)new String[]{"2", "8"});
            DynamicObject[] executors = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)"id", (QFilter[])new QFilter[]{collectStatusQFilter});
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f02\u6b65\u91c7\u96c6\u4e2d\uff0c\u8bf7\u5237\u65b0\u65e5\u5fd7\u67e5\u770b\u91c7\u96c6\u8fdb\u5ea6\uff0c\u7cfb\u7edf\u5f53\u524d\u8fd8\u6709%s\u4e2a\u4efb\u52a1\u5f85\u6267\u884c\u3002", (String)"DISchemeDataCollectListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), executors.length));
            String doName = ResManager.loadKDString((String)"\u5b9e\u65f6\u62bd\u53d6", (String)"DISchemeDataCollectListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String doSuccesss = ResManager.loadKDString((String)"\u5b9e\u65f6\u62bd\u53d6\u6210\u529f", (String)"DISchemeDataCollectListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (map != null) {
                this.printLogMessage(doName, map, doSuccesss);
            }
        }
    }

    private void printLogMessage(String doName, Map<Integer, List<Object>> map, String doSuccesss) {
        Iterator<Map.Entry<Integer, List<Object>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Object> value = iterator.next().getValue();
            String orgName = (String)value.get(0);
            String number = (String)value.get(1);
            String schemeNumber = (String)value.get(2);
            String schemeName = (String)value.get(3);
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)doName, (String)(orgName + " " + number + " " + schemeNumber + " " + schemeName + "," + doSuccesss), (Long)this.getModelId());
        }
    }

    private Map<Integer, List<Object>> getlogMessageMap() {
        int[] selectRows = this.getSelectedEntry();
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>(16);
        ArrayList<String> list = new ArrayList<String>(10);
        Integer i = 0;
        for (int selectRow : selectRows) {
            DynamicObject entryentityData = this.getModel().getEntryRowEntity(ctl_entryentity, selectRow);
            list.add(entryentityData.getString("org.number"));
            list.add(entryentityData.getString("org.name"));
            list.add(entryentityData.getString("schemename.number"));
            list.add(entryentityData.getString("schemename.name"));
            map.put(i, list);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return map;
    }

    private void actionCollectLog(Long exeId, Integer rowIndex) {
        DynamicObject sceneObj = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue(currency);
        IFormView mainPageView = this.getView().getMainView();
        if (mainPageView == null) {
            mainPageView = this.getView();
        }
        String pageId = "dischemecollectlog" + mainPageView.getPageId();
        IFormView childView = mainPageView.getView(pageId);
        if (exeId != null) {
            pageId = "dischemecollectlog" + System.currentTimeMillis();
        }
        if (childView == null || exeId != null) {
            ListShowParameter parameter = new ListShowParameter();
            HashMap<String, Object> fmap = new HashMap<String, Object>();
            this.dealWhileFilterData(fmap, rowIndex);
            parameter.getCustomParams().putAll(fmap);
            parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            parameter.setCustomParam(DimTypesEnum.YEAR.getNumber(), yearObj == null ? null : Long.valueOf(yearObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.PERIOD.getNumber(), periodObj == null ? null : Long.valueOf(periodObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.SCENARIO.getNumber(), sceneObj == null ? null : Long.valueOf(sceneObj.getLong("id")));
            parameter.setCustomParam(DimTypesEnum.CURRENCY.getNumber(), currencyObj == null ? null : Long.valueOf(currencyObj.getLong("id")));
            DynamicObjectCollection dyncol = this.getModel().getEntryEntity(ctl_entryentity);
            if (rowIndex != null && rowIndex >= 0) {
                DynamicObject schemeObj = ((DynamicObject)dyncol.get(rowIndex.intValue())).getDynamicObject(entry_scheme);
                parameter.setCustomParam("scheme", schemeObj == null ? null : Long.valueOf(schemeObj.getLong("id")));
            }
            parameter.setFormId("di_isschemeloglist");
            parameter.setPageId(pageId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCustomParam("exeId", (Object)exeId);
            IFormView appPageView = this.getView().getParentView();
            if (appPageView == null) {
                appPageView = this.getView();
            }
            appPageView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(appPageView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void actionRefresh() {
        this.refreshLeftTree(this.getModelId());
        this.refreshEntryEntity();
    }

    private void dealWhileFilterData(Map<String, Object> fmap, Integer rowIndex) {
        EntryGrid teg = (EntryGrid)this.getControl(ctl_entryentity);
        int[] sRows = teg.getSelectRows();
        HashSet<String> temNumbers = new HashSet<String>(16);
        HashSet<String> orgNumbers = new HashSet<String>();
        if (rowIndex != null) {
            temNumbers.add(this.getModel().getEntryRowEntity(ctl_entryentity, rowIndex.intValue()).getString("schemename.number"));
            orgNumbers.add(this.getModel().getEntryRowEntity(ctl_entryentity, rowIndex.intValue()).getString("org.number"));
        } else {
            for (int i : sRows) {
                temNumbers.add(this.getModel().getEntryRowEntity(ctl_entryentity, i).getString("schemename.number"));
                orgNumbers.add(this.getModel().getEntryRowEntity(ctl_entryentity, i).getString("org.number"));
            }
        }
        fmap.put("temNumbers", temNumbers);
        fmap.put("orgNumbers", orgNumbers);
    }

    private int[] getSelectedEntry() {
        EntryGrid teg = (EntryGrid)this.getControl(ctl_entryentity);
        return teg.getSelectRows();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getModelIdFilter());
    }

    private QFilter getModelIdFilter() {
        QFilter qf;
        if (this.getModel().getValue("model") == null) {
            qf = new QFilter("2", "=", (Object)1);
        } else {
            Long modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            qf = new QFilter("model", "=", (Object)modelid);
        }
        return qf;
    }

    private QFilter getMembFilter() {
        QFilter qf = null;
        if (this.getModel().getValue("scenario") == null || this.getModel().getValue("year") == null || this.getModel().getValue("period") == null) {
            qf = new QFilter("2", "=", (Object)1);
        } else {
            Long modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            qf = new QFilter("model", "=", (Object)modelid);
            Long scenarioid = ((DynamicObject)this.getModel().getValue("scenario")).getLong("id");
            qf.and(new QFilter("scenario", "=", (Object)scenarioid));
            Long fyid = ((DynamicObject)this.getModel().getValue("year")).getLong("id");
            qf.and(new QFilter("fy", "=", (Object)fyid));
            Long periodid = ((DynamicObject)this.getModel().getValue("period")).getLong("id");
            qf.and(new QFilter("period", "=", (Object)periodid));
            Long currencyid = this.getModel().getValue(currency) == null ? 0L : ((DynamicObject)this.getModel().getValue(currency)).getLong("id");
            qf.and(new QFilter(currency, "=", (Object)currencyid));
        }
        return qf;
    }

    private void refreshEntryEntity() {
        this.getModel().deleteEntryData(ctl_entryentity);
        if (!this.validateConditionNoTip()) {
            return;
        }
        TreeView tree = this.getCurrentTree();
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        String rootNodeId = this.getPageCache().get(ROOT_NODE_ID);
        if ("0".equals(focusNodeId) || StringUtils.isEmpty((CharSequence)focusNodeId)) {
            return;
        }
        if (focusNodeId.equals(rootNodeId)) {
            return;
        }
        Table<Long, Long, DynamicObject> schemeOrgIdMaps = null;
        Long focusid = LongUtil.toLong((Object)focusNodeId);
        schemeOrgIdMaps = this.isEntityTab() ? this.geneOrgEntity(focusid) : this.geneSchemeEntity(focusid);
        if (this.getModel().getValue("scenario") != null) {
            ArrayList<Long> schemeIds = new ArrayList<Long>(schemeOrgIdMaps.rowKeySet());
            String scenarioNum = ((DynamicObject)this.getModel().getValue("scenario")).getString("number");
            if (this.getModel().getValue("year") != null && this.getModel().getValue("period") != null) {
                final String yearNum = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                final String periodNum = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                DIIntegrationUtil.filterSchemeByScenarioAndDate((long)this.getModelId(), (String)scenarioNum, (String)periodNum, (String)yearNum, schemeIds, (Boolean)Boolean.TRUE);
                Long yearDimId = ((DynamicObject)this.getModel().getValue("year")).getDynamicObject("dimension").getLong("id");
                Long l = ((DynamicObject)this.getModel().getValue("period")).getDynamicObject("dimension").getLong("id");
                Pair yearMemberPair = DIIntegrationUtil.getSimpleMapAndDefaultTar((Long)yearDimId, schemeIds, (List)new ArrayList<String>(){
                    {
                        this.add(yearNum);
                    }
                });
                HashSet set = new HashSet();
                ((Map)yearMemberPair.p1).values().forEach(set::addAll);
                if (((Map)yearMemberPair.p2).get(yearNum) != null) {
                    set.removeAll((Collection)((Map)yearMemberPair.p2).get(yearNum));
                }
                Pair periodMemberPair = DIIntegrationUtil.getSimpleMapAndDefaultTar((Long)l, set, (List)new ArrayList<String>(){
                    {
                        this.add(periodNum);
                    }
                });
                HashSet set1 = new HashSet();
                ((Map)periodMemberPair.p1).values().forEach(set1::addAll);
                if (((Map)periodMemberPair.p2).get(periodNum) != null) {
                    set1.removeAll((Collection)((Map)periodMemberPair.p2).get(periodNum));
                }
                if (this.getModel().getValue(currency) != null) {
                    Long currencyDimId = ((DynamicObject)this.getModel().getValue(currency)).getDynamicObject("dimension").getLong("id");
                    final String currencyNum = ((DynamicObject)this.getModel().getValue(currency)).getString("number");
                    Pair currencyMemberPair = DIIntegrationUtil.getSimpleMapAndDefaultTar((Long)currencyDimId, set1, (List)new ArrayList<String>(){
                        {
                            this.add(currencyNum);
                        }
                    });
                    HashSet set3 = new HashSet();
                    ((Map)currencyMemberPair.p1).values().forEach(set3::addAll);
                    if (((Map)currencyMemberPair.p2).get(currencyNum) != null) {
                        set3.removeAll((Collection)((Map)currencyMemberPair.p2).get(currencyNum));
                    }
                    schemeIds = new ArrayList(set3);
                } else {
                    schemeIds = new ArrayList(set1);
                }
            } else {
                Set scenarioSchemeIds = DIIntegrationUtil.filterSchemeByScenePeriod((long)this.getModelId(), (String)scenarioNum, schemeIds);
                QFBuilder qFBuilder = new QFBuilder();
                qFBuilder.add("id", "in", (Object)scenarioSchemeIds);
                qFBuilder.add("status", "=", (Object)"1");
                DynamicObject[] dynamics = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id, number, effectivedate, expiringdate, versionnumber", (QFilter[])qFBuilder.toArray(), (String)"number asc, versionnumber desc");
                schemeIds.clear();
                for (DynamicObject dynamic : dynamics) {
                    schemeIds.add(dynamic.getLong("id"));
                }
            }
            Set sidSet = DIIntegrationUtil.filterByScenario((String)this.getCurModelNumber(), schemeIds, (String)scenarioNum);
            ArrayList needRemove = Lists.newArrayList();
            for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
                if (sidSet.contains(cell.getRowKey())) continue;
                needRemove.add(cell.getRowKey() + "_" + cell.getColumnKey());
            }
            Iterator iterator = needRemove.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                String[] idArray = s.split("_");
                schemeOrgIdMaps.remove((Object)Long.parseLong(idArray[0]), (Object)Long.parseLong(idArray[1]));
            }
        }
        int count = 0;
        if (schemeOrgIdMaps.size() <= 100) {
            if (!schemeOrgIdMaps.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(ctl_entryentity, schemeOrgIdMaps.size());
            }
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id, number, name, versionnumber", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.rowKeySet()).toArray());
            Map<Long, DynamicObject> schemeIdMap = Stream.of(schemes).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
                this.getModel().setValue(entry_scheme, cell.getRowKey(), count);
                this.getModel().setValue(entry_org, cell.getColumnKey(), count);
                this.getModel().setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(schemeIdMap.get(cell.getRowKey()).getBigDecimal("versionnumber").floatValue())), count);
                DynamicObject dynamicObject = (DynamicObject)cell.getValue();
                if (dynamicObject != null && dynamicObject.getDataEntityType().getName().equals("bcm_isschemeexecuterec")) {
                    this.getModel().setValue(entry_collectstatus, dynamicObject.get(entry_collectstatus), count);
                    this.getModel().setValue(entry_modifier, dynamicObject.get(entry_modifier), count);
                    this.getModel().setValue(entry_step, dynamicObject.get(entry_step), count);
                    Date startDate = dynamicObject.getDate(entry_modifydate);
                    Date endDate = dynamicObject.getDate("endtime");
                    this.getModel().setValue(entry_optime, dynamicObject.getDate("optime") == null ? "" : dynamicObject.getDate("optime"), count);
                    this.getModel().setValue(entry_exeip, (Object)dynamicObject.getString(entry_exeip), count);
                    this.getModel().setValue(entry_exeid, (Object)dynamicObject.getLong("id"), count);
                    this.getModel().setValue(entry_modifydate, (Object)startDate, count);
                    this.getModel().setValue(entry_enddate, (Object)endDate, count);
                    if (startDate != null && endDate != null) {
                        Long spend = endDate.getTime() - startDate.getTime();
                        StringBuffer sb = this.calculate(spend);
                        this.getModel().setValue("spend", (Object)sb.toString(), count);
                    }
                } else if (this.valicateMembConditionNoTip()) {
                    this.getModel().setValue(entry_collectstatus, (Object)1, count);
                }
                ++count;
            }
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ctl_entryentity);
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id, number, name, versionnumber", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.rowKeySet()).toArray());
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id, number, name", (QFilter[])new QFilter("id", "in", (Object)schemeOrgIdMaps.columnKeySet()).toArray());
            Map<Long, DynamicObject> map = Stream.of(schemes).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            Map<Long, DynamicObject> orgIdMap = Stream.of(orgs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            Stream.of(orgs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
                DynamicObject addNew = dynamicObjectCollection.addNew();
                addNew.set(entry_scheme, (Object)map.get(cell.getRowKey()));
                addNew.set(entry_org, (Object)orgIdMap.get(cell.getColumnKey()));
                addNew.set("versionnum", (Object)String.format("V%.1f", Float.valueOf(map.get(cell.getRowKey()).getBigDecimal("versionnumber").floatValue())));
                DynamicObject excutor = (DynamicObject)cell.getValue();
                if (excutor != null && excutor.getDataEntityType().getName().equals("bcm_isschemeexecuterec")) {
                    addNew.set(entry_collectstatus, excutor.get(entry_collectstatus));
                    addNew.set(entry_modifier, excutor.get(entry_modifier));
                    Date startDate = excutor.getDate(entry_modifydate);
                    Date endDate = excutor.getDate("endtime");
                    addNew.set(entry_optime, excutor.getDate("optime") == null ? "" : excutor.getDate("optime"));
                    addNew.set(entry_exeip, (Object)excutor.getString(entry_exeip));
                    addNew.set(entry_exeid, (Object)excutor.getLong("id"));
                    addNew.set(entry_modifydate, (Object)startDate);
                    addNew.set(entry_enddate, (Object)endDate);
                    addNew.set(entry_step, excutor.get(entry_step));
                    if (startDate == null || endDate == null) continue;
                    Long spend = endDate.getTime() - startDate.getTime();
                    StringBuffer sb = this.calculate(spend);
                    addNew.set("spend", (Object)sb.toString());
                    continue;
                }
                if (!this.valicateMembConditionNoTip()) continue;
                addNew.set(entry_collectstatus, (Object)1);
            }
            this.getView().updateView(ctl_entryentity);
        }
        if (this.isEntityTab()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgnumber", entry_org});
        }
    }

    public StringBuffer calculate(Long spend) {
        long mi = spend % 1000L;
        long se = spend / 1000L % 60L;
        long min = spend / 1000L / 60L % 60L;
        long hour = spend / 1000L / 60L / 60L;
        StringBuffer sb = new StringBuffer();
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"DISchemeDataCollectListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"DISchemeDataCollectListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (se > 0L) {
            sb.append(se).append(ResManager.loadKDString((String)"\u79d2", (String)"DISchemeDataCollectListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (mi > 0L) {
            sb.append(mi).append(ResManager.loadKDString((String)"\u6beb\u79d2", (String)"DISchemeDataCollectListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)sb.toString())) {
            sb.append(ResManager.loadKDString((String)"0\u79d2", (String)"DISchemeDataCollectListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return sb;
    }

    private Table<Long, Long, DynamicObject> geneOrgEntity(Long focusNodeId) {
        DynamicObject[] excutors;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(this.getModelIdFilter());
        qfBuilder.add(QFilter.of((String)"scheme.status = ?", (Object[])new Object[]{"1"}));
        qfBuilder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{true}));
        qfBuilder.add(QFilter.of((String)"scheme.templatecatalog.type = ?", (Object[])new Object[]{"2"}));
        qfBuilder.add(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        qfBuilder.add(QFilter.of((String)"scheme.datasrctype != ?", (Object[])new Object[]{DIDataSrcTypeEnum.EASReportPush.getValue()}));
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        DynamicObject[] schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        DynamicObject orgTemp = BusinessDataServiceHelper.loadSingle((Object)focusNodeId, (String)"bcm_entitymembertree");
        boolean allSub = (Boolean)this.getModel().getValue("allsub");
        HashMap<String, Long> orgRangeId = new HashMap<String, Long>(16);
        HashSet<String> shareOrgs = new HashSet<String>(16);
        if (!orgTemp.getBoolean("isleaf") && allSub) {
            AbstractTreeNode<Object> root = this.getOrgTree(this.getModelId(), this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
            ITreeNode treeNode = root.getTreeNode(Long.toString(focusNodeId), 999);
            this.handleALLNodes((ITreeNode<Object>)treeNode, orgRangeId, shareOrgs);
        }
        orgRangeId.put(orgTemp.getString("number"), orgTemp.getLong("id"));
        if (orgRangeId.size() == 1) {
            shareOrgs.add(orgTemp.getString("number"));
        }
        this.reSetShareOrgs(orgRangeId, shareOrgs);
        ArrayList orgNums = new ArrayList(orgRangeId.keySet());
        ArrayList schemes = new ArrayList(schemeAssignEntitys.length);
        Arrays.stream(schemeAssignEntitys).forEach(s -> schemes.add(s.getDynamicObject("scheme").getLong("id")));
        Pair orgMember2Pair = DIIntegrationUtil.getSimpleMapAndDefaultTar((Long)orgTemp.getDynamicObject("dimension").getLong("id"), schemes, orgNums);
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            Long mId = 0L;
            String mnumber = null;
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyvalue)) continue;
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.getModelId());
            rangItem.matchItems(arg_0 -> DISchemeDataCollectListPlugin.lambda$geneOrgEntity$22(orgRangeId, schemeAssign, orgMember2Pair, (Table)schemeOrgIdMaps, arg_0));
        }
        selectProperties = "scheme,org,checkstatus,collectstatus,step,batch,modifier,modifydate,endtime,optime,exeip";
        qfBuilder.clear();
        qfBuilder.add(this.getMembFilter());
        qfBuilder.add(new QFilter("scheme", "in", (Object)schemeOrgIdMaps.rowKeySet()));
        qfBuilder.add(new QFilter(entry_org, "in", (Object)schemeOrgIdMaps.columnKeySet()));
        for (DynamicObject excutor : excutors = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            Long orgId;
            Long schemeId = excutor.getLong("scheme.id");
            if (!schemeOrgIdMaps.contains((Object)schemeId, (Object)(orgId = Long.valueOf(excutor.getLong("org.id"))))) continue;
            schemeOrgIdMaps.put((Object)schemeId, (Object)orgId, (Object)excutor);
        }
        return schemeOrgIdMaps;
    }

    private void reSetShareOrgs(Map<String, Long> orgRangeId, Set<String> shareOrgs) {
        if (shareOrgs.size() > 0) {
            QFBuilder qfBuilder1 = new QFBuilder("model", "=", (Object)this.getModelId());
            qfBuilder1.add("number", "in", shareOrgs);
            qfBuilder1.add("storagetype", "in", (Object)StorageTypeEnum.STORAGE.index);
            DynamicObject[] baseOrgs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])qfBuilder1.toArray());
            Arrays.stream(baseOrgs).forEach(d -> orgRangeId.put(d.getString("number"), d.getLong("id")));
        }
    }

    private void handleALLNodes(ITreeNode<Object> node, Map<String, Long> orgRangeId, Set<String> shareOrgs) {
        OrgTreeNode orgNode = (OrgTreeNode)node;
        orgRangeId.put(((OrgTreeNode)node).getNumber(), LongUtil.toLong((Object)node.getId()));
        if (!StorageTypeEnum.STORAGE.index.equals(orgNode.getStoragetype())) {
            shareOrgs.add(orgNode.getNumber());
        }
        if (!node.isLeaf()) {
            node.getChildren().forEach(children -> this.handleALLNodes((ITreeNode<Object>)children, orgRangeId, shareOrgs));
        }
    }

    private Table<Long, Long, DynamicObject> geneSchemeEntity(Long focusNodeId) {
        DynamicObject[] excutors;
        HashBasedTable schemeOrgIdMaps;
        QFilter qf = new QFilter("templatecatalog", "=", (Object)focusNodeId);
        qf.and("datasrctype", "!=", (Object)DIDataSrcTypeEnum.EASReportPush.getValue());
        qf.or("id", "=", (Object)focusNodeId);
        qf.and("status", "=", (Object)"1");
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{this.getModelIdFilter(), qf});
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(this.getModelIdFilter());
        if (schemes != null && schemes.length > 0) {
            ArrayList<Long> schemeids = new ArrayList<Long>(schemes.length);
            for (DynamicObject scheme : schemes) {
                schemeids.add(scheme.getLong("id"));
            }
            qfBuilder.add("scheme", "in", schemeids);
        } else {
            qfBuilder.add(QFilter.of((String)"scheme = ?", (Object[])new Object[]{focusNodeId}));
        }
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        DynamicObject[] schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        HashMap<String, Long> orgRangeId = new HashMap<String, Long>();
        HashSet<String> shareOrgs = new HashSet<String>(16);
        AbstractTreeNode<Object> root = this.getOrgTree(this.getModelId(), this.getPageCache().get(CACHE_SHOW_ORG_TYPE));
        this.handleALLNodes((ITreeNode<Object>)root, (Map<String, Long>)orgRangeId, (Set<String>)shareOrgs);
        this.reSetShareOrgs(orgRangeId, shareOrgs);
        HashBasedTable tempSchemeOrgIdMaps = schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            DynamicObject schemeDyn = schemeAssign.getDynamicObject("scheme");
            if (schemeDyn == null) continue;
            Long mId = 0L;
            String mnumber = null;
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.getModelId());
            rangItem.matchItems(arg_0 -> DISchemeDataCollectListPlugin.lambda$geneSchemeEntity$25(orgRangeId, (Table)tempSchemeOrgIdMaps, schemeDyn, arg_0));
        }
        Map<Long, String> shareOrg = orgRangeId.entrySet().stream().filter(arg_0 -> DISchemeDataCollectListPlugin.lambda$geneSchemeEntity$26((Table)tempSchemeOrgIdMaps, arg_0)).collect(Collectors.toMap(k -> (Long)k.getValue(), v -> (String)v.getKey(), (v1, v2) -> v1));
        ArrayList<String> orgNums = new ArrayList<String>(shareOrg.values());
        List schemeIds = Arrays.stream(schemeAssignEntitys).map(s -> s.getDynamicObject("scheme").getLong("id")).collect(Collectors.toList());
        Pair orgMember2Pair = DIIntegrationUtil.getSimpleMapAndDefaultTar((Long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.ENTITY.getNumber()), schemeIds, orgNums);
        HashBasedTable result = HashBasedTable.create();
        for (Table.Cell c : schemeOrgIdMaps.cellSet()) {
            String orgNum = shareOrg.get(c.getColumnKey());
            if ((((Map)orgMember2Pair.p1).get(orgNum) == null || !((Set)((Map)orgMember2Pair.p1).get(orgNum)).contains(c.getRowKey())) && (((Map)orgMember2Pair.p1).get(ALL) == null || !((Set)((Map)orgMember2Pair.p1).get(ALL)).contains(c.getRowKey())) || ((Map)orgMember2Pair.p2).get(orgNum) != null && ((Set)((Map)orgMember2Pair.p2).get(orgNum)).contains(c.getRowKey())) continue;
            result.put(c.getRowKey(), c.getColumnKey(), c.getValue());
        }
        schemeOrgIdMaps = result;
        selectProperties = "org, scheme,checkstatus,collectstatus,step,batch,modifier,modifydate,endtime,optime,exeip";
        qfBuilder.clear();
        qfBuilder.add(this.getMembFilter());
        qfBuilder.add(new QFilter("scheme", "in", (Object)schemeOrgIdMaps.rowKeySet()));
        qfBuilder.add(new QFilter(entry_org, "in", (Object)schemeOrgIdMaps.columnKeySet()));
        for (DynamicObject excutor : excutors = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)selectProperties, (QFilter[])qfBuilder.toArray())) {
            Long orgId;
            Long schemeId = excutor.getLong("scheme.id");
            if (!schemeOrgIdMaps.contains((Object)schemeId, (Object)(orgId = Long.valueOf(excutor.getLong("org.id"))))) continue;
            schemeOrgIdMaps.put((Object)schemeId, (Object)orgId, (Object)excutor);
        }
        return schemeOrgIdMaps;
    }

    private boolean validateConditionNoTip() {
        return this.getModel().getValue("model") != null;
    }

    private boolean valicateMembConditionNoTip() {
        return this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null;
    }

    private boolean validate() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISchemeDataCollectListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("scenario") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"DISchemeDataCollectListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("year") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"DISchemeDataCollectListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("period") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"DISchemeDataCollectListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.equals("bcm_acquisitionmode")) {
            if (returnData == Boolean.FALSE || returnData == null) {
                this.getPageCache().remove("template");
                return;
            }
            Boolean isSync = Boolean.TRUE;
            Map dataMap = (Map)returnData;
            Integer modeType = (Integer)dataMap.get("modeType");
            Integer firstType = (Integer)dataMap.get("firstType");
            if (modeType == 1) {
                isSync = Boolean.TRUE;
            } else if (modeType == 2) {
                isSync = Boolean.FALSE;
            }
            IPageCache pageCache = this.getPageCache();
            String serviceParam = pageCache.get(DIContextParam.SERVICE_PARAM);
            this.removeCollectParamCache();
            String template = pageCache.get("template");
            List selectTemplate = template == null ? null : (List)ObjectSerialUtil.deSerializedBytes((String)template);
            pageCache.remove("template");
            DynamicObjectCollection selectRowsData = this.getSelectRowsData();
            this.collect(isSync, firstType, serviceParam, selectTemplate, selectRowsData);
        }
    }

    private DynamicObjectCollection getSelectRowsData() {
        int[] selectedRows = this.getSelectedEntry();
        DynamicObjectCollection allDc = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObjectCollection dc = new DynamicObjectCollection();
        for (int row : selectedRows) {
            dc.add(allDc.get(row));
        }
        return dc;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int rowIndex = arg0.getRowIndex();
        DynamicObjectCollection allDc = this.getModel().getEntryEntity(ctl_entryentity);
        DynamicObject dynamicObject = (DynamicObject)allDc.get(rowIndex);
        Long exeid = dynamicObject.getLong(entry_exeid);
        this.actionCollectLog(exeid, rowIndex);
    }

    private static /* synthetic */ boolean lambda$geneSchemeEntity$26(Table tempSchemeOrgIdMaps, Map.Entry o) {
        return tempSchemeOrgIdMaps.columnKeySet().contains(o.getValue());
    }

    private static /* synthetic */ void lambda$geneSchemeEntity$25(Map orgRangeId, Table tempSchemeOrgIdMaps, DynamicObject schemeDyn, SimpleItem c) {
        if (orgRangeId.containsKey(c.number)) {
            tempSchemeOrgIdMaps.put((Object)schemeDyn.getLong("id"), orgRangeId.get(c.number), (Object)schemeDyn);
        }
    }

    private static /* synthetic */ void lambda$geneOrgEntity$22(Map orgRangeId, DynamicObject schemeAssign, Pair orgMember2Pair, Table schemeOrgIdMaps, SimpleItem c) {
        if (orgRangeId.containsKey(c.number)) {
            DynamicObject scheme = schemeAssign.getDynamicObject("scheme");
            Long schemeid = scheme.getLong("id");
            if (scheme != null && (((Map)orgMember2Pair.p1).get(c.number) != null && ((Set)((Map)orgMember2Pair.p1).get(c.number)).contains(schemeid) || ((Map)orgMember2Pair.p1).get(ALL) != null && ((Set)((Map)orgMember2Pair.p1).get(ALL)).contains(schemeid)) && (((Map)orgMember2Pair.p2).get(c.number) == null || !((Set)((Map)orgMember2Pair.p2).get(c.number)).contains(schemeid))) {
                schemeOrgIdMaps.put((Object)schemeid, orgRangeId.get(c.number), (Object)scheme);
            }
        }
    }
}

