/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.integration.di.service.DIBaseEntAutoCreateService;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.intergration.di.DimMapService;
import kd.fi.bcm.formplugin.intergration.util.DISchemeUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DISchemeEditPlugin
extends AbstractBaseListPlugin
implements UploadListener,
IOperationLog,
BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String TEMPLATECATALOG = "templatecatalog";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String VERSIONNUMBER = "versionnumber";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRINGDATE = "expiringdate";
    private static final String ISTARG = "istarg";
    private static final String ISSRC = "issrc";
    private static final String DATASRCTYPE = "datasrctype";
    private static final String SOURCESYS = "sourcesys";
    private static final String SOURCEOBJ = "sourceobj";
    private static final String EXTENDSMODEL = "extendsmodel";
    private static final String EXTENDSTABLE = "extendstable";
    private static final String SERVICEFLOW = "serviceflow";
    private static final String TARGETSYS = "targetsys";
    private static final String TARGETTYPE = "targtype";
    private static final String TARGETOBJ = "targetobj";
    private static final String ISCDATACOPY = "iscdatacopy";
    private static final String ISCDATACOPYTRIGGER = "iscdatacopytrigger";
    private static final String MODELCONFIG = "modelconfig";
    private static final String SINGLEMETRIC = "singlemetric";
    private static final String TEXTFIELD = "textfield";
    private static final String IMPORTMODEID = "importmodeid";
    private static final String OLAPDATASYSTEM = "1";
    private static final String EXTENDDATASYSTEM = "2";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMNAME = "paramname";
    private static final String CANBENULL = "canbenull";
    private static final String ISSYSPRESET = "issyspreset";
    private static final String SRCPARAMNUMBER = "srcparamnumber";
    private static final String DEFAULTVALUE = "defaultvalue";
    private static final String FLOWPARAM = "flowparam";
    private static final String SRCEXTMODEL = "srcextmodel";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_EXIT = "btn_exit";
    private static final String DISCHEME_ID = "discheme_id";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String IS_CHANGED = "is_changed";
    private static final String IS_SPECIAL_MAPPING = "specialmappingable";
    private static final String STARTODEFAULT = "startodefault";
    private static final String SRC_SYS = "isscheme";
    private static final String PERM_CLASS = "permclass";
    private static final String[] mainDataSelector = new String[]{"model", "number", "name", "templatecatalog", "versionnumber", "effectivedate", "expiringdate", "istarg", "issrc", "datasrctype", "modelconfig", "sourceobj", "sourcesys", "targtype", "targetsys", "targetobj", "iscdatacopy", "iscdatacopytrigger", "singlemetric", "importmodeid", "extendsmodel", "extendstable", "serviceflow", "textfield", "specialmappingable", "startodefault", "isscheme", "srcextmodel"};
    private static final String[] paramSelector = new String[]{"entryentity.paramname", "entryentity.canbenull", "entryentity.issyspreset", "entryentity.srcparamnumber", "entryentity.defaultvalue", "entryentity.flowparam"};
    private static final String[] entryFields = new String[]{"paramname", "canbenull", "issyspreset", "srcparamnumber", "defaultvalue", "flowparam"};
    private static final String[] mustInput4All = new String[]{"number", "name", "effectivedate", "targtype", "datasrctype", "importmodeid"};

    public static String operationEnable() {
        return ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DISchemeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static String operationDisable() {
        return ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"DISchemeEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap", "advcontoolbarap1");
        BasedataEdit importmode = (BasedataEdit)this.getControl(IMPORTMODEID);
        importmode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit extendsModel = (BasedataEdit)this.getControl(EXTENDSMODEL);
        extendsModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit permClass = (BasedataEdit)this.getControl(PERM_CLASS);
        if (permClass != null) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)permClass, (Object)this.getModelId());
        }
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        entry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(DISchemeEditPlugin.SRCPARAMNUMBER)) {
                    DISchemeEditPlugin.this.setSrcParamItems();
                }
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
                if (cellClickEvent.getFieldKey().equals(DISchemeEditPlugin.SRCPARAMNUMBER)) {
                    DISchemeEditPlugin.this.setSrcParamItems();
                }
            }
        });
    }

    private void setSrcParamItems() {
        String accountId;
        DynamicObject modelConfigObj;
        String dataSrcType = (String)this.getModel().getValue(DATASRCTYPE);
        ArrayList<ComboItem> itemlist = new ArrayList<ComboItem>(8);
        List<Object> singleMetricList = new ArrayList(8);
        if (this.getModel().getValue(SOURCEOBJ) != null && DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
            DynamicObject srcObj = (DynamicObject)this.getModel().getValue(SOURCEOBJ);
            DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcObj.getLong("id"), (String)"isc_metadata_schema", (String)"group,prop_entryentity.prop_name,prop_entryentity.prop_label,data_type");
            DynamicObjectCollection prop_entryentity = src.getDynamicObjectCollection("prop_entryentity");
            prop_entryentity.forEach(p -> {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(p.getString("prop_label")));
                item.setValue(p.getString("prop_name"));
                itemlist.add(item);
            });
            singleMetricList = prop_entryentity.stream().filter(p -> p.getString("data_type") != null && ("bigint".equalsIgnoreCase(p.getString("data_type")) || "int".equalsIgnoreCase(p.getString("data_type")) || p.getString("data_type").toLowerCase().startsWith("decimal"))).map(p -> this.getComboItem(p.getString("prop_label"), p.getString("prop_name"))).collect(Collectors.toList());
            this.getView().getModel().setValue(SOURCESYS, src.get("group"));
        } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
            String value = (String)this.getView().getModel().getValue(EXTENDSTABLE);
            if (kd.bos.util.StringUtils.isNotEmpty((String)value) && DB.getTables((DBRoute)BCMConstant.DBROUTE).stream().anyMatch(e -> e.equalsIgnoreCase(value) || e.equalsIgnoreCase(value + "$0"))) {
                List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)value);
                columnNames.forEach(p -> itemlist.add(new ComboItem(new LocaleString(p.toLowerCase(Locale.ENGLISH)), p.toLowerCase(Locale.ENGLISH))));
                List fieldInfo = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)value);
                singleMetricList = fieldInfo.stream().filter(info -> info.getDataType() != null && !info.getDataType().toLowerCase(Locale.ENGLISH).contains("char")).map(info -> info.getFieldName().toLowerCase(Locale.ENGLISH)).map(name -> this.getComboItem((String)name, (String)name)).collect(Collectors.toList());
            }
        } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType) && (modelConfigObj = (DynamicObject)this.getModel().getValue(MODELCONFIG)) != null && (accountId = RequestContext.get().getAccountId()).equals(modelConfigObj.getString("datacenter")) && OLAPDATASYSTEM.equals(modelConfigObj.getString("apptype"))) {
            Long modelId = MemberReader.findModelIdByShowNum((String)modelConfigObj.getString("modelNum"));
            if (OLAPDATASYSTEM.equals(this.getModel().getValue(TARGETTYPE))) {
                QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
                QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name", (QFilter[])new QFilter[]{qf}, (String)"dseq").forEach(dimDyn -> itemlist.add(new ComboItem(new LocaleString(dimDyn.getString(NAME)), dimDyn.getString(NUMBER).toLowerCase())));
                itemlist.add(new ComboItem(new LocaleString("money"), "money"));
                itemlist.add(new ComboItem(new LocaleString("text"), "text"));
            } else {
                this.setSrcExtModelItem(modelId);
            }
        }
        if (EXTENDDATASYSTEM.equals(this.getModel().getValue(TARGETTYPE)) && DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
            this.setSrcParamNumber();
        } else {
            ComboEdit srcParamNumber = (ComboEdit)this.getControl(SRCPARAMNUMBER);
            srcParamNumber.setComboItems(itemlist);
            ComboEdit singleMetric = (ComboEdit)this.getControl(SINGLEMETRIC);
            if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
                singleMetric.setComboItems(itemlist);
            } else {
                singleMetric.setComboItems(singleMetricList);
            }
            ComboEdit textField = (ComboEdit)this.getControl(TEXTFIELD);
            textField.setComboItems(itemlist);
        }
    }

    private ComboItem getComboItem(String caption, String value) {
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(caption));
        item.setValue(value);
        return item;
    }

    private void setDataSrcTypeItems() {
        String targetType = (String)this.getModel().getValue(TARGETTYPE);
        ComboEdit dataSrcType = (ComboEdit)this.getControl(DATASRCTYPE);
        ArrayList<ComboItem> itemlist = new ArrayList<ComboItem>();
        String type1 = ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u4e91\u5bf9\u8c61", (String)"DIDataSrcTypeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
        String type2 = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u8868", (String)"DIDataSrcTypeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
        String type4 = ResManager.loadKDString((String)"\u4f53\u7cfb\u96c6\u6210\u9002\u914d\u5668", (String)"DIDataSrcTypeEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
        String type5 = ResManager.loadKDString((String)"EAS\u62a5\u8868\u63a8\u9001", (String)"DIDataSrcTypeEnum_5", (String)"fi-bcm-common", (Object[])new Object[0]);
        itemlist.add(new ComboItem(new LocaleString(type1), OLAPDATASYSTEM));
        itemlist.add(new ComboItem(new LocaleString(type2), EXTENDDATASYSTEM));
        itemlist.add(new ComboItem(new LocaleString(type4), "4"));
        if (OLAPDATASYSTEM.equals(targetType)) {
            itemlist.add(new ComboItem(new LocaleString(type5), "5"));
        }
        dataSrcType.setComboItems(itemlist);
    }

    private void updateSchemeParam() {
        int[] rows;
        this.getModel().deleteEntryData(ENTRYENTITY);
        List<String> preDatas = Arrays.asList("Entity", "Year", "Period", "Currency");
        for (int i : rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, preDatas.size())) {
            this.getModel().setValue(PARAMNAME, (Object)preDatas.get(i), i);
            this.getModel().setValue(CANBENULL, (Object)OLAPDATASYSTEM, i);
            this.getModel().setValue(ISSYSPRESET, (Object)"0", i);
            this.getModel().setValue(SRCPARAMNUMBER, (Object)"", i);
            this.getModel().setValue(DEFAULTVALUE, (Object)"", i);
            this.getModel().setValue(FLOWPARAM, (Object)("" + (i + 1)), i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CANBENULL, PARAMNAME, ISSYSPRESET});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty(map.get("scheme"))) {
            Long schemeId = (Long)map.get("scheme");
            this.setButtonEnable();
            this.getPageCache().put(DISCHEME_ID, String.valueOf(schemeId));
            this.fillMainData(schemeId);
            this.setFieldVisibleAndMustInput(false);
            this.setControlEnable();
        } else {
            if (!map.containsKey(TEMPLATECATALOG)) {
                return;
            }
            this.setNewSchemeFields(map);
            this.getModel().setDataChanged(false);
            this.getPageCache().put(DISCHEME_ID, String.valueOf(GlobalIdUtil.genGlobalLongId()));
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(map.get("KEY_MODEL_ID")));
            this.setFieldVisibleAndMustInput(false);
        }
        this.setDataSrcTypeItems();
        this.setSrcParamItems();
    }

    private void setButtonEnable() {
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_SAVE, "newentry", "deleteentry"});
        }
    }

    private void setFieldVisibleAndMustInput(boolean isClearValue) {
        String[] show;
        CharSequence[] mustInput;
        String dataSrcType;
        String[] needControlFields = new String[]{TARGETSYS, SOURCEOBJ, SOURCESYS, MODELCONFIG, SINGLEMETRIC, TEXTFIELD, EXTENDSMODEL, EXTENDSTABLE, IS_SPECIAL_MAPPING, STARTODEFAULT, SRC_SYS, SRCEXTMODEL};
        String tarType = (String)this.getModel().getValue(TARGETTYPE);
        String string = dataSrcType = this.getModel().getValue(DATASRCTYPE) == null ? "" : (String)this.getModel().getValue(DATASRCTYPE);
        if (EXTENDDATASYSTEM.equals(tarType)) {
            if (DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
                mustInput = new String[]{TARGETSYS, SOURCEOBJ, SOURCESYS, EXTENDSMODEL};
                show = new String[]{TARGETSYS, SOURCEOBJ, SOURCESYS, EXTENDSMODEL};
            } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
                mustInput = new String[]{EXTENDSMODEL, EXTENDSTABLE};
                show = new String[]{EXTENDSMODEL, EXTENDSTABLE};
            } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
                mustInput = new String[]{MODELCONFIG, SRCEXTMODEL};
                show = new String[]{MODELCONFIG, SRCEXTMODEL};
            } else {
                mustInput = null;
                show = null;
            }
            needControlFields = (String[])Arrays.stream(needControlFields).filter(e -> !e.equals(EXTENDSMODEL)).toArray(String[]::new);
        } else if (DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
            mustInput = new String[]{TARGETSYS, SOURCEOBJ, SOURCESYS, SINGLEMETRIC};
            show = new String[]{TARGETSYS, SOURCEOBJ, SOURCESYS, SINGLEMETRIC, TEXTFIELD, IS_SPECIAL_MAPPING, STARTODEFAULT};
        } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
            mustInput = new String[]{EXTENDSTABLE, SINGLEMETRIC};
            show = new String[]{EXTENDSTABLE, SINGLEMETRIC, TEXTFIELD, IS_SPECIAL_MAPPING, STARTODEFAULT};
        } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
            mustInput = new String[]{MODELCONFIG, SINGLEMETRIC, TEXTFIELD};
            show = new String[]{MODELCONFIG, SINGLEMETRIC, TEXTFIELD, IS_SPECIAL_MAPPING, STARTODEFAULT};
        } else if (DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType)) {
            mustInput = new String[]{SRC_SYS};
            show = new String[]{SRC_SYS, SERVICEFLOW};
        } else {
            mustInput = null;
            show = null;
        }
        this.setImportModeVisible(dataSrcType);
        if (isClearValue) {
            for (String e2 : needControlFields) {
                this.getModel().setValue(e2, null);
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), needControlFields);
        if (show != null) {
            List<String> showList = Arrays.asList(show);
            if (!showList.contains(IS_SPECIAL_MAPPING) && !showList.contains(STARTODEFAULT)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
            }
        }
        this.getView().setVisible(Boolean.valueOf(true), show);
        this.setMustInput(needControlFields, false);
        this.setMustInput((String[])mustInput, true);
        this.getPageCache().put("mustInput", String.join((CharSequence)",", mustInput));
    }

    private void setImportModeVisible(String dataSrcType) {
        if (DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType)) {
            this.getModel().setValue(IMPORTMODEID, null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMPORTMODEID});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{IMPORTMODEID});
        }
    }

    private void setMustInput(String[] fields, boolean mustInput) {
        Arrays.stream(fields).forEach(f -> ((FieldEdit)this.getControl((String)f)).setMustInput(mustInput));
    }

    private void setNewSchemeFields(Map<String, Object> map) {
        this.getModel().setValue(MODEL, map.get("KEY_MODEL_ID"));
        this.getModel().setValue(TEMPLATECATALOG, map.get(TEMPLATECATALOG));
        this.getModel().setValue(EFFECTIVEDATE, (Object)EntityVersioningUtil.getModelBeginDate((Object)map.get("KEY_MODEL_ID")));
        this.getModel().setValue(ISTARG, (Object)this.getProduct(IntegrateProductEnum.NGProduct.getNumber()));
        this.getModel().setValue(ISSRC, (Object)this.getProduct(IntegrateProductEnum.DIProduct.getNumber()));
    }

    private void fillMainData(Long schemeId) {
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme", (String)(String.join((CharSequence)",", mainDataSelector) + "," + String.join((CharSequence)",", paramSelector)));
        Arrays.stream(mainDataSelector).forEach(field -> this.getModel().setValue(field, schemeDyn.get(field)));
        this.getModel().setValue(PERM_CLASS, (Object)this.getPermClass(schemeId));
        DynamicObjectCollection dynCols = schemeDyn.getDynamicObjectCollection(ENTRYENTITY);
        if (dynCols.size() == 0) {
            this.updateSchemeParam();
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dynCols.size());
        for (int i = 0; i < dynCols.size(); ++i) {
            this.getModel().setValue(PARAMNAME, ((DynamicObject)dynCols.get(i)).get(PARAMNAME), i);
            this.getModel().setValue(CANBENULL, ((DynamicObject)dynCols.get(i)).get(CANBENULL), i);
            this.getModel().setValue(ISSYSPRESET, ((DynamicObject)dynCols.get(i)).get(ISSYSPRESET), i);
            this.getModel().setValue(SRCPARAMNUMBER, ((DynamicObject)dynCols.get(i)).get(SRCPARAMNUMBER), i);
            this.getModel().setValue(DEFAULTVALUE, ((DynamicObject)dynCols.get(i)).get(DEFAULTVALUE), i);
            this.getModel().setValue(FLOWPARAM, ((DynamicObject)dynCols.get(i)).get(FLOWPARAM), i);
            if (!"0".equals(((DynamicObject)dynCols.get(i)).getString(ISSYSPRESET))) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CANBENULL, PARAMNAME, ISSYSPRESET});
        }
    }

    protected void checkDimCompletion() {
        Long schemeId = Long.parseLong(this.getPageCache().get(DISCHEME_ID));
        DynamicObject scheme = this.getScheme(schemeId);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u65b9\u6848\u57fa\u672c\u4fe1\u606f\u3002", (String)"DISchemeEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        MappingService service = new MappingService(scheme);
        List error = service.checkDim();
        if (error.size() > 0) {
            this.getView().showErrorNotification(error.toString());
        } else {
            scheme.set(ENABLE, (Object)true);
            scheme = BusinessDataServiceHelper.loadSingle((Object)scheme.get("id"), (String)"bcm_isscheme", (String)"id, enable,model.name,name");
            scheme.set(ENABLE, (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f\u3002", (String)"DISchemeEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void disableDim() {
        Long schemeId = Long.parseLong(this.getPageCache().get(DISCHEME_ID));
        DynamicObject scheme = this.getScheme(schemeId);
        if (scheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"DISchemeEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (scheme.getBoolean("status")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u65b9\u6848\uff0c\u7ef4\u5ea6\u6620\u5c04\u624d\u80fd\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"DISchemeEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isExtendstable = StringUtils.isNotBlank((CharSequence)scheme.getString(EXTENDSTABLE));
        scheme.set(ENABLE, (Object)false);
        scheme = BusinessDataServiceHelper.loadSingle((Object)scheme.get("id"), (String)"bcm_isscheme", (String)"id, enable, status,model.name,number");
        scheme.set(ENABLE, (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        if (!isExtendstable) {
            ISImportModeUtil.updateImportMode((Tuple)Tuple.create((Object)scheme.getLong("id"), (Object)scheme.getString(NUMBER), (Object)scheme.getString(NAME)), (ISImpModeEnum)ISImpModeEnum.MERGEIMPORT);
        }
        DeleteServiceHelper.delete((String)"bcm_iscleardataconfig", (QFilter[])new QFilter[]{new QFilter(SRC_SYS, "=", (Object)scheme.getLong("id"))});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u6210\u529f\u3002", (String)"DISchemeEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private Long getProduct(String name) {
        DynamicObject product = QueryServiceHelper.queryOne((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)name)});
        return product == null ? 0L : product.getLong("id");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            int[] selectRows;
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            for (int selectRow : selectRows = entry.getSelectRows()) {
                DynamicObject dy = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow);
                if (!"0".equals(dy.getString(ISSYSPRESET))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"DISchemeEditPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof NewEntry) {
            int selectRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            this.getView().setEnable(Boolean.valueOf(false), selectRow, new String[]{ISSYSPRESET});
            Optional<Integer> flowparam = this.getModel().getEntryEntity(ENTRYENTITY).stream().map(e -> e.getInt(FLOWPARAM)).max(Comparator.comparing(x -> x));
            if (flowparam.isPresent()) {
                this.getModel().setValue(FLOWPARAM, (Object)(flowparam.get() + 1), selectRow);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave();
                break;
            }
            case "btn_exit": {
                break;
            }
            case "enable": {
                this.checkDimCompletion();
                break;
            }
            case "disable": {
                this.disableDim();
                break;
            }
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if (BTN_SAVE.equals(opkey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            opkey = OperationStatus.ADDNEW == status ? "btn_add" : "btn_edit";
        }
        super.checkPerm(opkey);
    }

    @Override
    public String getPermEntity(String entityId) {
        return "di_schemelist";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "sourceobj": {
                if (e.getChangeSet()[0].getOldValue() != null && e.getChangeSet()[0].getOldValue() != e.getChangeSet()[0].getNewValue()) {
                    Long schemeId = Long.parseLong(this.getPageCache().get(DISCHEME_ID));
                    this.cleanBaseEntList(schemeId);
                    this.cleanMapping(schemeId);
                    IDataModel iDataModel = this.getModel();
                }
                this.setSrcParamItems();
                this.updateSchemeParam();
                break;
            }
            case "targtype": {
                this.updateDataSrcTypeValue();
                this.setDataSrcTypeItems();
                this.setFieldVisibleAndMustInput(true);
                this.setSrcParamItems();
                this.updateSchemeParam();
                break;
            }
            case "datasrctype": {
                this.setFieldVisibleAndMustInput(true);
                this.setSrcParamItems();
                this.setMetric4ModelAdpter();
                this.updateSchemeParam();
                break;
            }
            case "modelconfig": {
                this.setSrcParamItems();
                break;
            }
            case "extendstable": {
                this.setSrcParamItems();
                this.updateSchemeParam();
                break;
            }
            case "textfield": 
            case "singlemetric": {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getValue(TEXTFIELD))) || !kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getValue(SINGLEMETRIC))) || !this.getValue(TEXTFIELD).equals(this.getValue(SINGLEMETRIC))) break;
                this.getModel().setValue(TEXTFIELD.equals(name) ? SINGLEMETRIC : TEXTFIELD, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u5b57\u6bb5\u548c\u6587\u672c\u503c\u5b57\u6bb5\u4e0d\u53ef\u8bbe\u7f6e\u76f8\u540c\u7684\u9009\u9879\u3002", (String)"DISchemeEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "flowparam": {
                Integer newValue = (Integer)e.getChangeSet()[0].getNewValue();
                int rowIndex = e.getChangeSet()[0].getRowIndex() + 1;
                if (!this.getModel().getEntryEntity(ENTRYENTITY).stream().filter(a -> a.getInt("seq") != rowIndex).anyMatch(a -> a.getInt(name) != 0 && a.getInt(name) == newValue.intValue())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u53c2\u6570\u5e8f\u53f7\u4e0d\u53ef\u91cd\u590d\u3002", (String)"DISchemeEditPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getView().getModel().setValue(name, e.getChangeSet()[0].getOldValue() == null ? Integer.valueOf(0) : e.getChangeSet()[0].getOldValue(), e.getChangeSet()[0].getRowIndex());
                return;
            }
            case "srcextmodel": {
                this.setSrcParamNumber();
                if (e.getChangeSet()[0].getOldValue() == null || e.getChangeSet()[0].getOldValue() == e.getChangeSet()[0].getNewValue()) break;
                this.updateSchemeParam();
                break;
            }
        }
        if (e.getChangeSet()[0].getOldValue() != e.getChangeSet()[0].getNewValue()) {
            this.getPageCache().put(IS_CHANGED, OLAPDATASYSTEM);
        }
    }

    private void setSrcParamNumber() {
        String accountId;
        DynamicObject modelConfigObj = (DynamicObject)this.getModel().getValue(MODELCONFIG);
        ArrayList itemlist = new ArrayList();
        if (modelConfigObj != null && (accountId = RequestContext.get().getAccountId()).equals(modelConfigObj.getString("datacenter")) && OLAPDATASYSTEM.equals(modelConfigObj.getString("apptype"))) {
            Long modelId = MemberReader.findModelIdByShowNum((String)modelConfigObj.getString("modelNum"));
            if (EXTENDDATASYSTEM.equals(this.getModel().getValue(TARGETTYPE)) && this.getModel().getValue(SRCEXTMODEL) != null) {
                String srcExtModel = (String)this.getModel().getValue(SRCEXTMODEL);
                DISchemeUtil.getFixedDim(modelId).forEach((k, v) -> itemlist.add(new ComboItem(new LocaleString(v), k.toLowerCase())));
                Long extendsModelId = DISchemeUtil.getExtendsModelId(srcExtModel, modelId);
                DISchemeUtil.getDimNumber2Name(extendsModelId).forEach((k, v) -> itemlist.add(new ComboItem(new LocaleString(v), k.toLowerCase())));
                DISchemeUtil.getFieldNumber2NameDTID(extendsModelId).forEach((k, v) -> itemlist.add(new ComboItem(new LocaleString((String)v.p1), k.toLowerCase())));
            }
        }
        ComboEdit srcParamNumber = (ComboEdit)this.getControl(SRCPARAMNUMBER);
        srcParamNumber.setComboItems(itemlist);
        ComboEdit singleMetric = (ComboEdit)this.getControl(SINGLEMETRIC);
        singleMetric.setComboItems(itemlist);
    }

    private void setMetric4ModelAdpter() {
        if (this.getModel().getValue(DATASRCTYPE) != null && DIDataSrcTypeEnum.ModelAdptor.getValue().equals(this.getModel().getValue(DATASRCTYPE))) {
            this.getModel().setValue(SINGLEMETRIC, (Object)"money");
            this.getModel().setValue(TEXTFIELD, (Object)"text");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SINGLEMETRIC, TEXTFIELD});
        } else {
            this.getModel().setValue(SINGLEMETRIC, null);
            this.getModel().setValue(TEXTFIELD, null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SINGLEMETRIC, TEXTFIELD});
        }
    }

    private void updateDataSrcTypeValue() {
        String targetType = (String)this.getModel().getValue(TARGETTYPE);
        String dataSrcType = (String)this.getModel().getValue(DATASRCTYPE);
        if (EXTENDDATASYSTEM.equals(targetType) && (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType) || DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType))) {
            this.getModel().setValue(DATASRCTYPE, (Object)OLAPDATASYSTEM);
        }
        if (OLAPDATASYSTEM.equals(targetType) && DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
            this.getModel().setValue(DATASRCTYPE, (Object)OLAPDATASYSTEM);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (OLAPDATASYSTEM.equals(this.getPageCache().get(IS_CHANGED)) && !this.isEnable()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"DISchemeEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    private void cleanMapping(Long schemeId) {
        Map<String, Set<Long>> ids = this.getDeleteMappingIds(schemeId);
        HashSet<Long> deleteIds = new HashSet<Long>((Collection)ids.get("deleteIds"));
        HashSet<Long> deleteTagIds = new HashSet<Long>((Collection)ids.get("deleteTagIds"));
        HashSet<Long> deleteSrcIds = new HashSet<Long>((Collection)ids.get("deleteSrcIds"));
        this.doDeleteMapping(deleteIds, deleteTagIds, deleteSrcIds);
    }

    private void cleanBaseEntList(Long schemeId) {
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        DeleteServiceHelper.delete((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getScheme(Long Id) {
        return BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id,sourceobj,enable,issrc,istarg,model,status,extendstable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Id)});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("save_comfirm".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.actionSave();
            } else {
                this.getPageCache().remove(IS_CHANGED);
                this.getView().close();
            }
        } else if ("specialmapping".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.saveScheme();
                this.deleteSpecialMappingData();
                this.clearTableRout();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.saveScheme();
                this.clearTableRout();
            }
            this.getPageCache().remove(IS_CHANGED);
        } else if ("mapping".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.saveScheme();
                this.clearTableRout();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getModel().setValue(IS_SPECIAL_MAPPING, (Object)0);
                this.getPageCache().remove(IS_CHANGED);
            }
        }
    }

    private void clearTableRout() {
        if (DIIntegrationUtil.existTableRouteData((Long)Long.parseLong(this.getPageCache().get(DISCHEME_ID))).booleanValue()) {
            DIIntegrationUtil.clearTableRoute((long)Long.parseLong(this.getPageCache().get(DISCHEME_ID)));
            log.info("do clearTableRoute\u3002");
        }
    }

    private void saveScheme() {
        this.doSaveScheme();
        this.setControlEnable();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DISchemeEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        this.getPageCache().remove(IS_CHANGED);
    }

    private void deleteSpecialMappingData() {
        Long schemeId = Long.parseLong(this.getPageCache().get(DISCHEME_ID));
        QFBuilder qf = new QFBuilder();
        qf.add("scheme", "=", (Object)schemeId);
        qf.add("mappedtype", "=", (Object)DimMappTypeEnum.SPECIAL.getCode());
        Long mapTypeId = QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"id", (QFilter[])qf.toArray()).getLong("id");
        DISchemeUtil.deleteDefMapping(Collections.singleton(mapTypeId));
        DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter("id", "in", (Object)mapTypeId).toArray());
        DISchemeUtil.deleteMemberMap(Collections.singleton(mapTypeId));
    }

    private Map<String, Set<Long>> getDeleteMappingIds(Long schemeId) {
        DynamicObject[] dynamicObjects;
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>();
        HashSet<Long> deleteIds = new HashSet<Long>();
        HashSet<Long> deletetagIds = new HashSet<Long>();
        HashSet<Long> deletesrcIds = new HashSet<Long>();
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        for (DynamicObject dyo : dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,mappedtype,isdimmaptargentry,isdimmapsrcentry", (QFilter[])new QFilter[]{filter})) {
            String mappedtype = dyo.getString("mappedtype");
            if (DimMappTypeEnum.SINGLE.getCode().equals(mappedtype)) {
                deleteIds.add(dyo.getLong("id"));
                continue;
            }
            if (DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(mappedtype)) {
                DynamicObjectCollection dynamicObjectTag = (DynamicObjectCollection)dyo.get("isdimmaptargentry");
                for (DynamicObject dynamicObject : dynamicObjectTag) {
                    deletetagIds.add(dynamicObject.getLong("id"));
                }
                continue;
            }
            if (!DimMappTypeEnum.SRC_DEFAULT.getCode().equals(mappedtype)) continue;
            DynamicObjectCollection dynamicObjectSrc = (DynamicObjectCollection)dyo.get("isdimmapsrcentry");
            for (DynamicObject dynamicObject : dynamicObjectSrc) {
                deletesrcIds.add(dynamicObject.getLong("id"));
            }
        }
        ids.put("deleteIds", deleteIds);
        ids.put("deleteTagIds", deletetagIds);
        ids.put("deleteSrcIds", deletesrcIds);
        return ids;
    }

    private void doDeleteMapping(Set<Long> deleteIds, Set<Long> deletetagIds, Set<Long> deletesrcIds) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (deletetagIds.size() > 0) {
                    this.deleteDefMapping(deleteIds, deletetagIds, "isdimmaptargentry");
                }
                if (deletesrcIds.size() > 0) {
                    this.deleteDefMapping(deleteIds, deletesrcIds, "isdimmapsrcentry");
                }
                if (deleteIds.size() > 0) {
                    DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter("id", "in", deleteIds).toArray());
                    DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter("dimmapid", "in", deleteIds).toArray());
                    DeleteServiceHelper.delete((String)"bcm_isgroupmap", (QFilter[])new QFilter("dimmapid", "in", deleteIds).toArray());
                }
            }
            catch (Exception e) {
                log.error(String.format("delete mapping inner failed: %s", ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
                tx.markRollback();
            }
        }
        catch (Exception e) {
            log.error(String.format("delete mapping out failed: %s", ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)));
        }
    }

    private void deleteDefMapping(Set<Long> deleteIds, Set<Long> deletetagIds, String entry) {
        DynamicObject[] loads;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_isdimmap");
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isdimmap", (QFilter[])new QFilter(entry + ".id", "in", deletetagIds).toArray(), null, (int)-1);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)dataEntityType)) {
            DynamicObjectCollection dynamicObjectCollection = load.getDynamicObjectCollection(entry);
            Iterator iterator = dynamicObjectCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (!deletetagIds.contains(next.getLong("id"))) continue;
                iterator.remove();
            }
            if (dynamicObjectCollection.size() > 0) continue;
            deleteIds.add(load.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])loads);
    }

    private void actionSave() {
        if (this.isEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"DISchemeEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        } else if (this.checkMustInputNotSaveInValidator() && this.validateNumber() && this.validateDate() && this.validateSchemeParam()) {
            if (QueryServiceHelper.exists((String)"bcm_isscheme", (Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)))) {
                Boolean pageFlag = (Boolean)this.getModel().getValue(IS_SPECIAL_MAPPING);
                Boolean DBFlag = DIIntegrationUtil.getSpecialMappingStatus((Long)Long.parseLong(this.getPageCache().get(DISCHEME_ID)));
                Boolean existTableRoute = DIIntegrationUtil.existTableRouteData((Long)Long.parseLong(this.getPageCache().get(DISCHEME_ID)));
                if (!pageFlag.booleanValue() && DBFlag.booleanValue()) {
                    this.doConfirm(existTableRoute);
                } else if (!DBFlag.booleanValue() && pageFlag.booleanValue() && existTableRoute.booleanValue()) {
                    this.doSpecialMapping();
                } else {
                    this.saveScheme();
                }
            } else {
                this.saveScheme();
            }
        }
    }

    private void doSpecialMapping() {
        String noticeStr = ResManager.loadKDString((String)"\u5f00\u542f\u7279\u6b8a\u6620\u5c04\u5f00\u5173\uff0c\u5c06\u6539\u53d8\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\uff0c\u5e76\u6e05\u9664\u96c6\u6210\u65b9\u6848\u5386\u53f2\u6570\u636e\u3002\u662f\u5426\u786e\u8ba4\u5f00\u542f\uff1f", (String)"DISchemeEditPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String checkStr = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u662f\u5426\u5f00\u542f\u7279\u6b8a\u6620\u5c04\u5f00\u5173\u3002", (String)"DISchemeEditPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(checkStr, noticeStr, MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("mapping", (IFormPlugin)this));
    }

    private void doConfirm(Boolean existTableRoute) {
        String noticeStr = ResManager.loadKDString((String)"\u5173\u95ed\u7279\u6b8a\u6620\u5c04\u5f00\u5173\u5c06\u4f1a\u6539\u53d8\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u5e76\u6e05\u9664\u96c6\u6210\u65b9\u6848\u5386\u53f2\u6570\u636e\u3002", (String)"DISchemeEditPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String checkStr = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u662f\u5426\u5220\u9664\u65b9\u6848\u7279\u6b8a\u6620\u5c04\u53ca\u6210\u5458\u6620\u5c04?", (String)"DISchemeEditPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if (existTableRoute.booleanValue()) {
            this.getView().showConfirm(checkStr, noticeStr, MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("specialmapping", (IFormPlugin)this));
        } else {
            String prompt = ResManager.loadKDString((String)"\u5173\u95ed\u7279\u6b8a\u6620\u5c04\u5f00\u5173\uff0c\u662f\u5426\u5220\u9664\u65b9\u6848\u7684\u7279\u6b8a\u6620\u5c04\u53ca\u6210\u5458\u6620\u5c04?", (String)"DISchemeEditPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(prompt, MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("specialmapping", (IFormPlugin)this));
        }
    }

    private void setControlEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{TARGETTYPE, SOURCEOBJ, DATASRCTYPE, MODELCONFIG, EXTENDSTABLE});
        if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(this.getModel().getValue(DATASRCTYPE))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SINGLEMETRIC, TEXTFIELD});
        }
    }

    private boolean validateDate() {
        Date expiringDate = this.getModel().getValue(EXPIRINGDATE) == null ? null : (Date)this.getModel().getValue(EXPIRINGDATE);
        Date effectiveDate = (Date)this.getModel().getValue(EFFECTIVEDATE);
        if (expiringDate != null && effectiveDate.after(expiringDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u65e9\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"DISchemeEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateNumber() {
        String number = (String)this.getModel().getValue(NUMBER);
        String regEx = "^\\w+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DISchemeEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getValue(TEXTFIELD))) && kd.bos.util.StringUtils.isNotEmpty((String)((String)this.getValue(SINGLEMETRIC))) && this.getValue(TEXTFIELD).equals(this.getValue(SINGLEMETRIC))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u5b57\u6bb5\u548c\u6587\u672c\u503c\u5b57\u6bb5\u4e0d\u53ef\u8bbe\u7f6e\u76f8\u540c\u7684\u9009\u9879\u3002", (String)"DISchemeEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String extendstable = (String)this.getModel().getValue(EXTENDSTABLE);
        if (kd.bos.util.StringUtils.isNotEmpty((String)extendstable) && (!pattern.matcher(extendstable).matches() || extendstable.matches("^\\d.*"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DISchemeEditPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String targetType = (String)this.getModel().getValue(TARGETTYPE);
        if (!EXTENDDATASYSTEM.equals(targetType) && kd.bos.util.StringUtils.isNotEmpty((String)extendstable) && !DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)extendstable) && !DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)(extendstable + "$map"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u8868\u4e0d\u5b58\u5728\u3002", (String)"DISchemeEditPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        QFBuilder qf = new QFBuilder(MODEL, "=", (Object)((DynamicObject)this.getModel().getValue(MODEL)).getLong("id"));
        qf.add("id", "!=", (Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number,name", (QFilter[])qf.toArray());
        if (schemes.stream().anyMatch(scheme -> number.equalsIgnoreCase(scheme.getString(NUMBER)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u65b9\u6848, \u4fee\u6539\u7f16\u7801\u540e\u91cd\u8bd5\u3002", (String)"DISchemeEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        if (schemes.stream().anyMatch(scheme -> scheme.getString(NAME).equals(this.getValue(NAME).toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u65b9\u6848, \u4fee\u6539\u540d\u79f0\u540e\u91cd\u8bd5\u3002", (String)"DISchemeEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    private boolean validateSchemeParam() {
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map controlMetaState = viewProxy.getControlMetaState(SRCPARAMNUMBER);
        if (controlMetaState.containsKey("st")) {
            List st = (List)controlMetaState.get("st");
            Set itemLists = st.stream().map(e -> (String)e.get(0)).collect(Collectors.toSet());
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            HashSet<Integer> flowParams = new HashSet<Integer>(16);
            HashSet<String> names = new HashSet<String>(16);
            for (DynamicObject dy : entryentity) {
                if (kd.bos.util.StringUtils.isEmpty((String)dy.getString(PARAMNAME))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53c2\u6570\u5217\u8868\u4e2d\u7b2c%s\u884c\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DISchemeEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.get("seq")), Integer.valueOf(3000));
                    return false;
                }
                if (names.contains(dy.getString(PARAMNAME))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53c2\u6570\u5217\u8868\u4e2d\u7b2c%s\u884c\u53c2\u6570\u540d\u79f0\u91cd\u590d\u3002", (String)"DISchemeEditPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.get("seq")), Integer.valueOf(3000));
                    return false;
                }
                names.add(dy.getString(PARAMNAME));
                if ("0".equals(dy.getString(CANBENULL)) && kd.bos.util.StringUtils.isEmpty((String)dy.getString(DEFAULTVALUE))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53c2\u6570\u5217\u8868\u4e2d\u7b2c%s\u884c\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DISchemeEditPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.get("seq")), Integer.valueOf(3000));
                    return false;
                }
                if (dy.getInt(FLOWPARAM) != 0 && flowParams.contains(dy.getInt(FLOWPARAM))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53c2\u6570\u5217\u8868\u4e2d\u7b2c%s\u884c\u6d41\u7a0b\u53c2\u6570\u5e8f\u53f7\u91cd\u590d\u3002", (String)"DISchemeEditPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dy.get("seq")), Integer.valueOf(3000));
                    return false;
                }
                flowParams.add(dy.getInt(FLOWPARAM));
            }
            List errorFields = entryentity.stream().map(e -> e.getString(SRCPARAMNUMBER)).filter(e -> kd.bos.util.StringUtils.isNotEmpty((String)e) && !itemLists.contains(e)).collect(Collectors.toList());
            if (!errorFields.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53c2\u6570\u5217\u8868\u4e2d\uff0c\u6e90\u5b57\u6bb5\u8bbe\u7f6e\u5b58\u5728\u4e0d\u53ef\u7528\u7684\u503c\uff1a%s\u3002", (String)"DISchemeEditPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorFields)), Integer.valueOf(3000));
                return false;
            }
        }
        return true;
    }

    private boolean isEnable() {
        if (QueryServiceHelper.exists((String)"bcm_isscheme", (Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)))) {
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)), (String)"bcm_isscheme", (String)"status");
            return scheme != null && scheme.getBoolean("status");
        }
        return false;
    }

    private void doSaveScheme() {
        DynamicObject middle;
        boolean newAdd = !QueryServiceHelper.exists((String)"bcm_isscheme", (Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)));
        DynamicObject diScheme = !newAdd ? BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.getPageCache().get(DISCHEME_ID)), (String)"bcm_isscheme") : BusinessDataServiceHelper.newDynamicObject((String)"bcm_isscheme");
        diScheme.set("id", (Object)this.getPageCache().get(DISCHEME_ID));
        boolean isSynClearRouteTable = !newAdd && (ObjectUtils.notEqual((Object)diScheme.get(SINGLEMETRIC), (Object)this.getModel().getValue(SINGLEMETRIC)) || ObjectUtils.notEqual((Object)diScheme.get(TEXTFIELD), (Object)this.getModel().getValue(TEXTFIELD)));
        Arrays.stream(mainDataSelector).forEach(f -> diScheme.set(f, this.getModel().getValue(f)));
        diScheme.set("creator", (Object)RequestContext.get().getCurrUserId());
        diScheme.set("status", (Object)"0");
        String tarType = diScheme.getString(TARGETTYPE);
        String dataSrcType = diScheme.getString(DATASRCTYPE);
        String issrcNumber = null;
        if (DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
            issrcNumber = EXTENDDATASYSTEM.equals(tarType) ? IntegrateProductEnum.DIISCEXProduct.getNumber() : IntegrateProductEnum.DIProduct.getNumber();
        } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
            issrcNumber = EXTENDDATASYSTEM.equals(tarType) ? IntegrateProductEnum.DIMIDEXProduct.getNumber() : IntegrateProductEnum.DIMIDProduct.getNumber();
        } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
            issrcNumber = EXTENDDATASYSTEM.equals(tarType) ? IntegrateProductEnum.DICMEXTProduct.getNumber() : IntegrateProductEnum.DICMProduct.getNumber();
        } else if (DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType)) {
            issrcNumber = IntegrateProductEnum.DIPUSH2EASREPProduct.getNumber();
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)issrcNumber) && (middle = BusinessDataServiceHelper.loadSingle((String)"bcm_isproduct", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)issrcNumber)})) != null) {
            diScheme.set(ISSRC, (Object)middle);
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<DynamicObject> entryEntityList = new ArrayList<DynamicObject>(entryentity.size());
        for (DynamicObject dyn : entryentity) {
            if (ObjectUtils.isEmpty((Object)dyn.get(PARAMNAME))) continue;
            DynamicObject dyo = new DynamicObject(diScheme.getDynamicObjectCollection(ENTRYENTITY).getDynamicObjectType());
            Arrays.stream(entryFields).forEach(f -> dyo.set(f, dyn.get(f)));
            entryEntityList.add(dyo);
        }
        diScheme.set(ENTRYENTITY, entryEntityList);
        Boolean pageFlag = (Boolean)this.getModel().getValue(IS_SPECIAL_MAPPING);
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{diScheme});
            PermClassEntityHelper.savePermClass((String)"bcm_isscheme", (Object)diScheme.getLong("id"), (Object)diScheme.getLong("model.id"), (Object)this.getModel().getValue(PERM_CLASS));
            new DIBaseEntAutoCreateService(diScheme.getLong("id")).excute();
            if (this.needAddDimMap(diScheme.getLong("id")).booleanValue()) {
                this.saveDefDimMap(diScheme.getLong("id"));
            }
            if (pageFlag.booleanValue()) {
                this.saveAllDimMap(diScheme.getLong("id"));
            }
            if (isSynClearRouteTable) {
                DIIntegrationUtil.clearTableRoute((long)diScheme.getLong("id"));
            }
        });
    }

    private DynamicObject getPermClass(Long entityId) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        qFilter.and("entityname", "=", (Object)"bcm_isscheme");
        qFilter.and("entityid", "=", (Object)entityId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permclass_entity", (String)"permclass,permclass.number", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dy)) {
            return null;
        }
        return dy.getDynamicObject(PERM_CLASS);
    }

    private Boolean needAddDimMap(Long schemeId) {
        QFBuilder filter = new QFBuilder("scheme", "=", (Object)schemeId);
        return !QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filter.toArray());
    }

    private void saveDefDimMap(Long schemeId) {
        QFilter qfScheme = new QFilter("id", "=", (Object)schemeId);
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, name, number,model.id,extendstable,extendsmodel,datasrctype", (QFilter[])qfScheme.toArray());
        DimMapService dimMapService = new DimMapService(schemeDy);
        dimMapService.insertDimPerData();
    }

    private void saveAllDimMap(Long schemeId) {
        QFilter qfScheme = new QFilter("id", "=", (Object)schemeId);
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, name, number,model.id,extendstable,extendsmodel", (QFilter[])qfScheme.toArray());
        DimMapService dimMapService = new DimMapService(schemeDy);
        dimMapService.createSpecialDimMap();
    }

    private boolean checkMustInputNotSaveInValidator() {
        boolean canSave = true;
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(16);
        Arrays.stream(mustInput4All).forEach(f -> fieldMap.put((String)f, ((FieldEdit)this.getControl((String)f)).getProperty().getDisplayName().getLocaleValue()));
        String mustInput = this.getPageCache().get("mustInput");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mustInput)) {
            String[] inputs = mustInput.split(",");
            Arrays.stream(inputs).forEach(f -> fieldMap.put((String)f, ((FieldEdit)this.getControl((String)f)).getProperty().getDisplayName().getLocaleValue()));
        }
        StringJoiner message = new StringJoiner("\uff0c");
        fieldMap.forEach((k, v) -> {
            Object value = this.getModel().getValue(k);
            if (value instanceof OrmLocaleValue) {
                value = value.toString();
            }
            if (ObjectUtils.isEmpty((Object)value) && !this.iSEASReportPushAndImportMode((String)k).booleanValue()) {
                ((FieldEdit)this.getControl((String)k)).setFocus(true);
                message.add("\"" + v + "\"");
            }
        });
        if (message.length() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DISchemeEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[]{message.toString()}), Integer.valueOf(3000));
            canSave = false;
        }
        return canSave;
    }

    private Boolean iSEASReportPushAndImportMode(String k) {
        if (IMPORTMODEID.equals(k) && DIDataSrcTypeEnum.EASReportPush.getValue().equals(this.getModel().getValue(DATASRCTYPE))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        switch (key) {
            case "importmodeid": {
                ArrayList<QFilter> qfList = new ArrayList<QFilter>();
                qfList.add(new QFilter(MODEL, "=", (Object)modelId));
                qfList.add(new QFilter("scheme", "=", (Object)0L));
                evt.setCustomQFilters(qfList);
                break;
            }
            case "extendsmodel": 
            case "permclass": {
                ArrayList<QFilter> qfList1 = new ArrayList<QFilter>();
                qfList1.add(new QFilter(MODEL, "=", (Object)modelId));
                evt.setCustomQFilters(qfList1);
                break;
            }
        }
    }

    private void setSrcExtModelItem(Long modelId) {
        ComboEdit ce = (ComboEdit)this.getControl(SRCEXTMODEL);
        ArrayList items = new ArrayList(10);
        this.getExtendsModel(modelId).forEach((k, v) -> items.add(new ComboItem(new LocaleString(k + " " + v), k)));
        ce.setComboItems(items);
    }

    private Map<String, String> getExtendsModel(Long modelId) {
        HashMap<String, String> extMap = new HashMap<String, String>(10);
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"number,name", (QFilter[])filter.toArray());
        if (collection != null && collection.size() > 0) {
            for (DynamicObject extendsModel : collection) {
                extMap.put(extendsModel.getString(NUMBER), extendsModel.getString(NAME));
            }
        }
        return extMap;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }
}

