/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class DISchemeListPlugin
extends DIAbstractListPlugin
implements HyperLinkClickListener {
    private static final String ctl_model = "model";
    private static final String ctl_schemecatalog = "templatecatalog";
    private static final String ctl_billlistap = "billlistap";
    private static final String btn_addgroup = "btn_addgroup";
    private static final String btn_editgroup = "btn_editgroup";
    private static final String btn_delgroup = "btn_delgroup";
    private static final String deletescheme_confirm = "deletescheme_confirm";
    private static final String deletecatalog_confirm = "deletecatalog_confirm";
    private static final String BTN_ADD = "btn_add";
    private static final String btn_importmode = "btn_importmode";
    private static final String btn_assign = "btn_assign";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISENABLE = "btn_disenable";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_DELETE = "btn_delete";
    public static final String DI_CATALOG_TYPE = "2";
    private static final String ctl_checkbox_tree = "treecheckbox";
    private static final String BTN_DIMMAP = "btn_dimmap";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{btn_importmode, btn_assign, "btn_base", BTN_DIMMAP, "btn_numbermap", "btn_rule", "btn_collect", "btn_codetail"});
        this.createHand();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validate()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "model": {
                this.propertyChangedModel();
                break;
            }
            case "treecheckbox": {
                this.refreshBillList();
                break;
            }
        }
    }

    public void createHand() {
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
            billList.getFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            this.getView().getModel().setValue(ctl_model, (Object)modelId);
            this.modelChange(modelId);
        }
    }

    public void propertyChangedModel() {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), ctl_model);
        if (modelId == null) {
            this.getView().getModel().setValue(ctl_model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
        } else {
            if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                return;
            }
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            this.modelChange(modelId);
        }
    }

    private void modelChange(String modelid) {
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(ctl_model, "=", (Object)Long.parseLong(modelid));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.setMulti(false);
        billList.setFilterParameter(fp);
        this.refreshTree();
        this.refreshBillList();
    }

    public void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_DELETE, BTN_ENABLE, BTN_DISENABLE});
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode schemecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        String entityName = "bcm_schemecatalog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter(ctl_model, "=", (Object)ConvertUtil.convertStrToLong((String)modelID));
        QFilter typeQf = new QFilter("type", "=", (Object)DI_CATALOG_TYPE);
        QFilter[] filters = new QFilter[]{fmodelid, typeQf};
        String orderBys = "id";
        Long rootid = null;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                rootid = task.getLong("id");
                this.getPageCache().put("focusnodeid", rootid.toString());
                this.getPageCache().put("headnodeid", rootid.toString());
            }
        } else {
            rootid = GlobalIdUtil.genGlobalLongId();
            DISchemeListPlugin.setDefaultRootNode(modelID, rootid);
            this.getPageCache().put("focusnodeid", rootid.toString());
            this.getPageCache().put("headnodeid", rootid.toString());
        }
        schemecatalog.setId(rootid != null ? rootid.toString() : "");
        schemecatalog.setParentid("");
        schemecatalog.setText(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"ISSchemeListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)schemecatalog, treeList, (String)(rootid != null ? rootid.toString() : ""));
        BCMTreeUtils.spreadAllNode((TreeNode)schemecatalog);
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        tree.addNode(schemecatalog);
        tree.focusNode(schemecatalog);
    }

    private static void setDefaultRootNode(String modelid, Long rootid) {
        DynamicObject catalogTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schemecatalog");
        catalogTree.set("id", (Object)rootid);
        catalogTree.set("number", (Object)"root");
        catalogTree.set(ctl_model, (Object)ConvertUtil.convertStrToLong((String)modelid));
        catalogTree.set("name", (Object)ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"ISSchemeListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        catalogTree.set("parent", (Object)0);
        catalogTree.set("longnumber", (Object)"root");
        catalogTree.set("status", (Object)"C");
        catalogTree.set("enable", (Object)1);
        catalogTree.set("type", (Object)DI_CATALOG_TYPE);
        catalogTree.set("modifier", (Object)RequestContext.get().getCurrUserId());
        catalogTree.set("creator", (Object)RequestContext.get().getCurrUserId());
        catalogTree.set("modifytime", (Object)TimeServiceHelper.now());
        catalogTree.set("createtime", (Object)TimeServiceHelper.now());
        BusinessDataWriter.save((IDataEntityType)catalogTree.getDynamicObjectType(), (Object[])new Object[]{catalogTree});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_addgroup, btn_editgroup, btn_delgroup);
        this.addItemClickListeners("toolbarap1");
        TreeView treeView = (TreeView)this.getControl(ctl_schemecatalog);
        final BillList billList = (BillList)this.getControl(ctl_billlistap);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                DISchemeListPlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                billList.clearSelection();
                DISchemeListPlugin.this.refreshBillList();
            }
        });
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validate()) {
            return;
        }
        Long nodeId = Long.valueOf(this.getPageCache().get("focusnodeid"));
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addgroup": {
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delgroup": {
                this.delTemplateCatalog(nodeId, this.getModelId());
                break;
            }
            case "btn_editgroup": {
                this.newTemplateCatalog(nodeId, false);
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (!Objects.isNull(currentListSelectedRow)) {
            Object primaryKeyValue = currentListSelectedRow.getPrimaryKeyValue();
            Boolean flag = DIIntegrationUtil.isWriteSchemePerm((long)LongUtil.toLong((Object)primaryKeyValue), (long)this.getModelId());
            this.getView().setEnable(flag, new String[]{BTN_DELETE, BTN_ENABLE, BTN_DISENABLE});
        }
    }

    public void delTemplateCatalog(Long nodeId, Long modelId) {
        if (nodeId.toString().equals(this.getPageCache().get("headnodeid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ISSchemeListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkIsHasScheme(nodeId, modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u4e0b\u5b58\u5728\u96c6\u6210\u65b9\u6848\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ISSchemeListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u8be5\u65b9\u6848\u5206\u7c7b\uff1f", (String)"ISSchemeListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(deletecatalog_confirm, (IFormPlugin)this));
    }

    private boolean checkIsHasScheme(Long nodeId, Long modelId) {
        List<Long> ids = this.getTempIds(nodeId, modelId);
        QFilter filter = new QFilter(ctl_schemecatalog, "in", ids);
        DynamicObject dyn_ids = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject dyn_ids_old = QueryServiceHelper.queryOne((String)"bcm_schemeentity", (String)"id", (QFilter[])new QFilter[]{filter});
        return dyn_ids != null || dyn_ids_old != null;
    }

    private List<Long> getTempIds(Long nodeId, Long modelId) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (modelId == null) {
            modelId = this.getModelId();
        }
        QFilter filter = new QFilter(ctl_model, "=", (Object)modelId);
        DynamicObjectCollection schemecatalogs = QueryServiceHelper.query((String)"bcm_schemecatalog", (String)"id,parent", (QFilter[])new QFilter[]{filter});
        Map<Long, DynamicObject> idDys = schemecatalogs.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        schemecatalogs.forEach(e -> {
            if (this.isParent((DynamicObject)e, nodeId, idDys)) {
                ids.add(e.getLong("id"));
            }
        });
        return ids;
    }

    private boolean isParent(DynamicObject e, Long nodeId, Map<Long, DynamicObject> idDys) {
        while (e != null) {
            if (e.getLong("id") == nodeId.longValue()) {
                return true;
            }
            e = idDys.get(e.getLong("parent"));
        }
        return false;
    }

    public void newTemplateCatalog(Long nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(ctl_model, this.getPageCache().get("KEY_MODEL_ID"));
        params.put("type", DI_CATALOG_TYPE);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "di_schemecatalog_edit");
        if (isAddNew) {
            Long id = nodeId;
            params.put("parent", id);
            this.showForm("di_schemecatalog_edit", params, closeCallBack, ShowType.Modal, 0L);
        } else if (nodeId.toString().equals(this.getPageCache().get("headnodeid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ISSchemeListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.showForm("di_schemecatalog_edit", params, closeCallBack, ShowType.Modal, nodeId);
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, Long id) {
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"DISchemeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            params.put("id", id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public boolean validate() {
        String modulid = this.getPageCache().get("KEY_MODEL_ID");
        return StringUtils.isNotEmpty((CharSequence)modulid);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                Long catalogId = Long.valueOf(this.getPageCache().get("focusnodeid"));
                this.addNew(catalogId);
                break;
            }
            case "btn_enable": {
                this.enableScheme("1");
                break;
            }
            case "btn_disenable": {
                this.enableScheme("0");
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_importmode": {
                this.actionOpenForm("di_importmodelist");
                break;
            }
            case "btn_base": {
                this.actionOpenForm("di_isbaseentlist");
                break;
            }
            case "btn_dimmap": {
                this.actionOpenDimMapList();
                break;
            }
            case "btn_rule": {
                this.actionOpenForm("di_derive_rule_list");
                break;
            }
            case "btn_assign": {
                this.actionOpenForm("di_schemeassign");
                break;
            }
            case "btn_numbermap": {
                this.actionOpenForm("di_membermapping");
                break;
            }
            case "btn_codetail": {
                this.actionOpenReportForm("di_executdetailreport");
                break;
            }
            case "btn_collect": {
                this.actionOpenForm("di_executejob");
                break;
            }
        }
    }

    public void actionOpenForm(String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void actionOpenReportForm(String formId) {
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void actionOpenDimMapList() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("di_dimmaplist");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void actionDelete() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISSchemeListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
        DynamicObjectCollection assignSchemeCol = QueryServiceHelper.query((String)"bcm_schemeassignentity", (String)"scheme", (QFilter[])new QFBuilder().add(ctl_model, "=", (Object)this.getModelId()).add("scheme", "=", primaryKeyValue).toArray());
        if (assignSchemeCol.size() != 0) {
            this.showDeleteConfirmForm(primaryKeyValue, ResManager.loadKDString((String)"\u6240\u9009\u96c6\u6210\u65b9\u6848\u5df2\u5206\u914d\uff0c\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.showDeleteConfirmForm(primaryKeyValue, ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showDeleteConfirmForm(Object schemeId, String msg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("di_schemedeleteconfirm");
        parameter.setCustomParam("msg", (Object)msg);
        parameter.setCustomParam("schemeId", schemeId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "confirm_schemedelete"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void enableScheme(String status) {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISSchemeListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        Long schemeId = (Long)rows.get(0).getPrimaryKeyValue();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)schemeId);
        DynamicObject dos = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, enable, status,note", (QFilter[])qfBuilder.toArray());
        if (!dos.getBoolean("enable")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7ef4\u5ea6\u6620\u5c04\u4e3a\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u8fdb\u884c\u542f\u7528/\u7981\u7528\u3002", (String)"ISSchemeListPlugin_59", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ISSchemeListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        if ("1".equals(status)) {
            msg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ISSchemeListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        scheme.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        this.refreshBillList();
        this.getView().showSuccessNotification(msg);
    }

    private void addNew(Long catalogId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_schemeedit");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        showParameter.setCustomParam(ctl_schemecatalog, (Object)catalogId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u65b0\u589e", (String)"DISchemeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "di_schemeedit"));
        this.getView().showForm(showParameter);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    private void openEditDISchemeForm(Object schemeId) {
        FormShowParameter formView = new FormShowParameter();
        formView.setFormId("di_schemeedit");
        formView.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formView.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u4fee\u6539", (String)"DISchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formView.setCustomParam("scheme", schemeId);
        if (DIIntegrationUtil.isWriteSchemePerm((long)LongUtil.toLong((Object)schemeId), (long)this.getModelId())) {
            formView.setStatus(OperationStatus.EDIT);
        } else {
            formView.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(formView);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "di_schemecatalog_edit": {
                this.closeAddCatalog(evt);
                break;
            }
            case "confirm_schemedelete": {
                if (evt.getReturnData() == null) break;
                if (((Boolean)evt.getReturnData()).booleanValue()) {
                    this.getPageCache().put("deleteExtendsTable", "true");
                }
                this.deleteConfirm();
                break;
            }
        }
    }

    public void closeAddCatalog(ClosedCallBackEvent evt) {
        JSONArray ids;
        JSONArray jSONArray = ids = evt.getReturnData() == null ? null : new JSONArray((List)evt.getReturnData());
        if (ids != null && ids.size() > 0) {
            this.refreshTree();
            String nodeid = ids.get(0).toString();
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            for (Map m : treeList) {
                if (!nodeid.equals(m.get("id"))) continue;
                TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                ((TreeView)this.getControl(ctl_schemecatalog)).focusNode(node);
                this.getPageCache().put("focusnodeid", nodeid);
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ISSchemeListPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "deletecatalog_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                this.deletecatalog(this.getModelId());
                break;
            }
        }
    }

    private void deleteConfirm() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        Long id = LongUtil.toLong((Object)billList.getFocusRowPkId());
        this.checkDeleteStatus(id);
        this.doDelete(id);
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void checkDeleteStatus(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        filter.and("status", "=", (Object)"1");
        if (QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])new QFilter[]{filter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ISDimMappingV2Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void deletecatalog(Long modelId) {
        TreeView tree = (TreeView)this.getControl(ctl_schemecatalog);
        Map map = tree.getTreeState().getFocusNode();
        Long nodeId = LongUtil.toLong(map.get("id"));
        QFilter filter = new QFilter("id", "in", this.getTempIds(nodeId, modelId));
        BusinessDataWriter.delete((String)"bcm_schemecatalog", (QFilter[])new QFilter[]{filter});
        this.refreshTree();
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void doDelete(Long id) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updateIntergrationLog(id);
                this.deleteWithExtendTable(id);
                this.deleteDsData(id);
                QFilter filter = new QFilter("id", "=", (Object)id);
                DeleteServiceHelper.delete((String)"bcm_isscheme", (QFilter[])new QFilter[]{filter});
                filter = new QFilter("scheme", "=", (Object)id);
                DynamicObjectCollection maps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])new QFilter[]{filter});
                ArrayList<Long> mapids = new ArrayList<Long>(10);
                if (maps != null) {
                    for (DynamicObject map : maps) {
                        mapids.add(map.getLong("id"));
                    }
                }
                QFilter dimmapfilter = new QFilter("dimmapid", "in", mapids);
                DeleteServiceHelper.delete((String)"bcm_ismapjson", (QFilter[])new QFilter[]{dimmapfilter});
                DeleteServiceHelper.delete((String)"bcm_schemeassignentity", (QFilter[])new QFilter[]{filter});
                DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter[]{filter});
                DeleteServiceHelper.delete((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{filter});
                QFilter schemefilter = new QFilter("schemeid", "=", (Object)id);
                DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter[]{schemefilter});
                DeleteServiceHelper.delete((String)"bcm_isgroupmap", (QFilter[])new QFilter[]{schemefilter});
                PermClassEntityHelper.deleteEntities(Collections.singletonList(id), (Long)this.getModelId());
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    private void deleteDsData(Long id) {
        DynamicObject[] tableRoute;
        QFilter idQf = new QFilter("id", "=", (Object)id);
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id,iscdatacopytrigger,iscdatacopy,targetobj,issrc", (QFilter[])new QFilter[]{idQf});
        HashSet<Long> triggerSet = new HashSet<Long>(16);
        HashSet<Long> copySet = new HashSet<Long>(16);
        HashSet<Long> objSet = new HashSet<Long>(16);
        QFilter schemeQf = new QFilter("scheme", "in", this.getIdsBySchemes(schemes));
        for (DynamicObject route : tableRoute = BusinessDataServiceHelper.load((String)"di_tableroute", (String)"targetobj,iscdatacopy,iscdatacopytrigger", (QFilter[])new QFilter[]{schemeQf})) {
            DynamicObject targetobj;
            DynamicObject iscdatacopy;
            DynamicObject iscdatacopytrigger = route.getDynamicObject("iscdatacopytrigger");
            if (iscdatacopytrigger != null) {
                triggerSet.add(iscdatacopytrigger.getLong("id"));
            }
            if ((iscdatacopy = route.getDynamicObject("iscdatacopy")) != null) {
                copySet.add(iscdatacopy.getLong("id"));
            }
            if ((targetobj = route.getDynamicObject("targetobj")) == null) continue;
            objSet.add(targetobj.getLong("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"isc_data_copy_trigger", (QFilter[])new QFilter[]{new QFilter("id", "in", triggerSet)});
            DeleteServiceHelper.delete((String)"isc_data_copy", (QFilter[])new QFilter[]{new QFilter("id", "in", copySet)});
            DeleteServiceHelper.delete((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("id", "in", objSet)});
        }
        DeleteServiceHelper.delete((String)"di_tableroute", (QFilter[])new QFilter[]{schemeQf});
    }

    private List<Long> getIdsBySchemes(DynamicObject[] schemes) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : schemes) {
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    private void deleteWithExtendTable(Long id) {
        DIIntegrationUtil.clearTableRoute((long)id);
        if (this.getPageCache().get("deleteExtendsTable") != null) {
            String tableName = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isscheme", (String)"extendstable").getString("extendstable");
            DIIntegrationUtil.dropTable((String)tableName);
            this.getPageCache().remove("deleteExtendsTable");
        }
    }

    private void updateIntergrationLog(Long id) {
        DynamicObject[] load;
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id,number,name,versionnumber", (QFilter[])new QFilter[]{filter});
        filter = new QFilter("scheme", "=", (Object)id);
        String fieldStr = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"di_isschemecollectlog").getAllFields().keySet());
        for (DynamicObject doj : load = BusinessDataServiceHelper.load((String)"di_isschemecollectlog", (String)fieldStr, (QFilter[])new QFilter[]{filter})) {
            doj.set("preschemenumber", (Object)schemeDyn.getString("number"));
            doj.set("preschemename", (Object)schemeDyn.getString("name"));
            doj.set("preschemeversion", (Object)schemeDyn.getString("versionnumber"));
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    public QFilter getFilter() {
        String nodeid = this.getPageCache().get("focusnodeid");
        if (nodeid == null) {
            return new QFilter("1", "=", (Object)0);
        }
        boolean isallchild = Boolean.parseBoolean(this.getView().getModel().getValue(ctl_checkbox_tree).toString());
        QFilter qFilter = new QFilter(ctl_schemecatalog, "=", (Object)ConvertUtil.convertStrToLong((String)nodeid));
        if (isallchild) {
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            ArrayList<String> list = new ArrayList<String>(10);
            this.queryAllChildNodeList(nodeid, treeList, list);
            if (list.size() > 0) {
                qFilter.or(new QFilter(ctl_schemecatalog, "in", (Object)ConvertUtil.convertListToLong(list)));
            }
        }
        qFilter.and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
        return qFilter;
    }

    private List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        BillList list = (BillList)this.getControl(ctl_billlistap);
        this.openEditDISchemeForm(list.getFocusRowPkId());
    }
}

