/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.di.SelectDimDTO;
import kd.fi.bcm.formplugin.intergration.util.DISchemeUtil;

public class DISetDimPlugin
extends AbstractBaseFormPlugin {
    protected static final String entryentity = "entryentity";
    protected static final String entryentity1 = "entryentity1";
    private static final String DIM_IDS = "dimids";
    private static final String TYPE = "type";
    private static final String TAG_DIM = "tagdim";
    private static final String SRC_DIM = "srcdim";
    private static final String SCHEME = "scheme";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("addoneb", "deloneb", "imageup", "imagedown", "btnok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam(SCHEME);
        String DimIds = (String)this.getView().getFormShowParameter().getCustomParam(DIM_IDS);
        String type = (String)this.getView().getFormShowParameter().getCustomParam(TYPE);
        this.getModel().setValue(TYPE, (Object)type);
        String[] tagIdsStr = null;
        ArrayList<Long> ids = new ArrayList(4);
        if (kd.bos.util.StringUtils.isNotEmpty((String)DimIds)) {
            tagIdsStr = DimIds.split(",");
            ids = Arrays.stream(tagIdsStr).map(s -> LongUtil.toLong((Object)s)).collect(Collectors.toList());
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        if (!StringUtils.isEmpty((CharSequence)modelId)) {
            this.setDimDate2View(modelId, type, schemeId);
            this.setDimOrder2View(modelId, ids, type, schemeId);
            this.getPageCache().put(entryentity1, SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(entryentity1)));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        IDataModel model = this.getModel();
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String type = this.getModel().getValue(TYPE).toString();
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        switch (key) {
            case "addoneb": {
                int row = eg.getEntryState().getFocusRow();
                Long id = LongUtil.toLong((Object)model.getValue("id", row));
                if (row < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u7ef4\u5ea6\u3002", (String)"DISetDimPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String selectFields = "id,number,name";
                DynamicObject queryResult = new DynamicObject();
                if (TAG_DIM.equals(type)) {
                    queryResult = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                } else if (SRC_DIM.equals(type)) {
                    queryResult = QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                }
                if (queryResult == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u672a\u627e\u5230\u8be5\u7ef4\u5ea6\u3002", (String)"DISetDimPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String isMulti = (String)this.getView().getFormShowParameter().getCustomParam("ismulti");
                int entryRowCount = this.getModel().getEntryRowCount(entryentity1);
                if (!Boolean.parseBoolean(isMulti) && entryRowCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u96c6\u6210\uff0c\u53ea\u5141\u8bb8\u9009\u62e91\u4e2a\u7ef4\u5ea6\u3002", (String)"DISetDimPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String dimId = queryResult.getString("id");
                if (this.checkRepeatDim(dimId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u5df2\u9009\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\u3002", (String)"DISetDimPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryentity1);
                Map state = entryGrid.getEntryState().getState();
                Object getRow = state.get("row");
                Object selRows = state.get("selRows");
                ArrayList selRowsList = new ArrayList();
                if (selRows instanceof ArrayList) {
                    for (Object o : (List)selRows) {
                        selRowsList.add(Integer.class.cast(o));
                    }
                }
                int rowIndex = selRowsList.size() == 0 ? entryRowCount - 1 : (Integer)getRow;
                int[] rows = model.appendEntryRow(entryentity1, rowIndex, 1);
                int index = 0;
                model.setValue("mid1", (Object)queryResult.getString("id"), rows[index]);
                model.setValue("mnum1", (Object)queryResult.getString("number"), rows[index]);
                model.setValue("mname1", (Object)queryResult.getString("name"), rows[index]);
                break;
            }
            case "deloneb": {
                EntryGrid eg1 = (EntryGrid)this.getControl(entryentity1);
                int delRow = eg1.getEntryState().getFocusRow();
                if (delRow < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"SetOrderPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                model.deleteEntryRow(entryentity1, delRow);
                break;
            }
            case "btnok": {
                DynamicObjectCollection doc = model.getEntryEntity(entryentity1);
                ArrayList selectDimDTOList = new ArrayList(doc.size());
                if (doc.size() > 0) {
                    doc.stream().forEach(obj -> {
                        SelectDimDTO selectDimDTO = new SelectDimDTO();
                        selectDimDTO.setId(obj.getString("mid1"));
                        selectDimDTO.setName(obj.getString("mname1"));
                        selectDimDTO.setNumber(obj.getString("mnum1"));
                        selectDimDTO.setType(type);
                        selectDimDTOList.add(selectDimDTO);
                    });
                    this.getView().returnDataToParent(selectDimDTOList);
                    this.getView().close();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u540e\u91cd\u8bd5\u3002", (String)"SetOrderPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean checkRepeatDim(String dimId) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryentity1);
        List Ids = entryEntity.stream().map(dyn -> dyn.getString("mid1")).collect(Collectors.toList());
        if (Ids.contains(dimId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setDimDate2View(String modelid, String type, String schemeId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection temlist = this.getDimColls(modelid, type, schemeId);
        if (temlist.size() > 0) {
            int[] rowsAll = model.batchCreateNewEntryRow(entryentity, temlist.size());
            int indexAll = 0;
            for (DynamicObject template : temlist) {
                model.setValue("number", (Object)template.getString("number"), rowsAll[indexAll]);
                model.setValue("name", (Object)template.getString("name"), rowsAll[indexAll]);
                model.setValue("id", (Object)template.getString("id"), rowsAll[indexAll]);
                ++indexAll;
            }
        }
    }

    private void setDimOrder2View(String modelId, List<Long> ids, String type, String schemeId) {
        IDataModel model = this.getModel();
        String selectFields = "id,name,number";
        DynamicObjectCollection sortDimData = new DynamicObjectCollection();
        if (TAG_DIM.equals(type)) {
            sortDimData = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)).and("id", "in", ids)});
        } else if (SRC_DIM.equals(type)) {
            sortDimData = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(SCHEME, "=", (Object)LongUtil.toLong((Object)schemeId)).and("id", "in", ids)});
        }
        Map<Long, DynamicObject> objMap = this.getObjMap(sortDimData);
        sortDimData = this.afterSortDimData(ids, objMap);
        if (sortDimData.size() > 0) {
            int[] rowsAll = model.batchCreateNewEntryRow(entryentity1, sortDimData.size());
            int indexAll = 0;
            for (DynamicObject template : sortDimData) {
                model.setValue("mnum1", (Object)template.getString("number"), rowsAll[indexAll]);
                model.setValue("mname1", (Object)template.getString("name"), rowsAll[indexAll]);
                model.setValue("mid1", (Object)template.getString("id"), rowsAll[indexAll]);
                ++indexAll;
            }
        }
    }

    private Map<Long, DynamicObject> getObjMap(DynamicObjectCollection sortDimData) {
        HashMap<Long, DynamicObject> dimMap = new HashMap<Long, DynamicObject>(sortDimData.size());
        sortDimData.stream().forEach(dyn -> dimMap.put(dyn.getLong("id"), (DynamicObject)dyn));
        return dimMap;
    }

    private DynamicObjectCollection afterSortDimData(List<Long> ids, Map<Long, DynamicObject> objMap) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (Long id : ids) {
            dynamicObjects.add((Object)objMap.get(id));
        }
        return dynamicObjects;
    }

    private DynamicObjectCollection getDimColls(String modelId, String type, String schemeId) {
        QFilter filterModelId = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter filterSchemeId = new QFilter(SCHEME, "=", (Object)LongUtil.toLong((Object)schemeId));
        String selectFields = "id,number,name";
        DynamicObjectCollection queryResult = new DynamicObjectCollection();
        if (TAG_DIM.equals(type)) {
            queryResult = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])new QFilter[]{filterModelId}, (String)"dseq asc");
        } else if (SRC_DIM.equals(type)) {
            Set<String> textMetricList = DISchemeUtil.getSchemeTextMetric(LongUtil.toLong((Object)schemeId));
            if (textMetricList.size() > 0) {
                QFilter excludeNumber = new QFilter("number", "not in", textMetricList);
                filterSchemeId.and(excludeNumber);
            }
            queryResult = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)selectFields, (QFilter[])new QFilter[]{filterSchemeId}, (String)"number");
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        queryResult.forEach(c -> result.add(c));
        return result;
    }
}

