/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.intergration.di.DIMemberMappingPlugin;
import kd.fi.bcm.formplugin.intergration.membermap.handel.AbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public abstract class DiAbstractMemMapSheetHandel {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractMemMapSheetHandel.class);
    protected static final String TREEVIEW = "treeviewap";
    protected static final int EQUAL_LEVEL = 1000;
    protected static final int IN_LEVEL = 2000;
    protected static final int BETWEEN_LEVEL = 3000;
    protected static final int LIKE_LEVEL = 4000;
    protected static final int NOTEQUAL_LEVEL = 5000;
    protected static final int NOTIN_LEVEL = 6000;
    protected static final int NOTBETWEEN_LEVEL = 7000;
    protected static final int NOTLIKE_LEVEL = 8000;
    protected static final int STAR_LEVEL = 9000;
    private static final int STEP = 100;
    protected static final int CHANGESIGN_INDEX = 0;
    protected static final String ALL = "*";
    protected DIMemberMappingPlugin plugin;
    protected String spreadKey;
    protected SpreadManager sm;
    protected MemAndComVO vo;
    protected Map<String, Integer> srcSignColIndex;
    protected Map<String, Integer> targetSignColIndex;
    protected Map<String, Integer> otherSignColIndex;
    protected Map<Integer, String> colSignIndex;
    protected int maxrow;
    protected int maxcol;

    protected abstract void buildSheet();

    protected String getSelectFiled() {
        return IntegrationUtil.getSelectField((Boolean)false);
    }

    protected String getDynamicObjectType() {
        return "bcm_isgroupmap";
    }

    protected QFilter getRebuildDataFilter() {
        return new QFilter("srctype", "=", (Object)"1");
    }

    protected abstract void checkBeforeSave(Map<String, Integer> var1);

    protected abstract void fillData(Map<String, Integer> var1);

    protected abstract boolean showLevel();

    protected abstract boolean showOrder();

    public DiAbstractMemMapSheetHandel(DIMemberMappingPlugin plugin) {
        this.plugin = plugin;
        this.spreadKey = plugin.getSpreadKey();
        this.sm = plugin.getSpreadManager();
        this.vo = plugin.getMemAndComVO();
        int num = this.vo.getSourcePro().size() + this.vo.getTargetPro().size();
        this.maxcol = num * 2 + 10;
        this.initMaxRow();
    }

    private void initMaxRow() {
        this.maxrow = 2000;
        String entity = ((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getEntityName();
        if (DimEntityNumEnum.INTERCOMPANY.getEntityNum().equals(entity) || DimEntityNumEnum.MYCOMPANY.getEntityNum().equals(entity) || DimEntityNumEnum.ENTITY.getEntityNum().equals(entity)) {
            this.maxrow = 10000;
        }
    }

    public void buildSpread() {
        log.startWatch();
        log.warn("DiAbstractMemMapSheetHandel: queryDimmapping");
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
        log.warn("DiAbstractMemMapSheetHandel: else");
        this.sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        this.rebuildData();
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.allowExtendPasteRange.k(), (Object)true));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)false));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.defaultDragFillType.k(), (Object)0));
        this.plugin.cacheSpreadModel(this.sm);
        log.infoEnd("DiAbstractMemMapSheetHandel: end");
    }

    public void clearSpread() {
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
    }

    public void beforeUpdateMulValue(NotifyEvent event) {
        event.setCancel(true);
        SpreadPostDataInfo data = (SpreadPostDataInfo)event.getParam();
        List value = data.getValues();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        invoker.setBatch(true);
        for (LinkedHashMap map : value) {
            Cell cell = this.getSheet().getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue());
            String sign = this.getSignByCol((Integer)map.get("c"));
            String valueString = map.get("v") == null ? "" : map.get("v").toString().trim();
            this.setCellChange(cell);
            if (StringUtils.isNotEmpty((String)sign)) {
                if (this.isSrcSign(sign)) {
                    cell.setValue((Object)valueString);
                } else if (this.isTargetSign(sign)) {
                    this.targetValueChange(invoker, cell, sign, valueString);
                } else if (this.isEnum(sign)) {
                    this.enumValueChange(invoker, cell, sign, valueString);
                } else {
                    this.commonValueChange(invoker, cell, sign, valueString);
                }
                this.updateOtherCol((Integer)map.get("r"), sign, valueString, invoker);
                continue;
            }
            cell.setValue((Object)valueString);
        }
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    public void afterUpdataValue(EventObject e) {
        Cell cell = (Cell)e.getSource();
        Cell head = this.getHeader(cell.getCol());
        if (head != null) {
            this.setCellChange(cell);
        }
    }

    private void rebuildData() {
        this.buildSheet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        invoker.setBatch(true);
        String selectFiled = this.getSelectFiled();
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)this.getDynamicObjectType(), (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId()).and(this.getRebuildDataFilter())}, (String)"dseq");
        if (doc != null && doc.length > this.maxrow) {
            this.insertRowFromInxdex(this.maxrow - 1, doc.length - this.maxrow + 10);
        }
        int row = 2;
        log.warn("AbstractMemMapSheetHandel: rebuilddata start");
        HashMap<Long, Integer> tarDimIndex = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> srcDimIndex = new HashMap<Long, Integer>(16);
        this.buildIndexMapById(tarDimIndex, srcDimIndex);
        if (doc != null && doc.length > 0) {
            for (DynamicObject obj : doc) {
                Cell cell = this.getSheet().getCell(row, 0);
                cell.setUserObject("id", obj.get("id"));
                cell.setUserObject("seq", obj.get("dseq"));
                this.rebuildData(row, obj, invoker, tarDimIndex, srcDimIndex);
                ++row;
            }
        }
        log.warn("AbstractMemMapSheetHandel: rebuilddata end");
        invoker.startToInvoke();
    }

    protected void rebuildData(int row, DynamicObject rowData, SpreadEasyInvoker invoker, Map<Long, Integer> tarDimIndex, Map<Long, Integer> srcDimIndex) {
        String value;
        int col = 0;
        if (this.showLevel()) {
            value = rowData.getString("level");
            this.setValueUnChange(row, col, value);
            invoker.updataValue(row, col, value);
            ++col;
        }
        if (this.showOrder()) {
            value = rowData.getString("order");
            this.setValueUnChange(row, col, value);
            invoker.updataValue(row, col, value);
            ++col;
        }
        DynamicObjectCollection tars = rowData.getDynamicObjectCollection("isgrouptargmapentry");
        for (DynamicObject tar : tars) {
            long dimensionId = tar.getLong("tardimension");
            int index = tarDimIndex.get(dimensionId);
            String number = tar.getString("tarmembnumber");
            String name = tar.getString("tarmembname");
            this.setValueUnChange(row, index, number);
            invoker.updataValue(row, index, number);
            this.setValueUnChange(row, index + 1, name);
            invoker.updataValue(row, index + 1, name);
        }
        col += this.vo.getTargetPro().size() * 2;
        if (this.showComputeOprt()) {
            value = rowData.getString("computeoprt");
            ComputeOprtEnum c = ComputeOprtEnum.getEnumByid((String)value);
            if (c != null) {
                this.setValueUnChange(row, col, c.getIndex());
                invoker.updataValue(row, col, c.getSymbol());
            }
            value = rowData.getString("weight");
            this.setValueUnChange(row, ++col, value);
            invoker.updataValue(row, col, value);
        }
        DynamicObjectCollection srcs = rowData.getDynamicObjectCollection("isgroupsrcmapentry");
        HashMap<Long, List> srcMap = new HashMap<Long, List>(16);
        for (DynamicObject src : srcs) {
            long dimensionId = src.getLong("srcdimension");
            srcMap.computeIfAbsent(dimensionId, l -> new ArrayList());
            List members = (List)srcMap.get(dimensionId);
            members.add(src);
        }
        srcMap.forEach((dimId, v) -> {
            if (v.isEmpty()) {
                return;
            }
            int index = (Integer)srcDimIndex.get(dimId);
            String number = this.getSrcNumber((List<DynamicObject>)v);
            this.setValueUnChange(row, index, number);
            invoker.updataValue(row, index, number);
            String name = ((DynamicObject)v.get(0)).getString("srcmembname");
            this.setValueUnChange(row, index + 1, name);
            invoker.updataValue(row, index + 1, name);
        });
    }

    private String getSrcNumber(List<DynamicObject> members) {
        int scope = members.get(0).getInt("scope");
        StringBuilder sb = new StringBuilder();
        switch (MapScopeEnum.getEnumByindex((int)scope)) {
            case EQUALS: {
                return members.get(0).getString("srcmembnumber");
            }
            case RANGE: {
                sb.append("between(");
                break;
            }
            case LIKE: {
                sb.append("like(");
                break;
            }
            case INCLUDE: {
                sb.append("in(");
                break;
            }
            case NOT_EQUALS: {
                sb.append("notequal(");
                break;
            }
            case NOT_RANGE: {
                sb.append("notbetween(");
                break;
            }
            case NOT_LIKE: {
                sb.append("notlike(");
                break;
            }
            case NOT_INCLUDE: {
                sb.append("notin(");
            }
        }
        members.forEach(m -> sb.append(m.getString("srcmembnumber")).append(","));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    protected MemAndComVO.Node getEntityByTar(long id) {
        for (MemAndComVO.Node n : this.vo.getTargetPro()) {
            if (n.getId() != id) continue;
            return n;
        }
        return null;
    }

    private void buildIndexMapById(Map<Long, Integer> tarDimIndex, Map<Long, Integer> srcDimIndex) {
        this.initSignColMap();
        this.vo.getTargetPro().forEach(node -> {
            long dimId = node.getId();
            String dimNum = MemberReader.getDimensionNumById((long)dimId);
            this.targetSignColIndex.forEach((k, v) -> {
                String num = this.getDimNumberByKey((String)k);
                if (dimNum.equals(num)) {
                    tarDimIndex.put(dimId, (Integer)v);
                }
            });
        });
        this.vo.getSourcePro().forEach(node -> {
            long dimId = node.getId();
            String dimNum = BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"bcm_isbaseentlist").getString("number");
            this.srcSignColIndex.forEach((k, v) -> {
                String num = this.getDimNumberByKey((String)k);
                if (dimNum.equals(num)) {
                    srcDimIndex.put(dimId, (Integer)v);
                }
            });
        });
    }

    public void insertRowFromInxdex(int row, int num) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            insertdata.add(row);
        }
        AskExcuteInfo excuteinfo = new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCon(true);
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.plugin.updateRowAndCol(excuteinfo);
    }

    private DynamicObject getJsonObject(boolean isnew) {
        QFilter qf = new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId());
        if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
            qf.and(new QFilter("type", "=", (Object)"2"));
        } else {
            qf.and(new QFilter("type", "<>", (Object)"2"));
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bcm_ismapjson", (String)"spreadjson,data", (QFilter[])new QFilter[]{qf});
        if (obj == null && isnew) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ismapjson");
            obj.set("dimmapid", (Object)this.vo.getDimMapId());
            if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
                obj.set("type", (Object)"2");
            } else {
                obj.set("type", (Object)"1");
            }
        }
        return obj;
    }

    protected Sheet getSheet() {
        return this.sm.getBook().getSheet(0);
    }

    protected boolean isAllNone(int row) {
        for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
            Cell cell;
            String sign = this.getSignByCol(col);
            if (sign == null || this.cellIsNull(cell = this.getSheet().getCell(row, col))) continue;
            return false;
        }
        return true;
    }

    protected boolean srcTargetAllNone(int row) {
        for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
            Cell cell;
            String sign = this.getSignByCol(col);
            if (sign == null || !this.isSrcSign(sign) && !this.isTargetSign(sign) || this.cellIsNull(cell = this.getSheet().getCell(row, col))) continue;
            return false;
        }
        return true;
    }

    public Pair<Map<Long, DynamicObject>, List<DynamicObject>> collectDynamicObjects(List<Cell> cells) {
        ArrayList<DynamicObject> updateRow = new ArrayList<DynamicObject>();
        HashMap<Integer, Object> editids = new HashMap<Integer, Object>();
        HashMap<Long, DynamicObject> insertRow = new HashMap<Long, DynamicObject>(16);
        DynamicObject sc = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isdimmap", (String)"scheme.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.vo.getDimMapId())});
        long scheme = sc.getLong("scheme.id");
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, 0);
            boolean isAllNone = this.isAllNone(row);
            if (cell.getUserObject("ischange") == null) {
                if (isAllNone) continue;
                cells.add(cell);
                continue;
            }
            Object id = cell.getUserObject("id");
            if (id == null) {
                if (isAllNone) {
                    cell.removeUserObject("ischange");
                    continue;
                }
                DynamicObject object = this.packDynamicObject(row);
                id = GlobalIdUtil.genGlobalLongId();
                object.set("schemeid", (Object)scheme);
                object.set("dimmapid", (Object)this.vo.getDimMapId());
                object.set("id", id);
                this.setCreateTimeAndUser(object);
                this.setModifyTimeAndUser(object);
                insertRow.put((Long)id, object);
                cell.setUserObject("id", id);
                cell.setUserObject("isnew", (Object)true);
            } else {
                if (isAllNone) {
                    cell.removeUserObject("id");
                    cell.removeUserObject("ischange");
                    continue;
                }
                editids.put(row, id);
            }
            cell.removeUserObject("ischange");
            cells.add(cell);
        }
        if (editids.size() > 0) {
            DynamicObject[] docs = BusinessDataServiceHelper.load((Object[])editids.values().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)this.getDynamicObjectType()).getDynamicObjectType());
            Map<Object, DynamicObject> col = this.resultToMap(docs);
            for (Map.Entry v : editids.entrySet()) {
                DynamicObject object = this.updateDynamicObject((Integer)v.getKey(), col.get(v.getValue()));
                this.setModifyTimeAndUser(object);
                updateRow.add(object);
            }
        }
        return Pair.onePair(insertRow, updateRow);
    }

    private Map<Object, DynamicObject> resultToMap(DynamicObject[] objects) {
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject ob : objects) {
            map.put(ob.get("id"), ob);
        }
        return map;
    }

    protected void setCreateTimeAndUser(DynamicObject object) {
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
    }

    protected void setModifyTimeAndUser(DynamicObject object) {
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)TimeServiceHelper.now());
    }

    protected String getEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    protected Map<String, Object> getStyleMap(boolean setFrame) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#b2b2b2");
        if (setFrame) {
            HashMap<String, String[]> styleMap0 = new HashMap<String, String[]>();
            styleMap0.put("bls", new String[]{"thin"});
            styleMap0.put("blc", new String[]{"#000000"});
            styleMap.put("bl", styleMap0);
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        return styleMap;
    }

    protected Object getSSid() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        DynamicObject oriSys = scheme.getDynamicObject("isscheme");
        return oriSys == null ? null : oriSys.get("id");
    }

    protected void setValueUnChange(int row, int col, Object value) {
        Cell cell = this.getSheet().getCell(row, col);
        cell.setValue(value);
        cell.setChangeVal(false);
    }

    public final IFormView getView() {
        return this.plugin.getView();
    }

    protected boolean isEnum(String sign) {
        return sign.startsWith("_enum_");
    }

    protected void enumValueChange(SpreadEasyInvoker invoker, Cell cell, String sign, String value) {
        ComputeOprtEnum c;
        String index = null;
        String name = null;
        if ("_enum_computeoprt".equals(sign) && (c = ComputeOprtEnum.getEnumBySymbol((String)value)) != null) {
            index = c.getIndex();
            name = c.getSymbol();
        }
        invoker.updataValue(cell.getRow(), cell.getCol(), name);
        cell.setValue((Object)index);
    }

    protected void targetValueChange(SpreadEasyInvoker invoker, Cell cell, String sign, String value) {
        String dimNumber = this.getDimNumberByKey(sign);
        if (this.isSpecialNumber(value, dimNumber)) {
            cell.setValue((Object)value.toUpperCase(Locale.ENGLISH));
            invoker.updataValue(cell.getRow(), cell.getCol() + 1, value.toUpperCase(Locale.ENGLISH).trim());
            invoker.updataValue(cell.getRow(), cell.getCol(), value.toUpperCase(Locale.ENGLISH).trim());
        } else {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.plugin.getModelNumber(), (String)dimNumber, (String)value);
            if (!IDNumberTreeNode.NotFoundTreeNode.equals(node)) {
                cell.setValue((Object)value);
                invoker.updataValue(cell.getRow(), cell.getCol(), value);
                this.getSheet().getCell(cell.getRow(), cell.getCol() + 1).setValue((Object)node.getName());
                invoker.updataValue(cell.getRow(), cell.getCol() + 1, node.getName());
            } else {
                cell.setValue(null);
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol() + 1, null);
                if (StringUtils.isNotEmpty((String)value)) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u76ee\u6807\u7cfb\u7edf\u6210\u5458\u5728\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u9664\u3002", (String)"SingleMemMapSheetHandel_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected boolean isSpecialNumber(String value, String dimNumber) {
        return ALL.equals(value) || "IGNORE".equalsIgnoreCase(value) || "$ECur".equals(value) && "MyCompany".equals(dimNumber);
    }

    private void commonValueChange(SpreadEasyInvoker invoker, Cell cell, String sign, String value) {
        if (StringUtils.isEmpty((String)value)) {
            cell.setValue(null);
            invoker.updataValue(cell.getRow(), cell.getCol(), null);
            return;
        }
        if ("order".equals(sign)) {
            try {
                int order = Integer.parseInt(value);
                if (order <= 0) {
                    cell.setValue(null);
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53ea\u80fd\u5f55\u5165\u6b63\u6574\u6570\u3002", (String)"DiAbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                cell.setValue((Object)order);
            }
            catch (Exception e) {
                cell.setValue(null);
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u53ea\u80fd\u5f55\u5165\u6b63\u6574\u6570\u3002", (String)"DiAbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if ("weight".equals(sign)) {
            try {
                BigDecimal weight = new BigDecimal(value);
                weight = weight.stripTrailingZeros();
                if (weight.precision() > 23) {
                    weight = new BigDecimal(weight.toPlainString().substring(0, 23));
                }
                if (weight.scale() > 10) {
                    weight = weight.setScale(10, 1);
                }
                cell.setValue((Object)weight.doubleValue());
                invoker.updataValue(cell.getRow(), cell.getCol(), weight.toPlainString());
            }
            catch (Exception e) {
                cell.setValue(null);
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u91cd\u53ea\u80fd\u5f55\u5165\u6570\u503c\u3002", (String)"DiAbstractMemMapSheetHandel_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void updateOtherCol(int row, String sign, String value, SpreadEasyInvoker invoker) {
        if (this.isSrcSign(sign) || this.isTargetSign(sign)) {
            if (this.showOrder() && this.srcTargetAllNone(row)) {
                Cell order = this.getSheet().getCell(row, this.getOtherColByEntity("order"));
                order.setValue(null);
                invoker.updataValue(order.getRow(), order.getCol(), null);
            }
            if (this.showComputeOprt()) {
                Cell opp = this.getSheet().getCell(row, this.getOtherColByEntity("_enum_computeoprt"));
                Cell weight = this.getSheet().getCell(row, this.getOtherColByEntity("weight"));
                if (this.srcTargetAllNone(row)) {
                    opp.setValue(null);
                    invoker.updataValue(opp.getRow(), opp.getCol(), null);
                    weight.setValue(null);
                    invoker.updataValue(weight.getRow(), weight.getCol(), null);
                } else {
                    if (opp.getValue() == null || StringUtils.isEmpty((String)opp.getValue().toString().trim())) {
                        opp.setValue((Object)ComputeOprtEnum.PLUS.getIndex());
                        invoker.updataValue(opp.getRow(), opp.getCol(), ComputeOprtEnum.PLUS.getSymbol());
                    }
                    if (weight.getValue() == null || StringUtils.isEmpty((String)weight.getValue().toString().trim())) {
                        weight.setValue((Object)1);
                        invoker.updataValue(weight.getRow(), weight.getCol(), 1);
                    }
                }
            }
        }
    }

    protected String getDimNumberByKey(String key) {
        if (key.contains("!")) {
            return key.split("!")[1];
        }
        return key;
    }

    protected Cell getHeader(int col) {
        int maxrow = this.getSheet().getMaxRowCount();
        for (int i = 1; i < maxrow; ++i) {
            Cell cell = this.getSheet().getCell(i, col);
            if (cell.getUserObject("entitysign") == null) continue;
            return cell;
        }
        return null;
    }

    protected void setCellChange(Cell cell) {
        cell.setChangeVal(true);
        Cell seqCell = this.getSheet().getCell(cell.getRow(), 0);
        seqCell.setUserObject("ischange", (Object)true);
        this.getSheet().putUserObject("change", (Object)true);
    }

    public void actionSave() {
        try {
            log.startWatch();
            HashMap<String, Integer> maxOrderMap = new HashMap<String, Integer>(16);
            this.initSignColMap();
            this.checkBeforeSave(maxOrderMap);
            this.fillData(maxOrderMap);
            log.info("DiAbstractMemMapSheetHandel checkData " + this.plugin.getMemAndComVO().getDimMapId());
            ArrayList<Cell> cells = new ArrayList<Cell>();
            Pair<Map<Long, DynamicObject>, List<DynamicObject>> datas = this.collectDynamicObjects(cells);
            List<Object> notDeleteId = this.collectNotDeleteids();
            this.simpleModel();
            if (this.getSheet().getUserObject() != null) {
                this.getSheet().getUserObject().remove("change");
            }
            Map<Integer, List<Object>> updateRowSeq = this.dealSeq(cells, (Map)datas.p1);
            log.info("DiAbstractMemMapSheetHandel collectData " + this.plugin.getMemAndComVO().getDimMapId());
            List need2Save = (List)datas.p2;
            need2Save.addAll(((Map)datas.p1).values());
            this.saveData(need2Save, notDeleteId, updateRowSeq);
            this.writeSaveSuccessLog();
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractMemMapSheetHandel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.plugin.cacheSpreadModel(this.sm);
            log.infoEnd("DiAbstractMemMapSheetHandel saveData " + this.plugin.getMemAndComVO().getDimMapId());
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private List<Object> collectNotDeleteids() {
        ArrayList<Object> nodeleteid = new ArrayList<Object>();
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, 0);
            Object id = cell.getUserObject("id");
            if (id == null) continue;
            nodeleteid.add(id);
        }
        return nodeleteid;
    }

    private void saveData(List<DynamicObject> need2Save, List<Object> notDeleteId, Map<Integer, List<Object>> updateRowSeq) {
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                QFilter notid = new QFilter("id", "not in", notDeleteId);
                QFilter dimmap = new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId());
                if (this.vo.getType() == MemAndComVO.VOEnum.C1 || this.vo.getType() == MemAndComVO.VOEnum.C2) {
                    dimmap.and(new QFilter("srctype", "=", (Object)"1"));
                } else if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
                    dimmap.and(new QFilter("srctype", "=", (Object)"2"));
                }
                DeleteServiceHelper.delete((String)this.getDynamicObjectType(), (QFilter[])new QFilter[]{notid, dimmap});
                SaveServiceHelper.save((DynamicObject[])need2Save.toArray(new DynamicObject[0]));
                this.updateSeq(updateRowSeq);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    protected void simpleModel() {
        for (int row = 0; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell seqCell = this.getSheet().getCell(row, 0);
            if (seqCell.getUserObject("ischange") != null || seqCell.getUserObject("entitysign") != null) continue;
            for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
                Cell cell = this.getSheet().getCell(row, col);
                cell.removeUserObject("KEY_DIM_FLAG");
                cell.setChangeVal(false);
            }
        }
    }

    protected Map<Integer, List<Object>> dealSeq(List<Cell> cells, Map<Long, DynamicObject> insertRow) {
        int insertRowNum = 0;
        int preSeq = 0;
        HashMap<Integer, List<Object>> updateRowSeq = new HashMap<Integer, List<Object>>(16);
        for (Cell cell : cells) {
            int seq;
            Long id = (Long)cell.getUserObject("id");
            if (((Boolean)cell.getUserObject("isnew", (Object)false)).booleanValue()) {
                seq = preSeq + 1;
                DynamicObject row = insertRow.get(id);
                if (row != null) {
                    row.set("dseq", (Object)seq);
                }
                ++insertRowNum;
                preSeq = seq;
            } else {
                if (insertRowNum != 0) {
                    updateRowSeq.computeIfAbsent(insertRowNum, l -> new ArrayList());
                    List ids = (List)updateRowSeq.get(insertRowNum);
                    ids.add(id);
                }
                preSeq = seq = (Integer)cell.getUserObject("seq") + insertRowNum;
            }
            cell.removeUserObject("isnew");
            cell.setUserObject("seq", (Object)seq);
        }
        return updateRowSeq;
    }

    private void updateSeq(Map<Integer, List<Object>> updateRowSeq) {
        updateRowSeq.forEach((k, v) -> {
            SqlBuilder sql = new SqlBuilder();
            sql.append("update t_bcm_isgroupmap set fseq = fseq + ? where", new Object[]{k});
            sql.appendIn("fid", v);
            DB.execute((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)sql);
        });
    }

    public void resetSeq() {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_bcm_isgroupmap set fseq = flevel * 10000 + forder where fdimmapid = ?", new Object[]{this.vo.getDimMapId()});
        DB.execute((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)sql);
    }

    protected void writeSaveSuccessLog() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        String schemeName = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848%s", (String)"AbstractMemMapSheetHandel_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scheme.getString("number"));
        TreeView tree = (TreeView)this.plugin.getView().getControl(TREEVIEW);
        try {
            String nodeName = tree.getTreeState().getFocusNode().get("text").toString();
        }
        catch (NullPointerException e) {
            String nodeName = ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
    }

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected String buildColEntityKey(String entity, String dimNum) {
        return entity + "!" + dimNum;
    }

    protected String buildEntityNameByNode(MemAndComVO.Node node) {
        return this.buildColEntityKey(node.getEntityName(), node.getNumber());
    }

    protected String getSignByCol(int col) {
        if (this.colSignIndex == null) {
            this.colSignIndex = new HashMap<Integer, String>();
        }
        if (!this.colSignIndex.containsKey(col)) {
            Cell head = this.getHeader(col);
            if (head != null) {
                this.colSignIndex.put(col, head.getUserObject("entitysign").toString());
            } else {
                this.colSignIndex.put(col, null);
            }
        }
        return this.colSignIndex.get(col);
    }

    protected int getFirstSrcCol() {
        String firstSrc = this.plugin.getPageCache().get("firstsrc");
        if (firstSrc == null) {
            return -1;
        }
        return Integer.parseInt(firstSrc);
    }

    protected void cacheFirstSrcCol(int col) {
        this.plugin.getPageCache().put("firstsrc", "" + col);
    }

    public void initSignColMap() {
        this.srcSignColIndex = new HashMap<String, Integer>();
        this.targetSignColIndex = new HashMap<String, Integer>();
        this.otherSignColIndex = new HashMap<String, Integer>();
        int maxcol = this.getSheet().getMaxColumnCount();
        for (int col = 0; col < maxcol; ++col) {
            Cell cell = this.getSheet().getCell(1, col);
            if (cell.getUserObject("entitysign") == null) continue;
            String sign = cell.getUserObject("entitysign").toString();
            if (sign.contains("!")) {
                int firstSrcCol = this.getFirstSrcCol();
                if (firstSrcCol != -1 && col >= firstSrcCol) {
                    this.srcSignColIndex.put(sign, col);
                    continue;
                }
                this.targetSignColIndex.put(sign, col);
                continue;
            }
            this.otherSignColIndex.put(sign, col);
        }
    }

    protected int getSrcColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.srcSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.srcSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    protected int getTargetColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.targetSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    private boolean isTargetSign(String sign) {
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return this.targetSignColIndex.containsKey(sign);
    }

    private boolean isSrcSign(String sign) {
        if (this.srcSignColIndex == null) {
            this.initSignColMap();
        }
        return this.srcSignColIndex.containsKey(sign);
    }

    protected int getOtherColByEntity(String entity) {
        Integer col;
        String entitySign = this.getEntitySign(entity, null);
        if (this.otherSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.otherSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    private String getEntitySign(String entity, String dimNum) {
        if (dimNum != null) {
            entity = this.buildColEntityKey(entity, dimNum);
        } else {
            String number = DimEntityNumEnum.getNumberByEntieyNum((String)entity);
            if (StringUtils.isNotEmpty((String)number)) {
                entity = this.buildColEntityKey(entity, number);
            }
        }
        return entity;
    }

    protected boolean showComputeOprt() {
        for (MemAndComVO.Node node : this.vo.getTargetPro()) {
            if (!"Account".equals(node.getNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean cellIsNull(Cell cell) {
        return cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString());
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        String sign = this.getSignByCol(args.getC());
        if (StringUtils.isNotEmpty((String)sign) && sign.startsWith("_enum_")) {
            this.setEnumValues(args, sign);
        }
    }

    protected void setEnumValues(LookUpDataArgs args, String sign) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList arrs = new ArrayList();
        if ("_enum_computeoprt".equals(sign)) {
            for (ComputeOprtEnum co : ComputeOprtEnum.values()) {
                ArrayList<String> arr = new ArrayList<String>();
                arr.add(co.getIndex());
                arr.add(co.getNumber());
                arr.add(co.getSymbol());
                arrs.add(arr);
            }
        }
        data.put("data", arrs);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        this.plugin.getClientViewProxy().invokeControlMethod(this.spreadKey, "setLookupData", new Object[]{data});
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        Cell cell = this.getSheet().getCell(arg.getR(), arg.getC());
        invoker.updataValue(arg.getR(), arg.getC(), arg.getName());
        cell.setValue((Object)arg.getId());
        this.setCellChange(cell);
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    protected DynamicObject packDynamicObject(int row) {
        return this.getDynamicObject(row, null);
    }

    protected DynamicObject updateDynamicObject(int row, DynamicObject oldValue) {
        return this.getDynamicObject(row, oldValue);
    }

    protected DynamicObject getDynamicObject(int row, DynamicObject object) {
        boolean isNew = false;
        if (object == null) {
            isNew = true;
            object = BusinessDataServiceHelper.newDynamicObject((String)this.getDynamicObjectType());
        }
        object.set("isdyna", (Object)0);
        object.set("srctype", (Object)"1");
        this.handleCommon(row, object);
        this.handleTarMem(row, object, isNew);
        this.handleSrcMem(row, object, isNew);
        return object;
    }

    private void handleCommon(int row, DynamicObject object) {
        int priorityCol = this.getOtherColByEntity("priority");
        if (priorityCol == -1) {
            object.set("level", (Object)1000);
        } else {
            Cell priorityCell = this.getSheet().getCell(row, priorityCol);
            object.set("level", priorityCell.getValue());
        }
        int orderCol = this.getOtherColByEntity("order");
        if (orderCol == -1) {
            object.set("order", (Object)1);
        } else {
            Cell orderCell = this.getSheet().getCell(row, orderCol);
            object.set("order", orderCell.getValue());
        }
        int oprtCol = this.getOtherColByEntity("_enum_computeoprt");
        if (oprtCol == -1) {
            object.set("computeoprt", (Object)1);
        } else {
            Cell oprtCell = this.getSheet().getCell(row, oprtCol);
            object.set("computeoprt", oprtCell.getValue());
            int weightCol = this.getOtherColByEntity("weight");
            Cell weightCell = this.getSheet().getCell(row, weightCol);
            object.set("weight", weightCell.getValue());
        }
    }

    private void handleTarMem(int row, DynamicObject object, boolean isNew) {
        DynamicObjectCollection isgrouptargmapentry = object.getDynamicObjectCollection("isgrouptargmapentry");
        int i = 0;
        for (MemAndComVO.Node node : this.vo.getTargetPro()) {
            DynamicObject entry;
            int col = this.getTargetColByEntity(this.buildEntityNameByNode(node), null);
            Cell cell = this.getSheet().getCell(row, col);
            if (cell.getValue() == null || StringUtils.isEmpty((String)((String)cell.getValue()))) {
                entry = this.getOldEntry(isgrouptargmapentry, "tardimension", node.getId());
                isgrouptargmapentry.remove((Object)entry);
                continue;
            }
            entry = isNew ? isgrouptargmapentry.addNew() : this.getOldEntry(isgrouptargmapentry, "tardimension", node.getId());
            entry.set("tardimension", (Object)node.getId());
            entry.set("tarmembnumber", cell.getValue());
            cell = this.getSheet().getCell(row, col + 1);
            entry.set("tarmembname", cell.getValue());
            entry.set("tarmember", null);
            entry.set("seq", (Object)i);
            ++i;
        }
    }

    protected DynamicObject getOldEntry(DynamicObjectCollection col, String key, long id) {
        for (DynamicObject object : col) {
            if (object.getLong(key) != id) continue;
            return object;
        }
        return col.addNew();
    }

    private void handleSrcMem(int row, DynamicObject object, boolean isNew) {
        DynamicObjectCollection isgroupsrcmapentry = object.getDynamicObjectCollection("isgroupsrcmapentry");
        int seq = 0;
        for (MemAndComVO.Node node : this.vo.getSourcePro()) {
            Map<String, Object> analysisResult;
            int col = this.getSrcColByEntity(this.buildEntityNameByNode(node), null);
            Cell cell = this.getSheet().getCell(row, col);
            if (!isNew) {
                this.deleteAllOldEntry(isgroupsrcmapentry, "srcdimension", node.getId());
            }
            if ((analysisResult = this.analysisScope(cell.getValue())).get("items") == null) continue;
            List items = (List)analysisResult.get("items");
            String scope = String.valueOf(analysisResult.get("scope"));
            for (String num : items) {
                String value = num.trim();
                this.checkScopeValue(row, value, scope);
                DynamicObject entry = isgroupsrcmapentry.addNew();
                entry.set("srcdimension", (Object)node.getId());
                entry.set("srcmembnumber", (Object)value);
                entry.set("isdynadim", (Object)0);
                entry.set("seq", (Object)seq++);
                entry.set("scope", (Object)scope);
                entry.set("priority", (Object)0);
                entry.set("srcmembname", this.getSheet().getCell(row, col + 1).getValue());
            }
        }
    }

    protected void deleteAllOldEntry(DynamicObjectCollection col, String key, long id) {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>();
        for (DynamicObject object : col) {
            if (object.getLong(key) != id) continue;
            objects.add(object);
        }
        col.removeAll(objects);
    }

    protected Map<String, Object> analysisScope(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (value != null && StringUtils.isNotEmpty((String)((String)value))) {
            String str = ((String)value).toUpperCase(Locale.ENGLISH).trim();
            Pattern pattern = Pattern.compile("(?<=\\()[^\\)]+");
            Matcher matcher = pattern.matcher((String)value);
            String content = "";
            while (matcher.find()) {
                content = matcher.group();
            }
            if (str.contains("BETWEEN(")) {
                result.put("scope", str.contains("NOTBETWEEN(") ? MapScopeEnum.NOT_RANGE.getIndex() : MapScopeEnum.RANGE.getIndex());
                result.put("level", str.contains("NOTBETWEEN(") ? 7000 : 3000);
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.contains("LIKE(")) {
                result.put("scope", str.contains("NOTLIKE(") ? MapScopeEnum.NOT_LIKE.getIndex() : MapScopeEnum.LIKE.getIndex());
                result.put("level", str.contains("NOTLIKE(") ? 8000 : 4000);
                result.put("items", Collections.singletonList(content));
                return result;
            }
            if (str.contains("IN(")) {
                result.put("scope", str.contains("NOTIN(") ? MapScopeEnum.NOT_INCLUDE.getIndex() : MapScopeEnum.INCLUDE.getIndex());
                result.put("level", str.contains("NOTIN(") ? 6000 : 2000);
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.contains("NOTEQUAL(")) {
                result.put("scope", MapScopeEnum.NOT_EQUALS.getIndex());
                result.put("level", 5000);
                result.put("items", Collections.singletonList(content));
                return result;
            }
            result.put("scope", MapScopeEnum.EQUALS.getIndex());
            result.put("level", value.equals(ALL) ? 9000 : 1000);
            result.put("items", Collections.singletonList(value));
            return result;
        }
        return result;
    }

    private void checkScopeValue(int row, String number, String scope) {
        int last;
        if (!scope.equals(MapScopeEnum.LIKE.getIndex()) && !scope.equals(MapScopeEnum.NOT_LIKE.getIndex())) {
            return;
        }
        int first = number.indexOf("%");
        if (first != (last = number.lastIndexOf("%"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884cLike/notLike\u53ea\u80fd\u6709\u4e00\u4e2a\u901a\u914d\u7b26\u3002", (String)"DiAbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
        }
        if (first != 0 && first != number.length() - 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884cLike/notLike\u4e2d%2$s\u901a\u914d\u7b26\u5fc5\u987b\u5728\u9996\u4f4d\u6216\u672b\u4f4d\u3002", (String)"DiAbstractMemMapSheetHandel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row, "\\"));
        }
    }

    protected int getMaxOrder(Integer max) {
        if (max == null) {
            return 100;
        }
        return (max / 100 + 1) * 100;
    }
}

