/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.DiDeriveRuleHelper;
import kd.fi.bcm.business.integration.di.model.DIDeriveRule;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.enums.integration.di.DIRuleEnum;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import kd.fi.bcm.common.enums.integration.di.DiDeriveRuleFieldTypeEnum;
import kd.fi.bcm.common.util.ControlPropValidateUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang.math.NumberUtils;

public class DiDeriveRuleEditPlugin
extends AbstractBaseFormPlugin {
    private static final String CTL_ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY_S = "_s";
    private static final String ENTRYENTITY_P = "_p";
    private static final String IS_CHANGE = "is_change";
    private FormShowParameter formShowParameter = null;

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity_s", "entryentity_p"});
        this.beforeBindEntryGrid(ENTRYENTITY_S);
        this.beforeBindEntryGrid(ENTRYENTITY_P);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().updateView("entryentity_s");
        this.getView().updateView("entryentity_p");
        this.initData();
        this.setDisableControl();
    }

    private void initData() {
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().setValue("scheme", this.getFormCustomParam("scheme"));
        Long deriveRuleId = this.getFormCustomParam("deriveRuleId", 0L);
        Map<Long, DynamicObject> rules = Collections.emptyMap();
        if (deriveRuleId != 0L) {
            this.getPageCache().put("deriveRuleId", deriveRuleId + "");
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)deriveRuleId, (String)"di_deriverule");
            if (dy != null) {
                this.setPerm(!dy.getBoolean("status"));
                DynamicObjectCollection entryentity = dy.getDynamicObjectCollection(CTL_ENTRYENTITY);
                rules = entryentity.stream().collect(Collectors.toMap(k -> k.getLong("basefield.id"), v -> v, (v1, v2) -> v1));
                this.initDeriveRule(dy);
            }
        }
        this.initDeriveRuleFields(rules);
    }

    private void setDisableControl() {
        boolean flag = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
        if (flag || !this.hasPerm()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "newline", "deleteline", "number", "name", "description"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTL_ENTRYENTITY, "entryentity_s"});
        }
    }

    private boolean hasPerm() {
        String perm = this.getPageCache().get("hasperm");
        return !"0".equals(perm);
    }

    private void setPerm(boolean perm) {
        this.getPageCache().put("hasperm", perm ? "1" : "0");
    }

    private void initDeriveRuleFields(Map<Long, DynamicObject> rules) {
        List<Map<String, Object>> docs = this.getISBaseEntListCache();
        if (docs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u65b9\u6848\u57fa\u7840\u8d44\u6599\u3002", (String)"DiDeriveRuleEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().batchCreateNewEntryRow(CTL_ENTRYENTITY, docs.size());
        for (int index = 0; index < docs.size(); ++index) {
            this.getModel().setValue("basefield", docs.get(index).get("id"), index);
            DynamicObject rule = rules.get(docs.get(index).get("id"));
            if (docs.get(index).get("fieldtype") != null) {
                this.getModel().setValue("fieldtype", docs.get(index).get("fieldtype"), index);
            }
            this.getModel().setValue("datatype", docs.get(index).get("datatype"), index);
            if (rule == null) continue;
            this.getModel().setValue("fieldtype", (Object)rule.getString("fieldtype"), index);
            this.getModel().setValue("conditontype", (Object)rule.getString("conditontype"), index);
            this.getModel().setValue("conditonvalue", (Object)rule.getString("conditonvalue"), index);
            this.getModel().setValue("coderule", (Object)rule.getString("coderule"), index);
            this.getModel().setValue("coderulevalue", (Object)rule.getString("coderulevalue"), index);
        }
    }

    private Long getSchemeId() {
        if (this.getView() == null) {
            return this.formShowParameter.getCustomParam("scheme") == null ? Long.valueOf(0L) : (Long)this.formShowParameter.getCustomParam("scheme");
        }
        return this.getFormCustomParam("scheme", 0L);
    }

    private List<Map<String, Object>> getISBaseEntListCache() {
        if (this.getPageCache() == null) {
            return this.getISBaseEntList();
        }
        String baseList = this.getPageCache().get("isBaseEntListCache");
        if (StringUtils.isEmpty((CharSequence)baseList)) {
            List<Map<String, Object>> resList = this.getISBaseEntList();
            this.getPageCache().put("isBaseEntListCache", ObjectSerialUtil.toByteSerialized(resList));
            return resList;
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)baseList);
    }

    private List<Map<String, Object>> getISBaseEntList() {
        return (List)ThreadCache.get((Object)"isBaseEntList", () -> {
            String extendstable;
            QFilter qFilter = new QFilter("scheme", "=", (Object)this.getSchemeId());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"number");
            if (query.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList list = new ArrayList(10);
            HashMap<String, Map> map = new HashMap<String, Map>(query.size());
            query.forEach(e -> {
                HashMap<String, Object> res = new HashMap<String, Object>(16);
                res.put("id", e.getLong("id"));
                res.put("name", e.getString("name"));
                res.put("number", e.getString("number"));
                map.put(e.getString("number"), res);
            });
            DynamicObject isscheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"sourceobj,extendstable,datasrctype,singlemetric", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getSchemeId())});
            String singlemetric = isscheme.getString("singlemetric");
            if (isscheme.get("sourceobj") != null && DIDataSrcTypeEnum.InServiceObj.getValue().equals(isscheme.getString("datasrctype"))) {
                DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)isscheme.getLong("sourceobj"), (String)"isc_metadata_schema", (String)"group,prop_entryentity.prop_name,prop_entryentity.prop_label,prop_entryentity.data_type");
                DynamicObjectCollection prop_entryentity = src.getDynamicObjectCollection("prop_entryentity");
                prop_entryentity.forEach(p -> {
                    Map res = (Map)map.get(p.getString("prop_name"));
                    if (res != null) {
                        res.put("datatype", p.getString("data_type"));
                        if (p.getString("prop_name").equals(singlemetric)) {
                            res.put("fieldtype", DiDeriveRuleFieldTypeEnum.NUMBERIC.getCode());
                        } else {
                            DiDeriveRuleFieldTypeEnum fieldtype = DiDeriveRuleFieldTypeEnum.searchEnumByDB((String)p.getString("data_type"));
                            if (fieldtype != null) {
                                res.put("fieldtype", fieldtype.getCode());
                            }
                        }
                    }
                });
            } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(isscheme.getString("datasrctype")) && StringUtils.isNotEmpty((CharSequence)(extendstable = isscheme.getString("extendstable"))) && DB.getTables((DBRoute)BCMConstant.DBROUTE).contains(extendstable.toLowerCase(Locale.ENGLISH))) {
                List columnNames = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)extendstable);
                columnNames.forEach(p -> {
                    Map res = (Map)map.get(p.getFieldName());
                    if (res != null) {
                        res.put("datatype", p.getDataType());
                        if (p.getFieldName().equals(singlemetric)) {
                            res.put("fieldtype", DiDeriveRuleFieldTypeEnum.NUMBERIC.getCode());
                        } else {
                            DiDeriveRuleFieldTypeEnum fieldtype = DiDeriveRuleFieldTypeEnum.searchEnumByDB((String)p.getDataType());
                            if (fieldtype != null) {
                                res.put("fieldtype", fieldtype.getCode());
                            }
                        }
                    }
                });
            }
            map.forEach((k, v) -> list.add(v));
            return list;
        });
    }

    private void initDeriveRule(DynamicObject dy) {
        this.getModel().setValue("number", dy.get("number"));
        this.getModel().setValue("name", dy.get("name"));
        this.getModel().setValue("scheme", dy.get("scheme"));
        this.getModel().setValue("templatecatalog", dy.get("templatecatalog"));
        String rulepreview = dy.getString("rulepreview");
        if (StringUtils.isNotEmpty((CharSequence)rulepreview)) {
            List vals = (List)ObjectSerialUtil.deSerializedBytes((String)rulepreview);
            this.getModel().batchCreateNewEntryRow("entryentity_s", vals.size());
            for (int i = 0; i < vals.size(); ++i) {
                Map val = (Map)vals.get(i);
                for (Map<String, Object> base : this.getISBaseEntListCache()) {
                    String number = (String)base.get("number");
                    this.getModel().setValue(number + ENTRYENTITY_S, val.get(number), i);
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.beforeBindEntryGrid(ENTRYENTITY_S);
        this.beforeBindEntryGrid(ENTRYENTITY_P);
    }

    private void beforeBindEntryGrid(String suffix) {
        EntryAp entryAp = this.createEntryAp(suffix);
        IFormView formView = this.getView();
        EntryGrid entryGrid = (EntryGrid)formView.getControl(CTL_ENTRYENTITY + suffix);
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(formView);
            entryGrid.getItems().add(fieldEdit);
            if (!(fieldEdit instanceof Container)) continue;
            List listCol = ((Container)fieldEdit).getItems();
            for (Control col : listCol) {
                col.setView(formView);
                entryGrid.getItems().add(col);
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.formShowParameter = (FormShowParameter)e.getSource();
        e.getItems().add(this.getCustomEntryEntity(ENTRYENTITY_S));
        e.getItems().add(this.getCustomEntryEntity(ENTRYENTITY_P));
    }

    private Map<String, Object> getCustomEntryEntity(String prefix) {
        HashMap<String, Object> mapEntry = new HashMap<String, Object>(16);
        EntryAp entryAp = this.createEntryAp(prefix);
        mapEntry.put("id", CTL_ENTRYENTITY + prefix);
        mapEntry.put("columns", entryAp.createControl().get("columns"));
        return mapEntry;
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            this.registerEntityType(newMainType, ENTRYENTITY_S);
            this.registerEntityType(newMainType, ENTRYENTITY_P);
            e.setNewEntityType(newMainType);
        }
        catch (CloneNotSupportedException exp) {
            log.error((Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
    }

    private EntryAp createEntryAp(String suffix) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setShowSeq(true);
        for (Map<String, Object> base : this.getISBaseEntListCache()) {
            EntryFieldAp apMat = new EntryFieldAp();
            apMat.setId(base.get("number") + suffix);
            apMat.setKey(base.get("number") + suffix);
            apMat.setWidth(new LocaleString("100px"));
            apMat.setName(new LocaleString((String)base.get("name")));
            TextField textFiled = new TextField();
            textFiled.setKey(base.get("number") + suffix);
            textFiled.setDefValue(null);
            apMat.setField((Field)textFiled);
            entryAp.getItems().add(apMat);
        }
        return entryAp;
    }

    private String getSuarKey(String fieldKey, String suffix) {
        if (fieldKey.endsWith(suffix)) {
            return fieldKey.substring(0, fieldKey.lastIndexOf(suffix));
        }
        return null;
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        List<Map<String, Object>> docs;
        Optional<Map> options;
        String prefix;
        String key = e.getKey();
        String string = key.endsWith(ENTRYENTITY_S) ? ENTRYENTITY_S : (prefix = key.endsWith(ENTRYENTITY_P) ? ENTRYENTITY_P : null);
        if (StringUtils.isNotEmpty((CharSequence)prefix) && (options = (docs = this.getISBaseEntListCache()).stream().filter(a -> this.getSuarKey(key, prefix).equals(a.get("number"))).findFirst()).isPresent()) {
            Map dy = options.get();
            FieldEdit bdMatEdit = new FieldEdit();
            bdMatEdit.setKey(dy.get("number") + prefix);
            bdMatEdit.setEntryKey(CTL_ENTRYENTITY + prefix);
            bdMatEdit.setView(this.getView());
            e.setControl((Control)bdMatEdit);
        }
    }

    private void registerEntityType(MainEntityType newMainType, String prefix) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(CTL_ENTRYENTITY + prefix);
        for (Map<String, Object> base : this.getISBaseEntListCache()) {
            TextProp textProp = new TextProp();
            textProp.setDbIgnore(true);
            textProp.setName(base.get("number") + prefix);
            textProp.setAlias("");
            textProp.setDefValue(null);
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave();
                break;
            }
            case "preview": {
                this.actionPreview();
                break;
            }
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if ("btn_save".equals(opkey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            opkey = OperationStatus.ADDNEW == status ? "btn_addnew" : "btn_edit";
        }
        super.checkPerm(opkey);
    }

    @Override
    public String getPermEntityId() {
        return "di_derive_rule_list";
    }

    private boolean validateSaveInfo() {
        Optional showTipMesg = ControlPropValidateUtil.validateData((IDataModel)this.getModel());
        if (showTipMesg.isPresent()) {
            this.getView().showTipNotification((String)showTipMesg.get());
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)(this.getModel().getValue("number") + ""))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long deriveRuleId = LongUtil.toLong((Object)this.getPageCache().get("deriveRuleId"));
        QFilter qf = new QFilter("id", "!=", (Object)deriveRuleId);
        qf.and("scheme", "=", (Object)this.getSchemeId()).and("number", "=", this.getModel().getValue("number"));
        if (QueryServiceHelper.exists((String)"di_deriverule", (QFilter[])qf.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u91cd\u590d\u3002", (String)"DiDeriveRuleEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateRuleCondition() {
        DynamicObjectCollection details = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
        StringJoiner sj = new StringJoiner("\n");
        for (DynamicObject e : details) {
            String coderulevalue;
            String coderule;
            block6: {
                DiConditionEnum condtionEnum;
                block4: {
                    String conditonvalue;
                    block7: {
                        DiDeriveRuleFieldTypeEnum fieldTypeEnum;
                        block5: {
                            String fieldtype = e.getString("fieldtype");
                            String conditontype = e.getString("conditontype");
                            conditonvalue = e.getString("conditonvalue");
                            coderule = e.getString("coderule");
                            coderulevalue = e.getString("coderulevalue");
                            if (StringUtils.isEmpty((CharSequence)conditontype) && StringUtils.isEmpty((CharSequence)conditonvalue) && StringUtils.isEmpty((CharSequence)coderule) && StringUtils.isEmpty((CharSequence)coderulevalue)) continue;
                            fieldTypeEnum = DiDeriveRuleFieldTypeEnum.getEnumByCode((String)fieldtype);
                            condtionEnum = DiConditionEnum.getEnumByCode((String)conditontype);
                            if (!StringUtils.isNotEmpty((CharSequence)conditonvalue)) break block4;
                            if (condtionEnum == null) {
                                sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u7c7b\u578b\u3011\u672a\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\u3002", (String)"DiDeriveRuleEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getInt("seq")));
                                continue;
                            }
                            if (DiDeriveRuleFieldTypeEnum.NUMBERIC != fieldTypeEnum) break block5;
                            this.validateNumber(condtionEnum, conditonvalue, e.getInt("seq"), sj);
                            break block6;
                        }
                        if (DiDeriveRuleFieldTypeEnum.INT != fieldTypeEnum) break block7;
                        this.validateInt(condtionEnum, conditonvalue, e.getInt("seq"), sj);
                        break block6;
                    }
                    if (DiConditionEnum.BETWEEN != condtionEnum) break block6;
                    this.validateBetween(conditonvalue, e.getInt("seq"), sj);
                    break block6;
                }
                if (condtionEnum != null && !condtionEnum.isNonCondValue()) {
                    sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u672a\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\u3002", (String)"DiDeriveRuleEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getInt("seq")));
                    continue;
                }
            }
            if (!(StringUtils.isEmpty((CharSequence)coderule) ^ StringUtils.isEmpty((CharSequence)coderulevalue))) continue;
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u6216\u89c4\u5219\u7f16\u7801\u503c\u672a\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\u3002", (String)"DiDeriveRuleEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getInt("seq")));
        }
        if (sj.length() > 0) {
            this.getView().showTipNotification(sj.toString());
            return false;
        }
        return true;
    }

    private void validateNumber(DiConditionEnum condtionEnum, String conditonvalue, int seq, StringJoiner sj) {
        if (condtionEnum.isMultiCondValue()) {
            for (String s : conditonvalue.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)s) || NumberUtils.isNumber((String)s)) continue;
                sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c\u3002", (String)"DiDeriveRuleEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
                break;
            }
        } else if (condtionEnum.isSingleCondValue() && !NumberUtils.isNumber((String)conditonvalue)) {
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c\u3002", (String)"DiDeriveRuleEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
        } else if (DiConditionEnum.LIKE == condtionEnum || DiConditionEnum.NOT_LIKE == condtionEnum || DiConditionEnum.LLIKE == condtionEnum || DiConditionEnum.RLIKE == condtionEnum || DiConditionEnum.IN == condtionEnum || DiConditionEnum.NOT_IN == condtionEnum) {
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u4e2d\uff0c\u6570\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u201c\u5305\u542b\u201d\u3001\u201c\u4e0d\u5305\u542b\u201d\u3001\u201c\u4ee5...\u5f00\u59cb\u201d\u3001\u201c\u4ee5...\u7ed3\u675f\u201d\u3001\u201c\u5728...\u4e2d\u201d\u3001\u201c\u4e0d\u5728...\u4e2d\u201d\u7b49\u6761\u4ef6\u7c7b\u578b\u3002", (String)"DiDeriveRuleEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
        }
    }

    private void validateInt(DiConditionEnum condtionEnum, String conditonvalue, int seq, StringJoiner sj) {
        if (condtionEnum.isMultiCondValue()) {
            for (String s : conditonvalue.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)s) || NumberUtils.isDigits((String)s)) continue;
                sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u578b\u3002", (String)"DiDeriveRuleEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
                break;
            }
        } else if (condtionEnum.isSingleCondValue() && !NumberUtils.isDigits((String)conditonvalue)) {
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u578b\u3002", (String)"DiDeriveRuleEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
        } else if (DiConditionEnum.LIKE == condtionEnum || DiConditionEnum.LLIKE == condtionEnum || DiConditionEnum.RLIKE == condtionEnum) {
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u4e2d\uff0c\u6574\u578b\u7c7b\u578b\u4e0d\u652f\u6301\u201c\u5305\u542b\u201d\u3001\u201c\u4e0d\u5305\u542b\u201d\u3001\u201c\u4ee5...\u5f00\u59cb\u201d\u3001\u201c\u4ee5...\u7ed3\u675f\u201d\u7b49\u6761\u4ef6\u7c7b\u578b\u3002", (String)"DiDeriveRuleEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
        }
    }

    private void validateBetween(String conditonvalue, int seq, StringJoiner sj) {
        String[] vs = conditonvalue.split(",");
        if (vs.length != 2 || Arrays.stream(vs).filter(a -> StringUtils.isNotEmpty((CharSequence)a)).count() != 2L) {
            sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6d3e\u751f\u6761\u4ef6\u3010\u6761\u4ef6\u503c\u3011\u8bbe\u7f6e\u9519\u8bef\uff0c\u4e0d\u7b26\u5408\u5728..\u4e4b\u95f4\uff0c\u59821,100\u3002", (String)"DiDeriveRuleEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), seq));
        }
    }

    private void actionSave() {
        if (!this.validateSaveInfo() || !this.validateRuleCondition()) {
            return;
        }
        Long deriveRuleId = LongUtil.toLong((Object)this.getPageCache().get("deriveRuleId"));
        DynamicObject newDy = null;
        if (deriveRuleId != 0L) {
            newDy = BusinessDataServiceHelper.loadSingle((Object)deriveRuleId, (String)"di_deriverule");
            if ("1".equals(newDy.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d3e\u751f\u7c7b\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"DiDeriveRuleEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            newDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"di_deriverule"));
            newDy.set("status", (Object)"0");
            newDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDy.set("createtime", (Object)TimeServiceHelper.now());
        }
        newDy.set("number", this.getValue("number"));
        newDy.set("name", this.getValue("name"));
        newDy.set("scheme", this.getValue("scheme"));
        newDy.set("templatecatalog", this.getValue("templatecatalog"));
        newDy.set("description", this.getValue("description"));
        DynamicObjectCollection entryentity = newDy.getDynamicObjectCollection(CTL_ENTRYENTITY);
        entryentity.clear();
        DynamicObjectCollection details = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
        for (DynamicObject e2 : details) {
            String fieldtype = e2.getString("fieldtype");
            String conditontype = e2.getString("conditontype");
            String conditonvalue = e2.getString("conditonvalue");
            String coderule = e2.getString("coderule");
            String coderulevalue = e2.getString("coderulevalue");
            if (StringUtils.isEmpty((CharSequence)conditontype) && StringUtils.isEmpty((CharSequence)conditonvalue) && StringUtils.isEmpty((CharSequence)coderule) && StringUtils.isEmpty((CharSequence)coderulevalue)) continue;
            DynamicObject addNew = entryentity.addNew();
            addNew.set("basefield", e2.get("basefield"));
            addNew.set("fieldtype", (Object)fieldtype);
            addNew.set("conditontype", (Object)conditontype);
            addNew.set("conditonvalue", (Object)conditonvalue);
            addNew.set("coderule", (Object)coderule);
            addNew.set("coderulevalue", (Object)coderulevalue);
        }
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity_s");
        if (!entryentity1.isEmpty()) {
            ArrayList dataMaps = new ArrayList(entryentity1.size());
            entryentity1.forEach(e -> {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                for (Map<String, Object> base : this.getISBaseEntListCache()) {
                    String number = (String)base.get("number");
                    map.put(number, e.get(number + ENTRYENTITY_S));
                }
                dataMaps.add(map);
            });
            newDy.set("rulepreview", (Object)ObjectSerialUtil.toByteSerialized(dataMaps));
        }
        newDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newDy.set("modifytime", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((IDataEntityType)newDy.getDataEntityType(), (Object[])new DynamicObject[]{newDy});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DiDeriveRuleEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("deriveRuleId", newDy.getString("id"));
                this.getModel().setDataChanged(false);
            }
            catch (Exception e3) {
                tx.markRollback();
                log.error((Throwable)e3);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"DiDeriveRuleListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e3));
            }
        }
    }

    private void actionPreview() {
        this.getModel().deleteEntryData("entryentity_p");
        if (!this.validateRuleCondition()) {
            return;
        }
        DynamicObjectCollection entryEntityS = this.getModel().getEntryEntity("entryentity_s");
        if (entryEntityS.isEmpty()) {
            return;
        }
        DynamicObjectCollection details = this.getModel().getEntryEntity(CTL_ENTRYENTITY);
        List transform = DIDeriveRule.transform((DynamicObjectCollection)details, (String)"");
        ArrayList canCreate = new ArrayList(16);
        StringJoiner sj = new StringJoiner("\n");
        List<Map<String, Object>> bases = this.getISBaseEntListCache();
        entryEntityS.forEach(e -> {
            boolean isCreate = true;
            for (DIDeriveRule deriveRule : transform) {
                Object column;
                String v = e.getString(deriveRule.getFieldName() + ENTRYENTITY_S);
                Object value = v;
                if (deriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                    if (StringUtils.isNotEmpty((CharSequence)v) && !NumberUtils.isDigits((String)v)) {
                        column = bases.stream().filter(a -> deriveRule.getFieldName().equals(a.get("number"))).map(a -> a.get("name")).findFirst().orElseGet(() -> deriveRule.getFieldName());
                        sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5217\u7684\u503c\u3010%3$s\u3011\u65e0\u6cd5\u89e3\u6790\u4e3a\u6574\u578b\u7c7b\u578b\u3002", (String)"DiDeriveRuleEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getInt("seq"), column, v));
                        continue;
                    }
                    Object object = value = StringUtils.isNotEmpty((CharSequence)v) ? Long.valueOf(Long.parseLong(v)) : null;
                }
                if (deriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                    if (StringUtils.isNotEmpty((CharSequence)v) && !NumberUtils.isNumber((String)v)) {
                        column = bases.stream().filter(a -> deriveRule.getFieldName().equals(a.get("number"))).map(a -> a.get("name")).findFirst().orElseGet(() -> deriveRule.getFieldName());
                        sj.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5217\u7684\u503c\u3010%3$s\u3011\u65e0\u6cd5\u89e3\u6790\u4e3a\u6570\u503c\u7c7b\u578b\u3002", (String)"DiDeriveRuleEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getInt("seq"), column, v));
                        continue;
                    }
                    Object object = value = StringUtils.isNotEmpty((CharSequence)v) ? new BigDecimal(v) : null;
                }
                if (DiDeriveRuleHelper.filter((DIDeriveRule)deriveRule, (Object)value)) continue;
                isCreate = false;
                break;
            }
            if (isCreate) {
                canCreate.add(e);
            }
        });
        if (sj.length() > 0) {
            this.getView().showTipNotification(sj.toString());
            return;
        }
        if (!canCreate.isEmpty()) {
            canCreate.forEach(e -> {
                int rowIndex = this.getModel().createNewEntryRow("entryentity_p");
                for (Map basis : bases) {
                    this.getModel().setValue(basis.get("number") + ENTRYENTITY_P, (Object)e.getString(basis.get("number") + ENTRYENTITY_S), rowIndex);
                }
                for (DIDeriveRule deriveRule : transform) {
                    if (deriveRule.getCodeRuleEnum() == null) continue;
                    String value = e.getString(deriveRule.getFieldName() + ENTRYENTITY_S);
                    value = deriveRule.getCodeRuleEnum() == DIRuleEnum.PREFIX ? deriveRule.getCodeRuleValue() + value : value + deriveRule.getCodeRuleValue();
                    this.getModel().setValue(deriveRule.getFieldName() + ENTRYENTITY_P, (Object)value, rowIndex);
                }
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u5df2\u751f\u6210\u3002", (String)"DiDeriveRuleEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u751f\u6210\u7684\u9884\u89c8\u6570\u636e\u3002", (String)"DiDeriveRuleEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        this.getModel().setDataChanged(true);
        switch (name) {
            case "fieldtype": {
                DiDeriveRuleFieldTypeEnum fieldTypeEnum = DiDeriveRuleFieldTypeEnum.getEnumByCode((String)((String)newValue));
                if (fieldTypeEnum != DiDeriveRuleFieldTypeEnum.NUMBERIC) break;
                this.getModel().setValue("coderule", (Object)"", changeSet.getRowIndex());
                this.getModel().setValue("coderulevalue", (Object)"", changeSet.getRowIndex());
                break;
            }
            case "conditontype": {
                DiConditionEnum conditionTypeEnum = DiConditionEnum.getEnumByCode((String)((String)newValue));
                if (conditionTypeEnum == null || !conditionTypeEnum.isNonCondValue()) break;
                this.getModel().setValue("conditonvalue", (Object)"", changeSet.getRowIndex());
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners("toolbarap", "advcontoolbarap1");
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u662f\u5426\u8fdb\u884c\u4fdd\u5b58\uff1f", (String)"DiDeriveRuleEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("save_comfirm".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.actionSave();
            } else {
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
        }
    }
}

