/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.ControlPropValidateUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.intergration.di.importexport.DIDeriveRuleExportImp;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DiDeriveRuleListPlugin
extends DIAbstractListPlugin
implements HyperLinkClickListener {
    private static final String ctl_treeviewap = "treeviewap";
    private static final String ctl_billlistap = "billlistap";
    private static final String ctl_discheme = "scheme";
    private static final String ctl_model = "model";

    @Override
    public void initialize() {
        super.initialize();
        this.initContainer();
    }

    private void initContainer() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("di_deriverule");
        fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u5217\u8868", (String)"DiDeriveRuleListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bdEdit = (BasedataEdit)this.getControl(ctl_discheme);
        if (bdEdit != null) {
            bdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(Collections.emptyList(), false);
        if (this.getModel().getValue(ctl_model) != null && this.getModel().getValue(ctl_discheme) != null) {
            this.refreshBillList();
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        args.getListColumns().forEach(e -> {
            e.setColumnFilter(true);
            e.setColumnOrder(true);
        });
    }

    public boolean validate() {
        Optional showTipMesg = ControlPropValidateUtil.validateData((IDataModel)this.getModel());
        if (showTipMesg.isPresent()) {
            this.getView().showTipNotification((String)showTipMesg.get());
            return false;
        }
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validate()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                this.actionAddNew(null);
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_import": {
                this.importRules();
                break;
            }
            case "btn_export": {
                this.exportRules();
                break;
            }
            case "btn_enable": {
                this.actionStatus(Boolean.TRUE);
                break;
            }
            case "btn_disable": {
                this.actionStatus(Boolean.FALSE);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void importRules() {
        if (this.getModel().getValue(ctl_discheme) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"DiDeriveRuleListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long schemeId = ((DynamicObject)this.getModel().getValue(ctl_discheme)).getLong("id");
        String schemeName = ((DynamicObject)this.getModel().getValue(ctl_discheme)).getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_deriveruleimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u5bfc\u5165\u5931\u8d25\u3002", (String)"DiDeriveRuleListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("schemeName", (Object)schemeName);
        showParameter.setCustomParam("modelNumber", (Object)MemberReader.findModelNumberById((Object)this.getModelId()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importCloseCallBack"));
        this.getView().showForm(showParameter);
    }

    private void exportRules() {
        if (this.validateSelected()) {
            Long schemeid = ((DynamicObject)this.getModel().getValue(ctl_discheme)).getLong("id");
            String schemeName = ((DynamicObject)this.getModel().getValue(ctl_discheme)).getString("name");
            BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            DIDeriveRuleExportImp exportService = new DIDeriveRuleExportImp();
            XSSFWorkbook workbook = exportService.exportData(schemeid, rows.getPrimaryKeyValues());
            try {
                String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u5bfc\u51fa", (String)"DiDeriveRuleListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeName));
                this.downloadFile(url, "di_derive_rule_list", "1G2FW/G3YIL8");
            }
            catch (IOException e) {
                log.error(e.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"DiDeriveRuleListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
        this.checkAndSetWritePermission();
    }

    private void actionAddNew(Long deriveRuleId) {
        String catalogId = this.getPageCache().get("focusnodeid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("di_deriverule_edit");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        formShowParameter.setCustomParam("templatecatalog", (Object)LongUtil.toLong((Object)catalogId));
        formShowParameter.setCustomParam(ctl_discheme, (Object)this.getSchemeId());
        formShowParameter.setCustomParam("deriveRuleId", (Object)deriveRuleId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Boolean flag = DIIntegrationUtil.isWriteSchemePerm((long)this.getSchemeId(), (long)this.getModelId());
        if (deriveRuleId == null && flag.booleanValue()) {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        } else if (deriveRuleId != null && flag.booleanValue()) {
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u89c4\u5219%s", (String)"DiDeriveRuleListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), deriveRuleId == null ? OpItemEnum.ADD.getName() : OpItemEnum.BTN_EDIT.getName()));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshBill"));
        this.getView().showForm(formShowParameter);
    }

    private boolean validateSelected() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55\u3002", (String)"DiDeriveRuleListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    public void actionDelete() {
        if (this.validateSelected()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ISSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
        }
    }

    public void actionStatus(boolean enable) {
        if (this.validateSelected()) {
            OpItemEnum opItemEnum;
            BillList billList = (BillList)this.getControl(ctl_billlistap);
            QFilter qf = new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues());
            DynamicObject[] docs = BusinessDataServiceHelper.load((String)"di_deriverule", (String)"id,number,status,modifier,modifytime", (QFilter[])qf.toArray());
            ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(docs.length);
            for (DynamicObject doc : docs) {
                if (!(doc.getBoolean("status") ^ enable)) continue;
                doc.set("status", (Object)(enable ? "1" : "0"));
                updates.add(doc);
            }
            OpItemEnum opItemEnum2 = opItemEnum = enable ? OpItemEnum.ENABLE : OpItemEnum.DISABLE;
            if (updates.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u53ef%s\u7684\u6570\u636e\u3002", (String)"DiDeriveRuleListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opItemEnum.getName()));
                return;
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])updates.toArray(new DynamicObject[0]));
                    this.writeOperationLog(opItemEnum.getName(), DynUtils.joinString((String)",", (String)"number", updates), null, ResultStatusEnum.SUCCESS.getName());
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"DiDeriveRuleListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opItemEnum.getName()));
                    this.refreshBillList();
                }
                catch (Exception e) {
                    this.writeOperationLog(opItemEnum.getName(), DynUtils.joinString((String)",", (String)"number", updates), null, ResultStatusEnum.FAIL.getName());
                    log.error((Throwable)e);
                    tx.markRollback();
                    throw new KDBizException(ResManager.loadKDString((String)"\u7279\u6b8a\u89c4\u5219\u8f6c\u6362\u542f\u7528\u6216\u7981\u7528\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"DiDeriveRuleListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String catalogId = this.getPageCache().get("focusnodeid");
        QFilter qFilter = new QFilter(ctl_discheme, "=", (Object)this.getSchemeId());
        qFilter.and("templatecatalog", "=", (Object)LongUtil.toLong((Object)catalogId));
        e.getQFilters().add(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "deletecatalog_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                String string = this.deletecatalog();
                break;
            }
            case "delete_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                this.deleteConfirm();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("refreshBill".equals(actionId)) {
            this.refreshBillList();
        } else if ("importCloseCallBack".equals(actionId)) {
            this.refreshBillList();
        }
    }

    public String deletecatalog() {
        return null;
    }

    public void deleteConfirm() {
        BillList billList = (BillList)this.getView().getControl(ctl_billlistap);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        QFilter qf = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"di_deriverule", (String)"id,name,number,status", (QFilter[])qf.toArray());
        List collect = query.stream().filter(e -> e.getBoolean("status")).map(e -> e.getString("number")).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u201c%s\u201d\u5df2\u542f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DiDeriveRuleListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", collect)));
            return;
        }
        ArrayList<Long> idlist = new ArrayList<Long>(10);
        for (Object id : ids) {
            idlist.add(Long.valueOf(id.toString()));
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"di_deriverule"), (Object[])idlist.toArray(new Long[0]));
                rows.forEach(r -> this.writeOperationLog(OpItemEnum.DELETE.getName(), r.getNumber(), r.getName(), ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DiDeriveRuleListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
            catch (Exception e2) {
                rows.forEach(r -> this.writeOperationLog(OpItemEnum.DELETE.getName(), r.getNumber(), r.getName(), ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"DiDeriveRuleListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                tx.markRollback();
                log.error((Throwable)e2);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u5220\u9664\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"DiDeriveRuleListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e2));
            }
        }
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (ctl_discheme.equals(key)) {
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qf = new QFilter(ctl_model, "=", (Object)this.getModelId()).and("templatecatalog.type", "=", (Object)"2").and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qf));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "model": {
                if (newValue == null || newValue.getPkValue().equals(oldValue == null ? null : oldValue.getPkValue())) break;
                this.getModel().setValue(ctl_discheme, null);
                this.propertyChangedDimUse(ctl_model, newValue, false, false);
                this.propertyChangedModelUse(Collections.emptyList());
                this.refreshBillList();
                break;
            }
            case "scheme": {
                if (this.getModelId() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                } else if (newValue != null && !newValue.getPkValue().equals(oldValue == null ? null : oldValue.getPkValue())) {
                    this.propertyChangedUse(ctl_discheme, newValue, false, false);
                }
                this.refreshBillList();
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        BillList list = (BillList)this.getControl(ctl_billlistap);
        this.actionAddNew((Long)list.getFocusRowPkId());
    }

    private Boolean checkAndSetWritePermission() {
        if (this.getModel().getValue(ctl_model) == null || this.getModel().getValue(ctl_discheme) == null) {
            return false;
        }
        Long modelId = this.getModelId();
        Long schemeId = this.getSchemeId();
        Boolean hasWritePermission = DIIntegrationUtil.isWriteSchemePerm((long)schemeId, (long)modelId);
        this.getView().setEnable(hasWritePermission, new String[]{"btn_addnew", "btn_delete", "btn_import", "btn_enable", "btn_disable", "ctl_billlistap"});
        return hasWritePermission;
    }
}

