/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.util.DISchemeUtil;

public class DimMapService {
    private static final List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");
    Map<String, String> dimNumber2Name = new LinkedHashMap<String, String>();
    Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = new LinkedHashMap<String, Tuple<String, String, Long>>();
    DynamicObject schemeDy;

    public DimMapService(DynamicObject schemeDy) {
        this.schemeDy = schemeDy;
    }

    public void insertDimPerData() {
        Long schemeId = this.schemeDy.getLong("id");
        Long modelId = this.schemeDy.getLong("model.id");
        Long extendsModelId = this.schemeDy.getLong("extendsmodel_id");
        String dataSrcType = this.schemeDy.getString("datasrctype");
        if (extendsModelId != 0L) {
            this.initExtendFieldData(extendsModelId);
            this.insertDimPerDataForExt(schemeId, modelId);
        } else if (DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType)) {
            this.insertDimPerDataForPush2EASReport();
            DISchemeUtil.enableScheme(schemeId);
        } else {
            this.insertDimPerDataForCM(schemeId, modelId);
        }
    }

    private kd.fi.bcm.business.integration.mapping.Tuple<Set<String>, Set<String>> getTupleNumber(String[][] oneMappings) {
        HashSet<String> srcNumbers = new HashSet<String>(16);
        HashSet<String> targetNumbers = new HashSet<String>(16);
        for (String[] out : oneMappings) {
            srcNumbers.add(out[1]);
            targetNumbers.add(out[0]);
        }
        return new kd.fi.bcm.business.integration.mapping.Tuple(srcNumbers, targetNumbers);
    }

    private void insertDimPerDataForPush2EASReport() {
        ArrayList<DynamicObject> dimmappings = new ArrayList<DynamicObject>(8);
        String[][] oneMappings = new String[][]{{"Entity", "Entity"}, {"Year", "Year"}, {"Period", "Period"}, {"Currency", "Currency"}, {"ChangeType", "DataElement"}, {"Account", "ReportItem"}};
        kd.fi.bcm.business.integration.mapping.Tuple<Set<String>, Set<String>> tupleNumbers = this.getTupleNumber(oneMappings);
        Map<String, DynamicObject> srcDynDim = this.queryDim((Set)tupleNumbers.getF(), "bcm_isbaseentlist");
        Map<String, DynamicObject> targetDynDim = this.queryDim((Set)tupleNumbers.getB(), "bcm_dimension");
        int seq = 1;
        for (String[] out : oneMappings) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            String[] srcNumbers = out[1].split("@");
            String[] targetNumbers = out[0].split("@");
            String number = Stream.of(targetNumbers).collect(Collectors.joining("+")) + "-" + Stream.of(srcNumbers).collect(Collectors.joining("+"));
            dimMapping.set("number", (Object)number);
            dimMapping.set("scheme", (Object)this.schemeDy.getLong("id"));
            dimMapping.set("sequence", (Object)seq++);
            dimMapping.set("mappedtype", (Object)DimMappTypeEnum.SIMPLE.getCode());
            dimMapping.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dimMapping.set("createtime", (Object)new Date());
            DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
            int index = 1;
            String srcname = "";
            for (String srcnumber : srcNumbers) {
                DynamicObject dimMappingsrc = srcCollections.addNew();
                DynamicObject srcDimDyn = srcDynDim.get(srcnumber);
                if (srcDimDyn == null) {
                    return;
                }
                dimMappingsrc.set("srcbyfrom", (Object)2);
                dimMappingsrc.set("srcdimension", srcDimDyn.get("id"));
                dimMappingsrc.set("srcdimtype", (Object)"bcm_isbaseentlist");
                srcname = index == 1 ? srcDimDyn.getString("name") : srcname + "+" + srcDimDyn.getString("name");
                dimMappingsrc.set("seq", (Object)index++);
            }
            index = 1;
            String targname = "";
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            for (String targnumber : targetNumbers) {
                DynamicObject dimMappingtarg = targCollections.addNew();
                DynamicObject targDimDyn = targetDynDim.get(targnumber);
                if (targDimDyn == null) {
                    return;
                }
                dimMappingtarg.set("tagbyfrom", (Object)1);
                dimMappingtarg.set("tagdimension", targDimDyn.get("id"));
                dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
                targname = index == 1 ? targDimDyn.getString("name") : targname + "+" + targDimDyn.getString("name");
                dimMappingtarg.set("seq", (Object)index++);
            }
            dimMapping.set("name", (Object)(targname + "-" + srcname));
            dimmappings.add(dimMapping);
        }
        DynamicObject[] result = dimmappings.toArray(new DynamicObject[dimmappings.size()]);
        if (result.length > 0) {
            SaveServiceHelper.save((DynamicObject[])result);
        }
    }

    private Map<String, DynamicObject> queryDim(Set<String> numbers, String entityName) {
        String selectFields = "";
        selectFields = "bcm_dimension".equals(entityName) ? "id, name, number, membermodel as entitynumber" : "id, name, number, entitynumber";
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", numbers), this.getQFilter(entityName)});
        return result.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
    }

    private QFilter getQFilter(String entityName) {
        if ("bcm_dimension".equals(entityName)) {
            DynamicObject model = this.schemeDy.getDynamicObject("model");
            return new QFilter("model", "=", model.get("id"));
        }
        return new QFilter("scheme", "=", this.schemeDy.get("id"));
    }

    private void insertDimPerDataForExt(Long schemeId, Long modelId) {
        ArrayList<String> allDim = new ArrayList<String>(10);
        allDim.addAll(fixedDimension);
        allDim.addAll(this.dimNumber2Name.keySet());
        allDim.addAll(this.fieldNumber2Name_DT_ID.keySet());
        Map<String, Object> dimNumber2Id = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()).stream().collect(Collectors.toMap(f -> f.getString("number"), f -> f.get("id")));
        int seq = 1;
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> dimMappings = new ArrayList<DynamicObject>(allDim.size());
        for (String dimNumber : allDim) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            dimMapping.set("scheme", (Object)schemeId);
            dimMapping.set("sequence", (Object)seq++);
            dimMapping.set("creator", (Object)currUserId);
            dimMapping.set("createtime", (Object)date);
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            DynamicObject dimMappingtarg = targCollections.addNew();
            dimMappingtarg.set("tagbyfrom", (Object)"1");
            if (this.fieldNumber2Name_DT_ID.containsKey(dimNumber)) {
                dimMappingtarg.set("tagdimtype", (Object)"bcm_structofextend");
                dimMappingtarg.set("tagdimension", this.fieldNumber2Name_DT_ID.get((Object)dimNumber).p3);
                dimMapping.set("datatype", this.fieldNumber2Name_DT_ID.get((Object)dimNumber).p2);
            } else {
                dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
                dimMappingtarg.set("tagdimension", dimNumber2Id.get(dimNumber));
            }
            dimMappingtarg.set("seq", (Object)1);
            dimMapping.set("mappedtype", (Object)DimMappTypeEnum.SIMPLE.getCode());
            dimMapping.set("issys", (Object)1);
            dimMappings.add(dimMapping);
        }
        SaveServiceHelper.save((DynamicObject[])dimMappings.toArray(new DynamicObject[0]));
    }

    private void initExtendFieldData(Long extendsmodelId) {
        this.dimNumber2Name = DISchemeUtil.getDimNumber2Name(extendsmodelId);
        this.fieldNumber2Name_DT_ID = DISchemeUtil.getFieldNumber2NameDTID(extendsmodelId);
    }

    private void insertDimPerDataForCM(Long schemeId, Long modelId) {
        Map<String, DynamicObject> allDimMap = DimMapService.getDimDyoByModelId(modelId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<String> allDim = new ArrayList<String>(allDimMap.size());
        allDim.addAll(allDimMap.keySet());
        ArrayList<DynamicObject> dimMappings = new ArrayList<DynamicObject>(allDim.size());
        int seq = 1;
        for (String dimNumber : allDim) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            dimMapping.set("scheme", (Object)schemeId);
            dimMapping.set("sequence", (Object)seq++);
            dimMapping.set("creator", (Object)currUserId);
            dimMapping.set("createtime", (Object)date);
            dimMapping.set("issys", (Object)1);
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            DynamicObject dimMappingtarg = targCollections.addNew();
            dimMappingtarg.set("tagbyfrom", (Object)"1");
            dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
            dimMappingtarg.set("tagdimension", (Object)allDimMap.get(dimNumber).getLong("id"));
            dimMappings.add(dimMapping);
        }
        SaveServiceHelper.save((DynamicObject[])dimMappings.toArray(new DynamicObject[0]));
    }

    public static Map<String, DynamicObject> getDimDyoByModelId(long modelId) {
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(16);
        QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,membermodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq asc").forEach(e -> map.put(e.getString("number"), (DynamicObject)e));
        return map;
    }

    public void createSpecialDimMap() {
        Long schemeId = this.schemeDy.getLong("id");
        Long modelId = this.schemeDy.getLong("model.id");
        QFBuilder filter = new QFBuilder("scheme", "=", (Object)schemeId);
        filter.add("mappedtype", "=", (Object)DimMappTypeEnum.SPECIAL.getCode());
        if (QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filter.toArray())) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
        dimMapping.set("scheme", (Object)schemeId);
        dimMapping.set("creator", (Object)currUserId);
        dimMapping.set("createtime", (Object)date);
        dimMapping.set("mappedtype", (Object)DimMappTypeEnum.SPECIAL.getCode());
        DynamicObjectCollection tagCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        List<Tuple<Long, String, String>> allDim = this.getAllDimByModel(modelId);
        this.doTagDimMap(tagCollections, allDim);
        DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
        List<Tuple<Long, String, String>> allBaseEntList = this.getBaseEntListByScheme(schemeId);
        this.doSrcDimMap(srcCollections, allBaseEntList);
        String tagNumber = allDim.stream().map(tuple -> (String)tuple.p2).collect(Collectors.joining(","));
        String tagName = allDim.stream().map(tuple -> (String)tuple.p3).collect(Collectors.joining(","));
        String srcNumber = allBaseEntList.stream().map(tuple -> (String)tuple.p2).collect(Collectors.joining(","));
        String srcName = allBaseEntList.stream().map(tuple -> (String)tuple.p3).collect(Collectors.joining(","));
        dimMapping.set("number", (Object)(tagNumber + "-" + srcNumber));
        dimMapping.set("name", (Object)(tagName + "-" + srcName));
        DynamicObjectCollection maxSeq = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"sequence", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray(), (String)"sequence desc", (int)1);
        int seq = maxSeq.size() > 0 ? ((DynamicObject)maxSeq.get(0)).getInt("sequence") + 1 : 1;
        dimMapping.set("sequence", (Object)seq);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dimMapping});
    }

    private void doSrcDimMap(DynamicObjectCollection srcCollections, List<Tuple<Long, String, String>> allBaseEntList) {
        int indexSrc = 1;
        for (Tuple<Long, String, String> baseEnt : allBaseEntList) {
            DynamicObject dimMappingsrc = srcCollections.addNew();
            dimMappingsrc.set("srcbyfrom", (Object)"2");
            dimMappingsrc.set("srcdimtype", (Object)"bcm_isbaseentlist");
            dimMappingsrc.set("srcdimension", baseEnt.p1);
            dimMappingsrc.set("seq", (Object)indexSrc);
            ++indexSrc;
        }
    }

    private void doTagDimMap(DynamicObjectCollection tagCollections, List<Tuple<Long, String, String>> allDim) {
        int indexTag = 1;
        for (Tuple<Long, String, String> dim : allDim) {
            DynamicObject dimMappingtarg = tagCollections.addNew();
            dimMappingtarg.set("tagbyfrom", (Object)"1");
            dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
            dimMappingtarg.set("tagdimension", dim.p1);
            dimMappingtarg.set("seq", (Object)indexTag);
            ++indexTag;
        }
    }

    private List<Tuple<Long, String, String>> getBaseEntListByScheme(Long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        Set<String> textMetricList = DISchemeUtil.getSchemeTextMetric(LongUtil.toLong((Object)schemeId));
        if (textMetricList.size() > 0) {
            QFilter excludeNumber = new QFilter("number", "not in", textMetricList);
            qFilter.and(excludeNumber);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"number");
        ArrayList<Tuple<Long, String, String>> allBaseEntList = new ArrayList<Tuple<Long, String, String>>(doc.size());
        for (DynamicObject baseEnt : doc) {
            allBaseEntList.add((Tuple<Long, String, String>)Tuple.create((Object)baseEnt.getLong("id"), (Object)baseEnt.getString("number"), (Object)baseEnt.getString("name")));
        }
        return allBaseEntList;
    }

    private List<Tuple<Long, String, String>> getAllDimByModel(Long modelId) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq asc");
        ArrayList<Tuple<Long, String, String>> allDim = new ArrayList<Tuple<Long, String, String>>(doc.size());
        for (DynamicObject dim : doc) {
            allDim.add((Tuple<Long, String, String>)Tuple.create((Object)dim.getLong("id"), (Object)dim.getString("number"), (Object)dim.getString("name")));
        }
        return allDim;
    }
}

