/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.diconfig;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.enums.NgModelTypeEnum;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.intergration.scheme.ISNgModelEditPlugin;

public class DIModelConfigEditPlugin
extends AbstractBasePlugIn
implements IOperationLog,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ISNgModelEditPlugin.class);
    private static final String BTN_SAVE = "btn_save";
    private static final String CONNECTTAG = "connecttag";
    private static final String DATACENTER = "datacenter";
    private static final String APPTYPE = "apptype";
    private static final String MODELSELECTED = "modelselected";
    private static final String USERURL = "userurl";
    private static final String DATACENTERNAME = "datacentername";
    private static final String MODELNUM = "modelnum";
    private static final String MODELNAME = "modelname";
    private static final String IS_SAME_DATA_SOURCE = "is_same_data_source";
    private static final String SUCCESS = "success";
    private static final String ISLOAD = "isLoad";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONNECTTAG});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDataCenterItems("1");
        this.getModel().setValue(USERURL, (Object)RequestContext.get().getClientFullContextPath());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{USERURL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String appType = (String)this.getModel().getValue(APPTYPE);
        this.setDataCenterItems("2");
        this.setModelItems(appType);
        this.getPageCache().put(ISLOAD, "true");
        String dataCenter = (String)this.getModel().getValue(DATACENTER);
        String accountId = RequestContext.get().getAccountId();
        if (accountId.equals(dataCenter)) {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "true");
        } else {
            QFilter qfModel = new QFilter("model", "=", (Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
            QFilter qfId = new QFilter("issrcmodel", "=", (Object)((Long)this.getModel().getValue("id")));
            DynamicObject[] exists = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"name", (QFilter[])new QFilter[]{qfModel, qfId});
            if (exists.length > 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CONNECTTAG, APPTYPE, DATACENTER, USERURL});
            }
            this.reSetModelSelectedCaption(appType);
        }
    }

    private void reSetModelSelectedCaption(String type) {
        ComboEdit modelSelected = (ComboEdit)this.getControl(MODELSELECTED);
        if (NgModelTypeEnum.NGCMMODEL.getCode().toString().equals(type) || NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
            modelSelected.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u7f16\u7801", (String)"DINgModelEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        } else if (NgModelTypeEnum.NGBGMODEL.getCode().toString().equals(type)) {
            modelSelected.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u96c6\u7f16\u7801", (String)"DINgModelEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "datacenter": {
                this.checkDataCenter(e);
                break;
            }
            case "apptype": {
                String type = e.getChangeSet()[0].getNewValue() == null ? "" : String.valueOf(e.getChangeSet()[0].getNewValue());
                this.setModelItems(type);
                break;
            }
            case "modelselected": {
                this.setNameNumber(e);
                break;
            }
            case "userurl": {
                this.setDataCenterItems("1");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void setNameNumber(PropertyChangedArgs e) {
        String modelSelected;
        String string = modelSelected = e.getChangeSet()[0].getNewValue() == null ? null : (String)e.getChangeSet()[0].getNewValue();
        if (modelSelected == null) {
            return;
        }
        String[] split = modelSelected.split(":");
        String shownumber = split[0];
        String name = split[1];
        this.getModel().setValue(MODELNUM, (Object)shownumber);
        this.getModel().setValue(MODELNAME, (Object)name);
    }

    private void setModelItems(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        Object dataCenter = this.getModel().getValue(DATACENTER);
        if (dataCenter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3002", (String)"DINgModelEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(APPTYPE, (Object)"");
            return;
        }
        boolean isSameDataSource = this.checkIsSameDataSource();
        if (!isSameDataSource) {
            this.reSetModelSelectedCaption(type);
        }
        if (NgModelTypeEnum.NGCMMODEL.getCode().toString().equals(type) || NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
            Map<String, Object> models = this.getModels(new String[]{ApplicationTypeEnum.CM.index});
            if (NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(type)) {
                models = this.getModels(new String[]{ApplicationTypeEnum.RPT.index});
            }
            ArrayList comboItems = new ArrayList(16);
            models.values().forEach(model -> {
                Map modelMap = (Map)model;
                String value = (String)modelMap.get("shownumber") + ":" + (String)modelMap.get("name");
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(value));
                comboItem.setValue(value);
                comboItems.add(comboItem);
            });
            ComboEdit comboEdit = (ComboEdit)this.getControl(MODELSELECTED);
            comboEdit.setComboItems(comboItems);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String appType = (String)this.getModel().getValue(APPTYPE);
        if (StringUtils.isEmpty((String)appType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e94\u7528\u201d\u3002", (String)"DINgModelEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        if (NgModelTypeEnum.NGBGMODEL.getCode().toString().equals(appType)) {
            arg0.getFormShowParameter().setAppId(ApplicationTypeEnum.BGMD.getAppnum());
        } else if (NgModelTypeEnum.NGFRMODEL.getCode().toString().equals(appType)) {
            arg0.getFormShowParameter().setAppId(ApplicationTypeEnum.RPT.getAppnum());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            String accountId = (String)this.getModel().getValue(DATACENTER);
            String connecttag = (String)this.getModel().getValue(CONNECTTAG);
            String appType = (String)this.getModel().getValue(APPTYPE);
            String modelSelected = (String)this.getModel().getValue(MODELSELECTED);
            if (StringUtils.isEmpty((String)accountId) || StringUtils.isEmpty((String)connecttag) || StringUtils.isEmpty((String)appType) || StringUtils.isEmpty((String)modelSelected)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fde\u63a5\u6807\u8bb0\u201d\u3001\u201c\u6570\u636e\u4e2d\u5fc3\u201d\u3001\u201c\u5e94\u7528\u201d\u3001\u201c\u9009\u62e9\u4f53\u7cfb\u201d\u3002", (String)"DINgModelEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter qfConnect = new QFilter(CONNECTTAG, "=", (Object)connecttag);
            Long curId = (Long)this.getModel().getValue("id");
            curId = curId == null ? Long.valueOf(0L) : curId;
            QFilter qfId = new QFilter("id", "!=", (Object)curId);
            boolean exists = QueryServiceHelper.exists((String)"di_isngmodel", (QFilter[])new QFilter[]{qfConnect, qfId});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6807\u8bb0\u5df2\u5b58\u5728\u3002", (String)"DINgModelEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String exist = this.checkModelExist();
            if (!SUCCESS.equals(exist)) {
                e.setCancel(true);
                return;
            }
            this.getModel().setValue(DATACENTERNAME, (Object)this.getPageCache().get(accountId));
        }
    }

    private String checkModelExist() {
        return SUCCESS;
    }

    private boolean checkIsSameDataSource() {
        return "true".equals(this.getPageCache().get(IS_SAME_DATA_SOURCE));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DINgModelEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void checkPermByCur() {
        Set modelids = MemberPermHelper.getLimitedModelListByUser();
        if (modelids.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.checkPermByCur();
        Object source = e.getSource();
        if (source instanceof Save) {
            this.getModel().setValue(USERURL, (Object)RequestContext.get().getClientFullContextPath());
        }
    }

    private void checkDataCenter(PropertyChangedArgs e) {
        this.getModel().setValue(APPTYPE, null);
        this.getModel().setValue(MODELSELECTED, null);
        this.getModel().setValue(MODELNAME, null);
        this.getModel().setValue(MODELNUM, null);
        this.getView().updateView();
        String id = String.valueOf(e.getChangeSet()[0].getNewValue());
        String accountId = RequestContext.get().getAccountId();
        if (!accountId.equals(id)) {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "false");
        } else {
            this.getPageCache().put(IS_SAME_DATA_SOURCE, "true");
        }
    }

    private void setDataCenterItems(String showType) {
        if ("1".equals(showType)) {
            this.getModel().setValue(DATACENTER, null);
        }
        try {
            String tenantId = RequestContext.get().getTenantId();
            List allAccounts = AccountUtils.getAllAccounts((String)tenantId);
            String accountId = RequestContext.get().getAccountId();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            for (Account account : allAccounts) {
                if (!accountId.equals(account.getAccountId())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(account.getAccountName()));
                comboItem.setValue(account.getAccountId());
                comboItems.add(comboItem);
                this.getPageCache().put(account.getAccountId(), account.getAccountName());
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(DATACENTER);
            comboEdit.setComboItems(comboItems);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"DINgModelEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            LOG.error("DINgModelEditPlugin get data center error", (Throwable)e);
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "di_isngmodel";
    }

    @Override
    public String getBizAppId() {
        return "";
    }

    @Override
    public void writeLog(String opName, String opDescriotion) {
    }

    private Map<String, Object> getModels(String[] apptypes) {
        QFilter qf;
        HasPermDimObjResult result = PermissionServiceHelper.getUserHasPermDimObjs((long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)"bcm_model");
        if (result.hasAllDimObjPerm()) {
            qf = new QFilter("1", "=", (Object)1);
        } else {
            Set modelids = MemberPermHelper.getLimitedModelListByUser();
            qf = new QFilter("id", "in", (Object)modelids);
        }
        QFilter reporttype = new QFilter("reporttype", "in", (Object)apptypes);
        DynamicObject[] modelDyns = BusinessDataServiceHelper.load((String)"bcm_model", (String)"number,shownumber,name,reporttype", (QFilter[])new QFilter[]{qf, reporttype});
        HashMap<String, Object> models = new HashMap<String, Object>(modelDyns.length);
        for (DynamicObject d : modelDyns) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("shownumber", d.getString("shownumber"));
            map.put("name", d.getString("name"));
            map.put("reporttype", d.getString("reporttype"));
            models.put(d.getString("number"), map);
        }
        return models;
    }
}

