/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.diconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.Modify;
import kd.bos.form.operate.New;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class DINgModelListPlugin
extends AbstractBaseListPlugin {
    private static final String ctl_billlistap = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillList();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "refreshBillList1": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.refresh();
        billList.clearSelection();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_delete".equals(evt.getItemKey())) {
            this.checkPermByCur();
            BillList billList = (BillList)this.getControl(ctl_billlistap);
            ListSelectedRowCollection selectedRow = billList.getSelectedRows();
            ArrayList ids = new ArrayList();
            selectedRow.forEach(e1 -> ids.add((Long)e1.getPrimaryKeyValue()));
            QFilter qfId = new QFilter("modelconfig", "in", ids);
            DynamicObject[] exists = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"name", (QFilter[])new QFilter[]{qfId});
            if (exists.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : exists) {
                    sb.append(dynamicObject.getString("name")).append(";");
                }
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6e90\u4f53\u7cfb\u5df2\u7ecf\u88ab\u4ee5\u4e0b\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664:%s\u3002", (String)"DINgModelListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
                return;
            }
            qfId = new QFilter("id", "in", ids);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"di_isngmodel", (String)"connecttag", (QFilter[])new QFilter[]{qfId});
            StringBuilder connecttag = new StringBuilder();
            for (DynamicObject dynamicObject : load) {
                connecttag.append(dynamicObject.getString("connecttag")).append(";");
            }
            DeleteServiceHelper.delete((String)"di_isngmodel", (QFilter[])new QFilter[]{qfId});
            if (connecttag.length() > 100) {
                connecttag.substring(0, 100);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ISSchemeSheetMappingListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            billList.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        ListSelectedRowCollection selectedRow = billList.getSelectedRows();
        if (source instanceof Modify) {
            this.checkPermByCur();
            if (selectedRow.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DINgModelListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long id = (Long)((ListSelectedRow)selectedRow.get(0)).getPrimaryKeyValue();
            DynamicObject nomodel = BusinessDataServiceHelper.loadSingle((Object)id, (String)"di_isngmodel");
            String accountId = RequestContext.get().getAccountId();
            if (!accountId.equals(nomodel.getString("datacenter"))) {
                return;
            }
            QFilter qfId = new QFilter("modelconfig", "=", (Object)id);
            DynamicObject[] exists = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"name", (QFilter[])new QFilter[]{qfId});
            if (exists.length > 0) {
                List names = Arrays.stream(exists).map(x -> x.getString("name")).collect(Collectors.toList());
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6e90\u4f53\u7cfb\u5df2\u88ab\u4ee5\u4e0b\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\uff1a%s\u3002", (String)"DINgModelListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", names)));
                e.setCancel(true);
            }
        } else if (source instanceof New) {
            this.checkPermByCur();
        }
    }

    private void checkPermByCur() {
        Set modelids = MemberPermHelper.getLimitedModelListByUser();
        if (modelids.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

