/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.importexport;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIExportService;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIDeriveRuleExportImp
implements IDIExportService {
    public XSSFWorkbook exportData(Long diSchemeId) {
        return null;
    }

    public XSSFWorkbook exportData(Long diSchemeId, Object[] dataIds) {
        DynamicObject[] rules;
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219", (String)"DIDeriveRuleExportImp_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CellStyle textStyle = this.getTextStyle(sheet);
        this.setColumnCellType(sheet, textStyle);
        this.setHeader(sheet);
        this.setDescription(sheet);
        int dataStartIndex = 1;
        for (DynamicObject row : rules = this.getDeriveRuleData(diSchemeId, dataIds)) {
            XSSFRow currentRow = sheet.getRow(dataStartIndex) != null ? sheet.getRow(dataStartIndex++) : sheet.createRow(dataStartIndex++);
            XSSFCell cell1 = currentRow.createCell(0);
            XSSFCell cell2 = currentRow.createCell(1);
            XSSFCell cell3 = currentRow.createCell(2);
            cell1.setCellValue(row.getString("number"));
            cell1.setCellStyle(textStyle);
            cell2.setCellValue(row.getString("name"));
            cell2.setCellStyle(textStyle);
            cell3.setCellValue(this.getRuleString(row));
            cell3.setCellStyle(textStyle);
        }
        return workBook;
    }

    private CellStyle getTextStyle(XSSFSheet sheet) {
        XSSFCellStyle textStyle = sheet.getWorkbook().createCellStyle();
        XSSFDataFormat dataFormat = sheet.getWorkbook().createDataFormat();
        textStyle.setDataFormat(dataFormat.getFormat("@"));
        return textStyle;
    }

    private void setColumnCellType(XSSFSheet sheet, CellStyle style) {
        sheet.setDefaultColumnStyle(0, style);
        sheet.setDefaultColumnStyle(1, style);
        sheet.setDefaultColumnStyle(2, style);
        sheet.setDefaultColumnStyle(4, style);
        sheet.setDefaultColumnStyle(5, style);
        sheet.setDefaultColumnStyle(6, style);
    }

    private String getRuleString(DynamicObject row) {
        DynamicObjectCollection entryentity = row.getDynamicObjectCollection("entryentity");
        StringBuilder sb = new StringBuilder();
        entryentity.forEach(e -> {
            sb.append(e.getString("basefield.number")).append("(\"");
            sb.append(StringUtils.isEmpty((String)e.getString("conditontype")) ? "" : DiConditionEnum.getEnumByCode((String)e.getString("conditontype")).getNumber()).append("\",");
            sb.append("\"").append(e.getString("conditonvalue")).append("\",");
            sb.append("\"").append(StringUtils.isEmpty((String)e.getString("coderule")) ? "" : ("p".equals(e.getString("coderule")) ? "prefix" : "suffix")).append("\",");
            sb.append("\"").append(e.getString("coderulevalue")).append("\");");
        });
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private DynamicObject[] getDeriveRuleData(Long diSchemeId, Object[] dataIds) {
        QFilter qf = new QFilter("scheme", "=", (Object)diSchemeId).and("id", "in", (Object)dataIds);
        return BusinessDataServiceHelper.load((String)"di_deriverule", (String)"id,name,number,entryentity.basefield,entryentity.coderule,entryentity.conditontype,entryentity.conditonvalue,entryentity.coderulevalue,entryentity.fieldtype", (QFilter[])qf.toArray());
    }

    public XSSFWorkbook exportTemplate(Long diSchemeId) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet(ResManager.loadKDString((String)"\u7279\u6b8a\u8f6c\u6362\u89c4\u5219", (String)"DIDeriveRuleExportImp_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.setColumnCellType(sheet, this.getTextStyle(sheet));
        this.setHeader(sheet);
        this.setDescription(sheet);
        return workBook;
    }

    private void setDescription(XSSFSheet sheet) {
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 4, 6));
        int currentIndex = 0;
        XSSFRow currentRow = sheet.getRow(currentIndex++);
        XSSFCell cell = currentRow.createCell(4);
        CellStyle cellStyle = this.createHeaderCellStyle(sheet.getWorkbook());
        cell.setCellStyle(cellStyle);
        cell.setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u8bf4\u660e", (String)"DIDeriveRuleExportImp_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        XSSFRow titleRow = sheet.createRow(currentIndex++);
        titleRow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u6761\u4ef6\u7c7b\u578b", (String)"DIDeriveRuleExportImp_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        titleRow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DIDeriveRuleExportImp_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        titleRow.createCell(6).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7f16\u7801\u503c", (String)"DIDeriveRuleExportImp_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        for (DiConditionEnum conditionEnum : DiConditionEnum.values()) {
            XSSFRow row = sheet.createRow(currentIndex++);
            row.createCell(5).setCellValue(conditionEnum.getName().loadKDString());
            row.createCell(6).setCellValue(conditionEnum.getNumber());
        }
        XSSFRow ruleDisRow = sheet.createRow(currentIndex++);
        ruleDisRow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"DIDeriveRuleExportImp_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ruleDisRow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DIDeriveRuleExportImp_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ruleDisRow.createCell(6).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7f16\u7801\u503c", (String)"DIDeriveRuleExportImp_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        XSSFRow ruleRow1 = sheet.createRow(currentIndex++);
        ruleRow1.createCell(5).setCellValue(ResManager.loadKDString((String)"\u524d\u7f00", (String)"DIDeriveRuleExportImp_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ruleRow1.createCell(6).setCellValue("prefix");
        XSSFRow ruleRow2 = sheet.createRow(currentIndex);
        ruleRow2.createCell(5).setCellValue(ResManager.loadKDString((String)"\u540e\u7f00", (String)"DIDeriveRuleExportImp_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        ruleRow2.createCell(6).setCellValue("suffix");
    }

    private void setHeader(XSSFSheet sheet) {
        XSSFRow headRow = sheet.createRow(0);
        CellStyle cellStyle = this.createHeaderCellStyle(sheet.getWorkbook());
        XSSFCell cell = headRow.createCell(0);
        cell.setCellStyle(cellStyle);
        sheet.setColumnWidth(0, 5000);
        cell.setCellValue(ResManager.loadKDString((String)"\u7f16\u7801", (String)"DIDeriveRuleExportImp_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        XSSFCell cellName = headRow.createCell(1);
        cellName.setCellStyle(cellStyle);
        sheet.setColumnWidth(1, 5000);
        cellName.setCellValue(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DIDeriveRuleExportImp_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        XSSFCell cellRule = headRow.createCell(2);
        cellRule.setCellStyle(cellStyle);
        cellRule.setCellValue(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6", (String)"DIDeriveRuleExportImp_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        sheet.setColumnWidth(2, 30000);
    }

    private CellStyle createHeaderCellStyle(XSSFWorkbook workBook) {
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setLocked(true);
        return headerStyle;
    }
}

