/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.importexport;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIImportService;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import kd.fi.bcm.common.enums.integration.di.DiDeriveRuleFieldTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.intergration.di.importexport.DeriveRuleImportFailData;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIDeriveRuleImportImp
implements IDIImportService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DIDeriveRuleImportImp.class);
    protected Integer successCount = 0;
    protected List<Object> errorMsgCollection = new ArrayList<Object>(16);
    private Map<String, Map<String, Object>> isBaseEntList = new HashMap<String, Map<String, Object>>(16);

    public void importData(String excelUrl, long schemeId, String importModel) {
        List<Object[]> datas = this.getDatas(excelUrl, schemeId);
        List<DynamicObject> ruleList = this.getData4Save(schemeId, datas);
        if (ruleList.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.saveRules(schemeId, ruleList, importModel);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void saveRules(long schemeId, List<DynamicObject> ruleList, String importModel) {
        List<String> numbers = ruleList.stream().map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        List enableNums = QueryServiceHelper.query((String)"di_deriverule", (String)"number", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("number", "in", numbers), new QFilter("status", "=", (Object)"1")}).stream().map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        if (enableNums.size() > 0) {
            this.addErrorMsg(-1, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s \u7684\u89c4\u5219\u5df2\u5b58\u5728\u4e14\u542f\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"DIDeriveRuleImportImp_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), JSON.toJSONString(enableNums)));
        }
        List canDeleteNums = ruleList.stream().filter(dyn -> !enableNums.contains(dyn.getString("number"))).collect(Collectors.toList());
        this.successCount = canDeleteNums.size();
        if (ImportStartData.ImportStartTypeEnum.NEW.getType().equals(importModel)) {
            this.deleteRules(schemeId, null);
        } else if (ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType().equals(importModel)) {
            this.deleteRules(schemeId, numbers);
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"di_deriverule"), (Object[])canDeleteNums.toArray(), (OperateOption)op);
    }

    private void deleteRules(long schemeId, List<String> numbers) {
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        qf.and("status", "=", (Object)"0");
        if (numbers != null) {
            qf.and("number", "in", numbers);
        }
        DeleteServiceHelper.delete((String)"di_deriverule", (QFilter[])qf.toArray());
    }

    private List<DynamicObject> getData4Save(long schemeId, List<Object[]> datas) {
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(datas.size());
        datas.forEach(dataRow -> {
            DynamicObject newDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"di_deriverule"));
            newDy.set("status", (Object)"0");
            newDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDy.set("createtime", (Object)TimeServiceHelper.now());
            newDy.set("modifier", null);
            newDy.set("modifytime", null);
            newDy.set("number", dataRow[0]);
            newDy.set("name", dataRow[1]);
            newDy.set("scheme", (Object)schemeId);
            newDy.set("templatecatalog", null);
            newDy.set("description", (Object)"");
            DynamicObjectCollection entryentity = newDy.getDynamicObjectCollection("entryentity");
            List rules = (List)dataRow[2];
            rules.forEach(rule -> {
                DynamicObject addNew = entryentity.addNew();
                addNew.set("basefield", this.isBaseEntList.get(rule[0]).get("id"));
                addNew.set("fieldtype", this.isBaseEntList.get(rule[0]).get("fieldtype"));
                addNew.set("conditontype", DiConditionEnum.getEnumByNumber((String)rule[1]) == null ? null : DiConditionEnum.getEnumByNumber((String)rule[1]).getCode());
                addNew.set("conditonvalue", (Object)rule[2]);
                addNew.set("coderule", (Object)this.getCodeRule(rule[3]));
                addNew.set("coderulevalue", (Object)rule[4]);
            });
            ruleList.add(newDy);
        });
        return ruleList;
    }

    private String getCodeRule(String codeRule) {
        return kd.bos.util.StringUtils.isEmpty((String)codeRule) ? "" : ("prefix".equals(codeRule) ? "p" : "s");
    }

    private List<Object[]> getDatas(String excelUrl, long schemeId) {
        ArrayList<Object[]> datas = new ArrayList<Object[]>(10);
        this.isBaseEntList = this.getISBaseEntList(schemeId);
        HashSet<String> repeatNums = new HashSet<String>(10);
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(excelUrl);){
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            for (int rowIndex = 1; rowIndex <= lastRowNum; ++rowIndex) {
                XSSFRow row = sheet.getRow(rowIndex);
                if (this.isEmptyRow(row)) {
                    if (this.isAllEmpty(row)) continue;
                    this.addErrorMsg(rowIndex, ResManager.loadKDString((String)"\u5b58\u5728\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"DIDeriveRuleImportImp_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (kd.bos.util.StringUtils.isEmpty((String)DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(0))) || kd.bos.util.StringUtils.isEmpty((String)DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(1)))) {
                    this.addErrorMsg(rowIndex, ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DIDeriveRuleImportImp_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!BCMNumberRule.checkNumber((String)DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(0)))) {
                    this.addErrorMsg(rowIndex, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DIDeriveRuleImportImp_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (repeatNums.contains(DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(0)))) {
                    this.addErrorMsg(rowIndex, ResManager.loadKDString((String)"\u7f16\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u5bfc\u5165\u3002", (String)"DIDeriveRuleImportImp_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                Object result = this.checkRule(DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(2)));
                if (result instanceof String) {
                    this.addErrorMsg(rowIndex, (String)result);
                    continue;
                }
                repeatNums.add(DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(0)));
                Object[] data = new Object[]{DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(0)), DIDeriveRuleImportImp.getCellValueByCell((CellBase)row.getCell(1)), result};
                datas.add(data);
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"Excel\u6253\u5f00\u5931\u8d25\u3002", (String)"DIDeriveRuleImportImp_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u683c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u5e76\u91cd\u65b0\u5bfc\u5165\u3002", (String)"DIDeriveRuleImportImp_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return datas;
    }

    private Object checkRule(String ruleValue) {
        HashMap<String, String[]> reMap = new HashMap<String, String[]>(10);
        if (kd.bos.util.StringUtils.isEmpty((String)ruleValue)) {
            return new ArrayList(reMap.values());
        }
        String[] filters = ruleValue.split(";");
        String regex = "(\\w+)\\(\"([^\"]*)\",\"([^\"]*)\",\"([^\"]*)\",\"([^\"]*)\"\\)";
        Pattern pattern = Pattern.compile(regex);
        for (String filter : filters) {
            String[] parameters;
            Matcher matcher = pattern.matcher(filter);
            if (matcher.matches()) {
                if (!this.isBaseEntList.containsKey(matcher.group(1).toLowerCase())) {
                    return String.format(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"DIDeriveRuleImportImp_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), matcher.group(1));
                }
                Optional<String> msg = this.validateRuleCondition(matcher.group(1).toLowerCase(), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5));
                if (msg.isPresent()) {
                    return msg.get();
                }
                parameters = new String[]{matcher.group(1).toLowerCase(), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5)};
                if (reMap.containsKey(matcher.group(1).toLowerCase())) {
                    return String.format(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u5b57\u6bb5%s\u91cd\u590d\u3002", (String)"DIDeriveRuleImportImp_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), matcher.group(1));
                }
            } else {
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u683c\u5f0f\u6709\u8bef\u3002", (String)"DIDeriveRuleImportImp_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            reMap.put(matcher.group(1).toLowerCase(), parameters);
        }
        return new ArrayList(reMap.values());
    }

    private Optional<String> validateRuleCondition(String field, String conditonType, String conditonValue, String codeRule, String codeRuleValue) {
        String fieldtype = (String)this.isBaseEntList.get(field).get("fieldtype");
        DiDeriveRuleFieldTypeEnum fieldTypeEnum = DiDeriveRuleFieldTypeEnum.getEnumByCode((String)fieldtype);
        DiConditionEnum condtionEnum = DiConditionEnum.getEnumByNumber((String)conditonType);
        if (kd.bos.util.StringUtils.isNotEmpty((String)conditonValue)) {
            if (condtionEnum == null) {
                return Optional.of(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\uff0c\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u7c7b\u578b\u201d\u672a\u8bbe\u7f6e\u3002", (String)"DIDeriveRuleImportImp_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String msg = "";
            if (DiDeriveRuleFieldTypeEnum.NUMBERIC == fieldTypeEnum) {
                msg = this.validateNumber(condtionEnum, conditonValue);
            } else if (DiDeriveRuleFieldTypeEnum.INT == fieldTypeEnum) {
                msg = this.validateInt(condtionEnum, conditonValue);
            } else if (DiConditionEnum.BETWEEN == condtionEnum) {
                msg = this.validateBetween(conditonValue);
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)msg)) {
                return Optional.of(msg);
            }
        } else if (condtionEnum != null && !condtionEnum.isNonCondValue()) {
            return Optional.of(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\u3002", (String)"DIDeriveRuleImportImp_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (kd.bos.util.StringUtils.isEmpty((String)codeRule) ^ kd.bos.util.StringUtils.isEmpty((String)codeRuleValue)) {
            return Optional.of(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u6216\u89c4\u5219\u7f16\u7801\u503c\u672a\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u5b8c\u6574\u6570\u636e\u3002", (String)"DIDeriveRuleImportImp_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)codeRule) && !"prefix".equals(codeRule) && !"suffix".equals(codeRule)) {
            return Optional.of(ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u5e94\u4e3a\u201cprefix\u201d\u6216\u8005\u201csuffix\u201d\uff0c\u8bf7\u7ef4\u62a4\u5e76\u91cd\u8bd5\u3002", (String)"DIDeriveRuleImportImp_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private String validateNumber(DiConditionEnum condtionEnum, String conditonvalue) {
        if (condtionEnum.isMultiCondValue()) {
            for (String s : conditonvalue.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)s) || NumberUtils.isNumber((String)s)) continue;
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201d\u8bbe\u7f6e\u6709\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c\u3002", (String)"DIDeriveRuleImportImp_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        } else {
            if (condtionEnum.isSingleCondValue() && !NumberUtils.isNumber((String)conditonvalue)) {
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201d\u8bbe\u7f6e\u6709\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u503c\u3002", (String)"DIDeriveRuleImportImp_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (DiConditionEnum.LIKE == condtionEnum || DiConditionEnum.NOT_LIKE == condtionEnum || DiConditionEnum.LLIKE == condtionEnum || DiConditionEnum.RLIKE == condtionEnum || DiConditionEnum.IN == condtionEnum || DiConditionEnum.NOT_IN == condtionEnum) {
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u4e2d\u6570\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u5305\u542b\uff0c\u4e0d\u5305\u542b\uff0c\u4ee5..\u5f00\u59cb\uff0c\u4ee5..\u7ed3\u675f\uff0c\u5728..\u4e2d\uff0c\u4e0d\u5728..\u4e2d\u7b49\u6761\u4ef6\u7c7b\u578b\u3002", (String)"DIDeriveRuleImportImp_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String validateInt(DiConditionEnum condtionEnum, String conditonvalue) {
        if (condtionEnum.isMultiCondValue()) {
            for (String s : conditonvalue.split(",")) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)s) || NumberUtils.isDigits((String)s)) continue;
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201c\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u578b\u3002", (String)"DIDeriveRuleImportImp_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        } else {
            if (condtionEnum.isSingleCondValue() && !NumberUtils.isDigits((String)conditonvalue)) {
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201c\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u578b\u3002", (String)"DIDeriveRuleImportImp_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            if (DiConditionEnum.LIKE == condtionEnum || DiConditionEnum.LLIKE == condtionEnum || DiConditionEnum.RLIKE == condtionEnum) {
                return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u4e2d\u6574\u578b\u7c7b\u578b\u4e0d\u652f\u6301\u5305\u542b\uff0c\u4e0d\u5305\u542b\uff0c\u4ee5..\u5f00\u59cb\uff0c\u4ee5..\u7ed3\u675f\u7b49\u6761\u4ef6\u7c7b\u578b\u3002", (String)"DIDeriveRuleImportImp_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String validateBetween(String conditonValue) {
        String[] vs = conditonValue.split(",");
        if (vs.length != 2 || Arrays.stream(vs).filter(kd.bos.util.StringUtils::isNotEmpty).count() != 2L) {
            return ResManager.loadKDString((String)"\u6d3e\u751f\u6761\u4ef6\u201c\u6761\u4ef6\u503c\u201d\u8bbe\u7f6e\u9519\u8bef\uff0c\u6761\u4ef6\u503c\u5e94\u5728\u533a\u95f4\u8303\u56f4\uff0c\u4f8b\u59821,100\u3002", (String)"DIDeriveRuleImportImp_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public List<Object> getErrorMsgs() {
        return this.errorMsgCollection;
    }

    public Integer getSuccessCount() {
        return this.successCount;
    }

    protected boolean isEmptyRow(XSSFRow row) {
        if (null == row) {
            return true;
        }
        boolean isEmpty = true;
        int maxCol = 2;
        for (int i = 0; i <= maxCol; ++i) {
            if (null == row.getCell(i) || !kd.bos.util.StringUtils.isNotEmpty((String)row.getCell(i).getRawValue())) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    private boolean isAllEmpty(XSSFRow row) {
        return !(row.getCell(0) != null && !kd.bos.util.StringUtils.isEmpty((String)row.getCell(0).getRawValue()) || row.getCell(1) != null && !kd.bos.util.StringUtils.isEmpty((String)row.getCell(1).getRawValue()) || row.getCell(2) != null && !kd.bos.util.StringUtils.isEmpty((String)row.getCell(2).getRawValue()));
    }

    private void addErrorMsg(int rowNumber, String msg) {
        this.errorMsgCollection.add(new DeriveRuleImportFailData(rowNumber, msg));
    }

    private Map<String, Map<String, Object>> getISBaseEntList(long schemeId) {
        String extendstable;
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,name,number", (QFilter[])qFilter.toArray(), (String)"number");
        if (query.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(1);
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(query.size());
        query.forEach(e -> {
            HashMap<String, Object> res = new HashMap<String, Object>(16);
            res.put("id", e.getLong("id"));
            res.put("name", e.getString("name"));
            res.put("number", e.getString("number"));
            map.put(e.getString("number"), res);
        });
        DynamicObject isscheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"sourceobj,extendstable,datasrctype,singlemetric", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        String singlemetric = isscheme.getString("singlemetric");
        if (isscheme.get("sourceobj") != null && DIDataSrcTypeEnum.InServiceObj.getValue().equals(isscheme.getString("datasrctype"))) {
            DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)isscheme.getLong("sourceobj"), (String)"isc_metadata_schema", (String)"group,prop_entryentity.prop_name,prop_entryentity.prop_label,prop_entryentity.data_type");
            DynamicObjectCollection prop_entryentity = src.getDynamicObjectCollection("prop_entryentity");
            prop_entryentity.forEach(p -> {
                Map res = (Map)map.get(p.getString("prop_name"));
                if (res != null) {
                    res.put("datatype", p.getString("data_type"));
                    if (p.getString("prop_name").equals(singlemetric)) {
                        res.put("fieldtype", DiDeriveRuleFieldTypeEnum.NUMBERIC.getCode());
                    } else {
                        DiDeriveRuleFieldTypeEnum fieldtype = DiDeriveRuleFieldTypeEnum.searchEnumByDB((String)p.getString("data_type"));
                        if (fieldtype != null) {
                            res.put("fieldtype", fieldtype.getCode());
                        }
                    }
                }
            });
        } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(isscheme.getString("datasrctype")) && StringUtils.isNotEmpty((CharSequence)(extendstable = isscheme.getString("extendstable"))) && DB.getTables((DBRoute)BCMConstant.DBROUTE).contains(extendstable.toLowerCase(Locale.ENGLISH))) {
            List columnNames = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)extendstable);
            columnNames.forEach(p -> {
                Map res = (Map)map.get(p.getFieldName());
                if (res != null) {
                    res.put("datatype", p.getDataType());
                    if (p.getFieldName().equals(singlemetric)) {
                        res.put("fieldtype", DiDeriveRuleFieldTypeEnum.NUMBERIC.getCode());
                    } else {
                        DiDeriveRuleFieldTypeEnum fieldtype = DiDeriveRuleFieldTypeEnum.searchEnumByDB((String)p.getDataType());
                        if (fieldtype != null) {
                            res.put("fieldtype", fieldtype.getCode());
                        }
                    }
                }
            });
        }
        return map;
    }

    public static String getCellValueByCell(CellBase cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    sdf = format == 20 || format == 32 ? new SimpleDateFormat("HH:mm") : (format == 14 || format == 31 || format == 57 || format == 58 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new KDBizException("exception on get date data !".concat(e.toString()));
                    }
                }
                BigDecimal bd = new BigDecimal(String.valueOf(cell.getNumericCellValue()));
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (CellType.NUMERIC == cachedFormulaResultType) {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                if (CellType.STRING != cachedFormulaResultType) break;
                cellValue = cell.getStringCellValue();
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "ERROR VALUE";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }
}

