/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.pusheasrpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIIntegrateContext;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class DIPushRpt2EasContext {
    private Pair<Long, String> scheme;
    private Pair<Long, String> model;
    private Pair<Long, String> scene;
    private Pair<Long, String> currency;
    private Pair<Long, String> year;
    private Pair<Long, String> period;
    private Map<String, String> entityMapping;
    private List<TemplateModel> templateModels;
    private DIIIntegrateContext inteCtx;
    private Map<String, Long> dimsMap;
    private List<String> dimensions;
    private Map<String, Map<String, String>> cellParams;
    private boolean isContainMyCompany;
    private String seqDimNum = null;
    private String tarRptType;
    private String tarPeriodType;
    private String tarYear;
    private String tarPeriod;
    private List<String> tarCompanyNumbers;
    private List<String> tarCurrencyNumbers;
    private List<Map<String, String>> tarIndexParams;
    private String tarTempNumber;
    private String tarInteMappingId;
    private String tarScheme;
    private boolean isInterExch;
    private Map<String, String> dim2ParamMap;
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";

    public DIPushRpt2EasContext(Map<String, Object> param) {
        this.tarRptType = (String)param.get("rptType");
        this.tarPeriodType = (String)param.get("periodType");
        this.tarYear = (String)param.get("year");
        this.tarPeriod = (String)param.get("period");
        this.tarCompanyNumbers = (List)param.get("companyNumbers");
        this.tarCurrencyNumbers = (List)param.get("currencyNumbers");
        this.tarInteMappingId = (String)param.get("inteMappingId");
        this.tarScheme = (String)param.get("scheme");
        this.isInterExch = "1".equals(String.valueOf(param.get("isInterExch")));
        this.tarTempNumber = (String)param.get("tempNumber");
        this.tarIndexParams = (List)param.get("indexParams");
        this.cellParams = this.tarIndexParams.stream().collect(Collectors.toMap(p -> (String)p.get("cp"), p -> p));
        this.dim2ParamMap = new HashMap<String, String>(){
            {
                this.put("Reportperiod", DIPushRpt2EasContext.this.tarPeriodType);
                this.put("ReportType", DIPushRpt2EasContext.this.tarRptType);
            }
        };
        this.initModel((String)param.get("modelNum"));
        this.initCQ();
    }

    private void initModel(String modelShowNum) {
        DynamicObject modelDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id,number,shownumber,name", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelShowNum)});
        if (modelDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb%s\u4e0d\u5b58\u5728\u3002", (String)"DIPushRpt2EasContext_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), modelShowNum));
        }
        this.model = Pair.onePair((Object)modelDyn.getLong("id"), (Object)modelDyn.getString("number"));
    }

    private void initCQ() {
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id,number,model", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.tarScheme), new QFilter("model", "=", this.model.p1), new QFilter("status", "=", (Object)true)});
        if (schemeDyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848%s\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u65b9\u6848\u672a\u542f\u7528\u3002", (String)"DIPushRpt2EasContext_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.tarScheme));
        }
        this.scheme = Pair.onePair((Object)schemeDyn.getLong("id"), (Object)schemeDyn.getString("number"));
        this.initDims();
        this.initYear();
        this.initPeriod();
        this.initCurrency();
        this.initScene();
        this.initEntityMapping();
        this.initTemplateModels();
        this.initDimensions();
        this.initIsContainMyCompany();
        this.initSeqDim();
        this.inteCtx = new DIIntegrateContext(this.model, this.scheme, this.currency, this.scene, this.year, this.period, Pair.onePair((Object)0L, (Object)""), null);
    }

    private void initIsContainMyCompany() {
        this.isContainMyCompany = this.dimensions.contains(PresetConstant.MYCOMPANY_DIM);
    }

    private void initDimensions() {
        this.dimensions = DimensionServiceHelper.getDimensionNumListByModel((Object)this.model.p1);
    }

    private void initDims() {
        QFBuilder qfb = new QFBuilder();
        qfb.add("model", "=", this.model.p1);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])qfb.toArray());
        this.dimsMap = new HashMap<String, Long>(16);
        dims.forEach(d -> this.dimsMap.put(d.getString("number"), d.getLong("id")));
    }

    private void initScene() {
        QFBuilder qfb = new QFBuilder();
        qfb.add("scheme", "=", this.scheme.p1);
        qfb.add("mappedtype", "=", (Object)DimMappTypeEnum.TARGET_DEFAULT.getCode());
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)this.dimsMap.get(PresetConstant.SCENE_DIM));
        DynamicObject memb = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)"id,targetmemnum,tagmemb,tagdimension", (QFilter[])qfb.toArray());
        if (memb != null) {
            for (DynamicObject dyn : memb.getDynamicObjectCollection("isdimmaptargentry")) {
                if (this.dimsMap.get(PresetConstant.SCENE_DIM).longValue() != dyn.getLong("tagdimension_id")) continue;
                DynamicObjectCollection defval = dyn.getDynamicObjectCollection("isdimmaptargdefval");
                this.scene = Pair.onePair((Object)((DynamicObject)defval.get(0)).getLong("tagmemb"), (Object)((DynamicObject)defval.get(0)).getString("targetmemnum"));
                break;
            }
        } else {
            DynamicObject[] dyn = this.querySingleMapMems((Long)this.scheme.p1, PresetConstant.SCENE_DIM, this.dimsMap.get(PresetConstant.SCENE_DIM), this.tarPeriodType);
            this.check(PresetConstant.SCENE_DIM, dyn);
            this.scene = this.getDimMemberPair(PresetConstant.SCENE_DIM, ((DynamicObject)dyn[0].getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber"));
        }
    }

    private void initYear() {
        DynamicObject[] dyn = this.querySingleMapMems((Long)this.scheme.p1, PresetConstant.FY_DIM, this.dimsMap.get(PresetConstant.FY_DIM), this.tarYear);
        this.check(PresetConstant.FY_DIM, dyn);
        this.year = this.getDimMemberPair(PresetConstant.FY_DIM, ((DynamicObject)dyn[0].getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber"));
    }

    private void initPeriod() {
        DynamicObject[] dyn = this.querySingleMapMems((Long)this.scheme.p1, PresetConstant.PERIOD_DIM, this.dimsMap.get(PresetConstant.PERIOD_DIM), this.tarPeriod);
        this.check(PresetConstant.PERIOD_DIM, dyn);
        this.period = this.getDimMemberPair(PresetConstant.PERIOD_DIM, ((DynamicObject)dyn[0].getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber"));
    }

    private void initCurrency() {
        DynamicObject[] dyn = this.querySingleMapMems((Long)this.scheme.p1, PresetConstant.CURRENCY_DIM, this.dimsMap.get(PresetConstant.CURRENCY_DIM), this.tarCurrencyNumbers.get(0));
        this.check(PresetConstant.CURRENCY_DIM, dyn);
        this.currency = this.getDimMemberPair(PresetConstant.CURRENCY_DIM, ((DynamicObject)dyn[0].getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber"));
    }

    private void initEntityMapping() {
        DynamicObject[] dyn = this.querySingleMapMems((Long)this.scheme.p1, PresetConstant.ENTITY_DIM, this.dimsMap.get(PresetConstant.ENTITY_DIM), this.tarCompanyNumbers.toArray(new String[0]));
        this.check(PresetConstant.ENTITY_DIM, dyn);
        HashMap<String, String> map = new HashMap<String, String>(dyn.length);
        Arrays.stream(dyn).forEach(d -> map.put(((DynamicObject)d.getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber"), ((DynamicObject)d.getDynamicObjectCollection("isgroupsrcmapentry").get(0)).getString("srcmembnumber")));
        this.entityMapping = map;
    }

    private Pair<Long, String> getDimMemberPair(String dimNum, String memberNum) {
        IDNumberTreeNode member = MemberReader.findMemberByNumber((String)((String)this.model.p2), (String)dimNum, (String)memberNum);
        return Pair.onePair((Object)member.getId(), (Object)memberNum);
    }

    private void initTemplateModels() {
        QFBuilder filters = new QFBuilder("model", "=", this.model.p1);
        filters.add("number", "=", (Object)this.tarTempNumber);
        filters.add("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())});
        DynamicObject[] tmpls = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"id", (QFilter[])filters.toArray());
        Set idsMap = Arrays.stream(tmpls).map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map rightTmplIds = TemplateUtils.getRightTplIdByVersioned((Long)((Long)this.model.p1), (Long)((Long)this.year.p1), (Long)((Long)this.period.p1), idsMap);
        ArrayList<TemplateModel> models = new ArrayList<TemplateModel>(10);
        rightTmplIds.values().forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
        if (models.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u661f\u701a\u6a21\u677f\u3002", (String)"DIPushRpt2EasContext_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), this.tarTempNumber));
        }
        this.templateModels = models;
    }

    private void initSeqDim() {
        DynamicObject sequenceDim = BusinessDataServiceHelper.loadSingle((String)"bcm_userdefinedmembertree", (String)"dimension.number,number", (QFilter[])new QFBuilder().add("model", "=", this.model.p1).add("isleaf", "=", (Object)false).add("isseq", "=", (Object)true).toArray());
        this.seqDimNum = sequenceDim == null ? null : sequenceDim.getString("dimension.number");
    }

    private DynamicObject[] querySingleMapMems(Long schemeId, String dimNum, Long dimId, String ... srcMembs) {
        QFBuilder qfb = new QFBuilder();
        qfb.add("scheme", "=", (Object)schemeId);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
        DynamicObject dimmap = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)"id, inheritancescheme.id, number", (QFilter[])qfb.toArray());
        if (dimmap == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6%s\u7f3a\u5c11\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DIPushRpt2EasContext_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimNum));
        }
        qfb.clear();
        qfb.add("schemeid", "=", (Object)schemeId);
        qfb.add("dimmapid", "=", (Object)dimmap.getLong("id"));
        qfb.add("isgroupsrcmapentry.srcmembnumber", "in", (Object)srcMembs);
        DynamicObject[] groupMaps = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"isgroupsrcmapentry.srcmembnumber,isgrouptargmapentry.tarmembnumber,isgrouptargmapentry.tarmember", (QFilter[])qfb.toArray());
        Long inheritanceschemeId = dimmap.getLong("inheritancescheme.id");
        if (groupMaps.length > 0 || inheritanceschemeId == null || inheritanceschemeId == 0L) {
            return groupMaps;
        }
        String number = dimmap.getString("number");
        return DIPushRpt2EasContext.addInheritMemerMap(inheritanceschemeId, number);
    }

    private static DynamicObject[] addInheritMemerMap(Long schemeId, String number) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        QFilter numberQf = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection dimMappingInher = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, inheritancescheme.id, number", (QFilter[])new QFilter[]{schemeQf, numberQf});
        if (CollectionUtil.isEmpty((Collection)dimMappingInher)) {
            return new DynamicObject[0];
        }
        List ids = dimMappingInher.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"isgroupsrcmapentry.srcmembnumber,isgrouptargmapentry.tarmembnumber,isgrouptargmapentry.tarmember", (QFilter[])new QFilter[]{new QFilter("dimmapid", "in", ids)});
    }

    private void check(String dimNum, DynamicObject[] dyn) {
        if (dyn.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6%s\u7f3a\u5c11\u6210\u5458\u6620\u5c04\u3002", (String)"DIPushRpt2EasContext_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), dimNum));
        }
    }

    public Pair<Long, String> getScheme() {
        return this.scheme;
    }

    public Pair<Long, String> getModel() {
        return this.model;
    }

    public Pair<Long, String> getScene() {
        return this.scene;
    }

    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    public Pair<Long, String> getYear() {
        return this.year;
    }

    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    public Map<String, String> getEntityMapping() {
        return this.entityMapping;
    }

    public DIIIntegrateContext getInteCtx() {
        return this.inteCtx;
    }

    public String getTarRptType() {
        return this.tarRptType;
    }

    public String getTarPeriodType() {
        return this.tarPeriodType;
    }

    public String getTarYear() {
        return this.tarYear;
    }

    public String getTarPeriod() {
        return this.tarPeriod;
    }

    public List<String> getTarCurrencyNumbers() {
        return this.tarCurrencyNumbers;
    }

    public List<Map<String, String>> getTarIndexParams() {
        return this.tarIndexParams;
    }

    public String getTarInteMappingId() {
        return this.tarInteMappingId;
    }

    public List<TemplateModel> getTemplateModels() {
        return this.templateModels;
    }

    public boolean isInterExch() {
        return this.isInterExch;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public Map<String, Map<String, String>> getCellParams() {
        return this.cellParams;
    }

    public boolean isContainMyCompany() {
        return this.isContainMyCompany;
    }

    public Map<String, Long> getDimsMap() {
        return this.dimsMap;
    }

    public String getSeqDimNum() {
        return this.seqDimNum;
    }

    public Map<String, String> getDim2ParamMap() {
        return this.dim2ParamMap;
    }
}

