/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di.pusheasrpt;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowSrc;
import kd.fi.bcm.business.integration.util.DataTypeCacheInfo;
import kd.fi.bcm.business.integration.util.DataTypeUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.PeriodTypeEnum;
import kd.fi.bcm.common.enums.integration.RptSrcTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.di.pusheasrpt.DIPushRpt2EasContext;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;

public class DIPushRpt2EasService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(DIPushRpt2EasService.class);
    private static final String CELLPOSITION = "cp";
    private static final String FLOATDIMENSION = "floatDimension";
    private static final String DATAFILTER = "dataFilter";
    private static final String CELLFILTER = "cellFilter";
    private BloomFilter<String> dynaRowExistsFilter;
    private static HashMap<String, DataTypeCacheInfo> dataTypeMap = new HashMap(16);
    private Table<String, String, SquenceCounter> sequenceTable = HashBasedTable.create();
    private Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public List<Map<String, Object>> execute(DIPushRpt2EasContext ctx) {
        Map<String, Object> filter = this.getDataFilterAndCellFilter(ctx);
        try {
            Pair<String, String> filter4Log = this.buildLogFilter(filter);
            log.info("DIPushRpt2EasService-cellFilter:" + (String)filter4Log.p1);
            log.info("DIPushRpt2EasService-dataFilter:" + (String)filter4Log.p2);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        MDResultSet olapData = this.queryOlap((String)ctx.getModel().p2, (Map)filter.get(DATAFILTER), ctx.getDimensions());
        log.info("DIPushRpt2EasService-olapData-Row:" + olapData.getFetchSize());
        return this.buildTableData(ctx, olapData, (Map)filter.get(CELLFILTER));
    }

    private Pair<String, String> buildLogFilter(Map<String, Object> filter) {
        HashMap cellFilter = new HashMap(16);
        if (!ObjectUtils.isEmpty((Object)filter.get(CELLFILTER))) {
            ((Map)filter.get(CELLFILTER)).forEach((k, v) -> {
                HashMap oneCell = new HashMap(16);
                v.forEach((k1, v1) -> {
                    int max = 0;
                    HashSet<String> oneDim = new HashSet<String>(10);
                    for (String member : v1) {
                        if (max >= 10) break;
                        oneDim.add(member);
                        ++max;
                    }
                    oneCell.put(k1, oneDim);
                });
                cellFilter.put(k, oneCell);
            });
        }
        HashMap dataFilter = new HashMap(16);
        if (!ObjectUtils.isEmpty((Object)filter.get(DATAFILTER))) {
            ((Map)filter.get(DATAFILTER)).forEach((k, v) -> {
                int max = 0;
                HashSet<String> oneDim = new HashSet<String>(10);
                for (String member : v) {
                    if (max >= 100) break;
                    oneDim.add(member);
                    ++max;
                }
                if (oneDim.size() < 100) {
                    dataFilter.put(k, oneDim);
                }
            });
        }
        return Pair.onePair((Object)ObjectSerialUtil.toJson(cellFilter), (Object)ObjectSerialUtil.toJson(dataFilter));
    }

    private List<Map<String, Object>> buildTableData(DIPushRpt2EasContext ctx, MDResultSet data, Map<String, Map<String, Set<String>>> cellsFilter) {
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(10);
        String valueColName = FacTabFieldDefEnum.FIELD_MONEY.getField();
        ctx.getCellParams().forEach((k, v) -> {
            Map cellFilter = (Map)cellsFilter.get(k);
            if (ObjectUtils.isEmpty((Object)cellFilter)) {
                return;
            }
            data.beforeFirst();
            while (data.next()) {
                Row row = data.getRow();
                Object value = row.getOriginalValue(valueColName);
                if (Objects.isNull(value) || !this.match(cellFilter, row, ctx.getDimensions())) continue;
                BigDecimal amount = null;
                String txt = null;
                if (value instanceof Number) {
                    amount = row.getBigDecimal(valueColName);
                } else {
                    Map<String, String> dim2Members = this.getDim2MembersMap(data.getRow(), ctx.getDimensions());
                    DataTypeEnum dataType = DataTypeUtil.getDataTypeThreadCache((long)((Long)ctx.getModel().p1), dim2Members, dataTypeMap);
                    if (DataTypeEnum.DATETP == dataType) {
                        try {
                            Date date = DateTimeUtils.parseStrDate((String)data.getRow().getString(valueColName));
                            txt = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                        }
                        catch (Exception e) {
                            txt = data.getRow().getString(valueColName);
                            log.error("--DIPushRpt2EasService.buildTableData: convert date:", (Throwable)e);
                        }
                    } else {
                        txt = data.getRow().getString(valueColName);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)cellFilter.get(FLOATDIMENSION)))) {
                    this.packFixedRptRowInfo((List<Map<String, Object>>)table, row, ctx, amount, txt, (Map<String, String>)v);
                    continue;
                }
                Set<String> floatDims = ((Set)cellFilter.get(FLOATDIMENSION)).stream().map(dim -> dim.split("!")[0]).collect(Collectors.toSet());
                Map<Integer, String> index2FloatDim = ((Set)cellFilter.get(FLOATDIMENSION)).stream().filter(dim -> Integer.parseInt(dim.split("!")[1]) >= 0).collect(Collectors.toMap(dim -> Integer.valueOf(dim.split("!")[1]), dim -> dim.split("!")[0]));
                ArrayList<Pair<String, String>> dynItem = new ArrayList<Pair<String, String>>(3);
                floatDims.forEach(d -> dynItem.add(Pair.onePair((Object)d, (Object)row.getString(d))));
                this.packDynRptRowInfo((List<Map<String, Object>>)table, row, ctx, amount, txt, (Map<String, String>)v, (List<Pair<String, String>>)dynItem, index2FloatDim);
            }
        });
        return table;
    }

    private Map<String, String> getDim2MembersMap(Row row, List<String> allDim) {
        HashMap<String, String> dim2Members = new HashMap<String, String>(allDim.size());
        allDim.forEach(dim -> dim2Members.put((String)dim, row.getString(dim)));
        return dim2Members;
    }

    private void packDynRptRowInfo(List<Map<String, Object>> table, Row r, DIPushRpt2EasContext ctx, BigDecimal amount, String txt, Map<String, String> cellParam, List<Pair<String, String>> dynItem, Map<Integer, String> index2FloatDim) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, r, ctx, cellParam);
        row.put("fdatatype", amount == null ? 3 : 1);
        row.put("ftext", txt);
        row.put("famount", amount);
        String floatItemDim = this.getFloatItemDim(ctx.getSeqDimNum(), dynItem);
        boolean needMyCompany = ctx.isInterExch() && ctx.isContainMyCompany();
        String appendSequence = this.getSeq(r, dynItem, floatItemDim, needMyCompany);
        boolean hasNotMembMapped2Eas = ctx.getInteCtx().getSimpleMappingByKey(floatItemDim) == null;
        String membNum = r.getString(floatItemDim);
        String targMembNam = this.getDynamicName(ctx, floatItemDim, membNum, hasNotMembMapped2Eas) + appendSequence;
        row.put("fdynaitemkey", StringUtils.isNotEmpty((String)appendSequence) ? targMembNam : membNum);
        row.put("fdynaitemname", targMembNam);
        table.add(row);
        Map<String, Map<String, String>> mem2ValueFloatDims = this.getMem2ValueFloatDims(ctx, cellParam, index2FloatDim);
        mem2ValueFloatDims.forEach((k, v) -> {
            HashMap<String, Object> rowFloatItem = new HashMap<String, Object>();
            this.packRowCommonInfo((Map<String, Object>)rowFloatItem, r, ctx, (Map<String, String>)v);
            rowFloatItem.put("fdynaitemkey", StringUtils.isNotEmpty((String)appendSequence) ? targMembNam : membNum);
            rowFloatItem.put("fdynaitemname", targMembNam);
            rowFloatItem.put("fdatatype", 3);
            String floatMembNum = r.getString(k);
            String floatMembName = this.getDynamicName(ctx, (String)k, floatMembNum, hasNotMembMapped2Eas);
            rowFloatItem.put("ftext", this.getFloatItemRowFtext(String.valueOf(v.get("isNum")), floatMembNum, floatMembName));
            rowFloatItem.put("famount", null);
            if (!this.checkDynaRecordExists(rowFloatItem)) {
                table.add(rowFloatItem);
            }
        });
    }

    private Map<String, Map<String, String>> getMem2ValueFloatDims(DIPushRpt2EasContext ctx, Map<String, String> cellParam, Map<Integer, String> index2FloatDim) {
        String cp = cellParam.get(CELLPOSITION);
        Point point = ExcelUtils.pos2Point((String)cp);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(3);
        index2FloatDim.forEach((k, v) -> {
            String pos = ExcelUtils.xy2Pos((int)k, (int)point.y);
            Map<String, String> floatCellMap = ctx.getCellParams().get(pos);
            if (floatCellMap != null) {
                result.put((String)v, floatCellMap);
            }
        });
        return result;
    }

    private String getFloatItemRowFtext(String isNum, String floatMembNum, String floatMembName) {
        if ("2".equals(isNum)) {
            return floatMembName;
        }
        return floatMembNum;
    }

    private String getFloatItemDim(String seqDimNum, List<Pair<String, String>> dynItem) {
        String floatItemDim = "";
        for (Pair<String, String> item : dynItem) {
            if (!((String)item.p1).equals(seqDimNum)) {
                floatItemDim = (String)item.p1;
            }
            if (!((String)item.p1).equals(PresetConstant.INTERNALCOMPANY_DIM)) continue;
            break;
        }
        return floatItemDim;
    }

    private boolean match(Map<String, Set<String>> cellFilter, Row row, List<String> dimensions) {
        for (String dim : dimensions) {
            if (cellFilter.get(dim) == null || cellFilter.get(dim).contains(row.getString(dim))) continue;
            return false;
        }
        return true;
    }

    private String getSeq(Row r, List<Pair<String, String>> dynItem, String floatItemDim, boolean needMyCompany) {
        StringBuilder rowKeyBuilder = new StringBuilder();
        rowKeyBuilder.append(floatItemDim).append(r.getString(floatItemDim));
        if (needMyCompany) {
            rowKeyBuilder.append(PresetConstant.MYCOMPANY_DIM).append(r.getString(PresetConstant.MYCOMPANY_DIM));
        }
        String rowKey = rowKeyBuilder.toString();
        StringBuilder colKeyBuilder = new StringBuilder();
        List<Pair> sortedItems = dynItem.stream().sorted(Comparator.comparing(d -> (String)d.p1)).collect(Collectors.toList());
        sortedItems.forEach(item -> {
            if (((String)item.p1).equals(floatItemDim)) {
                return;
            }
            if (needMyCompany && ((String)item.p1).equals(PresetConstant.MYCOMPANY_DIM)) {
                return;
            }
            colKeyBuilder.append((String)item.p1).append((String)item.p2);
        });
        String colKey = colKeyBuilder.toString();
        SquenceCounter counter = (SquenceCounter)this.sequenceTable.get((Object)rowKey, (Object)colKey);
        if (counter == null) {
            counter = new SquenceCounter();
            if (this.sequenceTable.row((Object)rowKey).size() > 0) {
                counter.setSequence(this.sequenceTable.row((Object)rowKey).size());
            }
            this.sequenceTable.put((Object)rowKey, (Object)colKey, (Object)counter);
        }
        return counter.sequence == 0 ? "" : String.format("@%d", counter.sequence);
    }

    private void packFixedRptRowInfo(List<Map<String, Object>> table, Row r, DIPushRpt2EasContext ctx, BigDecimal amount, String txt, Map<String, String> cellParam) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, r, ctx, cellParam);
        row.put("fdynaitemkey", null);
        row.put("ftext", txt);
        row.put("fdatatype", amount == null ? 3 : 1);
        row.put("famount", amount);
        row.put("fdynaItemname", null);
        table.add(row);
    }

    private void packRowCommonInfo(Map<String, Object> row, Row r, DIPushRpt2EasContext ctx, Map<String, String> cellParam) {
        boolean needMyCompany;
        row.put("headpk", GlobalIdUtil.genStringId());
        row.put("fcompany", ctx.getEntityMapping().get(r.getString(PresetConstant.ENTITY_DIM)));
        row.put("fcurrency", ctx.getTarCurrencyNumbers().get(0));
        row.put("frptitem", cellParam.get("ri"));
        row.put("fdataelement", cellParam.get("de"));
        row.put("fyear", ctx.getTarYear());
        row.put("fperiod", ctx.getTarPeriod());
        row.put("fperiodtype", PeriodTypeEnum.getEnum((String)ctx.getTarPeriodType()).getValue());
        row.put("frptsrctype", RptSrcTypeEnum.getEnum((String)ctx.getTarRptType()).getValue());
        row.put("fisInterexch", ctx.isInterExch() ? 1 : 0);
        boolean bl = needMyCompany = ctx.isInterExch() && ctx.isContainMyCompany();
        if (needMyCompany) {
            boolean hasNotMembMapped2Eas = ctx.getInteCtx().getSimpleMappingByKey(PresetConstant.MYCOMPANY_DIM) == null;
            String myNum = r.getString(PresetConstant.MYCOMPANY_DIM);
            row.put("fownnumber", myNum);
            row.put("fownname", this.getDynamicName(ctx, PresetConstant.MYCOMPANY_DIM, myNum, hasNotMembMapped2Eas));
        }
    }

    private String getDynamicName(DIPushRpt2EasContext ctx, String srcDimNum, String srcMembNumb, boolean isGetSrc) {
        if (isGetSrc) {
            return MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)srcDimNum, (String)srcMembNumb).getName();
        }
        try {
            return (String)this.cache.get((Object)(srcDimNum + "|" + srcMembNumb), () -> {
                DynamicObject dyna;
                List simpleMappingByKey = ctx.getInteCtx().getSimpleMappingByKey(srcDimNum);
                String memberNum = simpleMappingByKey.stream().filter(row -> row.getTarMappedRow().stream().anyMatch(r -> r.getValue().equals(srcMembNumb))).map(row -> (String)((DIMappedRowSrc)row.getSrcMappedRow().get(0)).getValue().get(0)).findFirst().orElse("");
                String entityNumb = "";
                if (StringUtils.isNotEmpty((String)entityNumb) && StringUtils.isNotEmpty((String)memberNum) && (dyna = BusinessDataServiceHelper.loadSingle((String)entityNumb, (String)"name", (QFilter[])new QFBuilder().add("number", "=", (Object)memberNum).toArray())) != null) {
                    return dyna.getString("name");
                }
                return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ef4\u5ea6[%1$s]\u6e90\u6210\u5458[%2$s]\u5bf9\u5e94\u540d\u79f0", (String)"DIPushRpt2EasService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), srcDimNum, srcMembNumb);
            });
        }
        catch (ExecutionException e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private Map<String, Object> getDataFilterAndCellFilter(DIPushRpt2EasContext ctx) {
        HashMap<String, Object> filter = new HashMap<String, Object>(3);
        List<TemplateModel> templateModels = ctx.getTemplateModels();
        TemplateModel tmplModel = templateModels.get(0);
        if (!tmplModel.isSaveByDim()) {
            return filter;
        }
        HashMap<String, HashMap<String, Set<String>>> cellsFilter = new HashMap<String, HashMap<String, Set<String>>>(16);
        HashMap<String, Set<String>> dataFilter = new HashMap<String, Set<String>>(16);
        Map<String, Object> dimFilter = this.getFilterView(ctx);
        for (Map<String, String> m : ctx.getTarIndexParams()) {
            Map<String, Object> rowAndColMap = this.getRowAndColDim(tmplModel, m.get(CELLPOSITION));
            HashMap<String, Set<String>> allFilter = new HashMap<String, Set<String>>(16);
            if (rowAndColMap.size() <= 0) continue;
            rowAndColMap.forEach((k, v) -> {
                if (FLOATDIMENSION.equals(k)) {
                    ((Map)v).forEach((k1, v1) -> allFilter.put(k1.split("!")[0], (Set<String>)v1));
                    allFilter.put(FLOATDIMENSION, ((Map)v).keySet());
                } else {
                    HashSet<String> set = new HashSet<String>(2);
                    set.add((String)v);
                    allFilter.put((String)k, (Set<String>)set);
                }
            });
            dimFilter.forEach((k, v) -> {
                Set<String> set = new HashSet<String>(2);
                if (DimEntityNumEnum.ENTITY.getNumber().equals(k)) {
                    set = (Set)v;
                } else {
                    set.add((String)v);
                }
                allFilter.put((String)k, set);
            });
            cellsFilter.put(m.get(CELLPOSITION), allFilter);
            this.setDataFilter(allFilter, dataFilter, ctx.getDimensions());
        }
        if (cellsFilter.size() <= 0 || dataFilter.size() <= 0) {
            log.info("DIPushRpt2EasService.getDataFilterAndCellFilter.cellsFilter is empty.");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u533a\u57df\u6570\u636e\u9700\u8981\u8fd4\u56de\uff0c\u8bf7\u68c0\u67e5\u5355\u5143\u683c\u6620\u5c04\u3002", (String)"DIPushRpt2EasService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.put(CELLFILTER, cellsFilter);
        filter.put(DATAFILTER, dataFilter);
        return filter;
    }

    private void setDataFilter(Map<String, Set<String>> allFilter, Map<String, Set<String>> dataFilter, List<String> dims) {
        if (dataFilter.size() == 0) {
            dims.forEach(k -> {
                Set cfr_ignored_0 = dataFilter.put((String)k, new HashSet());
            });
        }
        HashSet needDeleteDim = new HashSet();
        dataFilter.forEach((k, v) -> {
            Set str = (Set)allFilter.get(k);
            if (!CollectionUtils.isEmpty((Collection)str)) {
                ((Set)dataFilter.get(k)).addAll(str);
            } else {
                needDeleteDim.add(k);
            }
        });
        needDeleteDim.forEach(dataFilter::remove);
    }

    private Map<String, Object> getFilterView(DIPushRpt2EasContext ctx) {
        HashMap<String, Object> dimFilter = new HashMap<String, Object>(16);
        dimFilter.put(DimEntityNumEnum.ENTITY.getNumber(), ctx.getEntityMapping().keySet());
        dimFilter.put(DimEntityNumEnum.SCENARIO.getNumber(), ctx.getScene().p2);
        dimFilter.put(DimEntityNumEnum.YEAR.getNumber(), ctx.getYear().p2);
        dimFilter.put(DimEntityNumEnum.PERIOD.getNumber(), ctx.getPeriod().p2);
        dimFilter.put(DimEntityNumEnum.CURRENCY.getNumber(), ctx.getCurrency().p2);
        TemplateModel tm = ctx.getTemplateModels().get(0);
        for (ViewPointDimensionEntry v : tm.getViewPointDimensionEntries()) {
            dimFilter.put(v.getDimension().getNumber(), v.getMember().getNumber());
        }
        for (ViewPointDimensionEntry v : tm.getPageDimensionEntries()) {
            String dim = v.getDimension().getNumber();
            if (PresetConstant.ENTITY_DIM.equals(dim) || PresetConstant.FY_DIM.equals(dim) || PresetConstant.SCENE_DIM.equals(dim) || PresetConstant.PERIOD_DIM.equals(dim) || PresetConstant.CURRENCY_DIM.equals(dim)) continue;
            String member = this.getTargetMember(ctx, v.getDimension().getId(), v.getDimension().getNumber());
            if (member == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f\u7684\u9875\u9762\u7ef4\u5305\u542b%2$s\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u6620\u5c04\u672a\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u76ee\u6807\u7f3a\u7701\u503c\u3002", (String)"DIPushRpt2EasService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tm.getNumber(), dim, dim));
            }
            dimFilter.put(dim, member);
        }
        return dimFilter;
    }

    private String getTargetMember(DIPushRpt2EasContext ctx, Long dimId, String dimNum) {
        DIIIntegrateContext inteCtx = ctx.getInteCtx();
        String member = null;
        List members = (List)inteCtx.getDefMapping().get(dimNum);
        if (!ObjectUtils.isEmpty((Object)members)) {
            member = (String)members.get(0);
        } else {
            List simpleMappingByKey = inteCtx.getSimpleMappingByKey(dimNum);
            if (simpleMappingByKey == null) {
                return member;
            }
            String srcDimNum = simpleMappingByKey.stream().map(row -> ((DIMappedRowSrc)row.getSrcMappedRow().get(0)).getKey()).findFirst().orElse("");
            if (ctx.getDim2ParamMap().get(srcDimNum) != null) {
                QFBuilder qfb = new QFBuilder();
                qfb.add("scheme", "=", ctx.getScheme().p1);
                qfb.add("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
                qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
                DynamicObject[] dimmap = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id", (QFilter[])qfb.toArray());
                qfb.clear();
                qfb.add("schemeid", "=", ctx.getScheme().p1);
                qfb.add("dimmapid", "=", (Object)dimmap[0].getLong("id"));
                qfb.add("isgroupsrcmapentry.srcmembnumber", "=", (Object)ctx.getDim2ParamMap().get(srcDimNum));
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"isgrouptargmapentry.tarmembnumber", (QFilter[])qfb.toArray());
                member = ((DynamicObject)dyns[0].getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber");
            }
        }
        return member;
    }

    private Map<String, Object> getRowAndColDim(TemplateModel tmplModel, String position) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isFloat = TemplateTypeEnum.DYNA.getType() == tmplModel.getTemplateType().intValue();
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tmplModel.getRptData());
        Point cellPoint = ExcelUtils.pos2Point((String)position);
        Cell cell = sm.getBook().getSheet(0).getCell(cellPoint.y, cellPoint.x);
        Object keyDimFlag = cell.getUserObject("KEY_DIM_FLAG");
        if (!isFloat) {
            if (keyDimFlag != null) {
                ((List)keyDimFlag).forEach(mem -> map.put(mem.getDimension().getNumber(), mem.getNumber()));
            }
        } else {
            int direct = 0;
            int fixIndex = 0;
            boolean isDataArea = false;
            BasePointInfo hitBasePoint = null;
            for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
                isDataArea = ExcelUtils.isWithInScope((String)e.getAreaRange(), (String)cellPoint.toString());
                if (!isDataArea) continue;
                List basePoints = e.getBasePoints();
                if (ObjectUtils.isEmpty((Object)basePoints)) break;
                direct = ((BasePointInfo)basePoints.get(0)).getDirect();
                for (BasePointInfo basePoint : basePoints) {
                    RangeModel b = new RangeModel(basePoint.getDynaRange());
                    if (direct == 2 && b.getY_start() <= cellPoint.y && cellPoint.y <= b.getY_end()) {
                        hitBasePoint = basePoint;
                        fixIndex = cell.getCol() - ExcelUtils.pos2X((String)e.getAreaRange().split(":")[0]);
                        continue;
                    }
                    if (direct != 1 || b.getX_start() > cellPoint.x || cellPoint.x > b.getX_end()) continue;
                    hitBasePoint = basePoint;
                    fixIndex = cell.getRow() - ExcelUtils.pos2Y((String)e.getAreaRange().split(":")[0]);
                }
            }
            if (isDataArea && hitBasePoint != null) {
                ((List)hitBasePoint.getFixMemberPosition().get(fixIndex)).forEach(dim -> map.put(dim.getDimension().getNumber(), dim.getNumber()));
                List lines = hitBasePoint.getBasePointInnerLineInfo();
                HashMap floatDimension = new HashMap();
                lines.forEach(line -> {
                    if (line.isFloated()) {
                        Set<String> numbers = this.getDynaMembScopesMembers(line.getDynaMembScopes(), tmplModel.getModelId());
                        floatDimension.put(line.getDimension().getNumber() + "!" + line.getOffset(), numbers);
                    } else {
                        line.getDynaMembScopes().forEach(scope -> map.put(line.getDimension().getNumber(), scope.getMember().getNumber()));
                    }
                });
                map.put(FLOATDIMENSION, floatDimension);
            } else if (isDataArea && keyDimFlag != null) {
                List members = (List)keyDimFlag;
                members.forEach(mem -> map.put(mem.getDimension().getNumber(), mem.getNumber()));
            }
        }
        return map;
    }

    private Set<String> getDynaMembScopesMembers(List<DynaMembScopeInfo> list, Object modelId) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynaMembScopeInfo scInfo : list) {
            new MembRangeItem(scInfo.getMember().getDimension().getUqCode(), Long.valueOf(scInfo.getMember().getId()), scInfo.getMember().getNumber(), scInfo.getRangeId(), scInfo.isCustom(), modelId).matchItems(c -> numbers.add(c.number));
        }
        return numbers;
    }

    private MDResultSet queryOlap(String modelNum, Map<String, Set<String>> dataFilter, List<String> dimensions) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(dimensions.toArray(new String[0]));
        dataFilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private boolean checkDynaRecordExists(Map<String, Object> row) {
        String hashStr;
        boolean isExists;
        if (this.dynaRowExistsFilter == null) {
            this.dynaRowExistsFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)1000000, (double)0.001f);
        }
        if (!(isExists = this.dynaRowExistsFilter.mightContain((Object)(hashStr = "" + row.get("fcompany") + row.get("fcurrency") + row.get("frptitem") + row.get("fyear") + row.get("fperiod") + row.get("fperiodtype") + row.get("frptsrctype") + row.get("fdataelement") + row.get("fisInterexch") + row.get("fdynaitemkey") + row.get("fdynaitemname") + row.get("fdatatype") + row.get("fownnumber") + row.get("fownname") + row.get("ftext") + row.get("famount"))))) {
            this.dynaRowExistsFilter.put((Object)hashStr);
        }
        return isExists;
    }

    protected static class SquenceCounter {
        private int sequence = 0;

        protected SquenceCounter() {
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }
    }
}

