/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.export;

import java.io.IOException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.intergration.export.impl.SingleDimMapExport;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public interface IDimMapMemberExport {
    public static final WatchLogger log = BcmLogFactory.getWatchLogInstance(SingleDimMapExport.class);

    public String getDimMapType();

    public DynamicObject getDimMapEntity(Long var1);

    public String getEntityNum();

    default public String getSheetName(DynamicObject dimMapping) {
        return dimMapping.getString("name");
    }

    public void buildSheetHead(XSSFWorkbook var1, XSSFSheet var2, DynamicObject var3);

    default public CellStyle createHeaderCellStyle(XSSFWorkbook workBook) {
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setLocked(true);
        return headerStyle;
    }

    public String getExportFlat();

    default public void setCellValueAndStyle(XSSFCell cell, String value, CellStyle style) {
        cell.setCellValue(value);
        cell.setCellStyle(style);
    }

    public void writeData(Long var1, Long var2, XSSFSheet var3);

    default public void setAutoSizeColumn(XSSFSheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum > 3) {
            int lastCellNum = sheet.getRow(1).getLastCellNum();
            for (int i = 0; i <= lastCellNum; ++i) {
                int maxColSize = sheet.getColumnWidth(i);
                for (int j = 4; j <= lastRowNum; ++j) {
                    XSSFCell cell = sheet.getRow(j).getCell(i);
                    if (cell == null) continue;
                    int colSize = cell.getStringCellValue().getBytes().length * 256 + 512;
                    if (colSize > maxColSize) {
                        maxColSize = colSize;
                    }
                    if (maxColSize <= 65280) continue;
                    maxColSize = 65280;
                    break;
                }
                sheet.setColumnWidth(i, maxColSize);
            }
        }
    }

    default public void export(XSSFWorkbook workBook, IClientViewProxy proxy) {
        try {
            String url = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53ca\u7ec4\u5408\u8bbe\u7f6e\u5bfc\u51fa", (String)"ISDimMemberAndComSettingPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((String)url)) {
                proxy.addAction("download", (Object)url);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"IDimMapMemberExport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

