/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.export.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.formplugin.intergration.export.impl.GroupFormulaDimMapExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GroupDimMapExport
extends GroupFormulaDimMapExport {
    @Override
    public void buildSheetHead(XSSFWorkbook workBook, XSSFSheet sheet, DynamicObject dimMapping) {
        super.buildSheetHead(workBook, sheet, dimMapping);
        if (this.tar.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 2 + this.tar.size() - 1));
        }
        if (this.src.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 2 + this.tar.size(), 4 + this.tar.size() + this.src.size() - 1));
        }
        XSSFRow headRow1 = sheet.getRow(this.rowNum - 3);
        XSSFRow headRow2 = sheet.getRow(this.rowNum - 1);
        this.setCellValueAndStyle(headRow2.createCell(this.dimIndex++), ResManager.loadKDString((String)"\u8ba1\u7b97\u5173\u7cfb", (String)"ISDimMemberAndComSettingPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.headerStyle);
        this.setCellValueAndStyle(headRow2.createCell(this.dimIndex++), ResManager.loadKDString((String)"\u79d1\u76ee\u8303\u56f4", (String)"ISDimMemberAndComSettingPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.headerStyle);
        headRow1.createCell(this.dimSign++).setCellValue("computeoprt");
        headRow1.createCell(this.dimSign++).setCellValue("scope");
        for (int i = 0; i < this.src.size(); ++i) {
            this.setCellValueAndStyle(headRow2.createCell(this.dimIndex++), ((DynamicObject)this.src.get(i)).getDynamicObject("srcdimension").getString("name"), this.headerStyle);
            headRow1.createCell(this.dimSign++).setCellValue(((DynamicObject)this.src.get(i)).getDynamicObject("srcdimension").getString("number"));
        }
    }

    @Override
    public String getExportFlat() {
        return ResManager.loadKDString((String)"\u6210\u5458\u7ec4\u5408\u6620\u5c04\u6210\u5458\u660e\u7ec6 # bcm_isgroupmap", (String)"ISDimMemberAndComSettingPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void writeData(Long schemeId, Long dimMappingId, XSSFSheet sheet) {
        String selectField = "srctype,dseq,computeoprt,templateid,templateid.number,isgrouptargmapentry,isgrouptargmapentry.tardimension,isgrouptargmapentry.tarmember,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.seq,isgroupsrcmapentry.srcdimension,isgroupsrcmapentry.srcmember,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.scope,isgroupsrcexprentry.expressions";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and("srctype", "=", (Object)"1");
        qf.and(new QFilter("dimmapid", "=", (Object)dimMappingId));
        DynamicObject[] groupMapping = BusinessDataServiceHelper.load((String)this.getEntityNum(), (String)selectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc,isgroupsrcmapentry.seq");
        if (groupMapping.length == 0) {
            return;
        }
        this.memAndComVO = MappingService.generateMemAndComVO((Long)dimMappingId);
        Objects.requireNonNull(this.memAndComVO);
        Map<String, Long> tarDimIDAndNums = this.memAndComVO.getTargetPro().stream().collect(Collectors.toMap(MemAndComVO.Node::getNumber, MemAndComVO.Node::getId));
        Map<String, Long> srcDimIDAndNums = this.memAndComVO.getSourcePro().stream().collect(Collectors.toMap(MemAndComVO.Node::getNumber, MemAndComVO.Node::getId));
        HashMap tarDimAndMemberIds = new HashMap(16);
        HashMap srcDimAndMemberIds = new HashMap(16);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number,istarg.number", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
        String srcNum = scheme.getString("issrc.number");
        String tarNum = scheme.getString("istarg.number");
        boolean isEasForSrc = IntegrateProductEnum.EASACCProduct.getNumber().equals(srcNum) || IntegrateProductEnum.EASREPProduct.getNumber().equals(srcNum);
        boolean isEasForTar = IntegrateProductEnum.EASACCProduct.getNumber().equals(tarNum) || IntegrateProductEnum.EASREPProduct.getNumber().equals(tarNum);
        for (DynamicObject group : groupMapping) {
            Set<Long> memberIds;
            Long memberId;
            Long dimId;
            for (DynamicObject isgrouptargmapentry : group.getDynamicObjectCollection("isgrouptargmapentry")) {
                dimId = isgrouptargmapentry.getLong("tardimension");
                memberId = isgrouptargmapentry.getLong("tarmember");
                if (tarDimAndMemberIds.get(dimId) != null) {
                    memberIds = (HashSet<Long>)tarDimAndMemberIds.get(dimId);
                } else {
                    memberIds = new HashSet<Long>(16);
                    tarDimAndMemberIds.put(dimId, memberIds);
                }
                memberIds.add(memberId);
            }
            for (DynamicObject isgroupsrcmapentry : group.getDynamicObjectCollection("isgroupsrcmapentry")) {
                dimId = isgroupsrcmapentry.getLong("srcdimension");
                memberId = isgroupsrcmapentry.getLong("srcmember");
                if (srcDimAndMemberIds.get(dimId) != null) {
                    memberIds = (Set)srcDimAndMemberIds.get(dimId);
                } else {
                    memberIds = new HashSet(16);
                    srcDimAndMemberIds.put(dimId, memberIds);
                }
                memberIds.add(memberId);
            }
        }
        HashMap tarDimAndMemberInfo = new HashMap(16);
        HashMap srcDimAndMemberInfo = new HashMap(16);
        this.memAndComVO.getTargetPro().forEach(tarDim -> {
            Long dimId = tarDim.getId();
            Set memberIds = (Set)tarDimAndMemberIds.get(dimId);
            if (!CollectionUtils.isEmpty((Collection)memberIds)) {
                QFilter qFilter = new QFilter("id", "in", (Object)(isEasForTar ? memberIds.stream().map(Object::toString).collect(Collectors.toSet()) : memberIds));
                DynamicObject[] tarMembers = BusinessDataServiceHelper.load((String)tarDim.getEntityName(), (String)"number,name", (QFilter[])qFilter.toArray());
                Map<String, String> memNumAndName = Stream.of(tarMembers).collect(Collectors.toMap(t -> t.getString("number"), t -> t.getString("name")));
                tarDimAndMemberInfo.put(dimId, memNumAndName);
            }
        });
        this.memAndComVO.getSourcePro().forEach(srcDim -> {
            Long dimId = srcDim.getId();
            Set memberIds = (Set)srcDimAndMemberIds.get(dimId);
            if (!CollectionUtils.isEmpty((Collection)memberIds)) {
                QFilter qFilter = new QFilter("id", "in", (Object)(isEasForSrc ? memberIds.stream().map(Object::toString).collect(Collectors.toSet()) : memberIds));
                DynamicObject[] tarMembers = BusinessDataServiceHelper.load((String)srcDim.getEntityName(), (String)"number,name", (QFilter[])qFilter.toArray());
                Map<String, String> memNumAndName = Stream.of(tarMembers).collect(Collectors.toMap(t -> t.getString("number"), t -> t.getString("name")));
                srcDimAndMemberInfo.put(dimId, memNumAndName);
            }
        });
        for (DynamicObject group : groupMapping) {
            Map memNumAndName;
            XSSFRow row = sheet.createRow(this.rowNum++);
            int columnNum = 0;
            row.createCell(columnNum++).setCellValue("");
            DynamicObject template = group.getDynamicObject("templateid");
            String tempNum = template == null ? "" : template.getString("number") + "|" + template.getString("name");
            row.createCell(columnNum++).setCellValue(tempNum);
            DynamicObjectCollection tarMember = group.getDynamicObjectCollection("isgrouptargmapentry");
            DynamicObjectCollection srcMember = group.getDynamicObjectCollection("isgroupsrcmapentry");
            List entryScopes = srcMember.stream().filter(s -> !MapScopeEnum.EQUALS.getIndex().equals(s.getString("scope"))).map(s -> s.getString("scope")).collect(Collectors.toList());
            for (int i = 0; i < this.tar.size(); ++i) {
                String tarDimNumber = sheet.getRow(1).getCell(columnNum).getStringCellValue();
                long dimId = tarDimIDAndNums.get(tarDimNumber) == null ? 0L : tarDimIDAndNums.get(tarDimNumber);
                Optional<DynamicObject> tm = tarMember.stream().filter(t -> dimId == t.getLong("tardimension")).findAny();
                if (tm.isPresent()) {
                    DynamicObject t2 = tm.get();
                    memNumAndName = (Map)tarDimAndMemberInfo.get(dimId);
                    String tarmembnumber = t2.getString("tarmembnumber");
                    String tarmembname = memNumAndName != null && memNumAndName.get(tarmembnumber) != null ? (String)memNumAndName.get(tarmembnumber) : "";
                    row.createCell(columnNum++).setCellValue(tarmembnumber + "|" + tarmembname);
                    continue;
                }
                ++columnNum;
            }
            String computeoprt = ComputeOprtEnum.getNameByIndex((String)group.getString("computeoprt"));
            row.createCell(columnNum++).setCellValue(computeoprt);
            String scope = entryScopes.size() == 0 ? MapScopeEnum.EQUALS.getName() : MapScopeEnum.getNameByIndex((String)((String)entryScopes.get(0)));
            row.createCell(columnNum++).setCellValue(scope);
            for (int i = 0; i < this.src.size(); ++i) {
                String srcDimNumber = sheet.getRow(1).getCell(columnNum).getStringCellValue();
                long dimId = srcDimIDAndNums.get(srcDimNumber) == null ? 0L : srcDimIDAndNums.get(srcDimNumber);
                memNumAndName = (Map)srcDimAndMemberInfo.get(dimId);
                if (i == 0 && (MapScopeEnum.RANGE.getName().equals(scope) || MapScopeEnum.INCLUDE.getName().equals(scope))) {
                    List accountEntry = srcMember.stream().filter(s -> dimId == s.getLong("srcdimension")).collect(Collectors.toList());
                    if (accountEntry.size() > 0) {
                        List memShowName = accountEntry.stream().map(a -> {
                            String srcmembnumber = a.getString("srcmembnumber");
                            String srcmembname = memNumAndName != null && memNumAndName.get(srcmembnumber) != null ? (String)memNumAndName.get(srcmembnumber) : "";
                            return srcmembnumber + "|" + srcmembname;
                        }).collect(Collectors.toList());
                        String accountCellValue = MapScopeEnum.RANGE.getName().equals(scope) ? StringUtils.join(memShowName, (String)"<-->") : StringUtils.join(memShowName, (String)",");
                        row.createCell(columnNum++).setCellValue(accountCellValue);
                        continue;
                    }
                } else {
                    Optional<DynamicObject> sm = srcMember.stream().filter(s -> dimId == s.getLong("srcdimension")).findAny();
                    if (sm.isPresent()) {
                        DynamicObject s2 = sm.get();
                        String srcmembnumber = s2.getString("srcmembnumber");
                        String srcmembname = memNumAndName != null && memNumAndName.get(srcmembnumber) != null ? (String)memNumAndName.get(srcmembnumber) : "";
                        row.createCell(columnNum++).setCellValue(srcmembnumber + "|" + srcmembname);
                        continue;
                    }
                }
                ++columnNum;
            }
        }
    }
}

