/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.export.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.formplugin.intergration.export.IDimMapMemberExport;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SingleDimMapExport
implements IDimMapMemberExport {
    private int rowNum = 0;

    @Override
    public String getDimMapType() {
        return DimMappTypeEnum.SINGLE.getCode();
    }

    @Override
    public DynamicObject getDimMapEntity(Long dimMappingId) {
        String selectField = "id,name,number,seq,mappedtype,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmapsrcentry.srcdimension,isdimmapsrcentry.srcdimtype";
        QFilter qFilter = new QFilter("id", "=", (Object)dimMappingId);
        DynamicObject dimMapping = BusinessDataServiceHelper.loadSingle((String)"bcm_isdimmap", (String)selectField, (QFilter[])qFilter.toArray());
        return dimMapping;
    }

    @Override
    public String getEntityNum() {
        return "bcm_issinglemap";
    }

    @Override
    public void buildSheetHead(XSSFWorkbook workBook, XSSFSheet sheet, DynamicObject dimMapping) {
        CellStyle headerStyle = this.createHeaderCellStyle(workBook);
        String exportFlat = this.getExportFlat();
        sheet.createRow(this.rowNum++).createCell(0).setCellValue(exportFlat);
        String number = dimMapping.getString("number");
        String[] tarAndSrc = number.split("-");
        XSSFRow row1 = sheet.createRow(this.rowNum++);
        row1.createCell(0).setCellValue(tarAndSrc[0]);
        row1.createCell(2).setCellValue(tarAndSrc[1]);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 1));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
        XSSFRow headRow = sheet.createRow(this.rowNum++);
        this.setCellValueAndStyle(headRow.createCell(0), ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"ISDimMemberAndComSettingPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
        this.setCellValueAndStyle(headRow.createCell(2), ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"ISDimMemberAndComSettingPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
        XSSFRow headRow1 = sheet.createRow(this.rowNum++);
        this.setCellValueAndStyle(headRow1.createCell(0), ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801", (String)"ISDimMemberAndComSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
        this.setCellValueAndStyle(headRow1.createCell(1), ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"ISDimMemberAndComSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
        this.setCellValueAndStyle(headRow1.createCell(2), ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801", (String)"ISDimMemberAndComSettingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
        this.setCellValueAndStyle(headRow1.createCell(3), ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"ISDimMemberAndComSettingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), headerStyle);
    }

    @Override
    public String getExportFlat() {
        return ResManager.loadKDString((String)"\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04 # bcm_issinglemap", (String)"ISDimMemberAndComSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void writeData(Long schemeId, Long dimMappingId, XSSFSheet sheet) {
        String selectField = "dseq,dimmapid,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and("dimmapid", "=", (Object)dimMappingId);
        DynamicObjectCollection singleMapping = QueryServiceHelper.query((String)this.getEntityNum(), (String)selectField, (QFilter[])qf.toArray());
        singleMapping.forEach(single -> {
            XSSFRow row = sheet.createRow(this.rowNum++);
            row.createCell(0).setCellValue(single.getString("targmembnumber"));
            row.createCell(1).setCellValue(single.getString("targmembname"));
            row.createCell(2).setCellValue(single.getString("srcmembnumber"));
            row.createCell(3).setCellValue(single.getString("srcmembname"));
        });
    }
}

