/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.CommomElememt;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaEditPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private Formula formula;
    private static final String batch_prefix = "set_";
    private static final String cache_prefix = "cache_";
    private static final String ZHCN = "zh_CN";
    private static final List<String> newRptInfoParams = Collections.unmodifiableList(Arrays.asList("modifytime", "entity.name", "template.data"));

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formulaNumber = (String)this.getFormCustomParam("accttype");
        this.formula = ResourcesLoaderUtil.getFormulaByNumber((String)formulaNumber);
        this.buildPageByFormula(this.formula);
        String formulaStr = StringUtils.remove((String)((String)this.getFormCustomParam("formula")), (String)formulaNumber);
        formulaStr = StringUtils.remove((String)formulaStr, (char)'(');
        formulaStr = StringUtils.remove((String)formulaStr, (char)')');
        List params = this.formula.getParam();
        if (StringUtils.isNotEmpty((CharSequence)formulaStr)) {
            try {
                this.reLoadData(formulaNumber, formulaStr, params);
            }
            catch (Exception ex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u89c4\u8303\uff0c\u4e0d\u4f1a\u751f\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53c2\u6570\u3002", (String)"FormulaEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.setDefautValue(this.formula);
        }
        if (this.formula.getNumber().equalsIgnoreCase("newrptinfo")) {
            this.changeDateFormatStatus((String)this.getFormCustomParam("formula"), false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("reportinfonew".equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            boolean isChange = false;
            if (newValue != null && oldValue != null && !newValue.toString().equals(oldValue.toString()) && newRptInfoParams.contains(newValue)) {
                isChange = true;
            }
            this.changeDateFormatStatus((String)this.getFormCustomParam("formula"), isChange);
        }
    }

    private void changeDateFormatStatus(String formulaStr, boolean flag) {
        List params = this.formula.getParam();
        if (formulaStr != null && !formulaStr.contains("modifytime") && this.getValue("reportinfonew") == null || !"modifytime".equals(this.getValue("reportinfonew")) && this.getValue("reportinfonew") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dateformat"});
            params.forEach(map -> {
                if (map.get("number").toString().equalsIgnoreCase("dateformat")) {
                    map.put("mustinput", false);
                }
            });
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dateformat"});
            params.forEach(map -> {
                if (map.get("number").toString().equalsIgnoreCase("dateformat")) {
                    map.put("mustinput", true);
                }
            });
        }
        if (flag) {
            this.setValue("dateformat", ((Map)params.get(2)).get("dateformat"));
            this.setValue("prefix", ((Map)params.get(0)).get("prefix"));
        }
        this.getView().getPageCache().put("formulacache", ObjectSerialUtil.toByteSerialized((Object)this.formula));
    }

    private void reLoadData(String formulaNumber, String formulaStr, List<Map<String, Object>> params) {
        String[] parameters = this.parseFormulaParams(formulaStr);
        ArrayList accounts = Lists.newArrayList();
        int accountIndex = 2;
        int accountSum = 0;
        int j = 0;
        boolean has_MiddleNum = formulaStr.contains("[");
        for (int i = 0; i < parameters.length; ++i) {
            String str = StringUtils.remove((String)parameters[i].trim(), (char)'\"');
            if (StringUtils.isNotEmpty((CharSequence)str)) {
                String type = params.get(j).get("type").toString();
                if ("basedatafield".equals(type) || "mulbasedatafield".equals(type)) {
                    if (str.contains("|")) {
                        str = str.split("\\|")[0];
                    }
                    if ("account".equals(params.get(j).get("number")) && "acct".equals(formulaNumber)) {
                        str = StringUtils.remove((String)str, (String)"[");
                        str = StringUtils.remove((String)str, (String)"]");
                        accounts.add(str);
                        if (++accountSum < parameters.length - 6) continue;
                    }
                    if (this.getView().getControl((String)params.get(j).get("number")) instanceof MulBasedataEdit) {
                        if (has_MiddleNum) {
                            accounts.remove(1);
                        }
                        DynamicObjectCollection doc = this.queryEntityIdByNumbers(params.get(j).get("value").toString(), accounts.isEmpty() ? str.split(",") : accounts.toArray(new String[0]));
                        Long[] ids = DynamicObjectCollectionUtil.getPKArray((DynamicObjectCollection)doc);
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)ids);
                    } else {
                        long id = this.queryEntityIdByNumber(params.get(j).get("value").toString(), str);
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)id);
                    }
                } else if ("combofield".equals(type)) {
                    Map comboMap = (Map)params.get(j).get("items");
                    for (String key : comboMap.keySet()) {
                        if (!key.equalsIgnoreCase(str)) continue;
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)key);
                    }
                } else {
                    this.getModel().setValue(params.get(j).get("number").toString(), (Object)str);
                }
                if (params.get(j).get("needcache") != null && ((Boolean)params.get(j).get("needcache")).booleanValue()) {
                    this.getPageCache().put(cache_prefix + params.get(j).get("number").toString(), str);
                }
            }
            accounts.clear();
            ++j;
        }
        Page page = this.getPage(this.getView());
        page.updatePage(this.getView());
    }

    private String[] parseFormulaParams(String paramStr) {
        ArrayList<String> params = new ArrayList<String>(10);
        boolean isQuotationStart = false;
        StringBuilder param = new StringBuilder(10);
        for (char c : paramStr.toCharArray()) {
            if (c == '\"') {
                isQuotationStart = !isQuotationStart;
                continue;
            }
            if (c == ',') {
                if (isQuotationStart) {
                    param.append(c);
                    continue;
                }
                params.add(param.toString());
                param.setLength(0);
                continue;
            }
            param.append(c);
        }
        params.add(param.toString());
        return params.toArray(new String[0]);
    }

    private void buildPageByFormula(Formula formula) {
        List params = formula.getParam();
        Page page = new Page();
        Area area = new Area("flexpanelap");
        boolean iszh = ZHCN.equals(RequestContext.get().getLang().getLangTag());
        Map<Object, Object> formulamultilingualMap = new HashMap();
        String formulaNumber = formula.getNumber().toLowerCase(Locale.ENGLISH);
        if (!iszh) {
            QFilter qFilter = new QFilter("number", "=", (Object)formulaNumber);
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_formulamultilingual", (String)"paramnumber,name", (QFilter[])qFilter.toArray());
            formulamultilingualMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getString("paramnumber"), dy -> Optional.ofNullable(dy.getLocaleString("name").getLocaleValue() != null ? dy.getLocaleString("name").getLocaleValue() : dy.getLocaleString("name").getLocaleValue_zh_CN()).orElseGet(() -> dy.getString("paramnumber")), (v1, v2) -> v1));
        }
        for (Map param : params) {
            String type = (String)param.get("type");
            String number = (String)param.get("number");
            String reName = (String)formulamultilingualMap.get(String.join((CharSequence)".", formulaNumber, number, "name"));
            String name = reName == null ? ResManager.loadKDString((String)((String)param.get("name")), (String)("FormulaEditPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]) : reName;
            String entity = "";
            if (param.get("value") instanceof String) {
                entity = (String)param.get("value");
            }
            CommomElememt au = new CommomElememt(type, name, number, entity);
            if (param.get("orgFunc") != null) {
                au.setOrgFunc(param.get("orgFunc").toString());
                if ("basedatafield".equals(type)) {
                    au.setType("orgfield");
                }
            }
            if (param.get("mustinput") != null) {
                au.setMustInput(Boolean.parseBoolean(param.get("mustinput").toString()));
            }
            if (param.get("editStyle") != null) {
                au.setEditStyle(Integer.parseInt(param.get("editStyle").toString()));
            }
            if (param.get("maxLength") != null) {
                au.setLength(Integer.parseInt(param.get("maxLength").toString()));
            }
            if (param.get("items") != null) {
                Map comboMap = (Map)param.get("items");
                ArrayList<ValueMapItem> valueMapItems = new ArrayList<ValueMapItem>(comboMap.size());
                for (Map.Entry entry : comboMap.entrySet()) {
                    String key = (String)entry.getKey();
                    ValueMapItem item = new ValueMapItem();
                    String resName = formulamultilingualMap.get(String.join((CharSequence)".", formulaNumber, number, "items", key)) == null ? ResManager.loadKDString((String)((String)entry.getValue()), (String)("FormulaEditPlugin_" + key), (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (String)formulamultilingualMap.get(String.join((CharSequence)".", formulaNumber, number, "items", key));
                    item.setName(new LocaleString(resName));
                    item.setValue(key);
                    valueMapItems.add(item);
                }
                au.setComboItems(valueMapItems.toArray(new ValueMapItem[0]));
            }
            if (this.getView().getFormShowParameter().getFormId().equals("bcm_formulaparam_wide")) {
                au.setLabelDirection("v");
                au.setStyle(this.getWideStyle());
                au.setLabelWidth(new LocaleString("200px"));
            } else {
                au.setStyle(this.getStyle());
            }
            if ("basedatafield".equals(type)) {
                au.setQuickAdd(Boolean.valueOf(false));
            }
            area.addElement((Element)au);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void setDefautValue(Formula formula) {
        List params = formula.getParam();
        for (Map param : params) {
            if (param.get("number") != null && param.get("default") != null) {
                this.setValue(param.get("number").toString(), param.get("default"));
            }
            if (!"bcm_formulapicker_invest".equals(this.getView().getFormShowParameter().getParentFormId()) || !param.get("number").equals("holder") && !param.get("number").equals("invest")) continue;
            this.setValue(param.get("number").toString(), param.get("name"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{param.get("number").toString()});
        }
    }

    private Style getStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("100px");
        margin.setTop("10px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    private Style getWideStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("30px");
        margin.setTop("10px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    @Override
    public void initialize() {
        super.initialize();
        String formulaNumber = (String)this.getFormCustomParam("accttype");
        this.formula = ResourcesLoaderUtil.getFormulaByNumber((String)formulaNumber);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm");
        this.addClickListeners("account", "cashflow", "commondimension", "commonassist");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            List params;
            String serialStr = this.getView().getPageCache().get("formulacache");
            if (StringUtils.isEmpty((CharSequence)serialStr)) {
                params = this.formula.getParam();
            } else {
                Formula formulaCache = (Formula)ObjectSerialUtil.deSerializedBytes((String)serialStr);
                params = formulaCache.getParam();
            }
            ArrayList<String> valueList = new ArrayList<String>(10);
            for (Map param : params) {
                if ("basedatafield".equals(param.get("type")) || "mulbasedatafield".equals(param.get("type"))) {
                    if (!this.addF7Data2ValueList(valueList, param)) continue;
                    return;
                }
                Object obj = this.getModel().getValue(param.get("number").toString());
                String value = "";
                if (obj == null || StringUtils.isEmpty((CharSequence)obj.toString())) {
                    if (param.get("mustinput") != null && ((Boolean)param.get("mustinput")).booleanValue()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                        return;
                    }
                } else {
                    value = obj.toString();
                }
                if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                    value = this.getPageCache().get(cache_prefix + param.get("number").toString());
                }
                if (obj != null && "datefield".equals(param.get("type"))) {
                    value = DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd");
                }
                if (obj != null && "datetimefield".equals(param.get("type"))) {
                    value = DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
                }
                valueList.add(value);
            }
            StringBuilder stringBuilder = this.getFormulaParamString(params, valueList);
            String type = (String)this.getFormCustomParam("accttype");
            String str = type + "(" + stringBuilder + ")";
            this.getView().returnDataToParent((Object)str);
            this.getView().close();
        } else if ("account".equals(key) || "cashflow".equals(key) || "commondimension".equals(key) || "commonassist".equals(key)) {
            this.showView(key);
        }
    }

    private void showView(String number) {
        FormShowParameter formShowParameter = new FormShowParameter();
        List params = this.formula.getParam();
        for (Map param : params) {
            if (!param.get("number").toString().equals(number)) continue;
            if (param.get("metadata") != null) {
                Map metadata = (Map)param.get("metadata");
                formShowParameter.setFormId(metadata.get("number").toString());
                if (metadata.get("customparam") != null) {
                    List customParams = (List)metadata.get("customparam");
                    for (String customParam : customParams) {
                        DynamicObject value = (DynamicObject)this.getModel().getValue(customParam);
                        formShowParameter.setCustomParam(customParam, (Object)(value == null ? "" : value.getString("id")));
                    }
                }
            } else {
                return;
            }
            String accountStr = (String)this.getModel().getValue(number);
            if (StringUtils.isEmpty((CharSequence)accountStr)) continue;
            formShowParameter.setCustomParam(number, (Object)accountStr);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, batch_prefix + number);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("open", "true");
    }

    private StringBuilder getFormulaParamString(List<Map<String, Object>> params, List<String> valueList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            if ("integerfield".equals(params.get(i).get("type"))) {
                stringBuilder.append(valueList.get(i)).append(',');
                continue;
            }
            stringBuilder.append('\"').append(valueList.get(i)).append('\"').append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.toString().length() - 1);
        }
        return stringBuilder;
    }

    private boolean addF7Data2ValueList(List<String> valueList, Map<String, Object> param) {
        if ("mulbasedatafield".equals(param.get("type"))) {
            DynamicObjectCollection objs = (DynamicObjectCollection)this.getModel().getValue(param.get("number").toString());
            String value = "";
            if ((objs == null || objs.isEmpty()) && param.get("mustinput") != null && ((Boolean)param.get("mustinput")).booleanValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                return true;
            }
            if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                value = this.getPageCache().get(cache_prefix + param.get("number").toString());
            } else {
                ArrayList ls = Lists.newArrayList();
                for (DynamicObject obj : objs) {
                    if (obj == null) continue;
                    ls.add(obj.getDynamicObject("fbasedataid").getString("number"));
                }
                value = String.join((CharSequence)",", ls);
            }
            valueList.add(value);
        } else {
            DynamicObject obj = (DynamicObject)this.getModel().getValue(param.get("number").toString());
            String value = "";
            if (obj == null && param.get("mustinput") != null && ((Boolean)param.get("mustinput")).booleanValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                return true;
            }
            if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                value = this.getPageCache().get(cache_prefix + param.get("number").toString());
            } else if (obj != null) {
                value = obj.getString("number");
            }
            valueList.add(value);
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        List params = this.formula.getParam();
        this.getPageCache().put("open", null);
        for (Map param : params) {
            if (!actionId.equals(batch_prefix + param.get("number").toString()) || param.get("type") == null || !param.get("type").toString().contains("basedatafield") && !param.get("type").toString().contains("textfield")) continue;
            if ("commondimension".equals(param.get("number").toString()) || "commonassist".equals(param.get("number").toString())) {
                String returnData = (String)closedCallBackEvent.getReturnData();
                if (StringUtils.isEmpty((CharSequence)returnData)) {
                    return;
                }
                this.getModel().setValue(param.get("number").toString(), (Object)returnData);
                continue;
            }
            Map returndDataMap = (Map)closedCallBackEvent.getReturnData();
            if (returndDataMap == null) {
                return;
            }
            String returndData = (String)returndDataMap.get("returnData");
            String endAccount = (String)returndDataMap.get("endaccount");
            String accounttable = (String)returndDataMap.get("accounttable");
            String level = (String)returndDataMap.get("level");
            if (StringUtils.isEmpty((CharSequence)returndData)) {
                return;
            }
            if (((Boolean)param.get("needcache")).booleanValue()) {
                this.getPageCache().put(cache_prefix + param.get("number").toString(), returndData);
                this.getPageCache().put("endAccount", endAccount);
                this.getPageCache().put("accounttable", accounttable);
                this.getPageCache().put("level", level);
            }
            this.getModel().setValue(param.get("number").toString(), (Object)returndData);
        }
    }

    private long queryEntityIdByNumber(String entityNumber, String number) {
        QFilter filter2 = new QFilter("number", "=", (Object)number);
        DynamicObject object = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{filter2});
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    private DynamicObjectCollection queryEntityIdByNumbers(String entityNumber, String[] numbers) {
        QFilter filter2 = new QFilter("number", "in", (Object)numbers);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{filter2});
        return objects;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getFormShowParameter().getCloseCallBack() == null || this.getPageCache().get("open") != null) {
            return;
        }
        String number = beforeF7SelectEvent.getProperty().getName();
        FormShowParameter formShowParameter = new FormShowParameter();
        List params = this.formula.getParam();
        for (Map param : params) {
            if (!param.get("number").toString().equals(number)) continue;
            if (param.get("metadata") != null) {
                beforeF7SelectEvent.setCancel(true);
                Map metadata = (Map)param.get("metadata");
                formShowParameter.setFormId(metadata.get("number").toString());
                if (metadata.get("customparam") == null) continue;
                List customParams = (List)metadata.get("customparam");
                for (String customParam : customParams) {
                    DynamicObject value = (DynamicObject)this.getModel().getValue(customParam);
                    formShowParameter.setCustomParam(customParam, (Object)(value == null ? "" : value.getString("id")));
                }
                continue;
            }
            return;
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, batch_prefix + number);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("open", "true");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getControl() instanceof BasedataEdit) {
            ((BasedataEdit)e.getControl()).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            List params = this.formula.getParam();
            params.forEach(p -> {
                if (e.getKey().equals(p.get("number")) && p.get("filter") != null) {
                    Map filter = (Map)p.get("filter");
                    String sql = (String)filter.get("sql");
                    List param = (List)filter.get("param");
                    ArrayList<Object> realparam = new ArrayList<Object>(10);
                    for (String ps : param) {
                        int index = ps.lastIndexOf(46);
                        String filed = ps;
                        String property = "";
                        if (index > 0) {
                            filed = ps.substring(0, index);
                            property = ps.substring(index + 1);
                        }
                        if (this.getControl(filed) != null) {
                            Object value = this.getModel().getValue(filed);
                            if (!(value instanceof DynamicObject)) continue;
                            if (StringUtils.isNotEmpty((CharSequence)property)) {
                                realparam.add(((DynamicObject)value).get(property));
                                continue;
                            }
                            realparam.add(((DynamicObject)value).get("id"));
                            continue;
                        }
                        realparam.add(ps);
                    }
                    QFilter qf = CollectionUtils.isEmpty(realparam) ? QFilter.of((String)sql, (Object[])new Object[0]) : QFilter.of((String)sql, (Object[])new Object[]{realparam});
                    ((BasedataEdit)e.getControl()).setQFilter(qf);
                }
            });
        }
    }
}

