/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.report.postman.ReportPostmanFactory;

public class FormulaLinkShowForm {
    private static final String PREFIX_ENT = "Prefix_Ent_";
    private static final String PREFIX_TEMPLATE = "Prefix_Template_";
    private static final String SELECTCELL = "selectCell";
    private static final String NUMTOMEMS = "numtomems";
    private static final String EXTENDNUMTOMEMS = "extendnumtomems";
    private static final String FROMLINKQUERY = "fromlinkquery";
    private boolean isLinkRepByAttr = false;
    private IFormView formView;
    private AbstractReportPostman postman;
    private long orgId;
    private long temId;
    private long yearId;
    private long periodId;
    private long modelId;
    private long sceneId;
    private boolean isSelectEntityTab;
    private String selectCell;
    private Map<String, String> numToMems;
    private Map<String, String> extendNumToMems;

    public FormulaLinkShowForm(IFormView view, Object param, boolean isSelectEntityTab) {
        this.formView = view;
        if (!(param instanceof FormShowParameter) && param instanceof Map) {
            Map map = (Map)param;
            this.postman = ReportPostmanFactory.getReportPostmanNoReport(isSelectEntityTab, (Map<String, Long>)((Map)param));
            this.orgId = (Long)map.get("entity");
            this.temId = (Long)map.get("tem");
            this.yearId = (Long)map.get("fyear");
            this.periodId = (Long)map.get("period");
            this.modelId = (Long)map.get("model");
            this.sceneId = (Long)map.get("scene");
            this.selectCell = (String)map.get("cell");
            this.numToMems = (Map)map.get(NUMTOMEMS);
            this.extendNumToMems = (Map)map.get(EXTENDNUMTOMEMS);
            this.isSelectEntityTab = isSelectEntityTab;
            this.isLinkRepByAttr = ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)ConfigEnum.IS_LINKREP_BYATTR.getNumber());
        }
    }

    public void showForm() {
        long dimensionId;
        PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.modelId);
        boolean isNoPerm = permissionService.isAllNoPerm(Long.valueOf(dimensionId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)DimTypesEnum.ENTITY.getNumber()).longValue()), "bcm_entitymembertree", Collections.singletonList(this.orgId));
        if (isNoPerm) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8fdb\u884c\u8054\u67e5\uff0c\u56e0\u4e3a\u6ca1\u6709\u5bf9\u5e94\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"FormulaLinkShowForm_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.postman.isSortByEntity()) {
            this.postman.addPair(this.temId, this.getReportId(this.postman, this.orgId, this.temId));
        } else {
            this.postman.addPair(this.orgId, this.getReportId(this.postman, this.orgId, this.temId));
        }
        IFormView mainPageView = this.formView.getMainView();
        IFormView parentView = this.getParentView(this.formView);
        String menuPageID = this.getMenuPageId(this.postman);
        if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
            boolean openRpt;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setPageId(menuPageID);
            formShowParameter.setFormId("bcm_cslreportprocess");
            String moduleName = ResManager.loadKDString((String)"\u8054\u67e5", (String)"FormulaLinkShowForm_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String caption = this.getOpenFormCaption(this.postman);
            formShowParameter.setCaption(moduleName + " : " + caption);
            formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)this.postman));
            formShowParameter.setCustomParam("listPageID", (Object)this.formView.getPageId());
            formShowParameter.setCustomParam("isselectentitytab", (Object)this.isSelectEntityTab);
            if (StringUtils.isNotEmpty((CharSequence)this.selectCell)) {
                formShowParameter.setCustomParam(SELECTCELL, (Object)this.selectCell);
            }
            if (this.numToMems != null) {
                formShowParameter.setCustomParam(NUMTOMEMS, this.numToMems);
                formShowParameter.setCustomParam(FROMLINKQUERY, (Object)true);
            }
            if (this.extendNumToMems != null) {
                formShowParameter.setCustomParam(EXTENDNUMTOMEMS, this.extendNumToMems);
            }
            formShowParameter.setCustomParam("KEY_MODEL_ID", this.postman.getModelPK());
            QFBuilder builder = new QFBuilder("id", "=", (Object)this.temId);
            DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,number,usage,isonlyread", (QFilter[])builder.toArray());
            boolean isWrite = permissionService.isAllWritePerm(Long.valueOf(dimensionId), "bcm_entitymembertree", Collections.singletonList(this.orgId));
            boolean bl = openRpt = isWrite && this.isLinkRepByAttr && template.getString("usage").equals("1") && !template.getBoolean("isonlyread");
            if (openRpt) {
                formShowParameter.setCustomParam("processtype", (Object)"rpt");
                formShowParameter.setCustomParam("isonlyquery", (Object)"false");
            } else {
                formShowParameter.setCustomParam("processtype", (Object)"query");
                formShowParameter.setCustomParam("isonlyquery", (Object)"true");
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            if (parentView == null) {
                this.formView.showForm(formShowParameter);
            } else {
                formShowParameter.setParentPageId(parentView.getPageId());
                formShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm(formShowParameter);
                this.formView.sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(menuPageID);
            childFormView.getFormShowParameter().setCustomParam(SELECTCELL, (Object)this.selectCell);
            childFormView.cacheFormShowParameter();
            childFormView.activate();
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
            AbstractReportPostman pm = this.postman;
            pluginProxy.getPlugIns().forEach(e -> {
                if (IIncreaseReportTab.class.isAssignableFrom(e.getClass())) {
                    ((IIncreaseReportTab)IIncreaseReportTab.class.cast(e)).increaseReportTab(pm);
                }
            });
            this.formView.sendFormAction(childFormView);
        }
    }

    private long getReportId(AbstractReportPostman postman, long orgid, long temId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", postman.getModelPK());
        qf.add("fyear", "=", postman.getYearPK());
        qf.add("period", "=", postman.getPeriodPK());
        qf.add("scene", "=", postman.getScenarioPK());
        qf.add("currency", "=", postman.getCurrencyPK());
        qf.add("entity", "=", (Object)orgid);
        qf.add("template", "=", (Object)temId);
        DynamicObject report = BusinessDataServiceHelper.loadSingle((String)"bcm_reportentity", (String)"id", (QFilter[])qf.toArray());
        return report == null ? 0L : report.getLong("id");
    }

    private String getMenuPageId(AbstractReportPostman pm) {
        return this.getMenuPagePrefix() + (pm.isSortByEntity() ? pm.getEntityPK(null) : pm.getTemplatePK(null)) + this.formView.getPageId();
    }

    private String getMenuPagePrefix() {
        return this.isSelectEntityTab ? PREFIX_ENT : PREFIX_TEMPLATE;
    }

    private String getOpenFormCaption(AbstractReportPostman pm) {
        String entityNum = pm.getTabSort().getEntityNumber();
        DynamicObject entity = QueryServiceHelper.queryOne((String)entityNum, (String)"name,id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", pm.getSortViewPK())});
        String name = "";
        if ("bcm_templateentity".equals(entityNum)) {
            if (entity != null) {
                name = entity.getString("name");
            }
        } else {
            FilterOrgStructParam param = new FilterOrgStructParam(this.modelId, this.sceneId, this.yearId, this.periodId);
            ArrayList<Long> orgList = new ArrayList<Long>(1);
            orgList.add(entity.getLong("id"));
            Map orgIdNameMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct((FilterOrgStructParam)param, orgList);
            name = !orgIdNameMap.isEmpty() ? (String)orgIdNameMap.values().stream().findFirst().get() : MemberReader.findEntityMemberById((Long)this.modelId, (Long)entity.getLong("id")).getName();
        }
        return name;
    }

    private IFormView getParentView(IFormView formView) {
        IFormView parentView;
        String appHome;
        ApplicationTypeEnum sign = ModelUtil.queryApp(formView);
        String string = appHome = ApplicationTypeEnum.CM == sign ? "bcm_apphome" : "report_apphome_new";
        for (parentView = formView.getParentView(); parentView != null && !parentView.getEntityId().equals(appHome); parentView = parentView.getParentView()) {
        }
        return parentView;
    }
}

