/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.business.formula.model.external.IFormatParam;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.integration.util.TransFormulaUtil;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.linkquery.LinkFormulaUtil;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataFormulaVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.intergration.formula.FormulaLinkShowForm;
import kd.fi.bcm.formplugin.intergration.formula.LinkQueryShowForm;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.lang3.math.NumberUtils;

public class FormulaList
extends AbstractFormPlugin {
    private Set<Long> accountIds = new HashSet<Long>(16);
    private static final String TRACENUMBER = "tracenumber";
    private static final String TRACEINFO = "traceinfo";
    private static final String TRACEINFO_TAG = "traceinfo_tag";
    private static final String KEY_FORMULALIST = "formulalist";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String COMM_FORMULA = "COMM_FORMULA";
    private final boolean supportNewLink = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SUPPORT_NEWLINK.getNumber());
    private String orgNum;
    protected static final Log log = LogFactory.getLog(FormulaList.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        this.orgNum = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (this.supportNewLink) {
            this.orgNum = this.getGLMember("Entity", this.orgNum);
        }
        this.fillData();
    }

    private void fillData() {
        String traceNum;
        String tractInfo;
        ArrayList<RowData> rowData = new ArrayList<RowData>(10);
        String formulas = (String)this.getView().getFormShowParameter().getCustomParam("formulas");
        if (StringUtils.isNotEmpty((CharSequence)formulas)) {
            tractInfo = formulas;
            traceNum = (String)this.getView().getFormShowParameter().getCustomParam("cellValue");
            this.addData2List(formulas, rowData);
        } else {
            DataTraceFrom dtf = (DataTraceFrom)JacksonUtils.fromJson((String)((String)this.getView().getFormShowParameter().getCustomParam("datatrace")), DataTraceFrom.class);
            traceNum = dtf.getM();
            tractInfo = dtf.getD();
            if ("MiddleLib".equals(tractInfo)) {
                this.getView().getPageCache().put("isMiddleLib", Boolean.TRUE.toString());
                tractInfo = (String)this.getView().getFormShowParameter().getCustomParam(TRACEINFO);
            }
            this.addData2List(dtf, rowData);
        }
        this.fillData2Flex(traceNum, tractInfo);
        this.fillData2EntryEntity(rowData);
        if (this.isCheckDetail().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"computeoprt"});
        }
    }

    private Map<String, Object> collectCommonParams() {
        Map ids = (Map)this.getView().getFormShowParameter().getCustomParam("ids");
        HashMap<String, Object> commParam = new HashMap<String, Object>(16);
        if (ids != null) {
            commParam.putAll(ids);
        }
        String orgNum = (String)this.getView().getFormShowParameter().getCustomParam("org");
        String yearNum = (String)this.getView().getFormShowParameter().getCustomParam("year");
        String periodNum = (String)this.getView().getFormShowParameter().getCustomParam("period");
        commParam.put("org", orgNum);
        commParam.put("fy", yearNum);
        commParam.put("period", periodNum);
        return commParam;
    }

    private static String formatNumberWithThousandsSeparator(String number) {
        try {
            if (NumberUtils.isCreatable((String)number)) {
                double numberDouble = Double.parseDouble(number);
                DecimalFormat decimalFormat = new DecimalFormat("#,##0.00##########");
                String formattedNumber = decimalFormat.format(numberDouble);
                return formattedNumber;
            }
        }
        catch (Exception e) {
            log.error("millennialDisplay error ", (Throwable)e);
            return number;
        }
        return number;
    }

    private void fillData2Flex(String traceNum, String traceInfo) {
        this.getModel().setValue(TRACENUMBER, (Object)FormulaList.formatNumberWithThousandsSeparator(traceNum));
        if (traceInfo != null && traceInfo.length() > 150) {
            this.getModel().setValue(TRACEINFO, (Object)(traceInfo.substring(0, 150) + "..."));
        } else {
            this.getModel().setValue(TRACEINFO, (Object)traceInfo);
        }
        if (this.getView().getPageCache().get("isMiddleLib") != null && Boolean.parseBoolean(this.getView().getPageCache().get("isMiddleLib"))) {
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getControl(TRACEINFO);
            largeTextEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408", (String)"FormulaList_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        }
        this.getModel().setValue(TRACEINFO_TAG, (Object)traceInfo);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TRACENUMBER, TRACEINFO});
    }

    private void addData2List(String formulas, List<RowData> rowData) {
        List data = FormulaAnalyze.analyticFun((String)formulas);
        for (FunctionExpr expr : data) {
            this.createFormulaRow(expr, null, rowData);
        }
    }

    private void addData2List(DataTraceFrom dtf, List<RowData> rowData) {
        List data = dtf.getDf();
        for (DataTraceFromItem item : data) {
            List exprList = FormulaAnalyze.analyticFun((String)item.getD());
            if (!exprList.isEmpty()) {
                this.createFormulaRow((FunctionExpr)exprList.get(0), item.getV(), rowData);
                continue;
            }
            RowData row = item.getT() != null && item.getTi() != null && item.getTi() != 0L ? new RowData(item.getV(), item.getOprt(), item.getD(), item.getT(), item.getTi()) : new RowData(item.getV(), item.getOprt(), item.getD(), null, null);
            rowData.add(row);
        }
    }

    private void createFormulaRow(FunctionExpr expr, String value, List<RowData> rowData) {
        StringBuffer stringBuffer = new StringBuffer();
        FormulaAnalyze.fillAcctTypeParam((FunctionExpr)expr, (String)this.orgNum, null, null);
        expr.output(stringBuffer, null);
        String formula = stringBuffer.toString();
        if (expr.getFuncionName().equalsIgnoreCase("V")) {
            this.buildVFormulaRowData(rowData, formula, value);
        } else if (expr.getFuncionName().equalsIgnoreCase("ref")) {
            this.buildRefFormulaRowData(rowData, formula, value);
        } else if (expr.getFuncionName().equalsIgnoreCase("V_DATA")) {
            this.buildVDataFormulaRowData(rowData, formula, value);
        } else {
            RowData row = new RowData(value, null, formula, null, null);
            rowData.add(row);
            if (expr.getFuncionName().equalsIgnoreCase("v_data") || expr.getFuncionName().equalsIgnoreCase("vs_data")) {
                this.getView().getPageCache().put(COMM_FORMULA, Boolean.toString(true));
            }
        }
    }

    private void buildVDataFormulaRowData(List<RowData> rowData, String formula, String value) {
        Map dimMemberMap = (Map)this.collectCommonParams().get("memberMap");
        VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormula((String)formula);
        boolean isExistCur = false;
        for (VDataRowVo columnVo : formulaVo.getColumnVos()) {
            String dimNum;
            MultiF7Result multiF7Result;
            if (!(columnVo instanceof VDataDimNodeVo) || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList() == null || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().size() != 1 || (multiF7Result = (MultiF7Result)((VDataDimNodeVo)columnVo).getMultiF7Results().getList().get(0)) == null || multiF7Result.getScope() != 10 || !"$Cur".equals(multiF7Result.getNumber()) || !dimMemberMap.containsKey(dimNum = columnVo.getDimNum())) continue;
            multiF7Result.setNumber((String)dimMemberMap.get(dimNum));
            columnVo.setCondition((String)dimMemberMap.get(dimNum));
            isExistCur = true;
        }
        RowData row = isExistCur ? new RowData(value, null, formulaVo.toExcelFormula(), null, null) : new RowData(value, null, formula, null, null);
        rowData.add(row);
    }

    private void buildVFormulaRowData(List<RowData> rowData, String formula, String value) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        ArrayList formulaParam = new ArrayList();
        try {
            Pair pair = parser.parse(formula, coder);
            ((List)pair.p2).forEach(fp -> {
                if (fp instanceof IFormatParam) {
                    formulaParam.addAll(((IFormatParam)fp).formatParam());
                }
            });
        }
        catch (Exception pair) {
            // empty catch block
        }
        Map<String, Object> commParam = this.collectCommonParams();
        long modelId = (Long)commParam.get("model");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Map dimShort2Num = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        Map dimMemberMap = (Map)commParam.get("memberMap");
        HashMap map = new HashMap(dimMemberMap);
        formulaParam.forEach(p -> {
            String e = p.toString();
            int index = e.indexOf(".");
            if (index > 0) {
                map.put(dimShort2Num.get(e.substring(0, index)), e.substring(index + 1));
            }
        });
        if (map.size() != dimShort2Num.size()) {
            RowData row = new RowData(value, null, formula, null, null);
            rowData.add(row);
            return;
        }
        Map matchTemplates = LinkQueryUtil.getMatchTemplates((long)modelId, map);
        if (matchTemplates.isEmpty()) {
            RowData row = new RowData(value, null, formula, null, null);
            rowData.add(row);
            return;
        }
        matchTemplates.forEach((k, v) -> {
            RowData row = new RowData(value, null, formula, (String)v, (Long)k);
            rowData.add(row);
        });
    }

    private void buildRefFormulaRowData(List<RowData> rowData, String formula, String value) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        ArrayList formulaParam = new ArrayList();
        try {
            Pair pair = parser.parse(formula, coder);
            ((List)pair.p2).forEach(fp -> {
                if (fp instanceof IFormatParam) {
                    formulaParam.addAll(((IFormatParam)fp).formatParam());
                }
            });
        }
        catch (Exception pair) {
            // empty catch block
        }
        String templateNum = formulaParam.get(5).toString().replaceAll("\"", "");
        Map<String, Object> commParam = this.collectCommonParams();
        long modelId = (Long)commParam.get("model");
        QFBuilder builder = new QFBuilder("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)templateNum);
        builder.add("templatetype", "not in", (Object)Lists.newArrayList((Object[])new String[]{TemplateTypeEnum.MSN.getType() + "", TemplateTypeEnum.OTHERWP.getType() + ""}));
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_templateentity", (String)"id,number,name", (QFilter[])builder.toArray());
        String name = null;
        Long templateId = null;
        if (template != null) {
            name = template.getString("number") + "|" + template.getString("name");
            templateId = template.getLong("id");
        }
        RowData row = new RowData(value, null, formula, name, templateId);
        rowData.add(row);
    }

    private void fillData2EntryEntity(List<RowData> rowData) {
        IDataModel dataModel = this.getModel();
        int rowCount = rowData.size();
        this.getModel().batchCreateNewEntryRow(KEY_FORMULALIST, rowCount);
        for (int i = 0; i < rowCount; ++i) {
            dataModel.setEntryCurrentRowIndex(KEY_FORMULALIST, i);
            RowData row = rowData.get(i);
            dataModel.setValue("value", (Object)row.getValue(), i);
            if (row.getComputeOprt() != null) {
                dataModel.setValue("computeoprt", (Object)row.getComputeOprt(), i);
            }
            dataModel.setValue("detail", (Object)row.getDetail(), i);
            dataModel.setValue("template", (Object)row.getTemplate(), i);
            dataModel.setValue("templateid", (Object)row.getTemplateId(), i);
        }
    }

    private Boolean isCheckDetail() {
        Map linkType;
        Boolean fromCheckDetail = false;
        if (this.getView().getFormShowParameter().getCustomParam("ids") != null && "checkDetail".equals((linkType = (Map)this.getView().getFormShowParameter().getCustomParam("ids")).get("linkType"))) {
            fromCheckDetail = true;
        }
        return fromCheckDetail;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(KEY_BTNOK)) {
            if (this.getView().getPageCache().get("isMiddleLib") != null && Boolean.parseBoolean(this.getView().getPageCache().get("isMiddleLib")) && StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get(COMM_FORMULA))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4fe1\u606f\u6682\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"FormulaList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
            int[] rowSelect = entryGrid.getSelectRows();
            if (rowSelect.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u660e\u7ec6\u4fe1\u606f\u3002", (String)"FormulaList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.supportNewLink) {
                this.openLinkQuery(rowSelect);
            } else {
                String itemKey = (String)this.getView().getFormShowParameter().getCustomParam("itemKey");
                if (StringUtils.isEmpty((CharSequence)itemKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8054\u67e5\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"FormulaList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (int i : rowSelect) {
                    this.openLinkQuery(i);
                }
            }
        } else if (control.getKey().equals(KEY_BTNCANCEL)) {
            this.getView().close();
        }
    }

    private void openLinkQuery(int[] rowSelect) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
        HashMap<String, PairList> formulaMap = new HashMap<String, PairList>(16);
        for (int i : rowSelect) {
            String formulaStr = entryGrid.getModel().getValue("detail", i).toString();
            if (this.isCheckDetail().booleanValue()) {
                formulaStr = "V" + formulaStr;
            }
            Long templateId = (Long)entryGrid.getModel().getValue("templateid", i);
            if (formulaStr.contains("@")) continue;
            List lstFormula = FormulaAnalyze.analyticFun((String)formulaStr);
            if (!lstFormula.isEmpty()) {
                FunctionExpr expr = (FunctionExpr)lstFormula.get(0);
                if (!(!expr.getFuncionName().equalsIgnoreCase("V") && !expr.getFuncionName().equalsIgnoreCase("REF") || templateId != null && templateId != 0L)) continue;
                formulaMap.computeIfAbsent(expr.getFuncionName().toUpperCase(), k -> new PairList());
                PairList formulas = (PairList)formulaMap.get(expr.getFuncionName());
                formulas.addPair((Object)formulaStr, (Object)templateId);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)(formulaStr = TransFormulaUtil.transGLGroup2Acct((String)formulaStr)))) continue;
            formulaMap.computeIfAbsent("ACCT", k -> new PairList());
            PairList formulas = (PairList)formulaMap.get("ACCT");
            formulas.addPair((Object)formulaStr, (Object)templateId);
        }
        if (!formulaMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(COMM_FORMULA))) {
            Collection formulas = formulaMap.values();
            for (PairList pairs : formulas) {
                String formula = (String)pairs.getPair((int)0).p1;
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormula((String)formula);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bcm_formulapreview");
                formShowParameter.setCustomParam("PREVIEW_FORMULA", (Object)ObjectSerialUtil.toByteSerialized((Object)formulaVo.toFetchDataString()));
                formShowParameter.setCustomParam("isSingleFormula", (Object)formulaVo.isSingleFormula());
                formShowParameter.setCustomParam("returnField", (Object)String.join((CharSequence)",", formulaVo.getReturnFields()));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            }
            return;
        }
        if (!this.isCheckDetail().booleanValue() && !this.isAllowVLink() && (formulaMap.containsKey("V") || formulaMap.containsKey("REF"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"V\u516c\u5f0f\u3001REF\u516c\u5f0f\u4e0d\u652f\u6301\u8fdb\u4e00\u6b65\u8054\u67e5\uff0c\u5982\u9700\u67e5\u770b\u6570\u636e\u6765\u6e90\u8bf7\u5728\u62a5\u8868\u7f16\u5236\u6216\u62a5\u8868\u67e5\u8be2\u83dc\u5355\u4e0b\u6253\u5f00\u5bf9\u5e94\u7684\u62a5\u8868\u3002", (String)"FormulaList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (formulaMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4fe1\u606f\u6682\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"FormulaList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> commParam = this.collectCommonParams();
        ArrayList allParameters = new ArrayList();
        ArrayList mapList = new ArrayList();
        formulaMap.forEach((k, v) -> {
            List parameters = LinkFormulaUtil.getLinkPageParam((String)k, (PairList)v, (Map)commParam);
            if (!parameters.isEmpty()) {
                if (parameters.get(0) instanceof FormShowParameter) {
                    allParameters.addAll(parameters);
                } else if (parameters.get(0) instanceof Map) {
                    mapList.addAll(parameters);
                }
            }
        });
        if (allParameters.isEmpty() && mapList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4fe1\u606f\u6682\u4e0d\u652f\u6301\u8054\u67e5\u3002", (String)"FormulaList_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            for (FormShowParameter e : allParameters) {
                IFormView parentView = this.getView().getParentView();
                parentView.showForm(e);
                this.getView().sendFormAction(parentView);
            }
            boolean isEntityTab = (Boolean)this.getView().getFormShowParameter().getCustomParam("isEntityTab");
            for (Map e : mapList) {
                FormulaLinkShowForm showForm = new FormulaLinkShowForm(this.getView(), e, isEntityTab);
                showForm.showForm();
            }
        }
    }

    private void openLinkQuery(int rowSelect) {
        String formulaType;
        Map param;
        String[] flexProp;
        String number;
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FORMULALIST);
        String formulaStr = entryGrid.getModel().getValue("detail", rowSelect).toString();
        String itemKey = (String)this.getView().getFormShowParameter().getCustomParam("itemKey");
        List lstFormula = FormulaAnalyze.analyticFun((String)formulaStr);
        FunctionExpr expr = (FunctionExpr)lstFormula.get(0);
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)expr.getFuncionName().toLowerCase(Locale.ENGLISH));
        int size = formula.getParam().size() - ((FunctionExpr)lstFormula.get(0)).getParameters().size();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                ((FunctionExpr)lstFormula.get(0)).getParameters().add("");
            }
        }
        if ((number = (flexProp = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)(param = FormulaAnalyze.generalledgerQueryParams((List)formula.getParam(), (List)((FunctionExpr)lstFormula.get(0)).getParameters())).get(formulaType = formulaStr.startsWith("ACCTCF") ? "cashflow" : "account").toString()))[0]).contains("[")) {
            String tempStr = number.trim().substring(1, number.length() - 1);
            if (tempStr.contains(",")) {
                String[] split = tempStr.split(",");
                for (int j = 0; j < split.length; ++j) {
                    this.accountIds.add(Long.parseLong(split[j].trim()));
                }
            } else {
                this.accountIds.add(Long.parseLong(tempStr));
            }
        } else if (number.contains(",")) {
            String[] numberList;
            for (String s : numberList = number.trim().split(",")) {
                this.accountIds.add(Long.parseLong(s));
            }
        } else if (formulaType.equals("account")) {
            this.accountIds.add(Long.parseLong(number.trim()));
        }
        String formId = this.getFormId(itemKey, flexProp);
        if ("linkcashflow".equals(itemKey)) {
            if (formulaStr.startsWith("ACCTCF")) {
                new LinkQueryShowForm(this.getView(), formId, param).getCashflowReportShowParameter(false);
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662facctcf\u516c\u5f0f\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u73b0\u91d1\u6d41\u91cf\u8868\u3002", (String)"FormulaList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (formulaStr.startsWith("ACCTCF")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662facct\u516c\u5f0f\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u603b\u8d26\u3001\u660e\u7ec6\u8d26\u548c\u51ed\u8bc1\u3002", (String)"FormulaList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (formId.equals("gl_voucher")) {
            new LinkQueryShowForm(this.getView(), formId, param).sendFormAction();
        } else {
            new LinkQueryShowForm(this.getView(), formId, param, true, this.accountIds).sendFormAction();
        }
    }

    private String getFormId(String itemKey, String[] flexProp) {
        switch (itemKey) {
            case "linkgl": {
                if (flexProp.length > 1) {
                    return "gl_assisttotal";
                }
                return "gl_rpt_generalledger";
            }
            case "linkdetailaccount": {
                if (flexProp.length > 1) {
                    return "gl_rpt_subsidiaryledger";
                }
                return "gl_rpt_subledger";
            }
            case "linkvoucher": {
                return "gl_voucher";
            }
            case "linkcashflow": {
                return "gl_rpt_cashflow";
            }
        }
        return "";
    }

    private String getGLMember(String dimNum, String memberNum) {
        Long modelId = (Long)((Map)this.getView().getFormShowParameter().getCustomParam("ids")).get("model");
        QFilter modQ = new QFilter("model", "=", (Object)modelId);
        QFilter[] qs = new QFilter[]{modQ};
        DynamicObjectCollection memberDims = QueryServiceHelper.query((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.number, bcmmember, assttype, asstmember, model", (QFilter[])qs);
        for (DynamicObject memberDim : memberDims) {
            if (!memberDim.getString("bcmdim.number").equals(dimNum) || !memberDim.getString("bcmmember").equals(memberNum)) continue;
            return memberDim.getString("asstmember");
        }
        return memberNum;
    }

    private boolean isAllowVLink() {
        Map<String, Object> commParam = this.collectCommonParams();
        long modelId = (Long)commParam.get("model");
        return ConfigServiceHelper.getBoolParam((Long)modelId, (String)ConfigEnum.IS_ALLOW_LINKREPORT.getNumber());
    }

    private static class RowData {
        private final String value;
        private final String computeOprt;
        private final String detail;
        private final String template;
        private final Long templateId;

        public RowData(String value, String computeOprt, String detail, String template, Long templateId) {
            this.value = FormulaList.formatNumberWithThousandsSeparator(value);
            this.computeOprt = computeOprt;
            this.detail = detail;
            this.template = template;
            this.templateId = templateId;
        }

        public String getValue() {
            return this.value;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getTemplate() {
            return this.template;
        }

        public Long getTemplateId() {
            return this.templateId;
        }

        public String getComputeOprt() {
            return this.computeOprt;
        }
    }
}

