/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.formula.calculate.XGetColSum;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.script.XdmExpressionGenerator;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.lang.StringUtils;

public class GetColSumFormulaPlugin
extends AbstractBaseFormPlugin
implements MainPage {
    public static final String EXTENDS_MODEL = "extendsmodel";
    public static final String EXTENDS_FIELD = "extendsfield";
    public static final String SCENARIO = "scenario";
    public static final String YEAR = "year";
    public static final String PERIOD = "period";
    public static final String ENTITY = "entity";
    public static final String CURRENCY = "currency";
    public static final String PROCESS = "process";
    public static final String AUDIT_TRAIL = "audittrail";
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String MD_FILED_PANEL = "mdfieldpanel";
    public static final List<String> TEXT_FIELD_VALUES = Arrays.asList("5", "6", "7", "8");
    private static String EXT_FIELDS = "EXT_FIELDS";
    private static String DIM_FIELDS = "DIM_FIELDS";
    public static final List<String> CLEAR_FILED = Arrays.asList("extendsfield", "scenario", "year", "period", "entity", "currency", "process", "audittrail");
    public static final List<String> CTX_DIM = Arrays.asList(SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Process.getNumber(), SysDimensionEnum.AuditTrail.getNumber());

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(Arrays.asList(YEAR, PERIOD, SCENARIO, CURRENCY), SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(Arrays.asList(ENTITY, PROCESS, AUDIT_TRAIL), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String formula = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<String, List<Map<String, String>>> dimScopes = new HashMap<String, List<Map<String, String>>>(16);
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        ArrayList extScopes = new ArrayList(10);
        if (StringUtils.isNotEmpty((String)formula)) {
            Pair pair;
            ExpressParser parser = new ExpressParser();
            try {
                pair = parser.parse(formula, new EncoderService());
            }
            catch (Exception ex) {
                log.error("xgetcolsum:" + formula);
                return;
            }
            ArrayList formulas = new ArrayList((Collection)pair.p2);
            for (IFormula iformula : formulas) {
                if (!(iformula instanceof XGetColSum)) continue;
                ParamList paramList = iformula.getParamList();
                if (paramList.size() > 8 && paramList.size() < 12) {
                    IntStream.range(0, paramList.size()).forEach(index -> {
                        String param = ((ParamItem)paramList.get(index)).toString().trim();
                        String[] splits = param.split("[.@]", 2);
                        switch (index) {
                            case 0: {
                                QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)param).add("model.id", "=", (Object)this.getModelId());
                                DynamicObjectCollection model = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,name", (QFilter[])qfBuilder.toArray());
                                if (model.size() != 0) {
                                    this.getModel().setValue(EXTENDS_MODEL, (Object)((DynamicObject)model.get(0)).getLong("id"));
                                    ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(((DynamicObject)model.get(0)).getLong("id")));
                                    this.getPageCache().put(EXT_FIELDS, this.toByteSerialized(extendsModel.getExtFieldEntry()));
                                    this.getPageCache().put(DIM_FIELDS, this.toByteSerialized(extendsModel.getDimFieldEntry()));
                                    break;
                                }
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"GetColSumFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            case 1: {
                                IDNumberTreeNode extNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)param);
                                if (extNode != IDNumberTreeNode.NotFoundTreeNode) {
                                    this.getModel().setValue(EXTENDS_FIELD, (Object)extNode.getId());
                                    break;
                                }
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"GetColSumFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                                break;
                            }
                            case 2: {
                                IDNumberTreeNode scenarioNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.SCENARIO.getNumber(), (String)splits[splits.length - 1]);
                                if (scenarioNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(SCENARIO, (Object)scenarioNode.getId());
                                break;
                            }
                            case 3: {
                                IDNumberTreeNode yearNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.YEAR.getNumber(), (String)splits[splits.length - 1]);
                                if (yearNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(YEAR, (Object)yearNode.getId());
                                break;
                            }
                            case 4: {
                                IDNumberTreeNode periodNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.PERIOD.getNumber(), (String)splits[splits.length - 1]);
                                if (periodNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(PERIOD, (Object)periodNode.getId());
                                break;
                            }
                            case 5: {
                                IDNumberTreeNode entityNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.ENTITY.getNumber(), (String)splits[splits.length - 1]);
                                if (entityNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(ENTITY, (Object)entityNode.getId());
                                break;
                            }
                            case 6: {
                                IDNumberTreeNode currencyNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.CURRENCY.getNumber(), (String)splits[splits.length - 1]);
                                if (currencyNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(CURRENCY, (Object)currencyNode.getId());
                                break;
                            }
                            case 7: {
                                IDNumberTreeNode processNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.PROCESS.getNumber(), (String)splits[splits.length - 1]);
                                if (processNode == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(PROCESS, (Object)processNode.getId());
                                break;
                            }
                            case 8: {
                                IDNumberTreeNode auditTrialNode;
                                String member = splits[splits.length - 1];
                                member = member.replace("\"", "");
                                if (!StringUtils.isNotEmpty((String)member) || (auditTrialNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)member)) == IDNumberTreeNode.NotFoundTreeNode) break;
                                this.getModel().setValue(AUDIT_TRAIL, (Object)auditTrialNode.getId());
                                break;
                            }
                            case 9: {
                                String[] scopes;
                                String inScopeStr = param;
                                Map map = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
                                inScopeStr = inScopeStr.trim().replace("),", ")|").replace("],", "]|");
                                for (String scope : scopes = inScopeStr.split("\\|")) {
                                    if (scope.contains("[") && scope.contains("]")) {
                                        int start = scope.indexOf("[");
                                        int end = scope.indexOf("]");
                                        int range = 10;
                                        String dim = scope.substring(0, start).trim();
                                        if (end == scope.length() - 1) {
                                            range = RangeEnum.VALUE_10.getValue();
                                        } else {
                                            String rangeName = scope.substring(end + 1);
                                            RangeEnum rangeByNumber = RangeEnum.getRangeByNumber((String)(rangeName = rangeName.substring(rangeName.indexOf(".") + 1, rangeName.indexOf("("))));
                                            if (rangeByNumber != null) {
                                                range = rangeByNumber.getValue();
                                            }
                                        }
                                        if (!map.containsKey(dim) && !map.containsValue(dim)) continue;
                                        if (map.containsKey(dim)) {
                                            dim = (String)map.get(dim);
                                        }
                                        String mem = scope.substring(start + 1, end).trim();
                                        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dim, (String)mem);
                                        dimScopes.putIfAbsent(dim, new ArrayList(10));
                                        HashMap<String, String> memScope = new HashMap<String, String>(8);
                                        memScope.put("id", node.getId().toString());
                                        memScope.put("scope", String.valueOf(range));
                                        memScope.put("number", node.getNumber());
                                        memScope.put("name", node.getName());
                                        memScope.put("pid", "");
                                        ((List)dimScopes.get(dim)).add(memScope);
                                        continue;
                                    }
                                    if (!scope.contains(".") || !scope.contains("(") || !scope.contains(")")) continue;
                                    String[] exts = scope.split("\\.", 2);
                                    String extNum = exts[0].trim();
                                    String input = exts[1].substring(0, exts[1].indexOf("("));
                                    ParamConstant.MethodEnum methodEnum = ParamConstant.MethodEnum.getInMethodEnumByInput((String)input);
                                    if (methodEnum == null) {
                                        return;
                                    }
                                    String value = null;
                                    String trim = exts[1].substring(exts[1].indexOf("(") + 1, exts[1].indexOf(")")).trim();
                                    if (trim.length() > 0) {
                                        value = trim;
                                    }
                                    extScopes.add(Tuple.create((Object)extNum, (Object)methodEnum.getCode(), (Object)value));
                                }
                                break;
                            }
                            case 10: {
                                String[] noScopes = param.replace("),", ")|").split("\\|");
                                if (!param.contains(".") || !param.contains("(") || !param.contains(")")) break;
                                for (String scope : noScopes) {
                                    String[] exts = scope.split("\\.", 2);
                                    String extNum = exts[0].trim();
                                    String input = exts[1].substring(0, exts[1].indexOf("("));
                                    ParamConstant.MethodEnum methodEnum = ParamConstant.MethodEnum.getExceptMethodEnumByInput((String)input);
                                    if (methodEnum == null) {
                                        return;
                                    }
                                    String value = null;
                                    String trim = exts[1].substring(exts[1].indexOf("(") + 1, exts[1].indexOf(")")).trim();
                                    if (trim.length() > 0) {
                                        value = trim;
                                    }
                                    extScopes.add(Tuple.create((Object)extNum, (Object)methodEnum.getCode(), (Object)value));
                                }
                                break;
                            }
                        }
                    });
                    continue;
                }
                return;
            }
            if (extScopes.size() > 0) {
                int row = 0;
                for (Tuple extScope : extScopes) {
                    DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
                    IDNumberTreeNode extNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)((String)extScope.p1));
                    newDynamicObject.set("id", (Object)extNode.getId());
                    newDynamicObject.set("name", (Object)extNode.getName());
                    newDynamicObject.set("number", (Object)extNode.getNumber());
                    DynamicObject dynamicObject = entryEntity.addNew();
                    dynamicObject.set("entryextendsfield", (Object)newDynamicObject);
                    dynamicObject.set("method", extScope.p2);
                    boolean isEmptyOrNotEmpty = ((String)extScope.p2).equals(ParamConstant.MethodEnum.IS_EMPTY.getCode()) || ((String)extScope.p2).equals(ParamConstant.MethodEnum.IS_NOT_EMPTY.getCode());
                    dynamicObject.set("conditionvalue", isEmptyOrNotEmpty ? "" : extScope.p3);
                    if (isEmptyOrNotEmpty) {
                        this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"conditionvalue"});
                    }
                    ++row;
                }
            }
        }
        this.refreshArea(dimScopes);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_add".equals(itemKey)) {
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bos_listf7");
            param.setBillFormId("bcm_structofextend");
            ListFilterParameter listFilter = new ListFilterParameter();
            param.setListFilterParameter(listFilter);
            listFilter.setFilter(this.getQFilter());
            param.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            param.setShowApproved(true);
            param.setShowUsed(true);
            param.setLookUp(true);
            param.setShowFilter(false);
            param.setShowQuickFilter(false);
            param.setShowTitle(false);
            param.setMultiSelect(true);
            param.getOpenStyle().setInlineStyleCss(css);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addRows"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7Listener(ParamConstant.CONTEXT_DIMENSIONS);
        this.addBeforeF7Listener(ParamConstant.EXTEND_DIMENSIONS);
        this.addItemClickListeners("advcontoolbarap");
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        List fieldEdits = entryentity.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            if (!(fieldEdit instanceof BasedataEdit) || !StringUtils.equals((String)fieldEdit.getFieldKey(), (String)"entryextendsfield")) continue;
            BasedataEdit entryExtendsField = (BasedataEdit)fieldEdit;
            entryExtendsField.setQFilter(this.getQFilter());
        }
        this.addClickListeners("confirm");
    }

    protected void addBeforeF7Listener(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit control = (BasedataEdit)this.getControl(f7Key);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            if (this.getModel().getValue(EXTENDS_MODEL) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"GetColSumFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.getModel().getValue(EXTENDS_FIELD) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CheckExtendsFormulaFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection conditions = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject condition : conditions) {
                if (condition.get("entryextendsfield") == null || condition.get("method") == null || StringUtils.isEmpty((String)condition.getString("conditionvalue")) && !condition.getString("method").equals(ParamConstant.MethodEnum.IS_EMPTY.getCode()) && !condition.getString("method").equals(ParamConstant.MethodEnum.IS_NOT_EMPTY.getCode())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\u8303\u56f4\u8bbe\u7f6e\u6bcf\u884c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u586b\u5165\u6216\u8005\u5220\u9664\u884c\u3002", (String)"CheckExtendsFormulaFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!((DynamicObject)condition.get("entryextendsfield")).getString("dataType").equals(DataTypeEnum.TXT.getOIndex()) || !TEXT_FIELD_VALUES.contains(condition.get("method").toString())) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u5b57\u6bb5\u201c%s\u201d\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\uff0c\u5224\u65ad\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u201c\u5927\u4e8e\u201d\u3001\u201c\u5927\u4e8e\u7b49\u4e8e\u201d\u3001\u201c\u5c0f\u4e8e\u201d\u3001\u201c\u5c0f\u4e8e\u7b49\u4e8e\u201d\u3002", (String)"CheckExtendsFormulaFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)condition.get("entryextendsfield")).getString("name")));
                evt.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            CommandParam com = new CommandParam("bcm_getcolsumformula", "bcm_getcolsumpanel", "getDimScope", new Object[0]);
            this.sendMsg(this.getView(), com);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        String name = beforeF7SelectEvent.getProperty().getName();
        if (EXTENDS_MODEL.equals(name)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("enable", "=", (Object)"1"));
        } else if (EXTENDS_FIELD.equals(name)) {
            if (Objects.isNull(this.getModel().getValue(EXTENDS_MODEL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"CheckExtendsFormulaFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter qFilter = this.getQFilter();
                beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            }
        } else if (CURRENCY.equals(name)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("number", "not in", (Object)new String[]{"EC", "PC", "DC"}));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (EXTENDS_MODEL.equals(key)) {
            ChangeData changeSet = e.getChangeSet()[0];
            Object oldValue = changeSet.getOldValue();
            Object newValue = changeSet.getNewValue();
            if (newValue == null) {
                this.getModel().setValue(EXTENDS_MODEL, oldValue);
            } else {
                for (String fieldKey : CLEAR_FILED) {
                    this.getModel().setValue(fieldKey, null);
                }
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(((DynamicObject)newValue).getLong("id")));
                this.getPageCache().put(EXT_FIELDS, this.toByteSerialized(extendsModel.getExtFieldEntry()));
                this.getPageCache().put(DIM_FIELDS, this.toByteSerialized(extendsModel.getDimFieldEntry()));
                this.refreshArea(Collections.emptyMap());
            }
        }
    }

    private void refreshArea(Map<String, List<Map<String, String>>> dimScope) {
        if (this.getModel().getValue(EXTENDS_MODEL) != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(MD_FILED_PANEL);
            formShowParameter.setFormId("bcm_getcolsumpanel");
            String childCache = this.getPageIdAndCache(this.getPageCache(), "bcm_getcolsumpanel");
            formShowParameter.setPageId(childCache);
            formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            formShowParameter.setCustomParam("extModelId", (Object)((DynamicObject)this.getModel().getValue(EXTENDS_MODEL)).getLong("id"));
            if (!dimScope.isEmpty()) {
                formShowParameter.setCustomParam("dimScope", (Object)this.toByteSerialized(dimScope));
            }
            this.getPageCache().put("dyn_child_page_id", childCache);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection lsc;
        List ids;
        String key = closedCallBackEvent.getActionId();
        if ("addRows".equals(key) && closedCallBackEvent.getReturnData() != null && !(ids = DynamicObjectCollectionUtil.getMultiF7DyIds((ListSelectedRowCollection)(lsc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))).isEmpty()) {
            this.getModel().beginInit();
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, ids.size());
            IntStream.range(0, ids.size()).forEach(index -> this.getModel().setValue("entryextendsfield", ids.get(index), rows[index]));
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("sendDimScope".equals(operation)) {
            Map res = (Map)com.getParam().get(0);
            DynamicObject extendsModel = (DynamicObject)this.getModel().getValue(EXTENDS_MODEL);
            String extModelNum = extendsModel.getString("number");
            DynamicObject extendsFieldModel = (DynamicObject)this.getModel().getValue(EXTENDS_FIELD);
            String extFieldNum = extendsFieldModel.getString("number");
            DynamicObjectCollection conditions = this.getModel().getEntryEntity(ENTRY_ENTITY);
            StringJoiner inScopeCondition = new StringJoiner(",");
            StringJoiner exceptScopeCondition = new StringJoiner(",");
            ArrayList<String> entryConditions = new ArrayList<String>();
            conditions.forEach(condition -> {
                String entryExtFieldNum = ((DynamicObject)condition.get("entryextendsfield")).getString("number");
                String method = condition.getString("method");
                String conditionValue = condition.getString("conditionvalue");
                entryConditions.add(String.format("%s@@%s@@%s", entryExtFieldNum, method, conditionValue));
                ParamConstant.MethodEnum methodEnum = ParamConstant.MethodEnum.getByCode((String)method);
                if (methodEnum != null) {
                    this.generateScopeCondition(entryExtFieldNum, methodEnum, conditionValue, inScopeCondition, exceptScopeCondition);
                }
            });
            for (Map.Entry entry : res.entrySet()) {
                List list = (List)entry.getValue();
                for (Map map : list) {
                    String scope = (String)map.get("scope");
                    String number = (String)map.get("number");
                    RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)Integer.parseInt(scope));
                    if (rangeEnum == RangeEnum.VALUE_10) {
                        inScopeCondition.add(String.format("%s['%s']", entry.getKey(), number));
                        continue;
                    }
                    inScopeCondition.add(String.format("%s['%s'].%s", entry.getKey(), number, BizRuleUtil.getFunctionNameByScope((int)rangeEnum.getValue())));
                }
            }
            boolean isRelaProcess = OrgRelaProcessMembPool.isRelaProcess((String)((String)this.getPropertyValue(PROCESS, "number")));
            for (int i = 0; i < ParamConstant.CONTEXT_DIMENSIONS_ENUM.length; ++i) {
                DimTypesEnum dimTypesEnum = ParamConstant.CONTEXT_DIMENSIONS_ENUM[i];
                if (dimTypesEnum == DimTypesEnum.ENTITY && isRelaProcess) {
                    Long orgId = (Long)this.getPropertyValue(ParamConstant.CONTEXT_DIMENSIONS[i], "id");
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId);
                    if (node != IDNumberTreeNode.NotFoundTreeNode) {
                        inScopeCondition.add(String.format("%s['%s']", dimTypesEnum.getNumber(), node.getVirtualEntity()));
                        continue;
                    }
                    inScopeCondition.add(String.format("%s['%s']", dimTypesEnum.getNumber(), null));
                    continue;
                }
                Object number = this.getPropertyValue(ParamConstant.CONTEXT_DIMENSIONS[i], "number");
                inScopeCondition.add(String.format("%s['%s']", dimTypesEnum.getNumber(), number));
            }
            CommonFormulaModel scopeBuilder = new CommonFormulaModel();
            XdmExpressionGenerator.appendXdmModel((CommonFormulaModel)scopeBuilder, (String)extModelNum);
            XdmExpressionGenerator.appendMethod((CommonFormulaModel)scopeBuilder, (String)"XDMScope", (String)inScopeCondition.toString());
            if (exceptScopeCondition.length() > 0) {
                XdmExpressionGenerator.appendMethod((CommonFormulaModel)scopeBuilder, (String)"except", (String)exceptScopeCondition.toString());
            }
            CommonFormulaModel scriptBuilder = this.createXdmScriptBuilder(extModelNum, extFieldNum, this.getMDFields(), scopeBuilder, res, entryConditions);
            StringJoiner stringJoiner = new StringJoiner("!");
            StringBuilder builder = (StringBuilder)scriptBuilder.getCondition("stringBuilder");
            scriptBuilder.addCondition("extendsFormula", (Object)builder.toString());
            this.getView().returnDataToParent(this.getReturnFormulaData(scriptBuilder));
            this.getView().close();
        }
    }

    private CommonFormulaModel createXdmScriptBuilder(String extModelNum, String extFieldNum, Collection<String> extendMdFields, CommonFormulaModel scopeBuilder, Map<String, List<Map<String, String>>> res, List<String> entryConditions) {
        IDNumberTreeNode entityNode;
        CommonFormulaModel xdmFormulaBuilder = new CommonFormulaModel();
        xdmFormulaBuilder.addDim(DimTypesEnum.SCENARIO.getNumber(), (String)this.getPropertyValue(SCENARIO, "number"));
        xdmFormulaBuilder.addDim(DimTypesEnum.YEAR.getNumber(), (String)this.getPropertyValue(YEAR, "number"));
        xdmFormulaBuilder.addDim(DimTypesEnum.PERIOD.getNumber(), (String)this.getPropertyValue(PERIOD, "number"));
        if (this.getPropertyValue(ENTITY, "id") != null && (entityNode = MemberReader.findEntityMemberById((String)this.getCurModelNumber(), (Long)((Long)this.getPropertyValue(ENTITY, "id")))) != IDNumberTreeNode.NotFoundTreeNode) {
            xdmFormulaBuilder.addDim(DimTypesEnum.ENTITY.getNumber(), entityNode.getVirtualEntity());
        }
        xdmFormulaBuilder.addDim(DimTypesEnum.AUDITTRIAL.getNumber(), (String)this.getPropertyValue(AUDIT_TRAIL, "number"));
        xdmFormulaBuilder.addDim(DimTypesEnum.CURRENCY.getNumber(), (String)this.getPropertyValue(CURRENCY, "number"));
        xdmFormulaBuilder.addDim(DimTypesEnum.PROCESS.getNumber(), (String)this.getPropertyValue(PROCESS, "number"));
        xdmFormulaBuilder.addCondition(EXTENDS_MODEL, this.getPropertyValue(EXTENDS_MODEL, "number"));
        xdmFormulaBuilder.addCondition(EXTENDS_FIELD, this.getPropertyValue(EXTENDS_FIELD, "number"));
        xdmFormulaBuilder.addCondition("extendsmdfield", extendMdFields);
        XdmExpressionGenerator.appendXdmModel((CommonFormulaModel)xdmFormulaBuilder, (String)extModelNum);
        XdmExpressionGenerator.appendMethod((CommonFormulaModel)xdmFormulaBuilder, (String)"getColSum", (String)String.format("'%s',%s", extFieldNum, XdmExpressionGenerator.generateFormulaExpression((CommonFormulaModel)scopeBuilder)));
        for (Map.Entry<String, List<Map<String, String>>> entry : res.entrySet()) {
            String sign = this.buildF7Sign(MD_FILED_PANEL, entry.getKey());
            Tuple mdFieldTuple = Tuple.create((Object)sign, (Object)"", (Object)SerializationUtils.toJsonString(entry.getValue()));
            ArrayList<Tuple> extendsMdFieldsValue = (ArrayList<Tuple>)xdmFormulaBuilder.getCondition("extendsmdfieldvalue");
            if (extendsMdFieldsValue == null) {
                extendsMdFieldsValue = new ArrayList<Tuple>();
                xdmFormulaBuilder.addCondition("extendsmdfieldvalue", extendsMdFieldsValue);
            }
            extendsMdFieldsValue.add(mdFieldTuple);
        }
        xdmFormulaBuilder.addCondition("entryconditions", entryConditions);
        return xdmFormulaBuilder;
    }

    private void generateScopeCondition(String entryExtFieldNum, ParamConstant.MethodEnum methodEnum, String conditionValue, StringJoiner inScopeCondition, StringJoiner exceptScopeCondition) {
        String expression = this.formatMethodExpression(entryExtFieldNum, methodEnum, conditionValue, "'", "'");
        switch (methodEnum) {
            case INCLUDE: 
            case LESS_THAN: 
            case GREATER_THAN: {
                inScopeCondition.add(expression);
                break;
            }
            case LIKE: {
                inScopeCondition.add(this.formatMethodExpression(entryExtFieldNum, methodEnum, conditionValue, "'%", "%'"));
                break;
            }
            case NOT_INCLUDE: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN_EQUAL: {
                exceptScopeCondition.add(expression);
                break;
            }
            case NOT_LIKE: {
                exceptScopeCondition.add(this.formatMethodExpression(entryExtFieldNum, methodEnum, conditionValue, "'%", "%'"));
                break;
            }
            case IS_NOT_EMPTY: 
            case IS_EMPTY: {
                inScopeCondition.add(String.format(methodEnum.getExpression(), entryExtFieldNum));
                break;
            }
        }
    }

    private String formatMethodExpression(String entryExtFieldNum, ParamConstant.MethodEnum methodEnum, String conditionValue, String prefix, String suffix) {
        return String.format(methodEnum.getExpression(), entryExtFieldNum, prefix + conditionValue + suffix);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.validExtendModel();
        super.beforeDoOperation(args);
    }

    private void validExtendModel() {
        if (Objects.isNull(this.getModel().getValue(EXTENDS_MODEL))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"GetColSumFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<String> getMDFields() {
        return this.getDimFields().stream().map(field -> field.getDimension().getNumber()).collect(Collectors.toList());
    }

    private Object getReturnFormulaData(CommonFormulaModel scriptBuilder) {
        Object extCondition;
        StringBuilder stringBuilder = new StringBuilder("XGETCOLSUM(");
        StringJoiner sj = new StringJoiner(",");
        sj.add("\"" + scriptBuilder.getCondition(EXTENDS_MODEL) + "\"");
        sj.add("\"" + scriptBuilder.getCondition(EXTENDS_FIELD) + "\"");
        HashMap toShortMap = new HashMap(8);
        HashMap lowerToNumMap = new HashMap(8);
        MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.getModelId())).forEach((key, val) -> {
            toShortMap.put(val, key);
            lowerToNumMap.put(val.toLowerCase(), val);
        });
        for (String dim : CTX_DIM) {
            String value = scriptBuilder.getDim(dim);
            if (SysDimensionEnum.Entity.getNumber().equals(dim) && value.contains("_")) {
                value = value.split("_", 2)[1];
            }
            if (StringUtils.isNotEmpty((String)value)) {
                sj.add("\"" + (String)toShortMap.get(dim) + "." + value + "\"");
                continue;
            }
            sj.add("\"\"");
        }
        StringJoiner scopeSj = new StringJoiner(",");
        StringJoiner noScopeSj = new StringJoiner(",");
        Object mdCondition = scriptBuilder.getCondition("extendsmdfieldvalue");
        if (mdCondition instanceof List) {
            List list = (List)mdCondition;
            for (Tuple tuple : list) {
                String lowerDimStr;
                String dimStr;
                if (!StringUtils.isNotEmpty((String)((String)tuple.p3)) || (dimStr = (String)lowerToNumMap.get(lowerDimStr = ((String)tuple.p1).substring(12))) == null) continue;
                String shortNum = (String)toShortMap.get(dimStr);
                List scopes = (List)SerializationUtils.fromJsonString((String)((String)tuple.p3), List.class);
                for (Map scope : scopes) {
                    StringBuilder temp = new StringBuilder(shortNum);
                    temp.append("[");
                    temp.append((String)scope.get("number"));
                    temp.append("]");
                    RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)Integer.parseInt((String)scope.get("scope")));
                    if (rangeEnum != null && rangeEnum != RangeEnum.VALUE_10) {
                        temp.append(".").append(rangeEnum.getNumber()).append("()");
                    }
                    scopeSj.add(temp);
                }
            }
        }
        if ((extCondition = scriptBuilder.getCondition("entryconditions")) instanceof List) {
            List conditions = (List)extCondition;
            for (String condition : conditions) {
                String ext;
                String[] splits = condition.split("@@");
                if (splits.length == 2) {
                    ext = splits[0];
                    ParamConstant.MethodEnum method = ParamConstant.MethodEnum.getByCode((String)splits[1]);
                    if (method == null) continue;
                    scopeSj.add(String.format(method.getExpression(), ext));
                    continue;
                }
                if (splits.length != 3) continue;
                ext = splits[0];
                String val2 = splits[2];
                ParamConstant.MethodEnum method = ParamConstant.MethodEnum.getByCode((String)splits[1]);
                if (method == null) continue;
                if (method == ParamConstant.MethodEnum.NOT_INCLUDE || method == ParamConstant.MethodEnum.GREATER_THAN_EQUAL || method == ParamConstant.MethodEnum.LESS_THAN_EQUAL || method == ParamConstant.MethodEnum.NOT_LIKE) {
                    noScopeSj.add(String.format(method.getExpression(), ext, val2));
                    continue;
                }
                scopeSj.add(String.format(method.getExpression(), ext, val2));
            }
        }
        stringBuilder.append(sj);
        if (scopeSj.length() != 0) {
            stringBuilder.append(",\"").append(scopeSj).append("\"");
        }
        if (noScopeSj.length() > 0) {
            if (StringUtils.isEmpty((String)scopeSj.toString())) {
                stringBuilder.append(",\"").append(scopeSj).append("\"");
            }
            stringBuilder.append(",\"").append(noScopeSj).append("\"");
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    public List<ExtFieldEntry> getExtFields() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(EXT_FIELDS))) {
            return Collections.emptyList();
        }
        return (List)this.deSerializedBytes(this.getPageCache().get(EXT_FIELDS));
    }

    public List<DimFieldEntry> getDimFields() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(DIM_FIELDS))) {
            return Collections.emptyList();
        }
        return (List)this.deSerializedBytes(this.getPageCache().get(DIM_FIELDS));
    }

    protected QFilter getQFilter() {
        if (this.getModel().getValue(EXTENDS_MODEL) != null) {
            List ids = this.getExtFields().stream().map(ext -> ext.getExtField().getId()).collect(Collectors.toList());
            return new QFilter("id", "in", ids);
        }
        return new QFilter("1", "=", (Object)-1);
    }

    private String buildF7Sign(String type, String number) {
        return (type + number).toLowerCase(Locale.ENGLISH);
    }

    private <T> T getPropertyValue(String property, String key) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(property);
        if (dynamicObject == null) {
            return null;
        }
        return (T)dynamicObject.get(key);
    }
}

