/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.computing.util.OlapQueryHelper;
import kd.fi.bcm.computing.util.RuleExecuteServiceHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import org.apache.commons.lang3.StringUtils;

public class LinkQueryExtDimData
extends AbstractBaseListPlugin {
    private static final String KEY_BTNQUERY = "btnquery";
    private static final String KEY_BTNCLOSE = "btnclose";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(KEY_BTNQUERY, KEY_BTNCLOSE);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long modelID = (Long)this.getFormCustomParam("modelD");
        Map dimNumber = (Map)this.getView().getFormShowParameter().getCustomParam("dimNumber");
        List<String> dimList = this.getDimList(dimNumber);
        this.replaceCustomDimension(dimList, modelID);
        List<String> allColumn = this.getAllColumn();
        allColumn.removeAll(dimList);
        this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("modelD"));
        this.getView().setVisible(Boolean.FALSE, allColumn.toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, this.getDocumentListBusColumn().toArray(new String[0]));
        Map<String, String> userDimNumberMap = this.userDimNumberMap(modelID);
        Map<String, String> userDimNameMap = this.userDimNameMap(modelID);
        for (Map.Entry entry : dimNumber.entrySet()) {
            IDNumberTreeNode member;
            if (userDimNumberMap.containsKey(entry.getKey())) {
                TextEdit textEdit = (TextEdit)this.getControl(userDimNumberMap.get(entry.getKey()));
                textEdit.setCaption(new LocaleString(userDimNameMap.get(userDimNumberMap.get(entry.getKey()))));
                IDNumberTreeNode member2 = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelID), (String)((String)entry.getKey()), (String)((String)dimNumber.get(entry.getKey())));
                this.getModel().setValue(userDimNumberMap.get(entry.getKey()), (Object)(member2.getNumber() + "|" + member2.getName()));
                continue;
            }
            if (SysDimensionEnum.Entity.getNumber().equalsIgnoreCase((String)entry.getKey())) {
                if (((String)dimNumber.get(entry.getKey())).contains("_")) {
                    String[] parent2child = ((String)dimNumber.get(entry.getKey())).split("_");
                    IDNumberTreeNode parentMember = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelID), (String)((String)entry.getKey()), (String)parent2child[0]);
                    IDNumberTreeNode childMember = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelID), (String)((String)entry.getKey()), (String)parent2child[1]);
                    this.getModel().setValue(((String)entry.getKey()).toLowerCase(), (Object)(parentMember.getNumber() + "|" + parentMember.getName() + "_" + childMember.getNumber() + "|" + childMember.getName()));
                    continue;
                }
                member = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelID), (String)((String)entry.getKey()), (String)((String)dimNumber.get(entry.getKey())));
                this.getModel().setValue(((String)entry.getKey()).toLowerCase(), (Object)(member.getNumber() + "|" + member.getName()));
                continue;
            }
            member = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelID), (String)((String)entry.getKey()), (String)((String)dimNumber.get(entry.getKey())));
            this.getModel().setValue(((String)entry.getKey()).toLowerCase(), (Object)(member.getNumber() + "|" + member.getName()));
        }
        this.getModel().setValue("fmoney", (Object)this.getOlapMoney(modelID, dimNumber), 0);
        this.showLogForm();
    }

    private void showLogForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("advconchildpanelap1");
        formShowParameter.setFormId("bcm_linkqueryextpanel");
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(formShowParameter);
    }

    private String getOlapMoney(Long modelID, Map<String, String> dims) {
        Map result;
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        dims.forEach((key, value) -> selectCommandInfo.addFilter(key, new String[]{value}));
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapConnection olapConnection = RuleExecuteServiceHelper.getOlapConnection((String)MemberReader.findModelNumberById((Object)modelID));
        List resultList = OlapQueryHelper.queryData((SelectCommandInfo)selectCommandInfo, (OlapConnection)olapConnection);
        if (resultList.size() == 1 && (result = (Map)resultList.get(0)) != null) {
            Object measure = result.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (measure == null) {
                return null;
            }
            return measure.toString();
        }
        return null;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnquery": {
                this.showLogForm();
                break;
            }
        }
    }

    public List<String> getDimList(Map<String, String> map) {
        ArrayList<String> dimList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dimList.add(entry.getKey());
        }
        return dimList;
    }

    private void replaceCustomDimension(List<String> dimList, Long modelID) {
        String selectFields = "number,fieldmapped";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelID}).toArray());
        for (DynamicObject collection : collections) {
            if (!StringUtils.isNotBlank((CharSequence)collection.getString("fieldmapped"))) continue;
            dimList.remove(collection.getString("number"));
            dimList.add(collection.getString("fieldmapped"));
        }
    }

    private Map<String, String> userDimNumberMap(Long modelID) {
        HashMap<String, String> userDimName = new HashMap<String, String>();
        String selectFields = "number,fieldmapped";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelID}).toArray());
        for (DynamicObject collection : collections) {
            if (!StringUtils.isNotBlank((CharSequence)collection.getString("fieldmapped"))) continue;
            userDimName.put(collection.getString("number"), collection.getString("fieldmapped"));
        }
        return userDimName;
    }

    private Map<String, String> userDimNameMap(Long modelID) {
        HashMap<String, String> userDimName = new HashMap<String, String>();
        String selectFields = "name,fieldmapped";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelID}).toArray());
        for (DynamicObject collection : collections) {
            if (!StringUtils.isNotBlank((CharSequence)collection.getString("fieldmapped"))) continue;
            userDimName.put(collection.getString("fieldmapped"), collection.getString("name"));
        }
        return userDimName;
    }

    private List<String> getAllColumn() {
        ArrayList<String> allDimList = new ArrayList<String>(32);
        allDimList.add(SysDimensionEnum.Account.getNumber());
        allDimList.add(SysDimensionEnum.Scenario.getNumber());
        allDimList.add(SysDimensionEnum.Year.getNumber());
        allDimList.add(SysDimensionEnum.Period.getNumber());
        allDimList.add(SysDimensionEnum.Process.getNumber());
        allDimList.add(SysDimensionEnum.Currency.getNumber());
        allDimList.add(SysDimensionEnum.AuditTrail.getNumber());
        allDimList.add(SysDimensionEnum.ChangeType.getNumber());
        allDimList.add(SysDimensionEnum.MyCompany.getNumber());
        allDimList.add(SysDimensionEnum.InternalCompany.getNumber());
        allDimList.add(SysDimensionEnum.MultiGAAP.getNumber());
        allDimList.add(SysDimensionEnum.DataSort.getNumber());
        allDimList.add("dim1");
        allDimList.add("dim2");
        allDimList.add("dim3");
        allDimList.add("dim4");
        allDimList.add("dim5");
        allDimList.add("dim6");
        return allDimList;
    }

    private List<String> getDocumentListBusColumn() {
        ArrayList<String> allBusList = new ArrayList<String>();
        allBusList.add("scenario_name");
        allBusList.add("year_name");
        allBusList.add("period_name");
        allBusList.add("org_name");
        allBusList.add("currency_name");
        allBusList.add("process_name");
        allBusList.add("audittrail_name");
        allBusList.add("entity_name");
        return allBusList;
    }

    @Override
    public long getModelId() {
        return (Long)this.getFormCustomParam("modelD");
    }
}

