/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class LinkQueryLogPanelPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final String EXT_ENTRY_ENTITY = "entryentity";
    private static final String SPLIT = "-";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection logs = this.getLogData();
        List<Tuple<String, String, String>> defaultCols = this.getDefaultCols();
        defaultCols.addAll(this.getExtDataModel(((DynamicObject)logs.get(0)).getLong("extendsmodel.id")));
        this.buildEntryMeta(defaultCols);
        this.initExtEntryData(defaultCols, logs);
    }

    private List<Tuple<String, String, String>> getExtDataModel(long dataModelId) {
        ArrayList<Tuple<String, String, String>> cols = new ArrayList<Tuple<String, String, String>>(10);
        ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(dataModelId));
        for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
            if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                cols.add((Tuple<String, String, String>)Tuple.create((Object)fieldEntry.getDimension().getNumber(), (Object)fieldEntry.getDimension().getName(), (Object)"text"));
                continue;
            }
            if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
            if (fieldEntry.getExtField().getMapped().contains("numext")) {
                cols.add((Tuple<String, String, String>)Tuple.create((Object)fieldEntry.getExtField().getNumber(), (Object)fieldEntry.getExtField().getName(), (Object)"num"));
                continue;
            }
            cols.add((Tuple<String, String, String>)Tuple.create((Object)fieldEntry.getExtField().getNumber(), (Object)fieldEntry.getExtField().getName(), (Object)"text"));
        }
        ThreadCache.put((Object)"extendsModel", (Object)extendsModel);
        return cols;
    }

    private List<Tuple<String, String, String>> getDefaultCols() {
        ArrayList<Tuple<String, String, String>> cols = new ArrayList<Tuple<String, String, String>>(10);
        cols.add(Tuple.create((Object)"bizrule", (Object)ResManager.loadKDString((String)"\u89c4\u5219", (String)"LinkQueryLogPanelPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)"extmodel", (Object)ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b", (String)"LinkQueryLogPanelPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)"extfield", (Object)ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u5b57\u6bb5", (String)"LinkQueryLogPanelPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.SCENARIO.getNumber().toLowerCase(), (Object)DimEntityNumEnum.SCENARIO.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.YEAR.getNumber().toLowerCase(), (Object)DimEntityNumEnum.YEAR.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.PERIOD.getNumber().toLowerCase(), (Object)DimEntityNumEnum.PERIOD.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)"org", (Object)DimEntityNumEnum.ENTITY.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.CURRENCY.getNumber().toLowerCase(), (Object)DimEntityNumEnum.CURRENCY.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.PROCESS.getNumber().toLowerCase(), (Object)DimEntityNumEnum.PROCESS.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.AUDITTRIAL.getNumber().toLowerCase(), (Object)DimEntityNumEnum.AUDITTRIAL.getName(), (Object)"text"));
        cols.add(Tuple.create((Object)DimEntityNumEnum.ENTITY.getNumber().toLowerCase(), (Object)ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"LinkQueryLogPanelPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)"creator", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u4eba", (String)"LinkQueryLogPanelPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)"createdate", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u65f6\u95f4", (String)"LinkQueryLogPanelPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        cols.add(Tuple.create((Object)"money", (Object)ResManager.loadKDString((String)"\u91d1\u989d", (String)"LinkQueryLogPanelPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"text"));
        return cols;
    }

    private DynamicObjectCollection getLogData() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", this.getFormCustomParam("modelD")));
        qfBuilder.add(new QFilter("dimstr", "=", this.getFormCustomParam("dimStr")));
        return QueryServiceHelper.query((String)"bcm_extendsynlog", (String)"bizrule.number,bizrule.name,extendsmodel.id,extendsmodel.number,extendsmodel.name,creater.name,createdate,extendmember.number,extendmember.name,entryentity.scenario, entryentity.year, entryentity.period,entryentity.org,entryentity.currency,entryentity.process,entryentity.audittrail,entryentity.entity,entryentity.money,entryentity.databus,entryentity.data", (QFilter[])qfBuilder.toArray());
    }

    private void buildEntryMeta(List<Tuple<String, String, String>> cols) {
        Page page = new Page();
        DynamicEntry entry = new DynamicEntry(EXT_ENTRY_ENTITY);
        LocaleString width = new LocaleString(90 / cols.size() + "%");
        for (Tuple<String, String, String> col : cols) {
            String number = (String)col.p1;
            String name = (String)col.p2;
            String type = (String)col.p3;
            TextEditElement element = new TextEditElement(name, number, "");
            element.setEditStyle(1);
            element.setWidth(new LocaleString("10%"));
            element.setLock("new,edit,view");
            entry.addElement((Element)element);
        }
        page.addEntry(entry);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private TextEditElement buildColEditElement(String number, String name, String type) {
        TextEditElement textEditElement = new TextEditElement(name, number, "");
        textEditElement.setEditStyle(1);
        return textEditElement;
    }

    private void initExtEntryData(List<Tuple<String, String, String>> cols, DynamicObjectCollection logs) {
        this.getModel().beginInit();
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<Map<String, String>> values = this.getAllColValues(logs);
        for (Tuple<String, String, String> col : cols) {
            vs.addField(((String)col.p1).toLowerCase(), new Object[0]);
        }
        vs = this.fillSetter(cols, values, vs);
        abstractFormDataModel.batchCreateNewEntryRow(EXT_ENTRY_ENTITY, vs);
        abstractFormDataModel.endInit();
        this.getView().updateView(EXT_ENTRY_ENTITY);
    }

    private List<Map<String, String>> getAllColValues(DynamicObjectCollection logs) {
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(10);
        ExtendsModel extendsModel = (ExtendsModel)ThreadCache.get((Object)"extendsModel");
        Map<Long, Map<String, Object>> extDataMap = this.getExtDataResultByLogs(logs, extendsModel);
        for (DynamicObject dyn : logs) {
            HashMap<String, String> values = new HashMap<String, String>(16);
            values.put("bizrule", dyn.getString("bizrule.number") + SPLIT + dyn.getString("bizrule.name"));
            values.put("extmodel", dyn.getString("extendsmodel.number") + SPLIT + dyn.getString("extendsmodel.name"));
            values.put("extfield", dyn.getString("extendmember.number") + SPLIT + dyn.getString("extendmember.name"));
            IDNumberTreeNode scenarioNode = MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)dyn.getLong("entryentity.scenario"));
            values.put(DimEntityNumEnum.SCENARIO.getNumber().toLowerCase(), scenarioNode.getNumber() + SPLIT + scenarioNode.getName());
            IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)this.getModelId(), (Long)dyn.getLong("entryentity.year"));
            values.put(DimEntityNumEnum.YEAR.getNumber().toLowerCase(), yearNode.getNumber() + SPLIT + yearNode.getName());
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)dyn.getLong("entryentity.period"));
            values.put(DimEntityNumEnum.PERIOD.getNumber().toLowerCase(), periodNode.getNumber() + SPLIT + periodNode.getName());
            IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)dyn.getLong("entryentity.process"));
            values.put(DimEntityNumEnum.PROCESS.getNumber().toLowerCase(), processNode.getNumber() + SPLIT + processNode.getName());
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)dyn.getLong("entryentity.org"));
            String orgName = orgNode.getName();
            String orgNum = orgNode.getNumber();
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)dyn.getLong("entryentity.entity"));
            String entityName = entityNode.getName();
            String entityNum = entityNode.getNumber();
            if (OrgRelaProcessMembPool.isRelaProcess((String)processNode.getNumber())) {
                values.put("org", orgNum + SPLIT + orgName + "_" + entityNum + SPLIT + entityName);
            } else {
                values.put("org", orgNum + SPLIT + orgName);
            }
            values.put(DimEntityNumEnum.ENTITY.getNumber().toLowerCase(), entityNum + SPLIT + entityName);
            IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.getModelId()), (Long)dyn.getLong("entryentity.currency"));
            values.put(DimEntityNumEnum.CURRENCY.getNumber().toLowerCase(), currencyNode.getNumber() + SPLIT + currencyNode.getName());
            IDNumberTreeNode auditNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_audittrialmembertree", (Long)dyn.getLong("entryentity.audittrail"));
            values.put(DimEntityNumEnum.AUDITTRIAL.getNumber().toLowerCase(), auditNode.getNumber() + SPLIT + auditNode.getName());
            values.put("creator", dyn.getString("creater.name"));
            values.put("createdate", DateTimeUtils.format((Date)dyn.getDate("createdate")));
            values.put("money", dyn.getString("entryentity.money"));
            long dataId = dyn.getLong("entryentity.data");
            long dataBusId = dyn.getLong("entryentity.databus");
            Map extData = extDataMap.getOrDefault(dataId, extDataMap.getOrDefault(dataBusId, new HashMap(0)));
            if (!extData.isEmpty()) {
                for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
                    if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)fieldEntry.getDimension().getNumber(), (String)this.getValueStr(extData.get(fieldEntry.getDimension().getNumber())));
                        if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                        values.put(fieldEntry.getDimension().getNumber(), node.getNumber() + SPLIT + node.getName());
                        continue;
                    }
                    if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
                    values.put(fieldEntry.getExtField().getNumber(), this.getValueStr(extData.get(fieldEntry.getExtField().getNumber())));
                }
            }
            res.add(values);
        }
        return res;
    }

    private Map<Long, Map<String, Object>> getExtDataResultByLogs(DynamicObjectCollection logs, ExtendsModel extendsModel) {
        String field = ExtendDimGroupType.COMMON.getIndex().equals(extendsModel.getExtendsGroupType()) ? "entryentity.data" : "entryentity.databus";
        List ids = logs.stream().filter(log -> log.getLong(field) != 0L).map(dyn -> dyn.getLong(field)).collect(Collectors.toList());
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(16);
        EdQueryComInfo queryComInfo = new EdQueryComInfo(MemberReader.findModelSNumberById((Object)this.getModelId()), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        queryComInfo.setDimselects((String[])extendsModel.getDimFieldEntry().stream().map(ext -> ext.getDimension().getNumber()).toArray(String[]::new));
        queryComInfo.setExtselects((String[])extendsModel.getExtFieldEntry().stream().map(ext -> ext.getExtField().getNumber()).toArray(String[]::new));
        queryComInfo.setQueryOriData(true);
        queryComInfo.setCustomFilter(new QFilter("id", "in", ids));
        EDResultSet edResultSet = ExtDataServiceHelper.queryData((EdQueryComInfo)queryComInfo);
        while (edResultSet.next()) {
            EDRow row = edResultSet.getRow();
            List colMetaDatas = edResultSet.getMetaData().getColMetaDatas();
            long pkId = row.getPkId();
            HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
            for (EDColumn colMetaData : colMetaDatas) {
                valueMap.put(colMetaData.getMdName(), row.getOriginalValue(colMetaData.getMdName()));
            }
            resultMap.put(pkId, valueMap);
        }
        return resultMap;
    }

    private TableValueSetter fillSetter(List<Tuple<String, String, String>> cols, List<Map<String, String>> values, TableValueSetter vs) {
        int index = 0;
        for (Map<String, String> value : values) {
            for (Tuple<String, String, String> col : cols) {
                vs.set((String)col.p1, (Object)value.get(col.p1), index);
            }
            ++index;
        }
        return vs;
    }

    @Override
    public long getModelId() {
        return (Long)this.getFormCustomParam("modelD");
    }

    private String getValueStr(Object value) {
        String str = "";
        if (value == null) {
            return str;
        }
        str = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : (value instanceof Date ? DateTimeUtils.formatDate((Date)((Date)value)) : value.toString());
        return str;
    }
}

