/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkQueryShowForm {
    private static final Log log = LogFactory.getLog(LinkQueryShowForm.class);
    private boolean isOpenRpt;
    private IFormView formView;
    private String formId;
    private Map<String, Object> params;
    private Set<Long> accountIds;
    private String[] fetchTypeQTY = new String[]{"QC", "QY", "QJF", "QDF", "CY", "QJL", "QDL"};

    public LinkQueryShowForm(IFormView formView, String formId, Map<String, Object> params) {
        this(formView, formId, params, false, null);
    }

    public LinkQueryShowForm(IFormView formView, String formId, Map<String, Object> params, boolean isOpenRpt, Set<Long> accountIds) {
        this.formView = formView;
        this.formId = formId;
        this.params = params;
        this.isOpenRpt = isOpenRpt;
        this.accountIds = accountIds == null ? new HashSet(16) : accountIds;
    }

    public void showForm() {
        this.formView.showForm((FormShowParameter)(this.isOpenRpt ? this.getReportShowParameter() : this.getListShowParameter()));
    }

    public void sendFormAction() {
        IFormView parentView = this.formView.getParentView();
        parentView.showForm((FormShowParameter)(this.isOpenRpt ? this.getReportShowParameter() : this.getListShowParameter()));
        this.formView.sendFormAction(parentView);
    }

    public void getCashflowReportShowParameter(boolean flag) {
        Long orgId = Long.valueOf(String.valueOf(this.params.get("org")));
        Long accountbookstype = Long.valueOf(String.valueOf(this.params.get("accountbookstype")));
        DynamicObject bookInfo = FormulaAnalyze.getBookObject((long)orgId, (long)accountbookstype);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"LinkQueryShowForm_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FilterInfo filter = new FilterInfo();
        String cashflowStr = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)this.params.get("cashflow").toString())[0];
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"level", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)cashflowStr)});
        if (queryOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"LinkQueryShowForm_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.addFilterItem("itemlevel", (Object)queryOne.getString("level"));
        filter.addFilterItem("org", (Object)orgId);
        filter.addFilterItem("booktype", (Object)bookInfo.getLong("bookstype.id"));
        filter.addFilterItem("periodtype", (Object)bookInfo.getLong("periodtype.id"));
        Long accountingsysId = bookInfo.getLong("accountingsys.id");
        DynamicObject one = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter("accountingsys", "=", (Object)accountingsysId).toArray());
        if (one == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6838\u7b97\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"LinkQueryShowForm_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.addFilterItem("orgview", (Object)one.getLong("id"));
        filter.addFilterItem("accounttable", (Object)bookInfo.getLong("accounttable.id"));
        filter.addFilterItem("issubstractpl", (Object)Boolean.TRUE);
        this.params.put("periodtype", bookInfo.getLong("periodtype.id"));
        DynamicObject dynamicObject = FormulaAnalyze.getCorrentPeriod(this.params);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u533a\u95f4\u3002", (String)"LinkQueryShowForm_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.addFilterItem("startperiod", (Object)dynamicObject.getLong("id"));
        filter.addFilterItem("endperiod", (Object)dynamicObject.getLong("id"));
        filter.addFilterItem("datebegin", (Object)dynamicObject.getDate("begindate"));
        filter.addFilterItem("dateend", (Object)dynamicObject.getDate("enddate"));
        filter.addFilterItem("accountlevel", (Object)QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"maxlevel", (QFilter[])new QFilter("id", "=", (Object)bookInfo.getLong("accounttable.id")).toArray()).getString("maxlevel"));
        if (!this.params.get("currency").toString().equals("") && Integer.parseInt(this.params.get("currency").toString()) != 0) {
            filter.addFilterItem("currency", this.params.get("currency"));
        } else {
            filter.addFilterItem("currency", (Object)String.valueOf(bookInfo.getLong("basecurrency.id")));
        }
        filter.addFilterItem("showqty", (Object)Arrays.asList(this.fetchTypeQTY).contains(this.params.get("fetchtype").toString()));
        filter.addFilterItem("isquerybyperiod", (Object)Boolean.TRUE);
        String[] flexProp = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)this.params.get("cashflow").toString());
        List ass = this.getFilters(flexProp, FilterItemInfo.class);
        filter.setFlexFilterItems(ass);
        filter.addFilterItem("showassist", (Object)Boolean.TRUE);
        filter.addFilterItem("showorg", (Object)Boolean.TRUE);
        filter.addFilterItem("orgtype", (Object)"1");
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        log.info("LinkQueryShowForm.getCashflowReportShowParameter:" + filter.toString());
        ReportShowParameter reportParams = new ReportShowParameter();
        reportParams.setFormId(this.formId);
        reportParams.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        reportParams.setQueryParam(queryParam);
        if (flag) {
            this.formView.showForm((FormShowParameter)reportParams);
        } else {
            IFormView parentView = this.formView.getParentView();
            parentView.showForm((FormShowParameter)reportParams);
            this.formView.sendFormAction(parentView);
        }
    }

    public ReportShowParameter getReportShowParameter() {
        Long orgId = Long.valueOf(String.valueOf(this.params.get("org")));
        Long accountbookstype = Long.valueOf(String.valueOf(this.params.get("accountbookstype")));
        DynamicObject bookInfo = FormulaAnalyze.getBookObject((long)orgId, (long)accountbookstype);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u79d1\u76ee\u4f59\u989d\u8868\u3002", (String)"LinkQueryShowForm_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.params.put("periodtype", bookInfo.getLong("periodtype.id"));
        String accountStr = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)this.params.get("account").toString())[0];
        Long accountId = 0L;
        if (accountStr.contains("[")) {
            if ((accountStr = accountStr.substring(1, accountStr.length() - 1)).contains(",")) {
                String[] split = accountStr.split(",");
                for (int i = 0; i < split.length; ++i) {
                    accountId = Long.parseLong(split[i].trim());
                    this.accountIds.add(Long.parseLong(split[i].trim()));
                }
            } else {
                this.accountIds.add(Long.parseLong(accountStr));
                accountId = Long.parseLong(accountStr);
            }
        }
        String level = "1";
        if (accountId != 0L) {
            QFBuilder qf = new QFBuilder();
            qf.add("id", "in", this.accountIds);
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"bd_accountview", (String)"id,level", (QFilter[])qf.toArray());
            if (objects == null || objects.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u603b\u8d26\u57fa\u7840\u8d44\u6599\u4e2d\u5b8c\u5584\u3002", (String)"LinkQueryShowForm_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject dyo : objects) {
                String level1 = dyo.getString("level");
                if (Integer.parseInt(level) >= Integer.parseInt(level1)) continue;
                level = level1;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u603b\u8d26\u57fa\u7840\u8d44\u6599\u4e2d\u5b8c\u5584\u3002", (String)"LinkQueryShowForm_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("org", (Object)orgId);
        filter.addFilterItem("booktype", (Object)bookInfo.getLong("bookstype.id"));
        filter.addFilterItem("periodtype", (Object)bookInfo.getLong("periodtype.id"));
        DynamicObject dynamicObject = FormulaAnalyze.getCorrentPeriod(this.params);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u533a\u95f4\u3002", (String)"LinkQueryShowForm_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long cuPeriodId = Long.valueOf(String.valueOf(dynamicObject.getLong("id")));
        filter.addFilterItem("startperiod", (Object)(cuPeriodId > 0L ? cuPeriodId.longValue() : bookInfo.getLong("curperiod.id")));
        filter.addFilterItem("endperiod", (Object)(cuPeriodId > 0L ? cuPeriodId.longValue() : bookInfo.getLong("curperiod.id")));
        filter.addFilterItem("accounttable", (Object)bookInfo.getLong("accounttable.id"));
        filter.addFilterItem("account", this.accountIds);
        filter.addFilterItem("accountlevel", (Object)level);
        filter.addFilterItem("searchtype", (Object)"1");
        if (!this.params.get("currency").toString().equals("")) {
            filter.addFilterItem("currency", this.params.get("currency"));
        } else {
            filter.addFilterItem("currency", (Object)"basecurrency");
        }
        filter.addFilterItem("showqty", (Object)Arrays.asList(this.fetchTypeQTY).contains(this.params.get("fetchtype").toString()));
        String[] flexProp = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)this.params.get("account").toString());
        List ass = this.getFilters(flexProp, FilterItemInfo.class);
        filter.setFlexFilterItems(ass);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        log.info("LinkQueryShowForm.getReportShowParameter:" + filter.toString());
        ReportShowParameter reportParams = new ReportShowParameter();
        reportParams.setFormId(this.formId);
        reportParams.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        reportParams.setQueryParam(queryParam);
        return reportParams;
    }

    public ListShowParameter getListShowParameter() {
        String orgId = String.valueOf(this.params.get("org"));
        Long accountbookstype = Long.valueOf(String.valueOf(this.params.get("accountbookstype")));
        DynamicObject bookInfo = FormulaAnalyze.getBookObject((long)Long.parseLong(orgId), (long)accountbookstype);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u79d1\u76ee\u4f59\u989d\u8868\u3002", (String)"LinkQueryShowForm_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.params.put("periodtype", bookInfo.getLong("periodtype.id"));
        ListShowParameter listParams = new ListShowParameter();
        listParams.setBillFormId(this.formId);
        listParams.setFormId("bos_list");
        DynamicObject dynamicObject = FormulaAnalyze.getCorrentPeriod(this.params);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u533a\u95f4\u3002", (String)"LinkQueryShowForm_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        JSONArray jsonArray = new JSONArray();
        try {
            String begindate = format1.format(format1.parse(dynamicObject.getString("begindate")));
            String enddate = format1.format(format1.parse(dynamicObject.getString("enddate")));
            jsonArray.add((Object)begindate);
            jsonArray.add((Object)enddate);
        }
        catch (Exception e) {
            jsonArray = new JSONArray();
            jsonArray.add((Object)format1.format(DateUtils.getThisMonthFirstDay()));
            jsonArray.add((Object)format1.format(DateUtils.getThisMonthEndDay()));
        }
        listParams.setCustomParam("bookeddate", (Object)jsonArray);
        listParams.setCustomParam("org", (Object)orgId);
        listParams.setCustomParam("booktype", (Object)String.valueOf(this.params.get("accountbookstype")));
        String[] flexProp = FormulaAnalyze.getAccountOrAsstactTypeNumbers((String)this.params.get("account").toString());
        List ass = this.getFilters(flexProp, QFilter.class);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("billstatus", "<>", (Object)"A"));
        filter.and(new QFilter("booktype", "=", (Object)String.valueOf(accountbookstype)));
        filter.and(new QFilter("bookeddate", ">=", (Object)dynamicObject.getDate("begindate")));
        filter.and(new QFilter("bookeddate", "<=", (Object)dynamicObject.getDate("enddate")));
        if (flexProp[0].contains("[")) {
            String substring = flexProp[0].substring(1, flexProp[0].length() - 1);
            if (substring.contains(",")) {
                String[] split = substring.split(",");
                for (int i = 0; i < split.length; ++i) {
                    this.accountIds.add(Long.parseLong(split[i].trim()));
                }
            } else {
                this.accountIds.add(Long.parseLong(substring.trim()));
            }
        } else {
            this.accountIds.add(Long.parseLong(flexProp[0].trim()));
        }
        filter.and(new QFilter("entries.account.id", "in", this.accountIds));
        for (QFilter qFilter : ass) {
            filter.and(qFilter);
        }
        log.info("LinkQueryShowForm.getListShowParameter:" + filter.toString());
        listParams.setCustomParam("filter", (Object)filter.toSerializedString());
        listParams.setCustomParam("source", (Object)"TransPLProgramsList");
        listParams.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return listParams;
    }

    private <T> List<T> getFilters(String[] flexProp, Class tClass) {
        ArrayList<Object> ass = new ArrayList<Object>(10);
        QFBuilder qfBuilder = new QFBuilder();
        QFBuilder qfBuilder1 = new QFBuilder();
        for (int i = 1; i < flexProp.length; ++i) {
            int index;
            HashSet<Long> vals = new HashSet<Long>(16);
            DynamicObject dyFlex = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)flexProp[i])});
            if (dyFlex == null) continue;
            if ((index = ++i) <= flexProp.length - 1) {
                String tempStr = flexProp[index];
                if ("@".equals(tempStr)) {
                    vals.add(null);
                    continue;
                }
                if (tempStr.contains("[") && tempStr.contains("]")) {
                    if (!(tempStr = tempStr.substring(1, tempStr.length() - 1)).contains(",") || tempStr.split(",").length != 2) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u586b\u5199\u9519\u8bef\uff0c\u5f53\u516c\u5f0f\u4e2d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e3a\u8fde\u7eed\u7c7b\u578b\u65f6\uff0c\u683c\u5f0f\u4e3a\u201c[a,b]\u201d\u3002", (String)"LinkQueryShowForm_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    qfBuilder.add("number", ">=", (Object)tempStr.split(",")[0]);
                    qfBuilder.and("number", "<=", (Object)tempStr.split(",")[1]);
                    qfBuilder1.add("internal_company.number", ">=", (Object)tempStr.split(",")[0]);
                    qfBuilder1.and("internal_company.number", "<=", (Object)tempStr.split(",")[1]);
                } else if (tempStr.contains(",")) {
                    qfBuilder.add("number", "in", (Object)tempStr.split(","));
                    qfBuilder1.and("internal_company.number", "in", (Object)tempStr.split(","));
                } else if (StringUtils.isNotEmpty((String)tempStr)) {
                    qfBuilder.add("number", "=", (Object)tempStr);
                    qfBuilder1.and("internal_company.number", "=", (Object)tempStr);
                }
                if (qfBuilder.size() > 0) {
                    DynamicObjectCollection dyMemberS = QueryServiceHelper.query((String)dyFlex.getString("valuesource"), (String)"id", (QFilter[])qfBuilder.toArray());
                    if (dyMemberS.size() == 0) {
                        dyMemberS = QueryServiceHelper.query((String)dyFlex.getString("valuesource"), (String)"id", (QFilter[])qfBuilder1.toArray());
                    }
                    for (DynamicObject dyMember : dyMemberS) {
                        vals.add(dyMember.getLong("id"));
                    }
                }
            }
            if (tClass == FilterItemInfo.class) {
                ass.add(new FilterItemInfo(dyFlex.getString("flexfield"), vals, "="));
            } else {
                ass.add(new QFilter(String.format("assgrp_%s.%s.name", dyFlex.getString("flexfield"), dyFlex.getString("valuesource")), "=", vals));
            }
            qfBuilder.clear();
            qfBuilder1.clear();
        }
        return ass;
    }
}

