/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class RefFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final String cache_prefix = "cache_";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", (Object)this.getModelId());
        String formulaNumber = (String)this.getFormCustomParam("accttype");
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)formulaNumber);
        String formulaStr = "";
        Object forObj = this.getFormCustomParam("formula");
        if (forObj != null) {
            String forStr = forObj.toString();
            int i = forStr.indexOf("(");
            int j = forStr.lastIndexOf(")");
            if (i != -1 && j != -1) {
                formulaStr = forStr.substring(i + 1, j);
            }
        }
        List params = formula.getParam();
        if (StringUtils.isNotEmpty((CharSequence)formulaStr)) {
            try {
                this.reLoadData(formulaNumber, formulaStr, params);
            }
            catch (Exception ex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u89c4\u8303\uff0c\u4e0d\u4f1a\u751f\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53c2\u6570\u3002", (String)"RefFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void reLoadData(String formulaNumber, String formulaStr, List<Map<String, Object>> params) {
        String[] parameters = formulaStr.split(",");
        ArrayList accounts = Lists.newArrayList();
        int accountIndex = 2;
        int accountSum = 0;
        int j = 0;
        boolean has_MiddleNum = formulaStr.contains("[");
        for (String parameter : parameters) {
            String str = StringUtils.remove((String)parameter.trim(), (char)'\"');
            if (StringUtils.isNotEmpty((CharSequence)str)) {
                String type = params.get(j).get("type").toString();
                if ("basedatafield".equals(type) || "mulbasedatafield".equals(type)) {
                    if (str.contains("|")) {
                        str = str.split("\\|")[0];
                    }
                    if ("account".equals(params.get(j).get("number")) && "acct".equals(formulaNumber)) {
                        str = StringUtils.remove((String)str, (String)"[");
                        str = StringUtils.remove((String)str, (String)"]");
                        accounts.add(str);
                        if (++accountSum < parameters.length - 6) continue;
                    }
                    if (this.getView().getControl((String)params.get(j).get("number")) instanceof MulBasedataEdit) {
                        if (has_MiddleNum) {
                            accounts.remove(1);
                        }
                        DynamicObjectCollection doc = this.queryEntityIdByNumbers(params.get(j).get("value").toString(), accounts.toArray(new String[0]));
                        Long[] ids = DynamicObjectCollectionUtil.getPKArray((DynamicObjectCollection)doc);
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)ids);
                    } else {
                        long id = this.queryEntityIdByNumber(params.get(j).get("value").toString(), str);
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)id);
                    }
                } else if ("combofield".equals(type)) {
                    Map comboMap = (Map)params.get(j).get("items");
                    for (String key : comboMap.keySet()) {
                        if (!key.equalsIgnoreCase(str)) continue;
                        this.getModel().setValue(params.get(j).get("number").toString(), (Object)key);
                    }
                } else {
                    this.getModel().setValue(params.get(j).get("number").toString(), (Object)str);
                }
                this.getView().updateView(params.get(j).get("number").toString());
                if (params.get(j).get("needcache") != null && ((Boolean)params.get(j).get("needcache")).booleanValue()) {
                    if ("account".equals(params.get(j).get("number").toString())) {
                        String accounttStr = has_MiddleNum ? "[" + String.join((CharSequence)",", accounts) + "]" : String.join((CharSequence)",", accounts);
                        this.getPageCache().put(cache_prefix + params.get(accountIndex).get("number").toString(), accounttStr);
                    } else {
                        this.getPageCache().put(cache_prefix + params.get(j).get("number").toString(), str);
                    }
                }
            }
            ++j;
        }
    }

    private long queryEntityIdByNumber(String entityNumber, String number) {
        DynamicObject object;
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("number", "=", (Object)number);
        if (entityNumber.equals("bcm_templateentity")) {
            filter2.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        }
        if ((object = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{filter1, filter2})) != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    private DynamicObjectCollection queryEntityIdByNumbers(String entityNumber, String[] numbers) {
        QFilter filter2 = new QFilter("number", "in", (Object)numbers);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{filter2});
        return objects;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm");
        BasedataEdit periodmember = (BasedataEdit)this.getControl("periodmember");
        DynamicObject sceneDyn = this.getModel().getDataEntity().getDynamicObject("scenemember");
        periodmember.addBeforeF7SelectListener(l -> {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            if (sceneDyn == null) {
                list.add(new QFilter("1", "=", (Object)1));
            } else {
                ArrayList<Long> ids = new ArrayList<Long>();
                DynamicObjectCollection dync = sceneDyn.getDynamicObjectCollection("sceneperiod");
                for (DynamicObject dyn : dync) {
                    long id = dyn.getLong("fbasedataid_id");
                    ids.add(id);
                }
                list.add(new QFilter("id", "in", ids).or(new QFilter("model", "=", (Object)this.getModelId()).and("number", "in", (Object)new Object[]{"LastPeriod", "CurrentPeriod"})));
            }
            l.setCustomQFilters(list);
        });
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            String formulaNumber = (String)this.getFormCustomParam("accttype");
            Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)formulaNumber);
            List params = formula.getParam();
            ArrayList<String> valueList = new ArrayList<String>();
            for (Map param : params) {
                if ("basedatafield".equals(param.get("type")) || "mulbasedatafield".equals(param.get("type"))) {
                    if (!this.addF7Data2ValueList(valueList, param)) continue;
                    return;
                }
                Object obj = this.getModel().getValue(param.get("number").toString());
                String value = "";
                if (obj == null) {
                    if (((Boolean)param.get("mustinput")).booleanValue()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                        return;
                    }
                } else {
                    if (StringUtils.isEmpty((CharSequence)obj.toString())) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                        return;
                    }
                    value = obj.toString();
                }
                if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                    value = this.getPageCache().get(cache_prefix + param.get("number").toString());
                }
                if (obj != null && "datefield".equals(param.get("type"))) {
                    value = DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd");
                }
                if (obj != null && "datetimefield".equals(param.get("type"))) {
                    value = DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
                }
                valueList.add(value);
            }
            StringBuilder stringBuilder = this.getFormulaParamString(params, valueList);
            String type = (String)this.getFormCustomParam("accttype");
            String str = type + "(" + stringBuilder + ")";
            this.getView().returnDataToParent((Object)str);
            this.getView().close();
        }
    }

    private boolean addF7Data2ValueList(List<String> valueList, Map<String, Object> param) {
        if ("mulbasedatafield".equals(param.get("type"))) {
            DynamicObjectCollection objs = (DynamicObjectCollection)this.getModel().getValue(param.get("number").toString());
            String value = "";
            if ((objs == null || objs.isEmpty()) && ((Boolean)param.get("mustinput")).booleanValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                return true;
            }
            if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                value = this.getPageCache().get(cache_prefix + param.get("number").toString());
            } else {
                ArrayList ls = Lists.newArrayList();
                for (DynamicObject obj : objs) {
                    if (obj == null) continue;
                    ls.add(obj.getDynamicObject("fbasedataid").getString("number"));
                }
                value = String.join((CharSequence)",", ls);
            }
            valueList.add(value);
        } else {
            DynamicObject obj = (DynamicObject)this.getModel().getValue(param.get("number").toString());
            String value = "";
            if (obj == null && ((Boolean)param.get("mustinput")).booleanValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RefFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), param.get("name").toString()), Integer.valueOf(3000));
                return true;
            }
            if (param.get("needcache") != null && ((Boolean)param.get("needcache")).booleanValue()) {
                value = this.getPageCache().get(cache_prefix + param.get("number").toString());
            } else if (obj != null) {
                value = obj.getString("number");
            }
            valueList.add(value);
        }
        return false;
    }

    private StringBuilder getFormulaParamString(List<Map<String, Object>> params, List<String> valueList) {
        StringBuilder stringBuilder = new StringBuilder();
        String startAccount = "";
        String endAccount = "";
        String[] s = new String[]{};
        if (!"rptdate".equals(this.getFormCustomParam("accttype")) && !"rptinfo".equals(this.getFormCustomParam("accttype"))) {
            s = valueList.get(2).split("\\|");
            startAccount = s.length > 1 ? s[0] : valueList.get(2);
            endAccount = this.getPageCache().get("endAccount");
        }
        if (StringUtils.isEmpty((CharSequence)endAccount)) {
            for (int i = 0; i < params.size(); ++i) {
                if ("integerfield".equals(params.get(i).get("type"))) {
                    stringBuilder.append(valueList.get(i)).append(',');
                    continue;
                }
                stringBuilder.append('\"').append(valueList.get(i)).append('\"').append(',');
            }
        } else {
            for (int i = 0; i < params.size(); ++i) {
                if ("integerfield".equals(params.get(i).get("type"))) {
                    stringBuilder.append(valueList.get(i)).append(',');
                    continue;
                }
                if (i == 2) {
                    if (startAccount.equals(endAccount)) {
                        stringBuilder.append('\"').append(valueList.get(i)).append('\"').append(',');
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    sb.append(startAccount).append(',');
                    sb.append(endAccount);
                    sb.append(']');
                    String params_third = valueList.get(i).replace(startAccount, sb.toString());
                    stringBuilder.append('\"').append(params_third).append('\"').append(',');
                    continue;
                }
                stringBuilder.append('\"').append(valueList.get(i)).append('\"').append(',');
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.toString().length() - 1);
        return stringBuilder;
    }
}

