/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaConstant;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.invest.sheet.formula.InvestFormulaRegisterHelper;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class RptFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final Map<String, String> operationCharacter = new HashMap<String, String>();
    private static final String[] operators = new String[]{"+", "-", "*", "/", "<>"};
    private static final String catalog_list = "CATALOG_LIST";
    private static final String TEXT_AREA = "txtadvance";
    private static final String TEXT_AREA_TAG = "txtadvance_tag";
    private static final String RPTMODEL_EDIT = "bcm_rptformulaedit";
    private static final String RPT_CALLBACK = "formulaedit";
    private static final String RPT_UPDATE_FORMULA = "updateFormula";
    private static Map<String, String> paramMultilingual = new HashMap<String, String>(16);
    private static final String ZHCN = "zh_CN";
    private static boolean ISZH = true;

    private List<Map<String, String>> getCatalogList() {
        return FormulaConfig.getInstance().getCatalogList();
    }

    protected List<Map<String, String>> getFormulaList() {
        List<Map<String, String>> formulaList = InvestFormulaRegisterHelper.getRptShowFxPlanelFormulaList();
        if (this.getFormCustomParam("containsbn") != null) {
            formulaList.add(MapInitHelper.ofMap((Object)"number", (Object)"bn", (Object)"catalog", (Object)"all", (Object)"name", (Object)ResManager.loadKDString((String)"\u5e73\u8861\u6570", (String)"RptFormulaPlugin_bn", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Object)"description", (Object)""));
        }
        return formulaList;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map<String, String>> formulaList = this.getFormulaList();
        formulaList.removeIf(map -> "excel".equals(map.get("catalog")));
        formulaList.sort((o1, o2) -> ((String)o1.get("number")).compareToIgnoreCase((String)o2.get("number")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("cmbtype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List<String> cats = this.getCatalogFilter();
        List<Map<String, String>> catalogList = this.getCatalogList();
        HashSet<String> paramNums = new HashSet<String>(16);
        Set formulaNumberSet = FormulaConfig.getInstance().getFormulaNumberSet();
        formulaNumberSet.forEach(number -> paramNums.add(number + ".name"));
        paramNums.addAll(cats);
        QFilter qFilter = new QFilter("paramnumber", "in", paramNums);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_formulamultilingual", (String)"paramnumber,name", (QFilter[])qFilter.toArray());
        paramMultilingual = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getString("paramnumber"), dy -> Optional.ofNullable(dy.getLocaleString("name").getLocaleValue() != null ? dy.getLocaleString("name").getLocaleValue() : dy.getLocaleString("name").getLocaleValue_zh_CN()).orElseGet(() -> dy.getString("paramnumber")), (v1, v2) -> v1));
        for (Map<String, String> catalog : catalogList) {
            if (!cats.contains(catalog.get("number"))) continue;
            String number2 = catalog.get("number");
            if (number2.contains("-")) {
                number2 = catalog.get("number").replace("-", "_");
            }
            String name = paramMultilingual.containsKey(catalog.get("number")) ? paramMultilingual.get(catalog.get("number")) : ResManager.loadKDString((String)catalog.get("name"), (String)("RptFormulaPlugin_" + number2), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            items.add(new ComboItem(new LocaleString(name), catalog.get("number")));
        }
        comboEdit.setComboItems(items);
        this.getModel().setValue("cmbtype", (Object)"all");
        this.setFormulaTree("all");
        Object txtadvance = this.getFormCustomParam(TEXT_AREA);
        if (txtadvance != null) {
            this.getModel().setValue(TEXT_AREA_TAG, txtadvance);
        }
    }

    private List<String> getFormulaFilter() {
        String filter = (String)this.getFormCustomParam("filter");
        ArrayList<String> filters = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            filters = Arrays.asList(filter.split(","));
        } else {
            List<Map<String, String>> formulaList = this.getFormulaList();
            for (Map<String, String> formula : formulaList) {
                String formulaNum = formula.get("number");
                if (formulaNum.equals("rptdate") || formulaNum.equals("rptinfo")) continue;
                filters.add(formulaNum);
            }
        }
        return filters;
    }

    private List<String> getCatalogFilter() {
        List<String> formulas = this.getFormulaFilter();
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("all");
        List<Map<String, String>> formulaList = this.getFormulaList();
        for (Map<String, String> formula : formulaList) {
            if (!formulas.contains(formula.get("number"))) continue;
            filters.add(formula.get("catalog"));
        }
        return filters;
    }

    private void setFormulaTree(String type) {
        TreeView tree = (TreeView)this.getControl("formulatree");
        tree.deleteAllNodes();
        ArrayList<TreeNode> catalogList = new ArrayList<TreeNode>();
        List<String> fors = this.getFormulaFilter();
        List<Map<String, String>> formulaList = this.getFormulaList();
        if ("all".equals(type)) {
            for (Map<String, String> formula : formulaList) {
                if (FormulaConstant.IGNORFORMULAS.contains(formula.get("number")) || "vs_data".equals(formula.get("number")) && !ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isOpenMultiCal") || !fors.contains(formula.get("number"))) continue;
                TreeNode node = new TreeNode();
                node.setId(formula.get("number"));
                String number = formula.get("number");
                if (number.contains("-")) {
                    number = formula.get("number").replace("-", "_");
                }
                String name = paramMultilingual.containsKey(number.toLowerCase(Locale.ENGLISH) + ".name") ? paramMultilingual.get(number.toLowerCase(Locale.ENGLISH) + ".name") : ResManager.loadKDString((String)formula.get("name"), (String)("RptFormulaPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                node.setText(formula.get("number") + " " + name);
                node.setParentid("");
                tree.addNode(node);
                catalogList.add(node);
            }
        } else {
            for (Map<String, String> formula : formulaList) {
                if (FormulaConstant.IGNORFORMULAS.contains(formula.get("number")) || !formula.get("catalog").equals(type) || !fors.contains(formula.get("number"))) continue;
                TreeNode node = new TreeNode();
                node.setId(formula.get("number"));
                String number = formula.get("number");
                if (number.contains("-")) {
                    number = formula.get("number").replace("-", "_");
                }
                String name = paramMultilingual.containsKey(number.toLowerCase(Locale.ENGLISH)) ? paramMultilingual.get(number.toLowerCase(Locale.ENGLISH)) : ResManager.loadKDString((String)formula.get("name"), (String)("RptFormulaPlugin_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                node.setText(formula.get("number") + name);
                node.setParentid("");
                tree.addNode(node);
                catalogList.add(node);
            }
        }
        this.getPageCache().put(catalog_list, SerializationUtils.serializeToBase64(catalogList));
        this.focusFirstNode(catalogList);
    }

    private void focusFirstNode(List<TreeNode> catalogList) {
        TreeView tree = (TreeView)this.getControl("formulatree");
        if (!catalogList.isEmpty()) {
            TreeNode node = catalogList.get(0);
            tree.focusNode(node);
            tree.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        String formula = this.getModel().getValue(TEXT_AREA_TAG).toString();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnconfirm": {
                if (StringUtils.isNotEmpty((CharSequence)formula)) {
                    this.returnFormulaToParent(formula);
                    break;
                }
                this.openFormulaEdit();
                break;
            }
            case "btnremove": {
                this.getModel().setValue(TEXT_AREA, (Object)"");
                this.getModel().setValue(TEXT_AREA_TAG, (Object)"");
                break;
            }
            case "btnformula": {
                List lstFormula = FormulaAnalyze.analyticFun((String)formula);
                if (lstFormula == null || lstFormula.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef,\u8bf7\u68c0\u67e5\u53f3\u4fa7\u8f93\u5165\u516c\u5f0f\u3002", (String)"RptFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.showListByFormula(formula);
                break;
            }
            default: {
                String character = operationCharacter.get(key);
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)TEXT_AREA_TAG, (String)character);
            }
        }
    }

    private void returnFormulaToParent(String formula) {
        formula = formula.replaceAll("\\p{C}", "");
        try {
            ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"RptFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)formula);
        this.getView().close();
    }

    private void showListByFormula(String formula) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(RPTMODEL_EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("formulas", (Object)formula);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RPT_CALLBACK);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openFormulaEdit() {
        TreeView tree = (TreeView)this.getControl("formulatree");
        String selectedNodeNumber = (String)tree.getTreeState().getSelectedNodeId().get(0);
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
        FormShowParameter parameter = new FormShowParameter();
        this.selectGuidePage(formula, parameter);
        parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u516c\u5f0f\u5411\u5bfc", (String)"RptFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula.getNumber()));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("is_commonpaper")) && formula.getNumber().equalsIgnoreCase("excrate")) {
            FormulaTicketer<DynamicObject> ticketer = InvestFormulaRegisterHelper.buildExcRateTicketer(formula, this.getModelId());
            parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
            parameter.setCustomParam("is_commonpaper", (Object)true);
            parameter.setFormId("bcm_invexrateformula");
        }
        if ("bcm_singleformula".equals(parameter.getFormId()) || "bcm_multiformula".equals(parameter.getFormId())) {
            parameter.setCustomParam("FLOAT_INFO", this.getFormCustomParam("FLOAT_INFO"));
        }
        parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setFormula");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void selectGuidePage(Formula formula, FormShowParameter parameter) {
        String ti = (String)this.getFormCustomParam("vticketer");
        if (StringUtils.isNotEmpty((CharSequence)ti)) {
            parameter.setCustomParam("vticketer", (Object)ti);
        }
        ShowFormulaUtil.selectGuidePage(formula, parameter, this.getModelId());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "cmbtype": {
                this.changeType();
                break;
            }
        }
    }

    private void changeType() {
        String type = (String)this.getModel().getValue("cmbtype");
        this.setFormulaTree(type);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "setFormula": {
                if (closedCallBackEvent.getReturnData() == null) break;
                String formula = closedCallBackEvent.getReturnData().toString();
                String oldtxt = this.getModel().getValue(TEXT_AREA_TAG).toString().trim();
                if (StringUtils.isNotBlank((CharSequence)oldtxt)) {
                    String str = oldtxt.substring(oldtxt.length() - 1);
                    if (!Arrays.asList(operators).contains(str)) {
                        oldtxt = oldtxt + " + ";
                    }
                }
                String newformula = oldtxt + formula;
                this.returnFormulaToParent(newformula);
                break;
            }
            case "formulaedit": {
                String selectedNodeNumber;
                Map formulaMap;
                if (closedCallBackEvent.getReturnData() == null || (formulaMap = (Map)closedCallBackEvent.getReturnData()) == null) break;
                String formula = (String)formulaMap.get("formula");
                if (formulaMap.get("rowSelect") != null) {
                    this.getPageCache().put("rowSelect", formulaMap.get("rowSelect").toString());
                }
                if (FormulaConstant.IGNORFORMULAS.contains(selectedNodeNumber = formula.substring(0, formula.indexOf(40)).toLowerCase(Locale.ENGLISH))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u4e0d\u5b58\u5728\u516c\u5f0f\u5411\u5bfc\u3002", (String)"RptFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showFormulaEdit(selectedNodeNumber, RPT_UPDATE_FORMULA, formula);
                break;
            }
            case "updateFormula": {
                if (closedCallBackEvent.getReturnData() != null) {
                    String formula = closedCallBackEvent.getReturnData().toString();
                    this.update2Formula(this.getModel(), formula);
                    break;
                }
                String formula = this.getModel().getValue(TEXT_AREA_TAG).toString();
                this.showListByFormula(formula);
                break;
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btnformula", "btnconfirm", "btnremove", "btnadd", "btnsubtract", "btnmultiply", "btndivide", "btnnotequal");
        operationCharacter.put("btnadd", "+");
        operationCharacter.put("btnsubtract", "-");
        operationCharacter.put("btnmultiply", "*");
        operationCharacter.put("btndivide", "/");
        operationCharacter.put("btnnotequal", "<>");
        TreeView tree = (TreeView)this.getControl("formulatree");
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                RptFormulaPlugin.this.refreshFormulaDescriptionAndContent();
            }

            public void treeNodeDoubleClick(TreeNodeEvent evt) {
                RptFormulaPlugin.this.openFormulaEdit();
            }
        });
        ISZH = ZHCN.equals(RequestContext.get().getLang().getLangTag());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvent -> {
            String text = searchEnterEvent.getText();
            this.searchAndFocusNode(text);
        });
    }

    private void searchAndFocusNode(String text) {
        String focusIndex;
        String str = this.getPageCache().get(catalog_list);
        List catalogList = (List)SerializationUtils.deSerializeFromBase64((String)str);
        TreeView tree = (TreeView)this.getControl("formulatree");
        ArrayList<Integer> formulaIndexs = new ArrayList<Integer>(5);
        for (int i = 0; i < catalogList.size(); ++i) {
            if (!((TreeNode)catalogList.get(i)).getText().contains(text)) continue;
            formulaIndexs.add(i);
        }
        String searchCacheStr = this.getPageCache().get("searchCache");
        Map searchMap = (Map)JSON.parseObject((String)searchCacheStr, Map.class);
        String string = focusIndex = searchMap != null ? (String)searchMap.get(text) : null;
        if (formulaIndexs.size() > 1) {
            if (focusIndex != null) {
                int index = formulaIndexs.indexOf(Integer.parseInt(focusIndex));
                if (formulaIndexs.size() == index + 1) {
                    focusIndex = this.nextFocus(catalogList, tree, formulaIndexs, 0);
                } else {
                    int focus = index + 1;
                    focusIndex = this.nextFocus(catalogList, tree, formulaIndexs, focus);
                }
            } else {
                focusIndex = this.nextFocus(catalogList, tree, formulaIndexs, 0);
            }
        } else if (formulaIndexs.size() == 1) {
            focusIndex = this.nextFocus(catalogList, tree, formulaIndexs, 0);
        }
        HashMap<String, String> searchCache = new HashMap<String, String>(1);
        if (focusIndex != null) {
            searchCache.put(text, focusIndex);
        }
        this.getPageCache().put("searchCache", JSON.toJSONString(searchCache));
    }

    private String nextFocus(List<TreeNode> catalogList, TreeView tree, List<Integer> formulaIndexs, int focus) {
        TreeNode treeNode = catalogList.get(formulaIndexs.get(focus));
        tree.focusNode(treeNode);
        tree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        String focusIndex = String.valueOf(formulaIndexs.get(focus));
        return focusIndex;
    }

    private void refreshFormulaDescriptionAndContent() {
        TreeView tree = (TreeView)this.getControl("formulatree");
        String selectedNodeNumber = (String)tree.getTreeState().getSelectedNodeId().get(0);
        Formula formula = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
        String number = formula.getNumber().toLowerCase(Locale.ENGLISH);
        String des_trans = " ";
        if (ISZH) {
            des_trans = ResManager.loadKDString((String)formula.getDescription(), (String)("RptFormulaPlugin_des_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            QFilter qFilter = new QFilter("paramnumber", "=", (Object)String.join((CharSequence)".", number, "description"));
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_formulamultilingual", (String)"paramnumber,name", (QFilter[])qFilter.toArray());
            String string = dy == null ? ResManager.loadKDString((String)formula.getDescription(), (String)("RptFormulaPlugin_des_" + number), (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (des_trans = dy.getLocaleString("name").getLocaleValue() == null ? dy.getLocaleString("name").getLocaleValue_zh_CN() : dy.getLocaleString("name").getLocaleValue());
        }
        if (des_trans != null) {
            this.getModel().setValue("txtdesc", (Object)des_trans.replace("?", "\n"));
        } else {
            this.getModel().setValue("txtdesc", (Object)"");
        }
    }

    protected void showFormulaEdit(String selectedNodeNumber, String actionId, String formula) {
        FormShowParameter parameter = new FormShowParameter();
        try {
            Formula formula1 = ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber);
            this.selectGuidePage(formula1, parameter);
            if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("is_commonpaper")) && formula1.getNumber().equalsIgnoreCase("excrate")) {
                FormulaTicketer<DynamicObject> ticketer = InvestFormulaRegisterHelper.buildExcRateTicketer(formula1, this.getModelId());
                parameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
                parameter.setCustomParam("is_commonpaper", (Object)true);
                parameter.setFormId("bcm_invexrateformula");
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u4e0d\u5b58\u5728\u516c\u5f0f\u5411\u5bfc\u3002", (String)"RptFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            String textFormula = this.getModel().getValue(TEXT_AREA_TAG).toString();
            this.showListByFormula(textFormula);
            return;
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        if (formula != null) {
            parameter.setCustomParam("formula", (Object)this.formula2LowerCase(formula));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private String formula2LowerCase(String formulaStr) {
        return ShowFormulaUtil.formula2LowerCase(formulaStr);
    }

    private void update2Formula(IDataModel model, String formula) {
        formula = this.formula2LowerCase(formula);
        String oldtxt = model.getValue(TEXT_AREA_TAG).toString().trim();
        List lstFormula = FormulaAnalyze.analyticFun((String)oldtxt);
        int row = 0;
        if (this.getPageCache().get("rowSelect") != null) {
            row = Integer.parseInt(this.getPageCache().get("rowSelect"));
        }
        StringBuilder subtxt = new StringBuilder();
        if (row > 0) {
            for (int i = 0; i < row; ++i) {
                String formulaStr = ((FunctionExpr)lstFormula.get(i)).toString().replaceAll(" ", "");
                formulaStr = this.formula2LowerCase(formulaStr);
                int indexOf = oldtxt.indexOf(formulaStr);
                subtxt.append(oldtxt, 0, indexOf + formulaStr.length());
                oldtxt = oldtxt.substring(indexOf + formulaStr.length());
            }
        }
        String expr = ((FunctionExpr)lstFormula.get(row)).toString().replaceAll(" ", "");
        expr = this.formula2LowerCase(expr);
        oldtxt = StringUtils.isEmpty((CharSequence)oldtxt) ? oldtxt : oldtxt.replaceAll(" ", "");
        int indexOf = oldtxt.toLowerCase(Locale.ENGLISH).indexOf(expr.toLowerCase(Locale.ENGLISH));
        subtxt.append(oldtxt, 0, indexOf);
        oldtxt = oldtxt.substring(indexOf + expr.length());
        this.getModel().setValue(TEXT_AREA_TAG, (Object)(subtxt + formula + oldtxt));
        this.getModel().setValue(TEXT_AREA, (Object)(subtxt + formula + oldtxt));
    }
}

