/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.formula.VDataFormulaServiceHelper;
import kd.fi.bcm.business.formula.enums.DataSourceTypeEnum;
import kd.fi.bcm.business.formula.enums.EPMDataTypeEnum;
import kd.fi.bcm.business.formula.enums.MetaDataTypeEnum;
import kd.fi.bcm.business.formula.enums.VDataTypeEnum;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.integration.model.IntegrateProperty;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.vo.EPMDataDetailVo;
import kd.fi.bcm.business.vo.EPMDataVo;
import kd.fi.bcm.business.vo.EbDimVo;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataEBVo;
import kd.fi.bcm.business.vo.VDataFormulaVo;
import kd.fi.bcm.business.vo.VDataIntegrateVo;
import kd.fi.bcm.business.vo.VDataPropertyVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.business.vo.VDataVoucherVo;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class VDataFormulaPlugin
extends AbstractBaseFormPlugin
implements TreeNodeClickListener {
    protected static final String TREEVIEW_AP = "treeviewap";
    protected static final String SOURCE = "source";
    protected static final String EXTMODEL = "extmodel";
    protected static final String RPTMODEL = "rptmodel";
    protected static final String ISEXT = "isext";
    protected static final String BCMMODEL = "bcmmodel";
    protected static final String EBMODEL = "ebmodel";
    protected static final String EBMODEL_SEL = "ebmodelsel";
    protected static final String ID = "id";
    protected static final String DIM = "dim";
    protected static final String NAME = "name";
    protected static final String NUMBER = "number";
    public static final String INTEGRATE = "integrate";
    public static final String EPMVOUCHER = "voucher";
    public static final String EPMTYPE = "epmtype";
    public static final String EPMMODEL = "epmmodel";
    protected static final String PROPERTY = "property";
    protected static final String EXT = "ext";
    protected static final String ROOT = "root";
    protected static final String SOURCEENTITY = "SourceEntity";
    protected static final String SE = "SE";
    protected static final String DEFCONDITION = "defcondition";
    protected static final String RETURNVALUE = "returnvalue";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String METADATATYPE = "metadatatype";
    protected static final String ISCMETADATA = "iscmetadata";
    protected static final String ENTRYENTITY_FIELD = "field";
    protected static final String ENTRYENTITY_TYPE = "type";
    protected static final String ENTRYENTITY_CONDITION = "condition";
    protected static final String ENTRYENTITY_ISAPPEAR = "isappear";
    protected static final String ENTRYENTITY_MEMMODEL = "memmodel";
    protected static final String TREE_NODE_CACHE = "treeNodeCache";
    protected static final String ENTRYENTITY_ISFLOAT = "isfloat";
    protected static final String ENTRYENTITY_MAPPING = "mapping";
    protected static final String ENTRYENTITY_VALUE = "fieldvalue";
    protected static final String ENTRYENTITY_DIM = "dim";
    protected static final String SHOW_VAR = "isShowSystemVariables";
    protected static final String MULTI_F7 = "MultiF7_";
    protected static final String DIMENSIONID = "dimensionid";
    protected static final String BCM_FORMULACONDITION = "bcm_formulacondition";
    protected static final String PREFIX1 = "Abc ";
    protected static final String PREFIX2 = " #  ";
    protected static final String BTN_DEL = "btn_del";
    protected static final String BTN_PREVIEW = "btn_preview";
    protected static final String BTN_OK = "btn_ok";
    public static final String PROP_ENTRYENTITY = "prop_entryentity";
    public static final String PROP_NAME = "prop_name";
    public static final String PROP_LABEL = "prop_label";
    public static final String DATA_TYPE = "data_type";
    public static final String DATA_SCHEMA = "data_schema";
    protected static final List<String> BCM_DIM = Lists.newArrayList((Object[])new String[]{"Entity", "Scenario", "Year", "Period", "Process", "Currency", "AuditTrail"});
    protected static final Set<String> EB_DIM = Sets.newHashSet((Object[])new String[]{"Entity", "Account", "BudgetPeriod", "Version", "Currency", "AuditTrail", "DataType", "Metric"});
    protected static final Set<String> CLEAR_PROPERTY = Sets.newHashSet((Object[])new String[]{"bcmmodel", "rptmodel", "ebmodel", "extmodel", "ebmodelsel", "metadatatype", "iscmetadata", "returnvalue", "epmmodel"});
    public static final Set<String> METADATANUMTYPE = Sets.newHashSet((Object[])new String[]{"decimal", "integer"});
    public static final Set<String> TABLENUMTYPE = Sets.newHashSet((Object[])new String[]{"bigint", "int", "decimal"});
    public static final Set<String> EPM_NUM_TYPE = Sets.newHashSet((Object[])new String[]{"decimal", "int", "long", "integer"});
    public static final String DECIMAL = "decimal";
    public static final String METANUMTYPE = "metanumtype";
    public static final String ISSINGLEFORMULA = "isSingleFormula";
    public static final String RETURN_FIELD = "returnField";
    public static final String FORMULA = "formula";
    public static final String RADIOGROUP_FIELD = "radiogroupfield";
    public static final String EPDM_DM = "epdm_dm";
    private static final Map<String, Set<String>> BTN_VISIBLE_MAP = MapInitHelper.ofMap((Object)DataSourceTypeEnum.MERGE_MODEL.getType(), (Object)Sets.newHashSet((Object[])new String[]{"bcmmodel", "isext", "defcondition"}), (Object)DataSourceTypeEnum.RPT_MODEL.getType(), (Object)Sets.newHashSet((Object[])new String[]{"rptmodel", "defcondition"}), (Object)DataSourceTypeEnum.EB_MODEL.getType(), (Object)Sets.newHashSet((Object[])new String[]{"ebmodel", "defcondition", "ebmodelsel"}), (Object)DataSourceTypeEnum.ISC_METADATA.getType(), (Object)Sets.newHashSet((Object[])new String[]{"metadatatype", "iscmetadata", "returnvalue"}), (Object)DataSourceTypeEnum.EPM_DATAMANAGE.getType(), (Object)Sets.newHashSet((Object[])new String[]{DataSourceTypeEnum.EPM_DATAMANAGE.getMark(), "returnvalue", "epmtype"}));
    public static final String METRIC_FIELD = "metricField";
    private static final List<String> FIRST_NODE_TYPE = Arrays.asList("dim", "integrate", "ext", "voucher");
    private static final List<String> SECOND_NODE_TYPE = Arrays.asList("number", "name", "property");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW_AP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        List<String> models = Arrays.asList(BCMMODEL, RPTMODEL, EBMODEL, EXTMODEL, ISCMETADATA, EBMODEL_SEL);
        for (String model : models) {
            BasedataEdit bcmModel = (BasedataEdit)this.getControl(model);
            if (bcmModel == null) continue;
            bcmModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit mapping = (BasedataEdit)this.getControl(ENTRYENTITY_MAPPING);
        if (mapping != null) {
            mapping.setF7BatchFill(false);
            mapping.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(ENTRYENTITY_CONDITION, BTN_DEL, BTN_PREVIEW, BTN_OK, EPMMODEL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildComboEdit();
        if (this.getFormCustomParam(FORMULA) != null && StringUtils.isNotEmpty((String)this.getFormCustomParam(FORMULA).toString())) {
            try {
                Long modelId;
                String modelShowNum;
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormula((String)this.getFormCustomParam(FORMULA).toString());
                this.setValue(SOURCE, formulaVo.getType().getVal());
                this.cleanAllData();
                this.setValue(RADIOGROUP_FIELD, "None".equals(formulaVo.getDefaultCon()) ? "1" : "2");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{EXTMODEL});
                this.getView().setVisible(Boolean.valueOf(false), (String[])BTN_VISIBLE_MAP.values().stream().flatMap(Collection::stream).distinct().toArray(String[]::new));
                this.getView().setVisible(Boolean.valueOf(true), BTN_VISIBLE_MAP.getOrDefault(formulaVo.getType().getVal(), Collections.emptySet()).toArray(new String[0]));
                if (formulaVo.getType() == VDataTypeEnum.CM || formulaVo.getType() == VDataTypeEnum.CM_ETX) {
                    this.setValue(RETURNVALUE, formulaVo.getReturnFields());
                    modelShowNum = formulaVo.getModelNum();
                    modelId = MemberReader.findModelIdByShowNum((String)modelShowNum);
                    this.setValue(DataSourceTypeEnum.MERGE_MODEL.getMark(), modelId);
                    if (formulaVo.getType() == VDataTypeEnum.CM_ETX) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{EXTMODEL, RETURNVALUE});
                        this.setValue(ISEXT, true);
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFCONDITION});
                        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)ID, (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter(NUMBER, "=", (Object)formulaVo.getExtNum())).toArray());
                        if (extModel == null) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"VDataFormulaPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.setValue(EXTMODEL, extModel.get(ID));
                        this.initExtModelTree(true);
                        if (this.isSingleFormula() && !CollectionUtil.isEmpty((Collection)formulaVo.getReturnFields())) {
                            this.setValue(RETURNVALUE, formulaVo.getReturnFields().get(0));
                        }
                    } else {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{EXTMODEL});
                        this.initBcmModelTree(true);
                    }
                } else if (formulaVo.getType() == VDataTypeEnum.ISC) {
                    this.setValue(METADATATYPE, formulaVo.getModelNum());
                    DynamicObject dyn = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)formulaVo.getExtNum())});
                    if (dyn == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"VDataFormulaPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[]{formulaVo.getExtNum()}));
                        return;
                    }
                    this.setValue(DataSourceTypeEnum.ISC_METADATA.getMark(), dyn.getLong(ID));
                    List IntegratePropertyList = VDataFormulaUtils.getMetadataProperty((String)formulaVo.getModelNum(), (String)formulaVo.getExtNum());
                    this.initIntegrateTreeData(IntegratePropertyList);
                    if (this.isSingleFormula() && !CollectionUtil.isEmpty((Collection)formulaVo.getReturnFields())) {
                        this.setValue(RETURNVALUE, formulaVo.getReturnFields().get(0));
                    }
                    if (!this.isSingleFormula()) {
                        this.setValue("is_sum", formulaVo.isAgg());
                    }
                } else if (formulaVo.getType() == VDataTypeEnum.RPT) {
                    modelShowNum = formulaVo.getModelNum();
                    modelId = MemberReader.findModelIdByShowNum((String)modelShowNum);
                    this.setValue(DataSourceTypeEnum.RPT_MODEL.getMark(), modelId);
                    this.initBcmModelTree(true);
                } else if (formulaVo.getType() == VDataTypeEnum.EB) {
                    modelShowNum = formulaVo.getModelNum();
                    DynamicObjectCollection models = QueryServiceHelper.query((String)DataSourceTypeEnum.EB_MODEL.getFormId(), (String)ID, (QFilter[])new QFilter("shownumber", "=", (Object)modelShowNum).toArray());
                    if (!models.isEmpty()) {
                        long modelId2 = ((DynamicObject)models.get(0)).getLong(ID);
                        this.setValue(EBMODEL, modelId2);
                        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId2);
                        qfBuilder.and(NUMBER, "=", (Object)formulaVo.getExtNum());
                        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"eb_dataset", (String)ID, (QFilter[])qfBuilder.toArray());
                        if (!dataSet.isEmpty()) {
                            long dataSetId = ((DynamicObject)dataSet.get(0)).getLong(ID);
                            this.setValue(EBMODEL_SEL, dataSetId);
                            this.initEBModelTree(true);
                        }
                    }
                } else if (formulaVo.getType() == VDataTypeEnum.EPM) {
                    this.setValue(EPMTYPE, EPMDataTypeEnum.getByValue((String)formulaVo.getModelNum()).getValue());
                    this.setValue(EPMMODEL, formulaVo.getExtNum());
                    this.initEPMModelTree();
                    if (this.isSingleFormula() && !CollectionUtil.isEmpty((Collection)formulaVo.getReturnFields())) {
                        this.setValue(RETURNVALUE, formulaVo.getReturnFields().get(0));
                    }
                    if (!this.isSingleFormula()) {
                        this.setValue("is_sum", formulaVo.isAgg());
                    }
                }
                List conditionVos = formulaVo.getColumnVos();
                if (!CollectionUtils.isNotEmpty((Collection)conditionVos) || !StringUtils.isNotEmpty((String)this.getPageCache().get(TREE_NODE_CACHE))) return;
                Map treeNodeMap = (Map)this.deSerializedBytes(this.getPageCache().get(TREE_NODE_CACHE));
                int index = 0;
                for (VDataRowVo conditionVo : conditionVos) {
                    TreeNode treeNode = this.getTreeNodeByCondition(conditionVo, treeNodeMap);
                    if (treeNode != null) {
                        this.addRightConditionRow(treeNode.getId(), treeNodeMap);
                        this.setRightConditionValue(formulaVo, conditionVo, index);
                        if (formulaVo.isSingleFormula()) {
                            if (conditionVo.isFloat()) {
                                this.getModel().setValue(ENTRYENTITY_ISFLOAT, (Object)true, index);
                                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ENTRYENTITY_CONDITION});
                                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ENTRYENTITY_MAPPING});
                                String dimNum = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.getFormCustomParam("KEY_MODEL_ID"))).getOrDefault(conditionVo.getFloatMapping(), conditionVo.getFloatMapping());
                                this.getModel().setValue(ENTRYENTITY_MAPPING, (Object)MemberReader.getDimensionIdByNum((long)((Long)this.getFormCustomParam("KEY_MODEL_ID")), (String)dimNum), index);
                                this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)"@", index);
                            }
                        } else {
                            this.getView().getModel().setValue(ENTRYENTITY_ISAPPEAR, (Object)conditionVo.isShow(), index);
                        }
                    }
                    ++index;
                }
                return;
            }
            catch (Exception ex) {
                this.getView().showTipNotification(ex.getMessage());
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BCMMODEL, RPTMODEL, EBMODEL, EBMODEL_SEL, ISEXT, EXTMODEL, METADATATYPE, ISCMETADATA});
                return;
            }
        } else {
            this.setDefaultSource();
            this.initModelTree();
        }
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public void setValue(String sign, Object value) {
        if (this.getView().getControl(sign) != null) {
            this.setValue(sign, value, true);
        }
    }

    private void setRightConditionValue(VDataFormulaVo formulaVo, VDataRowVo conditionVo, int rowIndex) {
        if (conditionVo instanceof VDataDimNodeVo && formulaVo.getType() != VDataTypeEnum.ISC) {
            MultiF7Results f7Results = ((VDataDimNodeVo)conditionVo).getMultiF7Results();
            String condition = f7Results.getShowText();
            if (StringUtils.isEmpty((String)f7Results.getShowText())) {
                condition = conditionVo.getCondition();
            }
            if ("*".equals(condition)) {
                this.getPageCache().remove(MULTI_F7 + this.getModel().getValue(ENTRYENTITY_VALUE, rowIndex));
            } else {
                this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)condition, rowIndex);
                this.getPageCache().put(MULTI_F7 + this.getModel().getValue(ENTRYENTITY_VALUE, rowIndex), SerializationUtils.toJsonString((Object)f7Results.toList()));
            }
            this.getPageCache().put(SE.equals(conditionVo.getNumber()) ? SOURCEENTITY : conditionVo.getDimNum(), SerializationUtils.toJsonString((Object)f7Results.toList()));
        } else if (!"*".equals(conditionVo.getCondition())) {
            this.getView().getModel().setValue(ENTRYENTITY_CONDITION, (Object)conditionVo.getCondition(), rowIndex);
        }
    }

    private TreeNode getTreeNodeByCondition(VDataRowVo conditionVo, Map<String, TreeNode> treeNodeMap) {
        if (conditionVo instanceof VDataDimNodeVo) {
            for (String dim : FIRST_NODE_TYPE) {
                String tempId = conditionVo.getNumber() + '|' + dim;
                if (dim.equals("dim")) {
                    Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.getModelNumber());
                    if (shortMap.containsKey(conditionVo.getNumber())) {
                        tempId = (String)shortMap.get(conditionVo.getNumber()) + '|' + "dim";
                    } else if (SE.equals(conditionVo.getNumber())) {
                        tempId = "SourceEntity|dim";
                    }
                }
                if (treeNodeMap.get(tempId) == null) continue;
                return treeNodeMap.get(tempId);
            }
        } else {
            if (conditionVo instanceof VDataEBVo) {
                String tempId = "";
                tempId = ((VDataEBVo)conditionVo).getProperty() == null ? conditionVo.getDimNum() + '|' + "dim" : conditionVo.getDimNum() + '|' + ((VDataEBVo)conditionVo).getProperty();
                return treeNodeMap.get(tempId);
            }
            if (conditionVo instanceof VDataIntegrateVo) {
                return treeNodeMap.get(conditionVo.getNumber() + '|' + INTEGRATE);
            }
            if (conditionVo instanceof VDataVoucherVo) {
                return treeNodeMap.get(conditionVo.getNumber() + '|' + EPMVOUCHER);
            }
            for (String dim : SECOND_NODE_TYPE) {
                String tempId = PROPERTY.equals(dim) ? conditionVo.getDimNum() + '|' + ((VDataPropertyVo)conditionVo).getProperty() + '|' + dim : conditionVo.getDimNum() + '|' + dim;
                if (treeNodeMap.get(tempId) == null) continue;
                return treeNodeMap.get(tempId);
            }
        }
        return null;
    }

    private void initModelTree() {
        this.getModel().setValue(BCMMODEL, (Object)LongUtil.toLong((Object)this.getFormCustomParam("KEY_MODEL_ID")));
        this.initBcmModelTree(false);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        switch (key) {
            case "condition": {
                if (grid.getSelectRows().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"VDataFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int index = grid.getSelectRows()[0];
                String rowValue = this.getModel().getValue(ENTRYENTITY_VALUE, index).toString();
                if (rowValue.endsWith("|dim")) {
                    if (this.getModel().getValue(ENTRYENTITY_MEMMODEL, index) != null && StringUtils.isEmpty((String)this.getModel().getValue(ENTRYENTITY_MEMMODEL, index).toString())) {
                        String dim = rowValue.split("\\|")[0];
                        if (this.getModel().getValue(ENTRYENTITY_CONDITION, index) == null || StringUtils.isEmpty((String)this.getModel().getValue(ENTRYENTITY_CONDITION, index).toString())) {
                            this.getView().getPageCache().remove(MULTI_F7 + rowValue);
                            this.getView().getPageCache().remove(dim);
                        }
                        this.openMultiF7(dim);
                        break;
                    }
                    String mems = this.getModel().getValue(ENTRYENTITY_CONDITION, index) == null ? "" : this.getModel().getValue(ENTRYENTITY_CONDITION, index).toString();
                    String dim = rowValue.split("\\|")[0];
                    this.openMemModel(dim, this.getModel().getValue(ENTRYENTITY_MEMMODEL, index).toString(), mems);
                    break;
                }
                Object value = this.getModel().getValue(ENTRYENTITY_CONDITION, index);
                this.openConditionForm(this.getModel().getValue(ENTRYENTITY_FIELD, index).toString(), value.toString());
                break;
            }
            case "btn_del": {
                if (grid.getSelectRows().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"VDataFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int index2 = grid.getSelectRows()[0];
                String rowValue2 = this.getModel().getValue(ENTRYENTITY_VALUE, index2).toString();
                if (this.isExtFormula() && rowValue2.endsWith("dim") && BCM_DIM.contains(rowValue2.split("\\|")[0])) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u53d6\u6570\u65f6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5fc5\u5f55\u6761\u4ef6\u7ef4\u5ea6%s\u3002", (String)"VDataFormulaPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowValue2.split("\\|")[0]));
                    return;
                }
                if (this.isEB() && rowValue2.endsWith("dim") && EB_DIM.contains(rowValue2.split("\\|")[0])) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5fc5\u5f55\u6761\u4ef6\u7ef4\u5ea6%s\u3002", (String)"VDataFormulaPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowValue2.split("\\|")[0]));
                    return;
                }
                if (rowValue2.endsWith("|dim")) {
                    DynamicObject[] dyns;
                    String dim = rowValue2.split("\\|")[0];
                    ArrayList<Integer> rowIndex = new ArrayList<Integer>(10);
                    int row = 0;
                    for (DynamicObject rowDyn : dyns = ((EntryGrid)this.getControl(ENTRYENTITY)).getEntryData().getDataEntitys()) {
                        if (StringUtils.isNotEmpty((String)rowDyn.getString("dim")) && dim.equals(rowDyn.getString("dim"))) {
                            rowIndex.add(row);
                        }
                        ++row;
                    }
                    int[] rows = new int[rowIndex.size()];
                    for (int i = 0; i < rowIndex.size(); ++i) {
                        rows[i] = (Integer)rowIndex.get(i);
                    }
                    this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                    break;
                }
                this.getModel().deleteEntryRow(ENTRYENTITY, index2);
                break;
            }
            case "btn_preview": {
                if (!this.checkMustInput()) {
                    return;
                }
                List<String> dims = this.checkVarDim();
                if (!dims.isEmpty()) {
                    this.showDataSelectForm(dims);
                    break;
                }
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormulaFromView((IFormView)this.getView(), (boolean)this.isSingleFormula(), Collections.emptyMap());
                Map dimMap = (Map)this.getView().getFormShowParameter().getCustomParam("FLOAT_INFO");
                formulaVo = VDataFormulaUtils.transferMultiRow((VDataFormulaVo)formulaVo, (Map)dimMap);
                this.showPreviewForm(formulaVo);
                break;
            }
            case "epmmodel": {
                ListShowParameter formShowParameter = new ListShowParameter();
                formShowParameter.setBillFormId(EPDM_DM);
                formShowParameter.setFormId("epdm_dm_f7");
                EPMDataTypeEnum typeEnum = EPMDataTypeEnum.getByValue((String)((String)this.getModel().getValue(EPMTYPE)));
                formShowParameter.getListFilterParameter().setFilter(new QFilter("type.number", "=", (Object)("DataModel." + typeEnum.getType())));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPDM_DM));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960px");
                css.setHeight("580px");
                formShowParameter.getOpenStyle().setInlineStyleCss(css);
                formShowParameter.setShowTitle(false);
                formShowParameter.setMultiSelect(false);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "btn_ok": {
                if (!this.checkMustInput()) {
                    return;
                }
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormulaFromView((IFormView)this.getView(), (boolean)this.isSingleFormula(), Collections.emptyMap());
                this.getView().returnDataToParent((Object)formulaVo.toExcelFormula());
                this.getView().close();
            }
        }
    }

    private void openMemModel(String dim, String entityForm, String mems) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_listf7");
        parameter.setBillFormId(entityForm);
        parameter.setShowApproved(true);
        parameter.setShowUsed(true);
        parameter.setLookUp(true);
        parameter.setShowFilter(false);
        parameter.setShowQuickFilter(false);
        parameter.setShowTitle(false);
        parameter.setMultiSelect(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("model", "=", (Object)this.getModelId()));
        qFilters.add(new QFilter("dimension.number", "=", (Object)dim));
        if (!dim.equals("BudgetPeriod")) {
            qFilters.add(new QFilter(NUMBER, "in", (Object)VDataFormulaServiceHelper.getDimMember((String)((DynamicObject)this.getModel().getValue(EBMODEL)).getString("shownumber"), (String)((DynamicObject)this.getModel().getValue(EBMODEL_SEL)).getString(NUMBER), (String)dim)));
        }
        if ("Currency".equals(dim)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u5e01\u79cd\u6210\u5458", (String)"VDataFormulaPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)mems)) {
            String[] nums = mems.split(",");
            ArrayList<QFilter> list = new ArrayList<QFilter>(qFilters);
            list.add(new QFilter(NUMBER, "in", Arrays.asList(nums)));
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)entityForm, (String)ID, (QFilter[])list.toArray(new QFilter[0]));
            parameter.setSelectedRows(dyns.stream().map(dyn -> dyn.getLong(ID)).toArray());
        }
        parameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTRYENTITY_MEMMODEL);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.setCloseCallBack(closeCallBack);
        parameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean checkMustInput() {
        String value;
        if (this.isExtFormula() && this.getValue(EXTMODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"VDataFormulaPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.isSingleFormula() && (this.isExtFormula() || this.isISC() || this.isEPMSource()) && StringUtils.isEmpty((String)(value = (String)this.getModel().getValue(RETURNVALUE)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ea6\u91cf\u503c\u3002", (String)"VDataFormulaPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entities = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entities.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u5b57\u6bb5\u3002", (String)"VDataFormulaPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set metricFields = new HashSet(16);
        String metricFieldStr = this.getPageCache().getBigObject(METRIC_FIELD);
        if (StringUtils.isNotBlank((String)metricFieldStr)) {
            metricFields = (Set)SerializationUtils.deSerializeFromBase64((String)metricFieldStr);
        }
        Map sourceDimMap = MemberReader.getDimNumberMapNameById((long)((Long)this.getFormCustomParam("KEY_MODEL_ID")));
        boolean haveMetric = false;
        for (int i = 0; i < entities.size(); ++i) {
            List f7result;
            DynamicObject e = (DynamicObject)entities.get(i);
            String mf7Str = this.getPageCache().get(MULTI_F7 + e.getString(ENTRYENTITY_VALUE));
            String fieldNumber = e.getString(ENTRYENTITY_VALUE).split("\\|")[0];
            if (StringUtils.isNotBlank((String)mf7Str) && !CollectionUtil.isEmpty((Collection)(f7result = (List)SerializationUtils.fromJsonString((String)mf7Str, List.class))) && SystemVarsEnum.CURRENT.getNumber().equalsIgnoreCase((String)((Map)f7result.get(0)).get(NUMBER)) && !sourceDimMap.containsKey(fieldNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7ef4\u5ea6\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u8bbe\u7f6e\u3002", (String)"VDataFormulaPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[]{e.getString(ENTRYENTITY_FIELD)}));
                return false;
            }
            if (e.getBoolean(ENTRYENTITY_ISFLOAT) && e.get(ENTRYENTITY_MAPPING) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c%s\u884c\u7684\u6d6e\u52a8\u6620\u5c04\u3002", (String)"VDataFormulaPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (this.isSingleFormula() && e.getString(ENTRYENTITY_VALUE).endsWith("|dim") && StringUtils.isEmpty((String)e.getString(ENTRYENTITY_CONDITION))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c%s\u884c\u7684\u6761\u4ef6\u3002", (String)"VDataFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            if (!this.isISC()) continue;
            if (this.isSingleFormula()) {
                if (e.getBoolean(ENTRYENTITY_ISFLOAT) || !StringUtils.isEmpty((String)e.getString(ENTRYENTITY_CONDITION))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c%s\u884c\u7684\u6761\u4ef6\u3002", (String)"VDataFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            if (!metricFields.contains(fieldNumber) || !e.getBoolean(ENTRYENTITY_ISAPPEAR)) continue;
            haveMetric = true;
        }
        if (this.isISC() && !this.isSingleFormula() && !haveMetric) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u9009\u62e9\u4e00\u4e2a\u5ea6\u91cf\u5b57\u6bb5\u4e3a\u663e\u793a\u5217\u3002", (String)"VDataFormulaPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isISC() {
        return DataSourceTypeEnum.ISC_METADATA.getType().equals(this.getModel().getValue(SOURCE));
    }

    private boolean isEB() {
        return DataSourceTypeEnum.EB_MODEL.getType().equals(this.getModel().getValue(SOURCE));
    }

    private boolean isEPMSource() {
        return DataSourceTypeEnum.EPM_DATAMANAGE.getType().equals(this.getModel().getValue(SOURCE));
    }

    private void showDataSelectForm(List<String> dims) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_formulaselect");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("SHOW_DIMS", dims);
        formShowParameter.setCustomParam("SHOW_DIM_NUM_MAP", Collections.emptyMap());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_formulaselect"));
        this.getView().showForm(formShowParameter);
    }

    private List<String> checkVarDim() {
        DynamicObjectCollection entities = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList dims = Lists.newArrayList();
        for (DynamicObject entity : entities) {
            String cache;
            if (!"dim".equals(entity.getString(ENTRYENTITY_TYPE)) || !StringUtils.isNotEmpty((String)(cache = this.getPageCache().get(MULTI_F7 + entity.get(ENTRYENTITY_VALUE)))) || !cache.contains("$Cur") || !StringUtils.isNotEmpty((String)entity.getString(ENTRYENTITY_VALUE)) || !entity.getString(ENTRYENTITY_VALUE).contains("|")) continue;
            String dim = entity.getString(ENTRYENTITY_VALUE).split("\\|")[0];
            dims.add(dim);
        }
        return dims;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        try {
            switch (propertyName) {
                case "source": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{EXTMODEL});
                    this.getView().setVisible(Boolean.valueOf(false), (String[])BTN_VISIBLE_MAP.values().stream().flatMap(Collection::stream).distinct().toArray(String[]::new));
                    this.getView().setVisible(Boolean.valueOf(true), BTN_VISIBLE_MAP.getOrDefault(value.toString(), Collections.emptySet()).toArray(new String[0]));
                    this.cleanAllData();
                    if (!Objects.equals(value, DataSourceTypeEnum.MERGE_MODEL.getType())) return;
                    this.initModelTree();
                    return;
                }
                case "isext": {
                    this.getModel().setValue(EXTMODEL, null);
                    tree.deleteAllNodes();
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    if (Objects.equals(true, value)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{ISEXT, EXTMODEL, RETURNVALUE});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFCONDITION});
                        return;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXTMODEL, RETURNVALUE});
                    if (!(this.getModel().getValue(BCMMODEL) instanceof DynamicObject)) return;
                    this.initBcmModelTree(false);
                    return;
                }
                case "bcmmodel": {
                    if (value != null) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{ISEXT});
                        this.getModel().setValue(ISEXT, (Object)false);
                        this.getModel().deleteEntryData(ENTRYENTITY);
                        this.initBcmModelTree(false);
                        return;
                    }
                    this.getModel().setValue(ISEXT, (Object)false);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{EXTMODEL});
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    tree.deleteAllNodes();
                    return;
                }
                case "rptmodel": {
                    if (value != null) {
                        this.getModel().deleteEntryData(ENTRYENTITY);
                        this.initBcmModelTree(false);
                        return;
                    }
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    tree.deleteAllNodes();
                    return;
                }
                case "extmodel": {
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    if (value != null) {
                        this.initExtModelTree(false);
                        return;
                    }
                    tree.deleteAllNodes();
                    this.buildMoneyComboEdit(null, Collections.emptyList());
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    return;
                }
                case "ebmodel": {
                    this.getModel().setValue(EBMODEL_SEL, null);
                    tree.deleteAllNodes();
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    return;
                }
                case "ebmodelsel": {
                    TreeView tree2 = (TreeView)this.getView().getControl(TREEVIEW_AP);
                    tree2.deleteAllNodes();
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    if (!(this.getModel().getValue(EBMODEL_SEL) instanceof DynamicObject)) return;
                    this.initEBModelTree(false);
                    return;
                }
                case "iscmetadata": {
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    DynamicObject iscDyn = (DynamicObject)this.getModel().getValue(ISCMETADATA);
                    List IntegratePropertyList = VDataFormulaUtils.getMetadataProperty((String)((String)this.getModel().getValue(METADATATYPE)), iscDyn == null ? null : iscDyn.getString(NUMBER));
                    this.initIntegrateTreeData(IntegratePropertyList);
                    return;
                }
                case "epmtype": {
                    this.getModel().setValue(EPMMODEL, null);
                }
                case "epmmodel": {
                    TreeView tree3 = (TreeView)this.getView().getControl(TREEVIEW_AP);
                    tree3.deleteAllNodes();
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    if (!this.getModel().getValue(EPMMODEL).toString().isEmpty()) {
                        this.initEPMModelTree();
                        return;
                    }
                    this.buildMoneyComboEdit(null, Collections.emptyList());
                    return;
                }
                case "isfloat": {
                    EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                    if (grid.getSelectRows().length <= 0) return;
                    int index = grid.getSelectRows()[0];
                    Map treeNodeMap = (Map)this.deSerializedBytes(this.getPageCache().get(TREE_NODE_CACHE));
                    String nodeText = ((TreeNode)treeNodeMap.get(this.getModel().getValue(ENTRYENTITY_VALUE, index).toString())).getText();
                    if (e.getChangeSet()[0].getNewValue() != null && ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                        if (this.getModel().getValue(ENTRYENTITY_TYPE, index) != null && FIRST_NODE_TYPE.contains(this.getModel().getValue(ENTRYENTITY_TYPE, index).toString()) && nodeText.startsWith(PREFIX1)) {
                            this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)"@", index);
                            this.getPageCache().remove(MULTI_F7 + this.getModel().getValue(ENTRYENTITY_VALUE, index));
                            this.getPageCache().remove(this.getModel().getValue("dim", index).toString());
                            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ENTRYENTITY_CONDITION});
                            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ENTRYENTITY_MAPPING});
                            String fieldNumber = grid.getEntryData().getDataEntitys()[index].getString(ENTRYENTITY_VALUE).split("\\|")[0];
                            int[] needDeleteIndexs = Arrays.stream(grid.getEntryData().getDataEntitys()).filter(d -> d.getString(ENTRYENTITY_VALUE).startsWith(fieldNumber + '|') && d.getInt("seq") != index + 1 || d.getString(ENTRYENTITY_VALUE).startsWith(fieldNumber + ".")).mapToInt(d -> d.getInt("seq") - 1).toArray();
                            if (needDeleteIndexs.length <= 0) return;
                            this.getModel().deleteEntryRows(ENTRYENTITY, needDeleteIndexs);
                            return;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u591a\u7ef4\u4e00\u7ea7\u5b57\u6bb5\u3001\u62d3\u5c55\u7ef4\u548c\u96c6\u6210\u5bf9\u8c61\u7684\u975e\u5ea6\u91cf\u5b57\u6bb5\u53ef\u4ee5\u52fe\u9009\u662f\u5426\u6d6e\u52a8\u3002", (String)"VDataFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue(ENTRYENTITY_ISFLOAT, e.getChangeSet()[0].getOldValue(), index);
                        return;
                    }
                    if (e.getChangeSet()[0].getNewValue() == null || ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) return;
                    this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)"", index);
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ENTRYENTITY_CONDITION});
                    this.getModel().setValue(ENTRYENTITY_MAPPING, null, index);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ENTRYENTITY_MAPPING});
                    return;
                }
                case "metadatatype": {
                    this.getModel().setValue(ISCMETADATA, null);
                }
            }
            return;
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    private void initEPMModelTree() {
        String number = this.getModel().getValue(EPMMODEL).toString();
        String type = EPMDataTypeEnum.getByValue((String)this.getModel().getValue(EPMTYPE).toString()).getType();
        EPMDataVo epmDataModel = VDataFormulaServiceHelper.getEPMDataModel((String)number, (String)type);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId(ROOT);
        root.isDisabled();
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList<TreeNode> nums = new ArrayList<TreeNode>(10);
        ArrayList<TreeNode> texts = new ArrayList<TreeNode>(10);
        for (EPMDataDetailVo detailVo : epmDataModel.getDetails()) {
            if (EPM_NUM_TYPE.contains(detailVo.getDataType())) {
                nums.add(this.createTreeNode(detailVo.getField() + '|' + EPMVOUCHER, PREFIX2 + detailVo.getLabel(), detailVo.getLabel(), ROOT));
                continue;
            }
            texts.add(this.createTreeNode(detailVo.getField() + '|' + EPMVOUCHER, PREFIX1 + detailVo.getLabel(), detailVo.getLabel(), ROOT));
        }
        root.addChildren(texts);
        root.addChildren(nums);
        allTreeNodeList.addAll(root.getChildren());
        tree.updateNode(root);
        tree.expand(ROOT);
        if (allTreeNodeList.isEmpty()) {
            this.getPageCache().remove(TREE_NODE_CACHE);
        } else {
            LinkedHashMap treeNodeMap = new LinkedHashMap(16);
            allTreeNodeList.forEach(node -> treeNodeMap.put(node.getId(), node));
            this.getPageCache().put(TREE_NODE_CACHE, this.toByteSerialized(treeNodeMap));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(RETURNVALUE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (!nums.isEmpty()) {
            for (TreeNode num : nums) {
                items.add(new ComboItem(new LocaleString(num.getData().toString()), num.getId().split("\\|")[0]));
            }
        }
        comboEdit.setComboItems(items);
    }

    private void initEBModelTree(boolean isEdit) {
        String modelNum = ((DynamicObject)this.getModel().getValue(EBMODEL)).getString("shownumber");
        String dataSetNum = ((DynamicObject)this.getModel().getValue(EBMODEL_SEL)).getString(NUMBER);
        List ebDimVos = VDataFormulaServiceHelper.getDim((String)modelNum, (String)dataSetNum);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId(ROOT);
        root.isDisabled();
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        this.createEBDimensionNode(root, ebDimVos, allTreeNodeList);
        tree.updateNode(root);
        tree.expand(ROOT);
        if (allTreeNodeList.isEmpty()) {
            this.getPageCache().remove(TREE_NODE_CACHE);
        } else {
            LinkedHashMap treeNodeMap = new LinkedHashMap(16);
            allTreeNodeList.forEach(node -> treeNodeMap.put(node.getId(), node));
            this.getPageCache().put(TREE_NODE_CACHE, this.toByteSerialized(treeNodeMap));
        }
        if (!isEdit) {
            for (EbDimVo ebDimVo : ebDimVos) {
                if (!EB_DIM.contains(ebDimVo.getNumber())) continue;
                this.addEntryRow(ebDimVo.getName(), "", null, "dim", ebDimVo.getNumber(), ebDimVo.getNumber() + '|' + "dim");
                EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
                DynamicObject[] entities = entryEntity.getEntryData().getDataEntitys();
                this.getModel().setValue(ENTRYENTITY_MEMMODEL, (Object)ebDimVo.getMemberModel(), entities.length - 1);
            }
        }
    }

    private void createEBDimensionNode(TreeNode root, List<EbDimVo> ebDimVos, List<TreeNode> nodeList) {
        String localName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"VDataFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String localNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"VDataFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        for (EbDimVo ebDimVo : ebDimVos) {
            String dimNodeId = ebDimVo.getNumber() + '|' + "dim";
            TreeNode dimNode = this.createTreeNode(dimNodeId, PREFIX1 + ebDimVo.getName(), ebDimVo.getName(), ROOT);
            nodeList.add(dimNode);
            root.addChild(dimNode);
            TreeNode nameNode = this.createTreeNode(ebDimVo.getNumber() + '|' + NAME, PREFIX1 + localName, ebDimVo.getName() + "-" + localName, dimNodeId);
            nodeList.add(nameNode);
            dimNode.addChild(nameNode);
            TreeNode numNode = this.createTreeNode(ebDimVo.getNumber() + '|' + NUMBER, PREFIX1 + localNumber, ebDimVo.getName() + "-" + localNumber, dimNodeId);
            nodeList.add(numNode);
            dimNode.addChild(numNode);
        }
    }

    private void initExtModelTree(boolean isEdit) {
        String cache;
        long modelId = ((DynamicObject)this.getModel().getValue(BCMMODEL)).getLong(ID);
        long extendId = ((DynamicObject)this.getModel().getValue(EXTMODEL)).getLong(ID);
        ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(extendId));
        ArrayList<String> allDim = new ArrayList<String>(BCM_DIM);
        List extDim = extendsModel.getDimFieldEntry().stream().map(entry -> entry.getDimension().getNumber()).collect(Collectors.toList());
        List<String> extCol = extendsModel.getExtFieldEntry().stream().map(entry -> entry.getExtField().getNumber()).collect(Collectors.toList());
        allDim.addAll(extDim);
        HashMap<String, DimPropList> propMap = new HashMap<String, DimPropList>(16);
        for (String dim : allDim) {
            long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dim);
            propMap.put(dim, DimPropList.getDimPropList((long)dimensionId));
        }
        this.initTreeNode(allDim, extCol, propMap, extendsModel);
        if (!isEdit && StringUtils.isNotEmpty((String)(cache = this.getPageCache().get(TREE_NODE_CACHE)))) {
            LinkedHashMap treeNodeMap = (LinkedHashMap)this.deSerializedBytes(cache);
            Map dimNumber2Name = MemberReader.getDimNumberMapNameById((long)this.getModelId());
            int i = 0;
            for (Map.Entry nodeEntry : treeNodeMap.entrySet()) {
                if (i >= 7) break;
                String nodeId = ((TreeNode)nodeEntry.getValue()).getId();
                if (!nodeId.endsWith("dim")) continue;
                String dimNumber = ((TreeNode)nodeEntry.getValue()).getId().split("\\|")[0];
                this.addEntryRow((String)dimNumber2Name.get(dimNumber), "", null, "dim", dimNumber, nodeId);
                ++i;
            }
        }
    }

    private void initIntegrateTreeData(List<IntegrateProperty> integratePropertyList) {
        LinkedHashMap treeNodeMap = new LinkedHashMap(16);
        LinkedHashMap<String, String> metricMap = new LinkedHashMap<String, String>(16);
        if (!integratePropertyList.isEmpty()) {
            TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
            tree.deleteAllNodes();
            TreeNode root = new TreeNode();
            root.setId(ROOT);
            integratePropertyList.forEach(integrateProperty -> {
                String propNumber = integrateProperty.getPropNumber();
                String treeNodeNumber = propNumber + '|' + INTEGRATE;
                String propLabel = integrateProperty.getPropLabel();
                String dataType = integrateProperty.getDataType();
                TreeNode firstMetadataNode = this.createTreeNode(treeNodeNumber, propLabel, propLabel, ROOT);
                firstMetadataNode.setType(dataType);
                treeNodeMap.put(treeNodeNumber, firstMetadataNode);
                String metadataType = (String)this.getModel().getValue(METADATATYPE);
                if (MetaDataTypeEnum.ENTITY.getType().equals(metadataType)) {
                    if (METADATANUMTYPE.contains(dataType)) {
                        firstMetadataNode.setText(PREFIX2 + firstMetadataNode.getText());
                        metricMap.put(propNumber, propLabel);
                    } else {
                        firstMetadataNode.setText(PREFIX1 + firstMetadataNode.getText());
                    }
                    List childPropertyList = integrateProperty.getChildPropertyList();
                    if (childPropertyList != null && !childPropertyList.isEmpty()) {
                        childPropertyList.forEach(childproperty -> {
                            String childPropNumber = childproperty.getPropNumber();
                            String childNodeNumber = childPropNumber + '|' + INTEGRATE;
                            String childPropLabel = childproperty.getPropLabel();
                            String childDataType = childproperty.getDataType();
                            TreeNode childMetadataNode = this.createTreeNode(childNodeNumber, propLabel + "_" + childPropLabel, propLabel + "_" + childPropLabel, treeNodeNumber);
                            childMetadataNode.setType(childDataType);
                            treeNodeMap.put(childNodeNumber, childMetadataNode);
                            if (METADATANUMTYPE.contains(childDataType)) {
                                childMetadataNode.setText(PREFIX2 + childMetadataNode.getText());
                                metricMap.put(childPropNumber, propLabel + "_" + childPropLabel);
                            } else {
                                childMetadataNode.setText(PREFIX1 + childMetadataNode.getText());
                            }
                            firstMetadataNode.addChild(childMetadataNode);
                        });
                    }
                } else if (MetaDataTypeEnum.TABLE.getType().equals(metadataType)) {
                    if (TABLENUMTYPE.contains(dataType)) {
                        firstMetadataNode.setText(PREFIX2 + firstMetadataNode.getText());
                        metricMap.put(propNumber, propLabel);
                    } else if (dataType.startsWith(DECIMAL)) {
                        firstMetadataNode.setText(PREFIX2 + firstMetadataNode.getText());
                        metricMap.put(propNumber, propLabel);
                    } else {
                        firstMetadataNode.setText(PREFIX1 + firstMetadataNode.getText());
                    }
                }
                root.addChild(firstMetadataNode);
            });
            tree.addNode(root);
            tree.expand(ROOT);
            this.getPageCache().put(TREE_NODE_CACHE, this.toByteSerialized(treeNodeMap));
        } else {
            TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
            tree.deleteAllNodes();
            this.getPageCache().remove(METANUMTYPE);
            this.getPageCache().remove(TREE_NODE_CACHE);
        }
        this.getPageCache().putBigObject(METRIC_FIELD, SerializationUtils.serializeToBase64(new HashSet(metricMap.keySet())));
        this.setMetricComboItems(metricMap);
    }

    private void setMetricComboItems(Map<String, String> metricMap) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(RETURNVALUE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (metricMap != null && !metricMap.isEmpty()) {
            for (Map.Entry<String, String> kv : metricMap.entrySet()) {
                items.add(new ComboItem(new LocaleString(kv.getValue()), kv.getKey()));
            }
        }
        comboEdit.setComboItems(items);
    }

    private void cleanAllData() {
        this.getModel().beginInit();
        CLEAR_PROPERTY.forEach(e -> this.getModel().setValue(e, null));
        this.getModel().setValue(ISEXT, (Object)false);
        this.getModel().setValue(RADIOGROUP_FIELD, (Object)"1");
        this.getModel().deleteEntryData(ENTRYENTITY);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        this.setMetricComboItems(null);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void initBcmModelTree(boolean isEdit) {
        long modelId = this.getModelId();
        Map dimMap = MemberReader.getDimNumberMapNameById((long)modelId);
        HashMap<String, DimPropList> propMap = new HashMap<String, DimPropList>(16);
        for (String dim : dimMap.keySet()) {
            long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dim);
            propMap.put(dim, DimPropList.getDimPropList((long)dimensionId));
        }
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId(ROOT);
        root.isDisabled();
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        this.createDimensionNode(new ArrayList<String>(dimMap.keySet()), propMap, root, allTreeNodeList);
        tree.updateNode(root);
        tree.expand(ROOT);
        if (allTreeNodeList.isEmpty()) {
            this.getPageCache().remove(TREE_NODE_CACHE);
        } else {
            LinkedHashMap treeNodeMap = new LinkedHashMap(16);
            allTreeNodeList.forEach(node -> treeNodeMap.put(node.getId(), node));
            this.getPageCache().put(TREE_NODE_CACHE, this.toByteSerialized(treeNodeMap));
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String cache = this.getPageCache().get(TREE_NODE_CACHE);
        if (StringUtils.isNotEmpty((String)cache)) {
            Map treeNodeMap = (Map)this.deSerializedBytes(cache);
            this.addRightConditionRow(nodeId, treeNodeMap);
            if (this.isSingleFormula()) {
                this.sortEntryData(treeNodeMap);
            }
        }
    }

    private void addRightConditionRow(String nodeId, Map<String, TreeNode> treeNodeMap) {
        if (this.isEB()) {
            String modelNum = ((DynamicObject)this.getModel().getValue(EBMODEL)).getString("shownumber");
            String dataSetNum = ((DynamicObject)this.getModel().getValue(EBMODEL_SEL)).getString(NUMBER);
            List ebDimVos = VDataFormulaServiceHelper.getDim((String)modelNum, (String)dataSetNum);
            String dim = nodeId.split("\\|")[0];
            Optional<EbDimVo> first = ebDimVos.stream().filter(dimVo -> dimVo.getNumber().equals(dim)).findFirst();
            if (nodeId.endsWith("|dim")) {
                first.ifPresent(ebDimVo -> {
                    int rowIndex = this.addEntryRow(ebDimVo.getName(), "", null, "dim", dim, nodeId);
                    this.getModel().setValue(ENTRYENTITY_MEMMODEL, (Object)ebDimVo.getMemberModel(), rowIndex - 1);
                });
            } else if (nodeId.endsWith("|number") || nodeId.endsWith("|name")) {
                String number = nodeId.substring(nodeId.lastIndexOf(124) + 1);
                first.ifPresent(ebDimVo -> {
                    int curRow = this.addEntryRow(ebDimVo.getName(), "", null, "dim", dim, dim + '|' + "dim");
                    this.getModel().setValue(ENTRYENTITY_MEMMODEL, (Object)ebDimVo.getMemberModel(), curRow - 1);
                    TreeNode treeNode = (TreeNode)treeNodeMap.get(nodeId);
                    curRow = this.addEntryRow(treeNode.getData().toString(), "", null, number, dim, nodeId);
                    this.getModel().setValue(ENTRYENTITY_MEMMODEL, (Object)ebDimVo.getMemberModel(), curRow - 1);
                });
            }
        } else if (nodeId.endsWith("|dim")) {
            Map dimName = MemberReader.getDimNumberMapNameById((long)this.getModelId());
            String dim = nodeId.split("\\|")[0];
            this.addEntryRow(SOURCEENTITY.equals(dim) ? ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"VDataFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (String)dimName.get(dim), "", null, "dim", dim, nodeId);
        } else if (nodeId.endsWith("|number")) {
            this.addSecondLevelNode(nodeId, treeNodeMap, NUMBER);
        } else if (nodeId.endsWith("|name")) {
            this.addSecondLevelNode(nodeId, treeNodeMap, NAME);
        } else if (nodeId.endsWith("|property")) {
            this.addSecondLevelNode(nodeId, treeNodeMap, PROPERTY);
        } else if (nodeId.endsWith("|integrate")) {
            TreeNode treeNode = treeNodeMap.get(nodeId);
            this.addEntryRow(treeNode.getData().toString(), "", null, INTEGRATE, "", nodeId);
        } else if (nodeId.endsWith("|voucher")) {
            TreeNode treeNode = treeNodeMap.get(nodeId);
            this.addEntryRow(treeNode.getData().toString(), "", null, EPMVOUCHER, "", nodeId);
        } else {
            TreeNode treeNode = treeNodeMap.get(nodeId);
            this.addEntryRow(treeNode.getData().toString(), "", null, EXT, "", nodeId);
        }
    }

    protected boolean isSingleFormula() {
        return true;
    }

    protected boolean isExtFormula() {
        return this.getModel().getValue(ISEXT) != null && (Boolean)this.getModel().getValue(ISEXT) != false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if (Objects.nonNull(closedCallBackEvent.getReturnData())) {
            if ("bcm_formulaselect".equals(key)) {
                Map dimNumMap = (Map)closedCallBackEvent.getReturnData();
                VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormulaFromView((IFormView)this.getView(), (boolean)this.isSingleFormula(), (Map)dimNumMap);
                Map dimMap = (Map)this.getView().getFormShowParameter().getCustomParam("FLOAT_INFO");
                formulaVo = VDataFormulaUtils.transferMultiRow((VDataFormulaVo)formulaVo, (Map)dimMap);
                this.showPreviewForm(formulaVo);
            } else if (ENTRYENTITY_MEMMODEL.equals(key)) {
                EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                int index = grid.getSelectRows()[0];
                if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                    String condition = ((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).stream().map(ListSelectedRow::getNumber).collect(Collectors.joining(","));
                    this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)condition, index);
                } else {
                    this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)"", index);
                }
            } else if (EPDM_DM.equals(key)) {
                if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                    if (!((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).isEmpty()) {
                        Object primaryKeyValue = ((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0).getPrimaryKeyValue();
                        DynamicObject one = QueryServiceHelper.queryOne((String)DataSourceTypeEnum.EPM_DATAMANAGE.getFormId(), (String)"id,catalog.number", (QFilter[])new QFilter(ID, "=", primaryKeyValue).toArray());
                        if (one != null && StringUtils.isNotEmpty((String)one.getString("catalog.number"))) {
                            this.getModel().setValue(EPMMODEL, (Object)(((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0).getNumber() + "," + one.getString("catalog.number")));
                        }
                    } else {
                        this.getModel().setValue(EPMMODEL, (Object)"");
                    }
                } else {
                    this.getModel().setValue(EPMMODEL, (Object)"");
                }
            } else {
                EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                if (grid.getSelectRows().length > 0) {
                    int index = grid.getSelectRows()[0];
                    if (key.equals(BCM_FORMULACONDITION) && Objects.nonNull(closedCallBackEvent.getReturnData())) {
                        this.getView().getModel().setValue(ENTRYENTITY_CONDITION, closedCallBackEvent.getReturnData(), index);
                    } else if (closedCallBackEvent.getReturnData() != null) {
                        DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                        MultiF7Results mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
                        if (doc.isEmpty()) {
                            this.getModel().setValue(ENTRYENTITY_CONDITION, null, index);
                            this.getPageCache().remove(MULTI_F7 + this.getModel().getValue(ENTRYENTITY_VALUE, index));
                            this.getPageCache().remove(key);
                        } else {
                            this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)mps.getShowText(), index);
                            this.getPageCache().put(MULTI_F7 + this.getModel().getValue(ENTRYENTITY_VALUE, index), SerializationUtils.toJsonString((Object)mps.toList()));
                            this.getPageCache().put(key, SerializationUtils.toJsonString((Object)mps.toList()));
                        }
                    }
                }
            }
        }
    }

    private void showPreviewForm(VDataFormulaVo formulaVo) {
        try {
            VDataFormulaUtils.hasPermission((VDataFormulaVo)formulaVo);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_formulapreview");
        formShowParameter.setCustomParam("PREVIEW_FORMULA", (Object)this.toByteSerialized(formulaVo.toFetchDataString()));
        formShowParameter.setCustomParam(ISSINGLEFORMULA, (Object)formulaVo.isSingleFormula());
        formShowParameter.setCustomParam(RETURN_FIELD, (Object)VDataFormulaUtils.getReturnField((IFormView)this.getView(), (boolean)this.isSingleFormula()));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void sortEntryData(Map<String, TreeNode> treeNodeMap) {
        DynamicObject[] rows = ((EntryGrid)this.getControl(ENTRYENTITY)).getEntryData().getDataEntitys();
        if (rows.length > 0) {
            HashMap<String, Integer> sortMap = new HashMap<String, Integer>(16);
            int index = 0;
            for (String key : treeNodeMap.keySet()) {
                sortMap.put(key, index);
                ++index;
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rows.length);
            List entities = Arrays.stream(rows).sorted(Comparator.comparingInt(ind -> (Integer)sortMap.get(ind.getString(ENTRYENTITY_VALUE)))).collect(Collectors.toList());
            index = 0;
            for (DynamicObject dyn : entities) {
                this.getModel().setValue(ENTRYENTITY_FIELD, (Object)dyn.getString(ENTRYENTITY_FIELD), index);
                this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)dyn.getString(ENTRYENTITY_CONDITION), index);
                this.getModel().setValue(ENTRYENTITY_ISFLOAT, (Object)dyn.getBoolean(ENTRYENTITY_ISFLOAT), index);
                this.getModel().setValue(ENTRYENTITY_MAPPING, (Object)dyn.getDynamicObject(ENTRYENTITY_MAPPING), index);
                this.getModel().setValue(ENTRYENTITY_TYPE, (Object)dyn.getString(ENTRYENTITY_TYPE), index);
                this.getModel().setValue("dim", (Object)dyn.getString("dim"), index);
                this.getModel().setValue(ENTRYENTITY_VALUE, (Object)dyn.getString(ENTRYENTITY_VALUE), index);
                this.getModel().setValue(ENTRYENTITY_MEMMODEL, (Object)dyn.getString(ENTRYENTITY_MEMMODEL), index);
                if (dyn.getBoolean(ENTRYENTITY_ISFLOAT)) {
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ENTRYENTITY_MAPPING});
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ENTRYENTITY_CONDITION});
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ENTRYENTITY_MAPPING});
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ENTRYENTITY_CONDITION});
                }
                ++index;
            }
        }
    }

    private void openConditionForm(String name, String condition) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(BCM_FORMULACONDITION);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(ENTRYENTITY_CONDITION, (Object)condition);
        fsp.setCaption(String.format(ResManager.loadKDString((String)"%s\u6761\u4ef6\u8bbe\u7f6e", (String)"VDataFormulaPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BCM_FORMULACONDITION));
        this.getView().showForm(fsp);
    }

    private void openMultiF7(String sign) {
        String dim;
        FormShowParameter para = new FormShowParameter();
        String captionPrefix = "";
        if (SOURCEENTITY.equals(sign)) {
            dim = DimTypesEnum.ENTITY.getNumber();
            captionPrefix = ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"VDataFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            dim = sign;
        }
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dim);
        DynamicObject dimensionDynById = MemberReader.getDimensionDynById((long)dimensionId);
        String string = captionPrefix = "".equals(captionPrefix) ? dimensionDynById.getString(NAME) : captionPrefix;
        if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dim)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        params.put(DIMENSIONID, String.valueOf(dimensionId));
        params.put("sign", sign);
        if (this.isSingleFormula()) {
            params.put(SHOW_VAR, SystemVarsEnum.getReportVars());
        }
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), captionPrefix));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sign);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void addSecondLevelNode(String nodeId, Map<String, TreeNode> treeNodeMap, String number) {
        Map dimName = MemberReader.getDimNumberMapNameById((long)this.getModelId());
        TreeNode treeNode = treeNodeMap.get(nodeId);
        String dim = nodeId.split("\\|")[0];
        this.addEntryRow(SOURCEENTITY.equals(dim) ? ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"VDataFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (String)dimName.get(dim), "", null, "dim", dim, dim + '|' + "dim");
        this.addEntryRow(treeNode.getData().toString(), "", null, number, dim, nodeId);
    }

    private int addEntryRow(String fieldName, String condition, DynamicObject mapping, String type, String dim, String fieldValue) {
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject[] entities = entryEntity.getEntryData().getDataEntitys();
        boolean match = Arrays.stream(entities).anyMatch(ent -> ent.getString(ENTRYENTITY_TYPE).equals(type) && ent.getString(ENTRYENTITY_VALUE).equals(fieldValue));
        int current = entities.length;
        if (!match) {
            this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue(ENTRYENTITY_FIELD, (Object)fieldName, entities.length);
            this.getModel().setValue(ENTRYENTITY_CONDITION, (Object)condition, entities.length);
            this.getModel().setValue(ENTRYENTITY_MAPPING, (Object)mapping, entities.length);
            this.getModel().setValue(ENTRYENTITY_TYPE, (Object)type, entities.length);
            this.getModel().setValue("dim", (Object)dim, entities.length);
            this.getModel().setValue(ENTRYENTITY_VALUE, (Object)fieldValue, entities.length);
            this.getView().setEnable(Boolean.valueOf(false), entities.length, new String[]{ENTRYENTITY_MAPPING});
            ++current;
        }
        return current;
    }

    private void initTreeNode(List<String> allDim, List<String> extCol, Map<String, DimPropList> propMap, ExtendsModel extendsModel) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId(ROOT);
        root.isDisabled();
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        this.createDimensionNode(allDim, propMap, root, allTreeNodeList);
        this.addSourceEntityNode(root, allTreeNodeList);
        this.createExtNode(extendsModel, extCol, root, allTreeNodeList);
        tree.updateNode(root);
        tree.expand(ROOT);
        if (allTreeNodeList.isEmpty()) {
            this.getPageCache().remove(TREE_NODE_CACHE);
        } else {
            LinkedHashMap treeNodeMap = new LinkedHashMap(16);
            allTreeNodeList.forEach(node -> treeNodeMap.put(node.getId(), node));
            this.getPageCache().put(TREE_NODE_CACHE, this.toByteSerialized(treeNodeMap));
        }
    }

    private void addSourceEntityNode(TreeNode root, List<TreeNode> nodeList) {
        String localName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"VDataFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String localNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"VDataFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String sourceName = ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"VDataFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        TreeNode sourceNode = this.createTreeNode("SourceEntity|dim", PREFIX1 + sourceName, sourceName, ROOT);
        nodeList.add(sourceNode);
        root.addChild(sourceNode);
        TreeNode sourceNameNode = this.createTreeNode("SourceEntity|name", PREFIX1 + localName, sourceName + "-" + localName, SOURCEENTITY);
        nodeList.add(sourceNameNode);
        sourceNode.addChild(sourceNameNode);
        TreeNode sourceNumNode = this.createTreeNode("SourceEntity|number", PREFIX1 + localNumber, sourceName + "-" + localNumber, SOURCEENTITY);
        nodeList.add(sourceNumNode);
        sourceNode.addChild(sourceNumNode);
    }

    private void createExtNode(ExtendsModel extendsModel, List<String> extCol, TreeNode root, List<TreeNode> allTreeNodeList) {
        TreeNode extNode;
        ExtField extField;
        FieldEntry entry;
        ArrayList<String> numCols = new ArrayList<String>(10);
        for (String col : extCol) {
            entry = extendsModel.getFieldEntryByNumber(col);
            extField = entry.getExtField();
            if (extField.getMapped().contains("textext")) {
                extNode = this.createTreeNode(extField.getNumber() + '|' + EXT, PREFIX1 + extField.getName(), extField.getName(), ROOT);
                allTreeNodeList.add(extNode);
                root.addChild(extNode);
                continue;
            }
            if (!extField.getMapped().contains("numext")) continue;
            numCols.add(col);
        }
        for (String numCol : numCols) {
            entry = extendsModel.getFieldEntryByNumber(numCol);
            extField = entry.getExtField();
            extNode = this.createTreeNode(extField.getNumber() + '|' + EXT, PREFIX2 + extField.getName(), extField.getName(), ROOT);
            allTreeNodeList.add(extNode);
            root.addChild(extNode);
        }
        this.buildMoneyComboEdit(extendsModel, numCols);
    }

    private void createDimensionNode(List<String> dims, Map<String, DimPropList> propMap, TreeNode root, List<TreeNode> nodeList) {
        String localName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"VDataFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String localNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"VDataFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        for (String dim : dims) {
            DynamicObject dyn = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dim));
            if (dyn == null) continue;
            String dimNodeId = dim + '|' + "dim";
            TreeNode dimNode = this.createTreeNode(dimNodeId, PREFIX1 + dyn.getString(NAME), dyn.getString(NAME), ROOT);
            nodeList.add(dimNode);
            root.addChild(dimNode);
            TreeNode nameNode = this.createTreeNode(dim + '|' + NAME, PREFIX1 + localName, dyn.getString(NAME) + "-" + localName, dimNodeId);
            nodeList.add(nameNode);
            dimNode.addChild(nameNode);
            TreeNode numNode = this.createTreeNode(dim + '|' + NUMBER, PREFIX1 + localNumber, dyn.getString(NAME) + "-" + localNumber, dimNodeId);
            nodeList.add(numNode);
            dimNode.addChild(numNode);
            if (!propMap.containsKey(dim)) continue;
            DimPropList dimPropList = propMap.get(dim);
            for (String propNum : dimPropList.getPropList()) {
                String propName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - %s", (String)"VDataFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String disName = String.format(propName, dimPropList.getFieldName(propNum));
                TreeNode propNode = this.createTreeNode(dim + '|' + propNum + '|' + PROPERTY, PREFIX1 + disName, dyn.getString(NAME) + "-" + disName, dimNodeId);
                nodeList.add(propNode);
                dimNode.addChild(propNode);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String sourceKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (BCMMODEL.equals(sourceKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BCMMODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if (RPTMODEL.equals(sourceKey)) {
            QFilter modelFilter = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
            modelFilter.and(new QFilter(ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser()));
            modelFilter.or(ID, "in", BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_templatelist").get(ApplicationTypeEnum.RPT));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(RPTMODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.add(modelFilter);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("noNeedDefaultQFilter", (Object)true);
        } else if (sourceKey.equals(EXTMODEL)) {
            new QFilter(ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser());
            Object model = this.getModel().getValue(BCMMODEL);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VDataFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(new QFilter("model", "=", (Object)((DynamicObject)model).getLong(ID)), new QFilter("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType())), null));
            }
        } else if (EBMODEL.equals(sourceKey)) {
            HasPermDimObjResult perResult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"epm_model");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (perResult == null) {
                showParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(new QFilter("1", "=", (Object)0)), null));
            } else if (!perResult.hasAllDimObjPerm()) {
                showParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(new QFilter(ID, "in", (Object)perResult.getHasPermDimObjs())), null));
            }
        } else if (EBMODEL_SEL.equals(sourceKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (this.getModel().getValue(EBMODEL) instanceof DynamicObject) {
                showParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(new QFilter("model", "=", (Object)this.getModelId())), null));
            } else {
                showParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(new QFilter("1", "=", (Object)0)), null));
            }
        } else if (ENTRYENTITY_MAPPING.equals(sourceKey)) {
            Map dimMap = (Map)this.getFormCustomParam("FLOAT_INFO");
            Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.getFormCustomParam("KEY_MODEL_ID")));
            ArrayList<String> dims = new ArrayList<String>(10);
            for (String shortDim : dimMap.keySet()) {
                dims.add(shortMap.getOrDefault(shortDim, shortDim));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(new QFilter("model", "=", this.getFormCustomParam("KEY_MODEL_ID")), new QFilter(NUMBER, "in", dims)), null));
        } else if (ISCMETADATA.equals(sourceKey)) {
            MetaDataTypeEnum metaDataTypeEnum;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(ISCMETADATA)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            if ((metaDataTypeEnum = MetaDataTypeEnum.getByType((String)((String)this.getModel().getValue(METADATATYPE)))) != null) {
                qFilterList.add(new QFilter(ENTRYENTITY_TYPE, "=", (Object)metaDataTypeEnum.getType()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"VDataFormulaPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private List<String> getNoEquityExtendGroupType() {
        return Arrays.stream(ExtendDimGroupType.values()).filter(value -> value != ExtendDimGroupType.EQUITY).map(ExtendDimGroupType::getIndex).collect(Collectors.toList());
    }

    private void setDefaultSource() {
        this.getView().getModel().setValue(SOURCE, (Object)DataSourceTypeEnum.MERGE_MODEL.getType());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{RPTMODEL, EBMODEL, EBMODEL_SEL, DataSourceTypeEnum.EPM_DATAMANAGE.getMark(), EXTMODEL, RETURNVALUE, METADATATYPE, ISCMETADATA, EPMMODEL, EPMTYPE});
    }

    @Override
    public long getModelId() {
        if (this.getControl(BCMMODEL) != null && this.getModel().getValue(BCMMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(BCMMODEL)).getLong(ID);
        }
        if (this.getControl(RPTMODEL) != null && this.getModel().getValue(RPTMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(RPTMODEL)).getLong(ID);
        }
        if (this.getControl(EBMODEL) != null && this.getModel().getValue(EBMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(EBMODEL)).getLong(ID);
        }
        return super.getModelId();
    }

    @Override
    public String getModelNumber() {
        if (this.getControl(BCMMODEL) != null && this.getModel().getValue(BCMMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(BCMMODEL)).getString(NUMBER);
        }
        if (this.getControl(RPTMODEL) != null && this.getModel().getValue(RPTMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(RPTMODEL)).getString(NUMBER);
        }
        if (this.getControl(EBMODEL) != null && this.getModel().getValue(EBMODEL) instanceof DynamicObject) {
            return ((DynamicObject)this.getModel().getValue(EBMODEL)).getString(NUMBER);
        }
        return super.getModelNumber();
    }

    private TreeNode createTreeNode(String id, String text, String data, String parent) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        treeNode.setText(text);
        treeNode.setData((Object)data);
        treeNode.setParentid(parent);
        return treeNode;
    }

    private void buildComboEdit() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(SOURCE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        boolean showEPM = true;
        try {
            MainEntityType catalog = EntityMetadataCache.getDataEntityType((String)"iscx_catalog");
            showEPM = catalog != null;
        }
        catch (Exception e) {
            showEPM = false;
        }
        for (DataSourceTypeEnum dataSourceTypeEnum : DataSourceTypeEnum.values()) {
            if (!showEPM && dataSourceTypeEnum == DataSourceTypeEnum.EPM_DATAMANAGE) continue;
            items.add(new ComboItem(new LocaleString(dataSourceTypeEnum.getName()), dataSourceTypeEnum.getType()));
        }
        comboEdit.setComboItems(items);
        ComboEdit metaTypeEdit = (ComboEdit)this.getControl(METADATATYPE);
        ArrayList<ComboItem> metaTypes = new ArrayList<ComboItem>(16);
        for (MetaDataTypeEnum metaDataTypeEnum : MetaDataTypeEnum.values()) {
            metaTypes.add(new ComboItem(new LocaleString(metaDataTypeEnum.getName()), metaDataTypeEnum.getType()));
        }
        metaTypeEdit.setComboItems(metaTypes);
    }

    private void buildMoneyComboEdit(ExtendsModel extendsModel, List<String> extCols) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(RETURNVALUE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (extendsModel != null) {
            for (String extCol : extCols) {
                items.add(new ComboItem(new LocaleString(extendsModel.getFieldEntryByNumber(extCol).getExtField().getName()), extendsModel.getFieldEntryByNumber(extCol).getExtField().getNumber()));
            }
        }
        comboEdit.setComboItems(items);
        if (!items.isEmpty()) {
            this.getModel().setValue(RETURNVALUE, (Object)((ComboItem)items.get(0)).getValue());
        }
    }
}

