/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class VDataPreviewPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    public static final String ENTRYENTITY = "entryentity";
    public static final String ISSINGLEFORMULA = "isSingleFormula";
    public static final String RETURN_FIELD = "returnField";

    @Override
    public void afterCreateNewData(EventObject e) {
        List dataList;
        super.afterCreateNewData(e);
        String previewFormula = (String)this.getFormCustomParam("PREVIEW_FORMULA");
        boolean isSingleFormula = (Boolean)this.getFormCustomParam(ISSINGLEFORMULA);
        String fieldNum = (String)this.getFormCustomParam(RETURN_FIELD);
        if (StringUtils.isNotEmpty((String)previewFormula)) {
            previewFormula = (String)this.deSerializedBytes(previewFormula);
        }
        Object data = VDataFormulaUtils.getDataResultWithTip((String)previewFormula, (IFormView)this.getView());
        List<String> cols = null;
        ArrayList<Map> rows = new ArrayList<Map>(10);
        if (isSingleFormula) {
            if (data instanceof BigDecimal) {
                cols = Collections.singletonList(fieldNum);
                rows.add(MapInitHelper.ofMap((Object)fieldNum, (Object)data));
            }
        } else if (data instanceof List && !(dataList = (List)data).isEmpty()) {
            cols = new ArrayList(((Map)dataList.get(0)).keySet());
            rows.addAll(dataList);
        }
        if (CollectionUtils.isNotEmpty(cols)) {
            Page page = new Page();
            DynamicEntry entry = new DynamicEntry(ENTRYENTITY);
            LocaleString width = new LocaleString("10%");
            for (String string : cols) {
                TextEditElement textEditElement = this.createTextEditElement(string, string, width, 1);
                textEditElement.setLock("new,edit");
                entry.addElement((Element)textEditElement);
            }
            page.addEntry(entry);
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
        }
        if (!rows.isEmpty()) {
            this.getView().getModel().beginInit();
            this.getView().getModel().batchCreateNewEntryRow(ENTRYENTITY, rows.size());
            int index = 0;
            for (Map row : rows) {
                for (Map.Entry entry : row.entrySet()) {
                    Object val = entry.getValue() instanceof BigDecimal && ((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entry.getValue();
                    this.getView().getModel().setValue((String)entry.getKey(), val, index);
                }
                ++index;
            }
            this.getView().getModel().endInit();
        }
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setLock("new,edit,view");
        return textEditElement;
    }
}

