/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;

public class VDataSelectPlugin
extends AbstractBaseFormPlugin
implements TreeNodeClickListener {
    public static final String FLEXPANEL_AP = "flexpanelap";
    public static final String FIELDSETPANEL_AP = "fieldsetpanelap";
    public static final String BTN_OK = "btn_ok";

    @Override
    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List dims = (List)this.getFormCustomParam("SHOW_DIMS");
        this.bindCtrlMapping();
        List<String> keys = this.buildPageViewPanel(dims);
        this.getView().updateView(FLEXPANEL_AP);
        HashMap f7map = Maps.newHashMapWithExpectedSize((int)16);
        for (String key : keys) {
            f7map.put(key, SingleF7TypeEnum.COMMON);
        }
        this.initSingleMemberF7(f7map);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTN_OK)) {
            HashMap resultMap = Maps.newHashMap();
            List dims = (List)this.getFormCustomParam("SHOW_DIMS");
            Map nameMap = MemberReader.getDimNumberMapNameById((long)this.getModelId());
            for (String dim : dims) {
                if (this.getModel().getValue(dim.toLowerCase()) instanceof DynamicObject) {
                    resultMap.put(dim, ((DynamicObject)this.getModel().getValue(dim.toLowerCase())).getString("number"));
                    continue;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VDataSelectPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), nameMap.get(dim)));
                return;
            }
            this.getView().setReturnData((Object)resultMap);
            this.getView().returnDataToParent((Object)resultMap);
            this.getView().close();
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    @Override
    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
        super.initBasedataEditSingleMemberF7(f7Key, f7);
        QFilter customFilter = f7.getCustomFilter();
        Map numMap = (Map)this.getFormCustomParam("SHOW_DIM_NUM_MAP");
        if (numMap != null) {
            if (customFilter == null) {
                if (numMap.containsKey(f7Key)) {
                    f7.setCustomFilter(new QFilter("number", "in", numMap.get(f7Key)));
                }
            } else {
                f7.getCustomFilter().and(new QFilter("number", "in", numMap.get(f7Key)));
            }
        }
    }

    private void bindCtrlMapping() {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        List dims = (List)this.getFormCustomParam("SHOW_DIMS");
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        for (String dim : dims) {
            String entity = MemberReader.getEntityNumberByDim((String)modelNum, (String)dim);
            if (props.containsKey((Object)dim)) continue;
            DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl(FLEXPANEL_AP)), (MainEntityType)mainEntityType, (String)dim.toLowerCase(Locale.ENGLISH), (String)entity, (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    private List<String> buildPageViewPanel(List<String> dims) {
        ArrayList<String> keys = new ArrayList<String>(10);
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(FLEXPANEL_AP);
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey(FIELDSETPANEL_AP);
        flex.getItems().add(fieldsetpanelap);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("1px");
        margin.setBottom("15px");
        style.setMargin(margin);
        fieldsetpanelap.setStyle(style);
        fieldsetpanelap.setAlignItems("right");
        Map dimMap = MemberReader.getDimDyoByModelId((long)this.getModelId());
        for (String dim : dims) {
            FieldAp f7Field = new FieldAp();
            BasedataField basedata = new BasedataField();
            String key = dim.toLowerCase();
            keys.add(key);
            f7Field.setKey(key);
            f7Field.setName(new LocaleString(((DynamicObject)dimMap.get(dim)).getString("name")));
            f7Field.setFieldTextAlign("center");
            f7Field.setTextAlign("right");
            f7Field.setAlignSelf("center");
            f7Field.setStyle(style);
            f7Field.setLabelDirection("h");
            f7Field.setQuickAddNew(false);
            basedata.setViewDetail(false);
            basedata.setKey(key);
            basedata.setBaseEntityId(key);
            basedata.setDisplayProp("number,name");
            basedata.setMustInput(true);
            f7Field.setField((Field)basedata);
            fieldsetpanelap.getItems().add(f7Field);
        }
        this.getView().updateControlMetadata(FLEXPANEL_AP, flex.createControl());
        return keys;
    }
}

