/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.util.DimMemberQueryUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.computing.BizRuleVFormulaPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class VFormulaPlugin
extends AbstractBaseFormPlugin {
    public Map<String, Tuple<String, String, String>> shortNumber2NumberName = new LinkedHashMap<String, Tuple<String, String, String>>(16);
    protected Set<String> userDefinedDim = new HashSet<String>(4);
    private FormulaTicketer<DynamicObject> ticketer;

    @Override
    public void initialize() {
        super.initialize();
        this.getAllDimensions();
        this.bindCtrlMapping(this.shortNumber2NumberName);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getAllDimensions();
        this.bindCtrlMapping(this.shortNumber2NumberName);
        this.buildPageViewPanel(this.shortNumber2NumberName);
        this.setEnableVisibleMustInput();
        this.initPageviewPanelValues();
        SingleMemberF7Util.cacheModelPrem(this.getPageCache(), this.getModelId(), this.getApplicationType());
    }

    @Override
    public void registerListener(EventObject e) {
        if (this.shortNumber2NumberName.size() != 0) {
            this.shortNumber2NumberName.values().forEach(dim -> {
                String membEntityNum = (String)dim.p3;
                String f7Key = this.sugarF7Key(membEntityNum, (String)dim.p1);
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(f7Key);
                if (basedataEdit != null) {
                    basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                }
            });
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        BasedataProp property = (BasedataProp)beforeF7SelectEvent.getProperty();
        String key = property.getName();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        qFilterList.add(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        Object accttype = this.getFormCustomParam("accttype");
        String membEntityNum = property.getBaseEntityId();
        if (accttype != null && "v".equalsIgnoreCase(accttype.toString()) && "bcm_processmembertree".equals(membEntityNum)) {
            Set process = DimMemberQueryUtil.findDimAllSonMembs((Long)this.getModelId(), (String)"bcm_processmembertree", Arrays.asList("CCTotal", "CT"));
            QFilter filter = new QFilter("id", "in", (Object)process.toArray());
            qFilterList.add(filter);
        }
        if ("bcm_userdefinedmembertree".equals(membEntityNum)) {
            String[] split = key.split(membEntityNum + "_");
            String dimNumber = split[1];
            Map<String, String> dim2num = this.shortNumber2NumberName.values().stream().collect(Collectors.toMap(p -> ((String)p.p1).toLowerCase(), p -> (String)p.p1));
            if (dim2num.containsKey(dimNumber)) {
                Long dimensionIdByNum = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dim2num.get(dimNumber));
                QFilter dimFilter = new QFilter("dimension", "=", (Object)dimensionIdByNum);
                qFilterList.add(dimFilter);
            }
        }
        beforeF7SelectEvent.getCustomQFilters().addAll(qFilterList);
    }

    private void setEnableVisibleMustInput() {
        FormulaTicketer<DynamicObject> ticketer = this.getFormulaTicketer();
        ticketer.forEach(e -> {
            this.getView().setEnable(Boolean.valueOf(((FTicket)e.getValue()).isEnable()), new String[]{(String)e.getKey()});
            this.getView().setVisible(Boolean.valueOf(((FTicket)e.getValue()).isVisable()), new String[]{(String)e.getKey()});
            if (((FTicket)e.getValue()).isMustInput()) {
                Control ap = this.getView().getControl((String)e.getKey());
                ((BasedataEdit)ap).setMustInput(true);
            }
        });
        this.getView().updateView("membfieldpanel");
    }

    private void bindCtrlMapping(Map<String, Tuple<String, String, String>> ls) {
        if (ls == null || ls.size() == 0) {
            return;
        }
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        ls.values().stream().forEach(e -> {
            String membEntityNum = (String)e.p3;
            String f7Key = this.sugarF7Key(membEntityNum, (String)e.p1);
            if (!props.containsKey((Object)f7Key)) {
                DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("flexpanelap")), (MainEntityType)mainEntityType, (String)f7Key.toLowerCase(Locale.ENGLISH), (String)membEntityNum, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        });
    }

    public void initPageviewPanelValues() {
        LinkedHashMap<String, String> membValues = new LinkedHashMap<String, String>();
        String formula = (String)this.getFormCustomParam("formula");
        Long modelId = this.getModelId();
        if (formula != null) {
            try {
                FunctionExpr expr = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)formula);
                List parameters = expr.getParameters();
                if (parameters == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
                }
                if (parameters.size() == 1 && parameters.get(0).toString().indexOf(",") != -1) {
                    String[] dim2memStr;
                    String paramFirst = parameters.get(0).toString().replaceAll("\"", "");
                    for (String dim2mem : dim2memStr = paramFirst.split(",")) {
                        if (StringUtils.isEmpty((String)dim2mem) || dim2mem.indexOf(46) == -1) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
                        }
                        VFormulaPlugin.collectDimAndMems(membValues, dim2mem);
                    }
                } else {
                    parameters.forEach(e -> VFormulaPlugin.collectDimAndMems(membValues, e));
                }
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            }
            this.dealmembValues(membValues);
            membValues.entrySet().forEach(e -> {
                Tuple<String, String, String> dimInfo = this.shortNumber2NumberName.get(e.getKey());
                if (dimInfo != null) {
                    String value;
                    String membEntityNum = (String)dimInfo.p3;
                    String dimNumber = (String)dimInfo.p1;
                    String number = MemberReader.findModelNumberById((Object)modelId);
                    IDNumberTreeNode dynaObj = MemberReader.findMemberByNumber((String)number, (String)dimNumber, (String)(value = (String)e.getValue()));
                    if (dynaObj == IDNumberTreeNode.NotFoundTreeNode) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u6210\u5458\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"VFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimInfo.p2, e.getValue()));
                        return;
                    }
                    DynamicObject o = ORM.create().newDynamicObject(membEntityNum);
                    o.set("id", (Object)dynaObj.getId());
                    o.set("name", (Object)dynaObj.getName());
                    o.set("number", (Object)dynaObj.getNumber());
                    this.getModel().setValue(this.sugarF7Key(membEntityNum, (String)dimInfo.p1), (Object)o);
                }
            });
        }
    }

    private static void collectDimAndMems(Map<String, String> membValues, Object e) {
        String param = e.toString().replaceAll("\"", "");
        int pointIndex = param.indexOf(46);
        String shortNum = param.substring(0, pointIndex);
        String memberNum = param.substring(pointIndex + 1, param.length());
        membValues.put(shortNum, memberNum);
    }

    private DynamicObject getEntityByNumber(String membEntityNum, Long dimId, String value) {
        return (DynamicObject)ThreadCache.get((Object)(membEntityNum + dimId + value), () -> {
            String orgname = value;
            String[] split = orgname.split("_");
            orgname = split[1];
            String pNumber = split[0];
            QFilter qFilter = new QFilter("number", "=", (Object)orgname).and("parent.number", "=", (Object)pNumber).and("dimension", "=", (Object)dimId);
            return QueryServiceHelper.queryOne((String)membEntityNum, (String)"id,name,number", (QFilter[])qFilter.toArray());
        });
    }

    public void dealmembValues(Map<String, String> membValues) {
        Long modelId = this.getModelId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Map userdefineDims = MemberReader.getUsetDefineDimNumberMapNameById((long)modelId);
        Map shortnumber2number = MemberReader.getDimensionShortNumber2NumberMap((String)modelNumber);
        userdefineDims.forEach((k, v) -> shortnumber2number.forEach((p, q) -> {
            if (Objects.equals(k, q)) {
                this.userDefinedDim.add((String)p);
            }
        }));
    }

    private void buildPageViewPanel(Map<String, Tuple<String, String, String>> ls) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey("memberpanel");
        FieldsetPanelAp fieldsetpanelap = new FieldsetPanelAp();
        fieldsetpanelap.setKey("membfieldpanel");
        flex.getItems().add(fieldsetpanelap);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("1px");
        margin.setBottom("15px");
        style.setMargin(margin);
        fieldsetpanelap.setStyle(style);
        fieldsetpanelap.setAlignItems("right");
        FormulaTicketer<DynamicObject> ticketer = this.getFormulaTicketer();
        HashMap keyToname = new HashMap();
        ticketer.forEach(e -> {
            if (((FTicket)e.getValue()).isShowTips()) {
                keyToname.put(((FTicket)e.getValue()).getKey(), ((FTicket)e.getValue()).getTips());
            }
        });
        if (ls != null) {
            ls.values().stream().forEach(e -> {
                FieldAp f7Field = new FieldAp();
                BasedataField basedata = new BasedataField();
                String key = this.sugarF7Key((String)e.p3, (String)e.p1);
                f7Field.setKey(key);
                if (keyToname.get(key) != null) {
                    f7Field.setName(new LocaleString(ResManager.loadKDString((String)((String)keyToname.get(key)), (String)("VFormulaPlugin_" + key), (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                } else {
                    f7Field.setName(new LocaleString((String)e.p2));
                }
                f7Field.setLabelDirection("v");
                f7Field.setStyle(this.getWideStyle());
                f7Field.setQuickAddNew(false);
                basedata.setViewDetail(false);
                basedata.setKey((String)e.p3);
                basedata.setBaseEntityId((String)e.p3);
                String displayProp = this.getFormCustomParam("displayProp") == null ? "number,name" : (String)this.getFormCustomParam("displayProp");
                basedata.setDisplayProp(displayProp);
                f7Field.setField((Field)basedata);
                if (DimTypesEnum.MYCOMPANY.getNumber().equals(e.p1)) {
                    Tips tips = new Tips();
                    tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u4e3a\u7a7a\u65f6,\u9ed8\u8ba4\u53d6\u5f53\u524d\u7ec4\u7ec7\u3002", (String)"VFormulaPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    tips.setType("text");
                    f7Field.setCtlTips(tips);
                }
                fieldsetpanelap.getItems().add(f7Field);
            });
        }
        this.addFieldToMemberpanel(fieldsetpanelap, style);
        this.getView().updateControlMetadata("memberpanel", flex.createControl());
    }

    protected Style getWideStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("50px");
        margin.setTop("10px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    public void addFieldToMemberpanel(FieldsetPanelAp fieldsetpanelap, Style style) {
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("bcm_") && !ctrlKey.endsWith("_id")) {
            AtomicReference sql = new AtomicReference();
            this.getFormulaTicketer().forEach(f -> {
                if (ctrlKey.equals(f.getKey())) {
                    sql.set(((FTicket)f.getValue()).getFilterString());
                }
            });
            if (StringUtils.isNotEmpty((String)((String)sql.get()))) {
                BasedataEdit bsEdit = new BasedataEdit();
                bsEdit.setKey(ctrlKey);
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setFieldKey(ctrlKey);
                bsEdit.setDisplayProp("name");
                bsEdit.setQFilter(QFilter.of((String)((String)sql.get()), (Object[])new Object[0]));
                bsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                e.setControl((Control)bsEdit);
            } else {
                Map<String, Object> customData;
                String entityNum = this.getEntityNumByF7key(ctrlKey);
                Long modelId = this.getModelId();
                Optional<Tuple> dimNumOp = QueryDimensionServiceHelper.getDimensionsInfo((Long)modelId).values().stream().filter(p -> {
                    if (!this.isUserDefineDimension(entityNum) && Objects.equals(p.p3, entityNum)) {
                        return Boolean.TRUE;
                    }
                    if (this.isUserDefineDimension(entityNum) && Objects.equals(this.sugarF7Key(entityNum, (String)p.p1), ctrlKey)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }).findFirst();
                String dimNum = (String)dimNumOp.get().p1;
                Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
                DynamicObject dim = MemberReader.getDimensionDynById((long)dimId);
                BasedataEditSingleMemberF7 basedataSingleF7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dim.getLong("id"), ctrlKey, null, false);
                basedataSingleF7.setDisplayAllFyOrPeriodMemb(true);
                if (this.isRPT() && "bcm_entitymembertree".equals(ctrlKey)) {
                    customData = basedataSingleF7.getCustomData();
                    if (customData == null) {
                        customData = new HashMap<String, Object>(16);
                    }
                    customData.put("sourcePage", "rpt-formula");
                    basedataSingleF7.setCustomData(customData);
                } else if ("bcm_entitymembertree".equals(ctrlKey)) {
                    customData = basedataSingleF7.getCustomData();
                    if (customData == null) {
                        customData = new HashMap<String, Object>(16);
                    }
                    customData.put("orgCslschemeFlag", "1");
                    basedataSingleF7.setCustomData(customData);
                }
                Object accttype = this.getFormCustomParam("accttype");
                if (accttype != null && "v".equalsIgnoreCase(accttype.toString()) && "bcm_processmembertree".equals(entityNum)) {
                    basedataSingleF7.setCustomFilter(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("id", "in", (Object)DimMemberQueryUtil.findDimAllSonMembs((Long)this.getModelId(), (String)"bcm_processmembertree", Arrays.asList("CCTotal", "CT")))));
                }
                if ("bcm_icmembertree".equals(ctrlKey)) {
                    basedataSingleF7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"VFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if ("bcm_currencymembertree".equals(ctrlKey) && this instanceof BizRuleVFormulaPlugin) {
                    QFilter customFilter = basedataSingleF7.getCustomFilter();
                    if (customFilter == null) {
                        customFilter = new QFilter("number", "not in", (Object)new String[]{"EC", "PC", "DC"});
                    } else {
                        customFilter.and("number", "not in", (Object)new String[]{"EC", "PC", "DC"});
                    }
                    basedataSingleF7.getQFilter().and(new QFilter("number", "not in", (Object)new String[]{"EC", "PC", "DC"}));
                    basedataSingleF7.setCustomFilter(customFilter);
                }
                e.setControl((Control)basedataSingleF7);
            }
        }
    }

    private void getAllDimensions() {
        Long modelId = this.getModelId();
        this.shortNumber2NumberName = QueryDimensionServiceHelper.getDimensionsInfo((Long)modelId);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprtId = args.getOperateKey();
        if ("confirm".equals(oprtId)) {
            FormulaTicketer<DynamicObject> ticketer = this.getFormulaTicketer();
            String formulanumber = this.getFormCustomParam("formulanumber") == null ? "V" : (String)this.getFormCustomParam("formulanumber");
            StringBuffer formula = new StringBuffer(formulanumber).append('(');
            AtomicBoolean exit = new AtomicBoolean(false);
            this.getModel().getDataEntity().getDataEntityType().getProperties().forEach(p -> {
                if (p.getName().startsWith("bcm_") && !p.getName().endsWith("_id")) {
                    String msg = ticketer.validate(p.getName(), this.getModel().getDataEntity().getDynamicObject(p.getName()));
                    if (StringUtils.isNotEmpty((String)msg)) {
                        throw new KDBizException(msg);
                    }
                    if (this.getModel().getValue(p.getName()) != null) {
                        if ("bcm_entitymembertree".equals(p.getName()) && "V".equalsIgnoreCase(formulanumber)) {
                            formula.append(this.wrapFormulaEntityParam(p.getName()));
                        } else {
                            formula.append(this.wrapFormulaParam(p.getName()));
                        }
                        formula.append(',');
                        exit.set(true);
                    }
                }
            });
            if (!exit.get()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6210\u5458\u3002", (String)"VFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            formula.deleteCharAt(formula.length() - 1);
            this.addFormulaParam(formula);
            formula.append(')');
            this.getView().returnDataToParent((Object)formula);
        }
        this.getView().close();
    }

    public void addFormulaParam(StringBuffer formula) {
    }

    public FormulaTicketer<DynamicObject> getFormulaTicketer() {
        String ticketerStr = (String)this.getFormCustomParam("FormulaTicketer");
        if (this.ticketer == null) {
            this.ticketer = StringUtils.isEmpty((String)ticketerStr) ? new FormulaTicketer() : (FormulaTicketer)this.deSerializedBytes(ticketerStr);
        }
        return this.ticketer;
    }

    protected String wrapFormulaParam(String propName) {
        StringBuilder param = new StringBuilder();
        param.append('\"');
        DynamicObject dyna = this.getModel().getDataEntity().getDynamicObject(propName);
        param.append(dyna.getString("dimension.shortnumber"));
        param.append('.');
        param.append(dyna.getString("number"));
        param.append('\"');
        return param.toString();
    }

    private String wrapFormulaEntityParam(String propName) {
        StringBuilder param = new StringBuilder();
        param.append('\"');
        DynamicObject dyna = this.getModel().getDataEntity().getDynamicObject(propName);
        param.append(dyna.getString("dimension.shortnumber"));
        param.append('.');
        param.append(dyna.getString("parent.number"));
        param.append("_");
        param.append(dyna.getString("number"));
        param.append('\"');
        return param.toString();
    }
}

