/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.imports.handle;

import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

public class DimMappingMemImportHandle {
    private static final String TAR = "tar";
    private static final String SRC = "src";

    public static boolean isSupportImport(DynamicObject scheme) {
        HashSet supportImportSrc = Sets.newHashSet((Object[])new String[]{IntegrateProductEnum.NGProduct.getNumber(), IntegrateProductEnum.NGACCProduct.getNumber(), IntegrateProductEnum.EASACCProduct.getNumber(), IntegrateProductEnum.EASREPProduct.getNumber()});
        HashSet supportImportTar = Sets.newHashSet((Object[])new String[]{IntegrateProductEnum.NGProduct.getNumber(), IntegrateProductEnum.EASREPProduct.getNumber()});
        String srcSystemNum = scheme.getDynamicObject("issrc").getString("number");
        String tarSystemNum = scheme.getDynamicObject("istarg").getString("number");
        return supportImportSrc.contains(srcSystemNum) && supportImportTar.contains(tarSystemNum);
    }

    public static QFilter getTarMemFilter(DynamicObject schemeObj) {
        return DimMappingMemImportHandle.getMemberFilter(schemeObj, TAR);
    }

    public static QFilter getSrcMemFilter(DynamicObject schemeObj) {
        return DimMappingMemImportHandle.getMemberFilter(schemeObj, SRC);
    }

    private static QFilter getMemberFilter(DynamicObject schemeObj, String tarOrSrc) {
        String SystemNum;
        String string = SystemNum = TAR.equals(tarOrSrc) ? schemeObj.getDynamicObject("istarg").getString("number") : schemeObj.getDynamicObject("issrc").getString("number");
        if (IntegrateProductEnum.NGProduct.getNumber().equals(SystemNum)) {
            Long modelId = schemeObj.getDynamicObject("model").getLong("id");
            return new QFilter("model", "=", (Object)modelId);
        }
        if (IntegrateProductEnum.NGACCProduct.getNumber().equals(SystemNum)) {
            return null;
        }
        Long ssId = schemeObj.getDynamicObject("isscheme").getLong("id");
        return new QFilter("ssid", "=", (Object)ssId);
    }
}

