/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.imports.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.MemberImportFailEnum;
import kd.fi.bcm.formplugin.intergration.imports.DimMapMemImportContext;
import kd.fi.bcm.formplugin.intergration.imports.IDimMapMemberImport;
import kd.fi.bcm.formplugin.intergration.imports.handle.DimMappingMemImportHandle;
import kd.fi.bcm.formplugin.intergration.util.SchemeDimHelper;
import kd.fi.bcm.formplugin.intergration.util.UpdateMapJsonUtil;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class FormulaDimMapImport
implements IDimMapMemberImport {
    protected static final int dataStartRowNum = 4;
    protected static final String NULLVAL = "null";

    @Override
    public void checkTemplate(XSSFSheet sheet) {
        if (sheet.getLastRowNum() < 4 || this.checkTmplFlag(sheet) || this.checkSheetHead(sheet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"BcmImportStartPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean checkTmplFlag(XSSFSheet sheet) {
        String firstCellValue = this.getCellValueByCell(sheet.getRow(0).getCell(0));
        return StringUtils.isEmpty((CharSequence)firstCellValue) || firstCellValue.split(" # ").length < 2 || !"bcm_isgroupmapfomula".equals(firstCellValue.split(" # ")[1]);
    }

    @Override
    public boolean checkSheetHead(XSSFSheet sheet) {
        return false;
    }

    @Override
    public void checkMemberData(XSSFSheet sheet, DimMapMemImportContext importContext) {
        String importType;
        switch (importType = importContext.getImportType()) {
            case "new": {
                this.removeRepeat(sheet, importContext, false, false, false);
                this.removeNotExistMember(sheet, importContext);
                break;
            }
            case "override": {
                this.removeRepeat(sheet, importContext, false, true, true);
                break;
            }
            case "overridenew": {
                this.removeRepeat(sheet, importContext, false, true, false);
                this.removeNotExistMember(sheet, importContext);
            }
        }
    }

    @Override
    public void removeRepeat(XSSFSheet sheet, DimMapMemImportContext importContext, boolean isCanRepeatForExcel, boolean isCanRepeatForDB, boolean isOnlyCheck) {
        DynamicObject dimMappingObj = importContext.getDimMappingObj();
        DynamicObject[] memberMapping = this.getMemberMapping(importContext.getSchemeObj().getLong("id"), dimMappingObj.getLong("id"));
        ArrayList memMappingList = new ArrayList(memberMapping.length);
        if (memberMapping.length > 0) {
            MemAndComVO memAndComVO = MappingService.generateMemAndComVO((Long)dimMappingObj.getLong("id"));
            Objects.requireNonNull(memAndComVO);
            Map<Long, String> tarDimIDAndNums = memAndComVO.getTargetPro().stream().collect(Collectors.toMap(MemAndComVO.Node::getId, MemAndComVO.Node::getNumber));
            Arrays.asList(memberMapping).forEach(m -> {
                HashMap<String, String> map = new HashMap<String, String>(16);
                if (m.getDynamicObject("templateid") != null) {
                    map.put("template", m.getString("templateid.number"));
                }
                m.getDynamicObjectCollection("isgrouptargmapentry").forEach(t -> {
                    String tarDimensionNum = (String)tarDimIDAndNums.get(t.getLong("tardimension"));
                    if (tarDimensionNum != null) {
                        map.put(tarDimensionNum, t.getString("tarmembnumber"));
                    }
                });
                DynamicObjectCollection isgroupsrcexprentry = m.getDynamicObjectCollection("isgroupsrcexprentry");
                if (isgroupsrcexprentry.size() > 0) {
                    map.put("expressions", ((DynamicObject)isgroupsrcexprentry.get(0)).getString("expressions"));
                }
                memMappingList.add(map);
            });
        }
        int tarDimCount = dimMappingObj.getDynamicObjectCollection("isdimmaptargentry").size();
        int endColumn = 1 + tarDimCount + 1;
        int startColumn = 1;
        List<Integer> rows = this.removeRepeatForExcel(sheet, importContext, startColumn, endColumn);
        if (memMappingList.size() == 0) {
            importContext.getCheckPassRows().addAll(rows);
        } else {
            for (Integer row : rows) {
                boolean isContinue = false;
                HashMap<String, String> map = new HashMap<String, String>(16);
                for (int j = startColumn; j <= endColumn; ++j) {
                    String memNum = this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(j));
                    if (StringUtils.isEmpty((CharSequence)memNum)) continue;
                    String dimNum = this.getCellValueByCell(sheet.getRow(1).getCell(j));
                    if (j == endColumn) {
                        map.put("expressions", memNum);
                        continue;
                    }
                    if (memNum.split("\\|").length != 2) {
                        importContext.getFailShowMsg().add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), row, MemberImportFailEnum.dataerror.getCode()));
                        isContinue = true;
                        break;
                    }
                    if (j == 1) {
                        dimNum = "template";
                    }
                    map.put(dimNum, memNum.split("\\|")[0]);
                }
                if (isContinue) continue;
                boolean isRepeatForDB = memMappingList.stream().anyMatch(m -> map.equals(m));
                if (isRepeatForDB) {
                    importContext.getFailShowMsg().add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), row, MemberImportFailEnum.Alreadyexists.getCode()));
                    continue;
                }
                importContext.getCheckPassRows().add(row);
            }
        }
    }

    private List<Integer> removeRepeatForExcel(XSSFSheet sheet, DimMapMemImportContext importContext, int startColumn, int endColumn) {
        List<DimMapMemImportContext.ImportFialData> failShowMsg = importContext.getFailShowMsg();
        HashMap<String, Integer> existExcelData = new HashMap<String, Integer>(16);
        for (int i = 4; i <= sheet.getLastRowNum(); ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = startColumn; j <= endColumn; ++j) {
                String cellValue = this.getCellValueByCell(sheet.getRow(i).getCell(j));
                if (StringUtils.isEmpty((CharSequence)cellValue)) {
                    cellValue = NULLVAL;
                }
                sb.append(cellValue);
            }
            String rowData = sb.toString();
            if (existExcelData.containsKey(rowData)) {
                failShowMsg.add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), i, MemberImportFailEnum.repeat.getCode()));
                continue;
            }
            existExcelData.put(rowData, i);
        }
        ArrayList<Integer> rows = new ArrayList<Integer>(existExcelData.values());
        rows.sort(Integer::compareTo);
        return rows;
    }

    @Override
    public void removeNotExistMember(XSSFSheet sheet, DimMapMemImportContext importContext) {
        Set<Integer> checkPassRows = importContext.getCheckPassRows();
        if (checkPassRows.size() == 0) {
            return;
        }
        DynamicObject dimMappingObj = importContext.getDimMappingObj();
        int tarDimCount = dimMappingObj.getDynamicObjectCollection("isdimmaptargentry").size();
        int endColumn = 1 + tarDimCount + 1;
        int startColumn = 1;
        HashSet<String> tempNumber = new HashSet<String>(16);
        HashMap tarDimMemInfo = new HashMap(16);
        for (Integer row : checkPassRows) {
            for (int i = startColumn; i <= endColumn; ++i) {
                String memNumName = this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(i));
                if (StringUtils.isEmpty((CharSequence)memNumName)) continue;
                String dimNum = this.getCellValueByCell(sheet.getRow(1).getCell(i));
                if (i == 1) {
                    tempNumber.add(memNumName.split("\\|")[0]);
                    continue;
                }
                if (i > 1 && i <= endColumn - 1) {
                    HashSet<String> tarMemNum;
                    if (tarDimMemInfo.get(dimNum) != null) {
                        tarMemNum = (HashSet<String>)tarDimMemInfo.get(dimNum);
                    } else {
                        tarMemNum = new HashSet<String>(16);
                        tarDimMemInfo.put(dimNum, tarMemNum);
                    }
                    tarMemNum.add(memNumName.split("\\|")[0]);
                    continue;
                }
                if (i != endColumn) continue;
            }
        }
        MemAndComVO memAndComVO = MappingService.generateMemAndComVO((Long)importContext.getDimMappingObj().getLong("id"));
        List targetPro = memAndComVO.getTargetPro();
        if (tarDimMemInfo.size() != targetPro.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"Excel\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u8bfb\u53d6\u5f02\u5e38\u3002", (String)"GroupDimMapImport_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Map<String, Pair>> existTarDimMemData = new HashMap<String, Map<String, Pair>>(16);
        for (MemAndComVO.Node node : targetPro) {
            String tarDimNumber = node.getNumber();
            if (!tarDimMemInfo.containsKey(tarDimNumber)) continue;
            QFilter qFilter = new QFilter("number", "in", tarDimMemInfo.get(tarDimNumber));
            qFilter.and(DimMappingMemImportHandle.getTarMemFilter(importContext.getSchemeObj()));
            DynamicObjectCollection tarMembers = QueryServiceHelper.query((String)node.getEntityName(), (String)"id,number,name", (QFilter[])qFilter.toArray());
            Map<String, Pair> tarMemInfo = tarMembers.stream().collect(Collectors.toMap(t -> t.getString("number"), t -> new Pair(t.get("id"), (Object)t.getString("name"))));
            existTarDimMemData.put(tarDimNumber, tarMemInfo);
        }
        importContext.getExistGroupMemberInfo().get("tar").putAll(existTarDimMemData);
        HashMap existTempInfo = new HashMap(tempNumber.size());
        if (tempNumber.size() > 0) {
            QFilter qFilter = new QFilter("model", "=", (Object)importContext.getModelId());
            qFilter.and("number", "in", tempNumber);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,name", (QFilter[])qFilter.toArray());
            templates.forEach(t -> existTempInfo.put(t.getString("number"), new Pair(t.get("id"), (Object)t.getString("name"))));
        }
        importContext.getExistTempInfo().putAll(existTempInfo);
        Iterator<Integer> iterator = checkPassRows.iterator();
        while (iterator.hasNext()) {
            Integer row = iterator.next();
            String tempNumAndName = this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(1));
            String tempNum = tempNumAndName.split("\\|")[0];
            if (StringUtils.isNotEmpty((CharSequence)tempNum) && existTempInfo.containsKey(tempNum)) {
                iterator.remove();
                importContext.getFailShowMsg().add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), row, MemberImportFailEnum.dataerror.getCode()));
                continue;
            }
            for (int i = startColumn + 1; i < endColumn; ++i) {
                String dimNum;
                String memNum = this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(i)).split("\\|")[0];
                if (StringUtils.isEmpty((CharSequence)memNum) || existTarDimMemData.containsKey(dimNum = this.getCellValueByCell(sheet.getRow(1).getCell(i))) && ((Map)existTarDimMemData.get(dimNum)).containsKey(memNum)) continue;
                iterator.remove();
                importContext.getFailShowMsg().add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), row, MemberImportFailEnum.membernotexist.getCode()));
            }
        }
    }

    @Override
    public DynamicObject[] getMemberMapping(Long schemeId, Long dimMappingId) {
        String selectField = "srctype,dseq,computeoprt,templateid,templateid.number,isgrouptargmapentry,isgrouptargmapentry.tardimension,isgrouptargmapentry.tarmember,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.srcdimension,isgroupsrcmapentry.srcmember,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.scope,isgroupsrcexprentry.expressions";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMappingId));
        qf.and("srctype", "=", (Object)"2");
        return BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)selectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc");
    }

    @Override
    public DynamicObject packDynamicObject(XSSFSheet sheet, int rowNum, DimMapMemImportContext importContext) {
        Map<String, Map<String, Pair<Object, String>>> tarDimMember = importContext.getExistGroupMemberInfo().get("tar");
        Map<String, Pair<Object, String>> existTempInfo = importContext.getExistTempInfo();
        Map<String, Object> tarDimNumId = importContext.getDimNumIdMap().get("tar");
        DynamicObject groupmap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isgroupmap");
        int startSeq = importContext.getStartSeq();
        groupmap.set("dseq", (Object)startSeq);
        importContext.setStartSeq(startSeq + 1);
        groupmap.set("schemeid", (Object)importContext.getSchemeObj().getLong("id"));
        groupmap.set("dimmapid", (Object)importContext.getDimMappingObj().getLong("id"));
        groupmap.set("srctype", (Object)"2");
        String tempNum = this.getCellValueByCell(sheet.getRow(rowNum).getCell(1)).split("\\|")[0];
        Pair<Object, String> tempIdNum = existTempInfo.get(tempNum);
        groupmap.set("templateid", tempIdNum == null ? null : tempIdNum.p1);
        groupmap.set("creator", (Object)RequestContext.get().getUserId());
        groupmap.set("createtime", (Object)new Date());
        groupmap.set("modifier", (Object)RequestContext.get().getUserId());
        groupmap.set("modifytime", (Object)new Date());
        DynamicObjectCollection grouptargmapentry = groupmap.getDynamicObjectCollection("isgrouptargmapentry");
        short lastCellNum = sheet.getRow(1).getLastCellNum();
        for (int i = 2; i < lastCellNum - 1; ++i) {
            String memNumName = this.getCellValueByCell(sheet.getRow(rowNum).getCell(i));
            if (!StringUtils.isNotEmpty((CharSequence)memNumName)) continue;
            String dimNum = this.getCellValueByCell(sheet.getRow(1).getCell(i));
            String memNum = memNumName.split("\\|")[0];
            DynamicObject dy = grouptargmapentry.addNew();
            dy.set("tardimension", tarDimNumId.get(dimNum));
            dy.set("tarmember", tarDimMember.get((Object)dimNum).get((Object)memNum).p1);
            dy.set("tarmembnumber", (Object)memNum);
        }
        DynamicObjectCollection isgroupsrcexprentry = groupmap.getDynamicObjectCollection("isgroupsrcexprentry");
        DynamicObject expressions = isgroupsrcexprentry.addNew();
        expressions.set("expressions", (Object)this.getCellValueByCell(sheet.getRow(rowNum).getCell(lastCellNum - 1)));
        return groupmap;
    }

    @Override
    public void importDbAndSpread(XSSFSheet sheet, DimMapMemImportContext importContext) {
        Set<Integer> checkPassRows = importContext.getCheckPassRows();
        if (checkPassRows.size() == 0) {
            return;
        }
        DynamicObject dimMappingObj = importContext.getDimMappingObj();
        DynamicObjectCollection tarEntry = dimMappingObj.getDynamicObjectCollection("isdimmaptargentry");
        Map<String, Object> tarDimNumId = tarEntry.stream().collect(Collectors.toMap(t -> t.getString("tagdimension.number"), t -> t.get("tagdimension.id")));
        importContext.getDimNumIdMap().get("tar").putAll(tarDimNumId);
        int formulaDseq = SchemeDimHelper.getDseq(importContext.getSchemeObj().getLong("id"), dimMappingObj.getLong("id"), "2");
        importContext.setStartSeq(formulaDseq);
        ArrayList<DynamicObject> waitSaveData = new ArrayList<DynamicObject>(checkPassRows.size());
        for (Integer row : checkPassRows) {
            waitSaveData.add(this.packDynamicObject(sheet, row, importContext));
        }
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])waitSaveData.toArray(new DynamicObject[0]));
                UpdateMapJsonUtil.updateMapJsonForGroup(sheet, Collections.singletonMap("2", new ArrayList<Integer>(checkPassRows)), importContext.getDimMappingObj().getLong("id"), 0, formulaDseq, result);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }
}

