/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.imports.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.MemberImportFailEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.intergration.imports.DimMapMemImportContext;
import kd.fi.bcm.formplugin.intergration.imports.IDimMapMemberImport;
import kd.fi.bcm.formplugin.intergration.imports.handle.DimMappingMemImportHandle;
import kd.fi.bcm.formplugin.intergration.util.UpdateMapJsonUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class SingleDimMapImport
implements IDimMapMemberImport {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(SingleDimMapImport.class);
    protected final int dataStartRowNum = 4;

    @Override
    public void checkTemplate(XSSFSheet sheet) {
        if (sheet.getLastRowNum() < 4 || this.checkTmplFlag(sheet) || this.checkSheetHead(sheet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"BcmImportStartPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean checkTmplFlag(XSSFSheet sheet) {
        String firstCellValue = this.getCellValueByCell(sheet.getRow(0).getCell(0));
        return StringUtils.isEmpty((CharSequence)firstCellValue) || firstCellValue.split(" # ").length < 2 || !"bcm_issinglemap".equals(firstCellValue.split(" # ")[1]);
    }

    @Override
    public boolean checkSheetHead(XSSFSheet sheet) {
        XSSFRow row = sheet.getRow(1);
        return StringUtils.isBlank((CharSequence)this.getCellValueByCell(row.getCell(0))) || StringUtils.isBlank((CharSequence)this.getCellValueByCell(row.getCell(2)));
    }

    @Override
    public void checkMemberData(XSSFSheet sheet, DimMapMemImportContext importContext) {
        String importType;
        switch (importType = importContext.getImportType()) {
            case "new": {
                this.removeRepeat(sheet, importContext, false, false, false);
                this.removeNotExistMember(sheet, importContext);
                break;
            }
            case "override": {
                this.removeRepeat(sheet, importContext, false, true, true);
                break;
            }
            case "overridenew": {
                this.removeRepeat(sheet, importContext, false, true, false);
                this.removeNotExistMember(sheet, importContext);
            }
        }
    }

    @Override
    public void removeRepeat(XSSFSheet sheet, DimMapMemImportContext importContext, boolean isCanRepeatForExcel, boolean isCanRepeatForDB, boolean isOnlyCheck) {
        DynamicObject[] memberMapping = this.getMemberMapping(importContext.getSchemeObj().getLong("id"), importContext.getDimMappingObj().getLong("id"));
        List<DimMapMemImportContext.ImportFialData> failShowMsg = importContext.getFailShowMsg();
        List tarAndSrcNumForDB = Stream.of(memberMapping).map(m -> m.getString("targmembnumber") + "-" + m.getString("srcmembnumber")).collect(Collectors.toList());
        HashMap<String, Integer> existExcelData = new HashMap<String, Integer>(16);
        ArrayList<Integer> passRows = new ArrayList<Integer>(16);
        for (int i = 4; i <= sheet.getLastRowNum(); ++i) {
            String tarMemNum = this.getCellValueByCell(sheet.getRow(i).getCell(0));
            String srcMemNum = this.getCellValueByCell(sheet.getRow(i).getCell(2));
            String tarAndSrc = tarMemNum + "-" + srcMemNum;
            if (!tarAndSrcNumForDB.contains(tarAndSrc)) {
                if (existExcelData.containsKey(tarAndSrc)) continue;
                if (isOnlyCheck) {
                    failShowMsg.add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), i, MemberImportFailEnum.notexists.getCode()));
                } else {
                    passRows.add(i);
                }
                existExcelData.put(tarAndSrc, i);
                continue;
            }
            if (existExcelData.containsKey(tarAndSrc) && !isCanRepeatForExcel) {
                failShowMsg.add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), i, MemberImportFailEnum.repeat.getCode()));
            } else if (!isCanRepeatForDB) {
                failShowMsg.add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), i, MemberImportFailEnum.Alreadyexists.getCode()));
            }
            if (existExcelData.containsKey(tarAndSrc)) continue;
            existExcelData.put(tarAndSrc, i);
        }
        importContext.getCheckPassRows().addAll(passRows);
    }

    @Override
    public void removeNotExistMember(XSSFSheet sheet, DimMapMemImportContext importContext) {
        Set<Integer> checkPassRows = importContext.getCheckPassRows();
        if (checkPassRows.size() == 0) {
            return;
        }
        HashSet<String> tarMemNums = new HashSet<String>(checkPassRows.size());
        HashSet<String> srcMemNums = new HashSet<String>(checkPassRows.size());
        for (Integer row : checkPassRows) {
            tarMemNums.add(this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(0)));
            srcMemNums.add(this.getCellValueByCell(sheet.getRow(row.intValue()).getCell(2)));
        }
        MemAndComVO memAndComVO = MappingService.generateMemAndComVO((Long)importContext.getDimMappingObj().getLong("id"));
        String tarEntityName = ((MemAndComVO.Node)memAndComVO.getTargetPro().get(0)).getEntityName();
        QFilter tarQFilter = new QFilter("number", "in", tarMemNums);
        tarQFilter.and(DimMappingMemImportHandle.getTarMemFilter(importContext.getSchemeObj()));
        DynamicObjectCollection tarMembers = QueryServiceHelper.query((String)tarEntityName, (String)"id,number,name", (QFilter[])tarQFilter.toArray());
        Map<String, Pair> tarMemberInfo = tarMembers.stream().collect(Collectors.toMap(t -> t.getString("number"), t -> new Pair(t.get("id"), (Object)t.getString("name")), (v1, v2) -> v1));
        importContext.getExistMemberInfo().get("tar").putAll(tarMemberInfo);
        String srcEntityName = ((MemAndComVO.Node)memAndComVO.getSourcePro().get(0)).getEntityName();
        QFilter srcQFilter = new QFilter("number", "in", srcMemNums);
        srcQFilter.and(DimMappingMemImportHandle.getSrcMemFilter(importContext.getSchemeObj()));
        DynamicObjectCollection srcMembers = QueryServiceHelper.query((String)srcEntityName, (String)"id,number,name", (QFilter[])srcQFilter.toArray());
        Map<String, Pair> srcMemberInfo = srcMembers.stream().collect(Collectors.toMap(s -> s.getString("number"), s -> new Pair(s.get("id"), (Object)s.getString("name")), (v1, v2) -> v1));
        importContext.getExistMemberInfo().get("src").putAll(srcMemberInfo);
        Iterator<Integer> iterator = checkPassRows.iterator();
        while (iterator.hasNext()) {
            Integer passRow = iterator.next();
            String tarNum = this.getCellValueByCell(sheet.getRow(passRow.intValue()).getCell(0));
            String srcNum = this.getCellValueByCell(sheet.getRow(passRow.intValue()).getCell(2));
            if (tarMemberInfo.get(tarNum) != null && srcMemberInfo.get(srcNum) != null) continue;
            iterator.remove();
            importContext.getFailShowMsg().add(new DimMapMemImportContext.ImportFialData(sheet.getSheetName(), passRow, MemberImportFailEnum.membernotexist.getCode()));
        }
    }

    @Override
    public DynamicObject[] getMemberMapping(Long schemeId, Long dimMappingId) {
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMappingId));
        String selectField = "targmembnumber,targmembname,srcmembnumber,srcmembname";
        return BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)selectField, (QFilter[])qf.toArray());
    }

    @Override
    public DynamicObject packDynamicObject(XSSFSheet sheet, int rowNum, DimMapMemImportContext importContext) {
        Map<String, Pair<Object, String>> tarDimMember = importContext.getExistMemberInfo().get("tar");
        Map<String, Pair<Object, String>> srcDimMember = importContext.getExistMemberInfo().get("src");
        String tarMemNum = this.getCellValueByCell(sheet.getRow(rowNum).getCell(0));
        String srcMemNum = this.getCellValueByCell(sheet.getRow(rowNum).getCell(2));
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_issinglemap");
        dynamicObject.set("schemeid", (Object)importContext.getSchemeObj().getLong("id"));
        dynamicObject.set("dimmapid", (Object)importContext.getDimMappingObj().getLong("id"));
        dynamicObject.set("targmembid", tarDimMember.get((Object)tarMemNum).p1);
        dynamicObject.set("targmembnumber", (Object)tarMemNum);
        dynamicObject.set("targmembname", tarDimMember.get((Object)tarMemNum).p2);
        dynamicObject.set("scope", (Object)MapScopeEnum.EQUALS.getIndex());
        dynamicObject.set("srcmembnumber", (Object)srcMemNum);
        dynamicObject.set("srcmembname", srcDimMember.get((Object)srcMemNum).p2);
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        DynamicObjectCollection issinglemapentry = dynamicObject.getDynamicObjectCollection("issinglemapentry");
        DynamicObject entry = issinglemapentry.addNew();
        entry.set("srcmembid", srcDimMember.get((Object)srcMemNum).p1);
        entry.set("srcmemnumber", (Object)srcMemNum);
        entry.set("srcdim", ((DynamicObject)importContext.getDimMappingObj().getDynamicObjectCollection("isdimmapsrcentry").get(0)).getDynamicObject("srcdimension").getPkValue());
        return dynamicObject;
    }

    @Override
    public void importDbAndSpread(XSSFSheet sheet, DimMapMemImportContext importContext) {
        Set<Integer> checkPassRows = importContext.getCheckPassRows();
        if (checkPassRows.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> waitSaveData = new ArrayList<DynamicObject>(checkPassRows.size());
        for (Integer row : checkPassRows) {
            waitSaveData.add(this.packDynamicObject(sheet, row, importContext));
        }
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])waitSaveData.toArray(new DynamicObject[0]));
                UpdateMapJsonUtil.updateMapJsonForSingle(waitSaveData, importContext.getDimMappingObj().getLong("id"), result);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

