/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.membermap.handel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.intergration.membermap.handel.MapSheetUtil;
import kd.fi.bcm.formplugin.intergration.membermap.handel.RebuildNameModel;
import kd.fi.bcm.formplugin.intergration.scheme.ISDimMemberAndComSettingPlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;

public abstract class AbstractMemMapSheetHandel {
    protected ISDimMemberAndComSettingPlugin plugin;
    protected SpreadManager sm;
    protected String spKey;
    protected MemAndComVO vo;
    protected Map<String, Integer> srcSignColIndex;
    protected Map<String, Integer> targetSignColIndex;
    protected Map<String, Integer> otherSignColIndex;
    protected Map<Integer, String> colSignIndex;
    protected int hasseq = -1;
    protected MemberMsgCache members;
    protected Object ssid;
    protected String srcAccountNum;
    protected RebuildNameModel waitForUpdate;
    protected boolean isSrcNg;
    protected int maxrow = 2000;
    protected int maxcol;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractMemMapSheetHandel.class);
    protected static final String STAR = "*";
    protected static final String IGNORE = "IGNORE";
    protected static final String TREEVIEW = "treeviewap";
    protected static final String NULL = "null";
    protected Set<String> entityNumber;

    protected abstract DynamicObject packDynamicObject(int var1);

    protected abstract DynamicObject updateDynamicObject(int var1, DynamicObject var2);

    protected abstract String getDynamicObjectType();

    protected abstract void buildSheet();

    protected abstract void buildJQSheet();

    protected abstract void rebuildData(int var1, DynamicObject var2, SpreadEasyInvoker var3);

    protected abstract void rebuildJQData(int var1, DynamicObject var2, SpreadEasyInvoker var3);

    protected abstract String getSelectFiled();

    protected abstract String getSelectJqFiled();

    public void itemClick(String key) {
    }

    public AbstractMemMapSheetHandel(ISDimMemberAndComSettingPlugin plugin, String spKey) {
        this.plugin = plugin;
        this.sm = plugin.getSpreadManager();
        this.spKey = spKey;
        this.vo = plugin.getMemAndComVO();
        DynamicObject scheme = (DynamicObject)this.getView().getModel().getValue("scheme");
        MappingContext context = new MappingContext(scheme);
        this.isSrcNg = context.isSrcNg();
        this.srcAccountNum = this.getSrcAccountNum();
        int num = this.vo.getSourcePro().size() + this.vo.getTargetPro().size();
        this.maxcol = num + 10;
    }

    protected void initMaxRow() {
        this.maxrow = 2000;
    }

    public void buildSpread() {
        log.startWatch();
        this.initMaxRow();
        DynamicObject queryDimmapping = this.getJsonObject(false);
        log.warn("AbstractMemMapSheetHandel: queryDimmapping");
        if (queryDimmapping != null) {
            String json = queryDimmapping.getString("spreadjson");
            String data = queryDimmapping.getString("data");
            if (StringUtils.isEmpty((String)data)) {
                SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
                this.sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
                if (this.isFromJQ()) {
                    this.rebuildJQData();
                } else {
                    this.rebuildData();
                }
            } else {
                JSONObject jsonObject = JSONObjectUtil.parseObjectOrder((String)new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str((String)json)))));
                JSONObject sheetInfo = DataAndJsonTranslator.getSheetInfo((JSONObject)jsonObject);
                JSONObject dataTable = DataAndJsonTranslator.getDataTable((JSONObject)jsonObject, (String)this.getSheet().getSheetName());
                if (sheetInfo.containsKey((Object)"rowCount") && sheetInfo.getInteger("rowCount") < dataTable.size()) {
                    sheetInfo.put("rowCount", (Object)dataTable.size());
                    byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)jsonObject.toJSONString()));
                    String bbs = new String(bb);
                    json = "base64" + bbs;
                }
                SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), json);
                this.sm = JsonSerializerUtil.toSpreadManagerIgnoreSerialIDError((String)data);
                if (this.isFromJQ()) {
                    this.buildJQSheet();
                } else {
                    this.buildSheet();
                }
            }
            log.warn("AbstractMemMapSheetHandel: if");
        } else {
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
            this.sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
            if (this.isFromJQ()) {
                this.buildJQSheet();
            } else {
                this.buildSheet();
            }
            log.warn("AbstractMemMapSheetHandel: else");
        }
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.allowExtendPasteRange.k(), (Object)false));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)true));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.defaultDragFillType.k(), (Object)0));
        this.plugin.cacheSpreadModel(this.sm);
        log.warn("AbstractMemMapSheetHandel: end");
    }

    private DynamicObject getJsonObject(boolean isnew) {
        QFilter qf = new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId());
        if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
            qf.and(new QFilter("type", "=", (Object)"2"));
        } else {
            qf.and(new QFilter("type", "<>", (Object)"2"));
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bcm_ismapjson", (String)"spreadjson,data", (QFilter[])new QFilter[]{qf});
        if (obj == null && isnew) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ismapjson");
            obj.set("dimmapid", (Object)this.vo.getDimMapId());
            if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
                obj.set("type", (Object)"2");
            } else {
                obj.set("type", (Object)"1");
            }
        }
        return obj;
    }

    protected String getEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    protected Map<String, Object> getStyleMap() {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#b2b2b2");
        HashMap<String, String[]> styleMap0 = new HashMap<String, String[]>();
        styleMap0.put("bls", new String[]{"thin"});
        styleMap0.put("blc", new String[]{"#000000"});
        styleMap.put("bl", styleMap0);
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        return styleMap;
    }

    public void spreadF7Click(int row, int col) {
        Cell header = this.getHeader(col);
        if (header != null) {
            QFilter filter;
            ListShowParameter lsp;
            String orientity = header.getUserObject("entitysign").toString();
            String entity = this.getRealEntitySign(orientity);
            if ("bcm_templateentity".equals(entity)) {
                lsp = ShowFormHelper.createShowListForm((String)"bcm_templatef7", (boolean)false);
                filter = QFilter.of((String)"model = ?", (Object[])new Object[]{this.plugin.getModelId()});
                filter.and("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())});
                lsp.getListFilterParameter().setFilter(filter);
            } else {
                lsp = ShowFormHelper.createShowListForm((String)entity, (boolean)false);
                if (this.isMyF7(entity)) {
                    filter = "bcm_fetchtype".equals(entity) ? this.getFetchTypeFilter() : ("bcm_reclassparam".equals(entity) ? new QFilter("1", "=", (Object)1) : QFilter.of((String)"model = ? and storagetype != ?", (Object[])new Object[]{this.plugin.getModelId(), StorageTypeEnum.SHARE.index}));
                    if ("bcm_userdefinedmembertree".equals(entity)) {
                        filter.and(new QFilter("dimension.number", "=", (Object)this.getDimNumberByKey(orientity)));
                    }
                    if (SysDimensionEnum.Entity.getMemberTreemodel().equals(entity)) {
                        filter.and(new QFilter("isexchangerate", "=", (Object)"0"));
                    }
                    lsp.getListFilterParameter().setOrderBy("level,number");
                    lsp.getListFilterParameter().setFilter(filter);
                } else {
                    lsp.getListFilterParameter().setOrderBy("number");
                    lsp.getListFilterParameter().setFilter(this.getSSidFilter());
                }
            }
            lsp.setMultiSelect(true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, "cellf7callback");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        String sign = this.getSignByCol(args.getC());
        if (StringUtils.isNotEmpty((String)sign)) {
            if ("tmp".equals(sign)) {
                QFilter filter = QFilter.of((String)"model = ?", (Object[])new Object[]{this.plugin.getModelId()});
                try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.test.BeforeF7SelectPluginTest.setFilter(SetFilterEvent)", (String)"bcm_templateentity", (String)"id, group", (QFilter[])filter.toArray(), null);){
                    HashSet groupExist = Sets.newHashSet();
                    HashSet templateIds = Sets.newHashSet();
                    queryDataSet.forEach(q -> {
                        Long groupId = q.getLong("group");
                        if (groupExist.add(groupId)) {
                            templateIds.add(q.getLong("id"));
                        }
                    });
                    filter = new QFilter("id", "in", (Object)templateIds);
                }
                SpreadUtils.spreadF7lookUpData(this.plugin.getClientViewProxy(), this.spKey, "bcm_templateentity", args, filter);
            } else if ("floatdim".equals(sign) || "textspread".equals(sign)) {
                QFilter filter = QFilter.of((String)"model = ?", (Object[])new Object[]{this.plugin.getModelId()});
                SpreadUtils.spreadF7lookUpData(this.plugin.getClientViewProxy(), this.spKey, "bcm_dimension", args, filter);
            } else if (sign.startsWith("_enum_")) {
                this.setEnumValues(args, sign);
            } else if (this.isMyF7(sign)) {
                QFilter filter;
                String entity = this.getRealEntitySign(sign);
                String dimnum = this.getDimNumberByKey(sign);
                if ("bcm_fetchtype".equals(entity)) {
                    filter = this.getFetchTypeFilter();
                } else if ("bcm_reclassparam".equals(entity)) {
                    filter = new QFilter("1", "=", (Object)1);
                } else {
                    filter = QFilter.of((String)"model = ? and dimension.number =?", (Object[])new Object[]{this.plugin.getModelId(), dimnum});
                    if (SysDimensionEnum.Entity.getMemberTreemodel().equals(entity)) {
                        filter.and(new QFilter("isexchangerate", "=", (Object)"0"));
                    }
                }
                SpreadUtils.spreadF7lookUpData(this.plugin.getClientViewProxy(), this.spKey, entity, dimnum, args, this.plugin.getModelId(), filter, null, null, null);
            } else if (this.isOtherF7(sign)) {
                String entity = this.getRealEntitySign(sign);
                SpreadUtils.spreadF7lookUpData(this.plugin.getClientViewProxy(), this.spKey, entity, args, this.getSSidFilter());
            }
        }
    }

    private QFilter getFetchTypeFilter() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        return IntegrationUtil.getFetchTypeFilter((DynamicObject)scheme);
    }

    protected QFilter getSSidFilter() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        MappingContext context = new MappingContext(scheme);
        QFilter qfilter = context.isSrcNg() ? context.getTarget().getDimDetailQFilter(this.plugin.getView().getModel(), this.plugin.getView()) : context.getSource().getDimDetailQFilter(this.plugin.getView().getModel(), this.plugin.getView());
        return qfilter;
    }

    protected void setEnumValues(LookUpDataArgs args, String sign) {
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        DimMember mem;
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        Cell cell = this.getSheet().getCell(arg.getR(), arg.getC());
        String sign = this.getSignByCol(arg.getC());
        if ("tmp".equals(sign)) {
            mem = this.setMembackToCell(cell, arg.getName(), arg.getNumber(), arg.getId());
            this.showF7Value(arg.getR(), arg.getC(), mem, invoker);
        } else if ("floatdim".equals(sign) || "textspread".equals(sign)) {
            mem = this.setMembackToCell(cell, arg.getName(), arg.getNumber(), arg.getId());
            this.showF7Value(arg.getR(), arg.getC(), mem, invoker);
        }
        if (this.isF7(sign)) {
            if (this.beforeUpdateCheck(arg.getR(), arg.getC(), invoker)) {
                mem = this.setMembackToCell(cell, arg.getName(), arg.getNumber(), arg.getId());
                this.showF7Value(arg.getR(), arg.getC(), mem, invoker);
            }
        } else if (this.isEnum(sign)) {
            invoker.updataValue(arg.getR(), arg.getC(), arg.getName());
            this.changeEnumValue(cell, String.valueOf(arg.getId()), invoker);
            cell.setValue((Object)arg.getId());
            this.setCellChange(cell);
        }
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    protected void changeEnumValue(Cell cell, String newVal, SpreadEasyInvoker invoker) {
    }

    protected Cell getHeader(int col) {
        int maxrow = this.getSheet().getMaxRowCount();
        for (int i = 1; i < maxrow; ++i) {
            Cell cell = this.getSheet().getCell(i, col);
            if (cell.getUserObject("entitysign") == null) continue;
            return cell;
        }
        return null;
    }

    protected Sheet getSheet() {
        return this.sm.getBook().getSheet(0);
    }

    protected Cell getSeqCell(int row) {
        int maxCol = this.getSheet().getMaxColumnCount();
        for (int i = 1; i < maxCol; ++i) {
            Cell cell = this.getSheet().getCell(row, i);
            if (cell.getUserObject("entitysign") == null) continue;
            return cell;
        }
        return null;
    }

    protected String getSignByCol(int col) {
        if (this.colSignIndex == null) {
            this.colSignIndex = new HashMap<Integer, String>();
        }
        if (!this.colSignIndex.containsKey(col)) {
            Cell head = this.getHeader(col);
            if (head != null) {
                this.colSignIndex.put(col, head.getUserObject("entitysign").toString());
            } else {
                this.colSignIndex.put(col, null);
            }
        }
        return this.colSignIndex.get(col);
    }

    protected int getFirstSrcCol() {
        String firstSrc = this.plugin.getPageCache().get("firstsrc");
        if (firstSrc == null) {
            return -1;
        }
        return Integer.parseInt(firstSrc);
    }

    protected void cacheFirstSrcCol(int col) {
        this.plugin.getPageCache().put("firstsrc", "" + col);
    }

    public void initSignColMap() {
        this.srcSignColIndex = new HashMap<String, Integer>();
        this.targetSignColIndex = new HashMap<String, Integer>();
        this.otherSignColIndex = new HashMap<String, Integer>();
        int maxcol = this.getSheet().getMaxColumnCount();
        for (int col = 0; col < maxcol; ++col) {
            Cell cell = this.getSheet().getCell(1, col);
            if (cell.getUserObject("entitysign") == null) continue;
            String sign = cell.getUserObject("entitysign").toString();
            if (sign.contains("!")) {
                int firstSrcCol = this.getFirstSrcCol();
                if (firstSrcCol != -1 && col >= firstSrcCol) {
                    this.srcSignColIndex.put(sign, col);
                    continue;
                }
                this.targetSignColIndex.put(sign, col);
                continue;
            }
            this.otherSignColIndex.put(sign, col);
        }
    }

    private String getEntitySign(String entity, String dimNum) {
        if (dimNum != null) {
            entity = this.buildColEntityKey(entity, dimNum);
        } else {
            String number = DimEntityNumEnum.getNumberByEntieyNum((String)entity);
            if (StringUtils.isNotEmpty((String)number)) {
                entity = this.buildColEntityKey(entity, number);
            }
        }
        return entity;
    }

    protected int getSrcColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.srcSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.srcSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    protected int getTargetColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.targetSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    protected boolean isTargetCol(int col) {
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return this.targetSignColIndex.containsValue(col);
    }

    protected int getOtherColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.otherSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.otherSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    protected void setCellChange(Cell cell) {
        cell.setChangeVal(true);
        int seqIndex = this.getSeqIndex();
        Cell seqCell = this.getSheet().getCell(cell.getRow(), seqIndex);
        seqCell.setUserObject("ischange", (Object)true);
        this.getSheet().putUserObject("change", (Object)true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Cell head = this.getHeader(this.plugin.getSpreadSelector().getStartCol());
        int r = this.plugin.getF7SelectRow();
        int c = this.plugin.getF7SelectCol();
        ListSelectedRowCollection coll = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (coll == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        boolean isLongType = true;
        for (ListSelectedRow li : coll) {
            isLongType = li.isPkLongType();
            ids.add(li.getPrimaryKeyValue().toString());
        }
        String entity = head.getUserObject("entitysign").toString();
        entity = this.getRealEntitySign(entity);
        Map clos = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", isLongType ? LongUtil.toLongList(ids) : ids)});
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.setBatch(true);
        int index = 0;
        ArrayList<DynamicObject> objlist = new ArrayList<DynamicObject>(clos.values());
        ArrayList<String> errormsg = new ArrayList<String>();
        if (this.isNormalCloBak(r, c, invoker, objlist)) {
            int leafrow = this.getSheet().getMaxRowCount() - r;
            leafrow = Math.max(leafrow, 0);
            if (clos.size() > leafrow) {
                this.insertRowFromInxdex(this.getSheet().getMaxRowCount(), clos.size() - leafrow);
            }
            for (Object e : ids) {
                DynamicObject obj = (DynamicObject)clos.get(e);
                if (obj == null) {
                    obj = (DynamicObject)clos.get(Long.valueOf(e.toString()));
                }
                if (obj == null) {
                    errormsg.add(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5408\u6cd5\uff1b", (String)"AbstractMemMapSheetHandel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e));
                }
                if (this.beforeUpdateCheck(r + index, c, invoker) && obj != null) {
                    Cell cell = this.getSheet().getCell(r + index, c);
                    try {
                        DimMember mem = this.setMembackToCell(cell, obj.getString("name"), obj.getString("number"), obj.getLong("id"));
                        this.showF7Value(r + index, c, mem, invoker);
                    }
                    catch (NumberFormatException e2) {
                        errormsg.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u6210\u5458\u5185\u7f6eFID\u5f02\u5e38\uff1a%2$s\u3002", (String)"AbstractMemMapSheetHandel_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), obj.getString("number"), obj.get("id")));
                    }
                }
                ++index;
            }
        }
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
        if (errormsg.size() > 0) {
            this.getView().showMessage(((Object)errormsg).toString());
        }
    }

    protected boolean isNormalCloBak(int row, int col, SpreadEasyInvoker invoker, List<DynamicObject> clos) {
        return true;
    }

    protected boolean beforeUpdateCheck(int row, int col, SpreadEasyInvoker invoker) {
        return true;
    }

    protected void showF7Value(int r, int c, DimMember mem, SpreadEasyInvoker invoker) {
        invoker.updataValue(r, c, this.getShowName(mem));
    }

    protected String getShowName(DimMember mem) {
        return this.getShowName(mem.getNumber(), mem.getName());
    }

    protected String getShowName(String number, String name) {
        return MapSheetUtil.getShowName(number, name);
    }

    public void checkAndUpdate() {
    }

    protected void checkBeforeSave() {
    }

    protected void checkBeforeSave4Group() {
    }

    protected abstract String getRowInfo(List<Cell> var1);

    protected void checkRepeatData() {
        Sheet sheet = this.getSheet();
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        for (int row = 2; row < sheet.getMaxRowCount(); ++row) {
            List rowCells = sheet.getRow(row, true);
            if (this.isAllNone(row)) continue;
            String key = this.getRowInfo(rowCells);
            if (map.containsKey(key)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6570\u636e\u4e0e\u7b2c%2$s\u884c\u6570\u636e\u76f8\u540c\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"GroupMemMapSheetHandel_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), map.get(key), row + 1));
            }
            map.put(key, row + 1);
        }
    }

    public void actionSave(String spreadJson) {
        try {
            boolean isOneInDynamicObject;
            this.checkBeforeSave();
            List<DynamicObject> need2Save = this.collectDynamicObjects();
            this.checkBeforeSave4Group();
            List<Object> notDeleteId = this.collectNotDeleteids();
            this.simpleModel();
            if (this.getSheet().getUserObject() != null) {
                this.getSheet().getUserObject().remove("change");
            }
            if (isOneInDynamicObject = this.checkOneInDynamicObject(need2Save)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"IN\u8868\u8fbe\u5f0f\u7684\u6210\u5458\u5fc5\u987b\u8981\u4e00\u4e2a\u4ee5\u4e0a\u3002", (String)"AbstractMemMapSheetHandel_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveData(spreadJson, need2Save, notDeleteId);
            this.writeSaveSuccessLog();
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractMemMapSheetHandel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.plugin.cacheSpreadModel(this.sm);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private boolean checkOneInDynamicObject(List<DynamicObject> need2Save) {
        HashMap<Long, Integer> checkMap = new HashMap<Long, Integer>(16);
        Long id = null;
        for (DynamicObject dynamicObject : need2Save) {
            if (!"bcm_isgroupmap".equals(dynamicObject.getDataEntityType().getName())) continue;
            DynamicObjectCollection isgroupsrcmapentrys = dynamicObject.getDynamicObjectCollection("isgroupsrcmapentry");
            for (DynamicObject srcmapentry : isgroupsrcmapentrys) {
                if (!"4".equals(srcmapentry.getString("scope"))) continue;
                checkMap.put(id, checkMap.get(id = Long.valueOf(srcmapentry.getLong("srcdimension"))) == null ? 1 : (Integer)checkMap.get(id) + 1);
            }
        }
        for (Integer num : checkMap.values()) {
            if (num != 1) continue;
            return true;
        }
        return false;
    }

    protected void writeSaveSuccessLog() {
        String nodeName;
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        String schemeName = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848%s", (String)"AbstractMemMapSheetHandel_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scheme.getString("number"));
        TreeView tree = (TreeView)this.plugin.getView().getControl(TREEVIEW);
        try {
            nodeName = tree.getTreeState().getFocusNode().get("text").toString();
        }
        catch (NullPointerException e) {
            nodeName = ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String description = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractMemMapSheetHandel_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeName, nodeName);
        this.plugin.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58\u6210\u5458\u6620\u5c04", "AbstractMemMapSheetHandel_9", "fi-bcm-formplugin", "Save member mapping"), new OPDescMultiLangEnumBridge("%1$s\uff0c%2$s\u4fdd\u5b58\u6210\u529f\u3002", "AbstractMemMapSheetHandel_12", "fi-bcm-formplugin", new String[]{schemeName, nodeName}));
    }

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected boolean isAllNone(int row) {
        for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
            String v;
            String sign = this.getSignByCol(col);
            if (sign == null) continue;
            Cell cell = this.getSheet().getCell(row, col);
            String string = v = cell.getValue() == null ? "" : cell.getValue().toString();
            if (!StringUtils.isNotEmpty((String)v)) continue;
            return false;
        }
        return true;
    }

    public List<DynamicObject> collectDynamicObjects() {
        int seqCol = this.getSeqIndex();
        ArrayList<DynamicObject> need2Save = new ArrayList<DynamicObject>();
        HashMap<Integer, Object> editids = new HashMap<Integer, Object>();
        DynamicObject sc = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isdimmap", (String)"scheme.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.vo.getDimMapId())});
        if (sc == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u6210\u5458\u6620\u5c04\u9875\u9762\u3002", (String)"DIMemberMappingPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        long scheme = sc.getLong("scheme.id");
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, seqCol);
            if (cell.getUserObject("ischange") == null) continue;
            Object id = cell.getUserObject("id");
            boolean isAllNone = this.isAllNone(row);
            if (id == null) {
                if (isAllNone) {
                    cell.removeUserObject("ischange");
                    continue;
                }
                DynamicObject object = this.packDynamicObject(row);
                if (object == null) continue;
                id = GlobalIdUtil.genGlobalLongId();
                object.set("schemeid", (Object)scheme);
                object.set("dimmapid", (Object)this.vo.getDimMapId());
                object.set("id", id);
                this.setCreateTimeAndUser(object);
                this.setModifyTimeAndUser(object);
                need2Save.add(object);
                cell.setUserObject("id", id);
            } else {
                if (isAllNone) {
                    cell.removeUserObject("id");
                    cell.removeUserObject("ischange");
                    continue;
                }
                editids.put(row, id);
            }
            cell.removeUserObject("ischange");
        }
        if (editids.size() > 0) {
            DynamicObject[] docs = BusinessDataServiceHelper.load((Object[])editids.values().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)this.getDynamicObjectType()).getDynamicObjectType());
            Map<Object, DynamicObject> col = this.resultToMap(docs);
            for (Map.Entry v : editids.entrySet()) {
                DynamicObject object = this.updateDynamicObject((Integer)v.getKey(), col.get(v.getValue()));
                this.setModifyTimeAndUser(object);
                need2Save.add(object);
            }
        }
        return need2Save;
    }

    private Map<Object, DynamicObject> resultToMap(DynamicObject[] objects) {
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject ob : objects) {
            map.put(ob.get("id"), ob);
        }
        return map;
    }

    private List<Object> collectNotDeleteids() {
        int seqCol = this.getSeqIndex();
        ArrayList<Object> nodeleteid = new ArrayList<Object>();
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, seqCol);
            Object id = cell.getUserObject("id");
            if (id == null) continue;
            nodeleteid.add(id);
        }
        return nodeleteid;
    }

    private void saveData(String spreadJson, List<DynamicObject> need2Save, List<Object> notDeleteId) {
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                QFilter notid = new QFilter("id", "not in", notDeleteId);
                QFilter dimmap = new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId());
                if (this.vo.getType() == MemAndComVO.VOEnum.C1 || this.vo.getType() == MemAndComVO.VOEnum.C2) {
                    dimmap.and(new QFilter("srctype", "=", (Object)"1"));
                } else if (this.vo.getType() == MemAndComVO.VOEnum.C3) {
                    dimmap.and(new QFilter("srctype", "=", (Object)"2"));
                }
                DeleteServiceHelper.delete((String)this.getDynamicObjectType(), (QFilter[])new QFilter[]{notid, dimmap});
                SaveServiceHelper.save((DynamicObject[])need2Save.toArray(new DynamicObject[0]));
                DynamicObject json = this.getJsonObject(true);
                json.set("spreadjson", (Object)spreadJson);
                json.set("data", (Object)this.plugin.getSpreadModelSeria(this.sm));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{json});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    protected void simpleModel() {
        int seqCol = this.getSeqIndex();
        for (int row = 0; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell seqCell = this.getSheet().getCell(row, seqCol);
            if (seqCell.getUserObject("ischange") != null || seqCell.getUserObject("entitysign") != null) continue;
            for (int col = seqCol; col < this.getSheet().getMaxColumnCount(); ++col) {
                Cell cell = this.getSheet().getCell(row, col);
                cell.removeUserObject("KEY_DIM_FLAG");
                cell.setChangeVal(false);
            }
        }
    }

    public final IFormView getView() {
        return this.plugin.getView();
    }

    protected DimMember packMem(String memname, String memnumber, String dimnum, String dimname) {
        Dimension dimension = new Dimension(dimname, dimnum, null);
        return new DimMember(memname, memnumber, null, (IDimension)dimension);
    }

    protected void setCreateTimeAndUser(DynamicObject object) {
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
    }

    protected void setModifyTimeAndUser(DynamicObject object) {
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)TimeServiceHelper.now());
    }

    protected DynamicObject getOldEntry(DynamicObjectCollection col, String key, long id) {
        for (DynamicObject object : col) {
            if (object.getLong(key) != id) continue;
            return object;
        }
        return col.addNew();
    }

    protected void deleteAllOldEntry(DynamicObjectCollection col, String key, long id) {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>();
        for (DynamicObject object : col) {
            if (object.getLong(key) != id) continue;
            objects.add(object);
        }
        col.removeAll(objects);
    }

    protected boolean isContinute(boolean isNew, int row, String name, boolean mustinput) {
        if (isNew && mustinput) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%1$s\u884c%2$s\u3002", (String)"AbstractMemMapSheetHandel_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row, name));
        }
        return true;
    }

    public void autoMatchNG(MemAndComVO memAndComVO, MappingContext mappingContext) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void autoMatchNumber(MemAndComVO memAndComVO, MappingContext mappingContext) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void autoMatchTMP(MemAndComVO memAndComVO, MappingContext mappingContext, Object tmpId) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void fillTargetMember(MemAndComVO memAndComVO, MappingContext mappingContext) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractMemMapSheetHandel_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void beforeUpdateMulValue(NotifyEvent mulevt) {
        mulevt.setCancel(true);
        SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
        List value = data.getValues();
        HashBasedTable indexTable = HashBasedTable.create();
        HashBasedTable msgTable = HashBasedTable.create();
        if (!this.supportFuzzyMatch()) {
            this.collectMemberMsg(value, (Table<String, String, Integer>)indexTable, (Table<Integer, String, Object>)msgTable);
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.setBatch(true);
        for (LinkedHashMap map : value) {
            String valueString;
            Cell cell = this.getSheet().getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue());
            String sign = this.getSignByCol(cell.getCol());
            String string = valueString = map.get("v") == null ? "" : map.get("v").toString().trim();
            if (valueString.equalsIgnoreCase("True")) {
                valueString = "True";
            }
            if (valueString.equalsIgnoreCase("False")) {
                valueString = "False";
            }
            if (StringUtils.isNotEmpty((String)sign)) {
                String entity = this.getRealEntitySign(sign);
                if (this.supportFuzzyMatch()) {
                    if (this.isEnum(entity)) {
                        this.pasteEnum(invoker, cell, entity, valueString);
                    }
                    if (!StringUtils.isNotEmpty((String)valueString)) continue;
                    this.beforeUpdateCheck(cell.getRow(), cell.getCol(), invoker);
                    continue;
                }
                if (this.isF7(entity)) {
                    DimMember mem;
                    if (this.specialPaste(valueString, cell, (Table<String, String, Integer>)indexTable, (Table<Integer, String, Object>)msgTable, invoker)) continue;
                    String dinmun = this.getDimNumberByKey(sign);
                    Object msgindexObject = indexTable.get((Object)valueString, (Object)dinmun);
                    if (msgindexObject == null && !valueString.equals("|")) {
                        String number = valueString.split("\\|")[0];
                        msgindexObject = indexTable.get((Object)number, (Object)dinmun);
                    }
                    if (msgindexObject != null) {
                        if (this.beforeUpdateCheck(cell.getRow(), cell.getCol(), invoker)) {
                            int msgindex = (Integer)msgindexObject;
                            String memname = (String)msgTable.get((Object)msgindex, (Object)"name");
                            String memnumber = (String)msgTable.get((Object)msgindex, (Object)"number");
                            long id = (Long)msgTable.get((Object)msgindex, (Object)"id");
                            mem = this.setMembackToCell(cell, memname, memnumber, id);
                            this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
                            continue;
                        }
                        invoker.updataValue(cell.getRow(), cell.getCol(), null);
                        continue;
                    }
                    cell.clearMembersOfUserObject();
                    cell.setValue(null);
                    this.setCellChange(cell);
                    mem = this.packMem("", "", "", "");
                    this.showF7Value(cell.getRow(), cell.getCol(), mem, invoker);
                    invoker.updataValue(cell.getRow(), cell.getCol(), null);
                    continue;
                }
                if (this.isEnum(entity)) {
                    this.pasteEnum(invoker, cell, entity, valueString);
                    continue;
                }
                cell.setValue((Object)valueString);
                this.setCellChange(cell);
                continue;
            }
            cell.setValue((Object)valueString);
        }
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    private void collectMemberMsg(List<LinkedHashMap<String, Object>> value, Table<String, String, Integer> indexTable, Table<Integer, String, Object> msgTable) {
        HashMultimap dim2mem = HashMultimap.create();
        for (LinkedHashMap<String, Object> map : value) {
            String entity = this.getSignByCol((Integer)map.get("c"));
            Object v = map.get("v");
            if (entity == null || v == null || v.equals("|")) continue;
            String valueString = v.toString();
            this.analysisMembers((Multimap<String, String>)dim2mem, valueString, entity);
        }
        int i = 0;
        for (String key : dim2mem.keySet()) {
            String entity = this.getRealEntitySign(key);
            String dinmun = this.getDimNumberByKey(key);
            DynamicObjectCollection col = null;
            if ("bcm_templateentity".equals(entity)) {
                col = QueryServiceHelper.query((String)this.getRealEntitySign(key), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.plugin.getModelId()), new QFilter("number", "in", (Object)dim2mem.get((Object)key)).or(new QFilter("name", "in", (Object)dim2mem.get((Object)key)))});
            } else if (this.isMyF7(entity)) {
                col = "bcm_fetchtype".equals(entity) ? QueryServiceHelper.query((String)this.getRealEntitySign(key), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dim2mem.get((Object)key)).or(new QFilter("name", "in", (Object)dim2mem.get((Object)key)))}) : QueryServiceHelper.query((String)this.getRealEntitySign(key), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.plugin.getModelId()), new QFilter("dimension.number", "=", (Object)dinmun), new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index), new QFilter("number", "in", (Object)dim2mem.get((Object)key)).or(new QFilter("name", "in", (Object)dim2mem.get((Object)key)))});
            } else if (this.isOtherF7(entity)) {
                col = QueryServiceHelper.query((String)this.getRealEntitySign(key), (String)"id,name,number", (QFilter[])new QFilter[]{this.getSSidFilter(), new QFilter("number", "in", (Object)dim2mem.get((Object)key)).or(new QFilter("name", "in", (Object)dim2mem.get((Object)key)))});
            }
            if (col == null || col.size() <= 0) continue;
            for (DynamicObject obj : col) {
                indexTable.put((Object)obj.getString("number"), (Object)dinmun, (Object)i);
                indexTable.put((Object)obj.getString("name"), (Object)dinmun, (Object)i);
                indexTable.put((Object)(obj.getString("number") + '|' + obj.getString("name")), (Object)dinmun, (Object)i);
                msgTable.put((Object)i, (Object)"name", (Object)obj.getString("name"));
                msgTable.put((Object)i, (Object)"number", (Object)obj.getString("number"));
                msgTable.put((Object)i, (Object)"id", (Object)obj.getLong("id"));
                ++i;
            }
        }
    }

    protected void analysisMembers(Multimap<String, String> dim2mem, String valueString, String entity) {
        dim2mem.put((Object)entity, (Object)valueString);
        dim2mem.put((Object)entity, (Object)valueString.split("\\|")[0]);
    }

    protected boolean specialPaste(String valueString, Cell cell, Table<String, String, Integer> indexTable, Table<Integer, String, Object> msgTable, SpreadEasyInvoker invoker) {
        return false;
    }

    protected DimMember setMembackToCell(Cell cell, String memname, String memnumber, long id) {
        cell.clearMembersOfUserObject();
        cell.setValue((Object)memnumber);
        DimMember mem = this.packMem(memname, memnumber, "", "");
        mem.setId(id);
        cell.addDim2UserObject((IDimMember)mem);
        this.setCellChange(cell);
        return mem;
    }

    protected void pasteEnum(SpreadEasyInvoker invoker, Cell cell, String entity, String value) {
    }

    public void afterUpdataValue(EventObject e) {
        Cell cell = (Cell)e.getSource();
        Cell head = this.getHeader(cell.getCol());
        if (head != null) {
            this.setCellChange(cell);
        }
    }

    protected int getSeqIndex() {
        Object obj = this.getSheet().getUserObject("seqindex");
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return 0;
    }

    protected boolean ifCellisNull(Cell cell) {
        return cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString());
    }

    protected String buildColEntityKey(String entity, String dimNum) {
        return entity + "!" + dimNum;
    }

    protected String buildEntityNameByNode(MemAndComVO.Node node) {
        return this.buildColEntityKey(node.getEntityName(), node.getNumber());
    }

    protected String getRealEntitySign(String key) {
        if ("textspread".equals(key) || "floatdim".equals(key)) {
            return "bcm_dimension";
        }
        if ("tmp".equals(key)) {
            return "bcm_templateentity";
        }
        return key.split("!")[0];
    }

    protected String getDimNumberByKey(String key) {
        if (key.contains("!")) {
            return key.split("!")[1];
        }
        return key;
    }

    protected boolean isEnum(String sign) {
        return sign.startsWith("_enum_");
    }

    protected boolean isF7(String sign) {
        return this.isMyF7(sign) || this.isOtherF7(sign);
    }

    protected boolean isMyF7(String sign) {
        return sign.startsWith("bcm");
    }

    protected boolean isOtherF7(String sign) {
        String entityNum = this.getRealEntitySign(sign);
        return !this.isMyF7(sign) && this.getEntityNumber().contains(entityNum);
    }

    public void insertRowFromInxdex(int row, int num) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            insertdata.add(row);
        }
        AskExcuteInfo excuteinfo = new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCon(true);
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.plugin.updateRowAndCol(excuteinfo);
    }

    private void rebuildData() {
        DynamicObject[] doc;
        this.buildSheet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.setBatch(true);
        String selectFiled = this.getSelectFiled();
        if (this.isFromJQ()) {
            selectFiled = this.getSelectJqFiled();
        }
        if ((doc = BusinessDataServiceHelper.load((String)this.getDynamicObjectType(), (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId()).and(this.getRebuildDataFilter())}, (String)this.getOrders())) != null && doc.length > this.maxrow) {
            this.insertRowFromInxdex(this.maxrow - 1, doc.length - this.maxrow + 10);
        }
        int row = 2;
        this.members = new MemberMsgCache(this.plugin.getModelId());
        this.ssid = this.getSSid();
        this.waitForUpdate = new RebuildNameModel();
        log.warn("AbstractMemMapSheetHandel: rebuilddata start");
        if (doc != null && doc.length > 0) {
            for (DynamicObject obj : doc) {
                Cell cell = this.getSheet().getCell(row, this.getSeqIndex());
                cell.setUserObject("id", obj.get("id"));
                this.rebuildData(row, obj, invoker);
                ++row;
            }
        }
        log.warn("AbstractMemMapSheetHandel: rebuilddata end");
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (this.waitForUpdate.getList().size() > 0) {
            for (Map<String, Object> map : this.waitForUpdate.getList()) {
                int r = (Integer)map.get("r");
                int c = (Integer)map.get("c");
                this.members.cacheOthersDimMem(map.get("entity").toString(), this.ssid);
                String number = this.waitForUpdate.getValue(map, this.members);
                String name = this.waitForUpdate.getName(map, this.members);
                if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)number)) {
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5217", (String)"AbstractMemMapSheetHandel_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), r, c));
                    name = "";
                    number = "";
                }
                this.setValueUnChange(r, c, number);
                invoker.updataValue(r, c, name);
            }
        }
        if (errorMsg.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7f3a\u5931", (String)"AbstractMemMapSheetHandel_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Object)errorMsg).toString()));
        }
        invoker.startToInvoke();
    }

    private void rebuildJQData() {
        this.buildJQSheet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.setBatch(true);
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)this.getDynamicObjectType(), (String)this.getSelectJqFiled(), (QFilter[])new QFilter[]{new QFilter("dimmapid", "=", (Object)this.vo.getDimMapId()).and(this.getRebuildDataFilter())}, (String)this.getOrders());
        if (doc != null && doc.length > this.maxrow) {
            this.insertRowFromInxdex(this.maxrow - 1, doc.length - this.maxrow + 10);
        }
        int row = 2;
        this.members = new MemberMsgCache(this.plugin.getModelId());
        this.ssid = this.getSSid();
        this.waitForUpdate = new RebuildNameModel();
        log.warn("AbstractMemMapSheetHandel: rebuilddata start");
        if (doc != null && doc.length > 0) {
            for (DynamicObject obj : doc) {
                Cell cell = this.getSheet().getCell(row, this.getSeqIndex());
                cell.setUserObject("id", obj.get("id"));
                this.rebuildJQData(row, obj, invoker);
                ++row;
            }
        }
        log.warn("AbstractMemMapSheetHandel: rebuilddata end");
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (this.waitForUpdate.getList().size() > 0) {
            for (Map<String, Object> map : this.waitForUpdate.getList()) {
                int r = (Integer)map.get("r");
                int c = (Integer)map.get("c");
                this.members.cacheOthersDimMem(map.get("entity").toString(), this.ssid);
                String number = this.waitForUpdate.getValue(map, this.members);
                String name = this.waitForUpdate.getName(map, this.members);
                if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)number)) {
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u5217", (String)"AbstractMemMapSheetHandel_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), r, c));
                    name = "";
                    number = "";
                }
                this.setValueUnChange(r, c, number);
                invoker.updataValue(r, c, name);
            }
        }
        if (errorMsg.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7f3a\u5931", (String)"AbstractMemMapSheetHandel_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Object)errorMsg).toString()));
        }
        invoker.startToInvoke();
    }

    protected String getOrders() {
        return "dseq";
    }

    protected QFilter getRebuildDataFilter() {
        return null;
    }

    protected void setValueUnChange(int row, int col, Object value) {
        Cell cell = this.getSheet().getCell(row, col);
        cell.setValue(value);
        cell.setChangeVal(false);
    }

    protected Object getSSid() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        DynamicObject oriSys = scheme.getDynamicObject("isscheme");
        return oriSys == null ? null : oriSys.get("id");
    }

    protected final String getSrcAccountNum() {
        DynamicObject scheme = (DynamicObject)this.plugin.getView().getModel().getValue("scheme");
        QFilter qFilter = new QFilter("scheme", "=", (Object)scheme.getLong("id"));
        qFilter.and("mappedtype", "=", (Object)DimMappTypeEnum.SINGLE.getCode());
        qFilter.and("number", "like", (Object)"Account%");
        DynamicObject accountMap = QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"number", (QFilter[])new QFilter[]{qFilter});
        return accountMap == null ? "" : accountMap.getString("number").replace("Account-", "");
    }

    protected boolean supportFuzzyMatch() {
        return this.plugin.supportFuzzyMatch();
    }

    protected boolean isFromNGACC() {
        return this.isFromSrc("NGACC");
    }

    protected boolean isFormNGACC_C() {
        return this.isFromSrc("NGACC-C");
    }

    protected boolean isFromMIDLIB() {
        return this.isFromSrc("MIDLIB");
    }

    protected boolean isFromJQ() {
        return this.isFromSrc("JQ") || this.isFromSrc("JQONLINE");
    }

    private boolean isFromSrc(String number) {
        return this.plugin.isFromSrc(number);
    }

    protected boolean isFromEASACC() {
        return this.isFromSrc("EASACC");
    }

    protected Map<String, Object> analysisScope(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (value != null && StringUtils.isNotEmpty((String)((String)value))) {
            String str = ((String)value).toUpperCase(Locale.ENGLISH).trim();
            Pattern pattern = Pattern.compile("(?<=\\()[^\\)]+");
            Matcher matcher = pattern.matcher((String)value);
            String content = "";
            while (matcher.find()) {
                content = matcher.group();
            }
            if (str.contains("BETWEEN(")) {
                result.put("scope", MapScopeEnum.RANGE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.contains("LIKE(")) {
                result.put("scope", MapScopeEnum.LIKE.getIndex());
                result.put("items", Collections.singletonList(content));
                return result;
            }
            if (str.contains("IN(")) {
                result.put("scope", MapScopeEnum.INCLUDE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            result.put("scope", MapScopeEnum.EQUALS.getIndex());
            result.put("items", Collections.singletonList(value));
            return result;
        }
        return result;
    }

    protected Set<String> getEntityNumber() {
        if (this.entityNumber == null) {
            DynamicObject scheme = (DynamicObject)this.getView().getModel().getValue("scheme");
            QFilter qFilter = new QFilter("scheme", "=", (Object)scheme.getLong("id"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"entitynumber", (QFilter[])qFilter.toArray());
            this.entityNumber = dynamicObjects.stream().map(d -> d.getString("entitynumber")).collect(Collectors.toSet());
        }
        return this.entityNumber;
    }

    protected void addMsgToStringBuilder(Cell cell, StringBuilder sb) {
        if (this.ifCellisNull(cell)) {
            sb.append(NULL);
        } else {
            sb.append(cell.getValue().toString());
        }
    }
}

