/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.membermap.handel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RowColExcuteEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.intergration.membermap.handel.AbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.intergration.scheme.PubMemberMappingPlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public abstract class PubAbstractMemMapSheetHandel {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractMemMapSheetHandel.class);
    protected static final int CHANGESIGN_INDEX = 0;
    protected static final String ALL = "*";
    protected PubMemberMappingPlugin plugin;
    protected String spreadKey;
    protected SpreadManager sm;
    protected MemAndComVO vo;
    protected Map<String, Integer> srcSignColIndex;
    protected Map<String, Integer> targetSignColIndex;
    protected Map<String, Integer> otherSignColIndex;
    protected Map<Integer, String> colSignIndex;
    protected int maxrow;
    protected int maxcol;

    protected abstract void buildSheet();

    protected String getSelectFiled() {
        return null;
    }

    protected String getDynamicObjectType() {
        return "bcm_issinglemap";
    }

    protected abstract void checkBeforeSave();

    public PubAbstractMemMapSheetHandel(PubMemberMappingPlugin plugin) {
        this.plugin = plugin;
        this.spreadKey = plugin.getSpreadKey();
        this.sm = plugin.getSpreadManager();
        this.vo = plugin.getMemAndComVO();
        int num = this.vo.getSourcePro().size() + this.vo.getTargetPro().size();
        this.maxcol = num * 2 + 10;
        this.initMaxRow();
    }

    private void initMaxRow() {
        this.maxrow = 10000;
    }

    public void buildSpread() {
        log.startWatch();
        log.warn("DiAbstractMemMapSheetHandel: queryDimmapping");
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
        log.warn("DiAbstractMemMapSheetHandel: else");
        this.sm = new SpreadManager(ResManager.loadKDString((String)"\u96c6\u6210\u6210\u5458\u53ca\u7ec4\u5408\u6620\u5c04", (String)"AbstractMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        this.rebuildData();
        SpreadClientInvoker.invokeCloseToolBar(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.allowExtendPasteRange.k(), (Object)true));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)false));
        SpreadClientInvoker.invokeSetWorkbookOptions(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.defaultDragFillType.k(), (Object)0));
        this.plugin.cacheSpreadModel(this.sm);
        log.infoEnd("DiAbstractMemMapSheetHandel: end");
    }

    public void clearSpread() {
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey(), this.getEmptyJson(this.maxrow, this.maxcol));
    }

    public void beforeUpdateMulValue(NotifyEvent event) {
        event.setCancel(true);
        SpreadPostDataInfo data = (SpreadPostDataInfo)event.getParam();
        List value = data.getValues();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        invoker.setBatch(true);
        for (LinkedHashMap map : value) {
            Cell cell = this.getSheet().getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue());
            String sign = this.getSignByCol((Integer)map.get("c"));
            String valueString = map.get("v") == null ? "" : map.get("v").toString().trim();
            this.setCellChange(cell);
            if (StringUtils.isNotEmpty((String)sign)) {
                if (this.isSrcSign(sign)) {
                    this.srcGetValueChange(invoker, cell, sign, valueString);
                    continue;
                }
                if (!this.isTargetSign(sign)) continue;
                this.targetValueChange(invoker, cell, sign, valueString);
                continue;
            }
            cell.setValue((Object)valueString);
        }
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    private void srcGetValueChange(SpreadEasyInvoker invoker, Cell cell, String sign, String value) {
        String dimNumber = this.getDimNumberByKey(sign);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)dimNumber, (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)value)});
        if (dyn != null) {
            this.setCellValue(invoker, cell, value, (String)dyn.get("name"), 0L);
        } else {
            this.setCellValue(invoker, cell, null, null, 0L);
            if (StringUtils.isNotEmpty((String)value)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6e90\u7cfb\u7edf\u6210\u5458\u5728\u5f53\u524d\u5b9e\u4f53\u4e2d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u9664\u3002", (String)"SingleMemMapSheetHandel_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterUpdataValue(EventObject e) {
        Cell cell = (Cell)e.getSource();
        Cell head = this.getHeader(cell.getCol());
        if (head != null) {
            this.setCellChange(cell);
        }
    }

    private void rebuildData() {
        this.buildSheet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        invoker.setBatch(true);
        String selectFiled = this.getSelectFiled();
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)this.getDynamicObjectType(), (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("pubmappingid", "=", (Object)this.vo.getDimMapId())}, (String)"dseq");
        if (doc != null && doc.length > this.maxrow) {
            this.insertRowFromInxdex(this.maxrow - 1, doc.length - this.maxrow + 10);
        }
        int row = 2;
        log.warn("AbstractMemMapSheetHandel: rebuilddata start");
        HashMap<Long, Integer> tarDimIndex = new HashMap<Long, Integer>(16);
        tarDimIndex.put(((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getId(), 0);
        HashMap<Long, Integer> srcDimIndex = new HashMap<Long, Integer>(16);
        srcDimIndex.put(((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId(), 2);
        if (doc != null && doc.length > 0) {
            for (DynamicObject obj : doc) {
                Cell cell = this.getSheet().getCell(row, 0);
                cell.setUserObject("id", obj.get("id"));
                cell.setUserObject("seq", obj.get("dseq"));
                this.rebuildData(row, obj, invoker, tarDimIndex, srcDimIndex);
                ++row;
            }
        }
        log.warn("AbstractMemMapSheetHandel: rebuilddata end");
        invoker.startToInvoke();
    }

    protected void rebuildData(int row, DynamicObject rowData, SpreadEasyInvoker invoker, Map<Long, Integer> tarDimIndex, Map<Long, Integer> srcDimIndex) {
        String number = rowData.getString("targmembnumber");
        String name = rowData.getString("targmembname");
        this.setValueUnChange(row, 0, number);
        invoker.updataValue(row, 0, number);
        this.setValueUnChange(row, 1, name);
        invoker.updataValue(row, 1, name);
        number = rowData.getString("srcmembnumber");
        name = rowData.getString("srcmembname");
        this.setValueUnChange(row, 2, number);
        invoker.updataValue(row, 2, number);
        this.setValueUnChange(row, 3, name);
        invoker.updataValue(row, 3, name);
    }

    public void insertRowFromInxdex(int row, int num) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            insertdata.add(row);
        }
        AskExcuteInfo excuteinfo = new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCon(true);
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.plugin.updateRowAndCol(excuteinfo);
    }

    protected Sheet getSheet() {
        return this.sm.getBook().getSheet(0);
    }

    protected boolean isAllNone(int row) {
        for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
            Cell cell;
            String sign = this.getSignByCol(col);
            if (sign == null || this.cellIsNull(cell = this.getSheet().getCell(row, col))) continue;
            return false;
        }
        return true;
    }

    public Pair<Map<Long, DynamicObject>, List<DynamicObject>> collectDynamicObjects(List<Cell> cells) {
        ArrayList<DynamicObject> updateRow = new ArrayList<DynamicObject>();
        HashMap<Integer, Object> editids = new HashMap<Integer, Object>();
        HashMap<Long, DynamicObject> insertRow = new HashMap<Long, DynamicObject>(16);
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, 0);
            boolean isAllNone = this.isAllNone(row);
            if (cell.getUserObject("ischange") == null) {
                if (isAllNone) continue;
                cells.add(cell);
                continue;
            }
            Object id = cell.getUserObject("id");
            if (id == null) {
                if (isAllNone) {
                    cell.removeUserObject("ischange");
                    continue;
                }
                DynamicObject object = this.packDynamicObject(row);
                if (object == null) continue;
                id = GlobalIdUtil.genGlobalLongId();
                object.set("id", id);
                object.set("pubmappingid", (Object)this.vo.getDimMapId());
                this.setCreateTimeAndUser(object);
                this.setModifyTimeAndUser(object);
                insertRow.put((Long)id, object);
                cell.setUserObject("id", id);
                cell.setUserObject("isnew", (Object)true);
            } else {
                if (isAllNone) {
                    cell.removeUserObject("id");
                    cell.removeUserObject("ischange");
                    continue;
                }
                editids.put(row, id);
            }
            cell.removeUserObject("ischange");
            cells.add(cell);
        }
        if (editids.size() > 0) {
            DynamicObject[] docs = BusinessDataServiceHelper.load((Object[])editids.values().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)this.getDynamicObjectType()).getDynamicObjectType());
            Map<Object, DynamicObject> col = this.resultToMap(docs);
            for (Map.Entry v : editids.entrySet()) {
                DynamicObject object = this.updateDynamicObject((Integer)v.getKey(), col.get(v.getValue()));
                this.setModifyTimeAndUser(object);
                updateRow.add(object);
            }
        }
        return Pair.onePair(insertRow, updateRow);
    }

    private Map<Object, DynamicObject> resultToMap(DynamicObject[] objects) {
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject ob : objects) {
            map.put(ob.get("id"), ob);
        }
        return map;
    }

    protected void setCreateTimeAndUser(DynamicObject object) {
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
    }

    protected void setModifyTimeAndUser(DynamicObject object) {
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)TimeServiceHelper.now());
    }

    protected String getEmptyJson(int maxrow, int maxcol) {
        return "{\"version\":\"10.0.1\",\"sheets\":{\"sheet1\":{\"name\":\"sheet1\",\"rowCount\":\"" + maxrow + "\",\"columnCount\":\"" + maxcol + "\"}}}";
    }

    protected Map<String, Object> getStyleMap(boolean setFrame) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#b2b2b2");
        if (setFrame) {
            HashMap<String, String[]> styleMap0 = new HashMap<String, String[]>();
            styleMap0.put("bls", new String[]{"thin"});
            styleMap0.put("blc", new String[]{"#000000"});
            styleMap.put("bl", styleMap0);
        }
        styleMap.put(SpreadProperties.SetCellStyleMethod.HORIZONTALALIGN.k(), 1);
        styleMap.put(SpreadProperties.SetCellStyleMethod.DIRECTIONALIGN.k(), 1);
        return styleMap;
    }

    protected void setValueUnChange(int row, int col, Object value) {
        Cell cell = this.getSheet().getCell(row, col);
        cell.setValue(value);
        cell.setChangeVal(false);
    }

    public final IFormView getView() {
        return this.plugin.getView();
    }

    protected void targetValueChange(SpreadEasyInvoker invoker, Cell cell, String sign, String value) {
        String dimNumber = this.getDimNumberByKey(sign);
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.plugin.getModelNumber(), (String)dimNumber, (String)value);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(node)) {
            this.setCellValue(invoker, cell, value, node.getName(), node.getBaseTreeNode().getId());
        } else {
            this.setCellValue(invoker, cell, null, null, 0L);
            if (StringUtils.isNotEmpty((String)value)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u76ee\u6807\u7cfb\u7edf\u6210\u5458\u5728\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u9664\u3002", (String)"SingleMemMapSheetHandel_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setCellValue(SpreadEasyInvoker invoker, Cell cell, String number, String name, Long id) {
        cell.setUserObject("tarId", (Object)id);
        cell.setValue((Object)number);
        invoker.updataValue(cell.getRow(), cell.getCol(), number);
        this.getSheet().getCell(cell.getRow(), cell.getCol() + 1).setValue((Object)name);
        invoker.updataValue(cell.getRow(), cell.getCol() + 1, name);
    }

    protected String getDimNumberByKey(String key) {
        if (key.contains("!")) {
            return key.split("!")[1];
        }
        return key;
    }

    protected Cell getHeader(int col) {
        int maxrow = this.getSheet().getMaxRowCount();
        for (int i = 1; i < maxrow; ++i) {
            Cell cell = this.getSheet().getCell(i, col);
            if (cell.getUserObject("entitysign") == null) continue;
            return cell;
        }
        return null;
    }

    protected void setCellChange(Cell cell) {
        cell.setChangeVal(true);
        Cell seqCell = this.getSheet().getCell(cell.getRow(), 0);
        seqCell.setUserObject("ischange", (Object)true);
        this.getSheet().putUserObject("change", (Object)true);
    }

    public void actionSave() {
        try {
            log.startWatch();
            this.initSignColMap();
            this.checkBeforeSave();
            log.info("PubAbstractMemMapSheetHandel checkData " + this.plugin.getMemAndComVO().getDimMapId());
            ArrayList<Cell> cells = new ArrayList<Cell>();
            Pair<Map<Long, DynamicObject>, List<DynamicObject>> datas = this.collectDynamicObjects(cells);
            List<Object> notDeleteId = this.collectNotDeleteids();
            this.simpleModel();
            if (this.getSheet().getUserObject() != null) {
                this.getSheet().getUserObject().remove("change");
            }
            Map<Integer, List<Object>> updateRowSeq = this.dealSeq(cells, (Map)datas.p1);
            log.info("DiAbstractMemMapSheetHandel collectData " + this.plugin.getMemAndComVO().getDimMapId());
            List need2Save = (List)datas.p2;
            need2Save.addAll(((Map)datas.p1).values());
            this.saveData(need2Save, notDeleteId, updateRowSeq);
            this.writeSaveSuccessLog();
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractMemMapSheetHandel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.plugin.cacheSpreadModel(this.sm);
            log.infoEnd("DiAbstractMemMapSheetHandel saveData " + this.plugin.getMemAndComVO().getDimMapId());
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private List<Object> collectNotDeleteids() {
        ArrayList<Object> nodeleteid = new ArrayList<Object>();
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell cell = this.getSheet().getCell(row, 0);
            Object id = cell.getUserObject("id");
            if (id == null) continue;
            nodeleteid.add(id);
        }
        return nodeleteid;
    }

    private void saveData(List<DynamicObject> need2Save, List<Object> notDeleteId, Map<Integer, List<Object>> updateRowSeq) {
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                QFilter notid = new QFilter("id", "not in", notDeleteId);
                QFilter dimmap = new QFilter("pubmappingid", "=", (Object)this.vo.getDimMapId());
                DeleteServiceHelper.delete((String)this.getDynamicObjectType(), (QFilter[])new QFilter[]{notid, dimmap});
                SaveServiceHelper.save((DynamicObject[])need2Save.toArray(new DynamicObject[0]));
                this.updateSeq(updateRowSeq);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    protected void simpleModel() {
        for (int row = 0; row < this.getSheet().getMaxRowCount(); ++row) {
            Cell seqCell = this.getSheet().getCell(row, 0);
            if (seqCell.getUserObject("ischange") != null || seqCell.getUserObject("entitysign") != null) continue;
            for (int col = 0; col < this.getSheet().getMaxColumnCount(); ++col) {
                Cell cell = this.getSheet().getCell(row, col);
                cell.removeUserObject("KEY_DIM_FLAG");
                cell.setChangeVal(false);
            }
        }
    }

    protected Map<Integer, List<Object>> dealSeq(List<Cell> cells, Map<Long, DynamicObject> insertRow) {
        int insertRowNum = 0;
        int preSeq = 0;
        HashMap<Integer, List<Object>> updateRowSeq = new HashMap<Integer, List<Object>>(16);
        for (Cell cell : cells) {
            int seq;
            Long id = (Long)cell.getUserObject("id");
            if (((Boolean)cell.getUserObject("isnew", (Object)false)).booleanValue()) {
                seq = preSeq + 1;
                DynamicObject row = insertRow.get(id);
                if (row != null) {
                    row.set("dseq", (Object)seq);
                }
                ++insertRowNum;
                preSeq = seq;
            } else {
                if (insertRowNum != 0) {
                    updateRowSeq.computeIfAbsent(insertRowNum, l -> new ArrayList());
                    List ids = (List)updateRowSeq.get(insertRowNum);
                    ids.add(id);
                }
                preSeq = seq = (Integer)cell.getUserObject("seq") + insertRowNum;
            }
            cell.removeUserObject("isnew");
            cell.setUserObject("seq", (Object)seq);
        }
        return updateRowSeq;
    }

    private void updateSeq(Map<Integer, List<Object>> updateRowSeq) {
        updateRowSeq.forEach((k, v) -> {
            SqlBuilder sql = new SqlBuilder();
            sql.append("update t_bcm_issinglemap set fseq = fseq + ? where", new Object[]{k});
            sql.appendIn("fid", v);
            DB.execute((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)sql);
        });
    }

    protected void writeSaveSuccessLog() {
        String nodeName;
        TreeView tree = (TreeView)this.plugin.getView().getControl("simpletree");
        try {
            nodeName = tree.getTreeState().getFocusNode().get("text").toString();
        }
        catch (NullPointerException e) {
            nodeName = ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        String name = ResManager.loadKDString((String)"\u516c\u5171\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.plugin.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fdd\u5b58\u516c\u5171\u6210\u5458\u6620\u5c04", "AbstractMemMapSheetHandel_15", "fi-bcm-formplugin", "Save public mapping"), new OPDescMultiLangEnumBridge("%1$s\uff0c%2$s\u4fdd\u5b58\u6210\u529f\u3002", "AbstractMemMapSheetHandel_12", "fi-bcm-formplugin", new String[]{name, nodeName}));
    }

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u516c\u5171\u6210\u5458\u6620\u5c04", (String)"AbstractMemMapSheetHandel_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    protected String buildColEntityKey(String entity, String dimNum) {
        return entity + "!" + dimNum;
    }

    protected String buildEntityNameByNode(MemAndComVO.Node node) {
        return this.buildColEntityKey(node.getEntityName(), node.getNumber());
    }

    protected String getSignByCol(int col) {
        if (this.colSignIndex == null) {
            this.colSignIndex = new HashMap<Integer, String>();
        }
        if (!this.colSignIndex.containsKey(col)) {
            Cell head = this.getHeader(col);
            if (head != null) {
                this.colSignIndex.put(col, head.getUserObject("entitysign").toString());
            } else {
                this.colSignIndex.put(col, null);
            }
        }
        return this.colSignIndex.get(col);
    }

    protected int getFirstSrcCol() {
        String firstSrc = this.plugin.getPageCache().get("firstsrc");
        if (firstSrc == null) {
            return -1;
        }
        return Integer.parseInt(firstSrc);
    }

    protected void cacheFirstSrcCol(int col) {
        this.plugin.getPageCache().put("firstsrc", "" + col);
    }

    public void initSignColMap() {
        this.srcSignColIndex = new HashMap<String, Integer>();
        this.targetSignColIndex = new HashMap<String, Integer>();
        this.otherSignColIndex = new HashMap<String, Integer>();
        int maxcol = this.getSheet().getMaxColumnCount();
        for (int col = 0; col < maxcol; ++col) {
            Cell cell = this.getSheet().getCell(1, col);
            if (cell.getUserObject("entitysign") == null) continue;
            String sign = cell.getUserObject("entitysign").toString();
            if (sign.contains("!")) {
                int firstSrcCol = this.getFirstSrcCol();
                if (firstSrcCol != -1 && col >= firstSrcCol) {
                    this.srcSignColIndex.put(sign, col);
                    continue;
                }
                this.targetSignColIndex.put(sign, col);
                continue;
            }
            this.otherSignColIndex.put(sign, col);
        }
    }

    protected int getSrcColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.srcSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.srcSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    protected int getTargetColByEntity(String entity, String dimNum) {
        Integer col;
        String entitySign = this.getEntitySign(entity, dimNum);
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return (col = this.targetSignColIndex.get(entitySign)) == null ? -1 : col;
    }

    private boolean isTargetSign(String sign) {
        if (this.targetSignColIndex == null) {
            this.initSignColMap();
        }
        return this.targetSignColIndex.containsKey(sign);
    }

    private boolean isSrcSign(String sign) {
        if (this.srcSignColIndex == null) {
            this.initSignColMap();
        }
        return this.srcSignColIndex.containsKey(sign);
    }

    private String getEntitySign(String entity, String dimNum) {
        if (dimNum != null) {
            entity = this.buildColEntityKey(entity, dimNum);
        } else {
            String number = DimEntityNumEnum.getNumberByEntieyNum((String)entity);
            if (StringUtils.isNotEmpty((String)number)) {
                entity = this.buildColEntityKey(entity, number);
            }
        }
        return entity;
    }

    protected boolean cellIsNull(Cell cell) {
        return cell.getValue() == null || StringUtils.isEmpty((String)cell.getValue().toString());
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spreadKey);
        Cell cell = this.getSheet().getCell(arg.getR(), arg.getC());
        invoker.updataValue(arg.getR(), arg.getC(), arg.getName());
        cell.setValue((Object)arg.getId());
        this.setCellChange(cell);
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    protected DynamicObject packDynamicObject(int row) {
        return this.getDynamicObject(row, null);
    }

    protected DynamicObject updateDynamicObject(int row, DynamicObject oldValue) {
        return this.getDynamicObject(row, oldValue);
    }

    protected DynamicObject getDynamicObject(int row, DynamicObject object) {
        boolean isNew = false;
        if (object == null) {
            isNew = true;
            object = BusinessDataServiceHelper.newDynamicObject((String)this.getDynamicObjectType());
        }
        this.handleTarMem(row, object, isNew);
        this.handleSrcMem(row, object, isNew);
        return object;
    }

    private void handleTarMem(int row, DynamicObject object, boolean isNew) {
        for (MemAndComVO.Node node : this.vo.getTargetPro()) {
            int col = this.getTargetColByEntity(this.buildEntityNameByNode(node), null);
            Cell cell = this.getSheet().getCell(row, col);
            object.set("targmembnumber", (Object)cell.getValue().toString());
            object.set("targmembid", cell.getUserObject("tarId"));
            cell = this.getSheet().getCell(row, col + 1);
            object.set("targmembname", (Object)(cell.getValue() == null ? "" : cell.getValue().toString()));
        }
    }

    private void handleSrcMem(int row, DynamicObject object, boolean isNew) {
        String srcmembnumber = "";
        for (MemAndComVO.Node node : this.vo.getSourcePro()) {
            int col = this.getSrcColByEntity(this.buildEntityNameByNode(node), null);
            Cell cell = this.getSheet().getCell(row, col);
            srcmembnumber = cell.getValue().toString();
            object.set("srcmembnumber", (Object)srcmembnumber);
            cell = this.getSheet().getCell(row, col + 1);
            object.set("srcmembname", (Object)(cell.getValue() == null ? "" : cell.getValue().toString()));
        }
        object.set("scope", (Object)"1");
        DynamicObjectCollection issinglemapentry = object.getDynamicObjectCollection("issinglemapentry");
        DynamicObject singleEntry = new DynamicObject();
        singleEntry = isNew ? issinglemapentry.addNew() : (issinglemapentry.size() > 0 ? (DynamicObject)issinglemapentry.get(0) : issinglemapentry.addNew());
        singleEntry.set("srcdim", (Object)((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId());
        singleEntry.set("srcmemnumber", (Object)srcmembnumber);
        singleEntry.set("seq", (Object)0);
    }
}

