/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.membermap.handel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.JqReportTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.intergration.membermap.handel.AbstractMemMapSheetHandel;
import kd.fi.bcm.formplugin.intergration.scheme.ISDimMemberAndComSettingPlugin;
import kd.fi.bcm.formplugin.report.ReportDataSelectScheme;
import kd.fi.bcm.formplugin.report.util.ReportDataSchemeUtil;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;

public class SingleMemMapSheetHandel
extends AbstractMemMapSheetHandel {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(SingleMemMapSheetHandel.class);
    private Map<String, String> reportDataTypeMap;

    public SingleMemMapSheetHandel(ISDimMemberAndComSettingPlugin plugin, String spKey) {
        super(plugin, spKey);
    }

    @Override
    protected void initMaxRow() {
        super.initMaxRow();
        String entity = this.isSrcNg ? ((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getEntityName() : ((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getEntityName();
        if (this.isFromJQ()) {
            this.maxrow = 2000;
        } else if (DimEntityNumEnum.INTERCOMPANY.getEntityNum().equals(entity) || DimEntityNumEnum.MYCOMPANY.getEntityNum().equals(entity) || DimEntityNumEnum.ENTITY.getEntityNum().equals(entity)) {
            this.maxrow = 10000;
        }
    }

    @Override
    public void buildSheet() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.setBatch(true);
        invoker.setSpan(0, 1 + this.hasseq, 1, 2);
        int col = 5 + this.hasseq;
        if (this.supportFuzzyMatch()) {
            col = 4 + this.hasseq;
        } else {
            invoker.setSpan(0, 3 + this.hasseq, 1, 2);
        }
        invoker.setStyle(0, 0, 2, col, this.getStyleMap());
        invoker.updataValue(0, 1 + this.hasseq, ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"SingleMemMapSheetHandel_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.updataValue(0, 3 + this.hasseq, ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"SingleMemMapSheetHandel_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.updataValue(1, 1 + this.hasseq, ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801", (String)"SingleMemMapSheetHandel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getSheet().getCell(1, 1 + this.hasseq).setUserObject("entitysign", (Object)this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)));
        invoker.setColumnsWidth(1 + this.hasseq, 100);
        invoker.updataValue(1, 2 + this.hasseq, ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"SingleMemMapSheetHandel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(2 + this.hasseq, 150);
        invoker.updataValue(1, 3 + this.hasseq, ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801", (String)"SingleMemMapSheetHandel_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getSheet().getCell(1, 3 + this.hasseq).setUserObject("entitysign", (Object)this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getSourcePro().get(0)));
        this.cacheFirstSrcCol(3 + this.hasseq);
        invoker.setColumnsWidth(3 + this.hasseq, 100);
        if (!this.supportFuzzyMatch()) {
            invoker.setF7TypeCell(2, 1 + this.hasseq, this.maxrow, 1, 0, 0);
            invoker.setF7TypeCell(2, 3 + this.hasseq, this.maxrow, 1, 0, 0);
            invoker.updataValue(1, 4 + this.hasseq, ResManager.loadKDString((String)"\u6210\u5458\u540d\u79f0", (String)"SingleMemMapSheetHandel_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            invoker.setColumnsWidth(4 + this.hasseq, 150);
        }
        invoker.setFrozenSheet(2, col, 0, 0, "#A2CD5A", 0);
        invoker.lockCell(0, 0, 2, col);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), "@");
        invoker.setStyle(0, 0, this.maxrow, col, styleMap);
        invoker.startToInvoke();
    }

    @Override
    public void buildJQSheet() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cel = new HashMap<String, Integer>();
        cel.put(SpreadProperties.LockCellMethod.R.k(), 0);
        cel.put(SpreadProperties.LockCellMethod.C.k(), 1);
        cel.put(SpreadProperties.LockCellMethod.RC.k(), 1000);
        cel.put(SpreadProperties.LockCellMethod.CC.k(), 1);
        cells.add(cel);
        SpreadClientInvoker.invokeLockCellMethod(this.plugin.getClientViewProxy(), this.spKey, cells);
        invoker.setBatch(true);
        invoker.setSpan(0, 1 + this.hasseq, 1, 2);
        int col = 7 + this.hasseq;
        invoker.setSpan(0, 3 + this.hasseq, 1, 4);
        invoker.setStyle(0, 0, 2, col, this.getStyleMap());
        invoker.updataValue(0, 1 + this.hasseq, ResManager.loadKDString((String)"\u661f\u701a", (String)"SingleMemMapSheetHandel_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.updataValue(0, 3 + this.hasseq, ResManager.loadKDString((String)"\u4e45\u5176", (String)"SingleMemMapSheetHandel_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.updataValue(1, 1 + this.hasseq, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setF7TypeCell(2, 1 + this.hasseq, this.maxrow, 1, 0, 0);
        this.getSheet().getCell(1, 1 + this.hasseq).setUserObject("entitysign", (Object)this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)));
        invoker.setColumnsWidth(1 + this.hasseq, 100);
        invoker.updataValue(1, 2 + this.hasseq, ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"MultiExportFileRulePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(2 + this.hasseq, 250);
        invoker.updataValue(1, 3 + this.hasseq, ResManager.loadKDString((String)"\u672c\u4f01\u4e1a\u4ee3\u7801", (String)"SingleMemMapSheetHandel_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(3 + this.hasseq, 150);
        invoker.updataValue(1, 4 + this.hasseq, ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"SingleMemMapSheetHandel_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(4 + this.hasseq, 250);
        invoker.updataValue(1, 5 + this.hasseq, ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u7801", (String)"SingleMemMapSheetHandel_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(5 + this.hasseq, 150);
        invoker.updataValue(1, 6 + this.hasseq, ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e", (String)"SingleMemMapSheetHandel_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        invoker.setColumnsWidth(6 + this.hasseq, 150);
        ArrayList<Map<String, Integer>> dropdownList = new ArrayList<Map<String, Integer>>();
        HashMap<String, Integer> dropdown = new HashMap<String, Integer>();
        dropdown.put("c", 5 + this.hasseq);
        dropdown.put("rc", this.maxrow);
        dropdownList.add(dropdown);
        dropdown = new HashMap();
        dropdown.put("c", 6 + this.hasseq);
        dropdown.put("rc", this.maxrow);
        dropdownList.add(dropdown);
        invoker.setFrozenSheet(2, col, 0, 0, "#A2CD5A", 0);
        invoker.lockCell(0, 0, 2, col);
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), "@");
        invoker.setStyle(0, 0, this.maxrow, col, styleMap);
        this.setF7DropdownStyle(dropdownList);
        ArrayList<Map> toolbarItems = new ArrayList<Map>();
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)SpreadProperties.ToolbarItemNamesEnum.MergeCells, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)true));
        SpreadClientInvoker.invokeLockToolbarItems(this.plugin.getClientViewProxy(), this.spKey, toolbarItems);
        invoker.startToInvoke();
        this.cacheReportDataTypeMap();
    }

    private void setF7DropdownStyle(List<Map<String, Integer>> dropdownList) {
        ArrayList items = new ArrayList(10);
        for (Map<String, Integer> map : dropdownList) {
            Integer rc = map.get("rc");
            for (int i = 2; i < rc; ++i) {
                HashMap<String, Integer> cell = new HashMap<String, Integer>(16);
                cell.put(SpreadProperties.LockCellMethod.R.k(), i);
                cell.put(SpreadProperties.LockCellMethod.C.k(), map.get("c"));
                items.add(cell);
            }
        }
        HashMap<String, Serializable> features = new HashMap<String, Serializable>(16);
        features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(1));
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(0));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.plugin.getClientViewProxy(), this.spKey, features);
    }

    private void cacheReportDataTypeMap() {
        ReportDataSelectScheme rdss = ReportDataSchemeUtil.getReportDataSelectScheme(new SchemeContext(this.plugin.getModelId()), "2");
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashMap<String, String> numberNameMap = new HashMap<String, String>(16);
        for (ComboItem item : rdss.getExportComboItems()) {
            map.put(item.getCaption().getLocaleValue(), item.getValue());
            numberNameMap.put(item.getValue(), item.getCaption().getLocaleValue());
        }
        rdss.cacheReportDataSelectScheme(this.plugin.getPageCache());
        this.plugin.getPageCache().put("reportDataMap", ObjectSerialUtil.toByteSerialized(map));
        this.plugin.getPageCache().put("reportDataTypeNumberMap", ObjectSerialUtil.toByteSerialized(numberNameMap));
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        int col = args.getC();
        if (col != 4 && col != 5) {
            super.spreadF7LookUpData(args);
            return;
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(16);
        ArrayList arrs = new ArrayList(10);
        if (col == 4) {
            for (JqReportTypeEnum reportType : JqReportTypeEnum.values()) {
                ArrayList<Object> arr = new ArrayList<Object>();
                arr.add(reportType.getCode());
                arr.add(reportType.getName());
                arr.add(reportType.getName());
                arrs.add(arr);
            }
        } else {
            ReportDataSelectScheme rdss = ReportDataSelectScheme.getReportDataSelectScheme(this.plugin.getPageCache());
            if (rdss != null) {
                for (ComboItem item : rdss.getExportComboItems()) {
                    ArrayList<String> arr = new ArrayList<String>();
                    arr.add(item.getValue());
                    arr.add(item.getValue());
                    arr.add(item.getCaption().getLocaleValue());
                    arrs.add(arr);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u62a5\u8868\u6570\u636e\u3002", (String)"SingleMemMapSheetHandel_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        data.put("data", arrs);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        this.plugin.getClientViewProxy().invokeControlMethod(this.spKey, "setLookupData", new Object[]{data});
    }

    @Override
    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        int col = arg.getC();
        if (col != 4 && col != 5) {
            super.setSpreadF7Item(arg);
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
        invoker.updataValue(arg.getR(), arg.getC(), arg.getName());
        Cell cell = this.getSheet().getCell(arg.getR(), arg.getC());
        if (col == 4) {
            cell.setValue((Object)arg.getId());
        } else {
            cell.setValue((Object)arg.getNumber());
        }
        this.setCellChange(cell);
        invoker.startToInvoke();
        this.plugin.cacheSpreadModel(this.sm);
    }

    @Override
    protected void showF7Value(int r, int c, DimMember mem, SpreadEasyInvoker invoker) {
        invoker.updataValue(r, c, mem.getNumber());
        invoker.updataValue(r, c + 1, mem.getName());
    }

    @Override
    protected DynamicObject packDynamicObject(int row) {
        int sorCol = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getSourcePro().get(0)), null);
        if (this.isFromJQ()) {
            sorCol = 3 + this.hasseq;
        }
        int tarCol = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)), null);
        Cell sor = this.getSheet().getCell(row, sorCol);
        Cell tar = this.getSheet().getCell(row, tarCol);
        if (this.ifCellisNull(sor) || this.ifCellisNull(tar)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u6570\u636e\u3002", (String)"SingleMemMapSheetHandel_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_issinglemap");
        object.set("scope", (Object)1);
        if (this.supportFuzzyMatch()) {
            object.set("targmembnumber", tar.getValue());
            object.set("targmembname", tar.getValue());
            Object tarUserObject = tar.getUserObject("targetInfo");
            if (tarUserObject != null) {
                object.set("targmembid", ((Map)tarUserObject).get("id"));
                object.set("targmembname", ((Map)tarUserObject).get("name"));
                object.set("targmembnumber", ((Map)tarUserObject).get("number"));
            }
            DynamicObjectCollection issinglemapentry = object.getDynamicObjectCollection("issinglemapentry");
            object.set("srcmembnumber", sor.getValue());
            Map<String, Object> analysisResult = this.analysisScope(sor.getValue());
            if (analysisResult.get("items") != null) {
                object.set("scope", analysisResult.get("scope"));
                List items = (List)analysisResult.get("items");
                int seq = 0;
                for (String num : items) {
                    DynamicObject singleEntry = issinglemapentry.addNew();
                    singleEntry.set("srcdim", (Object)((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId());
                    singleEntry.set("srcmemnumber", (Object)num);
                    singleEntry.set("seq", (Object)seq);
                    ++seq;
                }
            }
        } else if (this.isFromJQ()) {
            DimMember tarmem = (DimMember)tar.getMemberFromUserObject().get(0);
            object.set("srcmembname", this.getSheet().getCell(row, sorCol + 1).getValue());
            object.set("srcmembnumber", this.getSheet().getCell(row, sorCol).getValue());
            Object value = this.getSheet().getCell(row, sorCol + 2).getValue();
            Integer realValue = 0;
            if (this.isMatches(String.valueOf(value))) {
                realValue = Integer.valueOf(String.valueOf(value));
            } else if (value instanceof String) {
                realValue = this.getJqReportTypeCodeByValue((String)value);
            }
            object.set("srcreporttype", (Object)realValue);
            value = this.getSheet().getCell(row, sorCol + 3).getValue();
            object.set("reportdatatype", (Object)value.toString());
            object.set("targmembname", (Object)tarmem.getName());
            object.set("targmembnumber", (Object)tarmem.getNumber());
            object.set("targmembid", (Object)tarmem.getId());
        } else {
            DimMember sormem = (DimMember)sor.getMemberFromUserObject().get(0);
            DimMember tarmem = (DimMember)tar.getMemberFromUserObject().get(0);
            object.set("srcmembname", (Object)sormem.getName());
            object.set("srcmembnumber", (Object)sormem.getNumber());
            object.set("targmembname", (Object)tarmem.getName());
            object.set("targmembnumber", (Object)tarmem.getNumber());
            object.set("targmembid", (Object)tarmem.getId());
            DynamicObjectCollection issinglemapentry = object.getDynamicObjectCollection("issinglemapentry");
            DynamicObject singleEntry = issinglemapentry.addNew();
            singleEntry.set("srcdim", (Object)((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId());
            singleEntry.set("srcmembid", (Object)sormem.getId());
            singleEntry.set("srcmemnumber", (Object)sormem.getNumber());
        }
        return object;
    }

    @Override
    protected DynamicObject updateDynamicObject(int row, DynamicObject oldValue) {
        int sorCol = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getSourcePro().get(0)), null);
        if (this.isFromJQ()) {
            sorCol = 3 + this.hasseq;
        }
        int tarCol = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)), null);
        Cell sor = this.getSheet().getCell(row, sorCol);
        Cell tar = this.getSheet().getCell(row, tarCol);
        if (this.ifCellisNull(sor) || this.ifCellisNull(tar)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u7b2c%s\u884c\u6570\u636e\u3002", (String)"SingleMemMapSheetHandel_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
        }
        if (this.supportFuzzyMatch()) {
            oldValue.set("srcmembnumber", sor.getValue());
            DynamicObjectCollection issinglemapentry = oldValue.getDynamicObjectCollection("issinglemapentry");
            issinglemapentry.clear();
            Map<String, Object> analysisResult = this.analysisScope(sor.getValue());
            if (analysisResult.get("items") != null) {
                oldValue.set("scope", analysisResult.get("scope"));
                List items = (List)analysisResult.get("items");
                int seq = 0;
                for (String num : items) {
                    DynamicObject singleEntry = issinglemapentry.addNew();
                    singleEntry.set("srcdim", (Object)((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId());
                    singleEntry.set("srcmemnumber", (Object)num);
                    singleEntry.set("seq", (Object)seq);
                    ++seq;
                }
            }
            oldValue.set("targmembnumber", tar.getValue());
            oldValue.set("targmembname", tar.getValue());
            Object tarUserObject = tar.getUserObject("targetInfo");
            if (tarUserObject != null) {
                if (tarUserObject instanceof DynamicObject) {
                    oldValue.set("targmembid", ((DynamicObject)tarUserObject).get("id"));
                    oldValue.set("targmembname", ((DynamicObject)tarUserObject).get("name"));
                    oldValue.set("targmembnumber", ((DynamicObject)tarUserObject).get("number"));
                } else if (tarUserObject instanceof Map) {
                    oldValue.set("targmembid", ((Map)tarUserObject).get("id"));
                    oldValue.set("targmembname", ((Map)tarUserObject).get("name"));
                    oldValue.set("targmembnumber", ((Map)tarUserObject).get("number"));
                }
            } else {
                if (tar.getValue() != null && this.vo.getTargetPro().size() > 0) {
                    Long modelId = (Long)this.plugin.getFormCustomParam("KEY_MODEL_ID");
                    IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getNumber(), (String)String.valueOf(tar.getValue()));
                    if (node == null || oldValue.getLong("targmembid") == 0L || !node.getId().equals(oldValue.getLong("targmembid"))) {
                        oldValue.set("targmembid", null);
                    }
                } else {
                    oldValue.set("targmembid", null);
                }
                oldValue.set("targmembname", null);
            }
        } else if (this.isFromJQ()) {
            if (tar.getMemberFromUserObject() != null) {
                DimMember tarmem = (DimMember)tar.getMemberFromUserObject().get(0);
                oldValue.set("targmembname", (Object)tarmem.getName());
                oldValue.set("targmembnumber", (Object)tarmem.getNumber());
                oldValue.set("targmembid", (Object)tarmem.getId());
            }
            oldValue.set("srcmembname", this.getSheet().getCell(row, sorCol + 1).getValue());
            oldValue.set("srcmembnumber", this.getSheet().getCell(row, sorCol).getValue());
            Object value = this.getSheet().getCell(row, sorCol + 2).getValue();
            Integer realValue = 0;
            if (this.isMatches(String.valueOf(value))) {
                realValue = Integer.valueOf(String.valueOf(value));
            } else if (value instanceof String) {
                realValue = this.getJqReportTypeCodeByValue((String)value);
            }
            oldValue.set("srcreporttype", (Object)realValue);
            value = this.getSheet().getCell(row, sorCol + 3).getValue();
            oldValue.set("reportdatatype", (Object)value.toString());
        } else {
            if (sor.getMemberFromUserObject() != null) {
                DimMember sormem = (DimMember)sor.getMemberFromUserObject().get(0);
                oldValue.set("srcmembname", (Object)sormem.getName());
                oldValue.set("srcmembnumber", (Object)sormem.getNumber());
                DynamicObjectCollection issinglemapentry = oldValue.getDynamicObjectCollection("issinglemapentry");
                issinglemapentry.clear();
                DynamicObject singleEntry = issinglemapentry.addNew();
                singleEntry.set("srcdim", (Object)((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getId());
                singleEntry.set("srcmembid", (Object)sormem.getId());
                singleEntry.set("srcmemnumber", (Object)sormem.getNumber());
            }
            if (tar.getMemberFromUserObject() != null) {
                DimMember tarmem = (DimMember)tar.getMemberFromUserObject().get(0);
                oldValue.set("targmembname", (Object)tarmem.getName());
                oldValue.set("targmembnumber", (Object)tarmem.getNumber());
                oldValue.set("targmembid", (Object)tarmem.getId());
            }
        }
        return oldValue;
    }

    private boolean isMatches(String bot) {
        try {
            String regex = "^[1-9]+[0-9]*$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(bot);
            return m.find();
        }
        catch (Exception e) {
            log.error("singleMem check Number error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u7801\u8f6c\u6362\u51fa\u9519\u3002", (String)"SingleMemMapSheetHandel_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected String getDynamicObjectType() {
        return "bcm_issinglemap";
    }

    @Override
    public void autoMatchNG(MemAndComVO memAndComVO, MappingContext mappingContext) {
        this.autoMatch(memAndComVO, mappingContext, true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u661f\u701a\u6210\u5458\u81ea\u52a8\u5339\u914d\u6210\u529f\u3002", (String)"SingleMemMapSheetHandel_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void autoMatch(MemAndComVO memAndComVO, MappingContext mappingContext, boolean type) {
        int trdColumnIndex;
        int ngColumnIndex;
        SpreadManager spreadManager = this.plugin.getSpreadManager();
        Sheet sheet = spreadManager.getBook().getSheet(0);
        int maxRowCount = this.getRealMaxRowCount(sheet, memAndComVO);
        boolean isSrcNg = mappingContext.isSrcNg();
        List targetPro = memAndComVO.getTargetPro();
        List sourcePro = memAndComVO.getSourcePro();
        if (isSrcNg) {
            ngColumnIndex = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)sourcePro.get(0)), null);
            trdColumnIndex = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)targetPro.get(0)), null);
        } else {
            ngColumnIndex = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)targetPro.get(0)), null);
            trdColumnIndex = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)sourcePro.get(0)), null);
        }
        HashSet<String> ngNums = new HashSet<String>(16);
        HashSet<String> trdNums = new HashSet<String>(16);
        for (int i = 2; i < maxRowCount; ++i) {
            Cell ngCell = sheet.getCell(i, ngColumnIndex);
            Cell trdCell = sheet.getCell(i, trdColumnIndex);
            Object ngValue = ngCell.getValue();
            Object trdValue = trdCell.getValue();
            if (ngValue != null) {
                ngNums.add(String.valueOf(ngValue));
            }
            if (trdValue == null) continue;
            trdNums.add(String.valueOf(trdValue));
        }
        DynamicObject model = (DynamicObject)this.plugin.getView().getModel().getValue("model");
        if (model != null) {
            QFilter trdFilter;
            String trdEntityName;
            MemAndComVO.Node trdNode;
            QFilter ngFilter;
            QFilter filters;
            String ngEntityName;
            if (isSrcNg) {
                MemAndComVO.Node node = (MemAndComVO.Node)sourcePro.get(0);
                ngEntityName = node.getEntityName();
                filters = QFilter.of((String)"model = ? and dimension = ? and storagetype != ?", (Object[])new Object[]{model.getLong("id"), node.getId(), StorageTypeEnum.SHARE.index});
                filters.and(new QFilter("number", "not in", ngNums));
                if (SysDimensionEnum.Entity.getMemberTreemodel().equals(ngEntityName)) {
                    filters.and(new QFilter("isexchangerate", "=", (Object)"0"));
                }
                ngFilter = filters;
                trdNode = (MemAndComVO.Node)targetPro.get(0);
                trdEntityName = trdNode.getEntityName();
                trdFilter = mappingContext.getTarget().getDimDetailQFilter(this.getView().getModel(), this.getView());
            } else {
                MemAndComVO.Node node = (MemAndComVO.Node)targetPro.get(0);
                ngEntityName = node.getEntityName();
                filters = QFilter.of((String)"model = ? and dimension = ? and storagetype != ?", (Object[])new Object[]{model.getLong("id"), node.getId(), StorageTypeEnum.SHARE.index});
                filters.and(new QFilter("number", "not in", ngNums));
                if (SysDimensionEnum.Entity.getMemberTreemodel().equals(ngEntityName)) {
                    filters.and(new QFilter("isexchangerate", "=", (Object)"0"));
                }
                ngFilter = filters;
                trdNode = (MemAndComVO.Node)sourcePro.get(0);
                trdEntityName = trdNode.getEntityName();
                trdFilter = mappingContext.getSource().getDimDetailQFilter(this.getView().getModel(), this.getView());
            }
            trdFilter = trdFilter.and(new QFilter("number", "not in", trdNums));
            trdFilter = trdFilter.and(new QFilter("number", "not in", trdNums));
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
            invoker.setBatch(true);
            DataSet ngDimAutoArray = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.intergration.membermap.handel.SingleMemMapSheetHandel.autoMatch.ng", (String)ngEntityName, (String)"id ngid, name ngname, number ngnumber", (QFilter[])ngFilter.toArray(), null);
            DataSet trdDimAutoArray = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.intergration.membermap.handel.SingleMemMapSheetHandel.autoMatch.trd", (String)trdEntityName, (String)"id trdid, name trdname, number trdnumber", (QFilter[])trdFilter.toArray(), null);
            JoinDataSet join = type ? ngDimAutoArray.leftJoin(trdDimAutoArray) : ngDimAutoArray.join(trdDimAutoArray);
            int[] maxRowCountarray = new int[]{maxRowCount};
            try (DataSet resultDataSet = join.on("ngnumber", "trdnumber").select("ngid, ngnumber, ngname".split(","), "trdid, trdname, trdnumber".split(",")).finish();){
                HashMap exisSrcRule = new HashMap();
                HashMap exisTagRule = new HashMap();
                int count = resultDataSet.copy().count("ngnumber", false);
                if (count > 0) {
                    this.insertRowFromInxdex(maxRowCount, count);
                }
                resultDataSet.forEach(dataRow -> {
                    String ruleValue = dataRow.getString("ngid");
                    String srcValue = dataRow.getString("trdid");
                    if (exisTagRule.get(ruleValue) == null && (srcValue == null || exisSrcRule.get(srcValue) == null)) {
                        exisTagRule.put(ruleValue, ruleValue);
                        if (srcValue != null) {
                            exisSrcRule.put(srcValue, srcValue);
                        }
                    } else {
                        return;
                    }
                    int rowIndex = maxRowCountarray[0];
                    maxRowCountarray[0] = maxRowCountarray[0] + 1;
                    Cell ngCellTemp = sheet.getCell(rowIndex, ngColumnIndex);
                    Cell ngNameCell = sheet.getCell(rowIndex, ngColumnIndex + 1);
                    Cell trdCellTemp = sheet.getCell(rowIndex, trdColumnIndex);
                    Cell trdNameCell = sheet.getCell(rowIndex, trdColumnIndex + 1);
                    ngCellTemp.setValue((Object)dataRow.getString("ngnumber"));
                    DimMember mem = this.packMem(dataRow.getString("ngname"), dataRow.getString("ngnumber"), "", "");
                    mem.setId(dataRow.getLong("ngid").longValue());
                    ngCellTemp.addDim2UserObject((IDimMember)mem);
                    ngNameCell.setValue((Object)dataRow.getString("ngname"));
                    this.setCellChange(ngCellTemp);
                    this.setCellChange(ngNameCell);
                    invoker.updataValue(rowIndex, ngColumnIndex, ngCellTemp.getValue());
                    invoker.updataValue(rowIndex, ngColumnIndex + 1, ngNameCell.getValue());
                    if (dataRow.getLong("trdid") != null) {
                        trdCellTemp.setValue((Object)dataRow.getString("trdnumber"));
                        DimMember trdmem = this.packMem(dataRow.getString("trdname"), dataRow.getString("trdnumber"), "", "");
                        trdmem.setId(dataRow.getLong("trdid").longValue());
                        trdCellTemp.addDim2UserObject((IDimMember)trdmem);
                        trdNameCell.setValue((Object)dataRow.getString("trdname"));
                        this.setCellChange(trdCellTemp);
                        this.setCellChange(trdNameCell);
                        invoker.updataValue(rowIndex, trdColumnIndex, trdCellTemp.getValue());
                        invoker.updataValue(rowIndex, trdColumnIndex + 1, trdNameCell.getValue());
                    }
                });
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
            }
            invoker.startToInvoke();
        }
        this.plugin.cacheSpreadModel(spreadManager);
    }

    private int getRealMaxRowCount(Sheet sheet, MemAndComVO memAndComVO) {
        int maxRowCount = sheet.getMaxRowCount();
        int sourceIndex = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)memAndComVO.getSourcePro().get(0)), null);
        int targetIndex = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)memAndComVO.getTargetPro().get(0)), null);
        int i = maxRowCount;
        while (i > 0 && sheet.getCell(i, sourceIndex).getValue() == null && sheet.getCell(i, targetIndex).getValue() == null) {
            maxRowCount = i--;
        }
        if (maxRowCount < 2) {
            maxRowCount = 2;
        }
        return maxRowCount;
    }

    @Override
    public void autoMatchNumber(MemAndComVO memAndComVO, MappingContext mappingContext) {
        this.autoMatch(memAndComVO, mappingContext, false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6309\u6210\u5458\u7f16\u7801\u81ea\u52a8\u5339\u914d\u6210\u529f\u3002", (String)"SingleMemMapSheetHandel_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected void rebuildData(int row, DynamicObject rowData, SpreadEasyInvoker invoker) {
        int col = this.getTargetColByEntity(((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getEntityName(), ((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getNumber());
        String value = rowData.getString("targmembnumber");
        this.setValueUnChange(row, col, value);
        invoker.updataValue(row, col, value);
        value = rowData.getString("targmembname");
        this.setValueUnChange(row, ++col, value);
        invoker.updataValue(row, col, value);
        col = this.getSrcColByEntity(((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getEntityName(), ((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getNumber());
        value = rowData.getString("srcmembnumber");
        this.setValueUnChange(row, col, value);
        invoker.updataValue(row, col, value);
        if (!this.supportFuzzyMatch()) {
            value = rowData.getString("srcmembname");
            this.setValueUnChange(row, ++col, value);
            invoker.updataValue(row, col, value);
        }
    }

    @Override
    protected String getSelectFiled() {
        return "id,targmembnumber,targmembname,srcmembnumber,srcmembname";
    }

    @Override
    protected void checkBeforeSave() {
        super.checkBeforeSave();
        if (this.isFromJQ()) {
            this.jQcheckBeforeSave();
            return;
        }
        if (this.isMultiCurrency()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u96c6\u6210\u65b9\u6848\u4e3a\u539f\u5e01\u6570\u636e\u96c6\u6210\u65b9\u6848\uff0c\u5df2\u5305\u542b\u5e01\u79cd\u5bf9\u5e94\u903b\u8f91(\u539f\u5e01\u6570\u636e\u6620\u5c04\u5230OC\uff0c\u672c\u4f4d\u5e01\u6570\u636e\u6620\u5c04\u5230EC)\uff0c\u65e0\u9700\u7ef4\u62a4\u3002", (String)"SingleMemMapSheetHandel_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean uncheck = false;
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add(DimEntityNumEnum.ENTITY.getEntityNum());
        ignore.add(DimEntityNumEnum.YEAR.getEntityNum());
        ignore.add(DimEntityNumEnum.PERIOD.getEntityNum());
        ignore.add(DimEntityNumEnum.CURRENCY.getEntityNum());
        for (MemAndComVO.Node no : this.vo.getTargetPro()) {
            if (!ignore.contains(no.getEntityName())) continue;
            uncheck = true;
            break;
        }
        int sorCol = this.getSrcColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getSourcePro().get(0)), null);
        int tarCol = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)), null);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>(16);
        StringBuilder sb = new StringBuilder();
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            String oldvalue2;
            Object sor = this.getSheet().getCell(row, sorCol).getValue();
            Object tar = this.getSheet().getCell(row, tarCol).getValue();
            if (sor == null || tar == null) continue;
            String sorValue = sor.toString();
            String tarValue = tar.toString();
            if (!StringUtils.isNotEmpty((String)sorValue) || !StringUtils.isNotEmpty((String)tarValue)) continue;
            String oldvalue = map.putIfAbsent(sorValue, tarValue);
            if (oldvalue != null && !uncheck) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u6709\u91cd\u590d\u7684\u6e90\u6210\u5458\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u540e\u4fee\u6539\u3002", (String)"SingleMemMapSheetHandel_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
            }
            if (!"IGNORE".equals(tarValue) && (oldvalue2 = map2.putIfAbsent(tarValue, sorValue)) != null && uncheck) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u6709\u91cd\u590d\u7684\u76ee\u6807\u6210\u5458\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u540e\u4fee\u6539\u3002", (String)"SingleMemMapSheetHandel_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
            }
            String key = sb.append(tarValue).append("-").append(sorValue).toString();
            sb.delete(0, sb.length());
            if (set.contains(key)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u6709\u91cd\u590d\u7684\u76ee\u6807\u6210\u5458\u548c\u6e90\u6210\u5458\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u540e\u4fee\u6539\u3002", (String)"SingleMemMapSheetHandel_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
            }
            set.add(key);
            if (!this.supportFuzzyMatch() || !uncheck || !("*".equals(sorValue) ^ "*".equals(tarValue))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5355\u4e00\u6620\u5c04\u4ec5\u652f\u6301\u6765\u6e90\u548c\u76ee\u6807\u5747\u4e3a\u5177\u4f53\u6210\u5458\u7f16\u7801\u7684\u6620\u5c04\u6216\u8005\u5747\u4e3a*\u7684\u6620\u5c04\uff0c\u5982\uff1a100101<->1001\u3001*<->*\uff0c\u8bf7\u786e\u8ba4\u540e\u4fee\u6539\u3002", (String)"SingleMemMapSheetHandel_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1));
        }
    }

    private boolean isMultiCurrency() {
        String src = ((MemAndComVO.Node)this.vo.getSourcePro().get(0)).getNumber();
        String target = ((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getNumber();
        return this.isFromNGACC() && "Currency".equals(src) && "Currency".equals(target) && this.plugin.getScheme().getBoolean("multicurrency");
    }

    private void jQcheckBeforeSave() {
        for (int row = 2; row < this.getSheet().getMaxRowCount(); ++row) {
            int countTime = 0;
            boolean needNotice = false;
            for (int col = 0; col < 6; ++col) {
                String value = this.getSheet().getCell(row, col).valueToString();
                if (value != null && !StringUtils.isEmpty((String)value)) continue;
                ++countTime;
                if (col == 1) continue;
                needNotice = true;
            }
            if (countTime == 6 || !needNotice) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u6709\u7a7a\u503c\uff0c\u8bf7\u786e\u8ba4\u540e\u4fee\u6539\u3002", (String)"SingleMemMapSheetHandel_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ++row));
        }
        this.checkRepeatData();
    }

    @Override
    public void beforeUpdateMulValue(NotifyEvent mulevt) {
        super.beforeUpdateMulValue(mulevt);
        if (this.supportFuzzyMatch()) {
            SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
            List value = data.getValues();
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
            invoker.setBatch(true);
            for (LinkedHashMap map : value) {
                String valueString;
                int col = (Integer)map.get("c");
                Cell cell = this.getSheet().getCell(((Integer)map.get("r")).intValue(), col);
                String sign = this.getSignByCol(cell.getCol());
                String string = valueString = map.get("v") == null ? "" : map.get("v").toString().trim();
                if (!StringUtils.isNotEmpty((String)sign)) continue;
                if (!this.isTargetCol(col)) {
                    cell.setValue((Object)valueString);
                    this.setCellChange(cell);
                    continue;
                }
                int tarCol = this.getTargetColByEntity(this.buildEntityNameByNode((MemAndComVO.Node)this.vo.getTargetPro().get(0)), null);
                Cell tar = this.getSheet().getCell(((Integer)map.get("r")).intValue(), tarCol);
                if ("*".equals(valueString) || "IGNORE".equalsIgnoreCase(valueString.trim())) {
                    cell.setValue((Object)valueString.toUpperCase(Locale.ENGLISH).trim());
                    this.setCellChange(cell);
                    invoker.updataValue((Integer)map.get("r"), (Integer)map.get("c") + 1, valueString.toUpperCase(Locale.ENGLISH).trim());
                    invoker.updataValue((Integer)map.get("r"), (Integer)map.get("c"), valueString.toUpperCase(Locale.ENGLISH).trim());
                    tar.setUserObject("targetInfo", null);
                    continue;
                }
                String dimNumber = this.getDimNumberByKey(sign);
                String memberNum = valueString.split("\\|")[0].trim();
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.plugin.getModelNumber(), (String)dimNumber, (String)memberNum);
                if (!IDNumberTreeNode.NotFoundTreeNode.equals(node)) {
                    cell.setValue((Object)memberNum);
                    this.setCellChange(cell);
                    invoker.updataValue((Integer)map.get("r"), (Integer)map.get("c"), memberNum);
                    invoker.updataValue((Integer)map.get("r"), (Integer)map.get("c") + 1, node.getName());
                    HashMap<String, Object> targetInfo = new HashMap<String, Object>(3);
                    targetInfo.put("id", node.getId());
                    targetInfo.put("number", node.getNumber());
                    targetInfo.put("name", node.getName());
                    tar.setUserObject("targetInfo", targetInfo);
                    continue;
                }
                cell.setValue((Object)"");
                this.setCellChange(cell);
                invoker.updataValue(cell.getRow(), cell.getCol(), null);
                invoker.updataValue(cell.getRow(), cell.getCol() + 1, null);
                tar.setUserObject("targetInfo", null);
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u76ee\u6807\u7cfb\u7edf\u6210\u5458\u5728\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\uff0c\u5df2\u6e05\u9664\u3002", (String)"SingleMemMapSheetHandel_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            invoker.startToInvoke();
        } else if (this.isFromJQ()) {
            SpreadPostDataInfo data = (SpreadPostDataInfo)mulevt.getParam();
            List value = data.getValues();
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.spKey);
            invoker.setBatch(true);
            for (LinkedHashMap map : value) {
                int col = (Integer)map.get("c");
                if (col <= 2 + this.hasseq || col >= 8 + this.hasseq) continue;
                Cell cell = this.getSheet().getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue());
                String valueString = map.get("v") == null ? "" : map.get("v").toString().trim();
                valueString = this.getJQComboValue(col, valueString);
                cell.setValue((Object)valueString);
                if (StringUtils.isEmpty((String)valueString)) {
                    invoker.updataValue(cell.getRow(), col, null);
                }
                this.setCellChange(cell);
            }
            invoker.startToInvoke();
        }
    }

    private String getJQComboValue(int col, String value) {
        if (col == 4) {
            Integer code = JqReportTypeEnum.getCodeByName((String)value);
            return code == null ? null : String.valueOf(code);
        }
        if (col == 5) {
            String cacheInfo = this.plugin.getPageCache().get("reportDataMap");
            Map reportDataMap = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheInfo);
            return (String)reportDataMap.get(value);
        }
        return value;
    }

    @Override
    protected void rebuildJQData(int row, DynamicObject rowData, SpreadEasyInvoker invoker) {
        int col = this.getTargetColByEntity(((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getEntityName(), ((MemAndComVO.Node)this.vo.getTargetPro().get(0)).getNumber());
        String value = rowData.getString("targmembnumber");
        this.setValueUnChange(row, col, value);
        invoker.updataValue(row, col, value);
        value = rowData.getString("targmembname");
        this.setValueUnChange(row, ++col, value);
        invoker.updataValue(row, col, value);
        value = rowData.getString("srcmembnumber");
        this.setValueUnChange(row, ++col, value);
        invoker.updataValue(row, col, value);
        value = rowData.getString("srcmembname");
        this.setValueUnChange(row, ++col, value);
        invoker.updataValue(row, col, value);
        value = rowData.getString("srcreporttype");
        String nameByCode = this.getNameByCode(Integer.valueOf(value));
        this.setValueUnChange(row, ++col, nameByCode);
        invoker.updataValue(row, col, nameByCode);
        value = rowData.getString("reportdatatype");
        nameByCode = this.getReportDataTypeNameByNumber(value);
        this.setValueUnChange(row, ++col, nameByCode);
        invoker.updataValue(row, col, nameByCode);
    }

    private String getNameByCode(Integer code) {
        for (JqReportTypeEnum type : JqReportTypeEnum.values()) {
            if (!type.getCode().equals(code)) continue;
            return type.getName();
        }
        return null;
    }

    private Integer getJqReportTypeCodeByValue(String value) {
        for (JqReportTypeEnum type : JqReportTypeEnum.values()) {
            if (!type.getName().equals(value)) continue;
            return type.getCode();
        }
        return null;
    }

    private String getReportDataTypeNameByNumber(String number) {
        if (this.reportDataTypeMap == null) {
            String cacheInfo = this.plugin.getPageCache().get("reportDataTypeNumberMap");
            this.reportDataTypeMap = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheInfo);
        }
        return this.reportDataTypeMap.get(number);
    }

    @Override
    protected String getSelectJqFiled() {
        return "id,targmembnumber,targmembname,srcmembnumber,srcmembname,srcreporttype,reportdatatype";
    }

    @Override
    protected String getRowInfo(List<Cell> cells) {
        StringBuilder sb = new StringBuilder();
        if (this.isFromJQ()) {
            for (int i = 0; i < 6; ++i) {
                Cell cell = cells.get(i);
                this.addMsgToStringBuilder(cell, sb);
            }
        }
        return sb.toString();
    }
}

