/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.pusheasrpt;

import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.pusheasrpt.PushRpt2EasService;
import kd.fi.bcm.formplugin.intergration.pusheasrpt.ctx.PushRpt2EasContext;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;

public class PushRpt2EasMsServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(PushRpt2EasMsServiceHelper.class);

    public List<Map<String, Object>> query(Map<String, Object> param) {
        log.startWatch();
        try {
            PushRpt2EasContext ctx = new PushRpt2EasContext(param);
            List<Map<String, Object>> table = null;
            boolean hasExtend = this.checkHasExtend(ctx);
            table = hasExtend ? new PushRpt2EasService().executeExtend(ctx) : new PushRpt2EasService().execute(ctx, param);
            if (DebugServiceHelper.isDebugModel()) {
                log.info("--PushRpt2EasMsServiceHelper--" + table);
            }
            return table;
        }
        catch (Throwable e) {
            log.error("--PushRpt2EasMsServiceHelper--error\n", e);
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
        }
    }

    private boolean checkHasExtend(PushRpt2EasContext ctx) {
        List<TemplateModel> templateModels = ctx.getTemplateModels();
        TemplateModel tmplModel = templateModels.get(0);
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tmplModel.getRptData());
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            if (e.getExtendInfo() == null) continue;
            return true;
        }
        return false;
    }
}

