/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.pusheasrpt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.integration.util.DataTypeCacheInfo;
import kd.fi.bcm.business.integration.util.DataTypeUtil;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.ISqlLazyFilter;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.integration.PeriodTypeEnum;
import kd.fi.bcm.common.enums.integration.RptSrcTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.pusheasrpt.ctx.PushRpt2EasContext;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;

public class PushRpt2EasService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(PushRpt2EasService.class);
    private static final String CELLPOSITION = "cp";
    private static final String FLOATDIMENSION = "floatDimension";
    private static final String DATAFILTER = "dataFilter";
    private static final String CELLFILTER = "cellFilter";
    private static final String DIMFILTER = "dimFilter";
    private BloomFilter<String> dynaRowExistsFilter;
    private static HashMap<String, DataTypeCacheInfo> dataTypeMap = new HashMap(16);
    private SingleMapModel singleMapModel;
    private boolean isNotUserNameOrder = false;
    private StringBuilder paramStr = new StringBuilder();
    private Table<String, String, SquenceCounter> sequenceTable = HashBasedTable.create();
    private Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public PushRpt2EasService() {
        this.isNotUserNameOrder = ConfigServiceHelper.getGlobalBoolParam((String)"pushEasIsNotUseNameOrder");
    }

    public List<Map<String, Object>> execute(PushRpt2EasContext ctx, Map<String, Object> param) {
        Long startTime = System.currentTimeMillis();
        Map<String, Object> filter = this.getDataFilterAndCellFilter(ctx);
        try {
            Pair<String, String> filter4Log = this.buildLogFilter(filter);
            log.info("PushRpt2EasService-cellFilter:" + (String)filter4Log.p1);
            log.info("PushRpt2EasService-dataFilter:" + (String)filter4Log.p2);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        try {
            this.paramStr.append(param.get("companyNumbers")).append(":").append(param.get("tempNumber"));
            this.paramStr.append(";;;param is:").append(JSONObject.toJSONString(param));
            this.paramStr.append(";;;DATAFILTER is:").append(JSONObject.toJSONString((Object)filter.get(DATAFILTER)));
        }
        catch (Throwable e) {
            log.error("paramStr is error:", e);
        }
        MDResultSet olapData = this.queryOlap((String)ctx.getModel().p2, (Map)filter.get(DATAFILTER), ctx.getDimensions());
        try {
            this.paramStr.append(";;;olapData is:").append(JSONObject.toJSONString(this.getOlapDataList(olapData, ctx.getDimensions())));
        }
        catch (Throwable e) {
            log.error("paramStr is error:", e);
        }
        log.info("PushRpt2EasService-olapData-Row:" + olapData.getFetchSize());
        this.singleMapModel = new SingleMapModel(ctx.getInteCtx());
        List<Map<String, Object>> maps = this.buildTableData(ctx, olapData, (Map)filter.get(CELLFILTER));
        try {
            this.paramStr.append(";;;maps is:").append(JSONObject.toJSONString(maps));
            this.paramStr.append(";;;cost is:").append(System.currentTimeMillis() - startTime);
            ErrorLogServiceHelper.saveErrorLog((Long)((Long)ctx.getModel().p1), (String)"PushRpt2Eas", (String)this.paramStr.toString());
        }
        catch (Throwable e) {
            log.error("paramStr is error:", e);
        }
        return maps;
    }

    private List<Map<String, Object>> getOlapDataList(MDResultSet olapData, List<String> dimensions) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Object> map = null;
        String valueColName = FacTabFieldDefEnum.FIELD_MONEY.getField();
        olapData.beforeFirst();
        while (olapData.next()) {
            kd.fi.bcm.business.sql.Row row = olapData.getRow();
            map = new HashMap<String, Object>(16);
            for (String dim : dimensions) {
                map.put(dim, row.getString(dim));
            }
            map.put(valueColName, row.getOriginalValue(valueColName));
            res.add(map);
        }
        return res;
    }

    private Pair<String, String> buildLogFilter(Map<String, Object> filter) {
        HashMap cellFilter = new HashMap(16);
        if (!ObjectUtils.isEmpty((Object)filter.get(CELLFILTER))) {
            ((Map)filter.get(CELLFILTER)).forEach((k, v) -> {
                HashMap oneCell = new HashMap(16);
                v.forEach((k1, v1) -> {
                    int max = 0;
                    HashSet<String> oneDim = new HashSet<String>(10);
                    if (v1 instanceof Set) {
                        for (String member : (Set)v1) {
                            if (max < 10) {
                                oneDim.add(member);
                                ++max;
                                continue;
                            }
                            break;
                        }
                    } else if (v1 instanceof List) {
                        block1: for (Set memberSet : (List)v1) {
                            for (String member : memberSet) {
                                if (max >= 100) continue block1;
                                oneDim.add(member);
                                ++max;
                            }
                        }
                    }
                    oneCell.put(k1, oneDim);
                });
                cellFilter.put(k, oneCell);
            });
        }
        HashMap dataFilter = new HashMap(16);
        if (!ObjectUtils.isEmpty((Object)filter.get(DATAFILTER))) {
            ((Map)filter.get(DATAFILTER)).forEach((k, v) -> {
                int max = 0;
                HashSet<String> oneDim = new HashSet<String>(10);
                for (String member : v) {
                    if (max >= 100) break;
                    oneDim.add(member);
                    ++max;
                }
                if (oneDim.size() < 100) {
                    dataFilter.put(k, oneDim);
                }
            });
        }
        return Pair.onePair((Object)ObjectSerialUtil.toJson(cellFilter), (Object)ObjectSerialUtil.toJson(dataFilter));
    }

    private List<Map<String, Object>> buildTableData(PushRpt2EasContext ctx, MDResultSet data, Map<String, Map<String, Object>> cellsFilter) {
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(10);
        String valueColName = FacTabFieldDefEnum.FIELD_MONEY.getField();
        ctx.getCellParams().forEach((k, v) -> {
            Map cellFilter = (Map)cellsFilter.get(k);
            if (ObjectUtils.isEmpty((Object)cellFilter)) {
                return;
            }
            data.beforeFirst();
            while (data.next()) {
                kd.fi.bcm.business.sql.Row row = data.getRow();
                Object value = row.getOriginalValue(valueColName);
                if (Objects.isNull(value) || !this.match(cellFilter, row, ctx.getDimensions())) continue;
                BigDecimal amount = null;
                String txt = null;
                if (value instanceof Number) {
                    amount = row.getBigDecimal(valueColName);
                } else {
                    Map<String, String> dim2Members = this.getDim2MembersMap(data.getRow(), ctx.getDimensions());
                    DataTypeEnum dataType = DataTypeUtil.getDataTypeThreadCache((long)((Long)ctx.getModel().p1), dim2Members, dataTypeMap);
                    if (DataTypeEnum.DATETP == dataType) {
                        try {
                            Date date = DateTimeUtils.parseStrDate((String)data.getRow().getString(valueColName));
                            txt = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                        }
                        catch (Exception e) {
                            txt = data.getRow().getString(valueColName);
                            log.error("--PushRpt2EasService.buildTableData: convert date:", (Throwable)e);
                        }
                    } else {
                        txt = data.getRow().getString(valueColName);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)((Set)cellFilter.get(FLOATDIMENSION)))) {
                    this.packFixedRptRowInfo((List<Map<String, Object>>)table, row, ctx, amount, txt, (Map<String, String>)v);
                    continue;
                }
                Set<String> floatDims = ((Set)cellFilter.get(FLOATDIMENSION)).stream().map(dim -> dim.split("!")[0]).collect(Collectors.toSet());
                Map<Integer, String> index2FloatDim = ((Set)cellFilter.get(FLOATDIMENSION)).stream().filter(dim -> Integer.parseInt(dim.split("!")[1]) >= 0).collect(Collectors.toMap(dim -> Integer.valueOf(dim.split("!")[1]), dim -> dim.split("!")[0]));
                ArrayList<Pair<String, String>> dynItem = new ArrayList<Pair<String, String>>(3);
                floatDims.forEach(d -> dynItem.add(Pair.onePair((Object)d, (Object)row.getString(d))));
                this.packDynRptRowInfo((List<Map<String, Object>>)table, row, ctx, amount, txt, (Map<String, String>)v, (List<Pair<String, String>>)dynItem, index2FloatDim);
            }
        });
        return table;
    }

    private Map<String, String> getDim2MembersMap(kd.fi.bcm.business.sql.Row row, List<String> allDim) {
        HashMap<String, String> dim2Members = new HashMap<String, String>(allDim.size());
        allDim.forEach(dim -> dim2Members.put((String)dim, row.getString(dim)));
        return dim2Members;
    }

    private void packDynRptRowInfo(List<Map<String, Object>> table, kd.fi.bcm.business.sql.Row r, PushRpt2EasContext ctx, BigDecimal amount, String txt, Map<String, String> cellParam, List<Pair<String, String>> dynItem, Map<Integer, String> index2FloatDim) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, r, ctx, cellParam);
        row.put("fdatatype", amount == null ? 3 : 1);
        row.put("ftext", txt);
        row.put("famount", amount);
        String floatItemDim = this.getFloatItemDim(ctx.getSeqDimNum(), dynItem);
        boolean needMyCompany = ctx.isInterExch() && ctx.isContainMyCompany();
        boolean hasNotMembMapped2Eas = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(floatItemDim)).getSourceDimItem() == null;
        String appendSequence = this.getSeq(r, dynItem, floatItemDim, needMyCompany, ctx, hasNotMembMapped2Eas, cellParam);
        if (!hasNotMembMapped2Eas) {
            this.singleMapModel.buildTar(ctx.getDimsMap().get(floatItemDim).longValue());
        }
        String membNum = r.getString(floatItemDim);
        String targMembNam = this.getDynamicName(ctx, floatItemDim, membNum, hasNotMembMapped2Eas, null) + appendSequence;
        row.put("fdynaitemkey", StringUtils.isNotEmpty((String)appendSequence) ? targMembNam : membNum);
        row.put("fdynaitemname", targMembNam);
        table.add(row);
        Map<String, Map<String, String>> mem2ValueFloatDims = this.getMem2ValueFloatDims(ctx, cellParam, index2FloatDim);
        mem2ValueFloatDims.forEach((k, v) -> {
            HashMap<String, Object> rowFloatItem = new HashMap<String, Object>();
            this.packRowCommonInfo((Map<String, Object>)rowFloatItem, r, ctx, (Map<String, String>)v);
            rowFloatItem.put("fdynaitemkey", StringUtils.isNotEmpty((String)appendSequence) ? targMembNam : membNum);
            rowFloatItem.put("fdynaitemname", targMembNam);
            rowFloatItem.put("fdatatype", 3);
            String floatMembNum = r.getString(k);
            String floatMembName = this.getDynamicName(ctx, (String)k, floatMembNum, hasNotMembMapped2Eas, null);
            rowFloatItem.put("ftext", this.getFloatItemRowFtext(String.valueOf(v.get("isNum")), floatMembNum, floatMembName));
            rowFloatItem.put("famount", null);
            if (!this.checkDynaRecordExists(rowFloatItem)) {
                table.add(rowFloatItem);
            }
        });
    }

    private Map<String, Map<String, String>> getMem2ValueFloatDims(PushRpt2EasContext ctx, Map<String, String> cellParam, Map<Integer, String> index2FloatDim) {
        String cp = cellParam.get(CELLPOSITION);
        Point point = ExcelUtils.pos2Point((String)cp);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(3);
        index2FloatDim.forEach((k, v) -> {
            String pos = ExcelUtils.xy2Pos((int)k, (int)point.y);
            Map<String, String> floatCellMap = ctx.getCellParams().get(pos);
            if (floatCellMap != null) {
                result.put((String)v, floatCellMap);
            }
        });
        return result;
    }

    private String getFloatItemRowFtext(String isNum, String floatMembNum, String floatMembName) {
        if ("2".equals(isNum)) {
            return floatMembName;
        }
        return floatMembNum;
    }

    private String getFloatItemDim(String seqDimNum, List<Pair<String, String>> dynItem) {
        String floatItemDim = "";
        for (Pair<String, String> item : dynItem) {
            if (!((String)item.p1).equals(seqDimNum)) {
                floatItemDim = (String)item.p1;
            }
            if (!((String)item.p1).equals(PresetConstant.INTERNALCOMPANY_DIM)) continue;
            break;
        }
        return floatItemDim;
    }

    private boolean match(Map<String, Object> cellFilter, kd.fi.bcm.business.sql.Row row, List<String> dimensions) {
        for (String dim : dimensions) {
            Object dimFilter = cellFilter.get(dim);
            if (dimFilter == null) continue;
            if (dimFilter instanceof Set) {
                if (((Set)dimFilter).contains(row.getString(dim))) continue;
                return false;
            }
            if (!(dimFilter instanceof List)) continue;
            boolean isMatch = false;
            for (Set set : (List)dimFilter) {
                if (!set.contains(row.getString(dim))) continue;
                isMatch = true;
            }
            if (isMatch) continue;
            return false;
        }
        return true;
    }

    private String getSeq(kd.fi.bcm.business.sql.Row r, List<Pair<String, String>> dynItem, String floatItemDim, boolean needMyCompany, PushRpt2EasContext ctx, boolean hasNotMembMapped2Eas, Map<String, String> cellParam) {
        String colKey;
        SquenceCounter counter;
        StringBuilder rowKeyBuilder = new StringBuilder();
        String membNum = r.getString(floatItemDim);
        String membName = "";
        String isNum = cellParam.get("isNum");
        String isNumStr = isNum == null ? "1" : isNum.toString();
        membName = !StringUtils.isEmpty((String)membNum) && !this.isNotUserNameOrder && "2".equals(isNumStr) && dynItem.size() == 1 ? this.getDynamicName(ctx, floatItemDim, membNum, hasNotMembMapped2Eas, null) : membNum;
        rowKeyBuilder.append(floatItemDim).append(membName);
        if (needMyCompany) {
            rowKeyBuilder.append(PresetConstant.MYCOMPANY_DIM).append(r.getString(PresetConstant.MYCOMPANY_DIM));
        }
        String rowKey = rowKeyBuilder.toString();
        StringBuilder colKeyBuilder = new StringBuilder();
        List<Pair> sortedItems = dynItem.stream().sorted(Comparator.comparing(d -> (String)d.p1)).collect(Collectors.toList());
        sortedItems.forEach(item -> {
            if (((String)item.p1).equals(floatItemDim)) {
                return;
            }
            if (needMyCompany && ((String)item.p1).equals(PresetConstant.MYCOMPANY_DIM)) {
                return;
            }
            colKeyBuilder.append((String)item.p1).append((String)item.p2);
        });
        if (dynItem.size() == 1 && ((String)dynItem.get((int)0).p1).equals(floatItemDim) && !this.isNotUserNameOrder && "2".equals(isNumStr)) {
            colKeyBuilder.append((String)dynItem.get((int)0).p1).append((String)dynItem.get((int)0).p2);
        }
        if ((counter = (SquenceCounter)this.sequenceTable.get((Object)rowKey, (Object)(colKey = colKeyBuilder.toString()))) == null) {
            counter = new SquenceCounter();
            if (this.sequenceTable.row((Object)rowKey).size() > 0) {
                counter.setSequence(this.sequenceTable.row((Object)rowKey).size());
            }
            this.sequenceTable.put((Object)rowKey, (Object)colKey, (Object)counter);
        }
        return counter.sequence == 0 ? "" : String.format("@%d", counter.sequence);
    }

    private void packFixedRptRowInfo(List<Map<String, Object>> table, kd.fi.bcm.business.sql.Row r, PushRpt2EasContext ctx, BigDecimal amount, String txt, Map<String, String> cellParam) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, r, ctx, cellParam);
        row.put("fdynaitemkey", null);
        row.put("ftext", txt);
        row.put("fdatatype", amount == null ? 3 : 1);
        row.put("famount", amount);
        row.put("fdynaItemname", null);
        table.add(row);
    }

    private void packRowCommonInfo(Map<String, Object> row, kd.fi.bcm.business.sql.Row r, PushRpt2EasContext ctx, Map<String, String> cellParam) {
        boolean needMyCompany;
        row.put("headpk", GlobalIdUtil.genStringId());
        row.put("fcompany", ctx.getEntityMapping().get(r.getString(PresetConstant.ENTITY_DIM)));
        row.put("fcurrency", ctx.getTarCurrencyNumbers().get(0));
        row.put("frptitem", cellParam.get("ri"));
        row.put("fdataelement", cellParam.get("de"));
        row.put("fyear", ctx.getTarYear());
        row.put("fperiod", ctx.getTarPeriod());
        row.put("fperiodtype", PeriodTypeEnum.getEnum((String)ctx.getTarPeriodType()).getValue());
        row.put("frptsrctype", RptSrcTypeEnum.getEnum((String)ctx.getTarRptType()).getValue());
        row.put("fisInterexch", ctx.isInterExch() ? 1 : 0);
        boolean bl = needMyCompany = ctx.isInterExch() && ctx.isContainMyCompany();
        if (needMyCompany) {
            boolean hasNotMembMapped2Eas = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(PresetConstant.MYCOMPANY_DIM)).getSourceDimItem() == null;
            String myNum = r.getString(PresetConstant.MYCOMPANY_DIM);
            row.put("fownnumber", myNum);
            row.put("fownname", this.getDynamicName(ctx, PresetConstant.MYCOMPANY_DIM, myNum, hasNotMembMapped2Eas, null));
        }
    }

    private String getDynamicName(PushRpt2EasContext ctx, String srcDimNum, String srcMembNumb, boolean isGetSrc, String dimMembNum) {
        if (isGetSrc) {
            return MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)srcDimNum, (String)srcMembNumb).getName();
        }
        try {
            return (String)this.cache.get((Object)(srcDimNum + "|" + srcMembNumb), () -> {
                DynamicObject dyna;
                MappedDimItem dimItem = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(srcDimNum)).getSourceDimItem().getDimItem();
                Pair pair = this.singleMapModel.getSrc(srcDimNum, srcMembNumb);
                String entityNumb = dimItem.getEntityNumb();
                if (StringUtils.isNotEmpty((String)entityNumb) && pair != null && (dyna = BusinessDataServiceHelper.loadSingle((String)entityNumb, (String)"name", (QFilter[])new QFBuilder().add("number", "=", pair.p2).toArray())) != null) {
                    return dyna.getString("name");
                }
                return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6e90\u6210\u5458\u201c%2$s\u201d\u5bf9\u5e94\u540d\u79f0\u672a\u627e\u5230\u3002", (String)"SupplierCollector_0", (String)"fi-bcm-business", (Object[])new Object[0]), srcDimNum, srcMembNumb);
            });
        }
        catch (ExecutionException e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private Map<String, Object> getDataFilterAndCellFilter(PushRpt2EasContext ctx) {
        HashMap<String, Object> filter = new HashMap<String, Object>(3);
        List<TemplateModel> templateModels = ctx.getTemplateModels();
        TemplateModel tmplModel = templateModels.get(0);
        if (!tmplModel.isSaveByDim()) {
            return filter;
        }
        HashMap<String, HashMap<String, Object>> cellsFilter = new HashMap<String, HashMap<String, Object>>(16);
        HashMap<String, Set<String>> dataFilter = new HashMap<String, Set<String>>(16);
        Map<String, Object> dimFilter = this.getFilterView(ctx);
        for (Map<String, String> m : ctx.getTarIndexParams()) {
            Map<String, Object> rowAndColMap = this.getRowAndColDim(tmplModel, m.get(CELLPOSITION));
            HashMap<String, Object> allFilter = new HashMap<String, Object>(16);
            if (rowAndColMap.size() <= 0) continue;
            rowAndColMap.forEach((k, v) -> {
                if (FLOATDIMENSION.equals(k)) {
                    ((Map)v).forEach((k1, v1) -> allFilter.put(k1.split("!")[0], v1));
                    allFilter.put(FLOATDIMENSION, ((Map)v).keySet());
                } else {
                    HashSet<String> set = new HashSet<String>(2);
                    set.add((String)v);
                    allFilter.put((String)k, set);
                }
            });
            dimFilter.forEach((k, v) -> {
                Set<String> set = new HashSet<String>(2);
                if (DimEntityNumEnum.ENTITY.getNumber().equals(k)) {
                    set = (Set)v;
                } else {
                    set.add((String)v);
                }
                allFilter.put((String)k, set);
            });
            cellsFilter.put(m.get(CELLPOSITION), allFilter);
            this.setDataFilter(allFilter, dataFilter, ctx.getDimensions());
        }
        if (cellsFilter.size() <= 0 || dataFilter.size() <= 0) {
            log.info("PushRpt2EasService.getDataFilterAndCellFilter.cellsFilter is empty.");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u533a\u57df\u6570\u636e\u9700\u8981\u8fd4\u56de\uff0c\u8bf7\u68c0\u67e5\u5355\u5143\u683c\u6620\u5c04\u3002", (String)"PushRpt2EasServiceHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.put(CELLFILTER, cellsFilter);
        filter.put(DATAFILTER, dataFilter);
        return filter;
    }

    private void setDataFilter(Map<String, Object> allFilter, Map<String, Set<String>> dataFilter, List<String> dims) {
        if (dataFilter.size() == 0) {
            dims.forEach(k -> {
                Set cfr_ignored_0 = dataFilter.put((String)k, new HashSet());
            });
        }
        HashSet needDeleteDim = new HashSet();
        dataFilter.forEach((k, v) -> {
            Object str = allFilter.get(k);
            if (str != null) {
                if (str instanceof Set) {
                    if (!CollectionUtils.isEmpty((Collection)((Set)str))) {
                        ((Set)dataFilter.get(k)).addAll((Set)str);
                    } else {
                        needDeleteDim.add(k);
                    }
                } else if (str instanceof List) {
                    needDeleteDim.add(k);
                }
            } else {
                needDeleteDim.add(k);
            }
        });
        needDeleteDim.forEach(dataFilter::remove);
    }

    private Map<String, Object> getFilterView(PushRpt2EasContext ctx) {
        HashMap<String, Object> dimFilter = new HashMap<String, Object>(16);
        dimFilter.put(DimEntityNumEnum.ENTITY.getNumber(), ctx.getEntityMapping().keySet());
        dimFilter.put(DimEntityNumEnum.SCENARIO.getNumber(), ctx.getScene().p2);
        dimFilter.put(DimEntityNumEnum.YEAR.getNumber(), ctx.getYear().p2);
        dimFilter.put(DimEntityNumEnum.PERIOD.getNumber(), ctx.getPeriod().p2);
        dimFilter.put(DimEntityNumEnum.CURRENCY.getNumber(), ctx.getCurrency().p2);
        TemplateModel tm = ctx.getTemplateModels().get(0);
        for (ViewPointDimensionEntry v : tm.getViewPointDimensionEntries()) {
            dimFilter.put(v.getDimension().getNumber(), v.getMember().getNumber());
        }
        for (ViewPointDimensionEntry v : tm.getPageDimensionEntries()) {
            String dim = v.getDimension().getNumber();
            if (PresetConstant.ENTITY_DIM.equals(dim) || PresetConstant.FY_DIM.equals(dim) || PresetConstant.SCENE_DIM.equals(dim) || PresetConstant.PERIOD_DIM.equals(dim) || PresetConstant.CURRENCY_DIM.equals(dim)) continue;
            String member = this.getTargetMember(ctx, v.getDimension().getId());
            if (member == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79%1$s\u6a21\u677f\u7684\u9875\u9762\u7ef4\u5305\u542b%2$s\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u6620\u5c04\u672a\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u76ee\u6807\u7f3a\u7701\u503c\u3002", (String)"PushRpt2EasServiceHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tm.getNumber(), dim, dim));
            }
            dimFilter.put(dim, member);
        }
        return dimFilter;
    }

    private String getTargetMember(PushRpt2EasContext ctx, Long dimId) {
        IIntegrateContext inteCtx = ctx.getInteCtx();
        String member = null;
        DimMappedRelation.DimAndDefValRela dimDefVals = (DimMappedRelation.DimAndDefValRela)inteCtx.getTargetDefaultValsMap().get(dimId);
        if (dimDefVals != null && !ObjectUtils.isEmpty((Object)dimDefVals.getDefVals())) {
            member = ((MappedDefaultVal)dimDefVals.getDefVals().get(0)).getNumber();
        } else {
            MappedDimItem dimItem = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)dimId).getSourceDimItem().getDimItem();
            if (ctx.getDim2ParamMap().get(dimItem.getNumber()) != null) {
                QFBuilder qfb = new QFBuilder();
                qfb.add("schemeid", "=", ctx.getScheme().p1);
                qfb.add("dimmapid", "=", (Object)ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)dimId).getDimMappedId());
                qfb.add("srcmembnumber", "=", (Object)ctx.getDim2ParamMap().get(dimItem.getNumber()));
                DynamicObjectCollection dyn = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"srcmembnumber,targmembnumber,targmembid", (QFilter[])qfb.toArray());
                member = ((DynamicObject)dyn.stream().findFirst().get()).getString("targmembnumber");
            }
        }
        return member;
    }

    private Map<String, Object> getRowAndColDim(TemplateModel tmplModel, String position) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isFloat = TemplateTypeEnum.DYNA.getType() == tmplModel.getTemplateType().intValue();
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tmplModel.getRptData());
        Point cellPoint = ExcelUtils.pos2Point((String)position);
        Cell cell = sm.getBook().getSheet(0).getCell(cellPoint.y, cellPoint.x);
        Object keyDimFlag = cell.getUserObject("KEY_DIM_FLAG");
        if (!isFloat) {
            if (keyDimFlag != null) {
                ((List)keyDimFlag).forEach(mem -> map.put(mem.getDimension().getNumber(), mem.getNumber()));
            }
        } else {
            int direct = 0;
            int fixIndex = 0;
            boolean isDataArea = false;
            BasePointInfo hitBasePoint = null;
            for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
                isDataArea = ExcelUtils.isWithInScope((String)e.getAreaRange(), (String)cellPoint.toString());
                if (!isDataArea) continue;
                List basePoints = e.getBasePoints();
                if (ObjectUtils.isEmpty((Object)basePoints)) break;
                direct = ((BasePointInfo)basePoints.get(0)).getDirect();
                for (BasePointInfo basePoint : basePoints) {
                    RangeModel b = new RangeModel(basePoint.getDynaRange());
                    if (direct == 2 && b.getY_start() <= cellPoint.y && cellPoint.y <= b.getY_end()) {
                        hitBasePoint = basePoint;
                        fixIndex = cell.getCol() - ExcelUtils.pos2X((String)e.getAreaRange().split(":")[0]);
                        continue;
                    }
                    if (direct != 1 || b.getX_start() > cellPoint.x || cellPoint.x > b.getX_end()) continue;
                    hitBasePoint = basePoint;
                    fixIndex = cell.getRow() - ExcelUtils.pos2Y((String)e.getAreaRange().split(":")[0]);
                }
            }
            if (isDataArea && hitBasePoint != null) {
                ((List)hitBasePoint.getFixMemberPosition().get(fixIndex)).forEach(dim -> map.put(dim.getDimension().getNumber(), dim.getNumber()));
                List lines = hitBasePoint.getBasePointInnerLineInfo();
                HashMap floatDimension = new HashMap();
                lines.forEach(line -> {
                    if (line.isFloated()) {
                        Object numbers = this.getDynaMembScopesMembersMemLimit(line.getDynaMembScopes(), tmplModel.getModelId());
                        floatDimension.put(line.getDimension().getNumber() + "!" + line.getOffset(), numbers);
                    } else {
                        line.getDynaMembScopes().forEach(scope -> map.put(line.getDimension().getNumber(), scope.getMember().getNumber()));
                    }
                });
                map.put(FLOATDIMENSION, floatDimension);
            } else if (isDataArea && keyDimFlag != null) {
                List members = (List)keyDimFlag;
                members.forEach(mem -> map.put(mem.getDimension().getNumber(), mem.getNumber()));
            }
        }
        return map;
    }

    private Set<String> getDynaMembScopesMembers(List<DynaMembScopeInfo> list, Object modelId) {
        HashSet<String> numbers = new HashSet<String>();
        for (DynaMembScopeInfo scInfo : list) {
            new MembRangeItem(scInfo.getMember().getDimension().getUqCode(), Long.valueOf(scInfo.getMember().getId()), scInfo.getMember().getNumber(), scInfo.getRangeId(), scInfo.isCustom(), modelId).matchItems(c -> numbers.add(c.number));
        }
        return numbers;
    }

    private Object getDynaMembScopesMembersMemLimit(List<DynaMembScopeInfo> list, Object modelId) {
        HashSet numbers = new HashSet(16);
        ArrayList<Set> numbersList = new ArrayList<Set>(16);
        String uqCode = null;
        for (DynaMembScopeInfo scInfo : list) {
            uqCode = scInfo.getMember().getDimension().getUqCode();
            if ("bcm_icmembertree".equals(uqCode)) {
                IDNumberTreeNode member = MemberReader.findMemberById((long)((Long)modelId), (String)uqCode, (Long)scInfo.getMember().getId());
                MembBaseItem mbi = new MembBaseItem(uqCode, Long.valueOf(scInfo.getMember().getId()), member.getLongNumber(), scInfo.getMember().getNumber(), scInfo.getRangeId(), scInfo.isCustom(), modelId);
                Set membersUnmodifiable = mbi.matchItem4UnmodifiableSet();
                if (membersUnmodifiable == null) continue;
                numbersList.add(membersUnmodifiable);
                continue;
            }
            new MembRangeItem(uqCode, Long.valueOf(scInfo.getMember().getId()), scInfo.getMember().getNumber(), scInfo.getRangeId(), scInfo.isCustom(), modelId).matchItems(c -> numbers.add(c.number));
        }
        if ("bcm_icmembertree".equals(uqCode)) {
            return numbersList;
        }
        return numbers;
    }

    private MDResultSet queryOlap(String modelNum, Map<String, Set<String>> dataFilter, List<String> dimensions) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(dimensions.toArray(new String[0]));
        dataFilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        if (!dataFilter.containsKey("InternalCompany")) {
            ISqlLazyFilter & Serializable filter = (ISqlLazyFilter & Serializable)member -> true;
            sql.addLazyFilter("InternalCompany", (ISqlLazyFilter)filter);
        }
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private boolean checkDynaRecordExists(Map<String, Object> row) {
        String hashStr;
        boolean isExists;
        if (this.dynaRowExistsFilter == null) {
            this.dynaRowExistsFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)1000000, (double)0.001f);
        }
        if (!(isExists = this.dynaRowExistsFilter.mightContain((Object)(hashStr = "" + row.get("fcompany") + row.get("fcurrency") + row.get("frptitem") + row.get("fyear") + row.get("fperiod") + row.get("fperiodtype") + row.get("frptsrctype") + row.get("fdataelement") + row.get("fisInterexch") + row.get("fdynaitemkey") + row.get("fdynaitemname") + row.get("fdatatype") + row.get("fownnumber") + row.get("fownname") + row.get("ftext") + row.get("famount"))))) {
            this.dynaRowExistsFilter.put((Object)hashStr);
        }
        return isExists;
    }

    public List<Map<String, Object>> executeExtend(PushRpt2EasContext ctx) {
        Map<String, Object> filter = this.getDataFilterAndCellFilterExtend(ctx);
        try {
            Pair<String, String> filter4Log = this.buildLogFilter(filter);
            log.info("PushRpt2EasService-cellFilter:" + (String)filter4Log.p1);
            log.info("PushRpt2EasService-dataFilter:" + (String)filter4Log.p2);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        List<Map<String, DataSet>> resSet = this.queryExtend(ctx, (Map)filter.get(DATAFILTER), ctx.getDimensions(), (Map)filter.get(DIMFILTER));
        this.singleMapModel = new SingleMapModel(ctx.getInteCtx());
        return this.buildTableDataExtend(ctx, resSet, (Map)filter.get(CELLFILTER));
    }

    private List<Map<String, Object>> buildTableDataExtend(PushRpt2EasContext ctx, List<Map<String, DataSet>> resSet, Map<String, Map<String, Set<String>>> cellsFilter) {
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>(10);
        Pair<Map<String, String>, Map<String, String>> fieldPair = this.getFieldMapped((Long)ctx.getModel().p1);
        for (Map<String, DataSet> dataMap : resSet) {
            String key = (String)dataMap.keySet().stream().findFirst().get();
            DataSet data = dataMap.get(key);
            RowMeta rowMeta = data.getRowMeta();
            Set<String> rowKey = this.getRowKey(rowMeta);
            HashMap<String, Integer> dynKeyMap = new HashMap<String, Integer>(16);
            String[] keyArr = key.split(":");
            while (data.hasNext()) {
                Row algoRow = data.next();
                for (Map.Entry<String, Map<String, String>> map : ctx.getCellParams().entrySet()) {
                    Map<String, Set<String>> cellFilter = cellsFilter.get(map.getKey());
                    if (ObjectUtils.isEmpty(cellFilter) || !this.matchExtend(cellFilter, algoRow, rowKey, keyArr[0], (Map)fieldPair.p1)) continue;
                    this.packDynRptRowInfoExtend(table, cellFilter, algoRow, ctx, map.getValue(), fieldPair, rowKey, dynKeyMap, keyArr[1]);
                }
            }
        }
        return table;
    }

    private Pair<Map<String, String>, Map<String, String>> getFieldMapped(Long modelId) {
        DynamicObjectCollection extModel = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,fieldmapped, datatype,enumitem.datatype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        DynamicObjectCollection userDefined = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,fieldmapped", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("issysdimension", "=", (Object)"0")});
        HashMap<String, String> fieldMapped = new HashMap<String, String>(16);
        HashMap<String, String> fieldType = new HashMap<String, String>(16);
        for (DynamicObject object : extModel) {
            fieldMapped.put(object.getString("number"), object.getString("fieldmapped"));
            if (DataTypeEnum.ENUMTP.getCode() == Integer.parseInt(object.getString("datatype"))) {
                fieldType.put(object.getString("number"), object.getString("enumitem.datatype"));
                continue;
            }
            fieldType.put(object.getString("number"), object.getString("datatype"));
        }
        for (DynamicObject object : userDefined) {
            fieldMapped.put(object.getString("number"), object.getString("fieldmapped"));
        }
        return Pair.onePair(fieldMapped, fieldType);
    }

    private void packDynRptRowInfoExtend(List<Map<String, Object>> table, Map<String, Set<String>> cellFilter, Row r, PushRpt2EasContext ctx, Map<String, String> cellParam, Pair<Map<String, String>, Map<String, String>> fieldPair, Set<String> rowKey, Map<String, Integer> dynKeyMap, String firstCol) {
        HashMap<String, Object> row = new HashMap<String, Object>(20);
        this.packRowCommonInfoExtend(row, r, ctx, cellParam, rowKey);
        Map fieldMapped = (Map)fieldPair.p1;
        Map fieldType = (Map)fieldPair.p2;
        List<String> dimensions = ctx.getDimensions();
        String col = (String)cellFilter.get("extCol").stream().findFirst().get();
        Object o = null;
        o = rowKey.contains(col.toLowerCase()) ? r.get(col) : r.get((String)fieldMapped.get(col));
        if (fieldType.containsKey(col) && !dimensions.contains(col)) {
            int type = Integer.parseInt((String)fieldType.get(col));
            if (DataTypeEnum.DEFAULT.getCode() == type || DataTypeEnum.CURRENCY.getCode() == type || DataTypeEnum.UNCURRENCY.getCode() == type) {
                row.put("fdatatype", 1);
                BigDecimal res = new BigDecimal(o == null ? "0" : o.toString());
                row.put("ftext", null);
                row.put("famount", new BigDecimal(res.stripTrailingZeros().toPlainString()));
            } else if (DataTypeEnum.DATETP.getCode() == type) {
                row.put("fdatatype", 3);
                String txt = o == null ? "" : DateTimeUtils.format((Date)((Date)o), (String)"yyyy-MM-dd");
                row.put("ftext", txt);
                row.put("famount", null);
            } else if (DataTypeEnum.TXT.getCode() == type || DataTypeEnum.PROPORTION.getCode() == type) {
                row.put("fdatatype", 3);
                row.put("ftext", o == null ? "" : o.toString());
                row.put("famount", null);
            }
        } else {
            row.put("fdatatype", 3);
            String isNum = String.valueOf(cellParam.get("isNum"));
            if ("2".equals(isNum) && dimensions.contains(col)) {
                boolean hasNotMembMapped2Eas;
                boolean bl = hasNotMembMapped2Eas = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(col)).getSourceDimItem() == null;
                if (!hasNotMembMapped2Eas) {
                    this.singleMapModel.buildTar(ctx.getDimsMap().get(col).longValue());
                }
                String floatMembName = this.getDynamicName(ctx, col, o.toString(), hasNotMembMapped2Eas, null);
                row.put("ftext", floatMembName);
            } else {
                row.put("ftext", o == null ? "" : o.toString());
            }
            row.put("famount", null);
        }
        String floatItemDim = firstCol;
        if (ctx.isInterExch() && rowKey.contains(DimEntityNumEnum.INTERCOMPANY.getNumber().toLowerCase())) {
            floatItemDim = DimEntityNumEnum.INTERCOMPANY.getNumber();
        }
        if (dimensions.contains(floatItemDim)) {
            boolean hasNotMembMapped2Eas;
            boolean bl = hasNotMembMapped2Eas = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(floatItemDim)).getSourceDimItem() == null;
            if (!hasNotMembMapped2Eas) {
                this.singleMapModel.buildTar(ctx.getDimsMap().get(floatItemDim).longValue());
            }
            String membNum = "";
            membNum = rowKey.contains(floatItemDim.toLowerCase()) ? r.getString(floatItemDim.toLowerCase()) : r.getString((String)fieldMapped.get(floatItemDim));
            String targMembNam = this.getDynamicName(ctx, floatItemDim, membNum, hasNotMembMapped2Eas, null);
            String seq = this.getSeqExtend(dynKeyMap, membNum, cellParam.get("ri") + cellParam.get("de"), floatItemDim);
            targMembNam = targMembNam + seq;
            row.put("fdynaitemkey", StringUtils.isEmpty((String)seq) ? membNum : targMembNam);
            row.put("fdynaitemname", targMembNam);
        } else {
            String membNum = r.getString((String)fieldMapped.get(floatItemDim));
            String seq = this.getSeqExtend(dynKeyMap, membNum, cellParam.get("ri") + cellParam.get("de"), floatItemDim);
            membNum = membNum + seq;
            row.put("fdynaitemkey", membNum);
            row.put("fdynaitemname", membNum);
        }
        table.add(row);
    }

    private String getSeqExtend(Map<String, Integer> dynKeyMap, String membNum, String ri, String floatItemDim) {
        if (DimEntityNumEnum.ACCOUNT.getNumber().equals(floatItemDim)) {
            return "";
        }
        String dynKey = membNum + ri;
        Integer seq = dynKeyMap.get(dynKey);
        if (seq == null) {
            dynKeyMap.put(dynKey, 1);
            return "";
        }
        dynKeyMap.put(dynKey, seq + 1);
        return "@" + seq;
    }

    private void packRowCommonInfoExtend(Map<String, Object> row, Row r, PushRpt2EasContext ctx, Map<String, String> cellParam, Set<String> rowKey) {
        boolean needMyCompany;
        row.put("headpk", GlobalIdUtil.genStringId());
        row.put("fcompany", ctx.getEntityMapping().values().stream().findFirst().get());
        row.put("fcurrency", ctx.getTarCurrencyNumbers().get(0));
        row.put("frptitem", cellParam.get("ri"));
        row.put("fdataelement", cellParam.get("de"));
        row.put("fyear", ctx.getTarYear());
        row.put("fperiod", ctx.getTarPeriod());
        row.put("fperiodtype", PeriodTypeEnum.getEnum((String)ctx.getTarPeriodType()).getValue());
        row.put("frptsrctype", RptSrcTypeEnum.getEnum((String)ctx.getTarRptType()).getValue());
        row.put("fisInterexch", ctx.isInterExch() ? 1 : 0);
        boolean bl = needMyCompany = ctx.isInterExch() && ctx.isContainMyCompany();
        if (needMyCompany && rowKey.contains(PresetConstant.MYCOMPANY_DIM.toLowerCase())) {
            boolean hasNotMembMapped2Eas = ctx.getInteCtx().getMappedRelation().getSingeDimRelationByDimId((Object)ctx.getDimsMap().get(PresetConstant.MYCOMPANY_DIM)).getSourceDimItem() == null;
            String myNum = r.getString(PresetConstant.MYCOMPANY_DIM);
            row.put("fownnumber", myNum);
            row.put("fownname", this.getDynamicName(ctx, PresetConstant.MYCOMPANY_DIM, myNum, hasNotMembMapped2Eas, null));
        }
    }

    private Set<String> getRowKey(RowMeta rowMeta) {
        HashSet<String> keySet = new HashSet<String>(16);
        for (String key : rowMeta.getFieldNames()) {
            keySet.add(key);
        }
        return keySet;
    }

    private boolean matchExtend(Map<String, Set<String>> cellFilter, Row algoRow, Set<String> rowKey, String key, Map<String, String> mappingKey) {
        for (Map.Entry<String, Set<String>> map : cellFilter.entrySet()) {
            if (!key.equals(cellFilter.get("extModelNumber").stream().findFirst().get())) {
                return false;
            }
            if (rowKey.contains(map.getKey().toLowerCase()) && !map.getValue().contains("*") && !map.getValue().contains(algoRow.get(map.getKey().toLowerCase()))) {
                return false;
            }
            if (!rowKey.contains(mappingKey.get(map.getKey())) || map.getValue().contains("*") || map.getValue().contains(algoRow.get(mappingKey.get(map.getKey())))) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> getDataFilterAndCellFilterExtend(PushRpt2EasContext ctx) {
        HashMap<String, Object> filter = new HashMap<String, Object>(3);
        List<TemplateModel> templateModels = ctx.getTemplateModels();
        TemplateModel tmplModel = templateModels.get(0);
        if (!tmplModel.isSaveByDim()) {
            return filter;
        }
        HashMap<String, HashMap<String, Set<String>>> cellsFilter = new HashMap<String, HashMap<String, Set<String>>>(16);
        HashMap<String, Set<String>> dataFilter = new HashMap<String, Set<String>>(16);
        Map<String, Object> dimFilter = this.getFilterView(ctx);
        for (Map<String, String> m : ctx.getTarIndexParams()) {
            Map<String, Object> rowAndColMap = this.getRowAndColDimExtend(tmplModel, m.get(CELLPOSITION), (Long)ctx.getModel().p1);
            HashMap<String, Set<String>> allFilter = new HashMap<String, Set<String>>(16);
            if (rowAndColMap.size() <= 0) continue;
            dimFilter.forEach((k, v) -> {
                Set<String> set = new HashSet<String>(2);
                if (v instanceof Set) {
                    set = (Set)v;
                } else {
                    set.add((String)v);
                }
                allFilter.put((String)k, set);
            });
            rowAndColMap.forEach((k, v) -> {
                Set<String> set = new HashSet<String>(2);
                if (v instanceof Set) {
                    set = (Set)v;
                } else {
                    set.add((String)v);
                }
                allFilter.put((String)k, set);
            });
            cellsFilter.put(m.get(CELLPOSITION), allFilter);
            this.setDataFilterExtend(allFilter, dataFilter);
        }
        if (cellsFilter.size() <= 0 || dataFilter.size() <= 0) {
            log.info("PushRpt2EasService.getDataFilterAndCellFilter.cellsFilter is empty.");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u533a\u57df\u6570\u636e\u9700\u8981\u8fd4\u56de\uff0c\u8bf7\u68c0\u67e5\u5355\u5143\u683c\u6620\u5c04\u3002", (String)"PushRpt2EasServiceHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        filter.put(CELLFILTER, cellsFilter);
        filter.put(DATAFILTER, dataFilter);
        filter.put(DIMFILTER, dimFilter);
        return filter;
    }

    private Map<String, Object> getRowAndColDimExtend(TemplateModel tmplModel, String position, Long modelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tmplModel.getRptData());
        Point cellPoint = ExcelUtils.pos2Point((String)position);
        this.getExtendCol(map, sm, cellPoint, modelId);
        return map;
    }

    private void getExtendCol(Map<String, Object> map, SpreadManager sm, Point cellPoint, Long modelId) {
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            Point cellEnd;
            String areaRange;
            String[] areaRangeArr;
            Point cellStart;
            ExtendInfo extendInfo = e.getExtendInfo();
            if (extendInfo == null || !this.includeCell(cellPoint, cellStart = ExcelUtils.pos2Point((String)(areaRangeArr = (areaRange = e.getAreaRange()).split(":"))[0]), cellEnd = ExcelUtils.pos2Point((String)areaRangeArr[1]))) continue;
            this.setMap(map, extendInfo, cellPoint.x - cellStart.x, modelId);
        }
    }

    private void setMap(Map<String, Object> map, ExtendInfo extendInfo, int index, Long modelId) {
        map.put("extModelNumber", extendInfo.getExtModelNumber());
        map.put("extGroup", extendInfo.getExtGroup());
        List cols = extendInfo.getCols(true);
        map.put("extCol", cols.get(index));
        map.put("firstCol", cols.get(0));
        List floatdims = extendInfo.getFloatdims();
        for (FloatDimInfo fdi : floatdims) {
            String number = fdi.getDimension().getNumber();
            HashSet<String> numberSet = new HashSet<String>(16);
            if (fdi.getDynaMembScopes().size() > 0) {
                for (DynaMembScopeInfo dmsi : fdi.getDynaMembScopes()) {
                    MembRangeItem rangItem = new MembRangeItem(fdi.getDimension().getUqCode(), Long.valueOf(dmsi.getMember().getId()), dmsi.getMember().getNumber(), RangeEnum.getRangeByVal((int)dmsi.getRangeId()), dmsi.isCustom(), (Object)modelId);
                    rangItem.matchItems(c -> numberSet.add(c.getNumber()));
                }
            } else if (fdi.getMember() != null) {
                numberSet.add(fdi.getMember().getNumber());
            }
            if (numberSet.size() == 0) {
                numberSet.add("*");
            }
            map.put(number, numberSet);
        }
    }

    private boolean includeCell(Point cellPoint, Point cellStart, Point cellEnd) {
        return cellPoint.x >= cellStart.x && cellPoint.y >= cellStart.y && cellPoint.x <= cellEnd.x && cellPoint.y <= cellEnd.y;
    }

    private void setDataFilterExtend(Map<String, Set<String>> allFilter, Map<String, Set<String>> dataFilter) {
        String extModelNumber = (String)allFilter.get("extModelNumber").stream().findAny().get();
        String extGroup = (String)allFilter.get("extGroup").stream().findAny().get();
        String firstCol = (String)allFilter.get("firstCol").stream().findAny().get();
        String extCol = (String)allFilter.get("extCol").stream().findAny().get();
        Set extColSet = dataFilter.computeIfAbsent(extModelNumber + ":" + extGroup + ":" + firstCol, e -> new HashSet());
        extColSet.add(extCol);
    }

    private List<Map<String, DataSet>> queryExtend(PushRpt2EasContext ctx, Map<String, Set<String>> dataFilter, List<String> dimensions, Map<String, Object> dimFilter) {
        String modelSNumber = MemberReader.findModelSNumberById((Object)ctx.getModel().p1);
        ArrayList<Map<String, DataSet>> resList = new ArrayList<Map<String, DataSet>>(16);
        HashMap<String, DataSet> resMap = null;
        for (Map.Entry<String, Set<String>> map : dataFilter.entrySet()) {
            EdQueryComInfo eqi = this.BuildComInfo(modelSNumber, map.getKey(), map.getValue(), dimensions, ctx, dimFilter);
            try {
                log.info("PushRpt2EasService-queryExtend \uff1a" + this.getEqiToString(eqi));
            }
            catch (Exception e) {
                log.error("PushRpt2EasService condition error", (Throwable)e);
            }
            resMap = new HashMap<String, DataSet>(16);
            String[] keyArr = map.getKey().split(":");
            resMap.put(keyArr[0] + ":" + keyArr[2], ExtDataServiceHelper.queryDataset((EdQueryComInfo)eqi));
            resList.add(resMap);
        }
        return resList;
    }

    private String getEqiToString(EdQueryComInfo eqi) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(eqi.getModelNum()).append(":");
        sb.append(eqi.getExtGroup()).append(":");
        sb.append(JSONObject.toJSONString((Object)eqi.getDimFilter())).append(":");
        return sb.toString();
    }

    private EdQueryComInfo BuildComInfo(String modelSNumber, String key, Set<String> value, List<String> dimensions, PushRpt2EasContext ctx, Map<String, Object> dimFilter) {
        String[] keyArr = key.split(":");
        EdQueryComInfo eqi = new EdQueryComInfo(modelSNumber, keyArr[1], keyArr[0]);
        Pair<String[], String[]> filedPair = this.getFiledPair(ctx, keyArr[0], dimensions, value, keyArr[2]);
        eqi.setDimselects((String[])filedPair.p1);
        eqi.setExtselects((String[])filedPair.p2);
        eqi.addDimFilter(DimEntityNumEnum.ENTITY.getNumber(), new String[]{(String)ctx.getEntityMapping().keySet().stream().findFirst().get()});
        eqi.addDimFilter(DimEntityNumEnum.YEAR.getNumber(), new String[]{(String)ctx.getYear().p2});
        eqi.addDimFilter(DimEntityNumEnum.PERIOD.getNumber(), new String[]{(String)ctx.getPeriod().p2});
        eqi.addDimFilter(DimEntityNumEnum.CURRENCY.getNumber(), new String[]{(String)ctx.getCurrency().p2});
        eqi.addDimFilter(DimEntityNumEnum.SCENARIO.getNumber(), new String[]{(String)ctx.getScene().p2});
        eqi.addDimFilter(DimEntityNumEnum.PROCESS.getNumber(), new String[]{(String)dimFilter.get(DimEntityNumEnum.PROCESS.getNumber())});
        eqi.addDimFilter(DimEntityNumEnum.AUDITTRIAL.getNumber(), new String[]{(String)dimFilter.get(DimEntityNumEnum.AUDITTRIAL.getNumber())});
        return eqi;
    }

    private Pair<String[], String[]> getFiledPair(PushRpt2EasContext ctx, String extNumber, List<String> dimensions, Set<String> fieldSet, String firstCol) {
        Long modelId = (Long)ctx.getModel().p1;
        List<Object> extselectsList = new ArrayList<String>();
        List<Object> dimselectsList = new ArrayList<String>();
        fieldSet.add(firstCol);
        for (String field : fieldSet) {
            if (dimensions.contains(field)) {
                dimselectsList.add(field);
                continue;
            }
            extselectsList.add(field);
        }
        Set<String> extDimSet = this.getExtDimSet(modelId, extNumber);
        dimselectsList.addAll(extDimSet);
        dimselectsList = dimselectsList.stream().distinct().collect(Collectors.toList());
        extselectsList = extselectsList.stream().distinct().collect(Collectors.toList());
        return Pair.onePair((Object)dimselectsList.toArray(new String[0]), (Object)extselectsList.toArray(new String[0]));
    }

    private Set<String> getExtDimSet(Long modelId, String extNumber) {
        HashSet<String> extDimSet = new HashSet<String>(16);
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)extNumber).add("model.id", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id", (QFilter[])qfBuilder.toArray());
        ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(((DynamicObject)query.get(0)).getLong("id")));
        extendsModel.getDimFieldEntry().stream().forEach(e -> extDimSet.add(e.getDimension().getNumber()));
        return extDimSet;
    }

    protected static class SquenceCounter {
        private int sequence = 0;

        protected SquenceCounter() {
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }
    }
}

