/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

abstract class BCMImportDataHandle {
    protected IFormView formView;
    protected IDataModel dataModel;
    protected JSONArray excelData;
    protected Map<String, Map<String, Object>> dataCache = new HashMap<String, Map<String, Object>>();
    protected Map<String, Object> custom = new HashMap<String, Object>();
    protected static final Log logger = LogFactory.getLog(BCMImportDataHandle.class);

    public BCMImportDataHandle(IFormView formView, IDataModel dataModel, JSONArray excelData, Map<String, Object> custom) {
        this(formView, dataModel, excelData);
        this.custom = custom;
    }

    public BCMImportDataHandle(IFormView formView, IDataModel dataModel, JSONArray excelData) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.excelData = excelData;
    }

    public void handle() {
        if (this.validate()) {
            try (TraceSpan span = Tracer.create((String)"BCM", (String)"kd.fi.bcm.formplugin.intergration.scheme.BCMImportDataHandle.handle");){
                span.addTag("key", this.getClass().getName());
                this.preData();
                long start = span.getCost();
                logger.info("load data speed " + start);
                this.dataModel.beginInit();
                this.fillData();
                this.dataModel.endInit();
                long end = span.getCost();
                logger.info("load data speed " + (end - start));
            }
        }
    }

    protected abstract boolean validate();

    protected abstract void fillData();

    protected abstract void preData();
}

