/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class BDConfigPlugin
extends AbstractBaseFormPlugin
implements CellClickListener,
IOperationLog {
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISENABLE = "btn_disenable";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_SAVE = "btn_save";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ADD_JOIN = "addJoin";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        EntryGrid eg = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        eg.addCellClickListener((CellClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean havePer = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"bcm_dimensionmanager", (String)"3E7+2X6S09FC");
        if (!havePer) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6b64\u9875\u9762\u64cd\u4f5c\u6743\u9650\u3002", (String)"SetMappingListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ENABLE, BTN_DISENABLE, BTN_SAVE, "btn_add", "btn_delete", BTN_REFRESH});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_delete", "btn_add"});
        DynamicObjectCollection bdData = this.queryBDConfig();
        this.fillBDData(bdData);
    }

    public void cellClick(CellClickEvent e) {
        super.click((EventObject)e);
        this.initItemBind(e);
    }

    private void initItemBind(CellClickEvent e) {
        if (!"fieldnumber".equals(e.getFieldKey()) && !"fieldname".equals(e.getFieldKey())) {
            return;
        }
        int rowIndex = e.getRow();
        if (rowIndex < 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection objs = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject dyn = (DynamicObject)objs.get(rowIndex);
        String entityNumber = dyn.getString("number");
        if (entityNumber == null) {
            return;
        }
        List<String> comList = this.setMetaData(entityNumber);
        FormShowParameter bs = new FormShowParameter();
        bs.setFormId("bcm_selectbdconfig");
        bs.setCustomParam("comboItems", comList);
        bs.setCustomParam("rowIndex", (Object)rowIndex);
        bs.setCustomParam("key", (Object)e.getFieldKey());
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_JOIN));
        this.getView().showForm(bs);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "addJoin": {
                this.addJoin(evt);
                break;
            }
        }
    }

    private void addJoin(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (map.get("key") == null || map.get("cancel") != null) {
            return;
        }
        this.getModel().setValue(map.get("key").toString(), map.get("joinfield"));
    }

    private void fillBDData(DynamicObjectCollection bdData) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        entryEntity.clear();
        for (DynamicObject bdDatum : bdData) {
            DynamicObject addNew = entryEntity.addNew();
            addNew.set("id", (Object)bdDatum.getString("id"));
            addNew.set("number", (Object)bdDatum.getString("number"));
            addNew.set("name", (Object)bdDatum.getString("name"));
            addNew.set("fieldid", (Object)(StringUtil.isEmptyString((String)bdDatum.getString("fieldid")) ? "id" : bdDatum.getString("fieldid")));
            addNew.set("fieldnumber", (Object)(StringUtil.isEmptyString((String)bdDatum.getString("fieldnumber")) ? "number" : bdDatum.getString("fieldnumber")));
            addNew.set("fieldname", (Object)(StringUtil.isEmptyString((String)bdDatum.getString("fieldname")) ? "name" : bdDatum.getString("fieldname")));
            addNew.set("belongcloud", (Object)bdDatum.getString("belongcloud"));
            addNew.set("belongapp", (Object)bdDatum.getString("belongapp"));
            addNew.set("source", (Object)bdDatum.getString("source"));
            addNew.set("issys", (Object)bdDatum.getString("issys"));
            addNew.set("enable", (Object)bdDatum.getString("enable"));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public DynamicObjectCollection queryBDConfig() {
        QFBuilder filter = new QFBuilder("1", "=", (Object)1);
        DynamicObjectCollection bdData = QueryServiceHelper.query((String)"bcm_bdconfig", (String)"id,number,name,source,fieldid,fieldnumber,fieldname,belongcloud,belongapp,creator,createtime,modifier,modifiedtime,issys,enable", (QFilter[])filter.toArray());
        return bdData;
    }

    private List<String> setMetaData(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String idByNumber = MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        List items = taskMeta.getItems();
        ArrayList<String> comList = new ArrayList<String>(16);
        for (ControlAp controlAp : items) {
            if (!(controlAp instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)controlAp;
            String comStr = fieldAp.getKey() + ";" + fieldAp.getName().getLocaleValue();
            comList.add(comStr);
        }
        return comList;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = grid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Long> ids = new ArrayList<Long>(rows.length);
        for (int row : rows) {
            ids.add(Long.parseLong(String.valueOf(((DynamicObject)entryEntity.get(row)).getString("id"))));
        }
        switch (itemKey) {
            case "btn_enable": 
            case "btn_disenable": {
                if (rows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ISSchemeSheetMappingListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String status = BTN_ENABLE.equals(itemKey) ? "1" : "0";
                this.changeCanEnable(status, ids);
                this.changeEnable(status, ids);
                this.refreshEntity();
                break;
            }
            case "btn_save": {
                this.saveBDData();
                this.refreshEntity();
                break;
            }
            case "btn_refresh": {
                this.refreshEntity();
                break;
            }
        }
    }

    private void changeCanEnable(String status, List<Long> ids) {
        QFilter filters;
        DynamicObjectCollection query;
        if ("0".equals(status) && (query = QueryServiceHelper.query((String)"bcm_bdmapping", (String)"number,entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])(filters = new QFilter("entryentity.config.id", "in", ids)).toArray())) != null && query.size() > 0) {
            StringBuilder sb = new StringBuilder(16);
            sb.append("[");
            for (DynamicObject obj : query) {
                sb.append(obj.getString("number")).append(";");
            }
            sb.append("]");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u88ab%1$s\u5f15\u7528\uff0c\u4e0d\u80fd\u5931\u6548\u3002", (String)"BDConfigPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString()));
        }
    }

    private void saveBDData() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        HashMap<Long, Tuple> saveDate = new HashMap<Long, Tuple>(8);
        for (DynamicObject dyn : entryEntity) {
            String id = null;
            String number = null;
            String name = null;
            if (dyn.getString("fieldid") != null) {
                id = dyn.getString("fieldid");
            }
            if (dyn.getString("fieldnumber") != null) {
                number = dyn.getString("fieldnumber");
            }
            if (dyn.getString("fieldname") != null) {
                name = dyn.getString("fieldname");
            }
            if (!StringUtils.isNotEmpty((String)id) && !StringUtils.isNotEmpty((String)number) && !StringUtils.isNotEmpty((String)name)) continue;
            saveDate.put(dyn.getLong("id"), Tuple.create((Object)id, (Object)number, (Object)name));
        }
        if (saveDate.size() > 0) {
            Set ids = saveDate.keySet();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("id", "in", ids);
            DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_bdconfig", (String)"id,fieldid,fieldnumber,fieldname,modifier,modifiedtime", (QFilter[])qfBuilder.toArray());
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(dos));
            for (DynamicObject dy : dynamicObjectList) {
                Tuple tuple = (Tuple)saveDate.get(dy.getLong("id"));
                if (StringUtils.isNotEmpty((String)((String)tuple.p1))) {
                    dy.set("fieldid", tuple.p1);
                }
                if (StringUtils.isNotEmpty((String)((String)tuple.p2))) {
                    dy.set("fieldnumber", tuple.p2);
                }
                if (StringUtils.isNotEmpty((String)((String)tuple.p3))) {
                    dy.set("fieldname", tuple.p3);
                }
                dy.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                dy.set("modifiedtime", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])dos);
            if (dos.length > 0) {
                this.getView().showSuccessNotification(this.getSaveNotification());
            }
        }
        this.writeOperationLog(BDConfigPlugin.getOperationSave(), "", ResManager.loadKDString((String)"\u5217\u8868", (String)"ISSchemeEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getOperationStstusSuccess());
    }

    private void refreshEntity() {
        DynamicObjectCollection bdData = this.queryBDConfig();
        this.fillBDData(bdData);
    }

    private void changeEnable(String status, List<Long> ids) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", ids);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_bdconfig", (String)"id,number,name,enable,modifier,modifiedtime", (QFilter[])qfBuilder.toArray());
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(Arrays.asList(dos));
        for (DynamicObject dy : dynamicObjectList) {
            dy.set("enable", (Object)status);
            dy.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dy.set("modifiedtime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.save((DynamicObject[])dos);
        for (DynamicObject dy : dos) {
            this.writeOperationLog("0".equals(status) ? this.getOperationDisable() : this.getOperationEnable(), "", dy.getString("name"), this.getOperationStstusSuccess());
        }
        if (dos.length > 0) {
            this.getView().showSuccessNotification("0".equals(status) ? this.getEnableNotification() : this.getAbleNotification());
        }
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"ISSchemeSheetMappingListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public static OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "ISSchemeEditPlugin_0", "fi-bcm-formplugin", "Save");
    }

    private OpNameMultiLangEnumBridge getOperationEnable() {
        return new OpNameMultiLangEnumBridge("\u751f\u6548", "ISSchemeSheetMappingListPlugin_0", "fi-bcm-formplugin", "Enable");
    }

    private OpNameMultiLangEnumBridge getOperationDisable() {
        return new OpNameMultiLangEnumBridge("\u5931\u6548", "ISSchemeSheetMappingListPlugin_1", "fi-bcm-formplugin", "Disable");
    }

    private String getAbleNotification() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6240\u9009\u5143\u6570\u636e\u5df2\u751f\u6548\u3002", (String)"BDConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getEnableNotification() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6240\u9009\u5143\u6570\u636e\u5df2\u5931\u6548\u3002", (String)"BDConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getSaveNotification() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BDConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }
}

